<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Dashboard | The Housing Value Assessment Methodology </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="" />
    <meta content="Indev Consultancy Pvt. Ltd." name="author" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <link rel="shortcut icon" href="assets/images/fav.png">
    <link href="assets/css/app.min.css" id="app-stylesheet" rel="stylesheet" type="text/css" />
</head>

<body data-layout="horizontal" data-topbar="light">
    <div id="wrapper">
        <?php include("include/header.php"); ?>
        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="filter-form mb-3">
                                        <form method="get">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <select class="form-control" name="country">
                                                            <option value="">Select Country</option>
                                                            <option value="">India</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <select class="form-control" placeholder="" name="state">
                                                            <option value="">Select State</option>
                                                            <option value="">New Delhi</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <select class="form-control" placeholder="" name="district">
                                                            <option value="">Select District</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <select class="form-control" placeholder="" name="city" id="city">
                                                            <option value="">Select City</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <button type="submit" class="btn btn-primary width-md waves-effect waves-light" name="search">Search</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-2 col-md-6">
                            <a href="state_list.php">
                                <div class="card-box small-dash-box">
                                    <h4 class="header-title mt-0 mb-1">Country</h4>
                                    <div class="widget-inner">
                                        <div class="widget-icon dark-blue">
                                            <i class="fa fa-globe"></i>
                                        </div>
                                        <div class="widget-chart">
                                            <div class="widget-detail text-right">
                                                <h2 class="font-weight-normal mb-1"> 4 </h2>
                                                <p class="text-muted mb-1">Country</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <div class="col-xl-2 col-md-6">
                            <a href="district_list.php">
                                <div class="card-box small-dash-box">
                                    <h4 class="header-title mt-0 mb-1">States</h4>
                                    <div class="widget-inner">
                                        <div class="widget-icon skyblue float-left">
                                            <i class="fa fa-map-marker-alt"></i>
                                        </div>
                                        <div class="widget-chart">
                                            <div class="widget-detail text-right">
                                                <h2 class="font-weight-normal mb-1"> 7 </h2>
                                                <p class="text-muted mb-1">States</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <div class="col-xl-2 col-md-6">
                            <a href="farmer-list.php">
                                <div class="card-box small-dash-box">
                                    <h4 class="header-title mt-0 mb-1">Districts</h4>
                                    <div class="widget-inner">
                                        <div class="widget-icon dark-blue float-left">
                                            <img src="assets/images/farmer-color.png" class="img-fluid">
                                        </div>
                                        <div class="widget-chart">
                                            <div class="widget-detail text-right">
                                                <h2 class="font-weight-normal mb-1"> 12,456 </h2>
                                                <p class="text-muted mb-1">Districts</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <div class="col-xl-2 col-md-6">
                            <a href="supplier-list.php">
                                <div class="card-box small-dash-box">
                                    <h4 class="header-title mt-0 mb-1">Projects</h4>
                                    <div class="widget-inner">
                                        <div class="widget-icon orange float-left">
                                            <img src="assets/images/tp.png" class="img-fluid">
                                        </div>
                                        <div class="widget-chart">
                                            <div class="widget-detail text-right">
                                                <h2 class="font-weight-normal mb-1"> 32 </h2>
                                                <p class="text-muted mb-1">Registered</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <div class="col-xl-2 col-md-6">
                            <a href="#">
                                <div class="card-box small-dash-box">
                                    <h4 class="header-title mt-0 mb-1">Smart Bulidings</h4>
                                    <div class="widget-inner">
                                        <div class="widget-icon skyblue float-left">
                                        <i class="fa fa-building"></i>
                                        </div>
                                        <div class="widget-chart">
                                            <div class="widget-detail text-right">
                                                <h2 class="font-weight-normal mb-1"> 123 </h2>
                                                <p class="text-muted mb-1">Registered</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <div class="col-xl-2 col-md-6">
                            <a href="land_holding.php">
                                <div class="card-box small-dash-box">
                                    <h4 class="header-title mt-0 mb-1">Total Users</h4>
                                    <div class="widget-inner">
                                        <div class="widget-icon dark-blue float-left">
                                        <i class="fa fa-users"></i>
                                        </div>
                                        <div class="widget-chart">
                                            <div class="widget-detail text-right">
                                                <h2 class="font-weight-normal mb-1"> 12,300 </h2>
                                                <p class="text-muted mb-1">Registered</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-4">
                            <div class="card-box heading-design">
                                <h4 class="header-title mt-0 design-1">Resources and Circularity</h4>
                                <div class="widget-chart text-center" style="min-height:250px">
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4">
                            <div class="card-box heading-design">
                                <h4 class="header-title mt-0 design-1">Environmental Impact Analysis</h4>
                                <div class="widget-chart text-center" style="min-height:250px">
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4">
                            <div class="card-box heading-design">
                                <h4 class="header-title mt-0 design-1">Governance and Management</h4>
                                <div class="widget-chart text-center" style="min-height:250px">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-7">
                            <div class="card-box heading-design">
                                <h4 class="header-title mt-0 design-1">Map</h4>
                                <div class="widget-chart text-center" style="min-height:250px">
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-5">
                            <div class="card-box heading-design">
                                <h4 class="header-title mt-0 design-1">Water Savings</h4>
                                <div class="widget-chart text-center" style="min-height:250px">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include("include/footer.php"); ?>
        </div>
    </div>
    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/app.min.js"></script>
    <script src="assets/libs/select2/select2.full.min.js"></script>
    <script src="assets/libs/moment/moment.js"></script>
    <script src="assets/libs/multiselect/jquery.multi-select.js"></script>
    <script src="assets/libs/select2/select2.full.min.js"></script>
    <script src="assets/libs/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/libs/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script src="assets/libs/jquery-mask-plugin/jquery.mask.min.js"></script>
    <script src="assets/libs/dropify/dropify.min.js"></script>
    <script src="assets/js/custom.js"></script>
</body>

</html>