<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<title>Dashboard | MIS for JM Financial Foundation</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta content="" />
<meta content="Indev Consultancy Pvt. Ltd." name="author" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<link rel="shortcut icon" href="assets/images/fav.png">
<link href="assets/css/app.min.css" id="app-stylesheet" rel="stylesheet" type="text/css" />
<link href="assets/libs/magnific-popup/magnific-popup.css" rel="stylesheet" type="text/css" />
</head>
<body data-layout="horizontal" data-topbar="light">
<div id="wrapper">
<?php include("include/header.php");?>
<div class="content-page">
<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-sm-12">
<div class="row">
<div class="col-sm-12">
<div class="filter-form mt-2 mb-3">
<form method="get">
<div class="row">
<div class="col-md-2">
<div class="form-group">
<select class="form-control">
<option value="">Select State</option>
</select>
</div>
</div>
<div class="col-md-2">
<div class="form-group">
<select class="form-control" placeholder="" name="district_id">
<option value="">Select District</option>
</select>
</div>
</div>
<div class="col-md-2">
<div class="form-group">
<select class="form-control" placeholder="" name="district_id">
<option value="">Select Block</option>
</select>
</div>
</div>

<div class="col-md-2">
<div class="form-group">
<select class="form-control" placeholder="" name="village_id" id="village_id">
<option value="">Select Village</option>
</select>
</div>
</div>
<div class="col-md-3">
<div class="form-group">
<input type="text" class="input-daterange-datepicker form-control" name="from" placeholer="From"/>
</div>
</div>
<div class="col-md-1">
<button type="submit" class="btn btn-secondary waves-effect waves-light" name="search">Go</button>
</div>
</div>
</form>
</div>
</div>
</div>
</div>
</div>
<div class="row">
<div class="col-xl-2 col-md-6">
<a href="state_list.php">
<div class="card-box small-dash-box">
<h4 class="header-title mt-0 mb-1">Total States</h4>
<div class="widget-inner">
<div class="widget-icon dark-blue">
<i class="fa fa-globe"></i>
</div>
<div class="widget-chart">
<div class="widget-detail text-right">
<h2 class="font-weight-normal mb-1"> 1 </h2>
<p class="text-muted mb-1">Registered</p>
</div>
</div>
</div>
</div>
</a>
</div>
<div class="col-xl-2 col-md-6">
<a href="district_list.php">
<div class="card-box small-dash-box">
<h4 class="header-title mt-0 mb-1">Total Districts</h4>
<div class="widget-inner">
<div class="widget-icon skyblue float-left">
<i class="fa fa-city"></i>
</div>
<div class="widget-chart">
<div class="widget-detail text-right">
<h2 class="font-weight-normal mb-1"> 2 </h2>
<p class="text-muted mb-1">Registered</p>
</div>
</div>
</div>
</div>
</a>
</div>
<div class="col-xl-2 col-md-6">
<a href="farmer-list.php">
<div class="card-box small-dash-box">
<h4 class="header-title mt-0 mb-1">Total Villages</h4>
<div class="widget-inner">
<div class="widget-icon dark-blue float-left">
<i class="fa fa-vihara"></i>
</div>
<div class="widget-chart">
<div class="widget-detail text-right">
<h2 class="font-weight-normal mb-1">  6</h2>
<p class="text-muted mb-1">Registered</p>
</div>
</div>
</div>
</div>
</a>
</div>
<div class="col-xl-2 col-md-6">
<a href="supplier-list.php">
<div class="card-box small-dash-box">
<h4 class="header-title mt-0 mb-1">Total Doctors</h4>
<div class="widget-inner">
<div class="widget-icon orange float-left">
<i class="fa fa-stethoscope"></i>
</div>
<div class="widget-chart">
<div class="widget-detail text-right">
<h2 class="font-weight-normal mb-1"> 11 </h2>
<p class="text-muted mb-1">Registered</p>
</div>
</div>
</div>
</div>
</a>
</div>
<div class="col-xl-2 col-md-6">
<a href="#">
<div class="card-box small-dash-box">
<h4 class="header-title mt-0 mb-1">Total Patients</h4>
<div class="widget-inner">
<div class="widget-icon yellow float-left">
<i class="fa fa-h-square"></i>
</div>
<div class="widget-chart">
<div class="widget-detail text-right">
<h2 class="font-weight-normal mb-1"> 50 </h2>
<p class="text-muted mb-1">Registered</p>
</div>
</div>
</div>
</div>
</a>
</div>
<div class="col-xl-2 col-md-6">
<a href="land_holding.php">
<div class="card-box small-dash-box">
<h4 class="header-title mt-0 mb-1">Total Registration</h4>
<div class="widget-inner">
<div class="widget-icon red float-left">
<i class="fa fa-users"></i>
</div>
<div class="widget-chart">
<div class="widget-detail text-right">
<h2 class="font-weight-normal mb-1"> 17 </h2>
<p class="text-muted mb-1">Registered</p>
</div>
</div>
</div>
</div>
</a>
</div>
</div>
<div class="row">    
	<div class="col-xl-12">
    	<h4 class="text-primary mb-3">Coverage Snapshot</h4>
    </div>     
    <div class="col-xl-4">
        <div class="card-box heading-design">
            <h4 class="header-title mt-0 design-1">Gender Wise Patient's</h4>
            <div class="widget-chart text-center" style="min-height:330px" id="patient-gender-wise">
            	
            </div>
        </div>
    </div>
    <div class="col-xl-4">
        <div class="card-box heading-design">
            <h4 class="header-title mt-0 design-1">Age Wise Segregation</h4>
            <div class="widget-chart text-center" style="min-height:330px" id="age-wise-segregation">
            	
            </div>
        </div>
    </div>
    <div class="col-xl-4">
        <div class="card-box heading-design">
            <h4 class="header-title mt-0 design-1">Target</h4>
            <div class="widget-chart text-center" style="min-height:330px" id="target">
            	
            </div>
        </div>
    </div>
    
    <div class="col-xl-12">
    	<h4 class="text-primary mb-3">Month's Wise Patient's</h4>
    </div> 
    
    
     <div class="col-xl-12">
        <div class="card-box heading-design">
            <h4 class="header-title mt-0 design-1 mb-3">Patient Details</h4>
            <div class="widget-chart text-center" style="min-height:330px" id="patient-details">
            </div>
        </div>
    </div>
    
    <div class="col-xl-12">
    	<h4 class="text-primary mb-3">Application Usage Snapshot</h4>
    </div> 
    
     <div class="col-xl-7">
        <div class="card-box heading-design">
            <h4 class="header-title mt-0 design-1 mb-3">Registration</h4>
            <div class="widget-chart text-center" style="min-height:330px" id="overall-snapshot">
            </div>
        </div>
    </div>
    
     <div class="col-xl-5">
        <div class="card-box heading-design">
            <h4 class="header-title mt-0 design-1 mb-3">Village Profile on Map</h4>
            <div class="widget-chart text-center" style="min-height:330px">
            	<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d56079.969241321756!2d77.24086072505392!3d28.539777500000003!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x390ce3de132b4909%3A0xb23d21cd15c91719!2sIndev%20Consultancy%20Pvt%20Ltd!5e0!3m2!1sen!2sin!4v1645787779074!5m2!1sen!2sin" width="100%" height="320" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
            </div>
        </div>
    </div>
    
</div>

</div>
</div>
<?php include("include/footer.php");?>
</div>
</div>
<script src="assets/js/vendor.min.js"></script>
<script src="assets/js/app.min.js"></script>
<script src="assets/libs/select2/select2.full.min.js"></script>
<script src="assets/libs/moment/moment.js"></script>
<script src="assets/libs/multiselect/jquery.multi-select.js"></script>
<script src="assets/libs/select2/select2.full.min.js"></script>
<script src="assets/libs/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
<script src="assets/libs/bootstrap-daterangepicker/daterangepicker.js"></script>
<script src="assets/libs/jquery-mask-plugin/jquery.mask.min.js"></script>
<script src="assets/libs/dropify/dropify.min.js"></script>
<script src="assets/libs/magnific-popup/jquery.magnific-popup.min.js"></script>
<script src="assets/js/jquery.stickytableheaders.js"></script>
<script src="assets/js/custom.js"></script>  

<script src="https://cdn.amcharts.com/lib/5/index.js"></script>
<script src="https://cdn.amcharts.com/lib/5/percent.js"></script>
<script src="https://cdn.amcharts.com/lib/5/xy.js"></script>
<script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>

<script>
am5.ready(function() {
var root = am5.Root.new("patient-gender-wise");
root.setThemes([
  am5themes_Animated.new(root)
]);

var chart = root.container.children.push(
  am5percent.PieChart.new(root, {
    endAngle: 270,
  })
);

var series = chart.series.push(
  am5percent.PieSeries.new(root, {
    valueField: "value",
    categoryField: "category",
    alignLabels: false,
	centerY: am5.percent(6)
	
  })
);
series.get("colors").set("colors", [
  am5.color(0x023858),
  am5.color(0x045a8d),
  am5.color(0x0570b0),
  am5.color(0x3690c0),
  am5.color(0xa9e9e5),
  am5.color(0xd1fdf4)
]);
series.states.create("hidden", {
  endAngle: -90
});
//series.slices.template.set("toggleKey", "none");
series.data.setAll([{
  category: "Male",
  value: 501.9
}, {
  category: "Female",
  value: 301.9
}]);

var legend = chart.children.push(am5.Legend.new(root, {
  centerX: am5.percent(50),
  x: am5.percent(50),
  centerY: am5.percent(100),
  y: am5.percent(100),
  marginTop: 15,
  marginBottom: 0,
  layout: root.gridLayout
}));
legend.markers.template.setAll({
  width: 15,
  height: 15
});
legend.labels.template.setAll({
  fontSize: 11,
  fontWeight: "600",
});

legend.valueLabels.template.setAll({
  fontSize: 11,
  fontWeight: "600",
  width:'90',
});
legend.markerRectangles.template.setAll({
  cornerRadiusTL: 10,
  cornerRadiusTR: 10,
  cornerRadiusBL: 10,
  cornerRadiusBR: 10
});


legend.data.setAll(series.dataItems);
series.labels.template.setAll({
  fontSize: 12,
  text: "{category}",
  textType: "circular",
  inside: true,
  radius: 10,
  fill: am5.color(0xffffff)
})
series.appear(1000, 100);

}); 



am5.ready(function() {
var root = am5.Root.new("age-wise-segregation");
root.setThemes([
  am5themes_Animated.new(root)
]);

var chart = root.container.children.push(
  am5percent.PieChart.new(root, {
    endAngle: 270,
  })
);

var series = chart.series.push(
  am5percent.PieSeries.new(root, {
    valueField: "value",
    categoryField: "category",
    alignLabels: false,
	centerY: am5.percent(6)
	
  })
);
series.get("colors").set("colors", [
  am5.color(0x023858),
  am5.color(0x045a8d),
  am5.color(0x0570b0),
  am5.color(0x3690c0),
  am5.color(0xa9e9e5),
  am5.color(0xd1fdf4)
]);
series.states.create("hidden", {
  endAngle: -90
});
//series.slices.template.set("toggleKey", "none");
series.data.setAll([{
  category: "Below 10 Year's",
  value: 120
}, {
  category: "11-20 Year's",
  value: 70
}, {
  category: "21-30 Year's",
  value: 170
}, {
  category: "Above 40 Year's",
  value: 90
}]);

var legend = chart.children.push(am5.Legend.new(root, {
  centerX: am5.percent(50),
  x: am5.percent(50),
  centerY: am5.percent(100),
  y: am5.percent(100),
  marginTop: 15,
  marginBottom: 0,
  layout: root.gridLayout
}));
legend.markers.template.setAll({
  width: 15,
  height: 15
});
legend.labels.template.setAll({
  fontSize: 11,
  fontWeight: "600",
});

legend.valueLabels.template.setAll({
  fontSize: 11,
  fontWeight: "600",
  width:'90',
});
legend.markerRectangles.template.setAll({
  cornerRadiusTL: 10,
  cornerRadiusTR: 10,
  cornerRadiusBL: 10,
  cornerRadiusBR: 10
});

legend.data.setAll(series.dataItems);
series.labels.template.setAll({
  fontSize: 12,
  text: "{category}",
  textType: "circular",
  inside: true,
  radius: 10,
  fill: am5.color(0xffffff)
})
series.appear(1000, 100);

}); 



am5.ready(function() {
var root = am5.Root.new("target");
root.setThemes([
  am5themes_Animated.new(root)
]);

var chart = root.container.children.push(
  am5percent.PieChart.new(root, {
    endAngle: 270,
  })
);

var series = chart.series.push(
  am5percent.PieSeries.new(root, {
    valueField: "value",
    categoryField: "category",
    alignLabels: false,
	centerY: am5.percent(6)
	
  })
);
series.get("colors").set("colors", [
  am5.color(0x023858),
  am5.color(0x045a8d),
  am5.color(0x0570b0),
  am5.color(0x3690c0),
  am5.color(0xa9e9e5),
  am5.color(0xd1fdf4)
]);
series.states.create("hidden", {
  endAngle: -90
});
//series.slices.template.set("toggleKey", "none");
series.data.setAll([{
  category: "New Patient",
  value: 400
}, {
  category: "Follow-up Patients",
  value: 150
}]);

var legend = chart.children.push(am5.Legend.new(root, {
  centerX: am5.percent(50),
  x: am5.percent(50),
  centerY: am5.percent(100),
  y: am5.percent(100),
  marginTop: 15,
  marginBottom: 0,
  layout: root.gridLayout
}));
legend.markers.template.setAll({
  width: 15,
  height: 15
});
legend.labels.template.setAll({
  fontSize: 11,
  fontWeight: "600",
});

legend.valueLabels.template.setAll({
  fontSize: 11,
  fontWeight: "600",
  width:'90',
});
legend.markerRectangles.template.setAll({
  cornerRadiusTL: 10,
  cornerRadiusTR: 10,
  cornerRadiusBL: 10,
  cornerRadiusBR: 10
});


legend.data.setAll(series.dataItems);
series.labels.template.setAll({
  fontSize: 12,
  text: "{category}",
  textType: "circular",
  inside: true,
  radius: 10,
  fill: am5.color(0xffffff)
})
series.appear(1000, 100);

}); 

am5.ready(function() {

// Create root element
// https://www.amcharts.com/docs/v5/getting-started/#Root_element
var root = am5.Root.new("patient-details");

// Set themes
// https://www.amcharts.com/docs/v5/concepts/themes/
root.setThemes([
  am5themes_Animated.new(root)
]);

// Create chart
// https://www.amcharts.com/docs/v5/charts/xy-chart/
var chart = root.container.children.push(am5xy.XYChart.new(root, {
  panX: false,
  panY: false,
  wheelX: "none",
  wheelY: "none"
}));

// Add cursor
// https://www.amcharts.com/docs/v5/charts/xy-chart/cursor/
var cursor = chart.set("cursor", am5xy.XYCursor.new(root, {}));
cursor.lineY.set("visible", false);

// Create axes
// https://www.amcharts.com/docs/v5/charts/xy-chart/axes/
var xRenderer = am5xy.AxisRendererX.new(root, { minGridDistance: 30 });

var xAxis = chart.xAxes.push(am5xy.CategoryAxis.new(root, {
  maxDeviation: 0,
  categoryField: "name",
  renderer: xRenderer,
  tooltip: am5.Tooltip.new(root, {})
}));

xRenderer.grid.template.set("visible", false);

var yRenderer = am5xy.AxisRendererY.new(root, {});
var yAxis = chart.yAxes.push(am5xy.ValueAxis.new(root, {
  maxDeviation: 0,
  min: 0,
  extraMax: 0.1,
  renderer: yRenderer
}));

yRenderer.grid.template.setAll({
  strokeDasharray: [2, 2]
});

// Create series
// https://www.amcharts.com/docs/v5/charts/xy-chart/series/
var series = chart.series.push(am5xy.ColumnSeries.new(root, {
  name: "Series 1",
  xAxis: xAxis,
  yAxis: yAxis,
  valueYField: "value",
  sequencedInterpolation: true,
  categoryXField: "name",
  tooltip: am5.Tooltip.new(root, { dy: -5, labelText: "{valueY} Patients" }),
  fill: am5.color(0x023858),
  stroke: am5.color(0x023858)
}));


series.columns.template.setAll({
  cornerRadiusTL: 5,
  cornerRadiusTR: 5
});

/*series.columns.template.adapters.add("fill", (fill, target) => {
  return chart.get("colors").getIndex(series.columns.indexOf(target));
});

series.columns.template.adapters.add("stroke", (stroke, target) => {
  return chart.get("colors").getIndex(series.columns.indexOf(target));
});*/

// Set data
var data = [
  {
    name: "Jan",
    value: 1500
  },{
    name: "Feb",
    value: 2500
  },{
    name: "Mar",
    value: 1450
  },{
    name: "Apr",
    value: 1600
  },{
    name: "May",
    value: 1900
  },{
    name: "Jun",
    value: 2600
  },{
    name: "Jul",
    value: 3257
  },{
    name: "Aug",
    value: 4500
  },{
    name: "Sep",
    value: 2670
  },{
    name: "Oct",
    value: 2459
  },{
    name: "Nov",
    value: 5605
  },{
    name: "Dec",
    value: 4613
  }
];

series.bullets.push(function() {
  return am5.Bullet.new(root, {
    locationY: 1,
	sprite: am5.Label.new(root, {
      text: "{valueYWorking.formatNumber('#,##,###.')}",
      fill: root.interfaceColors.get("alternativeText"),
      centerY: 0,
      centerX: am5.p50,
      populateText: true
    })
    /*sprite: am5.Picture.new(root, {
      templateField: "bulletSettings",
      width: 50,
      height: 50,
      centerX: am5.p50,
      centerY: am5.p50,
      shadowColor: am5.color(0x000000),
      shadowBlur: 4,
      shadowOffsetX: 4,
      shadowOffsetY: 4,
      shadowOpacity: 0.6
    })*/
  });
});




xAxis.data.setAll(data);
series.data.setAll(data);
series.appear(1000);
chart.appear(1000, 100);

}); // end am5.ready()








am5.ready(function() {
var root = am5.Root.new("overall-snapshot");
root.setThemes([
  am5themes_Animated.new(root)
]);
var chart = root.container.children.push(am5xy.XYChart.new(root, {
  panX: false,
  panY: false,
  wheelX: "none",
  wheelY: "none"
}));
var cursor = chart.set("cursor", am5xy.XYCursor.new(root, {}));
cursor.lineY.set("visible", false);
var xRenderer = am5xy.AxisRendererX.new(root, { minGridDistance: 30 });

var xAxis = chart.xAxes.push(am5xy.CategoryAxis.new(root, {
  maxDeviation: 0,
  categoryField: "name",
  renderer: xRenderer,
  tooltip: am5.Tooltip.new(root, {})
}));
xRenderer.grid.template.set("visible", false);
var yRenderer = am5xy.AxisRendererY.new(root, {});
var yAxis = chart.yAxes.push(am5xy.ValueAxis.new(root, {
  maxDeviation: 0,
  min: 0,
  extraMax: 0.1,
  renderer: yRenderer
}));
yRenderer.grid.template.setAll({
  strokeDasharray: [2, 2]
});
var series = chart.series.push(am5xy.ColumnSeries.new(root, {
  name: "Series 1",
  xAxis: xAxis,
  yAxis: yAxis,
  valueYField: "value",
  sequencedInterpolation: true,
  categoryXField: "name",
  tooltip: am5.Tooltip.new(root, { dy: -5, labelText: "{valueY} Users" }),
  fill: am5.color(0x023858),
  stroke: am5.color(0x023858)
}));


series.columns.template.setAll({
  cornerRadiusTL: 5,
  cornerRadiusTR: 5
});

/*series.columns.template.adapters.add("fill", (fill, target) => {
  return chart.get("colors").getIndex(series.columns.indexOf(target));
});

series.columns.template.adapters.add("stroke", (stroke, target) => {
  return chart.get("colors").getIndex(series.columns.indexOf(target));
});*/

// Set data
var data = [
  {
    name: "Jan",
    value: 5500
  },{
    name: "Feb",
    value: 4500
  },{
    name: "Mar",
    value: 4850
  },{
    name: "Apr",
    value: 6600
  },{
    name: "May",
    value: 1900
  },{
    name: "Jun",
    value: 2900
  },{
    name: "Jul",
    value: 3957
  },{
    name: "Aug",
    value: 6500
  },{
    name: "Sep",
    value: 7270
  },{
    name: "Oct",
    value: 6459
  },{
    name: "Nov",
    value: 5605
  },{
    name: "Dec",
    value: 4900
  }
];

series.bullets.push(function() {
  return am5.Bullet.new(root, {
    locationY: 1,
	sprite: am5.Label.new(root, {
      //text: "{valueYWorking.formatNumber('#,##,###.')}",
      fill: root.interfaceColors.get("alternativeText"),
      centerY: 0,
      centerX: am5.p50,
      populateText: true
    })
    /*sprite: am5.Picture.new(root, {
      templateField: "bulletSettings",
      width: 50,
      height: 50,
      centerX: am5.p50,
      centerY: am5.p50,
      shadowColor: am5.color(0x000000),
      shadowBlur: 4,
      shadowOffsetX: 4,
      shadowOffsetY: 4,
      shadowOpacity: 0.6
    })*/
  });
});




xAxis.data.setAll(data);
series.data.setAll(data);
series.appear(1000);
chart.appear(1000, 100);

}); // end am5.ready()
</script>
</body>
</html>