<!DOCTYPE html>

<html lang="en">
<head>

	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="" />
    <meta name="author" content="" />
    <meta name="robots" content="" />    
    <meta name="description" content="" />
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon" />
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png" />
    
    <!-- PAGE TITLE HERE -->
    <title>Global Communication Research Association (GCRA) | Home</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- [if lt IE 9]>
        <script src="js/html5shiv.min.js"></script>
        <script src="js/respond.min.js"></script>
	<![endif] -->
    
    <!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="css/fontawesome/css/font-awesome.min.css" />
    <link rel="stylesheet" type="text/css" href="css/flaticon.min.css">
    <link rel="stylesheet" type="text/css" href="css/animate.min.css">
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.min.css">
    <link rel="stylesheet" type="text/css" href="css/bootstrap-select.min.css">
    <link rel="stylesheet" type="text/css" href="css/magnific-popup.min.css">
    <link rel="stylesheet" type="text/css" href="css/loader.min.css"> 
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="stylesheet" class="skin" type="text/css" href="css/skin/skin-1.css">
    <link rel="stylesheet" type="text/css" href="css/custom.css"> 
    <link rel="stylesheet" type="text/css" href="plugins/revolution/revolution/css/settings.css">
    <link rel="stylesheet" type="text/css" href="plugins/revolution/revolution/css/navigation.css">
    <link href='http://fonts.googleapis.com/css?family=Roboto:400,100,300,300italic,400italic,500,500italic,700,700italic,900italic,900' rel='stylesheet' type='text/css'>
    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,300,300italic,400italic,600,600italic,700,800italic,800,700italic' rel='stylesheet' type='text/css'>
    <link href="https://fonts.googleapis.com/css?family=Crete+Round:400,400i&amp;subset=latin-ext" rel="stylesheet">
</head>

<body id="bg">

	<div class="page-wraper"> 
       	
        <?php include("include/header.php");?>
        
        <!-- CONTENT START -->
        <div class="page-content">
        
            <!-- SLIDER START -->
            <div class="main-slider style-two default-banner">
           		<div class="tp-banner-container">
                    <div class="tp-banner" >
                        <!-- START REVOLUTION SLIDER 5.4.1 -->
                        <div id="rev_slider_1014_1_wrapper" class="rev_slider_wrapper fullscreen-container" data-alias="typewriter-effect" data-source="gallery">
                           <div id="rev_slider_1014_1" class="rev_slider fullscreenbanner" style="display:none;" data-version="5.4.1">
                                <ul>
                                    <!-- SLIDE 1 -->
                                    <li data-index="rs-2000" data-transition="slidingoverlayhorizontal" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="default" data-easeout="default" data-masterspeed="default"  data-thumb="images/main-slider/slider2/slide4.jpg"  data-rotate="0"  data-saveperformance="off"  data-title="Welcome to GCRA" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
                                        <!-- MAIN IMAGE -->
                                        <img src="images/main-slider/slider2/slide4.jpg"  alt=""  data-bgposition="center bottom" data-bgfit="cover" data-bgrepeat="no-repeat" class="rev-slidebg" data-no-retina/>
                                        <!-- LAYERS -->
                                        
                                        <!-- LAYER NR. 1 [ for overlay ] -->
                                        <div class="tp-caption tp-shape tp-shapewrapper " 
                                        id="slide-200-layer-1" 
                                        data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
                                        data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
                                        data-width="full"
                                        data-height="full"
                                        data-whitespace="nowrap"
                                        data-type="shape" 
                                        data-basealign="slide" 
                                        data-responsive_offset="off" 
                                        data-responsive="off"
                                        data-frames='[
                                        {"from":"opacity:0;","speed":1000,"to":"o:1;","delay":0,"ease":"Power4.easeOut"},
                                        {"delay":"wait","speed":1000,"to":"opacity:0;","ease":"Power4.easeOut"}
                                        ]'
                                        data-textAlign="['left','left','left','left']"
                                        data-paddingtop="[0,0,0,0]"
                                        data-paddingright="[0,0,0,0]"
                                        data-paddingbottom="[0,0,0,0]"
                                        data-paddingleft="[0,0,0,0]"
                                        
                                        style="z-index: 12;background-color:rgb(0 0 0 / 48%);border-color:rgba(0, 0, 0, 0);border-width:0px;"> 
                                        </div>
                                    
                                        <!-- LAYER NR. 2 [ for title ] -->
                                        <div class="tp-caption   tp-resizeme" 
                                        id="slide-200-layer-2" 
                                        data-x="['left','left','left','left']" data-hoffset="['30','30','30','20']" 
                                        data-y="['top','top','top','top']" data-voffset="['80','80','70','50']"  
                                        data-fontsize="['42','36','27','22']"
                                        data-lineheight="['60','40','32','26']"
                                        data-width="['700','700','700','700']"
                                        data-height="['none','none','none','none']"
                                        data-whitespace="['normal','normal','normal','normal']"
                                    
                                        data-type="text" 
                                        data-responsive_offset="on" 
                                        data-frames='[
                                        {"from":"y:100px(R);opacity:0;","speed":2000,"to":"o:1;","delay":500,"ease":"Power4.easeOut"},
                                        {"delay":"wait","speed":1000,"to":"y:-50px;opacity:0;","ease":"Power2.easeInOut"}
                                        ]'
                                        data-textAlign="['left','left','left','left']"
                                        data-paddingtop="[0,0,0,0]"
                                        data-paddingright="[0,0,0,0]"
                                        data-paddingbottom="[0,0,0,0]"
                                        data-paddingleft="[0,0,0,0]"
                                    
                                        style="z-index: 13; 
                                        white-space: normal; 
                                        font-weight: 700; 
                                        color: rgba(255, 255, 255, 1.00);
                                        border-width:0px;">
                                        <span  style="font-family:'Roboto' ;">Welcome to <span class="text-primary"> GCRA </span></span>
                                        </div>
                                    
                                        <!-- LAYER NR. 3 [ for paragraph] -->
                                        <div class="tp-caption  tp-resizeme" 
                                        id="slide-200-layer-3" 
                                        data-x="['left','left','left','left']" data-hoffset="['30','30','30','100']" 
                                        data-y="['top','top','top','top']" data-voffset="['160','160','150','130']"  
                                        data-fontsize="['16','16','16','16']"
                                        data-lineheight="['27','25','22','22']"
                                        data-width="['650','650','650','320']"
                                        data-height="['none','none','none','none']"
                                        data-whitespace="['normal','normal','normal','normal']"
                                    
                                        data-type="text" 
                                        data-responsive_offset="on"
                                        data-frames='[
                                        {"from":"y:100px(R);opacity:0;","speed":2000,"to":"o:1;","delay":1000,"ease":"Power4.easeOut"},
                                        {"delay":"wait","speed":1000,"to":"y:-50px;opacity:0;","ease":"Power2.easeInOut"}
                                        ]'
                                        data-textAlign="['left','left','left','left']"
                                        data-paddingtop="[0,0,0,0]"
                                        data-paddingright="[0,0,0,0]"
                                        data-paddingbottom="[0,0,0,0]"
                                        data-paddingleft="[0,0,0,0]"
                                    
                                        style="z-index: 13; 
                                        font-weight: 400; 
                                        color: rgba(255, 255, 255, 0.85);
                                        border-width:0px;">
                                        <span style="font-family:'Roboto';">We work towards a brighter future for the underrepresented communication scholars in the global south. Throughout the world, large numbers of communication scholars and practitioners are underrepresented in forums of....</span>
                                        </div>
                                    
                                        <!-- LAYER NR. 4 [ for readmore botton ] -->
                                        <div class="tp-caption tp-resizeme" 	
                                        id="slide-200-layer-4"						
                                        data-x="['left','left','left','left']" data-hoffset="['30','30','30','100']" 
                                        data-y="['top','top','top','top']" data-voffset="['280','280','260','240']"  
                                        data-lineheight="['none','none','none','none']"
                                        data-width="['300','300','300','300']"
                                        data-height="['none','none','none','none']"
                                        data-whitespace="['normal','normal','normal','normal']"
                                        
                                        data-type="text" 
                                        data-responsive_offset="on"
                                        data-frames='[ 
                                        {"from":"y:100px(R);opacity:0;","speed":2000,"to":"o:1;","delay":1500,"ease":"Power4.easeOut"},
                                        {"delay":"wait","speed":1000,"to":"y:-50px;opacity:0;","ease":"Power2.easeInOut"}
                                        ]'
                                        data-textAlign="['left','left','left','left']"
                                        data-paddingtop="[0,0,0,0]"
                                        data-paddingright="[0,0,0,0]"
                                        data-paddingbottom="[0,0,0,0]"
                                        data-paddingleft="[0,0,0,0]"
                                        
                                        style="z-index:13; text-transform:uppercase; font-weight:700;">
                                        <a href="about.php" class="site-button">Read more </a>
                                        </div>
                                        
                                        <!-- LAYER NR. 5 [ for worker pic 1 big] -->
                                        <div class="tp-caption tp-resizeme" 	
                                        id="slide-200-layer-5"						
                                        data-x="['right','right','right','right']" data-hoffset="['10','10','10','10']" 
                                        data-y="['bottom','bottom','bottom','bottom']" data-voffset="['0','0','0','0']"
                                        
                                        data-frames='[ 
                                        {"from":"y:100px(R);opacity:0;","speed":2000,"to":"o:1;","delay":3000,"ease":"Power4.easeOut"},
                                        {"delay":"wait","speed":1000,"to":"y:-50px;opacity:0;","ease":"Power2.easeInOut"}
                                        ]'
                                        
                                        style="z-index: 13;">
                                        
                                        </div>
                                                                      
                                    </li>
                                    
                                    <li data-index="rs-3000" data-transition="slidingoverlayhorizontal" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="default" data-easeout="default" data-masterspeed="default"  data-thumb="images/main-slider/slider2/slide3.jpg"  data-rotate="0"  data-saveperformance="off"  data-title="GCRA Journal" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
                                        <!-- MAIN IMAGE -->
                                        <img src="images/main-slider/slider2/slide3.jpg"  alt=""  data-bgposition="center bottom" data-bgfit="cover" data-bgrepeat="no-repeat" class="rev-slidebg" data-no-retina/>
                                        <!-- LAYERS -->
                                        
                                        <!-- LAYER NR. 1 [ for overlay ] -->
                                        <div class="tp-caption tp-shape tp-shapewrapper " 
                                        id="slide-200-layer-1" 
                                        data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']" 
                                        data-y="['middle','middle','middle','middle']" data-voffset="['0','0','0','0']" 
                                        data-width="full"
                                        data-height="full"
                                        data-whitespace="nowrap"
                                        data-type="shape" 
                                        data-basealign="slide" 
                                        data-responsive_offset="off" 
                                        data-responsive="off"
                                        data-frames='[
                                        {"from":"opacity:0;","speed":1000,"to":"o:1;","delay":0,"ease":"Power4.easeOut"},
                                        {"delay":"wait","speed":1000,"to":"opacity:0;","ease":"Power4.easeOut"}
                                        ]'
                                        data-textAlign="['left','left','left','left']"
                                        data-paddingtop="[0,0,0,0]"
                                        data-paddingright="[0,0,0,0]"
                                        data-paddingbottom="[0,0,0,0]"
                                        data-paddingleft="[0,0,0,0]"
                                        
                                        style="z-index: 12;background-color:rgb(0 0 0 / 48%);border-color:rgba(0, 0, 0, 0);border-width:0px;"> 
                                        </div>
                                    
                                        <!-- LAYER NR. 2 [ for title ] -->
                                        <div class="tp-caption   tp-resizeme" 
                                        id="slide-200-layer-2" 
                                        data-x="['left','left','left','left']" data-hoffset="['30','30','30','20']" 
                                        data-y="['top','top','top','top']" data-voffset="['80','80','70','50']"  
                                        data-fontsize="['42','36','27','22']"
                                        data-lineheight="['60','40','32','26']"
                                        data-width="['700','700','700','700']"
                                        data-height="['none','none','none','none']"
                                        data-whitespace="['normal','normal','normal','normal']"
                                    
                                        data-type="text" 
                                        data-responsive_offset="on" 
                                        data-frames='[
                                        {"from":"y:100px(R);opacity:0;","speed":2000,"to":"o:1;","delay":500,"ease":"Power4.easeOut"},
                                        {"delay":"wait","speed":1000,"to":"y:-50px;opacity:0;","ease":"Power2.easeInOut"}
                                        ]'
                                        data-textAlign="['left','left','left','left']"
                                        data-paddingtop="[0,0,0,0]"
                                        data-paddingright="[0,0,0,0]"
                                        data-paddingbottom="[0,0,0,0]"
                                        data-paddingleft="[0,0,0,0]"
                                    
                                        style="z-index: 13; 
                                        white-space: normal; 
                                        font-weight: 700; 
                                        color: rgba(255, 255, 255, 1.00);
                                        border-width:0px;">
                                        <span  style="font-family:'Roboto' ;">GCRA <span class="text-primary"> Journal </span></span>
                                        </div>
                                    
                                        <!-- LAYER NR. 3 [ for paragraph] -->
                                        <div class="tp-caption  tp-resizeme" 
                                        id="slide-200-layer-3" 
                                        data-x="['left','left','left','left']" data-hoffset="['30','30','30','100']" 
                                        data-y="['top','top','top','top']" data-voffset="['160','160','150','130']"  
                                        data-fontsize="['16','16','16','16']"
                                        data-lineheight="['27','25','22','22']"
                                        data-width="['650','650','650','320']"
                                        data-height="['none','none','none','none']"
                                        data-whitespace="['normal','normal','normal','normal']"
                                    
                                        data-type="text" 
                                        data-responsive_offset="on"
                                        data-frames='[
                                        {"from":"y:100px(R);opacity:0;","speed":2000,"to":"o:1;","delay":1000,"ease":"Power4.easeOut"},
                                        {"delay":"wait","speed":1000,"to":"y:-50px;opacity:0;","ease":"Power2.easeInOut"}
                                        ]'
                                        data-textAlign="['left','left','left','left']"
                                        data-paddingtop="[0,0,0,0]"
                                        data-paddingright="[0,0,0,0]"
                                        data-paddingbottom="[0,0,0,0]"
                                        data-paddingleft="[0,0,0,0]"
                                    
                                        style="z-index: 13; 
                                        font-weight: 400; 
                                        color: rgba(255, 255, 255, 0.85);
                                        border-width:0px;">
                                        <span style="font-family:'Roboto';">The Journal of Global Communication (JGC) is a refereed journal for the publication of scholarly work in the field of communication for development (including extension education), educational communication, journalism, new media issues....</span>
                                        </div>
                                    
                                        <!-- LAYER NR. 4 [ for readmore botton ] -->
                                        <div class="tp-caption tp-resizeme" 	
                                        id="slide-200-layer-4"						
                                        data-x="['left','left','left','left']" data-hoffset="['30','30','30','100']" 
                                        data-y="['top','top','top','top']" data-voffset="['280','280','260','240']"  
                                        data-lineheight="['none','none','none','none']"
                                        data-width="['300','300','300','300']"
                                        data-height="['none','none','none','none']"
                                        data-whitespace="['normal','normal','normal','normal']"
                                        
                                        data-type="text" 
                                        data-responsive_offset="on"
                                        data-frames='[ 
                                        {"from":"y:100px(R);opacity:0;","speed":2000,"to":"o:1;","delay":1500,"ease":"Power4.easeOut"},
                                        {"delay":"wait","speed":1000,"to":"y:-50px;opacity:0;","ease":"Power2.easeInOut"}
                                        ]'
                                        data-textAlign="['left','left','left','left']"
                                        data-paddingtop="[0,0,0,0]"
                                        data-paddingright="[0,0,0,0]"
                                        data-paddingbottom="[0,0,0,0]"
                                        data-paddingleft="[0,0,0,0]"
                                        
                                        style="z-index:13; text-transform:uppercase; font-weight:700;">
                                        <a href="journal.php" class="site-button">Read more </a>
                                        </div>
                                        
                                        <!-- LAYER NR. 5 [ for worker pic 1 big] -->
                                        <div class="tp-caption tp-resizeme" 	
                                        id="slide-200-layer-5"						
                                        data-x="['right','right','right','right']" data-hoffset="['10','10','10','10']" 
                                        data-y="['bottom','bottom','bottom','bottom']" data-voffset="['0','0','0','0']"
                                        
                                        data-frames='[ 
                                        {"from":"y:100px(R);opacity:0;","speed":2000,"to":"o:1;","delay":3000,"ease":"Power4.easeOut"},
                                        {"delay":"wait","speed":1000,"to":"y:-50px;opacity:0;","ease":"Power2.easeInOut"}
                                        ]'
                                        
                                        style="z-index: 13;">
                                        
                                        </div>
                                              
                                        
                                                       
                                        
                                                                      
                                    </li>
                                   
                                    	
                                    
                                </ul>
                                <div class="tp-bannertimer tp-bottom" style="visibility: hidden !important;"></div>	
                           </div>
                        </div>
                        <!-- END REVOLUTION SLIDER -->
                    </div>
            	</div>
            </div>
            <!-- SLIDER END -->
            
            
            <!-- WHY CHOOSE US SECTION START  -->
            <div class="section-full bg-gray p-t30 p-b40">
            	<div class="container">                    
                    <div class="row p-b10">
                        <div class="col-md-8">
                            <div class="section-head text-left m-b0">
                                <h2>Thematic Area </h2>
                                <div class="wt-separator-outer">
                                    <div class="wt-separator style-square">
                                        <span class="separator-left bg-secondary"></span>
                                        <span class="separator-right bg-secondary"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="text-right">
                                <a href="#" class="m-b15 site-button red radius-xl  m-r15">View All</a>
                            </div>
                        </div>
                    </div>
                    <!-- TITLE END-->
                    <div class="section-content ">
                        <div class="row">
                        
                            <!-- COLUMNS 1 -->
                            <div class="col-md-4">
                                <div class="sidebar">
                                    <aside>
                                        <div class="sidebar-item search">
                                              <div class="sidebar-info">
                                               <div class="title text-left text-white"><h4>Search <i class="fa fa-search"></i></h4></div>
                                                    
                                                <form action="#" method="POST" class="contact-form">
                                                      <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                                                        
                                                         <div class="panel panel-default">
                                                             
                                                            <div class="panel-heading" role="tab" id="headingZero">
                                                            <h4 class="panel-title">
                                                            <a class="collapsed" role="button" data-toggle="collapse" data-target="#collapseZero" aria-expanded="true" aria-controls="collapseZero" data-parent="#accordion">
                                                              All 
                                                            </a>
                                                          </h4>
                                                          </div>
                                                             
                                                          <div id="collapseZero" class="panel-collaps collapse in" aria-labelledby="headingZero" data-parent="#accordion">
                                                              
                                                            <div class="panel-body">
                                                              
                                                              <div class="checkbox">
                                                                <input id="chk1" type="checkbox" name="chk1" checked="">
                                                                <label for="chk1">Select All</label> 
                                                              </div>
                                                              
                                                            </div>
                                                          </div>
                                                        </div>
                                                          
                                                          
                                                        <div class="panel panel-default">
                                                          <div class="panel-heading" role="tab" id="headingOne">
                                                            <h4 class="panel-title">
                                                            <a role="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne" data-parent="#accordion">
                                                              Category
                                                            </a>
                                                          </h4>
                                                          </div>
                                                          <div id="collapseOne" class="panel-collapse collapse" data-parent="#accordion" role="tabpanel" aria-labelledby="headingOne">
                                                            <div class="panel-body">
                                                              
                                                              <div class="checkbox">
                                                                <input id="chk2" type="checkbox" name="chk2">
                                                                <label for="chk2">Program Analytics &amp; Impact</label> 
                                                              </div>
                                                             
                                                              <div class="checkbox">
                                                                <input id="chk3" type="checkbox" name="chk3">
                                                                <label for="chk3">Market &amp; Sector Analysis </label> 
                                                              </div>
                                                             
                                                              <div class="checkbox">
                                                                <input id="chk11" type="checkbox" name="chk11">
                                                                <label for="chk11" data-toggle="modal" data-target="#myModal">Institutional Knowledge Memory</label> 
                                                              </div>
                                                            
                                                              
                                                            </div>
                                                          </div>
                                                        </div>
                                                        <div class="panel panel-default">
                                                          <div class="panel-heading" role="tab" id="headingTwo">
                                                            <h4 class="panel-title">
                                                            <a class="collapsed" role="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo" data-parent="#accordion">
                                                              Thematic Area
                                                            </a>
                                                          </h4>
                                                          </div>
                                                          <div id="collapseTwo" class="panel-collapse collapse" data-parent="#accordion" role="tabpanel" aria-labelledby="headingTwo">
                                                            <div class="panel-body scrolling-height">    											  
                                                              <div class="checkbox">
                                                                <input id="chk25" type="checkbox" name="chk25">
                                                                <label for="chk25">  Standards &amp; Curriculum </label> 
                                                              </div>
                                                              <div class="checkbox">
                                                                <input id="chk26" type="checkbox" name="chk26">
                                                                <label for="chk26">  Training Partners </label> 
                                                              </div>
                                                              <div class="checkbox">
                                                                <input id="chk27" type="checkbox" name="chk27">
                                                                <label for="chk27">  Counseling &amp; Mobilization </label> 
                                                              </div>
                                                              <div class="checkbox">
                                                                <input id="chk28" type="checkbox" name="chk28">
                                                                <label for="chk28">  Employability &amp; Entrepreneurship </label> 
                                                              </div>
                                                               <div class="checkbox">
                                                                <input id="chk29" type="checkbox" name="chk29">
                                                                <label for="chk29">  Future of Work </label> 
                                                              </div>
                                                                
                                                            </div>
                                                          </div>
                                                        </div>
                                                      </div>
                                                      
                                                      <div class="col-md-12">
                                                        <div class="row">
                                                            <button type="submit" name="submit" id="submit" class="btn btn-theme effect btn-sm">Search</button>
                                                        </div>
                                                      </div>
                                                </form>	
                                                
                                                <div class="clearfix"></div>
                
                                            </div>
                                
                                            
                                           
                                       </div>
                                        
                                    </aside>
                                </div>
                            </div>
                            <!-- COLUMNS 2 -->
                            <div class="col-md-8">
                                <div class="row porperty_listWrp thematic-bx">
                                    <div class="col-lg-12">
                                    
                                      <ul class="blog_post">
                                        <li>
                                          <div class="services_box wow fadeInUp">
                                            <div class="row">
                                              <div class="col-lg-4 col-md-4">
                                                <div class="servicesImg"><img alt="" src="images/gallery/pic1.jpg"></div>
                                              </div>
                                              <div class="col-lg-8 col-md-8">
                                                <h3><a href="#">Clean Energy</a></h3>
                                                <div class="post-meta"> <span><i class="fa fa-archive"></i> Counseling &amp; Mobilization </span> <span><i class="fa fa-bookmark"></i> Category: Market &amp; Sector Analysis </span> </div>
                                                <p> By 2030, upgrade infrastructure and retrofit industries to make them sustainable, with increased resource-use efficiency and greater adoption of clean and environmentally sound</p>
                                                <div class="readmore"><a href="#" class="site-button red radius-xl">Read More</a></div>
                                              </div>
                                            </div>
                                          </div>
                                        </li>
                                        <li>
                                          <div class="services_box wow fadeInUp">
                                            <div class="row">
                                              <div class="col-lg-4 col-md-4">
                                                <div class="servicesImg"><img alt="" src="images/gallery/pic2.jpg"></div>
                                              </div>
                                              <div class="col-lg-8 col-md-8">
                                                <h3><a href="#">Environmental Sustainability</a></h3>
                                               <div class="post-meta"> <span><i class="fa fa-archive"></i>   Standards &amp; Curriculum  </span> <span><i class="fa fa-bookmark"></i> Category: Market &amp; Sector Analysis </span> </div>
                                                <p>Focus on Reducing environmental degradation by using some production methods in industry</p>
                                                <div class="readmore"><a href="#" class="site-button red radius-xl">Read More</a></div>
                                              </div>
                                            </div>
                                          </div>
                                        </li>
                                        
                                      </ul>
                                      
                                      <h6 class="mb-3 thematic-pagi">
                                      
                                     
                                      
                                      <span><strong class="text-success">24</strong> Records Found</span>
                                      
                                       <span>
                                      <div class="blog-pagination text-center mt-0"> <a href="#0"><i class="fa fa-angle-left"></i></a> <a href="#0">01</a> <a href="#0" class="active">02</a> <a href="#0">03</a> <a href="#0"><i class="fa fa-angle-right"></i></a> </div>
                                      </span> 
                                      
                                      </h6>
                                      
                                    </div>
                      
                                </div>
                            </div>
                            
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- WHY CHOOSE US SECTION END  --> 
            
            <div class="section-full p-t30 p-b30">
                <div class="container">
                     
                    <div class="row">
                        <div class="col-lg-12 col-md-6">
                            <div class="row pb-3">
                                <div class="col-md-8">
                                	<div class="section-head text-left m-b0">
                                        <h2>Latest Stories </h2>
                                        <div class="wt-separator-outer">
                                            <div class="wt-separator style-square">
                                                <span class="separator-left bg-secondary"></span>
                                                <span class="separator-right bg-secondary"></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="text-right">
                                        <a href="#" class="m-b15 site-button red radius-xl  m-r15">View All</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-6 mb-30">
                            <div class="row">
                                <div class="col-lg-6 col-md-6 m-b30">
                                    <div class="tiles-wrap main-tile lg" style="background:url(images/Sanitation1.jpg);">
                                        <div class="tile-bg p1" style="background:url(images/thematic/1.jpg);">
                                            <div>
                                                <div class="content-part">
                                                    <h4 class="title"><a href="#">Model Village Development Program</a></h4>
                                                    <p class="desc">In association with Financial Foundation have taken a bold step to transform an entire cluster of 15 villages into a Model village. Focussing at the grass root level, we have adopted.... </p>
                                                </div>
                                                <div class="btn-part">
                                                    <a href="sanitation.php" class="read-more">Read More <span></span></a>
                                                </div>
                                            </div>
                                        </div>
        
                                        <div class="tile-bg p2" style="background:url(images/thematic/2.jpg);">
                                            <div>
                                                <div class="content-part">
                                                    <h4 class="title"><a href="#">Integrated Farming: An Approach towards Holistic Development</a></h4>
                                                    <p class="desc">In a pursuit to mitigate the challenges in dissemination of extension services during the pandemic pertaining to availability, accessibility and acceptability faced by the cultivators' community  has entrusted us with a challenging task of facilitating the diversification of livelihoods through appropriate and adequate training and capacity building exercises and aid in the development of a small cadre of on-ground specialists in the region... </p>
                                                </div>
                                                <div class="btn-part">
                                                    <a href="#" class="read-more">Read More <span></span></a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tile-bg p3" style="background:url(images/thematic/3.jpg);">
                                            <div>
                                                <div class="content-part">
                                                    <h4 class="title"><a href="#">Nutrition on Wheels</a></h4>
                                                    <p class="desc">Malnutrition is a menace that has affected tribal and non-urban. The
        ongoing pandemic has curtailed the accessibility and acceptability of a nutritious diet and has made the delivery of nutrition-focussed initiatives from the government end to liminal levels resulting in frequent incidences of Severely Acute Malnutrition (SAM) and Moderately
        Acute Malnutrition (MAM) cases.... </p>
                                                </div>
                                                <div class="btn-part">
                                                    <a href="#" class="read-more">Read More <span></span></a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tile-bg p4" style="background:url(images/thematic/4.jpg);">
                                            <div>
                                                <div class="content-part">
                                                    <h4 class="title"><a href="#">Designing Innovative and Holistic Community-Based Business Models for Mica Pickers</a></h4>
                                                    <p class="desc">The product has several attributes which are useful to a wide number of industries, such as cosmetics, paint, electronics, construction, oil-drilling etc. Nearly 75%..... </p>
                                                </div>
                                                <div class="btn-part">
                                                    <a href="#" class="read-more">Read More <span></span></a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="content-part">
                                            <h4 class="title"><a href="#">Our Works</a></h4>
                                            <p class="desc">We value knowledge, diversity and the many different perspectives that our team brings into
        complex issues with a truly collaborative spirit. We aim to create sustainable changes in Rurban life with our exhaustive research and comprehensive programmes on education, livelihood, health, environmental challenges, socio-economic justice and gender issues..... </p>
                                        </div>
                                        <div class="btn-part">
                                            <a href="#" class="read-more">Read More <span></span></a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="row">
                                        <div class="col-md-6 m-b4">
                                            <div class="tiles-wrap small-wrap" style="background:url(images/thematic/1.jpg);">
                                                <div class="tile-bg" style="background:url(images/thematic/1.jpg);">
                                                    <div class="project-hover-div">
                                                        <div class="content-part small-tab">
                                                            <h4 class="title project-flag" data-project="p1"><a href="#">Model Village Development Program</a></h4>
                                                            <p class="desc project-flag" data-project="p1">In association with Foundation have taken a bold step to transform an entire cluster of 15 villages...</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="content-part small-tab">
                                                    <h4 class="title"><a href="#">Model Village Development Program</a></h4>
                                                    <p class="desc">In association with Financial Foundation have taken a bold step to transform an entire cluster of 15 villages into a Model village... </p>
                                                </div>
                                                <div class="btn-part">
                                                    <a href="#" class="read-more">Read More <span></span></a>
                                                </div>
                                            </div>
                                        </div>
        
                                        <div class="col-md-6 m-b30">
                                            <div class="tiles-wrap small-wrap" style="background:url(images/thematic/2.jpg);">
                                                <div class="tile-bg" style="background:url(images/thematic/2.jpg);">
                                                    <div class="project-hover-div">
                                                        <div class="content-part small-tab">
                                                            <h4 class="title project-flag" data-project="p2"><a href="#">Agriculture</a></h4>
                                                            <p class="desc project-flag" data-project="p2">In a pursuit to mitigate the challenges in dissemination of extension services during the pandemic pertaining to availability, accessibility and acceptability faced by the cultivators'
        community... </p>
                                                        </div>
                                                    </div>
                                                </div>
        
                                                <div class="content-part small-tab">
                                                    <h4 class="title"><a href="#"> Agriculture</a></h4>
                                                    <p class="desc">In a pursuit to mitigate the challenges in dissemination of extension services during the pandemic pertaining to availability, accessibility and acceptability faced by the cultivators' community... </p>
                                                </div>
                                                <div class="btn-part">
                                                    <a href="#" class="read-more">Read More <span></span></a>
                                                </div>
                                            </div>
                                        </div>
        
                                        <div class="col-md-6 m-b4">
                                            <div class="tiles-wrap small-wrap" style="background:url(images/thematic/3.jpg);">
                                                <div class="tile-bg" style="background:url(images/thematic/3.jpg);">
                                                    <div class="project-hover-div">
                                                        <div class="content-part small-tab">
                                                            <h4 class="title project-flag" data-project="p3"><a href="#">Health & Nutrition</a></h4>
                                                            <p class="desc project-flag" data-project="p3">Malnutrition is a menace that has affected tribal and non-urban areas. The ongoing pandemic has curtailed the accessibility and acceptability ...</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="content-part small-tab">
                                                    <h4 class="title"><a href="#">Health & Nutrition</a></h4>
                                                    <p class="desc">Malnutrition is a menace that has affected tribal and non-urban areas. The ongoing pandemic has curtailed the accessibility and acceptability ...</p>
                                                </div>
                                                <div class="btn-part">
                                                    <a href="#" class="read-more">Read More <span></span></a>
                                                </div>
                                            </div>
                                        </div>
        
                                        <div class="col-md-6 m-b4">
                                            <div class="tiles-wrap small-wrap" style="background:url(images/thematic/4.jpg);">
                                                <div class="tile-bg" style="background:url(images/thematic/4.jpg);">
                                                    <div class="project-hover-div">
                                                        <div class="content-part small-tab">
                                                            <h4 class="title project-flag" data-project="p4"><a href="#">Policy Advocacy</a></h4>
                                                            <p class="desc project-flag" data-project="p4">Key minerals mined in the State. The product has several attributes which are useful to a wide number of industries, such as cosmetics, paint, electronics...</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="content-part small-tab">
                                                    <h4 class="title"><a href="#">Policy Advocacy, Jharkhand</a></h4>
                                                    <p class="desc">Key minerals mined in the State. The product has several attributes which are useful to a wide number of industries, such as cosmetics, paint, electronics... </p>
                                                </div>
                                                <div class="btn-part">
                                                    <a href="#" class="read-more">Read More <span></span></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    
                </div>
            </div>
            
            <!-- COMPANY DETAIL SECTION START -->
            <div class="section-full p-t50 p-b50 overlay-wraper bg-parallax"  data-stellar-background-ratio="0.5" style="background-image:url(images/background/bg-5.jpg);">
                <div class="overlay-main opacity-09 bg-primary"></div>
                <div class="container ">
                    <div class="row">
                        <div class="col-md-4"></div>
                        <div class="col-md-8">
                        	<div class="text-right text-white">
                            	<h3 class="font-24">GCRA</h3>
                                <h1 class="font-60">AWESOME FACTS</h1>
                                <p>The Global Communication Research Association (GCRA) seeks to provide a forum for those scholars and practitioners to be a part of the global communication community scholars and be able to express their research interests and best represent issues and problems of their countries. </p>
                            </div>
                         </div>
                        <div class="col-md-3"></div>
                        <div class="col-md-3 col-sm-4">
                            <div class="status-marks  text-white m-tb10">
                                <div class="status-value text-right">
                                	<span class="counter text-white">2234</span>
                                    <i class="fa fa-globe font-26 m-l15"></i>
                                </div>
                                <h6 class="text-uppercase text-white text-right">PROJECT COMPLETED</h6>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-4">
                            <div class="status-marks  text-white m-tb10">
                                <div class="status-value text-right">
                                	<span class="counter text-white">4156</span>
                                    <i class="fa fa-users font-26 m-l15"></i>
                                </div>
                                <h6 class="text-uppercase text-white text-right">Scholars and Practitioners</h6>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-4">
                            <div class="status-marks  text-white m-tb10">
                                <div class="status-value text-right">
                                	<span class="counter text-white">42</span>
                                    <i class="fa fa-file-o font-26 m-l15"></i>
                                </div>
                                <h6 class="text-uppercase text-white text-right">Research Documents</h6>
                            </div>
                        </div>
                        
                       
                    
                    
                    </div>
                </div>
            </div>
            <!-- COMPANY DETAIL SECTION End -->  
            
            <!-- ABOUT COMPANY SECTION START -->
            <div class="section-full p-tb40 bg-gray">
                <div class="container">
                    <div class="row">
                        <div class="col-md-5 col-sm-5 col-xs-6 col-xs-100pc">
                            <div class="about-com-pic">
                                <img src="images/about-pic.jpg" alt="" class="img-responsive"/>
                            </div>
                        </div>
                        <div class="col-md-7 col-sm-7 col-xs-6 col-xs-100pc">
                            <div class="section-head text-left m-b0">
                                <h2>About GCRA </h2>
                                <div class="wt-separator-outer">
                                    <div class="wt-separator style-square">
                                        <span class="separator-left bg-secondary"></span>
                                        <span class="separator-right bg-secondary"></span>
                                    </div>
                                </div>
                                <p class="text-justify">We work towards a brighter future for the underrepresented communication scholars in the global south.Throughout the world, large numbers of communication scholars and practitioners are underrepresented in forums of international communications scholarship for reasons of geography, national security, ethnicity, economics and language.
                                </p>
                                <p class="text-justify">
                                The Global Communication Research Association (GCRA) seeks to provide a forum for those scholars and practitioners to be a part of the global communication community scholars and be able to express their research interests and best represent issues and problems of their countries. GCRA was founded on 26 September 2001 at a meeting in Sydney, Australia.
                                </p>
                                <p class="text-justify">The association of communication scholars will be low-cost conferences at physical locations and virtual settings.The association will also undertake research projects.</p>
                                <a class="m-b15 site-button m-r15" href="about.php">Read More</a>
                            </div>
                        </div>                        
                    </div>
                </div>
            </div>   
            <!-- ABOUT COMPANY SECTION END -->  
            
            <div class="section-full p-t30 p-b40 bg-primary">
                <div class="container">
                	<!-- TITTLE START -->
                    
                    <!-- TITLE END -->                	
                    <div class="row">
                        
                        <div class="col-md-7 col-sm-7 col-xs-12 col-xs-100pc">
                            <!-- ACCORDIAN  BG DARK -->
                            <div class="section-content">
                                <div class="wt-accordion acc-bg-dark" id="accordion9">
                                    <div class="panel wt-panel">
                                        <div class="acod-head acc-actives">
                                             <h6 class="acod-title text-uppercase">
                                                <a data-toggle="collapse" href="#collapseOne9" data-parent="#accordion9" ><i class="fa fa-globe"></i>
                                                    Our Mission
                                                    <span class="indicator"><i class="fa fa-plus"></i></span>
                                                </a>
                                             </h6>
                                        </div>
                                        <div id="collapseOne9" class="acod-body collapse in">
                                            <div class="acod-content font-14 p-tb30 text-white">Carry out actions regarding communication and media research, diffusion of knowledge and innovation within an inclusive population framework, prioritizing the less advantaged geographical and professional contexts in specific fields.</div>
                                        </div>
                                    </div>
                                    <div class="panel wt-panel">
                                        <div class="acod-head">
                                             <h6 class="acod-title text-uppercase">
                                                <a data-toggle="collapse" href="#collapseTwo9" class="collapsed" data-parent="#accordion9" ><i class="fa fa-binoculars"></i>
                                                Our Vision
                                                <span class="indicator"><i class="fa fa-plus"></i></span>
                                                </a>
                                             </h6>
                                        </div>
                                        <div id="collapseTwo9" class="acod-body collapse">
                                            <div class="acod-content font-14 p-tb30  text-white">Be a forum and an organization pursuing media, communication, publication and technological and virtual inclusion, particularly reaching out to underrepresented areas
of all five continents.</div>
                                        </div>
                                    </div>
                                    
                                </div>                                        
                            </div>
                        </div>
                        <div class="col-md-5 col-sm-5 col-xs-12 col-xs-100pc">
                            <!--Fade slider-->
                            <div class="owl-carousel about-us-carousel owl-btn-vertical-center owl-dots-bottom-center">
                            
                                <div class="item">
                                    <div class="aon-thum-bx">
                                        <img src="images/mission.jpg" alt="">
                                    </div>
                                </div>   
                                 <div class="item">
                                    <div class="aon-thum-bx">
                                        <img src="images/vision.jpg" alt="">
                                    </div>
                                </div>                                 
                            
                            </div>
                            <!--fade slider END-->
                        </div>
                    </div>
                </div>
            </div>                    

            <!-- LATEST PROJECT SECTION START -->
            <div class="section-full bg-white p-t30">
                <div class="container">
                	<div class="section-head text-center">
                    	<h2>Picture Gallery</h2>
                        <div class="wt-separator-outer m-b0">
                            <div class="wt-separator style-square">
                                <span class="separator-left bg-primary"></span>
                                <span class="separator-right bg-primary"></span>
                            </div>
                        </div>
                    </div>
                    <!-- PAGINATION TOP START -->
                    <div class="filter-wrap p-tb15">
                        <ul class="masonry-filter link-style center-align text-uppercase">
                            <li class="active"><a data-filter="*" href="#">All</a></li>
                            <li><a data-filter=".cat-1" href="#">Scholars</a></li>
                            <li><a data-filter=".cat-1" href="#">Researches</a></li>
                        </ul>
                    </div>
                    <!-- PAGINATION END -->
                    
                    <!-- GALLERY CONTENT START -->
                    <div class="row">
                        <div class="portfolio-wrap mfp-gallery no-col-gap">
                        
                    		<!-- COLUMNS 1 -->
                            <div class="masonry-item cat-1 col-lg-3 col-md-3 col-sm-6 col-xs-6">
                                <div class="wt-gallery-bx p-a15">
                                    <div class="wt-thum-bx wt-img-overlay5 wt-img-effect blurr">
                                        <a href="javascript:void(0);">
                                            <img src="images/gallery/pic1.jpg"  alt="">
                                        </a>
                                        <div class="overlay-bx">
                                            <div class="overlay-icon">
                                                <a href="images/gallery/pic1.jpg" class="mfp-link">
                                                    <i class="fa fa-arrows-alt wt-icon-box-xs"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 2 -->
                            <div class="masonry-item cat-2 col-lg-3 col-md-3 col-sm-6 col-xs-6">
                                <div class="wt-gallery-bx p-a15">
                                    <div class="wt-thum-bx wt-img-overlay5 wt-img-effect blurr">
                                        <a href="javascript:void(0);">
                                            <img src="images/gallery/pic2.jpg"  alt="">
                                        </a>
                                        <div class="overlay-bx">
                                            <div class="overlay-icon">
                                                <a href="images/gallery/pic2.jpg" class="mfp-link">
                                                    <i class="fa fa-arrows-alt wt-icon-box-xs"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 3 -->
                            <div class="masonry-item cat-3 col-lg-3 col-md-3 col-sm-6 col-xs-6">
                                <div class="wt-gallery-bx p-a15">
                                    <div class="wt-thum-bx wt-img-overlay5 wt-img-effect blurr">
                                        <a href="javascript:void(0);">
                                            <img src="images/gallery/pic3.jpg"  alt="">
                                        </a>
                                        <div class="overlay-bx">
                                            <div class="overlay-icon">
                                                <a href="images/gallery/pic3.jpg" class="mfp-link">
                                                    <i class="fa fa-arrows-alt wt-icon-box-xs"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 4 -->
                            <div class="masonry-item cat-4 col-lg-3 col-md-3 col-sm-6 col-xs-6">
                                <div class="wt-gallery-bx p-a15">
                                    <div class="wt-thum-bx wt-img-overlay5 wt-img-effect blurr">
                                        <a href="javascript:void(0);">
                                            <img src="images/gallery/pic4.jpg"  alt="">
                                        </a>
                                        <div class="overlay-bx">
                                            <div class="overlay-icon">
                                                <a href="images/gallery/pic4.jpg" class="mfp-link m-b15">
                                                    <i class="fa fa-arrows-alt wt-icon-box-xs"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 5 -->
                            <div class="masonry-item cat-5 col-lg-3 col-md-3 col-sm-6 col-xs-6">
                                <div class="wt-gallery-bx p-a15">
                                    <div class="wt-thum-bx wt-img-overlay5 wt-img-effect blurr">
                                        <a href="javascript:void(0);">
                                            <img src="images/gallery/pic5.jpg"  alt="">
                                        </a>
                                        <div class="overlay-bx">
                                            <div class="overlay-icon">
                                                <a href="images/gallery/pic5.jpg" class="mfp-link">
                                                    <i class="fa fa-arrows-alt wt-icon-box-xs"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 6 -->
                            <div class="masonry-item cat-4 col-lg-3 col-md-3 col-sm-6 col-xs-6">
                                <div class="wt-gallery-bx p-a15">
                                    <div class="wt-thum-bx wt-img-overlay5 wt-img-effect blurr">
                                        <a href="javascript:void(0);">
                                            <img src="images/gallery/pic6.jpg"  alt="">
                                        </a>
                                        <div class="overlay-bx">
                                            <div class="overlay-icon">
                                                <a href="images/gallery/pic6.jpg" class="mfp-link">
                                                    <i class="fa fa-arrows-alt wt-icon-box-xs"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 7 -->
                            <div class="masonry-item cat-3 col-lg-3 col-md-3 col-sm-6 col-xs-6">
                                <div class="wt-gallery-bx p-a15">
                                    <div class="wt-thum-bx wt-img-overlay5 wt-img-effect blurr">
                                        <a href="javascript:void(0);">
                                            <img src="images/gallery/pic7.jpg"  alt="">
                                        </a>
                                        <div class="overlay-bx">
                                            <div class="overlay-icon">
                                                <a href="images/gallery/pic7.jpg" class="mfp-link">
                                                    <i class="fa fa-arrows-alt wt-icon-box-xs"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 8 -->
                            <div class="masonry-item cat-2 col-lg-3 col-md-3 col-sm-6 col-xs-6">
                                <div class="wt-gallery-bx p-a15">
                                    <div class="wt-thum-bx wt-img-overlay5 wt-img-effect blurr">
                                        <a href="javascript:void(0);">
                                            <img src="images/gallery/pic8.jpg"  alt="">
                                        </a>
                                        <div class="overlay-bx">
                                            <div class="overlay-icon">
                                                <a  href="images/gallery/pic8.jpg" class="mfp-link">
                                                    <i class="fa fa-arrows-alt wt-icon-box-xs"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        
                        </div>
                    </div>
                    <!-- GALLERY CONTENT END -->
                    

                    <!-- PAGINATION START -->
                    <div class="text-center clearfix ">
                       <a class="m-b20 site-button button-md m-t30" href="">View All <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                    <!-- PAGINATION END -->                    
                    
                </div>
            </div>
            <!-- LATEST PROJECT SECTION END -->
            
            <!-- OUR TEAM MEMBER SECTION START -->
            <div class="section-full p-t30 p-b30 bg-gray">
                <div class="container">
                    <div class=" m-b0">
                        <!-- TITLE START -->
                        <div class="section-head text-center">
                           <h2>Executive Board</h2>
                           <div class="wt-separator-outer">
                               <div class="wt-separator style-square">
                                   <span class="separator-left bg-primary"></span>
                                   <span class="separator-right bg-primary"></span>
                               </div>
                           </div>
                           
                        </div>
                        <!-- TITLE END -->
                    </div> 
                    <div class="section-content">
                        <div class="row">
                        
                            <!-- COLUMNS 1 -->
                            <div class="col-md-3 col-sm-6 col-xs-6 col-xs-100pc m-tb15">
                                <div class="wt-team-one bg-white">
                                    <div class="wt-team-media p-a10 p-b0">
                                        <a href="javascript:void(0);"><img src="images/our-team/pic1.jpg" alt=""></a>
                                    </div>
                                    <div class="wt-team-info text-center bg-white p-a10">
                                        <h4 class="wt-team-title"><a href="javascript:void(0);">Dr. Diosnel Centurion (Paraguay) </a></h4>
                                        <p>President</p>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 2 -->
                            <div class="col-md-3 col-sm-6 col-xs-6 col-xs-100pc m-tb15">
                                <div class="wt-team-one bg-white">
                                    <div class="wt-team-media p-a10 p-b0">
                                        <a href="javascript:void(0);"><img src="images/our-team/pic1.jpg" alt=""></a>
                                    </div>
                                    <div class="wt-team-info text-center bg-white p-a10">
                                        <h4 class="wt-team-title"><a href="javascript:void(0);">BasyouniIbrahim Hamada (Qatar) </a></h4>
                                        <p>Secretary General</p>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 3 -->
                            <div class="col-md-3 col-sm-6 col-xs-6 col-xs-100pc m-tb15">
                                <div class="wt-team-one  bg-white">
                                    <div class="wt-team-media p-a10 p-b0">
                                        <a href="javascript:void(0);"><img src="images/our-team/pic1.jpg" alt=""></a>
                                    </div>
                                    <div class="wt-team-info text-center bg-white p-a10">
                                        <h4 class="wt-team-title"><a href="javascript:void(0);">Dr. Arul Aram (India)</a></h4>
                                        <p>Treasurer</p>
                                    </div>
                                </div>
                            </div>                            
                            <!-- COLUMNS 4 -->
                            <div class="col-md-3 col-sm-6 col-xs-6 col-xs-100pc m-tb15">
                                <div class="wt-team-one  bg-white">
                                    <div class="wt-team-media p-a10 p-b0">
                                        <a href="javascript:void(0);"><img src="images/our-team/pic1.jpg" alt=""></a>
                                    </div>
                                    <div class="wt-team-info text-center bg-white p-a10">
                                        <h4 class="wt-team-title"><a href="javascript:void(0);">Dr. Mira K Desai (India) </a></h4>
                                        <p>Vice President</p>
                                    </div>
                                </div>
                            </div>
                           
                            <div class="col-md-12 col-sm-12 col-xs-12 col-xs-100pc m-tb15 text-center">
                            <a class="m-b15 site-button button-md m-r15" href="executive-board.php">View All <i class="fa fa-arrow-circle-right"></i></a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
            <!-- OUR TEAM MEMBER SECTION END -->
            
            <!-- SECTION CONTENT WITH BACKGROUND -->
            <div class="section-full p-t40 p-b50 overlay-wraper bg-parallax" data-stellar-background-ratio="0.5" style="background-image:url(images/background/bg9.jpg); background-size:cover;">
                <div class="overlay-main bg-black opacity-07"></div>
                <div class="container">
                    <div class="section-head">
                        <h2 class=" text-white">GCRA Conferences</h2>
                    </div>
                	<!-- TABS NAV BG WITH CONTENT OUTLINE ON BACKGROUND -->
                    <div class="section-content">
                        <div class="wt-tabs border-top border bg-tabs has-bg">
                            <ul class="nav nav-tabs">
                                <li class="active"><a data-toggle="tab" href="#tab1">Latest Conference</a></li>
                                <li><a data-toggle="tab" href="#tab2"> Past Conferences</a></li>
                            </ul>
                            <div class="tab-content">
                            
                                <div id="tab1" class="tab-pane active">
                                    <h2 class="text-white m-t0 m-b20"> International Online Conference</h2>
                                	<p class="text-justify"><strong>International Online Conference</strong> on the theme 'Communication Research Trends in Time of the Pandemic: Implications for Theory Building and Policy Research' is to be held tentatively on <strong>10-11 June 2022.</strong></p>
                                    <h3 class="text-white">Call of Papers</h3>
                                    <p class="text-justify">The organizing committee of the Global Communication Research Organization (GCRA) is calling for abstract submissions. To present your research at the conference, your abstract must first pass through peer review and registration fees shall be paid.</p>
                                	<p class="text-justify">Covid-19 has affected the entire world, and we have all suffered together. But the experience of the pandemic has been different across the world. The pandemic has made us rethink our relationship with ourselves as well as the world around us.
Communication has taken new turns during this pandemic phase, and so has communication research. These need to be studied and documented, and in view of this, GCRA is organizing an online conference to highlight and capture the trends and changes in communication research ushered in by the global pandemic scenario.</p>

									<a class="m-b15 site-button button-md m-r15" href="upcoming-conference.php">Read More <i class="fa fa-arrow-circle-right"></i></a>
                                    
									
                                
                                </div>
                                
                                <div id="tab2" class="tab-pane">
                                    <h2 class="text-white m-t0 m-b20">GCRA Past Conferences</h2>
                                    <p class="text-justify">Our conferences are mindful of your budget, and our research efforts seek to empower
the underrepresented.</p>
									<p class="text-justify">GCRA has held conferences in Sydney, Australia (2001), Varanasi, India (2003),
Singapore (2004), Guangzhou, China (2005, 2011), Nakhon Ratchasima, Thailand (2006), Chennai, India (2009), Colombo, Sri Lanka (2014), Bengalaru, India (2016).</p>
                                    <div class="row">
                                    	<div class="col-md-4 col-sm-6 m-b20">
                                            <div class="pro_activitie">
                                                <div class="row">
                                                    <div class="">
                                                        <div class="calendar_tab">
                                                            <div class="date-part bgc1"> <span class="month">June</span>
                                                                <div class="date">10-11</div>
                                                                <div class="year">2022</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="pro-content"> <h4 class="">International Online Conference</h4>
                                                        <p>International Online Conference on Communication Research Trends in Time of
the Pandemic: Implications for Theory Building and Policy Research tentatively</p> <a href="#">Read more</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-sm-6 m-b20">
                                            <div class="pro_activitie">
                                                <div class="row">
                                                    <div class="">
                                                        <div class="calendar_tab">
                                                            <div class="date-part bgc1"> <span class="month">January</span>
                                                                <div class="date">5-7</div>
                                                                <div class="year">2016</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="pro-content"> <h4 class="">International Conference</h4>
                                                        <p>International Conference on Innovative Digital Applications for Sustainable
Development, in the Bengaluru, India.</p> <a href="#">Read more</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-sm-6 m-b20">
                                            <div class="pro_activitie">
                                                <div class="row">
                                                    <div class="">
                                                        <div class="calendar_tab">
                                                            <div class="date-part bgc1"> <span class="month">February</span>
                                                                <div class="date">14-16</div>
                                                                <div class="year">2016</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="pro-content"> <h4 class="">International Conference on Media in Transformation</h4>
                                                        <p>Exploring Role of ICT, Innovative Communications, and New Media in Colombo, Sri Lanka,.</p> <a href="#">Read more</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-sm-6 m-b20">
                                            <div class="pro_activitie">
                                                <div class="row">
                                                    <div class="">
                                                        <div class="calendar_tab">
                                                            <div class="date-part bgc1"> <span class="month">December</span>
                                                                <div class="date">2-4</div>
                                                                <div class="year">2011</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="pro-content"> <h4 class="">International Conference</h4>
                                                        <p> on Communication, Education, Development and Innovation from in Guangzhou, China.</p> <a href="#">Read more</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-sm-6 m-b20">
                                            <div class="pro_activitie">
                                                <div class="row">
                                                    <div class="">
                                                        <div class="calendar_tab">
                                                            <div class="date-part bgc1"> <span class="month">December</span>
                                                                <div class="date">9-11</div>
                                                                <div class="year">2009</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="pro-content"> <h4 class="">International Conference</h4>
                                                        <p> International Conference on Development Communication in the Era of
Globalization in Chennai, India.</p> <a href="#">Read more</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-sm-6 m-b20">
                                            <div class="pro_activitie">
                                                <div class="row">
                                                    <div class="">
                                                        <div class="calendar_tab">
                                                            <div class="date-part bgc1"> 
                                                                <div class="year">2006</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="pro-content"> <h4 class="">International Conference</h4>
                                                        <p> International Conference in Nakhon Ratchasima, Thailand, in 2006.</p>
                                                        <a href="#">Read more</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        
                                        
                                        
                                    </div>
                                    
                                    <a class="m-b15 site-button white button-md m-r15" href="past-conference.php">View All <i class="fa fa-arrow-circle-right"></i></a>
                                    
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- SECTION CONTENT END -->
                        
            <!-- OUR CLIENT SLIDER START -->
            <div class="section-full p-t30 p-b30">
                <div class="container">
                
                    <!-- TITLE START -->
                    <div class="section-head text-center">
                        <h2>Our Partners</h2>
                        <div class="wt-separator-outer">
                            <div class="wt-separator style-square">
                                <span class="separator-left bg-primary"></span>
                                <span class="separator-right bg-primary"></span>
                            </div>
                        </div>
                    </div>
                    <!-- TITLE END -->
                    
                    <!-- IMAGE CAROUSEL START -->
                    <div class="section-content">
                        <div class="owl-carousel client-logo-carousel">
                        
                            <!-- COLUMNS 1 --> 
                            <div class="item">
                                <div class="ow-client-logo">
                                    <div class="client-logo wt-img-effect on-color">
                                        <a href="#"><img src="images/client-logo/logo1.png" alt=""></a>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 2 --> 
                            <div class="item">
                                <div class="ow-client-logo">
                                    <div class="client-logo wt-img-effect on-color">
                                        <a href="#"><img src="images/client-logo/logo1.png" alt=""></a>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 3 --> 
                            <div class="item">
                                <div class="ow-client-logo">
                                    <div class="client-logo wt-img-effect on-color">
                                        <a href="#"><img src="images/client-logo/logo1.png" alt=""></a>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 4 --> 
                            <div class="item">
                                <div class="ow-client-logo">
                                    <div class="client-logo wt-img-effect on-color">
                                        <a href="#"><img src="images/client-logo/logo1.png" alt=""></a>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 5 --> 
                            <div class="item">
                                <div class="ow-client-logo">
                                    <div class="client-logo wt-img-effect on-color">
                                        <a href="#"><img src="images/client-logo/logo1.png" alt=""></a>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 6 --> 
                            <div class="item">
                                <div class="ow-client-logo">
                                    <div class="client-logo wt-img-effect on-color">
                                        <a href="#"><img src="images/client-logo/logo1.png" alt=""></a>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 7 --> 
                            <div class="item">
                                <div class="ow-client-logo">
                                    <div class="client-logo wt-img-effect on-color">
                                        <a href="#"><img src="images/client-logo/logo1.png" alt=""></a>
                                    </div>
                                </div>
                            </div>
                            <!-- COLUMNS 8 --> 
                            <div class="item">
                                <div class="ow-client-logo">
                                    <div class="client-logo wt-img-effect on-color">
                                        <a href="#"><img src="images/client-logo/logo1.png" alt=""></a>
                                    </div>
                                </div>
                            </div>
                                               
                        
                        </div>
                    </div>
                    <!-- IMAGE CAROUSEL START -->
                </div>
            
            </div>
            <!-- OUR CLIENT SLIDER END --> 
              
        </div>
        <!-- CONTENT END -->
        
        
		<?php include("include/footer.php");?>
        
        
    </div>
 

<!-- JAVASCRIPT  FILES ========================================= --> 
<script type="text/javascript"  src="js/jquery-1.12.4.min.js"></script><!-- JQUERY.MIN JS -->
<script type="text/javascript"  src="js/bootstrap.min.js"></script><!-- BOOTSTRAP.MIN JS -->
<script type="text/javascript"  src="js/bootstrap-select.min.js"></script><!-- FORM JS -->
<script type="text/javascript"  src="js/jquery.bootstrap-touchspin.min.js"></script><!-- FORM JS -->
<script type="text/javascript"  src="js/magnific-popup.min.js"></script><!-- MAGNIFIC-POPUP JS -->
<script type="text/javascript"  src="js/waypoints.min.js"></script><!-- WAYPOINTS JS -->
<script type="text/javascript"  src="js/counterup.min.js"></script><!-- COUNTERUP JS -->
<script type="text/javascript"  src="js/waypoints-sticky.min.js"></script><!-- COUNTERUP JS -->
<script type="text/javascript" src="js/isotope.pkgd.min.js"></script><!-- MASONRY  -->
<script type="text/javascript"  src="js/owl.carousel.min.js"></script><!-- OWL  SLIDER  -->
<script type="text/javascript"  src="js/stellar.min.js"></script><!-- PARALLAX BG IMAGE   --> 
<script type="text/javascript"  src="js/scrolla.min.js"></script><!-- ON SCROLL CONTENT ANIMTE   -->
<script type="text/javascript"  src="js/custom.js"></script><!-- CUSTOM FUCTIONS  -->
<!-- REVOLUTION JS FILES -->
<script type="text/javascript" src="plugins/revolution/revolution/js/jquery.themepunch.tools.min.js"></script>
<script type="text/javascript" src="plugins/revolution/revolution/js/jquery.themepunch.revolution.min.js"></script>

<!-- SLIDER REVOLUTION 5.0 EXTENSIONS  (Load Extensions only on Local File Systems !  The following part can be removed on Server for On Demand Loading) -->	
<script type="text/javascript" src="plugins/revolution/revolution/js/extensions/revolution.extension.actions.min.js"></script>
<script type="text/javascript" src="plugins/revolution/revolution/js/extensions/revolution.extension.carousel.min.js"></script>
<script type="text/javascript" src="plugins/revolution/revolution/js/extensions/revolution.extension.kenburn.min.js"></script>
<script type="text/javascript" src="plugins/revolution/revolution/js/extensions/revolution.extension.layeranimation.min.js"></script>
<script type="text/javascript" src="plugins/revolution/revolution/js/extensions/revolution.extension.migration.min.js"></script>
<script type="text/javascript" src="plugins/revolution/revolution/js/extensions/revolution.extension.navigation.min.js"></script>
<script type="text/javascript" src="plugins/revolution/revolution/js/extensions/revolution.extension.parallax.min.js"></script>
<script type="text/javascript" src="plugins/revolution/revolution/js/extensions/revolution.extension.slideanims.min.js"></script>
<script type="text/javascript" src="plugins/revolution/revolution/js/extensions/revolution.extension.video.min.js"></script>

<!-- REVOLUTION SLIDER SCRIPT FILES -->
<script type="text/javascript" src="js/rev-script-2.js"></script>






</body>
</html>
