<!doctype html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link href="css/all.css" rel="stylesheet">
	<link rel="stylesheet" href="css/elements.css">
	<link rel="stylesheet" href="webfonts/fonts/flaticon.css">
	<link rel="shortcut icon" href="images/favicon.png" type="image/x-icon">
	<link rel="icon" href="images/favicon.png" type="image/x-icon">
	<title>Promoting Energy Efficiency and Renewable Energy in Selected MSME Clusters in India | About UNIDO</title>
</head>

<body class="gef4">
	<?php include( 'include/header1.php'); ?>
    <section class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="inner-content clearfix">
                        <div class="title_breadcrumb float-left">
                            <h1>About UNIDO</h1>
                        </div>
                        <div class="breadcrumb-menu float-right">
                            <ul class="clearfix">
                                <li><a href="sample1.php">GEF4</a></li>
                                <li class="active">About UNIDO</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
	
	
	
	<section class="pb-4 mt-4">
    <div class="container">
      <div class="row">
        
        <div class="col-lg-12 col-12">
          <div class="title text-left">
            <h2 class="text-justify">UNIDO is the specialized agency of the United Nations that promotes industrial development for poverty reduction, inclusive globalization and environmental sustainability.</h2>
          </div>
          <img src="https://www.unido.org/sites/default/files/inline-images/inbrief.png" class="float-left img-fluid mr-3 mb-3" alt="" style="max-width:450px;">
         
          
          <p class="text-justify text-dark">As of 1 April 2019, <a href="/member-states-list">170 States are Members of UNIDO</a>. They regularly discuss and decide UNIDO's guiding principles and policies in the sessions of <a href="/resources/policymaking-organs-and-other-related-bodies">the Policymaking Organs</a>.</p>
          
          <p class="text-justify text-dark">The mission of the United Nations Industrial Development Organization (UNIDO), as described in the&nbsp;<a href="https://www.unido.org/sites/default/files/2014-04/Lima_Declaration_EN_web_0.pdf" rel="noopener noreferrer" target="_blank"><i>Lima Declaration</i></a><i>&nbsp;</i>adopted at the fifteenth session of the UNIDO General Conference in 2013, as well as the&nbsp;<a href="https://www.unido.org/sites/default/files/files/2019-11/UNIDO_Abu_Dhabi_Declaration.pdf" rel="noopener noreferrer" target="_blank"><i>Abu Dhabi Declaration</i></a>&nbsp;adopted at the eighteenth session of the UNIDO General Conference in 2019, is to promote and accelerate&nbsp;<a href="https://www.unido.org/sites/default/files/2014-03/ISID_Brochure_web_singlesided_12_03_0.pdf" rel="noopener noreferrer" target="_blank">inclusive and sustainable industrial development</a>&nbsp;(ISID)&nbsp;in&nbsp;Member States.</p>
          
          <p  class="text-justify text-dark">The relevance of ISID as an integrated approach to all three pillars of sustainable development is recognized by the 2030 Agenda for Sustainable Development and the related Sustainable Development Goals (SDGs), which will frame United Nations and country efforts towards sustainable development in the next ten&nbsp;years. <a href="/who-we-are/unido-sustainable-development-goals" title="UNIDO &amp;amp; Sustainable Development Goals">UNIDO's mandate is fully recognized in SDG-9</a>, which calls to "Build resilient infrastructure, promote inclusive and sustainable industrialization and foster innovation". The relevance of ISID, however, applies in greater or lesser extent to all SDGs.</p>
          
          <p class="text-justify text-dark">Accordingly, the Organization's programmatic focus is structured, as detailed in the <a href="/sites/default/files/files/2019-01/MTPF_Brochure_23-06-2017.pdf">Organization's Medium-Term Programme Framework 2018-2021</a>,&nbsp;in four strategic priorities:</p>
          
          <ul class="bullet_icons din">
            <li><a href="/node/138" target="">Creating shared prosperity</a></li>
            <li><a href="/node/11" target="">Advancing economic competitiveness</a></li>
            <li><a href="/node/158" target="">Safeguarding the environment</a></li>
            <li><a href="https://www.unido.org/strengthening-knowledge-and-institutions-0 ">Strengthening knowledge and institutions</a></li>
          </ul>
          
          <p  class="text-justify text-dark">Each of these programmatic fields of activity contains a number of individual programmes, which are implemented in a holistic manner to achieve effective outcomes and impacts through UNIDO's four enabling functions: (i) technical cooperation; (ii) analytical and research functions and policy advisory services; (iii) normative functions and standards and quality-related activities; and (iv) convening and partnerships for knowledge transfer, networking and industrial cooperation.</p>
          
          <p class="text-justify text-dark">In carrying out the core requirements of its mission, UNIDO has considerably increased its technical services over the past ten years. At the same time, it has also substantially increased its mobilization of financial resources, testifying to the growing international recognition of the Organization as an effective provider of catalytic industrial development services.</p>
          
          
          
          
          
          
          
          
          
          
          
          
        </div>
      </div>
      
    </div>
  </section>
	
    

    
    
    
	

	<!--Newsletter Start-->
	<div class="newsletter-wrap wow fadeInUp">
		<div class="container">
			<div class="row">
				<div class="col-lg-12">
				
				</div>
				
			</div>
		</div>
	</div>
	<!--Newsletter End-->
	<?php include( 'include/footer1.php'); ?>
	<script src="js/all.js"></script>
	<script src="js/script.js"></script>
</body>

</html>