<!doctype html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link href="css/all.css" rel="stylesheet">
	<link rel="stylesheet" href="css/elements.css">
	<link rel="stylesheet" href="webfonts/fonts/flaticon.css">
	<link rel="shortcut icon" href="images/favicon.png" type="image/x-icon">
	<link rel="icon" href="images/favicon.png" type="image/x-icon">
	<title>Promoting Energy Efficiency and Renewable Energy in Selected MSME Clusters in India | About GEF</title>
</head>

<body class="gef4">
	<?php include( 'include/header1.php'); ?>
    <section class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="inner-content clearfix">
                        <div class="title_breadcrumb float-left">
                            <h1>About GEF</h1>
                        </div>
                        <div class="breadcrumb-menu float-right">
                            <ul class="clearfix">
                                <li><a href="sample1.php">GEF4</a></li>
                                <li class="active">About GEF</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
	<section class="breadcrumb-area mt-3">
		<div class="container">
			<div class="row">
				<div class="col-xl-12">
					<div class="inner-content clearfix pt-2 pb-2">
						<div class="title_breadcrumb">
							<h3 class="text-white text-center">Promoting Energy Efficiency and Renewable Energy in Selected MSME Clusters in India</h3>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	
	
	<section class="gef_sections">
		<div class="container pt-4 pb-4 ">
			<div class="row">
				<div class="col-md-12 col-12">
					<div class="sec-title wow fadeInUp" data-wow-delay="300ms" data-wow-duration="2000ms">
						<!-- <div class="sub-title primary">MSME's</div> -->
						<h2 class="title inner-title mb-20 mb-3">Project Background </h2>
					</div>
					<div class="project_bg">
						<div class="project_info">
							
							<p class="text-justify">The United Nations Industrial Development Organization (UNIDO), in collaboration with the Bureau of Energy Efficiency (BEE), a statutory body under the Ministry of Power, Government of India, is executing a Global Environment Facility (GEF) funded national project titled 'Promoting energy efficiency and renewable energy in selected MSME clusters in India'. The project aims to develop and promote a market environment for introducing energy efficiency (EE) and enhanced use of renewable energy (RE) technologies in process applications in selected energy intensive industrial clusters, comprising micro, small and medium enterprises (MSMEs). The project is supported by the Ministry of Micro, Small and Medium Enterprises (MoMSME) and Ministry of New and Renewable Energy (MNRE). The project was operational in 12 MSME clusters across India in five sectors namely Brass (Jamnagar); Ceramics (Khurja, Thangadh and Morbi); Dairy (Gujarat, Sikkim and Kerala); Foundry (Belgaum, Coimbatore and Indore); Hand Tools (Jalandhar and Nagaur) in its first phase. The Project has now scaled-up and expanded its activities to additional 11 new clusters, namely in Dairy (Tamil Nadu, Odisha, Madhya Pradesh, Andhra Pradesh & Telangana, Haryana, Maharashtra & Punjab), Foundry (Ahmedabad & Howrah), Ceramic (Himmatnagar), Mixed Cluster (Indore & Sikkim) to reach out to MSME's at national level.</p>
<div class="clearfix"></div>
							<p class="text-justify"><span style="font-weight: 700;">The key components of the project include:</span> :
								<ul class="bullet_icons din">
									<li>Increasing capacity of suppliers of EE/RE product suppliers / service providers / finance providers</li>
									<li>Increasing the level of end user demand and implementation of EE and RE technologies and practices by MSMEs.</li>
									<li>Scaling up of the project to more clusters across India.</li>
									<li>Strengthening policy, institutional and decision-making frameworks.</li>									
								</ul>
							</p>
						</div>
					</div>
				</div>
                <div class="col-md-12">
                	<img src="images/map.png" style="width:100%; max-width:750px;" alt="" class="float-none">
                    <img src="images/markers.png" class="img-fluid" alt="">
                </div>
                
			</div>
		</div>
	</section>
	
    

    
    
    
	

	<!--Newsletter Start-->
	<div class="newsletter-wrap wow fadeInUp">
		<div class="container">
			<div class="row">
				<div class="col-lg-12">
				
				</div>
				
			</div>
		</div>
	</div>
	<!--Newsletter End-->
	<?php include( 'include/footer1.php'); ?>
	<script src="js/all.js"></script>
	<script src="js/script.js"></script>
</body>

</html>