<!DOCTYPE html>
<html data-bs-theme="light" lang="en-US" dir="ltr">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Colab - Innovation Space</title>
  <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicons/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicons/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicons/favicon-16x16.png">
  <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicons/favicon.ico">
  <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons" />
  <meta name="theme-color" content="#ffffff">
  <script src="assets/js/config.js"></script>

  <script src="vendors/simplebar/simplebar.min.js"></script>

  <link href="vendors/simplebar/simplebar.min.css" rel="stylesheet">
  <link href="assets/css/theme.css" rel="stylesheet" id="style-default">
  <link href="assets/css/user.css" rel="stylesheet" id="user-style-default">

</head>


<body>

  <!-- ===============================================-->
  <!--    Main Content-->
  <!-- ===============================================-->
  <main class="main" id="top">
    <div class="container-fluid" data-layout="container">
      <?php include('includes/header.php'); ?>
      <div class="breadcrumb-conatainer">
        <div class="breadcrumb-title">
          <h4>Global South Peer-to-Peer Innovation Space</h4>
        </div>
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb breadcrumb-default">
            <li class="breadcrumb-item"><a href="#"><i class="fa fa-home"></i></a></li>
            <li class="breadcrumb-item" aria-current="page">Innovation Space</li>
            <li class="breadcrumb-item active" aria-current="page">Innovation Space</li>
          </ol>
        </nav>
      </div>
      <div class="content">
        <div class="row g-3 mb-3">
          <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3 ps-lg-3">
            <div class="card overflow-hidden shadow-none border" style="min-width: 12rem">
              <div class="bg-holder bg-card" style="background-image:url(assets/img/bg/corner-1.png);">
              </div>
              <!--/.bg-holder-->

              <div class="card-body position-relative">
                <h6>Projects<span class="badge badge-subtle-warning rounded-pill ms-2">-0.23%</span></h6>
                <div class="display-4 fs-4 mb-2 fw-normal font-sans-serif text-warning" data-countup="{&quot;endValue&quot;:58.386,&quot;decimalPlaces&quot;:2,&quot;suffix&quot;:&quot;k&quot;}">580,123</div><a class="fw-semi-bold fs--1 text-nowrap text-primary" href="#">See all<svg class="svg-inline--fa fa-angle-right fa-w-8 ms-1" data-fa-transform="down-1" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="angle-right" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512" data-fa-i2svg="" style="transform-origin: 0.25em 0.5625em;">
                    <g transform="translate(128 256)">
                      <g transform="translate(0, 32)  scale(1, 1)  rotate(0 0 0)">
                        <path fill="currentColor" d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z" transform="translate(-128 -256)"></path>
                      </g>
                    </g>
                  </svg><!-- <span class="fas fa-angle-right ms-1" data-fa-transform="down-1"></span> Font Awesome fontawesome.com --></a>
              </div>
            </div>
          </div>
          <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3 ps-lg-3">
            <div class="card overflow-hidden shadow-none border" style="min-width: 12rem">
              <div class="bg-holder bg-card" style="background-image:url(assets/img/bg/corner-2.png);">
              </div>
              <!--/.bg-holder-->

              <div class="card-body position-relative">
                <h6>Funded Collaborations<span class="badge badge-subtle-success rounded-pill ms-2">9.54%</span></h6>
                <div class="display-4 fs-4 mb-2 fw-normal font-sans-serif" data-countup="{&quot;endValue&quot;:23.434,&quot;decimalPlaces&quot;:2,&quot;suffix&quot;:&quot;k&quot;}">$43,594</div><a class="fw-semi-bold fs--1 text-nowrap text-primary" href="#">Statistics<svg class="svg-inline--fa fa-angle-right fa-w-8 ms-1" data-fa-transform="down-1" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="angle-right" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512" data-fa-i2svg="" style="transform-origin: 0.25em 0.5625em;">
                    <g transform="translate(128 256)">
                      <g transform="translate(0, 32)  scale(1, 1)  rotate(0 0 0)">
                        <path fill="currentColor" d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z" transform="translate(-128 -256)"></path>
                      </g>
                    </g>
                  </svg><!-- <span class="fas fa-angle-right ms-1" data-fa-transform="down-1"></span> Font Awesome fontawesome.com --></a>
              </div>
            </div>
          </div>
          <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3 ps-lg-3">
            <div class="card overflow-hidden shadow-none border" style="min-width: 12rem">
              <div class="bg-holder bg-card" style="background-image:url(assets/img/bg/corner-1.png);">
              </div>
              <!--/.bg-holder-->

              <div class="card-body position-relative">
                <h6>Successful<span class="badge badge-subtle-warning rounded-pill ms-2">-0.23%</span></h6>
                <div class="display-4 fs-4 mb-2 fw-normal font-sans-serif text-success" data-countup="{&quot;endValue&quot;:58.386,&quot;decimalPlaces&quot;:2,&quot;suffix&quot;:&quot;k&quot;}">514,242</div><a class="fw-semi-bold fs--1 text-nowrap text-primary" href="#">See all<svg class="svg-inline--fa fa-angle-right fa-w-8 ms-1" data-fa-transform="down-1" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="angle-right" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512" data-fa-i2svg="" style="transform-origin: 0.25em 0.5625em;">
                    <g transform="translate(128 256)">
                      <g transform="translate(0, 32)  scale(1, 1)  rotate(0 0 0)">
                        <path fill="currentColor" d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z" transform="translate(-128 -256)"></path>
                      </g>
                    </g>
                  </svg><!-- <span class="fas fa-angle-right ms-1" data-fa-transform="down-1"></span> Font Awesome fontawesome.com --></a>
              </div>
            </div>
          </div>
          <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3 ps-lg-3">
            <div class="card overflow-hidden shadow-none border" style="min-width: 12rem">
              <div class="bg-holder bg-card" style="background-image:url(assets/img/bg/corner-2.png);">
              </div>
              <!--/.bg-holder-->

              <div class="card-body position-relative">
                <h6>Revenue<span class="badge badge-subtle-success rounded-pill ms-2">9.54%</span></h6>
                <div class="display-4 fs-4 mb-2 fw-normal font-sans-serif" data-countup="{&quot;endValue&quot;:23.434,&quot;decimalPlaces&quot;:2,&quot;suffix&quot;:&quot;k&quot;}">$43,594</div><a class="fw-semi-bold fs--1 text-nowrap text-primary" href="#">Statistics<svg class="svg-inline--fa fa-angle-right fa-w-8 ms-1" data-fa-transform="down-1" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="angle-right" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512" data-fa-i2svg="" style="transform-origin: 0.25em 0.5625em;">
                    <g transform="translate(128 256)">
                      <g transform="translate(0, 32)  scale(1, 1)  rotate(0 0 0)">
                        <path fill="currentColor" d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z" transform="translate(-128 -256)"></path>
                      </g>
                    </g>
                  </svg><!-- <span class="fas fa-angle-right ms-1" data-fa-transform="down-1"></span> Font Awesome fontawesome.com --></a>
              </div>
            </div>
          </div>
        </div>


        <div class="row g-3 mb-3">
          <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3 ps-lg-3">
            <div class="card border shadow-none">
              <div class="card-head bg-light p-2">
                <h6>Filters</h6>
              </div>
              <div class="card-body p-2">
                <div class="mb-3">
                  <label class="form-label" for="exampleFormControlInput1">Category</label>
                  <select class="form-select" aria-label="Default select example">
                    <option selected="">Production, Agregation</option>
                    <option value="1">One</option>
                    <option value="2">Two</option>
                    <option value="3">Three</option>
                  </select>
                </div>
                <div class="mb-3">
                  <label class="form-label" for="exampleFormControlInput1">Status</label>
                  <select class="form-select" aria-label="Default select example">
                    <option selected="">None</option>
                    <option value="1">One</option>
                    <option value="2">Two</option>
                    <option value="3">Three</option>
                  </select>
                </div>
                <div class="mb-3">
                  <label class="form-label" for="exampleFormControlInput1">Status</label>
                  <select class="form-select" aria-label="Default select example">
                    <option selected="">None</option>
                    <option value="1">One</option>
                    <option value="2">Two</option>
                    <option value="3">Three</option>
                  </select>
                </div>
                <div class="mb-3">
                  <label class="form-label" for="exampleFormControlInput1">Country</label>
                  <select class="form-select" aria-label="Default select example">
                    <option selected="">Production, Agregation</option>
                    <option value="1">One</option>
                    <option value="2">Two</option>
                    <option value="3">Three</option>
                  </select>
                </div>
                <div class="mb-2">
                  <button class="btn bg-light rounded-pill me-1 mb-1 text-muted w-100" type="button">Apply Filters</button>
                </div>
                <div class="mb-1">
                  <button class="btn me-1 mb-1 text-danger w-100" type="button">Remove Filters</button>
                </div>
              </div>
            </div>
          </div>
          <div class="col-sm-9">
            <div class="card mb-3 shadow-none border" id="customersTable" data-list="{&quot;valueNames&quot;:[&quot;name&quot;,&quot;email&quot;,&quot;phone&quot;,&quot;address&quot;,&quot;joined&quot;],&quot;page&quot;:10,&quot;pagination&quot;:true}">
              <div class="card-header">
                <div class="row">
                  <div class="col-12 d-flex align-items-center pe-0">
                    <h5 class="fs-0 mb-0 text-nowrap py-2 py-xl-0">Collaborations</h5>
                    <form class="position-relative ms-3">
                      <input class="form-control form-control-sm search-input lh-1 rounded-2 ps-4" type="search" placeholder="Search by tickets name" aria-label="Search">
                      <div class="position-absolute top-50 start-0 translate-middle-y ms-2"><svg class="svg-inline--fa fa-search fa-w-16 text-400 fs--1" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="search" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" data-fa-i2svg="">
                          <path fill="currentColor" d="M505 442.7L405.3 343c-4.5-4.5-10.6-7-17-7H372c27.6-35.3 44-79.7 44-128C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c48.3 0 92.7-16.4 128-44v16.3c0 6.4 2.5 12.5 7 17l99.7 99.7c9.4 9.4 24.6 9.4 33.9 0l28.3-28.3c9.4-9.4 9.4-24.6.1-34zM208 336c-70.7 0-128-57.2-128-128 0-70.7 57.2-128 128-128 70.7 0 128 57.2 128 128 0 70.7-57.2 128-128 128z"></path>
                        </svg><!-- <span class="fas fa-search text-400 fs--1"></span> Font Awesome fontawesome.com --></div>
                    </form>
                    <div class="d-flex ms-auto"><a class="btn btn-link btn-sm text-400 px-1 border" href="innovation-space.php" data-bs-toggle="tooltip" data-bs-placement="top" aria-label="List View" data-bs-original-title="List View">
                        <span class="material-icons text-muted">view_agenda</span>
                        <!-- <span class="fas fa-th fs-1" data-fa-transform="down-1"></span> Font Awesome fontawesome.com --></a><a class="btn btn-link btn-sm px-1 text-400 border me-1" href="innovation-space-card.php" data-bs-toggle="tooltip" data-bs-placement="top" aria-label="Grid View" data-bs-original-title="Grid View">
                        <span class="material-icons text-black">dashboard</span><!-- <span class="fas fa-list-ul fs-1" data-fa-transform="down-1"></span> Font Awesome fontawesome.com --></a></div>
                  </div>
                  <div class="col-8 col-sm-auto text-end ps-2">
                    <div class="d-none" id="table-customers-actions">
                      <div class="d-flex">
                        <select class="form-select form-select-sm" aria-label="Bulk actions">
                          <option selected="">Bulk actions</option>
                          <option value="Refund">Refund</option>
                          <option value="Delete">Delete</option>
                          <option value="Archive">Archive</option>
                        </select>
                        <button class="btn btn-falcon-default btn-sm ms-2" type="button">Apply</button>
                      </div>
                    </div>
                    <div id="table-customers-replace-element">

                    </div>
                  </div>
                </div>
              </div>
              <div class="card-body" style="padding: 0px 10px;">
                <div class="row g-3 mb-3">
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Alpha Romeo Corp</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/south-africa.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">S. Africa</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">ABC Company</h5>
                              <span class="badge fs--1 badge-subtle-warning mt-2">Stage 2</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/united-states.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">US</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Social Well</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/united-kingdom.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">UK</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Alpha Romeo Corp</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/south-africa.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">South Africa</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="row g-3 mb-3">
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Alpha Romeo Corp</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/south-africa.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">S. Africa</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">ABC Company</h5>
                              <span class="badge fs--1 badge-subtle-warning mt-2">Stage 2</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/united-states.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">US</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Social Well</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/united-kingdom.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">UK</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Alpha Romeo Corp</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/south-africa.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">South Africa</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="row g-3 mb-3">
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Alpha Romeo Corp</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/south-africa.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">S. Africa</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">ABC Company</h5>
                              <span class="badge fs--1 badge-subtle-warning mt-2">Stage 2</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/united-states.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">US</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Social Well</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/united-kingdom.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">UK</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Alpha Romeo Corp</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/south-africa.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">South Africa</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="row g-3 mb-3">
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Alpha Romeo Corp</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/south-africa.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">S. Africa</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">ABC Company</h5>
                              <span class="badge fs--1 badge-subtle-warning mt-2">Stage 2</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/united-states.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">US</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Social Well</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/united-kingdom.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">UK</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Alpha Romeo Corp</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/south-africa.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">South Africa</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="row g-3">
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Alpha Romeo Corp</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/south-africa.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">S. Africa</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">ABC Company</h5>
                              <span class="badge fs--1 badge-subtle-warning mt-2">Stage 2</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/united-states.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">US</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Social Well</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/united-kingdom.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">UK</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-xl-3 col-xxl-3 mb-3">
                    <div class="card border shadow-none" style="">
                      <div class="card-body position-relative" style="padding: 10px 10px;">

                        <div class="name align-middle">
                          <div class="d-flex align-items-center">
                            <div class="avatar avatar-xl me-2">
                              <div class="avatar-name rounded-circle no-image-gradient"><span></span></div>
                            </div>
                            <div class="">
                              <h5 class="mb-0 fs--1">Alpha Romeo Corp</h5>
                              <span class="badge fs--1 badge-subtle-success mt-2">Stage 1</span>
                            </div>

                          </div>
                          <div class="d-flex align-items-center mt-2">
                            <div class="me-2">
                              <p class="mb-0 fs--1 text-primary">Production, Agregation</p>
                            </div>
                            <div class="d-flex align-items-center">
                              <div class="avatar avatar-xl me-2">
                                <img class="" src="assets/img/bg/south-africa.png" alt="">

                              </div>
                              <div class="">
                                <p class="mb-0 fs--1 text-primary">South Africa</p>
                              </div>
                            </div>
                          </div>
                          <div class="mt-2 d-flex align-items-center">
                            <span class="me-2 fs--1 mb-0">Active:</span>
                            <p class="mb-0 fs--1 text-primary"> 10,231,231</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>


              <div class="card-footer d-flex align-items-center justify-content-center">
                <button class="btn btn-sm btn-falcon-default me-1 disabled" type="button" title="Previous" data-list-pagination="prev" disabled=""><svg class="svg-inline--fa fa-chevron-left fa-w-10" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="chevron-left" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" data-fa-i2svg="">
                    <path fill="currentColor" d="M34.52 239.03L228.87 44.69c9.37-9.37 24.57-9.37 33.94 0l22.67 22.67c9.36 9.36 9.37 24.52.04 33.9L131.49 256l154.02 154.75c9.34 9.38 9.32 24.54-.04 33.9l-22.67 22.67c-9.37 9.37-24.57 9.37-33.94 0L34.52 272.97c-9.37-9.37-9.37-24.57 0-33.94z"></path>
                  </svg><!-- <span class="fas fa-chevron-left"></span> Font Awesome fontawesome.com --></button>
                <ul class="pagination mb-0">
                  <li class="active"><button class="page" type="button" data-i="1" data-page="10">1</button></li>
                  <li><button class="page" type="button" data-i="2" data-page="10">2</button></li>
                  <li><button class="page" type="button" data-i="3" data-page="10">3</button></li>
                </ul>
                <button class="btn btn-sm btn-falcon-default ms-1" type="button" title="Next" data-list-pagination="next"><svg class="svg-inline--fa fa-chevron-right fa-w-10" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="chevron-right" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" data-fa-i2svg="">
                    <path fill="currentColor" d="M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373-9.373 24.569-9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z"></path>
                  </svg><!-- <span class="fas fa-chevron-right"></span> Font Awesome fontawesome.com --></button>
              </div>
            </div>
          </div>
        </div>
      </div>


      <?php include('includes/footer.php'); ?>
      <div class="modal fade" id="authentication-modal" tabindex="-1" role="dialog" aria-labelledby="authentication-modal-label" aria-hidden="true">
        <div class="modal-dialog mt-6" role="document">
          <div class="modal-content border-0">
            <div class="modal-header px-5 position-relative modal-shape-header bg-shape">
              <div class="position-relative z-1" data-bs-theme="light">
                <h4 class="mb-0 text-white" id="authentication-modal-label">Register</h4>
                <p class="fs--1 mb-0 text-white">Please create your free Falcon account</p>
              </div>
              <button class="btn-close btn-close-white position-absolute top-0 end-0 mt-2 me-2" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body py-4 px-5">
              <form>
                <div class="mb-3">
                  <label class="form-label" for="modal-auth-name">Name</label>
                  <input class="form-control" type="text" autocomplete="on" id="modal-auth-name" />
                </div>
                <div class="mb-3">
                  <label class="form-label" for="modal-auth-email">Email address</label>
                  <input class="form-control" type="email" autocomplete="on" id="modal-auth-email" />
                </div>
                <div class="row gx-2">
                  <div class="mb-3 col-sm-6">
                    <label class="form-label" for="modal-auth-password">Password</label>
                    <input class="form-control" type="password" autocomplete="on" id="modal-auth-password" />
                  </div>
                  <div class="mb-3 col-sm-6">
                    <label class="form-label" for="modal-auth-confirm-password">Confirm Password</label>
                    <input class="form-control" type="password" autocomplete="on" id="modal-auth-confirm-password" />
                  </div>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="checkbox" id="modal-auth-register-checkbox" />
                  <label class="form-label" for="modal-auth-register-checkbox">I accept the <a href="#!">terms </a>and <a href="#!">privacy policy</a></label>
                </div>
                <div class="mb-3">
                  <button class="btn btn-primary d-block w-100 mt-3" type="submit" name="submit">Register</button>
                </div>
              </form>
              <div class="position-relative mt-5">
                <hr />
                <div class="divider-content-center">or register with</div>
              </div>
              <div class="row g-2 mt-2">
                <div class="col-sm-6"><a class="btn btn-outline-google-plus btn-sm d-block w-100" href="#"><span class="fab fa-google-plus-g me-2" data-fa-transform="grow-8"></span> google</a></div>
                <div class="col-sm-6"><a class="btn btn-outline-facebook btn-sm d-block w-100" href="#"><span class="fab fa-facebook-square me-2" data-fa-transform="grow-8"></span> facebook</a></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>
  <!-- ===============================================-->
  <!--    End of Main Content-->
  <!-- ===============================================-->





  <!-- ===============================================-->
  <!--    JavaScripts-->
  <!-- ===============================================-->
  <script src="vendors/jquery/jquery.min.js"></script>
  <script src="vendors/popper/popper.min.js"></script>
  <script src="vendors/bootstrap/bootstrap.min.js"></script>
  <script src="vendors/anchorjs/anchor.min.js"></script>
  <script src="vendors/is/is.min.js"></script>
  <script src="vendors/echarts/echarts.min.js"></script>
  <script src="vendors/fontawesome/all.min.js"></script>
  <script src="vendors/lodash/lodash.min.js"></script>
  <script src="https://polyfill.io/v3/polyfill.min.js?features=window.scroll"></script>
  <script src="vendors/list.js/list.min.js"></script>
  <script src="vendors/magnific-popup/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/theme.js"></script>

</body>

</html>