<!DOCTYPE html>
<html data-bs-theme="light" lang="en-US" dir="ltr">

  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Colab - Home</title>
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicons/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicons/favicon-16x16.png">
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicons/favicon.ico">
    <meta name="theme-color" content="#ffffff">
    <script src="assets/js/config.js"></script>
	  
    <script src="vendors/simplebar/simplebar.min.js"></script>
	  
    <link href="vendors/simplebar/simplebar.min.css" rel="stylesheet">
    <link href="assets/css/theme.css" rel="stylesheet" id="style-default">
    <link href="assets/css/user.css" rel="stylesheet" id="user-style-default">
    
  </head>


  <body>

    <!-- ===============================================-->
    <!--    Main Content-->
    <!-- ===============================================-->
    <main class="main" id="top">
      <div class="container-fluid" data-layout="container">
        <?php include('includes/header.php');?>
        
        <div class="content ps-md-4 pe-md-4">
          <div class="row g-3 mb-3 mt-3">
            <div class="col-md-6 col-lg-4">
              <div class="card mb-3 primary-gradient img-overlay home-card">
                <div class="card-header p-0">
                  <h2 class="mb-4 d-flex align-items-center fw-bold text-white">Global South Innovation Space</h2>
                </div>
                <div class="card-body d-flex flex-column justify-content-end mt-4 px-0">
                  <div class="row">
					<div class="col-12">
					 <a href="#" class="btn btn-dark rounded-pill w-100 mb-1">Create Collaboration <i class="fa fa-arrow-right ms-2"></i></a>
                    </div>
                    
                  </div>
                </div>
              </div>
            </div>
			<div class="col-md-6 col-lg-4">
              <div class="card mb-3 secondary-gradient img-overlay home-card home-card-secondary">
                <div class="card-header p-0">
                  <h2 class="mb-4 d-flex align-items-center fw-bold text-white">Intelligent Search across 48,923 Documents </h2>
                </div>
                <div class="card-body d-flex flex-column justify-content-end mt-4 px-0">
                  <div class="row">
					<div class="col-12">
						
							<div class="search-box" data-list='{"valueNames":["title"]}'>
							  <form class="position-relative" data-bs-toggle="search" data-bs-display="static">
								<input class="form-control search-input fuzzy-search" type="search" placeholder="Search Documents..." aria-label="Search" />
								<span class="search-box-icon"><i class="fas fa-search"></i></span>

							  </form>
							  <div class="btn-close-falcon-container position-absolute end-0 top-50 translate-middle shadow-none" data-bs-dismiss="search">
								<button class="btn btn-link btn-close-falcon p-0" aria-label="Close"></button>
							  </div>
							  <div class="dropdown-menu border font-base start-0 mt-2 py-0 overflow-hidden w-100">
								<div class="scrollbar list py-3">
								  <h6 class="dropdown-header fw-medium text-uppercase px-x1 fs--2 pt-0 pb-2">Recently Browsed</h6>
								  <a class="dropdown-item fs--1 px-x1 py-1 hover-primary" href="#">
									<div class="d-flex align-items-center">
									  <span class="fas fa-circle me-2 text-300 fs--2"></span>

									  <div class="fw-normal title">Pages</div>
									</div>
								  </a>
								  <a class="dropdown-item fs--1 px-x1 py-1 hover-primary" href="#">
									<div class="d-flex align-items-center">
									  <span class="fas fa-circle me-2 text-300 fs--2"></span>

									  <div class="fw-normal title">E-commerce </div>
									</div>
								  </a>
								</div>
								<div class="text-center mt-n3">
								  <p class="fallback fw-bold fs-1 d-none">No Result Found.</p>
								</div>
							  </div>
							</div>
						  
					 
                    </div>
                    
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-6 col-lg-4">
              <div class="card mb-3 tertiary-gradient img-overlay home-card home-card-tertiary">
                <div class="card-header p-0">
                  <h2 class="mb-4 d-flex align-items-center fw-bold text-white">Online <br>Academy</h2>
                </div>
                <div class="card-body d-flex flex-column justify-content-end mt-4 px-0">
                  <div class="row">
					<div class="col-12">
					 <a href="#" class="btn btn-dark rounded-pill w-100 mb-1">Find Course <i class="fa fa-arrow-right ms-2"></i></a>
                    </div>
                    
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-6 col-lg-6 mb-3">
			  <div class="card home-card-others h-100">
                <div class="card-header p-0  d-md-flex align-items-md-center justify-content-md-between">
					<h4 class="mb-2 mb-lg-0 mb-xl-0 fw-semi-bold">Digital Public Goods</h4>
					<a href="#" class="btn btn-dark rounded-pill mb-1">View All <i class="fa fa-arrow-right ms-2"></i></a>
                </div>
                <div class="card-body d-flex flex-column justify-content-end mt-2 px-0">
                  <div class="row">
					<div class="col-md-4">
					 	<div class="card bg-transparent shadow-none mb-lg-0 mb-md-0 mb-4">
							<a href="#">
								<div class="mb-3">
									<img src="assets/img/dpg/1.jpg" class="img-fluid rounded-2"/>
								</div>
								<h6 class="mb-2 text-muted text-uppercase">Data Set 01</h6>
								<p class="mb-0 fw-medium">Global Innovation Space</p>
							</a>
							
						</div>
                    </div>
					<div class="col-md-4">
					 	<div class="card bg-transparent shadow-none mb-lg-0 mb-md-0 mb-4">
							<a href="#">
								<div class="mb-3">
									<img src="assets/img/dpg/2.jpg" class="img-fluid rounded-2"/>
								</div>
								<h6 class="mb-2 text-muted text-uppercase">Data Set 02</h6>
								<p class="mb-0 fw-medium">Global Innovation Space</p>
							</a>
							
						</div>
                    </div>
					 <div class="col-md-4">
					 	<div class="card bg-transparent shadow-none mb-lg-0 mb-md-0 mb-4">
							<a href="#">
								<div class="mb-3">
									<img src="assets/img/dpg/3.jpg" class="img-fluid rounded-2"/>
								</div>
								<h6 class="mb-2 text-muted text-uppercase">Data Set 03</h6>
								<p class="mb-0 fw-medium">Global Innovation Space</p>
							</a>
							
						</div>
                    </div>
                    
                  </div>
                </div>
              </div>
			</div>
			  
			<div class="col-md-6 col-lg-6 mb-3">
			  <div class="card home-card-others event h-100">
                <div class="card-header p-0  d-md-flex align-items-md-center justify-content-md-between">
					<h4 class="mb-2 mb-lg-0 mb-xl-0 fw-semi-bold">Upcoming Event</h4>
					<a href="#" class="btn btn-dark rounded-pill mb-1">Join Event <i class="fa fa-arrow-right ms-2"></i></a>
                </div>
                <div class="card-body d-flex flex-column justify-content-end mt-2 px-0 pb-0">
                  <div class="row">
					<div class="col-12">
					 	<div class="card bg-transparent shadow-none">
							
							<div class="event-card">
								<iframe width="100%" height="250" src="https://www.youtube.com/embed/MCO-grTnsrA" title="YouTube video player" frameborder="0" allow="accelerometer;  autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
								<div class="hover-card">
									<a href="https://www.youtube.com/watch?v=MCO-grTnsrA" class="popup-youtube"><i class="fa fa-play"></i></a>
									<div class="video-card">
										<div class="row">
											<div class="col-md-6">
												<p class="mb-0">Advancing Digital Food System Together</p>
											</div>
											<div class="col-md-6">
												<p class="mb-1">November 7–9, 2023</p>
												<p class="mb-0"><small>Tomorrow</small></p>												
											</div>
										</div>
									</div>
								</div>
								
							</div>
							
							
						</div>
                    </div>
					
					 
                    
                  </div>
                </div>
              </div>
			</div> 
			  
            
          </div>
          
          
          
         
         
        </div>
		 <?php include('includes/footer.php');?>
        <div class="modal fade" id="authentication-modal" tabindex="-1" role="dialog" aria-labelledby="authentication-modal-label" aria-hidden="true">
          <div class="modal-dialog mt-6" role="document">
            <div class="modal-content border-0">
              <div class="modal-header px-5 position-relative modal-shape-header bg-shape">
                <div class="position-relative z-1" data-bs-theme="light">
                  <h4 class="mb-0 text-white" id="authentication-modal-label">Register</h4>
                  <p class="fs--1 mb-0 text-white">Please create your free Falcon account</p>
                </div>
                <button class="btn-close btn-close-white position-absolute top-0 end-0 mt-2 me-2" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body py-4 px-5">
                <form>
                  <div class="mb-3">
                    <label class="form-label" for="modal-auth-name">Name</label>
                    <input class="form-control" type="text" autocomplete="on" id="modal-auth-name" />
                  </div>
                  <div class="mb-3">
                    <label class="form-label" for="modal-auth-email">Email address</label>
                    <input class="form-control" type="email" autocomplete="on" id="modal-auth-email" />
                  </div>
                  <div class="row gx-2">
                    <div class="mb-3 col-sm-6">
                      <label class="form-label" for="modal-auth-password">Password</label>
                      <input class="form-control" type="password" autocomplete="on" id="modal-auth-password" />
                    </div>
                    <div class="mb-3 col-sm-6">
                      <label class="form-label" for="modal-auth-confirm-password">Confirm Password</label>
                      <input class="form-control" type="password" autocomplete="on" id="modal-auth-confirm-password" />
                    </div>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="modal-auth-register-checkbox" />
                    <label class="form-label" for="modal-auth-register-checkbox">I accept the <a href="#!">terms </a>and <a href="#!">privacy policy</a></label>
                  </div>
                  <div class="mb-3">
                    <button class="btn btn-primary d-block w-100 mt-3" type="submit" name="submit">Register</button>
                  </div>
                </form>
                <div class="position-relative mt-5">
                  <hr />
                  <div class="divider-content-center">or register with</div>
                </div>
                <div class="row g-2 mt-2">
                  <div class="col-sm-6"><a class="btn btn-outline-google-plus btn-sm d-block w-100" href="#"><span class="fab fa-google-plus-g me-2" data-fa-transform="grow-8"></span> google</a></div>
                  <div class="col-sm-6"><a class="btn btn-outline-facebook btn-sm d-block w-100" href="#"><span class="fab fa-facebook-square me-2" data-fa-transform="grow-8"></span> facebook</a></div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>
    <!-- ===============================================-->
    <!--    End of Main Content-->
    <!-- ===============================================-->


    


    <!-- ===============================================-->
    <!--    JavaScripts-->
    <!-- ===============================================-->
	<script src="vendors/jquery/jquery.min.js"></script>
    <script src="vendors/popper/popper.min.js"></script>
    <script src="vendors/bootstrap/bootstrap.min.js"></script>
    <script src="vendors/anchorjs/anchor.min.js"></script>
    <script src="vendors/is/is.min.js"></script>
    <script src="vendors/echarts/echarts.min.js"></script>
    <script src="vendors/fontawesome/all.min.js"></script>
    <script src="vendors/lodash/lodash.min.js"></script>
    <script src="https://polyfill.io/v3/polyfill.min.js?features=window.scroll"></script>
    <script src="vendors/list.js/list.min.js"></script>
	<script src="vendors/magnific-popup/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/theme.js"></script>

  </body>

</html>