<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/data.js"></script>
<script src="https://code.highcharts.com/modules/sunburst.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://code.highcharts.com/modules/accessibility.js"></script>
<script src="https://code.highcharts.com/highcharts-more.js"></script>



<script>

Highcharts.chart('ghgvs', {
    chart: {
        type: 'line'
    },
    title: {
        text: ''
    },
    subtitle: {
        text: ''
    },
    xAxis: {
        categories: ['2005', '2006', '2007', '2008', '2009', '2010']
    },
    yAxis: {
        title: {
            text: ''
        }
    },
    plotOptions: {
        line: {
            dataLabels: {
                enabled: true
            },
            enableMouseTracking: false
        }
    },
    series: [{
        name: 'GHG',
        data: [7.0, 6.9, 16.5, 10.5, 13.4, 17.5]
    }, {
        name: 'GDP',
        data: [3.9, 4.2, 12.7, 8.5, 11.9, 15.2]
    }]
});


Highcharts.chart('ghgemmision', {
    chart: {
        type: 'area'
    },
    title: {
        text: ''
    },
    subtitle: {
        text: ''
    },
    xAxis: {
        categories: ['2009', '2010', '2011', '2012', '2013', '2014', '2015'],
        tickmarkPlacement: 'on',
        title: {
            enabled: false
        }
    },
    yAxis: {
        title: {
            text: 'Billions'
        },
        labels: {
            formatter: function () {
                return this.value / 1000;
            }
        }
    },
    tooltip: {
        split: true,
        valueSuffix: ' millions'
    },
    plotOptions: {
        area: {
            stacking: 'normal',
            lineColor: '#666666',
            lineWidth: 1,
            marker: {
                lineWidth: 1,
                lineColor: '#666666'
            }
        }
    },
    series: [{
        name: 'CO2',
        data: [502, 635, 809, 947, 1402, 3634, 5268]
    }, {
        name: 'CH4',
        data: [106, 107, 111, 133, 221, 767, 1766]
    }, {
        name: 'NO2',
        data: [163, 203, 276, 408, 547, 729, 628]
    }, {
        name: 'F-Gases',
        data: [18, 31, 54, 156, 339, 818, 1201]
    }, {
        name: 'Others',
        data: [2, 2, 2, 6, 13, 30, 46]
    }]
});

Highcharts.chart('container123', {
    colors: ['#00a32a','#00ba37','#dba617','#4f94d4','#8c8f94'],
    chart: {
        type: 'column',
        inverted: true,
        polar: true
    },
    title: {
        text: ''
    },
    tooltip: {
        outside: true
    },
    pane: {
        size: '85%',
        innerSize: '20%',
        endAngle: 270
    },
    xAxis: {
        tickInterval: 1,
        labels: {
            align: 'right',
            useHTML: true,
            allowOverlap: true,
            step: 1,
            y: 3,
            style: {
                fontSize: '13px'
            }
        },
        lineWidth: 0,
        categories: [
            '2015',
            '2014',
            '2013',
            '2012',
            '2011'
        ]
    },
    yAxis: {
        crosshair: {
            enabled: true,
            color: '#333'
        },
        lineWidth: 0,
        tickInterval: 25,
        reversedStacks: false,
        endOnTick: true,
        showLastLabel: true
    },
    plotOptions: {
        column: {
            stacking: 'normal',
            borderWidth: 0,
            pointPadding: 0,
            groupPadding: 0.15
        }
    },
    series: [{
        name: 'Climate Policy',
        data: [132, 105, 92, 73, 64]
    }, {
        name: 'Energy Efficiency',
        data: [125, 110, 86, 64, 81]
    }, {
        name: 'Clean Power',
        data: [111, 90, 60, 62, 87]
    }, {
        name: 'Clean Energy',
        data: [111, 90, 60, 62, 87]
    }, {
        name: 'Transport',
        data: [111, 90, 60, 62, 87]
    }]
});


</script>