<?php 
include('include/config.php');
include('include/function.php');

?>
<!doctype html>

<html class="no-js" lang="zxx">

<head>

    <meta charset="utf-8">

    <meta http-equiv="x-ua-compatible" content="ie=edge">

    <title>Climate Shakti - Sectors</title>

    <meta name="robots" content="noindex, follow" />

    <meta name="description" content="">

    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="shortcut icon" href="img/favicon.png" type="image/x-icon" />

    <link rel="stylesheet" href="css/font-icons.css">

    <link rel="stylesheet" href="css/plugins.css">

    <link rel="stylesheet" href="css/style.css">

    <link rel="stylesheet" href="css/responsive.css">

    <script src="https://cdn.zingchart.com/zingchart.min.js"></script>

  <style>

    .chart--container {

      height: 100%;

      width: 100%;

      min-height: 650px;

    }



    .zc-ref {

      display: none;

    }

    #myChart-license-text { display:none;}
	
	.map-scale1{
					display: flex;
					flex-wrap: nowrap;
					max-width: 460px;
					z-index: 1;
					position: absolute;
					bottom: 42px;
					width: 100%;
				}
				.map-scale1 > div{
					width:20%;
					height:8px;
				}
				.map-scale1 > div > span {
					margin-top: -34px;
					display: block;
					width: 100%;
					text-align: center;
					font-size: 10px;
					line-height: 10px;
				}
				.map-scale1 > div.fst{
					background:#b8e6bf;
				}
				.map-scale1 > div.snd{
					background:#68de7c;
				}
				.map-scale1 > div.trd{
					background:#1ed14b;
				}
				.map-scale1 > div.for{
					background:#00a32a;
				}
				.map-scale1 > div.fft{
					background:#008a20;
				}
				.map-scale1 > div.six{
					background:#09581b;
				}
				.map-scale1 > div.sev{
					background:#003a11;
				}
	.zingchart-tooltip {
	  padding: 7px 5px;
	  background-color: #fff;
	  border-radius: 1px;
	  border: 1px solid #dcdcdc;
	  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
	  line-height: 20px;
	  -webkit-font-smoothing: antialiased;
	}
	
	.zingchart-tooltip .scalex-value {
	  color: #838383;
	  font-size: 14px !important;
	  font-weight: normal !important;
	  line-height: 24px;
	}
	
	.zingchart-tooltip .scaley-value {
	  color: #4184f3;
	  font-size: 24px !important;
	  font-weight: normal !important;
	}
	.map-botom {
		position: absolute;
		right: 0;
		max-width: 699px;
	}
	.map-botom p {
		margin-top: -50px;
		z-index: 100;
		max-width: 100%;
		text-align: center;
		padding: 0 70px;
		font-size: 14px;
		line-height: 20px;
	}
	.map-botom p a{
		color:#b83b30;
	}
	.map-botom p a:hover{
		color:#dba617;
	}
  </style>

</head>



<body>

    <!--[if lte IE 9]>

        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>

    <![endif]-->



    <!-- Add your site or application content here -->



<!-- Body main wrapper start -->

<div class="body-wrapper">



   <?php include('include/header.php');?>



   





    <div class="ltn__utilize-overlay"></div>



    <!-- BREADCRUMB AREA START -->

    <div class="ltn__breadcrumb-area text-left bg-overlay-black-80 bg-image " data-bs-bg="img/bg/breadcumb-bg.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ltn__breadcrumb-inner">
                        <h4 class="page-title">Sectors Dashboard </h4>
                        <div class="ltn__breadcrumb-list">
                            <ul>
                                <li><a href="index.php"><span class="ltn__secondary-color"><i class="fas fa-home"></i></span> Home</a></li>
                                <li>Sectors Dashboard</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- BREADCRUMB AREA END -->



    <!-- ABOUT US AREA START -->

	<div class="ltn__about-us-area pt-45 mt--30">

        <div class="container">

            <div class="row">

			 

                <div class="col-lg-5">
					<h5><?php if(isset($_GET['st'])) {echo $_GET['st'] = str_replace('-', ' ', $_GET['st']);};?></h5>
                    <div id="myChart" class="chart--container"></div>
					
                    <?php /*?><div class="map-scale1">
                        <div class="fst" data-toggle="tooltip" data-placement="top" title="">
                            <span>Air Quality</span>
                        </div>
                        <div class="snd" data-toggle="tooltip" data-placement="top" title="">
                            <span>Climate Finance</span>
                        </div>
                        <div class="trd" data-toggle="tooltip" data-placement="top" title="">
                            <span>Climate Governance & Policy</span>
                        </div>
                        <div class="for" data-toggle="tooltip" data-placement="top" title="">
                            <span>Energy Eefficiency</span>
                        </div>
                        <div class="fft" data-toggle="tooltip" data-placement="top" title="">
                            <span>Sustainable Land Use</span>
                        </div>
                        <div class="six" data-toggle="tooltip" data-placement="top" title="">
                            <span>Sustainable Transport</span>
                        </div>
                        <div class="sev" data-toggle="tooltip" data-placement="top" title="">
                            <span>Others</span>
                        </div>
                    </div><?php */?>
                    

                </div>

				<div class="col-lg-7">
					<h5></h5>
                    <iframe width="100%" height="566" src="https://www.youtube.com/embed/NJY6P7t-yD0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
				</div>

								

            </div>

        </div>

    </div>

    <div class="ltn__about-us-area pt-50 pb-30 mt--30">

        <div class="container">

         

		

		</div>

    </div>
    
    
    <div class="timeliness">
    <div class="container">
    	<div class="row">
        	<div class="col-md-12">
            	 <h5 class="pt-40 mb-80">New policy developments and announcements</h5>
            </div>
        </div>
    <section class="timeline-sec pb-0">
    
     
      <div class="timeline-main">
		<?php	
			$i=1;
			$sector_id=getone($conn,"sectors","id","name",str_replace("-"," ",$_REQUEST['st']));
			$getSectors_data = mysqli_query($conn,"SELECT id,sector_id,years,policy,objective,datasource,state_id FROM subsector_policies WHERE state_id='0' AND sector_id='".$sector_id."' AND years!='' GROUP BY years ORDER BY years ASC");
			while($sector_data = mysqli_fetch_object($getSectors_data)){ ?>
			<?php if($i==1){  ?>
				<div class='timeline-row'>
			<?php } ?>
				<div class="timeline-box">
				   <h6><?=$sector_data->years;?></h6>
				   <p><?=$sector_data->policy;?></p>
				</div>
				<?php if($i==3){ ?>
					<div class='horizontal-line'></div>
					<div class='verticle-line'></div>
					<div class='corner top'></div>
					<div class='corner bottom'></div>
					 
					</div>
				<?php $i=0;
				} $i++; ?>
			
			<?php 
			}
		?>
      </div>
  
</section>
 </div>
 </div>
    <!-- ABOUT US AREA END -->
 <section class="pt-50 pb-50">
 	<div class="container">
    	<div class="row">
          <div class="col-md-12">
              <h5 class="mb-20">Explore More</h5>
          </div>
        	
            
          <div class="col-md-5">
            <div class="maps-boxes">
                <div class="map-heading justify-content-start">
                    <h4>Reports</h4>
                </div>
                <ul class="ltn__list-item-1 ltn__list-item-1-before clearfix dashboard-listing">
                    <li> <a href="#">Cooling Emmissions and Synthesis Report</a></li>
                    <li> <a href="#">Global Industry Standards on Tailing report</a></li>
                    <li> <a href="#">Special and Methodology Reports, 2019</a></li>
                    <li> <a href="#">Sixth Assessment Report: 2022</a></li>
                </ul>
            </div>
         </div>
         <div class="col-md-7"> 
            <div class="maps-boxes">
                <div class="map-heading justify-content-start">
                    <h4 class="text-left">Stories</h4>
                </div>
                <div class="ltn__search-by-place-area">
                    <div>
                        <div class="row latest-stories slick-arrow-3">
                            <div class="col-lg-4">
                                <div class="story-box">   
                                    <div class="story-up">
                                        <div class="story-data">
                                            <h6><a href="#">Taking action on climate change</a></h6>
                                            <p>Taking action on climate change: the cooling industry</p>
                                            <div class="read-m-btn">
                                                <a href="#">Read More <i class="flaticon-right-arrow"></i></a>
                                            </div>
                                        </div>
                                        <div class="story-img">
                                            <a href="#"><img src="img/12.jpg" alt="#"></a>
                                        </div>
                                    </div>

                                </div>

                            </div>                                  

                            <div class="col-lg-4">
                                <div class="story-box">
                                    <div class="story-up">
                                        <div class="story-data">
                                            <h6><a href="#">Green Economy</a></h6>
                                            <p>Toward a Green economy in Europe through sector coupling.</p>
                                            <div class="read-m-btn">
                                                <a href="#">Read More <i class="flaticon-right-arrow"></i></a>
                                            </div>
                                        </div>
                                        <div class="story-img">
                                            <a href="#"><img src="img/13.jpg" alt="#"></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div> 
         </div>

            
            
        </div>
    </div>
 </section>



   <?php include('include/footer.php');?>



</div>

<script src="js/plugins.js"></script>

<script src="js/main.js"></script> 

<script>

var bgColorMain = '#FFF';

var aYears = [2007,2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021];

var aColors = [];



var aGender = ['Men','Women'];

var aAge = ['18-24','25-34','35-44','45-54','55-64','65+'];

var aRegion = ['Northeast','Midwest','South','West'];



// g2 ////////////////////////////////

var aSeries2_a = [48.48,59.06,64.82,66.54,56.31,66.28,72.31,79.82,75.03,77.52,74.34,82.93,86.13,86.79,86.27];

var aSeries2_b = [3.3,5.0,5.1,5.8,4.8,5.8,6.9,8.0,7.0,7.4,6.9,8.4,9.1,9.0,8.8];



var aTooltip2 = ['Per person expected Halloween spending','Total expected Halloween spending(in billions)'];

//////////////////////////////////////



// g3 /////////////////////////////////

var aSeries3_a = [

	[53,60,61,62,59,62,65,66,65,67,64,67,69,68,67],

	[95,96,95,96,94,96,96,96,96,95,94,94,95,95,95]

];



var aSeries3_b = [

	[16.98,21.57,23.33,24.17,20.75,23.37,26.52,28.65,27.85,29.26,27.33,31.03,31.73,31.26,31.05],

	[17.09,18.72,19.84,20.39,17.99,20.29,21.05,23.27,22.37,23.39,23.10,24.43,25.27,25.47,25.37],

	[12.35,15.63,17.73,18.25,14.54,18.66,19.79,23.56,20.99,21.20,20.34,23.62,25.24,26.21,26.03],

	[2.06,3.14,3.92,3.73,3.02,3.95,4.96,4.34,3.82,3.67,3.57,3.84,3.88,3.85,3.82]

];



var aSeries3_c = [

	[1.2,1.8,1.8,2.1,1.8,2.0,2.5,2.9,2.6,2.8,2.5,3.1,3.4,3.2,3.2],

	[1.2,1.6,1.6,1.8,1.5,1.8,2.0,2.3,2.1,2.2,2.1,2.5,2.7,2.6,2.6],

	[0.8,1.3,1.4,1.6,1.2,1.6,1.9,2.4,2.0,2.0,1.9,2.4,2.7,2.7,2.7],

	[0.1,0.3,0.3,0.3,0.3,0.4,0.5,0.6,0.4,0.4,0.3,0.4,0.4,0.4,0.39]

];



var aTooltip3 = ['Costumes','Candy','Decorations','Greeting Cards'];

//////////////////////////////////////



// g4 ////////////////////////////////

let bgColor = 'none';

// gender

var aData4_a = [

	['67%','$96.13'],

	['69%','$76.92']

];

var aSeries4_a = [

	[[2,0,32], [2,1,33]],

	[[5,0,33], [5,1,31]]

];



// age

var aData4_b = [

	['88%','$88.23'],

	['84%','$109.11'],

	['78%','$115.53'],

	['66%','$91.30'],

	['54%','$74.19'],

	['45%','$47.01']

];

var aSeries4_b = [

	[[1,0,30], [1,1,31]],

	[[2,0,32], [2,1,32]],

	[[3,0,32], [3,1,34]],

	[[4,0,30], [4,1,30]],

	[[5,0,26], [5,1,26]],

	[[6,0,26], [6,1,26]]

];



// region

var aData4_c = [

	['70%','$92.78'],

	['69%','77.57$'],

	['67%','$89.84'],

	['67%','$83.16']

];

var aSeries4_c = [

	[[1,0,30], [1,1,31]],

	[[2,0,32], [2,1,32]],

	[[3,0,32], [3,1,34]],

	[[4,0,30], [4,1,30]]

];

//////////////////////////////////////



// g5 ////////////////////////////////

var aTooltip5 = ['Costumes (including children<br>and pets)','Candy','Decorations','Greeting cards'];



var aSeries5_a = [

	[68,96,73,35],

	[66,93,71,33]

];



var aSeries5_b = [

	[87,92,77,32],

	[88,93,80,40],

	[87,95,79,40],

	[68,96,73,31],

	[51,96,70,31],

	[32,94,57,31]

];



var aSeries5_c = [

	[68,95,75,40],

	[62,95,67,32],

	[69,95,73,34],

	[67,93,71,31]

];

//////////////////////////////////////



// g6 ////////////////////////////////

var aTooltip6 = ['Dress<br>in costume','Dress your<br>pet(s) in costume','Throw/attend<br>a party','Hand out<br>candy','Carve a<br>pumpkin','Visit a<br>haunted house','Take children<br>trick-or-treating','Decorate your<br>home/yard','Other<br>(please specify)'];



var aSeries6_a = [

	[47,15,36,68,41,22,27,41,3],

	[47,19,28,69,48,22,30,56,3]

];



var aSeries6_b = [

	[73,26,53,56,53,40,26,45,2],

	[68,27,42,60,54,34,41,50,2],

	[56,22,34,65,50,29,47,47,2],

	[44,16,29,72,46,20,29,52,3],

	[34,12,24,77,40,14,20,53,3],

	[19,4,16,78,29,5,12,45,6]

];



var aSeries6_c = [

	[48,18,33,69,41,22,26,50,3],

	[45,15,31,69,47,22,30,50,4],

	[46,18,30,69,43,24,30,47,2],

	[50,17,33,67,47,21,28,48,4]

];

//////////////////////////////////////



// g7 ////////////////////////////////

var aTooltip7 = ['Before September','September','First 2 weeks of October','Last 2 weeks of October'];



var aSeries7_a = [

	[6,28,42,24],

	[6,34,42,18]

];



var aSeries7_b = [

	[4,28,50,18],

	[7,40,40,13],

	[9,37,40,13],

	[6,30,44,19],

	[6,29,43,22],

	[4,21,39,37]

];



var aSeries7_c = [

	[7,32,41,20],

	[6,34,40,21],

	[6,31,43,20],

	[6,28,43,23]

];

//////////////////////////////////////



// g9 ////////////////////////////////

var aTooltip9_a = ['Print Media','Online search','Retail store or costume shop','Friends/family','Pop culture','Current Events','Facebook','Instagram','Pinterest','Twitter','YouTube','Blogs','Habit','Other','N/A'];

var aTooltip9 = ['Print Media (magazines, catalogs, etc.)','Online Search','Within a retail store or costume shop','Friends/Family','Pop Culture (celebrities, TV shows, movies, etc.)','Current Events','Facebook','Instagram','Pinterest','Twitter','YouTube','Blogs','Habit/Wear the same costume each year','Other','Does not apply/Will not wear costume'];



var aSeries9_a = [

	[11,35,28,20,16,7,16,14,18,6,14,3,6,3,27]

];



var aSeries9_b = [

	[12,35,27,21,18,8,19,15,12,9,19,4,6,3,26],

	[11,35,30,18,14,6,14,14,25,3,10,3,6,3,28]

];



var aSeries9_c = [

	[13,56,40,32,32,8,23,35,33,13,30,6,7,2,6],

	[14,48,35,26,25,10,25,25,28,10,21,7,6,2,9],

	[15,45,35,22,22,10,25,19,23,8,17,3,6,4,12],

	[12,33,29,18,13,8,15,9,18,3,12,2,4,3,27],

	[10,25,25,14,7,4,10,4,10,2,8,1,7,4,39],

	[7,12,13,10,3,3,5,1,5,0,2,1,8,4,58]

];

var aSeries9_d = [

	[13,35,30,20,15,8,15,14,17,7,14,4,5,3,27],

	[10,32,27,19,14,6,17,11,19,5,10,3,7,3,29],

	[12,36,29,20,17,7,19,16,19,6,16,4,6,3,26],

	[11,35,27,18,17,7,13,15,18,5,14,3,7,4,26]

];

let data = [

['Andaman and Nicobar', 9, 20, 21.5, 38.3, 14.1, 'AN'],

['Andhra Pradesh', 10, 10, 21.7, 28.1, 15.1, 'AP'],

['Arunachal Pradesh', 11, 12, 21.9, 21.5, 16.1, 'AR'],

['Assam', 12, 9, 22.1, 34.1, 17.1, 'AS'],

['Bihar', 13, 20, 22.3, 38.3, 18.1, 'BR'],

['Chandigarh', 14, 10, 22.5, 28.1, 19.1, 'CH'],

['Dadra and Nagar Haveli', 15, 12, 22.7, 21.5, 20.1, 'DN'],

['Daman and Diu', 16, 9, 22.9, 34.1, 21.1, 'DD'],

['Delhi', 17, 20, 23.1, 38.3, 22.1, 'DL'],

['Goa', 18, 10, 23.3, 28.1, 23.1, 'GA'],

['Gujarat', 19, 12, 23.5, 21.5, 24.1, 'GJ'],

['Haryana', 20, 9, 23.7, 34.1, 25.1, 'HR'],

['Himachal Pradesh', 21, 20, 23.9, 38.3, 26.1, 'HP'],

['Jammu and Kashmir', 22, 10, 24.1, 28.1, 27.1, 'JK'],

['Karnataka', 23, 12, 24.3, 21.5, 28.1, 'KA'],

['Kerala', 24, 9, 24.5, 34.1, 29.1, 'KL'],

['Madhya Pradesh', 25, 20, 24.7, 38.3, 30.1, 'MP'],

['Maharashtra', 26, 10, 24.9, 28.1, 31.1, 'MH'],

['Manipur', 27, 12, 25.1, 21.5, 32.1, 'MN'],

['Meghalaya', 28, 9, 25.3, 34.1, 33.1, 'ML'],

['Mizoram', 29, 20, 25.5, 38.3, 34.1, 'MZ'],

['Nagaland', 30, 10, 25.7, 28.1, 35.1, 'NL'],

['Orissa', 31, 12, 25.9, 21.5, 36.1, 'OR'],

['Puducherry', 32, 9, 26.1, 34.1, 37.1, 'PY'],

['Punjab', 33, 20, 26.3, 38.3, 38.1, 'PB'],

['Rajasthan', 34, 10, 26.5, 28.1, 39.1, 'RJ'],

['Sikkim', 35, 12, 26.7, 21.5, 40.1, 'SK'],

['Tamil Nadu', 36, 9, 26.9, 34.1, 41.1, 'TN'],

['Tripura', 37, 20, 27.1, 38.3, 42.1, 'TR'],

['Uttar Pradesh', 38, 10, 27.3, 28.1, 43.1, 'UP'],

['West Bengal', 39, 12, 27.5, 21.5, 44.1, 'WB'],

['Uttaranchal', 40, 20, 27.7, 38.3, 45.1, 'UT'],

['Jharkhand', 41, 10, 27.9, 28.1, 46.1, 'JH'],

['Chhattisgarh', 42, 12, 28.1, 21.5, 47.1, 'CT'],

['Telangana', 43, 9, 28.3, 34.1, 48.1, 'TL']

];



// better placement to avoid pie overlap

let oOffsets = {

  RP: [15, -15]

};



let _r_ = function (min, max) {

  return Math.round(min + (max - min) * Math.random());

};



let getNameById = function (sId) {

  let sName = 'N/A';

  for (let i = 0; i < data.length; i++) {

    if (sId === data[i][6]) {

      sName = data[i][0];

    }

  }

  return sName;

};



let oCacheDataArea = {};

let getRandomDataArea = function (sId) {

  if (oCacheDataArea[sId]) {

    return oCacheDataArea[sId];

  }

  let aValues = [

    [],

    [],

    [],

    [],

	[]

  ];

  for (let i = 0; i < data.length; i++) {

    let v0 = _r_(5, 15);

    let v1 = _r_(25, 35);

    let v3 = _r_(5, 10);

	let v4 = _r_(7, 15);

    let v2 = 100 - v0 - v1 - v3 - v4;

    aValues[0].push(v0);

    aValues[1].push(v1);

    aValues[2].push(v2);

    aValues[3].push(v3);

	aValues[4].push(v4);

  }

  oCacheDataArea[sId] = aValues;

  return aValues;

};



let bCacheDataArea = {};

let bgetRandomDataArea = function (sId) {

  if (bCacheDataArea[sId]) {

    return bCacheDataArea[sId];

  }

  let bValues = [

    [],

    [],

    [],

    [],

	[]

  ];

  for (let i = 0; i <1; i++) {

    let v0 = _r_(5, 15);

    let v1 = _r_(25, 35);

    let v3 = _r_(5, 10);

	let v4 = _r_(7, 15);

    let v2 = 100 - v0 - v1 - v3 - v4;

    bValues[0].push(v0);

    bValues[1].push(v1);

    bValues[2].push(v2);

    bValues[3].push(v3);

	bValues[4].push(v4);

  }

  bCacheDataArea[sId] = bValues;

  return bValues;

};



let cCacheDataArea = {};

let cgetRandomDataArea = function (sId) {

  if (cCacheDataArea[sId]) {

    return cCacheDataArea[sId];

  }

  let cValues = [

    [],

    [],

    [],

    [],

	[]

  ];

  for (let i = 0; i <1; i++) {

    let v0 = _r_(5, 15);

    let v1 = _r_(25, 35);

    let v3 = _r_(5, 10);

	let v4 = _r_(7, 15);

    let v2 = 100 - v0 - v1 - v3 - v4;

    cValues[0].push(v0);

    cValues[1].push(v1);

    cValues[2].push(v2);

    cValues[3].push(v3);

	cValues[4].push(v4);

  }

  cCacheDataArea[sId] = cValues;

  return cValues;

};



let oCacheDataPop = {};

let getRandomDataPop = function (sId) {

  if (oCacheDataPop[sId]) {

    return oCacheDataPop[sId];

  }

  let aValues = [];

  let iPop = ZC._r_(200, 800);

  for (let i = 0; i < data.length; i++) {

    aValues.push(iPop);

    iPop += _r_(-200, 200);

  }

  let bValues = [];

  let iPop1 = ZC._r_(200, 830);

  for (let i = 0; i < data.length; i++) {

    bValues.push(iPop1);

    iPop1 += _r_(-200, 200);

  }

  oCacheDataPop[sId] = [aValues,bValues];

  return [aValues,bValues];

};



let oCacheDataPopg = {};

let getRandomDataPopg = function (sId) {

  if (oCacheDataPopg[sId]) {

    return oCacheDataPopg[sId];

  }

  let aValuesg = [];

  let iPopg = ZC._r_(200, 830);

  for (let i = 0; i < data.length; i++) {

    aValuesg.push(iPopg);

    iPopg += _r_(-200, 200);

  }

  oCacheDataPopg[sId] = [aValuesg];

  return [aValuesg];

};





let updateAreaPopCharts = function (sId) {

  zingchart.exec('myChart', 'setdata', {

    graphid: 'gmap',

    data: getMapData(sId),

    update: false

  });

  zingchart.exec('myChart', 'modify', {

    graphid: 'histarea',

    data: {

      subtitle: {

        text: getNameById(sId)

      }

    },

    update: false

  });

  zingchart.exec('myChart', 'modify', {

    graphid: 'histpop',

    data: {

      subtitle: {

        text: getNameById(sId)

      }

    },

    update: false

  });

  zingchart.exec('myChart', 'modify', {

    graphid: 'bhistpop',

    data: {

      subtitle: {

        text: getNameById(sId)

      }

    },

    update: false

  });

 zingchart.exec('myChart', 'modify', {

    graphid: 'pielegend',

    data: {

      subtitle: {

        text: getNameById(sId)

      }

    },

    update: false

  });

  zingchart.exec('myChart', 'setseriesvalues', {

    graphid: 'histarea',

    values: getRandomDataArea(sId),

    update: false

  });

  zingchart.exec('myChart', 'setseriesvalues', {

    graphid: 'histpop',

    values: getRandomDataPop(sId),

    update: false

  });

  zingchart.exec('myChart', 'setseriesvalues', {

    graphid: 'bhistpop',

    values: bgetRandomDataArea(sId),

    update: false

  });

  zingchart.exec('myChart', 'setseriesvalues', {

    graphid: 'pielegend',

    values: bgetRandomDataArea(sId),

    update: false

  });

  zingchart.exec('myChart', 'update');

}



zingchart.bind('myChart', 'node_click', function (p) {

  if (p.graphid.indexOf('zc-graph-pie') === 0) {

    updateAreaPopCharts(p.graphid.replace('zc-graph-pie', ''));

  }

});

zingchart.bind('myChart', 'shape_click', function (p) {

  if (p.shape.mapItem) {

    updateAreaPopCharts(p.shape.id);

  }

});







var getMapData = function (sId) {

  let oGraphMainMap = {

    backgroundColor: 'none',

    x: '0px',

    y: '0px',

    width: '800px',

    height: '600px',

    type: 'null',

    id: 'gmap',

    title: {

      align: 'left',

      fontSize: '15px',

      paddingLeft: '20px',

      text: ''

    },

    source: {

      text: '(*) dummy data',

      offsetX: '-50px'

    },

    shapes: [{

      type: 'zingchart.maps',

      options: {

        x: '0px',

        y: '20px',

        width: '480px',

        height: '580px',

        id: 'mapdeu',

        name: 'ind',

        zooming: false,

        panning: false,

        scrolling: false,

        scale: true,

        style: {

          controls: {

            visible: false

          },

          label: {

            visible: false

          },

          

          hoverState: {

            visible: false

          },

          items: {

AN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

AP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

AR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

AS: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

BR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

CH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

DN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

DD: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

DL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

GA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

GJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

HR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

HP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

JK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

KA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

KL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

MP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

MH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

MN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

ML: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

MZ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

NL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

OR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

PY: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

PB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

RJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

SK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

TN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

TR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

UP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

WB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

UT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

JH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

CT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},

TL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : ''},backgroundColor: '#777777',label: {visible: true}},



}

        }

      }

    }]

  };

  oGraphMainMap.shapes[0].options.style.items[sId] = {

    backgroundColor: '#eeeeee #c2edc3'

  };

  return oGraphMainMap;

};

































let chartConfig = {

  flat: true,

  backgroundColor: '#fff',

  borderColor: '#fff',

  borderWidth: '0px',

  graphset: [

    getMapData(data[0][6]),

	//oGraphHistoryArea,

	//g9,

	//stackchart

  ]

};






zingchart.loadModules('maps, maps-ind', function (e) {

  zingchart.render({

    id: 'myChart',

    data: chartConfig,

    height: '100%',

    width: '100%'

  });

});





	</script>

</body>

</html>