<?php include 'include/config.php';  ?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title> Add Story | MIS for Inclusive Growth</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="" />
    <meta content="Indev Consultancy Pvt. Ltd." name="author" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <link rel="shortcut icon" href="assets/images/fav.png">
    <link href="assets/css/app.min.css" id="app-stylesheet" rel="stylesheet" type="text/css" />
</head>

<body data-layout="horizontal" data-topbar="light">
    <div id="wrapper">
        <?php include("include/header.php");?>
        <div class="content-page">
            <div class="content">
                <div class="page-title-box">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="d-flex d-title-box-block align-items-center justify-content-between">
                                    <h4 class="page-title">Add Story</h4>
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
                                            <li class="breadcrumb-item active">Add Story</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card-box story-box">
                                <h4 class="mt-0">Story Details</h4>
                                <?php

                                $id = $_GET['id'];                                                                
                                $sql = "SELECT success_story.id, `story_title`, `story_description`, `image` , story_level.name as label, state.name as state_name 
                                FROM `success_story` 
                                JOIN story_level ON story_level.id=success_story.story_level_id 
                                LEFT JOIN state ON state.id=success_story.state_id 
                                WHERE success_story.del_action='N' AND success_story.id=$id";

                                $result = mysqli_query($conn, $sql);
                                $row = mysqli_fetch_array($result);

                                ?>
                                <form action="update-story.php" method="post" enctype="multipart/form-data">

                                <input type="hidden" name="hd" value="<?=$row['id'];?>">
                               
                                <div class="col-md-8">
                                <div class="form-group">
                                    <label for="story_name" class="form-label">Title</label>
                                    <input type="text" name="story_name" id="story_name" class="form-control" value="<?=$row['story_title'];?>">
                                </div>
                                </div>
                                <div class="col-md-8">
                                <div class="form-group">
                                    <label for="label_name" class="form-label">Label</label>
                                    <select name="label_name" id="label_name" class="form-control">
                                        <option value=""><?=$row['label'];?></option>
                                        <?php 
                                        
                                        $getLabel = mysqli_query($conn, "SELECT `id`, `name` FROM `story_level`");

                                        while($labelData = mysqli_fetch_array($getLabel)){
                                        ?>
                                        <option value="<?=$labelData['id'];?>"><?=$labelData['name'];?></option>
                                        <?php
                                        }
                                        ?> 
                                     
                                    </select>
                                </div>
                                </div>
                                <div class="col-md-8" id="state-div">
                                    <div class="form-group">
                                        <label for="state_id" class="form-label">State Name</label>
                                        <select name="state_id" id="" class="form-control">
                                            <option value=""><?=$row['state_name'];?></option>
                                            <?php 
                                            $getState = mysqli_query($conn, "SELECT `id`, `name` FROM `state` ORDER BY name ASC");
                                            
                                            while($stateData=mysqli_fetch_array($getState)){
                                            
                                            ?>
                                            <option value="<?=$stateData['id'];?>"><?=$stateData['name'];?></option>
                                            <?php
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                <div class="form-group">
                                <label class="col-form-label">Story Image</label>
                                <input type="file" class="dropify" data-default-file="assets/images/users/user-1.jpg" name="story_image"  />
                                <img src="images/success_story/<?=$row['image'];?>" alt="<?=$row['image'];?>" height="100rem" class="mt-5">
                                </div>
                                </div>
                                <div class="col-md-6">
                                <div class="form-group">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea name="description" id="description" rows="5" class="form-control"><?=$row['story_description'];?></textarea>
                                </div>
                                </div>
                                
                                
                                <div class="form-group text-right">
                                    <input type="submit" name="submit" class="btn btn-dark" value="Submit">
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include("include/footer.php");?>
        </div>
    </div>
    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/app.min.js"></script>
    <script src="assets/libs/select2/select2.full.min.js"></script>
    <script src="assets/libs/moment/moment.js"></script>
    <script src="assets/libs/multiselect/jquery.multi-select.js"></script>
    <script src="assets/libs/select2/select2.full.min.js"></script>
    <script src="assets/libs/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/libs/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script src="assets/libs/jquery-mask-plugin/jquery.mask.min.js"></script>
    <script src="assets/libs/dropify/dropify.min.js"></script>
    <script src="assets/js/custom.js"></script>
    <!-- <script src="js/plugins.js"></script>
    <script src="js/main.js"></script> -->
<script>
$('#state-div').css('display','none');
$('#label_name').change(function(){
	var id=$(this).val();
	//alert(id);
	if(id == 2){
		$('#state-div').css('display','block');
	}else{
		$('#state-div').css('display','none');
	}
	
});
</script>
</body>

</html>