<script>

/**

 * ---------------------------------------

 * This demo was created using amCharts 5.

 * 

 * For more information visit:

 * https://www.amcharts.com/

 * 

 * Documentation is available at:

 * https://www.amcharts.com/docs/v5/

 * ---------------------------------------

 */



// Create root element

// https://www.amcharts.com/docs/v5/getting-started/#Root_element

var root = am5.Root.new("chartdiv");





// Set themes

// https://www.amcharts.com/docs/v5/concepts/themes/

root.setThemes([

  am5themes_Animated.new(root)

]);





// Create chart

// https://www.amcharts.com/docs/v5/charts/xy-chart/

var chart = root.container.children.push(am5xy.XYChart.new(root, {

  panX: false,

  panY: false,

  wheelX: "none",

  wheelY: "none",

  layout: root.verticalLayout,

}));





// data9

var data99 = [{

	year: "2011",

	value: 600000

}, {

	year: "2012",

	value: 900000

}, {

	year: "2013",

	value: 180000

}];



// Populate data99

for (var i = 0; i < (data99.length - 1); i++) {

	data99[i].valueNext = data99[i + 1].value;

}





// Create axes

// https://www.amcharts.com/docs/v5/charts/xy-chart/axes/

var xAxis = chart.xAxes.push(am5xy.CategoryAxis.new(root, {

  categoryField: "year",

  renderer: am5xy.AxisRendererX.new(root, {

    cellStartLocation: 0.1,

    cellEndLocation: 0.9,

    minGridDistance: 30

  }),

  tooltip: am5.Tooltip.new(root, {})

}));



xAxis.data.setAll(data99);



var yAxis = chart.yAxes.push(am5xy.ValueAxis.new(root, {

  min: 0,

  renderer: am5xy.AxisRendererY.new(root, {})

}));





// Add series

// https://www.amcharts.com/docs/v5/charts/xy-chart/series/



// Column series

var series = chart.series.push(am5xy.ColumnSeries.new(root, {
  name: "Series",
  xAxis: xAxis,

  yAxis: yAxis,

  valueYField: "value",

  categoryXField: "year",
 tooltip: am5.Tooltip.new(root, {})


}));



series.columns.template.setAll({

  tooltipText: "{categoryX}: {valueY}",

  width: am5.percent(90),

  tooltipY: 0

});



series.data.setAll(data99);

/*var legend = chart.children.push(am5.Legend.new(root, {
  centerX: am5.percent(50),
  x: am5.percent(50),
  layout: am5.GridLayout.new(root, {
    maxColumns: 3,
    fixedWidthGrid: true
  })
}));
legend.data.setAll(series.dataItems);*/
//legend.data.setAll(series.dataItems);

var legend = chart.children.push(am5.Legend.new(root, {
  nameField: "categoryX",
  centerX: am5.percent(50),
  x: am5.percent(50),
  y: am5.percent(103),
  centerY: am5.percent(103),
  layout: am5.GridLayout.new(root, {
    maxColumns: 3,
    fixedWidthGrid: false
  })
}));
legend.markers.template.setAll({
  width: 15,
  height: 15
});
legend.labels.template.setAll({
  fontSize: 14,
  fontWeight: "700",
});

legend.valueLabels.template.setAll({
  fontSize: 14,
  fontWeight: "700",
  width:'100',
});
legend.markerRectangles.template.setAll({
  cornerRadiusTL: 10,
  cornerRadiusTR: 10,
  cornerRadiusBL: 10,
  cornerRadiusBR: 10
});
legend.data.setAll(series.dataItems);

//console.log(series.dataItems);

// Variance indicator series

var series2 = chart.series.push(am5xy.ColumnSeries.new(root, {

  xAxis: xAxis,

  yAxis: yAxis,

  valueYField: "valueNext",

  openValueYField: "value",

  categoryXField: "year",

  fill: am5.color(0x555555),

  stroke: am5.color(0x555555)

}));



series2.columns.template.setAll({

  width: 1

});



series2.data.setAll(data99);

/*// Add legend
var legend = chart.children.push(am5.Legend.new(root, {
  nameField: "name",
  fillField: "color",
  strokeField: "color",
  centerX: am5.percent(50),
  x: am5.percent(50)
}));

legend.data.setAll([{
  name: "Under budget",
  color: am5.color(0x297373)
}, {
  name: "Over budget",
  color: am5.color(0xff621f)
}]);*/


// Add legend
// Add legend



series2.bullets.push(function () {

  var label = am5.Label.new(root, {

    text: "{valueY}",

    fontWeight: "500",

    fill: am5.color(0x00cc00),

    centerY: am5.p100,

    centerX: am5.p50,

    populateText: true

  });

  

  // Modify text of the bullet with percent

  label.adapters.add("text", function(text, target) {

    var percent = getVariancePercent(target.dataItem);

    return percent ? percent + "%" : text;

  });

  

  // Set dynamic color of the bullet

  label.adapters.add("centerY", function(center, target) {

    return getVariancePercent(target.dataItem) < 0 ? 0 : center;

  });

  

  // Set dynamic color of the bullet

  label.adapters.add("fill", function(fill, target) {

    return getVariancePercent(target.dataItem) < 0 ? am5.color(0xcc0000) : fill;

  });

  

  return am5.Bullet.new(root, {

    locationY: 1,

    sprite: label

  });

});



series2.bullets.push(function() {

  var arrow = am5.Graphics.new(root, {

    rotation: -90,

    centerX: am5.p50,

    centerY: am5.p50,

    dy: 3,

    fill: am5.color(0x555555),

    stroke: am5.color(0x555555),

    draw: function (display) {

      display.moveTo(0, -3);

      display.lineTo(8, 0);

      display.lineTo(0, 3);

      display.lineTo(0, -3);

    }

  });

  

  arrow.adapters.add("rotation", function(rotation, target) {

    return getVariancePercent(target.dataItem) < 0 ? 90 : rotation;

  });

  

  arrow.adapters.add("dy", function(dy, target) {

    return getVariancePercent(target.dataItem) < 0 ? -3 : dy;

  });

  

  return am5.Bullet.new(root, {

    locationY: 1,

    sprite: arrow

  })

})





// Make stuff animate on load

// https://www.amcharts.com/docs/v5/concepts/animations/

series.appear();

chart.appear(1000, 100);





function getVariancePercent(dataItem) {

	if (dataItem) {

		var value = dataItem.get("valueY");

		var openValue = dataItem.get("openValueY");

		var change = value - openValue;

		return Math.round(change / openValue * 100);

	}

	return 0;

}

am4core.addLicense("ch-custom-attribution");

</script>

