/*
All of the code within the ZingChart software is developed and copyrighted by ZingChart, Inc., and may not be copied,
replicated, or used in any other software or application without prior permission from ZingChart. All usage must coincide with the
ZingChart End User License Agreement which can be requested by email at support@zingchart.com.

Build 2.9.8
*/
if(typeof(ZC)==="undefined"){if(window.ZC={AV:function(e,t){if(e.indexOf)return e.indexOf(t);for(var i=0,n=e.length;i<n;i++)if(e[i]===t)return i;return-1},VERSION:"2.9.8",VERSIONID:"2.9.8.2021.12.10",LICENSEKEY:"",ABV:!1,CHARTS:["null","null3d","line","line3d","vline","area","area3d","varea","bar","bar3d","vbar","vbar3d","hbar","hbar3d","scatter","hscatter","bubble","hbubble","pie","pie3d","ring","ring3d","nestedpie","mixed","mixed3d","hmixed","radar","bullet","vbullet","hbullet","funnel","vfunnel","hfunnel","piano","heatmap","stock","range","vrange","gauge","venn"],EQUIV:{floatbar:["vfloatbar","hfloatbar"],boxplot:["vboxplot","hboxplot"],waterfall:["vwaterfall","hwaterfall"],populationpyramid:["population-pyramid","pop-pyramid"],bubblepie:["bubble-pie","bubblepie"],bar:["column","vbar"],radar:["polar","radar"],stream:["vstream"]},ALIAS:{ring:"pie"},execFn:function(e,t){var i=[].slice.call(arguments).splice(2);return ZC.evalFn(e,t).apply(t,i)},evalFn:function(e,t){for(var i=e.split("."),n=i.pop(),a=0;a<i.length;a++)t=t[i[a]];return t[n]},cache:{data:{},size:0,add:function(e,t){ZC.cache.data[e]=t,ZC.cache.size++,ZC.cache.size>2048&&(ZC.cache.data={},ZC.cache.size=0)}},DEBUG:0,TS:{},MAX:Number.MAX_VALUE,IMG404:[],BLANK:"data:image/gif;base64,R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==",TTLOCK:!1,REFRESH_TICK:{},ASYNC_TICK:[],COLORS:[],SEQ:0,LOGO_ABOUT:"data:image/png;base64,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",IMAGES:{"zc.logo":"data:image/gif;base64,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"},hosted:!1,adapter:"",flash:null,canvas:null,svg:null,vml:null,move:!1,objmove:!1,compat:function(){ZC.flash=ZC.canvas=ZC.svg=ZC.vml=!1;var e=!!document.createElement("canvas").getContext,t=!1;e&&(t="function"==typeof document.createElement("canvas").getContext("2d").fillText);ZC.canvas=e&&t,ZC.svg=document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1");var i=document.body.appendChild(document.createElement("div")),n=document.createElement("zcv:shape");n.className="zcvml",n.setAttribute("id","vml_flag1"),n.setAttribute("adj",new Object),i.appendChild(n),n.style.behavior="url(#default#VML)",ZC.vml=!n||"object"==typeof n.adj,i.parentNode.removeChild(i);var a=!1;navigator.mimeTypes&&navigator.mimeTypes["application/x-shockwave-flash"]?a=navigator.mimeTypes["application/x-shockwave-flash"].enabledPlugin:document.all&&-1===navigator.appVersion.indexOf("Mac")&&(a=new Function('try { var xObj = new ActiveXObject("ShockwaveFlash.ShockwaveFlash");if (xObj) { xObj = null; return true; } } catch (e) { return false; }')()),ZC.flash=a?1:0},quirks:!(document.compatMode&&"CSS1Compat"===document.compatMode),ie67:!!/MSIE (\d+\.\d+);/.test(navigator.userAgent)&&parseFloat(RegExp.$1)<8,ie678:!!/MSIE (\d+\.\d+);/.test(navigator.userAgent)&&parseFloat(RegExp.$1)<9,mobile:/Mobile|BlackBerry|Opera Mini|PPC|Windows CE|Android/.test(navigator.userAgent),ipad:/iPad/.test(navigator.userAgent),iphone:/iPhone/.test(navigator.userAgent),websockets:"WebSocket"in window,webstorage:"sessionStorage"in window,RH:[],WI:[],E1:[0,0],ACO:null,_cp_:function(e,t,i,n,a,r){null===ZC._n_(i)&&(i=!0),null===ZC._n_(n)&&(n=!0),null===ZC._n_(a)&&(a=!1);var l=(r=r||[]).length;for(var o in e)if(0===l||l>0&&-1===ZC.AV(r,o))if(e[o]instanceof Array){if(n){(null===ZC._n_(t[o])||"override"!==o&&!a)&&(t[o]=[]);for(var s=0,c=e[o].length;s<c;s++)t[o].push(e[o][s])}}else e[o]instanceof Object&&!(e[o]instanceof Function)?n&&(null===ZC._n_(t[o])&&(t[o]={}),t[o]instanceof Object&&!(t[o]instanceof Function)&&ZC._cp_(e[o],t[o],i)):(null===ZC._n_(t[o])||i)&&(t[o]=e[o])},_cpa_:function(e,t){t||(t=[]);for(var i=0,n=e.length;i<n;i++)t.push(e[i])},_inj_:function(e,t){var i={};ZC._cp_(e,i),ZC._cp_(t,e),ZC._cp_(i,e)},_todash_:function(e,t,i){if("dashed"!==zingchart.SYNTAX){void 0===t&&(t=!0);var n,a,r=(i=i||[]).length;for(var l in e)if(e.hasOwnProperty(l)&&(0===r||r>0&&-1===ZC.AV(i,l))){var o=l.substring(0,1);if("."!==o&&"#"!==o)if(e[l]instanceof Array)if(ZC.UJ(l)!==l){for(e[ZC.UJ(l)]=[],n=0,a=e[l].length;n<a;n++)ZC._todash_(e[l][n]),e[ZC.UJ(l)].push(e[l][n]);delete e[l]}else for(n=0,a=e[l].length;n<a;n++)ZC._todash_(e[l][n]);else e[l]instanceof Object&&!(e[l]instanceof Function)?(ZC.UJ(l)!==l&&(e[ZC.UJ(l)]={},ZC._cp_(e[l],e[ZC.UJ(l)]),delete e[l]),t&&ZC._todash_(e[ZC.UJ(l)],t,i)):ZC.UJ(l)!==l&&(e[ZC.UJ(l)]=e[l],delete e[l])}}},ZO:function(e,t){for(var i in e){var n;if(e.hasOwnProperty(i))if((n=i.replace(t+"-",""))!==i)if(e[n]=e[i],e[i]instanceof Array)for(var a=0,r=e[i].length;a<r;a++)ZC.ZO(e[i][a],t);else e[i]instanceof Object&&!(e[i]instanceof Function)&&ZC.ZO(e[i],t)}},A9U:function(e){for(var t="",i=0,n=e.length;i<n;i++){var a=i%2==0?i:e.length-i;t+=e.substring(a,a+1)}return t=t.replace(/\./g,"d")},AD8:function(e){var t=e;return t=(t=(t=t.replace("*","&")).replace("9","3")).replace("l","1")},A9G:function(e){return e.replace(/[a-zA-Z]/g,function(e){return String.fromCharCode((e<="Z"?90:122)>=(e=e.charCodeAt(0)+13)?e:e-26)})},ACA:function(e,t){var i=ZC.X0(ZC.ABX(e)),n=ZC.X0(ZC.A1Z(t)),a=i.length;if(0===a)return"";for(var r,l,o=i[a-1],s=i[0],c=2654435769,h=Math.floor(6+52/a)*c;0!==h;){l=h>>>2&3;for(var C=a-1;C>0;C--)r=((o=i[C-1])>>>5^s<<2)+(s>>>3^o<<4)^(h^s)+(n[3&C^l]^o),s=i[C]-=r;r=((o=i[a-1])>>>5^s<<2)+(s>>>3^o<<4)^(h^s)+(n[3&C^l]^o),s=i[0]-=r,h-=c}return decodeURIComponent(ZC.ABT(ZC.A5X(i)))},AEU:function(e,t){e=encodeURIComponent(e);var i=ZC.X0(ZC.A1Z(e)),n=ZC.X0(ZC.A1Z(t)),a=i.length;if(0===a)return"";1===a&&(i[a++]=0);for(var r,l,o=i[a-1],s=i[0],c=Math.floor(6+52/a),h=0;c-- >0;){l=(h+=2654435769)>>>2&3;for(var C=0;C<a-1;C++)r=(o>>>5^(s=i[C+1])<<2)+(s>>>3^o<<4)^(h^s)+(n[3&C^l]^o),o=i[C]+=r;r=(o>>>5^(s=i[0])<<2)+(s>>>3^o<<4)^(h^s)+(n[3&C^l]^o),o=i[a-1]+=r}return ZC.ABW(ZC.A5X(i))},X0:function(e){for(var t=new Array(Math.ceil(e.length/4)),i=0;i<t.length;i++)t[i]=e[4*i]+(e[4*i+1]<<8)+(e[4*i+2]<<16)+(e[4*i+3]<<24);return t},A5X:function(e){for(var t=[],i=0;i<e.length;i++)t.push(255&e[i],e[i]>>>8&255,e[i]>>>16&255,e[i]>>>24&255);return t},ABW:function(e){for(var t="",i=["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"],n=0;n<e.length;n++)t+=i[e[n]>>4]+i[15&e[n]];return t},ABX:function(e){for(var t=[],i="0x"===e.substr(0,2)?2:0;i<e.length;i+=2)t.push(parseInt(e.substr(i,2),16));return t},ABT:function(e){for(var t="",i=0;i<e.length;i++)0!==e[i]&&(t+=String.fromCharCode(e[i]));return t},A1Z:function(e){for(var t=[],i=0;i<e.length;i++)t.push(e.charCodeAt(i));return t},_i_:function(e){return-1!==String(e).indexOf("e-")?0:""===(e=String(e).replace(/[^0-9\.\-]/gi,""))?0:Math.round(e)},_f_:function(e){return e=parseFloat(e),isNaN(e)?0:e},_x_:function(e,t){return void 0===t&&(t=2),parseFloat(Number(e).toFixed(t))},_a_:function(e){return Math.abs(e)},_b_:function(e){return"false"!==e&&"0"!==e&&("true"===e||"1"===e||!!e&&!0)},_p_:function(e){var t=(e=String(e).replace(/[^0-9\.\%\-]/gi,"")).indexOf("%");return-1!==t&&(e=e.substring(0,t),e=ZC._f_(e)/100),e},_h_:function(e){return window.toStaticHTML?window.toStaticHTML(e):e},_n_:function(e){return null===e||void 0===e?null:e},_c_:function(e,t){return null===e||void 0===e?t:e},_ang_:function(e){return(e%=360)<0&&(e+=360),e},II:function(e,t){return ZC._f_(e)+""==e+""?t?ZC._f_(e):ZC._a_(e):-1!==(e+="").indexOf("%")?ZC._f_(e.replace("%",""))/100:-1!==e.indexOf("px")?ZC._f_(e.replace("px","")):ZC._f_(e)},QX:function(e){return parseInt(e,16)},OT:function(e){return ZC._i_(e).toString(16)},_r_:function(e,t){return parseInt(e+(t-e)*Math.random(),10)},_l_:function(e,t,i){return e=(e=e<t?t:e)>i?i:e},DS:function(e,t,i,n){return n?t<e&&e<i||i<e&&e<t:t<=e&&e<=i||i<=e&&e<=t},BQ:function(e,t){return Math.max(e,t)},CY:function(e,t){return Math.min(e,t)},A1L:function(e,t){null===ZC._n_(t)&&(t=!1);for(var i=0,n=e.length,a=-Number.MAX_VALUE;i<n;i++)t&&0==e[i]||(a=Math.max(a,e[i]));return a},XY:function(e,t){null===ZC._n_(t)&&(t=!1);for(var i=0,n=e.length,a=Number.MAX_VALUE;i<n;i++)t&&0==e[i]||(a=Math.min(a,e[i]));return a},_rcolor_:function(){for(var e=(16777215*Math.random()+1<<0).toString(16);e.length<6;)e="0"+e;return"#"+e},AAA:function(e,t){for(var i,n=ZC._f_(t),a=Number.MAX_VALUE,r=0,l=0,o=e.length;l<o;l++)(i=Math.abs(ZC._f_(e[l])-n))<a&&(r=l,a=i);return r},AEK:function(e){var t=e.split(".");return t[t.length-1]||""},GV:function(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")},G6:function(e,t){return t=t||Math.E,isFinite(Math.log(e)/Math.log(t))?Math.log(e)/Math.log(t):0},TK:function(e){return 360*e/(2*Math.PI)},T1:function(e){return 2*e*Math.PI/360},EH:function(e){return Math.cos(ZC.T1(e))},EP:function(e){return Math.sin(ZC.T1(e))},P5:function(e){return!isNaN(parseFloat(e))&&isFinite(e)},EE:function(e){return-1!==e.indexOf("-")?e.replace(/(\-[a-z0-9])/g,function(e){return e.toUpperCase().replace("-","")}):e},UJ:function(e){return e.toUpperCase()!==e&&-1===e.indexOf("-")&&e.substring(0,1).toLowerCase()===e.substring(0,1)?e.replace(/([A-Z])/g,function(e){return"-"+e.toLowerCase()}).replace(/([0-9]+)/g,function(e){return"-"+e.toLowerCase()}).replace("-3d","3d"):e},AEL:function(e){return ZC.XK.md5(e)},AK:function(e){return document.getElementById(e)},A1H:function(e,t){return e[0].length<t[0].length?1:e[0].length>t[0].length?-1:0},ZJ:function(e){window.setTimeout(e,zingchart.TIMEOUT)},_fixed_:function(e,t){return t>=0&&t<=20?e.toFixed(t):""+e},_nfind_:function(e,t,i,n){var a=t.S[i].BT,r=t.S[n].BT;if(e==a)return i;if(e==r)return n;var l=ZC._i_((i+n)/2);if(!t.S[l]){for(;!t.S[l]&&l<n;)l++;if(l===n){for(l=ZC._i_((i+n)/2);!t.S[l]&&l>i;)l--;if(l===i)return null}}var o=t.S[l].BT;return l!==i&&l!==n?e==o?l:e>o?ZC._nfind_(e,t,l,n):ZC._nfind_(e,t,i,l):e==o?l:null},_tx_:function(e){var t,i,n,a,r=[1,1,0,0];if(zingchart.DEV.LOOKUPCSSTRANSFORM&&!ZC.vml&&ZC.AK(e)){var l=ZC.AK(e);for(t="";l&&(""===t||"none"===t);)t=ZC.A5(l).css("transform")||"",l=l.parentNode;-1!==(i=t.indexOf("matrix("))&&(n=t.indexOf(")",i),a=t.substring(i+7,n-i).split(","),r=[ZC._f_(a[0]),ZC._f_(a[3]),ZC._f_(a[4]),ZC._f_(a[5])])}return r},Utils_SetupFormat:function(e,t){return ZC.AP.O3(e,t)},Utils_Format:function(e,t,i,n){return ZC.AP.G2(e,t,i,n)},Loader_Api_Loader_Info:function(e){return e.FE()}},ZC.hasPassive=!1,ZC.SEC=1e3,ZC.MIN=60*ZC.SEC,ZC.HR=60*ZC.MIN,ZC.DAY=24*ZC.HR,ZC.MON=30*ZC.DAY,ZC.YR=365*ZC.DAY,ZC.MAPTX=0,window.JSON=window.JSON||{},JSON.stringify=JSON.stringify||function(e){var t=typeof e;if("object"!==t||null===e)return"string"===t&&(e='"'+e.replace("\\","\\\\").replace('"','"')+'"'),String(e);var i,n,a=[],r=e&&e.constructor===Array;for(i in e)"function"!=typeof e[i]&&("string"===(t=typeof(n=e[i]))?n='"'+n.replace("\\","\\\\").replace('"','\\"')+'"':"object"===t&&null!==n&&(n=JSON.stringify(n)),a.push((r?"":'"'+i+'":')+String(n)));return(r?"[":"{")+String(a)+(r?"]":"}")},JSON.parse=JSON.parse||function(KV){return""===KV&&(KV='""'),eval("("+KV+")")},function(){var e=!1,t=/xyz/.test(function(){xyz})?/\bb\b/:/.*/;ZC.C9=function(){},ZC.C9.CA=function(i){var n=this.prototype;e=!0;var a=new this;for(var r in e=!1,i)a[r]="function"==typeof a[r]&&"function"==typeof n[r]&&t.test(i[r])?function(e,t){return function(){var i=this.b;this.b=n[e];var a=t.apply(this,arguments);return this.b=i,a}}(r,i[r]):i[r];function l(){!e&&this.$i&&this.$i.apply(this,arguments)}return l.prototype=a,l.constructor=l,l.CA=arguments.callee,l}}(),ZC.AAT=function(e){this.H=e,this.A9B=function(e,t){var i,n=this,a=n.B8.palette;if(null!==ZC._n_(t)&&null!==ZC._n_(a[t])&&(a=a[t]),null!==ZC._n_(a[e])){var r=a[e];return null===ZC._n_(r[2])&&(r[2]=ZC.AP.QU(r[1],10)),null===ZC._n_(r[3])&&(r[3]=ZC.AP.QU(r[1],10)),r}var l=["#00BAF2","#E80C60","#E2D51A","#9B26AF","#FB301E","#00AE4D","#20398B"];i=null!==ZC._n_(l[e-n.B8.palette.length])?l[e-n.B8.palette.length]:"#"+ZC.XK.md5(e).substr(e%20,6);var o=ZC.AP.QU(i,10),s=ZC.AP.QU(i,20),c="#FFF";return n.B8.palette&&n.B8.palette[0]&&n.B8.palette[0][0]&&(c=n.B8.palette[0][0]),[c,i,o,s]},this.A8S=function(e){e&&ZC._cp_(e,this.B8,!0)},this.AAY=function(e){var t=this;null!==ZC._n_(t.NY[e])&&(ZC._todash_(t.NY[e]),ZC._cp_(t.NY[e],t.B8))},this.NY={},ZC._cp_(zingchart.THEMES,this.NY),this.NY.classic={palette:[["#fff","#6a921f","#a7da47","#89b92e"],["#fff","#007fa3","#00b0e1","#0392bb"],["#fff","#a62b02","#ef4810","#cc3300"],["#fff","#b79007","#f9c332","#da9b04"],["#fff","#563d02","#84680a","#6e4503"],["#fff","#0b32a0","#4d62b1","#1540a0"]],graph:{refresh:{curtain:{alpha:.5,"background-color":"#999",color:"#000","font-size":15,bold:1,text:"Loading..."}},"background-color":"#e1eaec #edf3f5",title:{"font-size":14,bold:1,color:"#fff","background-color":"#00bbf1 #05a0cd",padding:6},subtitle:{"font-size":11,bold:1,color:"#333","margin-top":30,padding:6},source:{"font-size":10,color:"#333",width:"100%",bold:1,"text-align":"right",height:20,margin:"auto 0 0 auto",padding:5},nodata:{"font-size":12,color:"#333","text-align":"center","vertical-align":"middle",text:""},SCALE:{"font-size":11,"line-width":2,"line-color":"#3e6c7b",item:{flat:!0},"ref-line":{"line-width":1,"line-color":"#3e6c7b"},guide:{visible:1,"line-width":1,"line-style":"solid","line-color":"#2c4a59",alpha:.2},"minor-guide":{visible:1,"line-width":1,"line-style":"solid","line-color":"#aaa",alpha:.1},tick:{visible:1,size:6,placement:"outer","line-width":2,"line-color":"#3e6c7b"},"minor-tick":{visible:1,size:4,placement:"outer","line-width":1,"line-color":"#3e6c7b"},label:{color:"#2c4a59",flat:!0}},"scroll-x":{bar:{height:16},handle:{height:16}},"scroll-y":{bar:{width:16},handle:{width:16}},legend:{"background-color":"#fff","border-width":1,alpha:.75,"border-alpha":.75,"border-color":"#666","shadow-distance":3,header:{padding:"4 6",color:"#fff","border-width":1,"border-color":"#3e6c7b","background-color":"#3e6c7b"},footer:{padding:"2 6","background-color":"#ccc","border-width":1,"border-color":"#666"},marker:{"border-color":"#333","border-width":1}},plot:{"value-box":{flat:!0},marker:{shadow:1,"line-width":1,"border-width":1},"hover-marker":{"line-width":1,"border-width":1}},guide:{"line-width":1,"line-color":"#999",alpha:1,"scale-label":{text:"%l",padding:"3 6"},"plot-label":{padding:"3 6"}}},line:{plot:{"shadow-alpha":.5,marker:{size:4},"hover-marker":{size:5}}},area:{plot:{"shadow-alpha":.5,marker:{size:4},"hover-marker":{size:5}}},vbar:{plot:{"fill-angle":90,shadow:0}},hbar:{plot:{"fill-angle":180,shadow:0}},piano:{plotarea:{"mask-tolerance":[0,0]},plot:{shadow:0}},stock:{plot:{shadow:0}},vbullet:{plot:{shadow:0}},hbullet:{plot:{"fill-angle":0,shadow:0}},scatter:{plot:{marker:{size:4},"hover-marker":{size:5}}},hscatter:{plot:{marker:{size:4},"hover-marker":{size:5}}},bubble:{plot:{marker:{"border-width":0},"hover-marker":{"border-width":0}}},hbubble:{plot:{marker:{"border-width":0},"hover-marker":{"border-width":0}}},pie:{plot:{"border-width":1}},nestedpie:{plot:{"border-width":1}},radar:{plot:{marker:{size:3},"hover-marker":{size:4}},"scale-k":{guide:{alpha:.5,"background-color":"#eee #ddd"}}},gauge:{"scale-r":{"background-color":"-1",guide:{alpha:.5,"background-color":"#eee #ddd"},item:{"offset-r":0},ring:{size:1,items:[{"background-color":"#999",alpha:.8},{"background-color":"#666",alpha:.8}]}}},vfunnel:{plotarea:{margin:"50 100"},SCALE:{"line-width":0,tick:{"line-width":0},"minor-tick":{"line-width":0},guide:{"line-width":0},"minor-guide":{"line-width":0}},"scale-y":{guide:{alpha:.25,"background-color":"-1 #58595B"}},"scale-y-n":{guide:{alpha:.25,"background-color":"-1 #58595B"}},plot:{"border-width":1}},hfunnel:{plotarea:{margin:"50 100"},"scale-x":{label:{"font-angle":270}},"scale-x-n":{label:{"font-angle":90}},SCALE:{"line-width":0,tick:{"line-width":0},"minor-tick":{"line-width":0},guide:{"line-width":0},"minor-guide":{"line-width":0}},"scale-y":{label:{"font-angle":0},item:{"text-align":"center"},guide:{alpha:.25,"background-color":"#58595B -1"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"},guide:{alpha:.25,"background-color":"#58595B -1"}},plot:{"border-width":1}},range:{plot:{marker:{type:"circle",size:4},"hover-marker":{size:5}}},line3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":0,"line-width":1}},area3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":0,"line-width":1}},mixed3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},vbar3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},hbar3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},pie3d:{plot:{"border-width":1}},"-":""},this.NY.light={palette:[["#fff","#29A2CC","#29A2CC","#1089B3"],["#fff","#D31E1E","#D31E1E","#BA0505"],["#fff","#7CA82B","#7CA82B","#638F12"],["#fff","#EF8535","#EF8535","#D66C1C"],["#fff","#A14BC9","#A14BC9","#8832B0"],["#fff","#A05F18","#A05F18","#874600"],["#fff","#265E96","#265E96","#0D457D"],["#fff","#6B7075","#6B7075","#52575C"],["#fff","#96C245","#96C245","#7CA82B"]],graph:{refresh:{curtain:{alpha:.5,"background-color":"#999",color:"#000","font-size":15,bold:1,text:"Loading..."}},"background-color":"#ffffff",title:{"font-size":21,bold:1,color:"#414042","background-color":"none",padding:6},subtitle:{"font-size":11,bold:1,color:"#414042","margin-top":30,padding:6},source:{"font-size":10,color:"#414042",width:"100%",bold:1,"text-align":"right",height:20,margin:"auto 0 0 auto",padding:5},nodata:{"font-size":12,color:"#333","text-align":"center","vertical-align":"middle",text:"No Data","background-color":"#BBBBBB",alpha:.8},SCALE:{"font-size":11,"line-width":1,"line-color":"#8C8C8C",item:{"font-size":12,flat:!0,color:"#808285"},"ref-line":{"line-width":1,"line-color":"#D1D3D4"},guide:{visible:1,"line-width":1,"line-style":"solid","line-color":"#DCDCDC",alpha:1},"minor-guide":{visible:1,"line-width":1,"line-style":"solid","line-color":"#aaa",alpha:.1},tick:{visible:1,size:5,placement:"outer","line-width":1,"line-color":"#8C8C8C"},"minor-tick":{visible:1,size:3,placement:"outer","line-width":1,"line-color":"#A7A9AC"},label:{color:"#414042",flat:!0}},"scale-x":{normalize:!0,guide:{visible:!1}},scroll:{bar:{"background-color":"#F0F1F1",margin:1},handle:{"background-color":"#A7A9AC","border-radius":6}},"scroll-x":{bar:{height:16,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"},handle:{height:10,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},"scroll-y":{bar:{width:16,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"},handle:{width:10,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},"scroll-xi":{bar:{width:16,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"},handle:{width:10,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},"scroll-yi":{bar:{height:16,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"},handle:{height:10,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},preview:{"background-color":"#fff","border-width":1,"border-color":"#A7A9AC",live:!0,mask:{"background-color":"#999"},active:{alpha:0},handle:{width:11,"border-width":2,"border-radius":3,"line-color":"#C6C6C6","border-color":"#A7A9AC","background-color":"#F0F1F1"},"handle-top":{height:11},"handle-bottom":{height:11}},tooltip:{shadow:1,"shadow-angle":45,"shadow-distance":1,"shadow-alpha":.25,"border-width":1,"border-color":"#fff","border-alpha":1},zoom:{"preserve-zoom":1,"background-color":"#929497"},legend:{"background-color":"#fff","border-width":1,shadow:0,"shadow-alpha":.2,alpha:1,"border-alpha":1,"border-color":"#cccccc",header:{padding:"5 0 5 10",color:"#222222","background-color":"none","border-width":0,"border-top":"0px solid none","border-bottom":"1px solid #cccccc"},footer:{padding:"5 0 5 10","border-top":"1px solid #cccccc"},shader:{"background-color":"#F0F1F1","line-color":"#C6C6C6",margin:2,height:8,"line-width":2,"line-style":"dotted"},icon:{"line-color":"#C6C6C6","line-width":2,style:"small"},marker:{"border-color":"#fff","border-width":1},"page-on":{"background-color":"#929497"},"page-off":{"background-color":"#D1D2D3"},scroll:{bar:{"background-color":"none","margin-top":3,"margin-bottom":3},handle:{"background-color":"#D1D2D3","border-top":"none","border-right":"none","border-bottom":"none","border-left":"none","border-radius":6,width:12,height:12}}},plot:{"value-box":{flat:!0},marker:{shadow:0,"line-width":1,"border-width":1,"border-color":"#fff"},"hover-marker":{"line-width":1,"border-width":1},monotone:!0},guide:{"line-width":1,"line-color":"#8C8C8C",alpha:1,"scale-label":{text:"%l",padding:"3 6"},"plot-label":{padding:"3 6"}}},line:{plot:{"line-width":2,shadow:0,marker:{size:4},"hover-state":{},"hover-marker":{size:5,"border-width":1,"border-color":"#fff"}}},area:{plot:{"line-width":2,shadow:0,"alpha-area":.25,"background-color-style":"solid",marker:{size:4},"hover-state":{},"hover-marker":{size:5,"border-width":1,"border-color":"#fff"}}},vbar:{plot:{"fill-angle":90,shadow:0}},hbar:{plot:{"fill-angle":180,shadow:0}},piano:{plotarea:{"mask-tolerance":[0,0]},plot:{shadow:0},"scale-x":{guide:{visible:!0}}},stock:{plot:{shadow:0}},vbullet:{plot:{shadow:0,goal:{"border-width":1,"border-color":"#fff",height:8}}},hbullet:{plot:{"fill-angle":0,shadow:0,goal:{"border-width":1,"border-color":"#fff",width:8}}},scatter:{plot:{"line-color":"%palette-0","border-color":"%palette-0",marker:{size:5},"hover-marker":{size:6}},"scale-x":{guide:{visible:!0}}},hscatter:{plot:{"line-color":"%palette-0","border-color":"%palette-0",marker:{size:4},"hover-marker":{size:5}},"scale-x":{guide:{visible:!0}}},bubble:{plot:{marker:{"border-width":1,"border-color":"#fff"},"hover-marker":{"border-width":1,"border-color":"#fff"}},"scale-x":{guide:{visible:!0}}},hbubble:{plot:{marker:{"border-width":1,"border-color":"#fff"},"hover-marker":{"border-width":1,"border-color":"#fff"}},"scale-x":{guide:{visible:!0}}},pie:{plot:{shadow:0,"border-width":1,"value-box":{placement:"in","font-size":16,text:"%node-percent-value%"}}},nestedpie:{plot:{"border-width":1}},radar:{plot:{shadow:0,"line-width":2,"background-color":"%palette-1","active-area":!0,marker:{size:4},"hover-marker":{size:5,"border-color":"#fff"}},"scale-k":{guide:{"line-width":1,"line-style":"solid","line-color":"#8C8C8C","line-segment-size":6,"line-gap-size":6,alpha:1,"background-color":"#fff #F7F8F8"},tick:{"line-color":"#8C8C8C","line-width":1,size:10}},"scale-r":{},"scale-v":{"ref-line":{"line-color":"#8C8C8C","line-width":1},tick:{"line-color":"#8C8C8C","line-width":1},guide:{"line-color":"#CDCDCD","line-width":1}}},gauge:{plot:{shadow:0},scale:{"size-factor":1},"scale-r":{aperture:270,tick:{size:11,"line-width":2},"background-color":-1,guide:{"background-color":"#fff"},ring:{size:8,"background-color":"#CDCDCD"},center:{size:20,"background-color":"#fff","border-width":6,"border-color":"#1089B3"}}},vfunnel:{plotarea:{margin:"50 100"},SCALE:{"line-width":0,tick:{"line-width":0},"minor-tick":{"line-width":0},guide:{"line-width":1,"line-style":"solid","line-color":"#CDCDCD","line-segment-size":6,"line-gap-size":6,alpha:1},"minor-guide":{"line-width":0}},"scale-x":{visible:!1,guide:{visible:0}},"scale-y":{guide:{"background-color":"-1",alpha:1}},"scale-y-n":{guide:{"background-color":"-1"}},plot:{"border-width":1,"border-color":"#fff",shadow:0,"hover-state":{"line-color":"-1","border-color":"-1"}}},hfunnel:{plotarea:{margin:"50 100"},"scale-x":{visible:!1,guide:{visible:0},label:{"font-angle":270}},"scale-x-n":{label:{"font-angle":90}},SCALE:{"line-width":0,tick:{"line-width":0},"minor-tick":{"line-width":0},guide:{"line-width":1,"line-style":"solid","line-color":"#CDCDCD","line-segment-size":6,"line-gap-size":6,alpha:1},"minor-guide":{"line-width":0}},"scale-y":{guide:{"background-color":"-1",alpha:1},label:{"font-angle":0},item:{"text-align":"center"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"},guide:{"background-color":"-1"}},plot:{"border-width":1,"border-color":"#fff",shadow:0,"hover-state":{"line-color":"-1","border-color":"-1"}}},range:{plot:{"background-color":"%palette-1",marker:{type:"circle",size:4},"hover-marker":{size:5}}},line3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":0,"line-width":1}},area3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":0,"line-width":1}},mixed3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},vbar3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},hbar3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},pie3d:{plot:{"border-width":1}},venn:{plot:{"border-width":0,shadow:0,alpha:.75,"background-color":"%palette-1"}},root:{gui:{"context-menu":{visible:!0,width:"125px",padding:"5 0","background-color":"#595959","border-width":0,"border-color":"#595959",position:"left",button:{visible:ZC.mobile,alpha:0},gear:{"background-color":"#000",type:"hamburger",alpha:1},item:{"background-color":"#595959","text-align":"left",padding:"4 20 4 15","border-width":0,"border-color":"#595959","font-size":"12px",color:"#fff","hover-state":{"background-color":"#414141"}},separator:{"line-width":1,"line-color":"#969696"}},"context-menu[mobile]":{item:{padding:"6 10 6 6"}}}},"-":""},this.NY.light.graph["crosshair-x"]=this.NY.light.graph["crosshair-y"]=this.NY.light.graph.guide,this.NY.dark={},ZC._cp_(this.NY.light,this.NY.dark,!0,!0),ZC._cp_({graph:{"background-color":"#221F1F",title:{color:"#fff"},subtitle:{color:"#fff"},source:{color:"#fff"},SCALE:{"line-color":"#D1D3D4",item:{color:"#D1D3D4"},"ref-line":{"line-color":"#D1D3D4"},guide:{"line-color":"#58595B"},"minor-guide":{"line-color":"#58595B"},tick:{"line-color":"#D1D3D4"},"minor-tick":{"line-color":"#D1D3D4"},label:{color:"#D1D3D4"}},scroll:{bar:{"background-color":"#6C6D70"},handle:{"background-color":"#A7A9AC"}},"scroll-x":{bar:{"border-top":"0px solid none","border-right":"2px solid #D1D3D4","border-bottom":"2px solid #D1D3D4","border-left":"2px solid #D1D3D4"},handle:{"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},"scroll-y":{bar:{"border-top":"2px solid #D1D3D4","border-right":"0px solid none","border-bottom":"2px solid #D1D3D4","border-left":"2px solid #D1D3D4"}},preview:{"background-color":"#221F1F"},tooltip:{"border-color":"#000"},legend:{"background-color":"#221F1F",header:{color:"#fff",shader:{"background-color":"#414042","line-color":"#676667"}},footer:{color:"#D1D3D4","background-color":"#414042","border-top":"0px solid none","border-right":"2px solid #A7A9AC","border-bottom":"2px solid #A7A9AC","border-left":"2px solid #A7A9AC"},shader:{"background-color":"#414042","line-color":"#676667"},icon:{"line-color":"#676667"},"page-status":{color:"#D1D3D4"},"page-on":{"background-color":"#D1D2D3"},"page-off":{"background-color":"#929497"},marker:{"border-color":"#000"},item:{color:"#D1D3D4"}},plot:{marker:{"border-color":"#221F1F"}},guide:{"line-color":"#D1D3D4","scale-label":{"background-color":"#929497"},"plot-label":{"background-color":"#221F1F",color:"#FFF","border-color":"#5a5a5a"}}},line:{plot:{"hover-marker":{"border-color":"#221F1F"}}},area:{plot:{"hover-marker":{"border-color":"#221F1F"}}},vbullet:{plot:{goal:{"border-color":"#221F1F"}}},hbullet:{plot:{goal:{"border-color":"#221F1F"}}},bubble:{plot:{marker:{"border-color":"#221F1F"},"hover-marker":{"border-color":"#221F1F"}}},hbubble:{plot:{marker:{"border-color":"#221F1F"},"hover-marker":{"border-color":"#221F1F"}}},pie:{plot:{"border-color":"#221F1F"}},radar:{plot:{"hover-marker":{"border-color":"#221F1F"}},"scale-k":{guide:{"line-color":"#58595B","background-color":"#221F1F #312F30"},tick:{"line-color":"#D1D3D4"}},"scale-v":{"ref-line":{"line-color":"#58595B"},tick:{"line-color":"#58595B"},guide:{"line-color":"#58595B"}}},gauge:{"scale-r":{guide:{"background-color":"#221F1F"},ring:{"background-color":"#57585B"}}},vfunnel:{SCALE:{guide:{"line-color":"#58595B"}},plot:{"border-color":"#221F1F","hover-state":{"line-color":"#58595B","border-color":"#221F1F"}}},hfunnel:{SCALE:{guide:{"line-color":"#58595B"}},"scale-y":{guide:{alpha:.25,"background-color":"#b6c8cf -1"}},"scale-y-n":{guide:{alpha:.25,"background-color":"#b6c8cf -1"}},plot:{"border-color":"#221F1F","hover-state":{"line-color":"#58595B","border-color":"#221F1F"}}},root:{gui:{"context-menu":{gear:{"background-color":"#FFF"}}}},"-":""},this.NY.dark,!0,!0),this.NY.dark.graph["crosshair-x"]=this.NY.dark.graph["crosshair-y"]=this.NY.dark.graph.guide,this.NY.mini={graph:{title:{width:"100%",padding:"1 2 2","font-size":10},subtitle:{width:"100%",padding:"1 2 2","margin-top":14,"font-size":9},plotarea:{width:"100%",height:"100%",margin:"18 4 4 4"},SCALE:{visible:0},tooltip:{shadow:0,"border-radius":7},legend:{visible:0},preview:{visible:0},guide:{"line-width":1,"line-color":"#ccc",alpha:1,"scale-label":{text:"%l",padding:"3 6"},"plot-label":{"border-color":"#ccc","border-radius":5,padding:"3 6"}},plot:{shadow:0,"value-box":{visible:0},"hover-state":{visible:0},"hover-marker":{visible:0},"max-trackers":99999,"max-nodes":99999}},line:{plot:{"line-width":1,marker:{type:"none"}}},line3d:{"3d-aspect":{depth:20,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0,zoom:.9}},area:{plot:{"line-width":1,marker:{type:"none"}}},area3d:{"3d-aspect":{depth:20,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0,zoom:.9}},scatter:{SCALE:{offset:5},plot:{marker:{size:3,shadow:!1,alpha:.8}}},hscatter:{SCALE:{offset:5},plot:{marker:{size:3,shadow:!1,alpha:.8}}},bubble:{SCALE:{offset:15},plot:{marker:{"fill-type":"none",shadow:!1,alpha:.8},"min-size":3,"max-size":9}},hbubble:{SCALE:{offset:15},plot:{marker:{"fill-type":"none",shadow:!1,alpha:.8},"min-size":3,"max-size":9}},pie:{plotarea:{margin:"18 4 4 4"},plot:{"value-box":{visible:0}},scale:{"size-factor":.95}},pie3d:{plotarea:{margin:"32 4 4 4"},plot:{"value-box":{visible:0}},scale:{"size-factor":1}},nestedpie:{plotarea:{margin:"18 4 4 4"},plot:{"value-box":{visible:0}},scale:{"size-factor":.95}},radar:{plotarea:{margin:"18 4 4 4"},plot:{"line-width":1,marker:{shadow:0,size:2}},scale:{"size-factor":.95}},vbar3d:{"3d-aspect":{depth:20,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0,zoom:.9}},hbar3d:{"3d-aspect":{depth:20,angle:45,"x-angle":0,"y-angle":-20,"z-angle":0,zoom:.9}},venn:{plotarea:{margin:"18 4 4 4"},plot:{"border-width":0}},gauge:{plotarea:{margin:"18 4 4 4"},plot:{indicator:[5]},SCALE:{visible:1},scale:{"size-factor":.9},"scale-r":{"background-color":"-1",aperture:270,tick:{visible:0},item:{visible:0},guide:{visible:0},ring:{size:6,"background-color":"#CDCDCD",items:[]},center:{"border-width":0,size:2,"background-color":"#fff"}}},vfunnel:{plotarea:{margin:"18 4 4 4"}},hfunnel:{plotarea:{margin:"18 4 4 4"}},vbullet:{plot:{"bar-space":.5,goal:{"border-width":0,height:4}}},hbullet:{plot:{"bar-space":.5,goal:{"border-width":0,width:4}}},range:{plot:{"line-width":1,marker:{visible:0},"hover-state":{visible:0}}},"-":""},this.NY.negative={palette:[["#000","#909090","#969696","#9c9c9c"],["#000","#a0a0a0","#a6a6a6","#acacac"],["#000","#b0b0b0","#b6b6b6","#bcbcbc"],["#000","#c0c0c0","#c6c6c6","#cccccc"],["#000","#d0d0d0","#d6d6d6","#dcdcdc"],["#000","#e0e0e0","#e6e6e6","#ececec"],["#000","#f0f0f0","#f6f6f6","#fcfcfc"]],graph:{"background-color":"#111",title:{color:"#fff"},subtitle:{color:"#333"},SCALE:{"font-size":11,"line-width":2,"line-color":"#ccc",guide:{visible:1,"line-width":1,"line-style":"solid","line-color":"#ccc",alpha:.2},"minor-guide":{visible:1,"line-width":1,"line-style":"solid","line-color":"#ccc",alpha:.2},tick:{visible:1,size:6,placement:"outer","line-width":2,"line-color":"#ccc"},"minor-tick":{visible:1,size:4,placement:"outer","line-width":1,"line-color":"#ccc"},label:{color:"#fff"},item:{color:"#fff"}}},radar:{"scale-k":{guide:{alpha:.5,"background-color":"#222 #333"}}},"-":""},this.NY.spark=this.NY.mini,this.B8={root:{gui:{behaviors:[{id:"PageScroll",enabled:"all"},{id:"ViewSource",enabled:"all"},{id:"BugReport",enabled:"none"},{id:"LogScale",enabled:"none"},{id:"LinScale",enabled:"none"},{id:"FullScreen",enabled:"none"},{id:"3D",enabled:"none"},{id:"ExportData",enabled:"none"},{id:"SaveAsImageJPG",enabled:"none"},{id:"DownloadCSV",enabled:ZC.ie678?"none":"all"},{id:"DownloadXLS",enabled:ZC.ie678?"none":"all"}],watermark:{type:1,position:"rb"},history:{margin:"10 auto auto 10",width:30,height:22,padding:4,item:{"background-color":"#369","border-width":1,"border-color":"#69c"},"item-off":{"background-color":"#eee","border-color":"#ddd"}},progress:{"background-color":"#fff",color:"#000"},"context-menu":{padding:0,"border-width":1,"border-color":"#000",button:{visible:ZC.mobile,margin:"5 auto auto 5",alpha:.8,"background-color":"#333 #999","border-radius":8,width:40,height:40},gear:{"background-color":"#fff #f6f6f6",type:"gear6",alpha:.8},item:{"background-color":"#36393D","text-align":"left",padding:"4 20 4 8","border-width":1,"border-color":"#000",color:"#fff","hover-state":{"background-color":"#0084AA"}},separator:{"line-width":1,"line-color":"#000000"}},"context-menu[mobile]":{item:{padding:"6 10 6 6"}}}},palette:[],graph:{title:{width:"100%",bold:1,"font-size":13},subtitle:{width:"100%",bold:1,"font-size":11},scroll:{bar:{"background-color":"#e1eaec","border-color":"#ddd"},handle:{"background-color":"#ddd","border-color":"#ccc","border-width":2,"border-top":"2px solid #eee","border-left":"2px solid #eee","border-right":"2px solid #999","border-bottom":"2px solid #999"}},"scroll-x":{bar:{height:16},handle:{height:16}},"scroll-y":{bar:{width:16},handle:{width:16}},"scroll-xi":{bar:{width:16},handle:{width:16}},"scroll-yi":{bar:{height:16},handle:{height:16}},preview:{width:"100%",height:50,margin:"auto 50 20 50","border-width":1,shadow:0,"background-color":"#f0f0f0","border-color":"#999",mask:{alpha:.5,"background-color":"#333"},active:{alpha:.1,"background-color":"#999"},handle:{width:9,height:16,"border-width":1,"line-width":1,"line-color":"#111","border-color":"#444","border-radius":2,"background-color":"#e6e6e6"},"handle-top":{width:16,height:9},"handle-bottom":{width:16,height:9}},"preview[yx]":{width:50,height:"100%",margin:"20 auto 50 20"},plotarea:{width:"100%",height:"100%",margin:"60 50 65 50"},"plotarea[preview]":{margin:"60 50 105 50"},SCALE:{"line-width":1,guide:{"line-width":1,"line-color":"#ddd"},tick:{size:6,"line-width":2},"minor-guide":{"line-width":1,"line-color":"#ddd"},"minor-tick":{size:4,"line-width":1},label:{bold:1,padding:6,flat:!0},item:{padding:2,"auto-align":!0,flat:!0},marker:{"line-width":1,"line-color":"#000","background-color":"#ccc"},"transform[date]":{item:{"font-size":10,padding:2,color:"#000","background-color":"#fff"}}},"SCALE[3d]":{"background-color":"#ccc"},"scale-y[default]":{label:{"font-angle":270},item:{"text-align":"right"}},"scale-y[opposite]":{label:{"font-angle":90},item:{"text-align":"left"}},plot:{error:{"line-width":1,"line-color":"#333",size:.5},"value-box":{flat:!0,text:"%v",bold:1,placement:"auto",shadow:1},"tooltip-text":"%v",shadow:1,"line-width":1,marker:{type:"square",shadow:1},"highlight-state":{shadow:!0,"shadow-blur":2,"shadow-distance":1,"shadow-alpha":.91}},tooltip:{shadow:1,padding:"4 8","shadow-distance":3,"offset-y":ZC.mobile?-40:-20},"tooltip[dynamic]":{padding:"4 8","offset-y":0},guide:{marker:{type:"circle"},"plot-label[single]":{text:'<b style="color:%color">%plot-text:</b> %node-value',padding:10,"background-color":"#fff #eee","border-width":1,"border-color":"#999",color:"#000","text-align":"left"},"plot-label[multiple]":{text:'<b style="color:%color">%plot-text:</b> %node-value',padding:5,"background-color":"#fff #eee","border-width":1,"border-color":"#999",color:"#000","text-align":"left"}},zoom:{"preserve-zoom":1,"border-width":0,"background-color":"#369",alpha:.25,label:{visible:!1,"background-color":"#fff","font-size":10,padding:2,"border-width":1,"border-color":"#999"}},arrow:{"border-width":1,"border-color":"#000","background-color":"#666",size:4},"legend[position]":{margin:10},legend:{"background-color":"#eee",alpha:1,shadow:1,margin:"10 10 auto auto",padding:"4 2 4 2",item:{"text-align":"left",margin:"2 6 2 4",padding:"2 4"},"item-off":{alpha:.25},marker:{shadow:0,size:6,"border-color":"#999","border-width":1},header:{"font-size":12,"text-align":"left",bold:1},footer:{"text-align":"left"},icon:{"line-color":"#000","line-width":1},"page-status":{color:"#000"},"page-on":{"background-color":"#f90"},"page-off":{"background-color":"#999"},scroll:{bar:{width:12,height:12,"background-color":"#e1eaec","border-color":"#ddd"},handle:{width:12,height:12,"background-color":"#ddd","border-color":"#ccc","border-width":2,"border-top":"2px solid #eee","border-left":"2px solid #eee","border-right":"2px solid #999","border-bottom":"2px solid #999"}}}},vbar:{plot:{"value-box":{placement:"top-out"}}},vbar3d:{plot:{"value-box":{placement:"top-out"}},"3d-aspect":{depth:40,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0}},mixed3d:{"3d-aspect":{depth:40,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0}},hbar:{"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x[default]":{label:{"font-angle":270}},"scale-x[opposite]":{label:{"font-angle":90}},plot:{"value-box":{placement:"top-out"}}},vline:{"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x[default]":{label:{"font-angle":270}},"scale-x[opposite]":{label:{"font-angle":90}}},varea:{plot:{"fill-angle":0},"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x[default]":{label:{"font-angle":270}},"scale-x[opposite]":{label:{"font-angle":90}}},hbar3d:{"scale-y":{label:{"font-angle":0}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0}},"scale-x-n":{label:{"font-angle":90}},"3d-aspect":{depth:40,angle:45,"x-angle":0,"y-angle":-20,"z-angle":0},plot:{"value-box":{placement:"top-out"}}},hbullet:{"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x-n":{label:{"font-angle":90}}},line:{plot:{"line-width":4,marker:{type:"circle",size:4}}},area:{plot:{"line-width":4,marker:{type:"circle",size:4},"value-box":{placement:"top"}}},line3d:{"3d-aspect":{depth:40,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0},plot:{"border-width":1,"line-width":1,marker:{type:"circle",size:4,alpha:1,visible:0}}},area3d:{"3d-aspect":{depth:40,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0},plot:{"border-width":1,"line-width":1,marker:{type:"circle",size:4,alpha:1,visible:0},"value-box":{placement:"top"}}},scatter:{SCALE:{offset:10},plot:{marker:{type:"circle",size:4},"value-box":{placement:"top"}}},poly:{SCALE:{offset:10},plot:{"alpha-area":.4,marker:{type:"none"},"value-box":{placement:"top"}}},hscatter:{SCALE:{offset:10},"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x-n":{label:{"font-angle":90}},plot:{marker:{type:"circle",size:4},"value-box":{placement:"top"}}},bubble:{SCALE:{offset:40},plot:{marker:{type:"circle","fill-type":"radial","fill-offset-x":-.2,"fill-offset-y":-.2},"hover-marker":{"fill-type":"radial","fill-offset-x":-.2,"fill-offset-y":-.2},"value-box":{placement:"middle",text:"%node-size-value"},"tooltip-text":"%node-size-value"}},hbubble:{SCALE:{offset:40},"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x-n":{label:{"font-angle":90}},plot:{marker:{type:"circle","fill-type":"radial","fill-offset-x":-.2,"fill-offset-y":-.2},"hover-marker":{"fill-type":"radial","fill-offset-x":-.2,"fill-offset-y":-.2},"value-box":{placement:"middle",text:"%node-size-value"},"tooltip-text":"%node-size-value"}},hmixed:{"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x-n":{label:{"font-angle":90}}},pie:{plotarea:{margin:"35 5 5 5"},scale:{"size-factor":"auto","line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0}},plot:{"fill-type":"radial","value-box":{connector:{"line-width":1},placement:"out",text:"%t",visible:1}}},pie3d:{"3d-aspect":{"x-angle":38,"y-angle":0,"z-angle":0},plotarea:{margin:"25 5 5 5"},scale:{"size-factor":"auto","line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0}},plot:{"fill-type":"linear","value-box":{connector:{"line-width":1},placement:"out",text:"%t",visible:1}}},nestedpie:{plotarea:{margin:"40 5 15 5"},scale:{"size-factor":.8,"line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0}},plot:{"fill-type":"radial","value-box":{connector:{"line-width":1},text:"%t",visible:1}}},venn:{plotarea:{margin:"30 10 10 10"},plot:{alpha:.5,"border-width":4},scale:{"size-factor":.65,"line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0}}},radar:{SCALE:{guide:{"line-width":1,"line-color":"#999","background-color":"-1"},tick:{"line-width":1},item:{"auto-align":!1}},scale:{visible:0,"size-factor":.7},"scale-k":{"ref-angle":270},plotarea:{margin:"40 5 5 5"},plot:{"line-width":4,aspect:"line",marker:{type:"circle"}}},gauge:{SCALE:{guide:{"border-width":1,"border-color":"#999","background-color":"-1"}},scale:{"line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0},"size-factor":.7},"scale-r":{"ref-angle":270,"background-color":"#fff",guide:{"line-width":0},tick:{placement:"inner"},item:{"offset-r":"-45%"}},plot:{size:"85%"},plotarea:{margin:"40 5 5 5"}},stock:{plot:{"line-width":1,"border-width":1,"tooltip-text":"Open:&nbsp;$%open<br>High:&nbsp;$%high<br>Low:&nbsp;$%low<br>Close:&nbsp;$%close"}},range:{plot:{"line-width":2,"value-box":{text:"%node-min-value - %node-max-value"},"tooltip-text":"%node-min-value - %node-max-value"}},"-":""},this.PL=function(e,t){var i,n=this,a=!1;return null!==ZC._n_(i=n.B8.graph[e])&&null!==ZC._n_(i.enabled)&&(a=a||ZC._b_(i.enabled)),null!==ZC._n_(n.B8[t])&&null!==ZC._n_(i=n.B8[t][e])&&null!==ZC._n_(i.enabled)&&(a=a||ZC._b_(i.enabled)),a},this.load=function(e,t,i,n){var a,r,l,o=this;i=null===ZC._n_(i)||ZC._b_(i),n=null!==ZC._n_(n)&&ZC._b_(n),t instanceof Array||(t=new Array(t));var s=[],c="";for(r=0,l=t.length;r<l;r++)if(/(\(\w+\))(.*)/.test(t[r])){var h=RegExp.$1;c=t[r].replace(h,"graph"),-1===ZC.AV(s,c)&&s.push(c),c=t[r].replace(h,h.substring(1,h.length-1)),-1===ZC.AV(s,c)&&s.push(c)}else-1===ZC.AV(s,t[r])&&s.push(t[r]),/root(.*)/.test(t[r])&&-1===ZC.AV(s,t[r].replace("root","loader"))&&s.push(t[r].replace("root","loader")),/loader(.*)/.test(t[r])&&-1===ZC.AV(s,t[r].replace("loader","root"))&&s.push(t[r].replace("loader","root"));var C={};for(r=0,l=s.length;r<l;r++){for(var u=s[r].split("."),d=o.B8,A=0,p=u.length;A<p;A++)if(null!==ZC._n_(a=d[u[A]]))d=a;else if(null!==ZC._n_(a=d[ZC.UJ(u[A])]))d=a;else{if(null===ZC._n_(a=d[ZC.EE(u[A])])){d=null;break}d=a}if(d)for(var g in d)null!==ZC._n_(d[g])&&(n||"object"!=typeof d[g]||d[g].length)&&(i||null===ZC._n_(e[g])?o.H.QP&&null!==ZC._n_(o.H.QP[g])||(C[g]=d[g]):i&&"object"==typeof d[g]&&(o.H.QP&&null!==ZC._n_(o.H.QP[g])||(C[g]=d[g])))}ZC._cp_(C,e)}},ZC.AP={AGL:function(e,t){for(var i=[],n=0,a=e.p.length;n<a;n++)if(e.p[n]){var r=(e.p[n][0]-e.x)/e.w,l=(e.p[n][1]-e.y)/e.h;i.push([t.x+t.w*r,t.y+t.h*l])}else i.push(null);return{l:t.w*e.l/e.w,r:t.w*e.r/e.w,p:i}},ACC:function(e,t,i){var n=document.getElementsByTagName("head")[0],a=document.createElement("script");a.type="text/javascript",a.src=t+"?v"+ZC.VERSION;var r=!1;a.onload=a.onreadystatechange=function(){if(!(r||this.readyState&&"loaded"!==this.readyState&&"complete"!==this.readyState)){r=!0,a.onload=a.onreadystatechange=null,n&&a.parentNode&&n.removeChild(a);var e=new RegExp("zingchart-(.+?).min.js","g").exec(t);e&&ZC.WI.push(e[1]),i&&i(t)}},a.onerror=function(){!e&&zingchart.HZ[0]&&(e=zingchart.HZ[0]),e?e.NU({name:"Network error",message:"Resource not found ("+a.src+")"},"Module loader"):alert("Resource not found ("+a.src+")")},n.insertBefore(a,n.firstChild)},_rcolor_:function(){return"#"+ZC.XK.md5(ZC._r_(0,99999)).substr(ZC._r_(0,20),6)},WQ:function(){},A83:function(e,t){return zingchart[e]||t&&t.A18&&t.A18[e]||zingchart.hasEvent(null,e)||t&&zingchart.hasEvent(t.K,e)},BY:function(e,t,i,n,a){i instanceof Array||(i=[i]);var r=1;return null!==ZC._n_(n)&&i.push(n),a&&(r=2,i.push(a)),"touchstart"===e&&(e="mousedown"),"touchend"===e&&(e="mouseup"),"touchmove"===e&&(e="mousemove"),zingchart[e]&&"render"!==e&&(null!==ZC._n_(n)?i[i.length-r]=zingchart[e].apply(zingchart,i):zingchart[e].apply(zingchart,i)),t&&t.A18[e]&&(null!==ZC._n_(n)?i[i.length-r]=t.A18[e].apply(zingchart,i):t.A18[e].apply(zingchart,i)),zingchart.hasEvent(null,e)&&(null!==ZC._n_(n)?i[i.length-r]=zingchart.callEvent(null,e,i,n):zingchart.callEvent(null,e,i)),t&&zingchart.hasEvent(t.K,e)&&(null!==ZC._n_(n)?i[i.length-r]=zingchart.callEvent(t.K,e,i,n):zingchart.callEvent(t.K,e,i)),i[i.length-r]},O5:function(e,t){if(t.A9%360!=0){for(var i=[[-t.I/2,-t.F/2],[t.I/2,-t.F/2],[t.I/2,t.F/2],[-t.I/2,t.F/2]],n="",a=0;a<4;a++)i[a]=[t.iX+t.I/2+t.BM+ZC.MAPTX+i[a][0]*ZC.EH(t.A9)-i[a][1]*ZC.EP(t.A9),t.iY+t.F/2+t.BH+ZC.MAPTX+i[a][0]*ZC.EP(t.A9)+i[a][1]*ZC.EH(t.A9)],n+=ZC._i_(i[a][0])+","+ZC._i_(i[a][1])+",";return t.D=i,ZC.Q.G0("poly",t.EA,t.IV)+'class="'+e+'-label-area zc-label-area" id="'+t.K+'-area" coords="'+n.substring(0,n.length-1)+'" />'}return ZC.Q.G0("rect",t.EA,t.IV)+'class="'+e+'-label-area zc-label-area" id="'+t.K+'-area" coords="'+ZC._i_(t.iX+t.BM+ZC.MAPTX)+","+ZC._i_(t.iY+t.BH+ZC.MAPTX)+","+ZC._i_(t.iX+t.BM+t.I+ZC.MAPTX)+","+ZC._i_(t.iY+t.BH+t.F+ZC.MAPTX)+'" />'},N2:function(e){var t,i="",n=e.indexOf('id="');if(-1!==n){var a=e.indexOf('"',n+4);-1!==a&&(i=e.substring(n+4,a))}if(ZC.cache.data["area-score-"+i])return ZC.cache.data["area-score-"+i];var r=0;if(-1!==e.indexOf('shape="rect"')?(r+=1e4,5===(t=/coords=\"(\-*\d+),(\-*\d+),(\-*\d+),(\-*\d+)\"/.exec(e)).length&&(r+=(ZC._i_(t[3])-ZC._i_(t[1]))*(ZC._i_(t[4])-ZC._i_(t[2])))):-1!==e.indexOf('shape="circle"')?(r+=100,t=/coords=\"(\-*\d+),(\-*\d+),(\-*\d+)\"/.exec(e),null!==ZC._n_(t[3])&&(r+=ZC._i_(t[3])/10)):-1!==e.indexOf('shape="poly"')?-1!==e.indexOf("data-map")?r+=1e6:r+=1e3:r+=1,-1!==e.indexOf("data-z-sort")){var l=/data-z-sort=\"(\-*\d+)\"/.exec(e);l&&2===l.length&&(r*=ZC._i_(Math.pow(10,ZC._i_(l[1]))))}return""!==i&&ZC.cache.add("area-score-"+i,r),r},A5B:function(e,t,i){for(var n=[],a=0,r=e.length;a<r;a++)if(null!==ZC._n_(e[a])){var l=e[a].slice(0);null!==ZC._n_(l[0])&&"string"!=typeof l[0]&&(l[0]+=t),null!==ZC._n_(l[1])&&"string"!=typeof l[1]&&(l[1]+=i),null!==ZC._n_(l[2])&&"string"!=typeof l[2]&&l.length<=4&&(l[2]+=t),null!==ZC._n_(l[3])&&"string"!=typeof l[3]&&l.length<=4&&(l[3]+=i),n.push(l)}else n.push(null);return n},O3:function(e,t){var i;t=t||{},e=e||{};var n={};if(null!==ZC._n_(i=e.negation)&&(n.negation=i),null!==ZC._n_(i=e.short)&&(n.short=ZC._b_(i)),null!==ZC._n_(i=e["short-unit"])&&(n["short-unit"]=i),null!==ZC._n_(i=e.exponent)&&(n.exponent=ZC._b_(i)),null!==ZC._n_(i=e["exponent-decimals"])&&(n["exponent-decimals"]=ZC._i_(i)),null!==ZC._n_(i=e["decimals-separator"])?n["decimals-separator"]=i:null===ZC._n_(t["decimals-separator"])&&null!==ZC._n_(i=ZC.HJ["decimals-separator"])&&(n["decimals-separator"]=i),null!==ZC._n_(i=e["thousands-separator"])?n["thousands-separator"]=i:null===ZC._n_(t["thousands-separator"])&&null!==ZC._n_(i=ZC.HJ["thousands-separator"])&&(n["thousands-separator"]=i),null!==ZC._n_(i=e.decimals)&&(n.decimals=ZC._i_(i)),null!==ZC._n_(i=e["decimals-dyn"])&&(n["decimals-dyn"]=i),null!==ZC._n_(i=e.transform)&&null!==ZC._n_(i.type))switch(i.type){case"date":n["transform-date"]=!0,null!==ZC._n_(i.text)&&(i.all=i.text),null!==ZC._n_(i.all)&&(n["transform-date-format"]=i.all)}return n},G2:function(e,t,i,n){var a,r=e,l=e+"",o=!1;if(n&&null!==ZC._n_(t["transform-date"])&&t["transform-date"]&&""+Number(l)===l&&(l=ZC.AP.Y5(Number(l),t["transform-date-format"],t.utc,t.timezone),o=!0),null===ZC._n_(t["decimals-separator"])&&null!==ZC._n_(e=ZC.HJ["decimals-separator"])&&(t["decimals-separator"]=e),null===ZC._n_(t["thousands-separator"])&&null!==ZC._n_(e=ZC.HJ["thousands-separator"])&&(t["thousands-separator"]=e),null!==ZC._n_(t.decimals)&&-1!==t.decimals&&"undefined"!=typeof t["max-decimals"]&&-1!==t["max-decimals"]&&(t.decimals=ZC.BQ(t["max-decimals"],t.decimals)),!o)if(null!==ZC._n_(t.exponent)&&t.exponent)l=Number(l).toExponential(ZC.CY(20,t["exponent-decimals"])),null!==ZC._n_(t["decimals-separator"])&&(l=l.replace(/\./g,t["decimals-separator"]));else{if(null!==ZC._n_(t.short)&&t.short){a="";var s=t["short-unit"]||"";if("string"!=typeof s&&s.length){""+ZC._f_(s[0])!==s[0]&&(s=[1e3].concat(s));for(var c=1,h=s[0]||1e3,C=s.slice(1),u=null,d=0;d<C.length;d++)0===C[d].indexOf("#")&&(u=d,C[d]=C[d].substring(1));if(C.length){if(null!==u)c=u;else if(null!==ZC._n_(t["max-power"]))c=t["max-power"];else{var A=ZC.G6(ZC._a_(Number(l)),h);c=Math.floor(A),c=ZC.CY(c,C.length-1)}a=C[c];var p=(l=""+Number(l)/Math.pow(h,c)).split(".");2===p.length&&p[1].length>=9&&(l=null!==ZC._n_(t.decimals)&&-1!==t.decimals?""+ZC._x_(l,t.decimals):""+ZC._x_(l))}}else{var g=ZC.G6(ZC._a_(Number(l)))/Math.LN10;switch(ZC._a_(Number(l))){case 1e3:g=3;break;case 1e6:g=6;break;case 1e9:g=9}if(null!==ZC._n_(t["max-power"])&&(g=3*t["max-power"]),"KB"===s.toUpperCase())l=""+Number(l)/1024,a="KB";else if("MB"===s.toUpperCase())l=""+Number(l)/1048576,a="MB";else if("GB"===s.toUpperCase())l=""+Number(l)/1073741824,a="GB";else if("TB"===s.toUpperCase())l=""+Number(l)/1099511627776,a="TB";else if("PB"===s.toUpperCase())l=""+Number(l)/0x4000000000000,a="PB";else if(g>=0&&g<3)switch(s){default:l=l,a="";break;case"K":l=""+Number(l)/1e3,a="K";break;case"M":l=""+Number(l)/1e6,a="M";break;case"B":l=""+Number(l)/1e9,a="B"}else g>=3&&g<6&&""===s||"K"===s.toUpperCase()?(l=""+Number(l)/1e3,a="K"):g>=6&&g<9&&""===s||"M"===s.toUpperCase()?(l=""+Number(l)/1e6,a="M"):(g>=9&&""===s||"B"===s.toUpperCase())&&(l=""+Number(l)/1e9,a="B")}if(ZC.P5(l))if(null!==ZC._n_(t.decimals)&&-1!==t.decimals)l=ZC._fixed_(Number(l),ZC.BQ(0,ZC._i_(t.decimals)));else{var Z=l.split(".")[1]||"";-1!==t["max-decimals"]&&t["max-decimals"]<Z.length&&(l=ZC._fixed_(Number(l),ZC.BQ(0,ZC._i_(t["max-decimals"]))))}null!==ZC._n_(t["decimals-separator"])&&(l=l.replace(/\./g,t["decimals-separator"]))}var f=i?i.K:"";if(!isNaN(l)&&("string"!=typeof r||-1===f.indexOf("-scale-"))){if(null!==ZC._n_(t.decimals)&&-1!==t.decimals&&ZC.P5(l)&&(null!==ZC._n_(t.short)&&t.short||(l=ZC._fixed_(Number(l),ZC.BQ(0,ZC._i_(t.decimals))))),null!==ZC._n_(t["thousands-separator"])||null!==ZC._n_(t["decimals-separator"])){for(var _=l.split("."),b="",m=0,v=_[0].length;m<v;m++){var E=_[0].substring(m,m+1);b+=E,-1===ZC.AV(["-","+"],E)&&(_[0].length-m-1)%3==0&&_[0].length-m-1!=0&&(b+=t["thousands-separator"])}l=b+(null!==ZC._n_(_[1])?t["decimals-separator"]+_[1]:"")}null!==ZC._n_(t.short)&&t.short&&(l+=a)}}return l},AAH:function(e){var t=e.indexOf("("),i="",n="";-1!==t?(i=ZC.GV(e.substring(0,t)),n=ZC.GV(e.substring(t+1,e.length-1))):i=ZC.GV(e);var a=[],r="";if(""!==n){var l=!1,o=!1,s=!1;r="";for(var c=0,h=n.length;c<h;c++){var C=n.substring(c,c+1);switch(C){case"\\":s?(r+="\\",s=!1):s=!0;break;case'"':s?(r+='"',s=!1):o?(a.push(r),r="",o=!1):l?r+=C:o=!0;break;case"'":s?(r+="'",s=!1):l?(a.push(r),r="",l=!1):o?r+=C:l=!0;break;case" ":(l||o)&&(r+=C);break;case",":l||o?r+=C:(""!==r&&a.push(r),r="");break;default:r+=C}}}return""!==r&&a.push(r),[i,a]},A4T:function(e){return e.toString().replace(/^([0-9])$/,"0$1")},Y5:function(e,t,i,n){e=ZC._i_(e),t=t||ZC.HJ["date-formats"].minute,void 0===i&&(i=!1),void 0===n&&(n=0),i&&(e+=36e5*n);var a,r,l,o,s,c,h,C,u=new Date;u.setTime(e),i?(a=u.getUTCHours(),r=u.getUTCMinutes(),l=u.getUTCSeconds(),o=u.getUTCMilliseconds(),s=u.getUTCDay(),c=u.getUTCDate(),h=u.getUTCMonth(),C=u.getUTCFullYear()):(a=u.getHours(),r=u.getMinutes(),l=u.getSeconds(),o=u.getMilliseconds(),s=u.getDay(),c=u.getDate(),h=u.getMonth(),C=u.getFullYear());for(var d=[["mm",ZC.AP.A4T(h+1)],["dd",ZC.AP.A4T(c)],["Y",C],["y",C.toString().substr(2,2)],["F",ZC.HJ["months-long"][h]],["m",h+1],["M",ZC.HJ["months-short"][h]],["n",h],["d",c],["D",ZC.HJ["days-short"][s]],["j",c],["l",ZC.HJ["days-long"][s]],["N",s+1],["w",s],["S",function(){return c%10==1?"st":c%10==2?"nd":c%10==3?"rd":"th"}],["a",a<12?"am":"pm"],["A",a<12?"AM":"PM"],["g",a%12||12],["G",a],["h",ZC.AP.A4T(a%12||12)],["H",ZC.AP.A4T(a)],["i",ZC.AP.A4T(r)],["s",ZC.AP.A4T(l)],["q",o]],A=0;A<d.length;A++)t=t.replace("%"+d[A][0],d[A][1]);return t},A0D:{},YN:function(e,t){var i=null;if(t&&t.BP?i=t.BP:t&&t.A&&t.A.BP&&(i=t.A.BP),"string"==typeof e&&-1!==e.indexOf("%color-")&&ZC.COLORS.length>0)for(var n=0;n<ZC.COLORS.length;n++)-1===e.indexOf("(+")&&-1===e.indexOf("(-")||(e=e.replace(/%color-(\d+?)\((\+|\-)(\d+?)\)/gi,function(){var e=ZC.AP.GC(ZC.COLORS[ZC._i_(arguments[1])]);return"+"===arguments[2]?e=ZC.AP.QU(e,ZC._i_(arguments[3])):"-"===arguments[2]&&(e=ZC.AP.JN(e,ZC._i_(arguments[3]))),e})),e=e.replace("%color-"+n,ZC.COLORS[n]);else"string"==typeof e&&i&&-1!==e.indexOf("%palette-")&&(e=i[ZC._i_(e.replace("%palette-",""))]);return e},GC:function(e,t){var i,n,a,r;if(null!==ZC._n_(ZC.AP.A0D[e]))return ZC.AP.A0D[e];var l=ZC.GV(String(e)),o=1,s=!1;return 0===l.length?"":("rgba("===(l=l.replace("0x","#")).substring(0,5)?(i=new RegExp("rgba\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3}),\\s*([0-9.]+)\\)","gi").exec(l))&&(1===(n=ZC.OT(i[1])).length&&(n="0"+n),1===(a=ZC.OT(i[2])).length&&(a="0"+a),1===(r=ZC.OT(i[3])).length&&(r="0"+r),l="#"+n+a+r,o=ZC.BQ(0,ZC.CY(1,parseFloat(i[4]))),s=!0):"rgb("===l.substring(0,4)?(i=new RegExp("rgb\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\)","gi").exec(l))&&(1===(n=ZC.OT(i[1])).length&&(n="0"+n),1===(a=ZC.OT(i[2])).length&&(a="0"+a),1===(r=ZC.OT(i[3])).length&&(r="0"+r),l="#"+n+a+r):"#"===l.substring(0,1)?4===l.length?l="#"+l.substring(1,2)+l.substring(1,2)+l.substring(2,3)+l.substring(2,3)+l.substring(3,4)+l.substring(3,4):7!==l.length&&(l=""):null!==ZC._n_(ZC.Q.A9O[l.toUpperCase()])&&(l="#"+ZC.Q.A9O[l.toUpperCase()]),"none"!==l&&"transparent"!==l||(l="-1"),t||(ZC.AP.A0D[e]=l),t&&s?[l,o]:l)},A1N:{},A32:function(e,t){if(-1===e&&(e="#ffffff",t=0),null!==ZC._n_(ZC.AP.A1N[e+","+t]))return ZC.AP.A1N[e+","+t];4===e.length&&(e=e.substring(0,1)+e.substring(1,2)+e.substring(1,2)+e.substring(2,3)+e.substring(2,3)+e.substring(3,4)+e.substring(3,4));var i="rgba("+[ZC.QX(e.substring(1,3)),ZC.QX(e.substring(3,5)),ZC.QX(e.substring(5,7)),t].join(",")+")";return ZC.AP.A1N[e+","+t]=i,i},AD9:function(e,t,i){e/=255,t/=255,i/=255;var n,a,r,l=Math.max(e,t,i),o=Math.min(e,t,i);r=l;var s=l-o;if(a=0===l?0:s/l,l===o)n=0;else{switch(l){case e:n=(t-i)/s+(t<i?6:0);break;case t:n=(i-e)/s+2;break;case i:n=(e-t)/s+4}n/=6}return[n,a,r]},AD7:function(e,t,i){var n,a,r,l=Math.floor(6*e),o=6*e-l,s=i*(1-t),c=i*(1-o*t),h=i*(1-(1-o)*t);switch(l%6){case 0:n=i,a=h,r=s;break;case 1:n=c,a=i,r=s;break;case 2:n=s,a=i,r=h;break;case 3:n=s,a=c,r=i;break;case 4:n=h,a=s,r=i;break;case 5:n=i,a=s,r=c}return[255*n,255*a,255*r]},JN:function(e,t){if(-1===e)return-1;if(t>=100)return"#000000";e=ZC.AP.GC(e),void 0===t&&(t=10);var i=ZC.QX(e.substring(1,3)),n=ZC.QX(e.substring(3,5)),a=ZC.QX(e.substring(5,7)),r=ZC.AP.AD9(i,n,a);r[2]=t>0?Math.max(0,r[2]-r[2]*t/100):Math.min(1,r[2]-r[2]*t/100);var l=ZC.AP.AD7(r[0],r[1],r[2]);return l[0]=ZC._i_(l[0])<16?"0"+ZC.OT(l[0]):ZC.OT(l[0]),l[1]=ZC._i_(l[1])<16?"0"+ZC.OT(l[1]):ZC.OT(l[1]),l[2]=ZC._i_(l[2])<16?"0"+ZC.OT(l[2]):ZC.OT(l[2]),e="#"+l[0]+l[1]+l[2]},QU:function(e,t){if(-1===e)return-1;if(t>=100)return"#ffffff";e=ZC.AP.GC(e),void 0===t&&(t=10);var i=parseInt(e.substr(1,2),16),n=parseInt(e.substr(3,2),16),a=parseInt(e.substr(5,2),16);return"#"+(0|256+i+(256-i)*t/100).toString(16).substr(1)+(0|256+n+(256-n)*t/100).toString(16).substr(1)+(0|256+a+(256-a)*t/100).toString(16).substr(1)},_hex2rgb_:function(e,t){var i=parseInt(e.substr(1,2),16),n=parseInt(e.substr(3,2),16),a=parseInt(e.substr(5,2),16);return ZC._n_(t)?"rgb("+i+","+n+","+a+")":{r:i,g:n,b:a}},_rgb2hex_:function(e,t,i){return"#"+((1<<24)+(e<<16)+(t<<8)+i).toString(16).slice(1)},AA9:function(e,t,i){var n=ZC.AP._hex2rgb_(e);return(299*n.r+587*n.g+114*n.b)/1e3>=128?i:t},_colorAlpha_:function(e,t,i){e=ZC.AP.GC(e),t=ZC.AP.GC(t);var n=ZC.AP._hex2rgb_(e),a=ZC.AP._hex2rgb_(t),r={};for(var l in n)r[l]=Math.floor(i*n[l]+(1-i)*a[l]);return ZC.AP._rgb2hex_(r.r,r.g,r.b)},A3E:function(){},ABR:function(){},gc:function(e,t){var i;for(i=0;i<t.length;i++)e[t[i]]=null;for(i in e)0===i.indexOf("zc_")&&"function"==typeof e[i]&&(e[i]=null)}},ZC.Q={A9O:{BLACK:"000000",BLUE:"0000FF",BROWN:"A52A2A",CYAN:"00FFFF",FUCHSIA:"FF00FF",GOLD:"FFD700",GRAY:"808080",GREEN:"008000",INDIGO:"4B0082",LIME:"00FF00",MAGENTA:"FF00FF",MAROON:"800000",NAVY:"000080",ORANGE:"FFA500",PINK:"FFC0CB",PURPLE:"800080",RED:"FF0000",SILVER:"C0C0C0",TURQUOISE:"40E0D0",VIOLET:"EE82EE",WHITE:"FFFFFF",YELLOW:"FFFF00"},G0:function(e,t,i){return"<area"+(i&&!t&&"hand"!==i?' style="cursor:'+i+'"':"")+(t&&"arrow"!==i||"hand"===i?' href="javascript:;"':"")+' shape="'+e+'" '},ABE:function(e){var t;if(ZC.A5.browser.msie)try{t=document.createElement("<iframe />")}catch(o){t=document.createElement("iframe")}else t=document.createElement("iframe");t.id=e.id+"-iframe",t.style.visibility="hidden",e.appendChild(t);var i=null,n=t.contentWindow||t.contentDocument;if(!(i=n.document?n.document:n).body){var a=i.createElement("HTML");i.appendChild(a);var r=i.createElement("HEAD");a.appendChild(r);var l=i.createElement("BODY");a.appendChild(l)}return i},BZ:function(e){var t;if("undefined"==typeof ZC.TOUCHEVENTS){if(ZC.ie678)t=!1;else{t=!0;try{document.createEvent("TouchEvent")}catch(i){t=!1}}t&&!ZC.mobile&&(t=!1),t&&(t="ontouchstart"in document.documentElement),ZC.TOUCHEVENTS=t}else t=ZC.TOUCHEVENTS;if(t)switch(e){case"mouseover":case"mousedown":e="touchstart";break;case"mousemove":e="touchmove";break;case"mouseout":case"mouseup":e="touchend";break;case"click":e="touchstart"}return e},_sh_:function(e,t){var i,n,a,r=[],l=t.JW,o=t.OH,s=t.PD,c=l-s/2;if(e.length>0){var h=0,C=0;for(0!==l&&(h=ZC._i_(c*ZC.EH(o)+s),C=ZC._i_(c*ZC.EP(o)+s)),i=0,n=e.length;i<n;i++)if(null!==ZC._n_(e[i])){var u=[];for(a=0;a<e[i].length;a++)u[a]=e[i][a];var d=u.length;if(2===d||4===d)for(a=0;a<d;a++)u[a]=e[i][a]+(a%2?C+ZC._c_(t.BH,0):h+ZC._c_(t.BM,0));r.push(u)}else r.push(null)}return r},_txp_:function(e,t,i,n,a){void 0===a&&(a=!1);var r,l,o=[e[0],e[1]];switch(e.length>=4&&(o[2]=e[2],o[3]=e[3]),e.length>=6&&(o[4]=e[4],o[5]=e[5]),7===e.length&&(o[6]=e[6]),t){case"canvas":case"svg":var s,c;if(i.CZ)s=c=i.AZ%2==1?.5:0,ZC.A5.browser.msie&&ZC.quirks&&"svg"===t&&(s=i.AZ%2==1?.5:0,c=i.AZ%2==1?0:.5),o[0]=Math.round(o[0])-s,o[1]=Math.round(o[1])-c,4===o.length&&(o[2]=Math.round(o[2])-s,o[3]=Math.round(o[3])-c);"svg"===t&&(o[0]=parseFloat(o[0].toFixed(4)),o[1]=parseFloat(o[1].toFixed(4)),4===o.length&&(o[2]=parseFloat(o[2].toFixed(4)),o[3]=parseFloat(o[3].toFixed(4)))),"canvas"!==t||n||"undefined"!=typeof i.BM&&"undefined"!=typeof i.BH&&(o[0]+=i.BM,o[1]+=i.BH,4===o.length&&(o[2]+=i.BM,o[3]+=i.BH));break;case"vml":i.A9%360==0?(r=10,l=i.AZ%2==1?0:r/2):(r=1,l=0),i.CZ?(o[0]=r*ZC._i_(ZC._i_(r*o[0])/r)-l,o[1]=r*ZC._i_(ZC._i_(r*o[1])/r)-l,4!==o.length&&7!==o.length||(o[2]=r*ZC._i_(ZC._i_(r*o[2])/r)-l,o[3]=r*ZC._i_(ZC._i_(r*o[3])/r)-l),7===o.length&&(o[4]=r*ZC._i_(ZC._i_(r*o[4])/r)-l,o[5]=r*ZC._i_(ZC._i_(r*o[5])/r)-l)):(o[0]=ZC._i_(r*o[0]),o[1]=ZC._i_(r*o[1]),4!==o.length&&7!==o.length||(o[2]=ZC._i_(r*o[2]),o[3]=ZC._i_(r*o[3])),7===o.length&&(o[4]=ZC._i_(r*o[4]),o[5]=ZC._i_(r*o[5])))}return o},A2W:function(e,t,i,n,a){var r,l,o,s,c,h,C;if(i.QW&&(i.E["fast-vector-path"]=!0),!i.E["fast-vector-path"]){for(r=0,l=e.length;r<l;r++)e[r]&&(e[r][0]=parseFloat(Number(e[r][0]).toFixed(2)),e[r][1]=parseFloat(Number(e[r][1]).toFixed(2)));if(i.O7&&(C=i.K+":"+i.A9+":"+e.join("#"),ZC.cache.data["path-points-"+C]))return ZC.cache.data["path-points-"+C].split("#")}var u=[ZC.MAX,ZC.MAX,-ZC.MAX,-ZC.MAX],d=[],A=!1;for(r=0,l=e.length;r<l;r++)if(null!==ZC._n_(e[r])){if(i.E["fast-vector-path"]){if(o=e[r],"vml"===t){var p=i.A9%360==0?10:1;o[0]=ZC._i_(p*o[0]),o[1]=ZC._i_(p*o[1]),4===o.length&&(o[2]=ZC._i_(p*o[2]),o[3]=ZC._i_(p*o[3]))}}else o=ZC.Q._txp_(e[r],t,i,n,a);if(null!==ZC._n_(o)&&!isNaN(o[0])&&!isNaN(o[1])&&isFinite(o[0])&&isFinite(o[1]))if(l<=20&&n&&(u[0]=ZC.CY(u[0],o[0]/("vml"===t?10:1)),u[1]=ZC.CY(u[1],o[1]/("vml"===t?10:1)),u[2]=ZC.BQ(u[2],o[0]/("vml"===t?10:1)),u[3]=ZC.BQ(u[3],o[1]/("vml"===t?10:1))),0===r)d.push(("svg"===t?"M ":"m ")+o[0]+" "+o[1]);else if(A&&(d.push(("svg"===t?"M ":"m ")+o[0]+" "+o[1]),A=!1),2===o.length)d.push(("svg"===t?"L ":"l ")+o[0]+" "+o[1]);else if(4===o.length)d.push(("svg"===t?"Q ":"qb ")+o[0]+" "+o[1]+" "+o[2]+" "+o[3]),"vml"===t&&d.push("l "+o[2]+" "+o[3]);else if(6===o.length)if("svg"===t){var g=0;o[3]%360==o[4]%360&&(g=o[4]>=o[3]?.001:-.001),s=ZC.AQ.BN(o[0],o[1],o[2],o[3]+g),c=ZC.AQ.BN(o[0],o[1],o[2],o[4]-g),h="0 0",0===o[5]?o[4]-o[3]>360?(h="0 1",c[0]=s[0],c[1]=s[1]):h=o[4]-o[3]<=180?"0 1":"1 1":o[3]-o[4]>360?(h="0 0",c[0]=s[0],c[1]=s[1]):h=o[3]-o[4]<=180?"0 0":"1 0",d.push("a "+o[2]+","+o[2]+" 0 "+h+" "+(c[0]-s[0])+","+(c[1]-s[1]))}else"vml"===t&&(o[2]*=10,s=ZC.AQ.BN(o[0],o[1],o[2],o[3]),c=ZC.AQ.BN(o[0],o[1],o[2],o[4]),h=1===o[5]?"at":"wa",d.push(h+" "+ZC._i_(o[0]-o[2])+","+ZC._i_(o[1]-o[2])+","+ZC._i_(o[0]+o[2])+","+ZC._i_(o[1]+o[2])+" "+ZC._i_(s[0])+","+ZC._i_(s[1])+" "+ZC._i_(c[0])+","+ZC._i_(c[1])));else 7===o.length&&d.push(("svg"===t?"C ":"c ")+o[0]+" "+o[1]+" "+o[2]+" "+o[3]+" "+o[4]+" "+o[5])}else A=!0;return i.E["fast-vector-path"]||i.O7&&ZC.cache.add("path-points-"+C,d.join("#")),i.H&&l<=20&&n&&(i.H.E[i.K+"-bounds"]=u),d},MB:function(e,t){var i,n,a=e.originalEvent||e.originalEventZC;return t=ZC._i_(t||"0"),a&&a.touches?a.touches.length>0?(i=a.touches[t].pageX,n=a.touches[t].pageY):a.changedTouches.length>0&&(i=a.changedTouches[t].pageX,n=a.changedTouches[t].pageY):(i=e.pageX,n=e.pageY),[ZC._i_(i||"0"),ZC._i_(n||"0")]},F5:function(e,t,i){var n;return i=i||document,null!==ZC._n_(t)?i.createElementNS?n=i.createElementNS(t,e):(n=i.createElement(e)).setAttribute("xmlns",t):n=i.createElement(e),"zcv:"===e.substring(0,4)&&(n.className="zcvml"),n},EU:function(e){var t;e instanceof Array||(e=[e]);for(var i=0,n=e.length;i<n;i++)"object"!=typeof(t=e[i])&&(t=ZC.AK(e[i])),t&&("undefined"!=typeof t.parentElement?t.parentElement.removeChild(t):"undefined"!=typeof t.parentNode&&t.parentNode.removeChild(t))},G3:function(e,t){for(var i in t)if("string"==typeof i&&"object"!=typeof t[i]&&"function"!=typeof t[i])try{e.setAttribute(i,t[i])}catch(n){}},PJ:function(e,t){for(var i in t)"string"==typeof i&&"object"!=typeof t[i]&&"function"!=typeof t[i]&&(e.style[i]=t[i])},AB3:function(e){var t;if(e===document)return!0;if(!e)return!1;if(!e.parentNode)return!1;if(e.style){if("none"===e.style.display)return!1;if("hidden"===e.style.visibility)return!1}if(window.getComputedStyle){if("none"===(t=window.getComputedStyle(e,"")).display)return!1;if("hidden"===t.visibility)return!1}if(t=e.currentStyle){if("none"===t.display)return!1;if("hidden"===t.visibility)return!1}return ZC.Q.AB3(e.parentNode)},T8:function(e){var t=e.className||ZC.A5(e).attr("class");return null!==ZC._n_(t)&&"object"==typeof t&&(t="undefined"!=typeof t.baseVal?t.baseVal:""),t||""},IU:function(e,t,i,n,a,r,l,o){if(e)switch(l=l||"",t){case"canvas":o?e.getContext("2d").clearRect(i,n,a,r):e.width=e.width;break;case"vml":case"svg":var s=e.childNodes.length;if(s>1024&&"undefined"!=typeof e.innerHTML)return void(e.innerHTML="");if(s>0)for(var c=s-1;c>=0;c--)""===l?e.removeChild(e.childNodes[c]):0===e.childNodes[c].id.indexOf(l+"-")&&e.removeChild(e.childNodes[c])}},EB:function(e,t){switch("string"==typeof e&&(e=ZC.AK(e)),t){case"canvas":return e.getContext("2d");case"svg":case"vml":return e}},JZ:function(e,t){switch(t){case"svg":return ZC.Q.ABK(e);case"vml":case"canvas":return ZC.Q.HY(e)}},HC:function(e,t){switch(t){case"svg":return ZC.Q.ABK(e);case"vml":return ZC.Q.HY(e);case"canvas":return ZC.Q.ADB(e)}},ABK:function(e){var t;if(ZC.AK(e.id))return ZC.AK(e.id);var i=ZC.Q.F5("g","http://www.w3.org/2000/svg");return null!==ZC._n_(t=e.id)&&i.setAttribute("id",t),null!==ZC._n_(t=e.cls)&&i.setAttribute("class",t),null!==ZC._n_(t=e.zidx)&&i.setAttribute("z-index",t),null!==ZC._n_(t=e["clip-path"])&&i.setAttribute("clip-path",t),e.after?e.p.insertBefore(i,e.after.nextSibling):e.p.appendChild(i),i},X8:function(e){var t;ZC.Q.EU(e.id);var i=ZC.Q.F5("clipPath","http://www.w3.org/2000/svg");return i.id=e.id,null!==ZC._n_(e.cx)?((t=ZC.Q.F5("circle","http://www.w3.org/2000/svg")).id=e.id+"-shape",ZC.Q.G3(t,{cx:e.cx,cy:e.cy,r:e.r})):((t=ZC.Q.F5("polygon","http://www.w3.org/2000/svg")).id=e.id+"-shape",ZC.Q.G3(t,{points:e.path})),i.appendChild(t),i},ADB:function(e){var t;if(ZC.AK(e.id))return ZC.AK(e.id);var i=document.createElement("canvas"),n=i.style;if(null!==ZC._n_(t=e.id)&&(i.id=t),null!==ZC._n_(t=e.cls)&&(i.className=t),null!==ZC._n_(t=e.wh)){var a=(""+t).split("/");e.width=a[0],e.height=a[1]}if(null!==ZC._n_(t=e.tl)){var r=(""+t).split("/");e.top=r[0],e.left=r[1]}return i.width=e.width,i.height=e.height,null!==ZC._n_(t=e.left)&&(n.left=t+"px"),null!==ZC._n_(t=e.top)&&(n.top=t+"px"),null!==ZC._n_(t=e.display)&&(n.display=t),null!==ZC._n_(t=e.position)&&(n.position=t),null!==ZC._n_(t=e.zidx)&&(n.zIndex=t),e.p.appendChild(i),i},HY:function(e){var t,i,n,a,r,l;if(ZC.AK(e.id))return n=ZC.AK(e.id),null!==ZC._n_(t=e.wh)&&(r=(""+t).split("/"),n.style.width=r[0]+"px",n.style.height=r[1]+"px"),null!==ZC._n_(t=e.tl)&&(l=(""+t).split("/"),n.style.top=l[0]+"px",n.style.left=l[1]+"px"),n;(a=(n=document.createElement("div")).style).whiteSpace="nowrap",null!==ZC._n_(t=e.wh)&&(r=(""+t).split("/"),e.width=r[0],e.height=r[1]),null!==ZC._n_(t=e.tl)&&(l=(""+t).split("/"),e.top=l[0],e.left=l[1]),null!==ZC._n_(t=e.id)&&(n.id=t),null!==ZC._n_(t=e.cls)&&""!==t&&(n.className=t);for(var o=[["top","","px"],["left","","px"],["width","","px"],["height","","px"],"position","overflow",["float","cssFloat|styleFloat"],["zidx","zIndex"],"clip","display",["fontSize","","px"],"fontFamily","fontWeight","fontStyle","textDecoration","textAlign","verticalAlign","color","border","borderTop","borderRight","borderBottom","borderLeft","background","cursor",["margin","marginTop|marginRight|marginBottom|marginLeft","px"],["marginTop","","px"],["marginRight","","px"],["marginBottom","","px"],["marginLeft","","px"],["padding","paddingTop|paddingRight|paddingBottom|paddingLeft","px"],["paddingTop","","px"],["paddingRight","","px"],["paddingBottom","","px"],["paddingLeft","","px"],"lineHeight","filter"],s=null,c=null,h=null,C=0,u=o.length;C<u;C++)if("string"==typeof o[C]&&(o[C]=[o[C]]),t=null,null!==ZC._n_(i=e[o[C][0]])&&(t=i),null!==ZC._n_(t)){null!==ZC._n_(o[C][1])&&""!==o[C][1]||(o[C][1]=o[C][0]);for(var d=o[C][1].split("|"),A=0,p=d.length;A<p;A++){var g=t+(null===ZC._n_(o[C][2])?"":o[C][2]);a[d[A]]=g,"fontFamily"===d[A]&&(s=g),"fontSize"===d[A]&&(c=ZC._i_(g)),"fontWeight"===d[A]&&(h=g)}}return null!==ZC._n_(t=e.opacity)&&(a.opacity=t,1!==ZC._f_(t)&&(a.filter="alpha(opacity = "+ZC._i_(100*ZC._f_(t))+")",a.opacity=t)),null!==ZC._n_(t=e.p)&&(e.after?t.insertBefore(n,e.after.nextSibling):t.appendChild(n)),null!==ZC._n_(t=e.html)&&(n.innerHTML=ZC._h_(t),-1!==t.indexOf("<")&&-1!==t.indexOf(">")&&ZC.A5(n).children().each(function(){null!==ZC._n_(s)&&(null!==ZC._n_(this.style.fontFamily)&&""!==this.style.fontFamily||(this.style.fontFamily=s)),null!==ZC._n_(c)&&(null!==ZC._n_(this.style.fontSize)&&""!==this.style.fontSize||(this.style.fontSize=c+"px")),null!==ZC._n_(h)&&(null!==ZC._n_(this.style.fontWeight)&&""!==this.style.fontWeight||(this.style.fontWeight=h))})),e.rtl&&(n.style.unicodeBidi="bidi-override",n.style.direction="rtl"),e.cursor&&"hand"===e.cursor&&(n.style.cursor="pointer"),n},W1:null,A43:function(e,t,i,n,a,r,l){var o,s,c,h;null===ZC._n_(l)&&(l=!1);var C=!1;"[HTMLMODE]"===t.substring(0,10)&&(C=!0,t=t.substring(10)),h=e+"-text-ruler",-1!==e.indexOf("-fullscreen")&&(h="zc-text-ruler");var u="{{"+t+"}}"+i.replace(/[^a-z]/gi,"").toLowerCase()+n+r+a;if(ZC.cache.data["text-width-"+u]&&!l)return ZC.cache.data["text-width-"+u];if(ZC.cache.data["text-height-"+u]&&l)return ZC.cache.data["text-height-"+u];var d,A=t;return A=A.replace(/<hr>/g,'<hr style="margin:0;padding:0">'),(d=ZC.AK(h))?(ZC.Q.W1&&ZC.Q.W1===e+i+n+r+a||(d.style.fontFamily=i,d.style.fontSize=n+"px",d.style.fontWeight=a,d.style.lineHeight=C?"130%":-1!==r?ZC._i_(r)+"px":"130%",ZC.Q.W1=e+i+n+r+a),d.innerHTML=A):(d=ZC.Q.HY({id:h,p:document.body,tl:"-9999/-9999",html:A,position:"absolute",fontFamily:i,fontSize:n,cls:"zc-text-ruler",fontWeight:a})).style.lineHeight=C?"130%":-1!==r?ZC._i_(r)+"px":"130%",-1===t.indexOf("<")||-1===t.indexOf(">")||C||ZC.A5(d).children().each(function(){"BR"!==this.tagName.toUpperCase()&&(null!==ZC._n_(this.style.fontFamily)&&""!==this.style.fontFamily||(this.style.fontFamily=i),null!==ZC._n_(this.style.fontSize)&&""!==this.style.fontSize||(this.style.fontSize=n+"px"),this.style.lineHeight=-1!==r?ZC._i_(r)+"px":"130%","B"!==this.tagName.toUpperCase()&&"STRONG"!==this.tagName.toUpperCase()&&(null!==ZC._n_(this.style.fontWeight)&&""!==this.style.fontWeight||(this.style.fontWeight=a)))}),(o=d.getBoundingClientRect())&&o.width>0?(s=o.width,l&&(c=o.height)):(s=ZC.mobile&&ZC.A5.browser.webkit?d.offsetWidth:ZC.A5(d).width(),l&&(c=ZC.mobile&&ZC.A5.browser.webkit?d.offsetHeight:ZC.A5(d).height())),l?(ZC.cache.add("text-height-"+u,c),c):(ZC.cache.add("text-width-"+u,s),s)}},!document.getElementsByClassName&&document.querySelectorAll&&(document.getElementsByClassName=function(e){return document.querySelectorAll("."+e)}),ZC.A5=function(e,t,i){var n,a,r,l,o=this;if(void 0===i&&(i=!0),i)return new ZC.A5(e,t,!1);if(o.P1=[],o.QD=e,o.MH=t,o.length=0,o.MH=o.MH||document.getElementsByTagName("body")[0],"object"==typeof o.QD)o.P1=[o.QD];else if("string"==typeof o.QD)for(var s=o.QD.split(","),c=0;c<s.length;c++){var h=ZC.GV(s[c]),C=!1;if(2===(n=h.split(">")).length&&(C=!0,ZC.A5(n[0]).each(function(){var e=this;ZC.A5(n[1],this).each(function(){this.parentNode===e&&o.P1.push(this)})})),2===(n=h.split(" ")).length&&(C=!0,ZC.A5(n[0]).each(function(){ZC.A5(n[1],this).each(function(){o.P1.push(this)})})),!C)if("#"===h.substring(0,1))ZC.AK(h.substring(1))&&(o.P1=[ZC.AK(h.substring(1))]);else if("."===h.substring(0,1))if(document.getElementsByClassName){if(o.MH.getElementsByClassName)a=o.MH.getElementsByClassName(h.substring(1));else if(a=document.getElementsByClassName(h.substring(1)),o.MH!==document){var u=[];for(r=0,l=a.length;r<l;r++)ZC.A5.childof(a[r],o.MH)&&u.push(a[r]);a=u}for(r=0,l=a.length;r<l;r++)o.P1.push(a[r])}else{var d=new RegExp("(^|\\s)"+h.substring(1)+"(\\s|$)","i"),A=o.MH.getElementsByTagName("*"),p="";for(r=0,l=A.length;r<l;r++)"object"==typeof(p=A[r].className)&&(p="undefined"!=typeof p.baseVal?p.baseVal:""),""!==p&&d.test(p)&&o.P1.push(A[r])}else for(r=0,l=(a=o.MH.getElementsByTagName(h)).length;r<l;r++)o.P1.push(a[r])}return o.length=o.P1.length,this},ZC.A5.prototype={eachfn:function(){for(var e,t=[],i=0,n=this.P1.length;i<n;i++){var a=[this.P1[i]];if((e=arguments.length)>1)for(var r=1;r<e;r++)a.push(arguments[r]);t.push(arguments[0].apply(this,a))}return t},each:function(){for(var e,t=0,i=this.P1.length;t<i;t++){var n=[this.P1[t]];if((e=arguments.length)>1)for(var a=1;a<e;a++)n.push(arguments[a]);arguments[0].apply(this.P1[t],n)}return this},children:function(){var e=[];return this.each(function(){for(var t=0,i=this.childNodes.length;t<i;t++)1===this.childNodes[t].nodeType&&e.push(this.childNodes[t])}),this.P1=e,this},remove:function(){this.eachfn.call(this,function(e){e&&e.parentNode&&e.parentNode.removeChild(e)})},empty:function(){this.eachfn.call(this,function(e){if(e)for(;e.childNodes.length;)e.removeChild(e.childNodes[e.childNodes.length-1])})},A2V:function(e){var t,i;void 0===e&&(e=!0);var n=this.eachfn.call(this,function(n){if(!n)return null;if(n===window){var a=document.body;return n.innerWidth?(t=n.innerWidth,i=n.innerHeight):a&&a.parentElement&&a.parentElement.clientWidth?(t=a.parentElement.clientWidth,i=a.parentElement.clientHeight):a&&a.clientWidth&&(t=a.clientWidth,i=a.clientHeight),{width:t,height:i}}var r,l,o=e?"block":ZC.A5(n).getstyle("display");if(window.getComputedStyle){var s=window.getComputedStyle(n,null);r=s.getPropertyValue("width").slice(0,-2),l=s.getPropertyValue("height").slice(0,-2)}else if(n.getBoundingClientRect){var c=n.getBoundingClientRect();r=c.width?c.width:n.offsetWidth,l=c.height?c.height:n.offsetHeight}else r=n.offsetWidth,l=n.offsetHeight;if("none"===o||""===o||void 0===o){var h=n.style,C=h.visibility,u=h.position,d=h.display;h.visibility="hidden",h.position="absolute",h.display="block",t=r,i=l,h.display=d,h.position=u,h.visibility=C}else t=r||0,i=l||0;return{width:t,height:i}});return 1===n.length?n[0]:n},getstyle:function(e){var t=this.eachfn.call(this,function(e,t){if("display"===t)return e.style.display;var i,n=document;if(t=ZC.EE(t),!e||e===n)return undefined;if("opacity"===t&&"undefined"!=typeof e.filters){var a=(ZC.A5(e).getstyle("filter")||"").match(/alpha\(opacity=(.*)\)/);return a&&a[1]?parseFloat(a[1])/100:1}if(-1!==ZC.AV(["float","cssFloat","styleFloat"],t))return(i=e.style.float)?i:(i=e.style.cssFloat)?i:(i=e.style.styleFloat)?i:"none";var r=e.style?e.style[t]:null;if(!r)if(n.defaultView&&n.defaultView.getComputedStyle){var l=n.defaultView.getComputedStyle(e,null);t=t.replace(/([A-Z])/g,"-$1").toLowerCase(),r=l?l.getPropertyValue(t):null}else if(e.currentStyle&&(r=e.currentStyle[t],/^\d/.test(r)&&!/px$/.test(r)&&"fontWeight"!==t)){var o=e.style.left,s=e.runtimeStyle.left;e.runtimeStyle.left=e.currentStyle.left,e.style.left=r||0,r=e.style.pixelLeft+"px",e.style.left=o,e.runtimeStyle.left=s}return"opacity"===t&&(r=parseFloat(r)),/Opera/.test(navigator.userAgent)&&-1!==ZC.AV(["left","top","right","bottom"],t)&&"static"===ZC.A5(e).getstyle("position")&&(r="auto"),"auto"===r?null:r},e);return 1===t.length?t[0]:t},wh:function(){var e;return this.P1[0]?null!==ZC._n_(e=ZC.A5(this.P1[0]).A2V())?[ZC._i_(e.width),ZC._i_(e.height)]:[0,0]:null},width:function(e){var t;if(void 0===e){var i=this.eachfn.call(this,function(e){return null!==ZC._n_(t=ZC.A5(e).A2V())?ZC._i_(t.width):0});return 1===i.length?i[0]:i}return this.eachfn.call(this,function(e,t){e.style.width=t+"px"},e),this},height:function(e){var t;if(void 0===e){var i=this.eachfn.call(this,function(e){return null!==ZC._n_(t=ZC.A5(e).A2V())?ZC._i_(t.height):0});return 1===i.length?i[0]:i}return this.eachfn.call(this,function(e,t){e.style.height=t+"px"},e),this},scrollLeft:function(){return ZC.A5.scroll().left},scrollTop:function(){return ZC.A5.scroll().top},css:function(e,t){if(void 0===t){var i=this.eachfn.call(this,function(t){var i=ZC.A5(t).getstyle(e);return-1!==(""+i).indexOf("px")?ZC._i_(i):i});return 1===i.length?i[0]:i}return this.eachfn.call(this,function(e,t,i){e.style[t]=i},e,t),this},attr:function(e,t){if(void 0===t){var i=this.eachfn.call(this,function(t){return t.getAttribute(e)});return 1===i.length?i[0]:i}return this.eachfn.call(this,function(e,t,i){e.setAttribute(t,i)},e,t),this},val:function(e){if(void 0===e){var t=this.eachfn.call(this,function(e){return e.value});return 1===t.length?t[0]:t}return this.eachfn.call(this,function(e,t){e.value=t},e),this},show:function(){return this.eachfn.call(this,function(e){e.style.display="block"}),this},hide:function(){return this.eachfn.call(this,function(e){e.style.display="none"}),this},offset:function(){var e=this.eachfn.call(this,function(e){if(!(e&&(e.x&&e.y||null!==!e.parentNode&&"none"!==ZC.A5(e).getstyle("display"))))return undefined;var t,i,n,a,r,l,o,s={top:0,left:0},c={top:0,left:0},h=e&&e.ownerDocument;return h&&((i=h.body)===e&&(s={top:i.offsetTop,left:i.offsetLeft}),t=h.documentElement,"undefined"!=typeof e.getBoundingClientRect&&(c=e.getBoundingClientRect()),n=h.defaultView||h.parentWindow,a=t.clientTop||i.clientTop||0,r=t.clientLeft||i.clientLeft||0,l=n.pageYOffset||t.scrollTop,o=n.pageXOffset||t.scrollLeft,s={top:c.top+l-a,left:c.left+o-r}),s});return 1===e.length?e[0]:e},bind:function(e,t,i){if(""!==(e=ZC.A5.cleanTouchEvents(e))){if(i||(i=!ZC.hasPassive||{passive:!0}),-1!==e.indexOf(" ")){for(var n=e.split(/\s+/),a=0;a<n.length;a++)this.bind(n[a],t,i);return this}return this.eachfn.call(this,function(e,t,n){function a(e){var t=(e=e||window.event).target||e.srcElement,i=ZC.A5.BZ(e);null!==i&&n.call(t,i)}ZC.A5.IY||(ZC.A5.IY=[]),ZC.A5.IY.push([e,t,n,a]),e.addEventListener?e.addEventListener(t,a,i):e.attachEvent("on"+t,a)},e,t),this}},unbind:function(e,t){if(""!==(e=ZC.A5.cleanTouchEvents(e))){if(-1!==e.indexOf(" ")){for(var i=e.split(/\s+/),n=0;n<i.length;n++)this.unbind(i[n],t);return this}return this.eachfn.call(this,function(e,t,i){if("undefined"!=typeof ZC.A5.IY)for(var n=0,a=ZC.A5.IY.length;n<a;n++)if((ZC.A5.IY[n][0]===e||e.tagName&&"MAP"===e.tagName.toUpperCase()&&e.id===ZC.A5.IY[n][0].id)&&ZC.A5.IY[n][1]===t&&ZC.A5.IY[n][2]===i){e.removeEventListener?e.removeEventListener(t,ZC.A5.IY[n][3],!0):e.detachEvent("on"+t,ZC.A5.IY[n][3]),ZC.A5.IY.splice(n,1);break}},e,t),this}},live:function(e,t,i){if(""!==(e=ZC.A5.cleanTouchEvents(e))){if(i||(i=!ZC.hasPassive||{passive:!0}),-1===e.indexOf("touch")&&-1===e.indexOf("wheel")||(i={passive:!1}),-1!==e.indexOf(" ")){for(var n=e.split(/\s+/),a=0;a<n.length;a++)this.live(n[a],t,i);return this}var r=this.QD;return ZC.A5.EVENTS||(ZC.A5.EVENTS={}),ZC.A5.EVENTS[e]||(ZC.A5.EVENTS[e]=[],document.addEventListener?document.addEventListener(e,l,i):document.attachEvent("on"+e,l)),ZC.A5.EVENTS[e].push([r,t]),this}function l(t){var i=(t=t||window.event).target||t.srcElement,n=i.className||"";"object"==typeof n&&(n="undefined"!=typeof n.baseVal&&null!==ZC._n_(n.baseVal)?n.baseVal:"");var r,l,o=ZC.A5.EVENTS[e],s=null,c=null,h=[];for(r=0,l=o.length;r<l;r++)("object"==typeof o[r][0]&&i===o[a][0]||"string"==typeof o[r][0]&&("."===o[r][0].substring(0,1)&&-1!==ZC.AV(n.split(" "),o[r][0].replace(".",""))||"#"===o[r][0].substring(0,1)&&i.id===o[r][0].substring(1)))&&(s=o[r][1],c=ZC.A5.BZ(t),null!==ZC._n_(s)&&null!==ZC._n_(c)&&h.push([s,i,c]));for(r=0,l=h.length;r<l;r++)h[r][0].call(h[r][1],h[r][2])}},die:function(e,t){if(""!==(e=ZC.A5.cleanTouchEvents(e))){var i,n,a;if(-1!==e.indexOf(" ")){for(n=0,a=(i=e.split(/\s+/)).length;n<a;n++)this.die(i[n],t);return this}var r=this.QD;if(ZC.A5.EVENTS||(ZC.A5.EVENTS={}),i=ZC.A5.EVENTS[e])for(n=i.length-1;n>=0;n--)i[n][0]!==r||t&&i[n][1]!==t||ZC.A5.EVENTS[e].splice(n,1);return this}}},ZC.A5._list_=function(e){for(var t=[],i=0;i<ZC.A5.EVENTS[e].length;i++)t.push(ZC.A5.EVENTS[e][i][0]);return t.join(",")},ZC.A5.cleanTouchEvents=function(e){return ZC.ie678&&(e=ZC.GV(e.replace(/touchstart|touchend|touchmove/,""))),e},ZC.A5.cache={},ZC.A5.browser={},function(){var e=/(webkit)[ \/]([\w.]+)/,t=/(opera)(?:.*version)?[ \/]([\w.]+)/,i=/(msie) ([\w.]+)/,n=/(mozilla)(?:.*? rv:([\w.]+))?/,a=/(trident)(?:.*? rv:([\w.]+))?/,r=function(r){r=r.toLowerCase();var l=e.exec(r)||t.exec(r)||i.exec(r)||a.exec(r)||r.indexOf("compatible")<0&&n.exec(r)||[];return[l[1]||"",l[2]||"0"]}(navigator.userAgent);r[0]&&("trident"===r[0]&&(r[0]="msie"),ZC.A5.browser[r[0]]=!0,ZC.A5.browser.version=r[1])}(),ZC.A5.scroll=function(){var e={top:0,left:0},t=document,i=t.documentElement,n=t.body;return i&&(i.scrollTop||i.scrollLeft)?(e.left=i.scrollLeft,e.top=i.scrollTop):n&&(e.left=n.scrollLeft,e.top=n.scrollTop),e},ZC.A5.BZ=function(e){if(e.originalEventZC=e,e.target||(e.target=e.srcElement||document),3!==e.target.nodeType&&8!==e.target.nodeType||(e.target=e.target.parentNode),null===ZC._n_(e.pageX)&&null!==ZC._n_(e.clientX)){var t=e.target.ownerDocument||document,i=t.documentElement,n=t.body;e.pageX=e.clientX+(i&&i.scrollLeft||n&&n.scrollLeft||0)-(i&&i.clientLeft||n&&n.clientLeft||0),e.pageY=e.clientY+(i&&i.scrollTop||n&&n.scrollTop||0)-(i&&i.clientTop||n&&n.clientTop||0)}return e.which||e.button===undefined||(e.which=1&e.button?1:2&e.button?3:4&e.button?2:0),e.preventDefault||(e.preventDefault=function(){this.returnValue=!1}),e.stopPropagation||(e.stopPropagation=function(){this.cancelBubble=!0}),e},ZC.A5.childof=function(e,t){if(e===t)return!0;for(;e!==t&&e.parentNode;)if((e=e.parentNode)===t)return!0;return!1},ZC.A5.ajax=function(e){var t=e.url||"",i=e.type||"GET",n=e.data||"",a=!0;"undefined"!=typeof e.async&&(a=ZC._b_(e.async)),""===n.replace(/\&/g,"")&&(n="");var r=e.beforeSend||null,l=e.error||null,o=e.success||null,s=null;try{window.ActiveXObject?s=new ActiveXObject("Microsoft.XMLHTTP"):window.XMLHttpRequest&&(s=new XMLHttpRequest)}catch(h){}var c="file:"===window.location.protocol;if(s){a&&(s.onreadystatechange=function(){4===s.readyState&&((c||s.status>=200&&s.status<300)&&o&&o(s.responseText,s.status,s,t),s.status>=400&&l&&l(s,s.status,s.statusText,t),s.onreadystatechange=new window.Function,s=null)}),window.ActiveXObject||(s.onerror=function(){l&&l(s,0,"",t)}),"POST"===i.toUpperCase()?(s.open("POST",t,a),s.setRequestHeader("X-Requested-With","XMLHttpRequest"),s.setRequestHeader("Content-type","application/x-www-form-urlencoded")):(""!==n&&(-1===t.indexOf("?")&&(t+="?"),t+="&"+n),s.open("GET",t,a)),r&&r(s);try{s.send(n),a||((c||s.status>=200&&s.status<300)&&o&&o(s.responseText,s.status,s,t),s.status>=400&&l&&l(s,s.status,s.statusText,t),s=null)}catch(C){c&&l&&(l(s,s.status,s.statusText,t),s.onreadystatechange=new window.Function,s=null)}}},ZC.AQ={ACI:function(e,t){var i,n,a=zingchart.DEV.SPREADFACTOR,r=[],l=0;function o(e,t){-1===ZC.AV(e,t)&&e.push(t)}for(i=0;i<e.length;i++)e[i]+=t;var s=-1;for(i=1;i<e.length;i++)ZC._a_(e[i]-e[i-1])<a?(r[l]=r[l]||{min:-1,max:-1,items:[]},-1===r[l].min&&(r[l].min=i>1?e[i-2]:t,-1===s&&(s=r[l].min),r[l].min),o(r[l].items,i-1),o(r[l].items,i)):r[l]&&(r[l].max=e[i],r[l].max,l++);r[l]&&-1===r[l].max&&(r[l].max=360+t);var c=r.length;if(c>1&&r[c-1].max-r[0].min==360){for(n=0;n<r[0].items.length;n++)e[r[0].items[n]]+=360;r[c-1].items=r[c-1].items.concat(r[0].items),r[c-1].max+=r[0].min,r=r.splice(1)}for(r.length>1&&(r[r.length-1].max=r[0].min+360),i=0;i<r.length;i++){var h=r[i],C=h.items.length,u=(h.max-h.min)/(C+4);u=ZC.CY(u,a);var d=0;for(n=0;n<h.items.length;n++)d+=e[h.items[n]];d/=h.items.length;for(var A=!0;A;)for(A=!1,n=1;n<h.items.length;n++)if(e[h.items[n]]-e[h.items[n-1]]<u){e[h.items[n-1]]<d?(e[h.items[n-1]]-=.45,e[h.items[n]]+=.05):e[h.items[n]]+=.25,A=!0;break}}return e},_int_:function(e){return Math.abs(e-ZC._i_(e))<Math.pow(10,-10)},XM:function(e,t,i){return i=i||1,!(e.x>t.x+t.width+i)&&(!(t.x>e.x+e.width+i)&&(!(e.y>t.y+t.height+i)&&!(t.y>e.y+e.height+i)))},_boxoverlap2_:function(e,t,i){return i=i||1,!(e.iX>t.iX+t.I+i)&&(!(t.iX>e.iX+e.I+i)&&(!(e.iY>t.iY+t.F+i)&&!(t.iY>e.iY+e.F+i)))},AG6:function(e,t){return e.iX>=t.iX&&e.iX<=t.iX+t.I&&e.iY>=t.iY&&e.iY<=t.iY+t.F&&e.iX+e.I>=t.iX&&e.iX+e.I<=t.iX+t.I&&e.iY+e.F>=t.iY&&e.iY+e.F<=t.iY+t.F},A6D:function(e,t,i){for(var n=Math.sqrt(e/Math.PI),a=Math.sqrt(t/Math.PI),r=Math.min(n,a),l=Math.max(n,a),o=ZC.MAX,s=0,c=r+l;c>l-r;c-=r/50){var h=r*r*Math.acos((c*c+r*r-l*l)/(2*c*r))+l*l*Math.acos((c*c+l*l-r*r)/(2*c*l))-.5*Math.sqrt((-c+r+l)*(c+r-l)*(c-r+l)*(c+r+l));Math.abs(h-i)<o&&(o=Math.abs(h-i),s=c)}return s},BN:function(e,t,i,n){return[e+i*Math.cos(2*n*Math.PI/360),t+i*Math.sin(2*n*Math.PI/360)]},A5I:function(e,t,i,n,a){var r=ZC.TK(Math.atan((n-t)/(i-e)));return[e+ZC._i_(ZC.EH(r)*a),t+ZC._i_(ZC.EP(r)*a)]},JT:function(e,t,i,n,a,r){if(a=null===ZC._n_(a)?0:a,r=null===ZC._n_(r)||r,i-e!=0){var l=0,o=0,s=Math.atan((n-t)/(i-e));return(a<1||r)&&(l=a/2.5*Math.cos(s),o=a/2.5*Math.sin(s)),[(e+i)/2+(e<i?l:-l),(t+n)/2+o]}return[e,(t+n)/2]},AB0:function(e,t){var i=(e[1]-t[1])/(e[0]-t[0]);return[i,e[1]-i*e[0]]},A4K:function(e,t,i,n){if(t[0]===n[0]&&t[1]===n[1])return t;if(e[0]===i[0]&&e[1]===i[1])return e;var a=ZC.AQ.AB0(e,t),r=a[0],l=a[1],o=ZC.AQ.AB0(i,n),s=o[0],c=(o[1]-l)/(r-s);return[c,r*c+l]},PR:function(e,t,i){null===ZC._n_(t)&&(t=5);var n=0,a=0;null!==ZC._n_(i)&&(n=i[0],a=i[1]);for(var r,l,o,s="",c=ZC.ie67?ZC.MAPTX:0,h=0,C=e.length;h<C;h++)e[h]&&(0===h?(l=e[h][0]+c+n,o=e[h][1]+c+a,r=h,s+=Math.round(l,10)+","+Math.round(o,10)+","):Math.sqrt((e[h][0]+c-l)*(e[h][0]+c-l)+(e[h][1]+c-o)*(e[h][1]+c-o))>t&&e[h-1]&&(Math.sqrt((e[h][0]-e[h-1][0])*(e[h][0]-e[h-1][0])+(e[h][1]-e[h-1][1])*(e[h][1]-e[h-1][1]))>t&&h-r>1&&(s+=Math.round(e[h-1][0]+c+n,10)+","+Math.round(e[h-1][1]+c+a,10)+","),l=e[h][0]+c+n,o=e[h][1]+c+a,r=h,s+=Math.round(l,10)+","+Math.round(o,10)+","));return s=s.substring(0,s.length-1)},Z0:function(e,t){if(null===ZC._n_(e)||e.length<2)return"";null===ZC._n_(t)&&(t=6,ZC.mobile&&(t+=10));var i,n,a,r,l,o=[];for(i=0,n=e.length;i<n;i++)(0===i||i>0&&null!==ZC._n_(e[i])&&null!==ZC._n_(e[i-1])&&e[i].join("/")!==e[i-1].join("/")||null===ZC._n_(e[i]))&&o.push(e[i]);var s=[],c=[],h=!1;for(i=0,n=o.length;i<n;i++)if(o[i]){var C,u,d,A,p=o[i][0],g=o[i][1];if(o[i-1]&&(d=o[i-1][0],A=o[i-1][1],d===p&&(d-=.1)),o[i+1]&&(C=o[i+1][0],u=o[i+1][1],C===p&&(C+=.1)),0===i)a=Math.atan((u-g)/(C-p)),l=r=ZC.TK(a),C>=p&&(l+=180),s.push(ZC.AQ.BN(p,g,t,r+90),ZC.AQ.BN(p,g,t,l),ZC.AQ.BN(p,g,t,r+270));else if(i===o.length-1)a=Math.atan((A-g)/(d-p)),l=r=ZC.TK(a),d>=p&&(l+=180),h?(c.push(ZC.AQ.BN(p,g,t,r+270),ZC.AQ.BN(p,g,t,l),ZC.AQ.BN(p,g,t,r+90)),h=!1):s.push(ZC.AQ.BN(p,g,t,r+270),ZC.AQ.BN(p,g,t,l),ZC.AQ.BN(p,g,t,r+90));else{var Z=Math.atan((u-g)/(C-p)),f=Math.atan((g-A)/(p-d));l=ZC.TK((Z+f)/2),s.push(ZC.AQ.BN(p,g,t,l+270)),C>=p&&d>=p?(s.push(ZC.AQ.BN(p,g,t,l+180)),s.push(ZC.AQ.BN(p,g,t,l+90)),c.push(ZC.AQ.BN(p,g,t,l)),h=!0):C<=p&&d<=p?(s.push(ZC.AQ.BN(p,g,t,l)),s.push(ZC.AQ.BN(p,g,t,l+90)),c.push(ZC.AQ.BN(p,g,t,l+180)),h=!0):c.push(ZC.AQ.BN(p,g,t,l+90))}}for(i=c.length-1;i>=0;i--)s.push(c[i]);return s},A2C:function(e,t){var i=0,n=0,a=[];switch(e+=""){case"horizontal":case"h":i=1,n=t;break;case"vertical":case"v":i=t,n=1;break;default:a=e.split("x"),null!==ZC._n_(a[0])&&ZC._i_(a[0])+""===a[0]&&(i=ZC._i_(a[0])),null!==ZC._n_(a[1])&&ZC._i_(a[1])+""===a[1]&&(n=ZC._i_(a[1])),0===n&&0===i?(i=Math.ceil(Math.sqrt(t)),n=Math.ceil(t/i)):(0===n&&(n=Math.ceil(t/i)),0===i&&(i=Math.ceil(t/n)))}return[i,n]},AB4:function(e,t){return.5*(2*t[1]+(-t[0]+t[2])*e+(2*t[0]-5*t[1]+4*t[2]-t[3])*e*e+(-t[0]+3*t[1]-3*t[2]+t[3])*e*e*e)},AB7:function(e,t){var i,n,a,r,l,o=e.length,s=[],c=[],h=[];for(i=0;i<o-1;i++)n=e[i+1]-e[i],a=t[i+1]-t[i],c.push(n),s.push(a),h.push(a/n);var C=[h[0]];for(i=0;i<c.length-1;i++){r=h[i];var u=h[i+1];if(r*u<=0)C.push(0);else{n=c[i];var d=c[i+1];l=n+d,C.push(3*l/((l+d)/r+(l+n)/u))}}C.push(h[h.length-1]);var A=[],p=[];for(i=0;i<C.length-1;i++){r=h[i];var g=C[i],Z=1/c[i];l=g+C[i+1]-r-r,A.push((r-g-l)*Z),p.push(l*Z*Z)}return function(i){var n=e.length-1;if(i===e[n])return t[n];for(var a,r=0,l=p.length-1;r<=l;){a=Math.floor(.5*(r+l));var o=e[a];if(o<i)r=a+1;else{if(!(o>i))return t[a];l=a-1}}n=Math.max(0,l);var s=i-e[n],c=s*s;return t[n]+C[n]*s+A[n]*c+p[n]*s*c}},Y9:function(e,t,i,n){null===ZC._n_(n)&&(n=1/(i/t.length*4));var a,r,l=[];if(e)if((a=[].concat(t))[1]&&a[2]){a[0]=a[0]||a[1]||a[2]||a[3],a[1]=a[1]||a[2]||a[0]||a[3],a[2]=a[2]||a[3]||a[1]||a[0],a[3]=a[3]||a[2]||a[1]||a[0];var o=ZC.AQ.AB7([0,1,2,3],a);for(r=1;r<=2;r+=n)l.push([r-1,o(r)])}else l.push([]);else for(var s=1;s<t.length-2;s++)if(1!==n)if((a=[t[s-1],t[s],t[s+1],t[s+2]])[1]&&a[2])for(a[0]=a[0]||a[1]||a[2]||a[3],a[1]=a[1]||a[2]||a[0]||a[3],a[2]=a[2]||a[3]||a[1]||a[0],a[3]=a[3]||a[2]||a[1]||a[0],r=0;r<=1;r+=n){var c=s+r,h=ZC.AQ.AB4(r,a);l.push([c-1,h])}else l.push([]);else l.push([s-1,t[s]]);return l},A0K:function(e){for(var t=Math.round(ZC.G6(ZC._a_(e))/Math.LN10),i=[1,2,4,5,6,8,10],n=ZC.MAX,a=1,r=0;r<i.length;r++){var l=i[r]*Math.pow(10,t)-e;ZC._a_(l)<n&&(a=i[r],n=ZC._a_(l))}return a*Math.pow(10,t)},_nice_number_:function(e,t){var i,n;return i=Math.floor(Math.log(e)/Math.log(10)),n=e/Math.pow(10,i),(t?n<1.5?1:n<3?2:n<7?5:10:n<=1?1:n<=2?2:n<=5?5:10)*Math.pow(10,i)},VS:function(e,t,i,n,a,r){var l,o,s,c,h,C;null===ZC._n_(a)&&(a=!0),r=null===ZC._n_(r)?10:Math.min(Math.max(2,r),100),null!==ZC._n_(n)&&0!==n||(n=1);var u=Math.floor(ZC.G6(ZC._a_(t))/Math.LN10);e===t&&(t+=Math.pow(10,u)),l=e,o=t,c=ZC.AQ._nice_number_(o-l,!1),null===ZC._n_(i)?(s=c/(r-1),s=ZC.AQ._nice_number_(s,!0),s*=n):s=i,a?(h=Math.floor(l/s)*s,C=Math.ceil(o/s)*s):(h=l,C=o,s=null===ZC._n_(i)?c/(r-1):i);var d=Math.floor(ZC.G6(ZC._a_(s))/Math.LN10),A=d<0?ZC._a_(d):0;if(0===A){var p=(""+s).split(".");2===p.length&&(A=p[1].length)}return[h,C,s,A,s]}},ZC.XK={md5:function(e){return ZC.XK.ACT(ZC.XK.ACU(ZC.XK.ACQ(e)))},ACU:function(e){return ZC.XK.AC6(ZC.XK.ACV(ZC.XK.ACD(e),8*e.length))},ACT:function(e){for(var t,i="",n=0,a=e.length;n<a;n++)t=e.charCodeAt(n),i+="0123456789abcdef".charAt(t>>>4&15)+"0123456789abcdef".charAt(15&t);return i},ACQ:function(e){for(var t,i,n="",a=-1,r=e.length;++a<r;)t=e.charCodeAt(a),i=a+1<r?e.charCodeAt(a+1):0,55296<=t&&t<=56319&&56320<=i&&i<=57343&&(t=65536+((1023&t)<<10)+(1023&i),a++),t<=127?n+=String.fromCharCode(t):t<=2047?n+=String.fromCharCode(192|t>>>6&31,128|63&t):t<=65535?n+=String.fromCharCode(224|t>>>12&15,128|t>>>6&63,128|63&t):t<=2097151&&(n+=String.fromCharCode(240|t>>>18&7,128|t>>>12&63,128|t>>>6&63,128|63&t));return n},ACD:function(e){var t,i=Array(e.length>>2);for(t=0;t<i.length;t++)i[t]=0;for(t=0;t<8*e.length;t+=8)i[t>>5]|=(255&e.charCodeAt(t/8))<<t%32;return i},AC6:function(e){for(var t="",i=0;i<32*e.length;i+=8)t+=String.fromCharCode(e[i>>5]>>>i%32&255);return t},ACV:function(e,t){function i(e,t,i,n,a,r){return o((l=o(o(t,e),o(n,r)))<<(s=a)|l>>>32-s,i);var l,s}function n(e,t,n,a,r,l,o){return i(t&n|~t&a,e,t,r,l,o)}function a(e,t,n,a,r,l,o){return i(t&a|n&~a,e,t,r,l,o)}function r(e,t,n,a,r,l,o){return i(t^n^a,e,t,r,l,o)}function l(e,t,n,a,r,l,o){return i(n^(t|~a),e,t,r,l,o)}function o(e,t){var i=(65535&e)+(65535&t);return(e>>16)+(t>>16)+(i>>16)<<16|65535&i}e[t>>5]|=128<<t%32,e[14+(t+64>>>9<<4)]=t;for(var s=1732584193,c=-271733879,h=-1732584194,C=271733878,u=0,d=e.length;u<d;u+=16){var A=s,p=c,g=h,Z=C;c=l(c=l(c=l(c=l(c=r(c=r(c=r(c=r(c=a(c=a(c=a(c=a(c=n(c=n(c=n(c=n(c,h=n(h,C=n(C,s=n(s,c,h,C,e[u],7,-680876936),c,h,e[u+1],12,-389564586),s,c,e[u+2],17,606105819),C,s,e[u+3],22,-1044525330),h=n(h,C=n(C,s=n(s,c,h,C,e[u+4],7,-176418897),c,h,e[u+5],12,1200080426),s,c,e[u+6],17,-1473231341),C,s,e[u+7],22,-45705983),h=n(h,C=n(C,s=n(s,c,h,C,e[u+8],7,1770035416),c,h,e[u+9],12,-1958414417),s,c,e[u+10],17,-42063),C,s,e[u+11],22,-1990404162),h=n(h,C=n(C,s=n(s,c,h,C,e[u+12],7,1804603682),c,h,e[u+13],12,-40341101),s,c,e[u+14],17,-1502002290),C,s,e[u+15],22,1236535329),h=a(h,C=a(C,s=a(s,c,h,C,e[u+1],5,-165796510),c,h,e[u+6],9,-1069501632),s,c,e[u+11],14,643717713),C,s,e[u],20,-373897302),h=a(h,C=a(C,s=a(s,c,h,C,e[u+5],5,-701558691),c,h,e[u+10],9,38016083),s,c,e[u+15],14,-660478335),C,s,e[u+4],20,-405537848),h=a(h,C=a(C,s=a(s,c,h,C,e[u+9],5,568446438),c,h,e[u+14],9,-1019803690),s,c,e[u+3],14,-187363961),C,s,e[u+8],20,1163531501),h=a(h,C=a(C,s=a(s,c,h,C,e[u+13],5,-1444681467),c,h,e[u+2],9,-51403784),s,c,e[u+7],14,1735328473),C,s,e[u+12],20,-1926607734),h=r(h,C=r(C,s=r(s,c,h,C,e[u+5],4,-378558),c,h,e[u+8],11,-2022574463),s,c,e[u+11],16,1839030562),C,s,e[u+14],23,-35309556),h=r(h,C=r(C,s=r(s,c,h,C,e[u+1],4,-1530992060),c,h,e[u+4],11,1272893353),s,c,e[u+7],16,-155497632),C,s,e[u+10],23,-1094730640),h=r(h,C=r(C,s=r(s,c,h,C,e[u+13],4,681279174),c,h,e[u],11,-358537222),s,c,e[u+3],16,-722521979),C,s,e[u+6],23,76029189),h=r(h,C=r(C,s=r(s,c,h,C,e[u+9],4,-640364487),c,h,e[u+12],11,-421815835),s,c,e[u+15],16,530742520),C,s,e[u+2],23,-995338651),h=l(h,C=l(C,s=l(s,c,h,C,e[u],6,-198630844),c,h,e[u+7],10,1126891415),s,c,e[u+14],15,-1416354905),C,s,e[u+5],21,-57434055),h=l(h,C=l(C,s=l(s,c,h,C,e[u+12],6,1700485571),c,h,e[u+3],10,-1894986606),s,c,e[u+10],15,-1051523),C,s,e[u+1],21,-2054922799),h=l(h,C=l(C,s=l(s,c,h,C,e[u+8],6,1873313359),c,h,e[u+15],10,-30611744),s,c,e[u+6],15,-1560198380),C,s,e[u+13],21,1309151649),h=l(h,C=l(C,s=l(s,c,h,C,e[u+4],6,-145523070),c,h,e[u+11],10,-1120210379),s,c,e[u+2],15,718787259),C,s,e[u+9],21,-343485551),s=o(s,A),c=o(c,p),h=o(h,g),C=o(C,Z)}return Array(s,c,h,C)}},"undefined"==typeof zingchart&&(zingchart={ADG:!0}),zingchart.clipart={},zingchart.widgets={},zingchart.plugins={},zingchart.pool={},zingchart.pool.size=0,zingchart.pool.data={},zingchart.pool.getInstance=function(e,t,i,n){var a;if(null!==ZC._n_(zingchart.pool.data[i]))(a=zingchart.pool.data[i])._POOL_=!0,ZC.SKIPOBJCOUNT=!0,n||(a.$i(t),a.K=i),ZC.SKIPOBJCOUNT=!1;else{switch(e){case"DN":a=new ZC.DN(t);break;case"HL":a=new ZC.HL(t);break;case"DT":a=new ZC.DT(t);break;case"OY":a=new ZC.OY(t);break;case"D0":a=new ZC.D0(t)}a.K=i,zingchart.pool.size++,zingchart.pool.size>zingchart.DEV.MAXPOOLSIZE?(zingchart.pool.data={},zingchart.pool.size=0):zingchart.pool.data[i]=a}return a},zingchart.i18n={},zingchart.THEMES={},zingchart.V3D=2,zingchart.QUOTEDVALUES=!1,zingchart.EDITSOURCE=1,zingchart.MODULESDEP={line:"xy",line3d:"3d,line",area:"xy",area3d:"3d,area",vline:"yx",varea:"yx",vbar:"xy",vbar3d:"3d,vbar",hbar:"yx",hbar3d:"3d,hbar",scatter:"xy",bubble:"xy",hscatter:"yx",hbubble:"yx",pie:"r",pie3d:"3d,pie",nestedpie:"r",gauge:"r",vbullet:"vbar",hbullet:"hbar",vfunnel:"xy",hfunnel:"yx",piano:"xy",radar:"r",range:"xy",vrange:"yx",stock:"xy,vbar",venn:"r"},zingchart.SKIP={EVENT:!1,ANIMATION:!1,LEGEND:!1,CSV:!1,PARSE3D:!1},zingchart.MODULESDIR=function(e){for(var t=0;t<e.length;t++){if(e[t].src)if(e[t].src.indexOf("zingchart.min.js")>-1)return e[t].src.split("zingchart.min.js")[0]+"modules/"}return"./modules/"}(document.getElementsByTagName("head")[0].childNodes),zingchart.DEV={DOMFRAGMENTS:1,SORTTOKENS:1,PLOTSTATS:1,RESOURCES:1,KEEPSOURCE:1,SPREADTYPE:0,SPREADFACTOR:10,IGNORESUBUNIT:0,DELAYEDTRACKERS:0,STACKINGLOGIC:-1,SMARTDATELABELS:0,GC:1,CACHECANVASTEXT:0,CHECKDECIMALS:0,CACHESELECTION:0,MEDIARULES:1,SKIPTRACKERS:0,PLOTSHLAYER:0,RESIZESPEED:250,DEBOUNCESPEED:250,LOCALSVGEXPORT:1,SKIPPROGRESS:0,SKIPCONTEXTMENU:0,COPYDATA:1,GUIDETIMEOUT:0,LOOKUPCSSTRANSFORM:0,MAPSONBOTTOM:0,MAXPOOLSIZE:1024,MINTRACKERDIFF:1.5},zingchart.CANVASTEXT=0,zingchart.ZINDEX=1,zingchart.CMZINDEX=9999,zingchart.FSZINDEX=9998,zingchart.FSID=null,zingchart.ZCOUTPUT=0,zingchart.ASYNC=0,zingchart.SORTTRACKERS=0,zingchart.TIMEOUT=0,zingchart.USERCSS={},zingchart.OBJECTMODE="normal",zingchart.SYNTAX="mixed",zingchart.THEME=null,zingchart.EXPORTURL=("file:"===document.location.protocol?"http:":document.location.protocol)+"//export.zingchart.com/",zingchart.AJAXEXPORT=!1,zingchart.TOUCHZOOM="normal",zingchart.DEFAULT={height:480,width:640},zingchart.FASTWIDTH=0,zingchart.FONTSIZE=11,zingchart.FONTFAMILY="Lucida Sans Unicode,Lucida Grande,Lucida Sans,Helvetica,Arial,sans-serif",ZC.mobile&&(zingchart.FONTFAMILY="Lucida Sans,Helvetica,Arial,sans-serif"),zingchart.loadModules=function(e,t){for(var i=(""+e).split(","),n=0,a=i.length;n<a;n++){var r=ZC.GV(i[n]);r=ZC.ALIAS[r]||r,-1!==ZC.AV(["bar","bar3d","funnel","bullet"],r)&&(r="v"+r);var l=zingchart.MODULESDEP[r];null!==ZC._n_(l)&&zingchart.loadModules(l),-1===ZC.AV(ZC.RH,r)&&ZC.RH.push(r)}t&&zingchart.A1E(null,ZC.RH,t)},zingchart.A1E=function(e,t,i){var n=0;if(0===t.length)i();else{if(!document.getElementsByTagName("head")[0])return void i();!function a(){var r,l=!0;function o(){++n===t.length?i():a()}zingchart.ACL(t[n])?r=zingchart.MODULESDIR+"zingchart-"+t[n]+".min.js":l=!1,l?ZC.AP.ACC(e,r,o):o()}()}},zingchart.ACL=function(e){return-1!==ZC.AV(ZC.RH,e)&&-1===ZC.AV(ZC.WI,e)},zingchart.LH=[],ZC.ie67||function(){for(var e in ZC.IMAGES)ZC.IMAGES.hasOwnProperty(e)&&(zingchart.LH[e]=new Image,zingchart.LH[e].src=ZC.IMAGES[e])}(),"undefined"!=typeof Ext&&(zingchart.LH["zc.blank"]=new Image,zingchart.LH["zc.blank"].src=ZC.BLANK),zingchart.exec=function(e,t,i){return zingchart.exec_flash?zingchart.exec_flash(e,t,i):null},zingchart.AD4=function(O){var QM=O.dataurl||"",EW="",G,M9=null;null!==ZC._n_(G=O.data)&&("string"==typeof G?EW=G:M9=JSON.parse(JSON.stringify(G)));var DL=null;if(""!==QM)ZC.A5.ajax({type:"GET",url:QM,async:!1,data:zingchart.ZCOUTPUT?"zcoutput=userdef":"",error:function(){return!1},success:function(KC){function _f_(e){ZC.cache.data["data-"+QM]=KC,O.output="auto",ZC._cp_(e.render,O)}try{DL=JSON.parse(KC),_f_(DL)}catch(JA){try{DL=eval("("+KC+")"),_f_(DL)}catch(JA){return!1}}}});else{if(""!==EW)try{DL=JSON.parse(EW)}catch(JA){return!1}else null!==M9&&(DL=M9);null===ZC._n_(O.output)&&(O.output="auto"),ZC._cp_(DL.render,O)}return zingchart.render(O)},zingchart.A01=null,zingchart.params={},zingchart.render=function(e,t){if(null===ZC._n_(t)&&(t=!1),t)return zingchart.AD4(e);null===ZC._n_(ZC.canvas)&&ZC.compat();var i=e.output||"auto";"html5"===i&&(i="auto"),ZC.mobile&&"auto"===i&&(i="svg");var n=!1;if("!"===i.substring(0,1)&&(n=!0,i=i.substring(1)),n||("auto"===i||"canvas"===i&&!ZC.canvas||"svg"===i&&!ZC.svg||"vml"===i&&!ZC.vml||"flash"===i&&!ZC.flash)&&(ZC.svg?i="svg":ZC.canvas?i="canvas":ZC.vml?i="vml":ZC.flash&&(i="flash")),"vml"===i&&null===ZC._n_(zingchart.A01)&&(zingchart.A01=!1),"flash"!==i)return zingchart.A8O(e,i);zingchart.render_flash(e)},document.attachEvent&&("complete"===document.readyState?zingchart.A01=!0:document.attachEvent("onreadystatechange",function(){"complete"===document.readyState&&(zingchart.A01=!0)})),zingchart.setlabel=zingchart.setLabel=function(e,t){ZC.HJ[e]=t},zingchart.HZ=[],zingchart.XZ={},zingchart.ADF=0,zingchart.AD1=0,zingchart.ADD=!1,zingchart.AA4=!1,zingchart.AA3=!1,zingchart.ACX=!1,zingchart.css=null,zingchart.WX=function(e){if(e.target.id){for(var t=null,i=0,n=zingchart.HZ.length;i<n;i++)e.target.id.substr(0,zingchart.HZ[i].K.length+1)===zingchart.HZ[i].K+"-"&&(t=zingchart.HZ[i]);return t}},ZC.GESTURE={id:null,on:!1,ts:null,type:null,dist:-1,mp:[-1,-1]},"undefined"==typeof zingchart.MI&&(zingchart.MI=function(e){if(e.target&&e.target.tagName&&"INPUT"!==e.target.tagName.toUpperCase()&&"TEXTAREA"!==e.target.tagName.toUpperCase()){var t;if("pinch"===zingchart.TOUCHZOOM)switch(ZC.TOUCHEVENTS=!1,e.type){case"touchstart":for(var i=!1,n=0;n<zingchart.HZ.length;n++)t=ZC.A5("#"+zingchart.HZ[n].K+"-top"),ZC.DS(e.touches[0].pageX,t.offset().left,t.offset().left+t.width())&&ZC.DS(e.touches[0].pageY,t.offset().top,t.offset().top+t.height())&&(i=!0,ZC.GESTURE.id=zingchart.HZ[n].K);i&&(ZC.GESTURE.on=!0);break;case"touchmove":if(ZC.GESTURE.on&&2===e.touches.length){e.preventDefault();var a=(e.touches[0].clientX-e.touches[1].clientX)*(e.touches[0].clientX-e.touches[1].clientX)+(e.touches[0].clientY-e.touches[1].clientY)*(e.touches[0].clientY-e.touches[1].clientY);a=Math.round(Math.sqrt(a));var r=[Math.round((e.touches[0].clientX+e.touches[1].clientX)/2),Math.round((e.touches[0].clientY+e.touches[1].clientY)/2)];if(-1===ZC.GESTURE.dist)ZC.GESTURE.dist=a,ZC.GESTURE.mp=r,ZC.GESTURE.ts=(new Date).getTime();else if((new Date).getTime()-ZC.GESTURE.ts>100){if(a>ZC.GESTURE.dist+50)ZC.GESTURE.type="pinch-in",zingchart.exec(ZC.GESTURE.id,"zoomin");else if(a<ZC.GESTURE.dist-50)ZC.GESTURE.type="pinch-out",zingchart.exec(ZC.GESTURE.id,"zoomout");else{ZC.GESTURE.type="panning";var l={};r[0]>ZC.GESTURE.mp[0]+10?(l["x-"]=!0,l.xdist=ZC._a_(ZC.GESTURE.mp[0]-r[0])):r[0]<ZC.GESTURE.mp[0]-10&&(l["x+"]=!0,l.xdist=ZC._a_(ZC.GESTURE.mp[0]-r[0])),r[1]>ZC.GESTURE.mp[1]+10?(l["y+"]=!0,l.ydist=ZC._a_(ZC.GESTURE.mp[1]-r[1])):r[1]<ZC.GESTURE.mp[1]-10&&(l["y-"]=!0,l.ydist=ZC._a_(ZC.GESTURE.mp[1]-r[1])),ZC.GESTURE.mp=r,zingchart.exec(ZC.GESTURE.id,"pan",l)}ZC.GESTURE.ts=(new Date).getTime()}}break;case"touchend":ZC.GESTURE.id=null,ZC.GESTURE.on=!1,ZC.GESTURE.type=null,ZC.GESTURE.ts=null,ZC.GESTURE.dist=-1,ZC.GESTURE.mp=[-1,-1]}if(window.ZC){window.ZC.E1=[e.pageX,e.pageY];var o=zingchart.WX(e);if(o){if(!zingchart.SKIP.EVENT){if("mousedown"===e.type&&(window.ZC.aMDXY=[e.pageX,e.pageY]),"touchstart"===e.type&&o.AG)for(var s=0;s<o.AG.length;s++)o.AG[s].LD();if(-1!==ZC.AV(["mouseover","mouseout","mouseover"],e.type)&&"IMG"!==e.target.tagName.toUpperCase())return;if("mouseout"===e.type&&(t=ZC.A5("#"+o.K+"-top"),ZC.DS(e.pageX,t.offset().left,t.offset().left+t.width(),!0)&&ZC.DS(e.pageY,t.offset().top,t.offset().top+t.height(),!0)))return;ZC.AP.BY(e.type,o,zingchart.A0A(e,o))}zingchart.SKIP.EVENT=!1}}}},ZC.A5(document).bind(ZC.Q.BZ("mouseover"),zingchart.MI).bind(ZC.Q.BZ("mouseout"),zingchart.MI).bind(ZC.Q.BZ("mousemove"),zingchart.MI).bind(ZC.Q.BZ("mousedown"),zingchart.MI).bind(ZC.Q.BZ("mouseup"),zingchart.MI)),zingchart.A0A=function(e,t){var i=ZC.Q.MB(e),n=t.A4A(i[0],i[1]),a=ZC.A5("#"+t.K+"-top"),r=Math.round(i[0]-a.offset().left),l=Math.round(i[1]-a.offset().top),o="none";return/(.*)\-scale\_(.*)\-item\_title\-area(.*)/.test(e.target.id)&&(o="scale-title"),/(.*)\-scale\_(.*)\-item\_(\d+)\-area(.*)/.test(e.target.id)&&(o="scale-item"),/(.*)\-plotset\-plot\-(\d+)\-node\-(\d+)(.*)/.test(e.target.id)&&(o="node"),/(.*)\-legend\-item\_(\d+)\-area/.test(e.target.id)&&(o="legend-item"),/(.*)\-legend\-marker\_(\d+)\-area/.test(e.target.id)&&(o="legend-marker"),/(.*)\-legend\-(.+)\-area/.test(e.target.id)&&(o="legend-element"),/(.*)\-menu\-item\-(.*)/.test(e.target.id)&&(o="menu-item"),/(.*)\-preview\-handler\-x(.*)/.test(e.target.id)&&(o="preview"),/(.*)\-shape\-(.*?)\-area/.test(e.target.id)&&(o="shape"),/(.*)\-label\-(.*?)\-area/.test(e.target.id)&&(o="label"),{id:t.K,ev:ZC.A5.BZ(e),targetid:e.target.id,graphid:n?n.K:null,target:o,x:r,y:l,plotarea:!!n&&(r>=n.P.iX&&r<=n.P.iX+n.P.I&&l>=n.P.iY&&l<=n.P.iY+n.P.F),touch:ZC.mobile}},"undefined"==typeof zingchart.SB&&(zingchart.SB=function(e){for(var t=0,i=zingchart.HZ.length;t<i;t++)zingchart.HZ[t].hideCM();if(ZC.mobile&&ZC.move)ZC.move=!1;else if(ZC.mobile||!(e.which>1)){var n=zingchart.WX(e);if(n){if("click"===e.type&&ZC.aMDXY&&(ZC._a_(ZC.aMDXY[0]-e.pageX)>2||ZC._a_(ZC.aMDXY[1]-e.pageY)>2))return;if(!zingchart.SKIP.EVENT){var a=zingchart.A0A(e,n);a.target=zingchart.plugins.CLICK_TARGET||a.target,zingchart.plugins.CLICK_TARGET=null,ZC.mobile&&"touchend"===e.type&&(n.E["click-ts"]&&(new Date).getTime()-n.E["click-ts"]<500&&ZC.AP.BY("dblclick",n,a),n.E["click-ts"]=(new Date).getTime()),ZC.AP.BY("dblclick"===e.type?"dblclick":"click",n,a)}zingchart.SKIP.EVENT=!1,e.target.id!==n.K+"-menu-area"?n.hideCM():zingchart.YS(e)}}},ZC.mobile?(ZC.A5(document).bind("touchmove",function(){ZC.move=!0}),ZC.A5(document).bind("touchend",function(){ZC.move=!1})):(ZC.A5(document).bind("click",zingchart.SB),ZC.A5(document).bind("dblclick",zingchart.SB))),"undefined"==typeof zingchart.A2S&&(zingchart.A2S=function(e){e.touches.length>0&&(ZC.TOUCHEVENTS=!0)},ZC.A5(document).bind("touchstart",zingchart.A2S)),"undefined"==typeof zingchart.YS&&(zingchart.YS=function(e,t,i){if(!(e&&e.target&&e.target.tagName&&"IMG"!==e.target.tagName.toUpperCase()&&"AREA"!==e.target.tagName.toUpperCase()&&-1===ZC.Q.T8(e.target).indexOf("zc-scroll")&&-1===e.target.id.indexOf("-legend-")&&-1===e.target.id.indexOf("-preview-"))||zingchart.DEV.SKIPTRACKERS){var n,a,r,l,o,s;i=i||{};var c=null===ZC._n_(t)?zingchart.WX(e):zingchart.getLoader(t);if(c){if(-1!==ZC.AV(c.KR,"skip_context_menu"))return!1;if(null===ZC._n_(t)?(a=ZC.Q.MB(e),n=c.A4A(a[0],a[1])):n=null!==ZC._n_(i.graphid)?c.OQ(i.graphid):c.AG[0],!n)return!1;var h=ZC.A5("#"+c.K+"-top");null===ZC._n_(t)?(r=a[0]-h.offset().left,l=a[1]-h.offset().top):(r=c.I/2,l=c.F/2);var C={};e&&(C=zingchart.A0A(e,c));var u=ZC.AP.BY("contextmenu",c,C,!0);if(!u&&void 0!==u&&(!e&&!i["from-api"]||e&&e.target.id!==c.K+"-menu-area"))return e.preventDefault(),!1;var d=ZC._tx_(c.K);c.A5T(n?n.L:-1,e);var A=-1;if(0!==zingchart.CMZINDEX)A=zingchart.CMZINDEX;else for(var p=ZC.AK(c.K);-1===A&&null!==p.parentNode;)"auto"!==(A=ZC._i_(ZC.A5(p).css("zIndex")))&&""!==A&&null!==ZC._n_(A)||(A=-1),p=p.parentNode;A&&-1!==A&&null!==ZC._n_(A)||(A=1);var g=ZC.A5("#"+c.K+"-menu");if(g.css("zIndex",zingchart.ZINDEX+A+1),null===ZC._n_(t)){if(e.target.id===c.K+"-print-png"||e.target.id===c.K+"-print-jpeg")return!0;e.preventDefault()}if(!ZC.AK(c.K+"-menu"))return!1;r=h.offset().left,l=h.offset().top;var Z=h.width(),f=h.height();null===ZC._n_(t)?(o=(a=ZC.Q.MB(e))[0]||ZC.E1[0],s=a[1]||ZC.E1[1]):(o=r+c.I/2,s=l+5);var _=!1;if(c.VL("goback",!1),c.NS>0&&(c.VL("goback",!0),_=!0),c.VL("goforward",!1),c.NS<c.QL.length-1&&(c.VL("goforward",!0),_=!0),c.VL("history",_,!0),o>=r&&o<=r+Z*d[0]&&s>=l&&s<=l+f*d[1]){ZC.A5(".zc-menu").each(function(){this.id!==c.K+"-menu"&&c.hideCM()}),c.SW=[o,s,null===ZC._n_(t)?e.target.id:t],g.css("opacity",0).show();var b,m,v=ZC._i_(g.css("width"))+ZC._i_(g.css("paddingLeft"))+ZC._i_(g.css("paddingRight")),E=ZC._i_(g.css("height"))+ZC._i_(g.css("paddingTop"))+ZC._i_(g.css("paddingBottom")),D=1,w=!1;if(c.o.gui&&c.o.gui["context-menu"]&&c.o.gui["context-menu"]&&(D=c.o.gui["context-menu"].alpha?c.o.gui["context-menu"].alpha:1,w=c.o.gui["context-menu"].docked),g.css("opacity",D).hide(),"classic"!==c.LL&&w){if(w){var x=c.B8.NY[c.LL].root.gui["context-menu"];ZC._cp_(c.o.gui["context-menu"],x),b="left"!==c.o.gui["context-menu"].position&&ZC._n_(c.o.gui["context-menu"].position)?h.offset().left+h.width()-v:h.offset().left}m=h.offset().top,g.css("left",ZC.BQ(1,b)+"px").css("top",ZC.BQ(1,m)+"px").css("height",h.height()+"px").css("box-sizing","border-box").show(),g=ZC.A5("#"+c.K+"-menu"),w&&g.P1[0].scrollHeight>h.height()&&g.css("overflow-y","scroll")}else{if(null===ZC._n_(t)&&e.target.id===c.K+"-menu-area"){ZC.AK(c.K+"-menu").style.paddingTop=0;var B=ZC.A5("#"+c.K+"-menu-area").attr("coords").split(","),y=ZC._i_(B[3])-ZC._i_(B[1]);ZC.AK(c.K+"-menu").style.backgroundPosition=ZC._i_(B[0])>c.I/2?"100% 0% !important":"0% 0% !important",b=r+(ZC._i_(B[0])>c.I/2?ZC._i_(B[2])-v:ZC._i_(B[0])),m=l+(ZC._i_(B[1])>c.F/1.25?ZC._i_(B[3])-E-y:ZC._i_(B[3]))}else ZC.AK(c.K+"-menu").style.backgroundPosition="50% 0% !important",b=c.SW[0]-v/2,m=c.SW[1],E>c.F*d[1]?m=l:m-l+E>c.F*d[1]&&(m=ZC.BQ(m-E,c.F*d[1]-E)),b<r&&(b=ZC.BQ(b,r)),b+v>r+c.I*d[0]&&(b=ZC.CY(r+c.I*d[0]-v/2,b-v/2));if(i.position)switch(i.position){case"top":break;case"top-left":b=b-(c.I*d[0]-v)/2+5;break;case"top-right":b=b+(c.I*d[0]-v)/2-5;break;case"bottom":m=m+(c.F*d[1]-E)-10;break;case"bottom-left":m=m+(c.F*d[1]-E)-10,b=b-(c.I*d[0]-v)/2+5;break;case"bottom-right":m=m+(c.F*d[1]-E)-10,b=b+(c.I*d[0]-v)/2-5;break;case"left":m=m+(c.F*d[1]-E)/2-5,b=b-(c.I*d[0]-v)/2+5;break;case"right":m=m+(c.F*d[1]-E)/2-5,b=b+(c.I*d[1]-v)/2-5}else null!==ZC._n_(i.x)&&null!==ZC._n_(i.y)&&(b=r+ZC._i_(i.x),m=l+ZC._i_(i.y));if(g.css("left",ZC.BQ(1,b)+"px").css("top",ZC.BQ(1,m)+"px").show(),ZC.ie67){var K=ZC.A5("#"+c.K+"-menu div").width()[0]||120;g.css("width",K+"px")}}return c.AA2=!0,!1}}}},ZC.A5(document).bind("contextmenu",zingchart.YS)),zingchart.AAF=function(e,t){if(zingchart.css)return zingchart.css.addRule?zingchart.css.addRule(e,t):zingchart.css.insertRule(e+"{"+t+"}",0)},zingchart.wh=function(e,t,i){"auto"===t&&(t="100%"),"auto"===i&&(i="100%");var n=[0,0];return-1===(""+t).indexOf("%")&&-1===(""+i).indexOf("%")||(n=e.wh()),[-1!==(""+t).indexOf("%")?n[0]*parseInt(t,10)/100:parseInt(t,10),-1!==(""+i).indexOf("%")?n[1]*parseInt(i,10)/100:parseInt(i,10)]},zingchart.IY={},zingchart.bind=function(e,t,i){e=e||"zingchart-global",zingchart.IY[e]||(zingchart.IY[e]={}),zingchart.IY[e][t]?zingchart.IY[e][t].push({fn:i}):zingchart.IY[e][t]=[{fn:i}]},zingchart.unbind=function(e,t,i){if(e=e||"zingchart-global",zingchart.IY[e]&&zingchart.IY[e][t])if(i){for(var n=0,a=zingchart.IY[e][t].length;n<a;n++)if(zingchart.IY[e][t][n].fn===i){zingchart.IY[e][t].splice(n,1);break}}else zingchart.IY[e][t]=null},zingchart.callEvent=function(e,t,i,n){if(e=e||"zingchart-global",zingchart.IY[e]&&zingchart.IY[e][t]){for(var a=0,r=zingchart.IY[e][t].length;a<r;a++)null!==ZC._n_(n)?i[i.length-1]=zingchart.IY[e][t][a].fn.apply(zingchart,i):zingchart.IY[e][t][a].fn.apply(zingchart,i);if(null!==ZC._n_(n))return i[i.length-1]}},zingchart.hasEvent=function(e,t){return e=e||"zingchart-global",zingchart.IY[e]&&zingchart.IY[e][t]},zingchart.A8O=function(e,t){ZC._todash_(e,!1);var i,n,a,r,l,o,s,c,h=[];if(null!==ZC._n_(i=e.flags)&&(h=i.split(",")),null!==ZC._n_(i=e.mode))switch(i){case"static":h=["skip_context_menu","skip_segment_tracking","skip_marker_tracking","skip_interactivity","use_single_canvas"]}var C="";if(null!==ZC._n_(i=e.container)&&(C=i),null!==ZC._n_(i=e.id)&&(C=i),ZC.AK(C)){var u=null;for(a=0;a<zingchart.HZ.length;a++)zingchart.HZ[a].K===C&&(u=zingchart.HZ[a].MA);if(null!==ZC._n_(u)){if(""!==u)return;zingchart.exec(C,"destroy")}zingchart.params[C]={},ZC._cp_(e,zingchart.params[C]);var d=!1,A=null;for(a=0;a<zingchart.HZ.length;a++)zingchart.HZ[a].K===C&&(zingchart.HZ[a]=new ZC.Q2,A=zingchart.HZ[a],d=!0);if(d||((A=new ZC.Q2).MA="init",zingchart.HZ.push(A)),A.K=C,zingchart.XZ[C]=!0,"vml"!==t||zingchart.A01||zingchart.A8O(e,t),!zingchart.AA3){zingchart.AA3=!0;var p={".zc-style":"font-family:"+zingchart.FONTFAMILY+";font-size:"+zingchart.FONTSIZE+"px;font-weight:normal;font-style:normal;text-decoration:none;text-shadow:none;",".zc-style *":"font-family:"+zingchart.FONTFAMILY+";font-size:"+zingchart.FONTSIZE+"px;font-weight:normal;font-style:normal;text-decoration:none;text-shadow:none;",".zc-top *":"text-align:left;margin:auto;text-shadow:none;",".zc-menu *":"text-align:left;margin:auto;",".zc-main text":"-webkit-touch-callout:none;-webkit-user-select:none;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;",".zc-img":"-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",".zc-map":"-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",".zc-pixmap":"-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",".zc-preview-mask":"cursor:default;-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",".zc-about":"position:absolute;overflow:hidden;border:5px solid #fff;background:#003C4F url("+(ZC.ie67?"//":ZC.LOGO_ABOUT)+") no-repeat center 10px",".zc-about-1":"padding:80px 5px 5px 5px;text-align:center !important;",".zc-about-1 a":"color:#1AB6E3;font-size:17px;line-height:125%;",".zc-about-2":"padding:5px;color:#fff;text-align:center !important;",".zc-about-3":"padding:5px;text-align:center;line-height:125%;",".zc-about-3 div":"background-color:#1AB6E3;line-height:125%;color:#fff;border:1px solid #fff;padding:5px 10px;font-weight:bold;width:60px;margin:0 auto;cursor:pointer;text-align:center",".zc-about-4":"color:#fff;line-height:125%;",".zc-about-4 div":"float:right;color:#fff;line-height:125%;",".zc-viewsource":"border:5px solid #fff;background:#999",".zc-error":"border:5px solid #fff;background:#900",".zc-bugreport":"border:5px solid #fff;background:#999",".zc-form-row-label":"padding:4px 10px 2px;text-align:left;color:#fff",".zc-form-row-element":"padding:2px 8px",".zc-form-row-last":"padding:8px 8px 2px !important",".zc-form-row-element textarea":"text-align:left;background:#fff;color:#000;border:1px solid #333;",".zc-form-row-label input":"color:#000;padding:2px;margin:0 5px 0 0;background-color:#999;",".zc-form-row-element input":"color:#000;padding:2px;margin:0;background-color:#fff",".zc-form-row-last input":"padding:4px 10px !important;margin:0 20px 0 0 !important;background-color:#eee !important;border:2px outset #ccc !important",".zc-form-s0":"font-size:27px !important;letter-spacing:-1px;line-height:125%",".zc-form-s1":"font-size:17px !important;line-height:125%",".zc-form-s1 a":"color:#fff;padding:3px 10px;position:relative;top:4px;border:1px solid #333;border-bottom:0px solid #333",".zc-tab-active":"background-color:#fff;color:#333 !important",".zc-tab-inactive":"background-color:#999;color:#ddd !important",".zc-bugreport label":"display:inline-block;position:relative;top:-2px",".zc-viewimage div":"position:absolute;text-align:center;padding:5px;background:#999;color:#fff",".zc-license-ie67":"padding:0;position:absolute;font-size:12px;font-weight:bold;font-family:"+zingchart.FONTFAMILY+";color:#369;text-align:left",".zc-license":"padding:0;position:absolute;","#zc-fullscreen":"display:block;position:absolute;top:0;left:0;width:100%;height:100%;margin:0;padding:0;background:#fff;",".zc-menu":"position:absolute;display:none;background-repeat:no-repeat !important;background-position:50% 0% !important;",".zc-menu-sep":"font-size:1px;padding:0;line-height:1px;border-bottom:1px solid #000",".zc-menu-item":"cursor:pointer;white-space:nowrap",".zc-blocker":"background:#eee",".zc-blocker div.zc-blocker-msg":"position:absolute;border:2px solid #ccc;padding:10px 30px;background-color:#333;color:#fff",".zc-modal":"background-color:#fff;color:#000;border:2px solid #999",".zc-guide-label-table":"border-collapse:collapse",".zc-guide-label-table td":"padding:4px 10px 2px 2px",".zc-data-table":"border-collapse:collapse",".zc-data-table caption":"font-family:"+zingchart.FONTFAMILY+";text-align:left;font-size:17px;font-weight:600;padding:6px 14px 6px 4px;background-color:#ccc;border-bottom:2px solid #666",".zc-data-table th":"font-family:"+zingchart.FONTFAMILY+";text-align:left;font-size:13px;font-weight:600;padding:2px 14px 2px 4px;background-color:#ddd;border-bottom:1px solid #666",".zc-data-table td":"font-family:"+zingchart.FONTFAMILY+";text-align:left;font-size:11px;padding:1px 14px 1px 4px;background-color:#ffffff;border-bottom:1px solid #eee;white-space:nowrap",".zc-rel":"top:0;left:0;position:relative",".zc-abs":"top:0;left:0;position:absolute"};ZC.ie678||(p[".zc-data-table th:not(:last-child)"]="border-right:1px dotted #666",p[".zc-data-table td:not(:last-child)"]="border-right:1px solid #eee");var g=document.getElementsByTagName("head")[0],Z=document.createElement("style");if(Z.type="text/css",Z.setAttribute("data-author","zingchart"),g.appendChild(Z),!zingchart.css)for(a=0,r=document.styleSheets.length;a<r;a++)document.styleSheets[a].ownerNode&&"zingchart"===document.styleSheets[a].ownerNode.getAttribute("data-author")&&(zingchart.css=document.styleSheets[a]);for(var f in zingchart.css||(zingchart.css=document.styleSheets[document.styleSheets.length-1]),p)null!==ZC._n_(zingchart.USERCSS[f])?zingchart.AAF(f,zingchart.USERCSS[f]):zingchart.AAF(f,p[f])}if("vml"===t&&!zingchart.AA4)document.namespaces.add("zcv","urn:schemas-microsoft-com:vml"),document.createStyleSheet().cssText=".zcvml { behavior:url(#default#VML); }",zingchart.AA4=!0;var _="";zingchart.THEME&&(_=zingchart.THEME),e.data&&null!==ZC._n_(i=e.data.theme)&&(_=i),null!==ZC._n_(i=e.theme)&&(_=i);var b={data:!1,defaults:!1,css:!1,csv:!1};if(null!==ZC._n_(i=e.cache))for(var m in b)null!==ZC._n_(n=i[m])&&(b[m]=ZC._b_(n));var v=!1;null!==ZC._n_(i=e.fullscreen)&&(v=ZC._b_(i));var E=!0;null!==ZC._n_(i=e["auto-resize"])&&(E=ZC._b_(i));var D=ZC.A5("#"+C);l=(e.width||"100%")+"",o=(e.height||""+zingchart.DEFAULT.height)+"","auto"===l&&(l="100%"),"auto"===o&&(o="100%");var w=zingchart.wh(D,l,o);s=w[0],c=w[1],v&&(s=ZC.A5(window).width(),c=ZC.A5(window).height(),document.body.style.overflow="hidden"),s<10&&(s=zingchart.DEFAULT.width),c<10&&(c=zingchart.DEFAULT.height),s=0===s?zingchart.DEFAULT.width:s,c=0===c?zingchart.DEFAULT.height:c;var x=e.dataurl||"",B=e.defaultsurl||"",y=null,K="",F=null;null!==ZC._n_(i=e.data)&&("string"==typeof i?K=i:F=zingchart.DEV.COPYDATA?JSON.parse(JSON.stringify(i)):i),null!==ZC._n_(i=e.defaults)&&("string"==typeof i&&(i=JSON.parse(i)),y=i),null!==ZC._n_(i=e.imggen)&&(A.A19=ZC._b_(i)),A.A19&&(A.G1=null),A.JL=l+"/"+o,A.AA=t,A.A=A,A.iX=0,A.iY=0,A.I=s,A.F=c,A.FZ=l,A.MT=o,A.QM=x,A.EW=K,A.M9=F,A.QJ=B,A.ML=y,A.UN=!1,null!==ZC._n_(e.fullscreenmode)&&ZC._b_(e.fullscreenmode)&&(A.QZ=!0),A.LS=v,A.RS=b,A.KR=h,A.LL=_,A.H=A,A.E.hideprogresslogo=!1,null!==ZC._n_(i=e.hideprogresslogo)&&(A.E.hideprogresslogo=ZC._b_(i)),null!==ZC._n_(i=e.customprogresslogo)&&(A.E.customprogresslogo=i),null!==ZC._n_(i=e.customprogresstext)&&(A.E.customprogresstext=i),null!==ZC._n_(i=e.exportdataurl)&&(A.E.exportdataurl=i),null!==ZC._n_(i=e.exportimageurl)&&(A.E.exportimageurl=i);var M={};for(var z in null!==ZC._n_(i=e.bgcolor)&&(M["background-color"]=i),null!==ZC._n_(i=e["background-color"])&&(M["background-color"]=i),null!==ZC._n_(i=e["border-color"])&&(M["border-color"]=i),null!==ZC._n_(i=e["border-width"])&&(M["border-width"]=i),null!==ZC._n_(i=e.color)&&(M.color=i),A.E.progress=M,null!==ZC._n_(i=e["auto-load-modules"])&&(A.A6L=ZC._b_(i)),null!==ZC._n_(i=e.events)&&(A.A18=i),null!==ZC._n_(i=e.modules)&&(A.A1A=i),null!==ZC._n_(i=e.format)&&(A.CI=i),null!==ZC._n_(i=e.csvdata)&&(A.NW=i),null!==ZC._n_(i=e.locale)&&null!==ZC._n_(zingchart.i18n[i])&&(A.A14=i,ZC.HJ=zingchart.i18n[i]),null!==ZC._n_(i=e["cache-control"])&&(A.MZ=i),null!==ZC._n_(i=e.accessibility)&&(A.bA11y=ZC._b_(i)),null!==ZC._n_(i=e.description)&&(A.P2=i+""),zingchart.params)if(!zingchart.XZ[z])for(var I in delete zingchart.params[z],delete ZC.TS[z],zingchart.pool.data)0===I.indexOf(z+"-")&&(delete zingchart.pool.data[I],zingchart.pool.size--);if(A.render(),D.css("overflow","hidden"),A.LS&&D.css("position","absolute").css("top",0).css("left",0),(-1!==A.FZ.indexOf("%")||-1!==A.MT.indexOf("%")||A.LS||A.QZ)&&E){var S=A.QZ||A.LS?ZC.A5(window):D,G=S.width(),N=S.height(),H=0;A.A0P=!1,A.YV=window.setInterval(function(){var e;if(ZC.AK(C)&&!A.A2H){var t=ZC.A5("#"+C+"-top"),i=!1;if(-1!==(""+A.FZ).indexOf("%")&&t.length&&S.length&&t.width()!==S.width()&&(i=!0),0!==H||S.width()===G&&S.height()===N&&!i){if(S.width()+S.height()>0&&(S.width()!==G||S.height()!==N)&&(e=A.LS||A.QZ?zingchart.wh(S,""+S.width(),""+S.height()):zingchart.wh(S,A.FZ,A.MT))[0]>10&&e[1]>10){for(A.I=ZC._i_(e[0]),A.F=ZC._i_(e[1]),G=S.width(),N=S.height(),a=0,r=A.AG.length;a<r;a++)A.AG[a].MC[0]=0;L()}}else if(G=S.width(),N=S.height(),G>10&&N>10){for(-1!==(""+A.FZ).indexOf("%")?A.I=ZC._i_(G*ZC.II(A.FZ)):A.I=ZC._i_(G),-1!==(""+A.MT).indexOf("%")?A.F=ZC._i_(N*ZC.II(A.MT)):A.F=ZC._i_(N),a=0,r=A.AG.length;a<r;a++)A.AG[a].MC[0]=0;L()}H++}else window.clearInterval(A.YV)},zingchart.DEV.RESIZESPEED)}return A}function k(){if(!A.E.wh||A.E.wh!==A.I+"/"+A.F){for(var e=!1,t=0;t<zingchart.HZ.length;t++)zingchart.HZ[t].K===A.K&&(e=!0);e&&A.resize()}A.A0P=!1}function L(){A.A0P?A.VD.width!==A.I&&(clearTimeout(A.A64),A.VD.width=A.I,A.VD.height=A.F,A.A64=setTimeout(k,zingchart.DEV.DEBOUNCESPEED)):(A.A0P=!0,A.VD={width:A.I,height:A.F},A.A64=setTimeout(k,zingchart.DEV.DEBOUNCESPEED))}},window.zingchart=zingchart,ZC.A5.browser.msie&&parseFloat(ZC.A5.browser.version)<9){var _window_onunload_=window.onunload;window.onunload=function(){for(;zingchart.HZ.length;){var e=zingchart.HZ[0];e.A9H({},!0),e.YV&&window.clearInterval(e.YV),ZC.Q.EU([e.K+"-top",e.K+"-text-ruler"]);var t=ZC.AV(zingchart.HZ,e);-1!==t&&zingchart.HZ.splice(t,1),e=null}ZC.A5(document).unbind(ZC.Q.BZ("mouseover"),zingchart.MI).unbind(ZC.Q.BZ("mouseout"),zingchart.MI).unbind(ZC.Q.BZ("mousemove"),zingchart.MI).unbind(ZC.Q.BZ("mousedown"),zingchart.MI).unbind(ZC.Q.BZ("mouseup"),zingchart.MI).unbind("click",zingchart.SB).unbind("contextmenu",zingchart.YS),zingchart.HZ=[],_window_onunload_&&_window_onunload_()}}zingchart.i18n.en_us={rtl:!1,"decimals-separator":".","thousands-separator":"","menu-enablepagescroll":"Enable Page Scroll","menu-disablepagescroll":"Disable Page Scroll","menu-reload":"Reload","menu-print":"Print Chart","menu-viewaspng":"View As PNG","menu-viewasjpg":"View As JPG","menu-downloadpdf":"Download PDF","menu-downloadsvg":"Download SVG","menu-downloadcsv":"Download CSV","menu-downloadxls":"Download XLS","menu-viewdatatable":"View Data Table","menu-hidedatatable":"Hide Data Table","menu-exportdata":"Export Data","menu-zoomin":"Zoom In","menu-zoomout":"Zoom Out","menu-viewall":"View All","menu-viewsource":"View Source","menu-bugreport":"Submit Bug","menu-switchto2d":"Switch To 2D","menu-switchto3d":"Switch To 3D","menu-showguide":"Show Guide","menu-hideguide":"Hide Guide","menu-switchtolin":"Show Linear Scale","menu-switchtolog":"Show Log Scale","menu-fullscreen":"Full Screen","menu-exitfullscreen":"Exit Full Screen","menu-goback":"Go Back","menu-goforward":"Go Forward","date-formats":{msecond:"%d %M %Y<br>%g:%i:%s %A<br>%q ms",second:"%d %M %Y<br>%g:%i:%s %A",minute:"%d %M %Y<br>%g:%i %A",hour:"%d %M %Y<br>%g %A",day:"%d %M %Y",month:"%M %Y",year:"%Y"},"days-short":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"days-long":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],"months-short":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"months-long":["January","February","March","April","May","June","July","August","September","October","November","December"],"sync-wait":"Wait...","export-wait":"Exporting...","progress-wait-long":"Wait. Loading...","progress-wait-short":"Wait...","progress-wait-mini":"...","error-header":"An Error Has Occured","error-message":"Error Message:","error-close":"Close","bugreport-header":"Submit Bug Report","bugreport-senddata":"Send JSON Data","bugreport-sendcapture":"Send Graph Capture","bugreport-yourcomment":"Your Comment:","bugreport-jsondata":"JSON Data:","bugreport-youremail":"Your Email Address","bugreport-infoemail":"if you want to receive via email our reply to your problem","bugreport-emailmandatory":"Email address is mandatory...","bugreport-submit":"Submit","bugreport-cancel":"Cancel","bugreport-confirm":"Your bug report was sent.\n\nThank you!","about-close":"Close","viewsource-jsonsource":"Parsed JSON","viewsource-originalsource":"Original JSON","viewsource-close":"Close","viewsource-apply":"Apply","viewimage-close":"Close","legend-pagination":"Page %page% of %pages%"},ZC.HJ=zingchart.i18n.en_us,zingchart.getLoader=function(e){for(var t=0;t<zingchart.HZ.length;t++)if(zingchart.HZ[t].K===e)return zingchart.HZ[t];return null},zingchart.getGraph=function(e,t){return e.OQ(t)},zingchart.clearLayer=function(e){e.A7&&e.A7.onmouseout();for(var t=0;t<e.AG.length;t++)e.AG[t].LD()},zingchart.getGraphInfo=function(e,t,i){return e.A4O(t,i)},zingchart.initThemes=function(e){e&&e.A9Y(!0)},zingchart.setModule=function(e){ZC.WI.push(e)},zingchart.getModules=function(e){return e.A1A.split(",")},zingchart.defineModule=function(e,t,i){switch(zingchart.setModule(e),t){case"chart":zingchart.bind(null,"dataparse",function(t,n){for(var a=n.graphset.length,r=0;r<a;r++)if(n.graphset[r].type===e){var l=n.graphset[r];l.id?l.id=l.id:l.id=e.replace(/-/g,"")+r,n.graphset[r]=i(l)}return n});break;case"plugin":zingchart.bind(null,"dataparse",function(t,n){var a=zingchart.getLoader(t.id);if(-1!==zingchart.getModules(a).indexOf(e))for(var r=n.graphset.length,l=null,o=0;o<r;o++)(l=n.graphset[o]).hasOwnProperty(e)&&(n.graphset[o]=i(l,t.id));return n})}},zingchart.getPalette=function(e,t,i){return i=i||"bar",e.B8.A9B(t,i)},zingchart.getObject=function(e,t,i){var n,a;switch(i=i||"label"){case"shape":for(n=0,a=e.FH.length;n<a;n++)if(e.FH[n].H8===t||n===t)return e.FH[n].BG;break;case"label":for(n=0,a=e.BX.length;n<a;n++)if(e.BX[n].H8===t||n===t)return e.BX[n]}return null},zingchart.getInstance=function(e,t){switch(t){case"style":return new ZC.D0(e);case"shape":return new ZC.DT(e);case"box":return new ZC.HL(e);case"textbox":return new ZC.DN(e)}return null},zingchart.normalize=function(e){ZC._todash_(e)},zingchart.copy=function(e,t){ZC._cp_(e,t)},zingchart.formatDate=function(e,t,i,n){return ZC.AP.Y5(e,t,i,n)},zingchart.formatNumber=function(e,t){return ZC.AP.G2(e,t)},zingchart.fireEvent=function(e,t,i){ZC.AP.BY(e,t,i)},zingchart.A93=[],zingchart.extendAPI=function(e,t){zingchart.A93.push({call:e,api:t})},zingchart.exec=function(e,t,i){return zingchart.getLoader(e)?zingchart.ACY(e,t,i):zingchart.exec_flash?zingchart.exec_flash(e,t,i):void 0},zingchart.ACY=function(e,t,i){var n,a,r;i=i||{},document.getElementById("zc-fullscreen")&&!i.skipfs&&(e="zc-fullscreen"),"string"==typeof i&&(i=JSON.parse(i));var l,o,s,c,h,C=zingchart.getLoader(e);if(null!==ZC._n_(i.preservezoom)&&(C.E.preservezoom=ZC._b_(i.preservezoom)),C)switch(t){case"goback":C.IC&&C.NS>0&&(ZC.AP.BY("history_back",C,C.FE()),C.NS--,zingchart.exec(C.K,"setdata",{data:C.QL[C.NS]}));break;case"goforward":C.IC&&C.NS<C.QL.length-1&&(ZC.AP.BY("history_forward",C,C.FE()),C.NS++,zingchart.exec(C.K,"setdata",{data:C.QL[C.NS]}));break;case"setmode":if("undefined"==typeof C.E["mode-flags"]&&(C.E["mode-flags"]=C.KR.join(",")),""===i.mode&&"undefined"!=typeof C.E["mode-flags"])C.KR=C.E["mode-flags"].split(",");else{C.KR=[];var u=(""+i.mode).split(",");-1!==ZC.AV(u,"static")&&C.KR.push("skip_context_menu","skip_objects_tracking","skip_segment_tracking","skip_marker_tracking","skip_interactivity")}break;case"showmenu":ZC.E1[0]=ZC._n_(i.x)?i.x:ZC.E1[0],ZC.E1[1]=ZC._n_(i.y)?i.y:ZC.E1[1],i["from-api"]=!0,zingchart.YS(null,C.K,i);break;case"hidemenu":C.hideCM();break;case"destroy":case"zcdestroy":for(ZC.AP.BY("beforedestroy",C,{id:e,loader:C}),delete zingchart.XZ[e],a=0,r=C.AG.length;a<r;a++)C.AG[a].MC[0]=0,C.AG[a].B9&&(C.AG[a].B9.IM=!1,C.AG[a].unbind(!1,!0)),C.H2&&(C.H2.IM=!1);for(var d in ZC.move=!1,C.A0C(),C.A9H(i,!0),zingchart.DEV.GC&&C.gc(),C.YV&&window.clearInterval(C.YV),C.Z3&&window.clearInterval(C.Z3),zingchart.IY[e]&&delete zingchart.IY[e],ZC.Q.EU([e+"-wrapper",e+"-top",e+"-text-ruler",e+"-dummy",e+"-progress"]),C.A1K||delete zingchart.params[e],delete ZC.TS[e],delete ZC.cache.data["svg-rect"],zingchart.pool.data)0===d.indexOf(e+"-")&&(delete zingchart.pool.data[d],zingchart.pool.size--);var A=ZC.AV(zingchart.HZ,C);-1!==A&&zingchart.HZ.splice(A,1),zingchart.HZ.length||(zingchart.GUIDE_EV=null,delete zingchart.LH["zc.logo"]),C=null,ZC.AP.BY("destroy",null,{id:e});break;case"getrender":return C.AA;case"clear":C.A9H(i);break;case"reload":C.A8Y(i);break;case"load":C.ACZ(i);break;case"enable":C.A42();break;case"disable":C.A7W(i.text);break;case"closemodal":ZC.Q.EU([C.K+"-modal",C.K+"-blocker"]);break;case"openmodal":if(!ZC.AK(C.K+"-modal"))return ZC.Q.HY({cls:"zc-abs zc-style zc-blocker",id:C.K+"-blocker",p:ZC.AK(C.K+"-top"),wh:C.I+"/"+C.F,opacity:.75}),ZC.Q.HY({cls:"zc-abs zc-style zc-modal",id:C.K+"-modal",p:ZC.AK(C.K+"-top"),tl:(C.F-i.height)/2+"/"+(C.I-i.width)/2,wh:i.width+"/"+i.height,opacity:1}),ZC.AK(C.K+"-modal");break;case"mapdata":C.AC5(i);break;case"print":C.A98();break;case"fullscreen":C.A5W();break;case"exitfullscreen":zingchart.exec("zc-fullscreen","destroy"),ZC.Q.EU("zc-fullscreen");break;case"resize":C.A2H=!0;var p=C.I,g=C.F,Z=C.JL.split("/"),f=!1,_=Z[0],b=Z[1];null!==ZC._n_(n=i.width)&&(_=n),null!==ZC._n_(n=i.height)&&(b=n),null!==ZC._n_(n=i.scale)&&(f=ZC._b_(n)),C.A1K&&(zingchart.params[C.K].width=_,zingchart.params[C.K].height=b);var m=zingchart.wh(ZC.A5("#"+C.K),_,b);(i.layout||(p!==m[0]||g!==m[1])&&m[0]>10&&m[1]>10)&&(C.I=m[0],C.F=m[1],null!==ZC._n_(n=i.layout)&&(C.o.layout=n),""===C.MA&&(C.E["from-api"]=!0,C.E.preservezoom=!0,C.resize(f),C.FZ=_,C.MT=b,C.A2H=!1));break;case"plothide":case"hideplot":(l=C.C8(i.graphid))&&l.A3C(i,"hide");break;case"showguide":case"hideguide":ZC.E1[0]=ZC._n_(i.x)?i.x:ZC.E1[0],ZC.E1[1]=ZC._n_(i.y)?i.y:ZC.E1[1],(l=C.C8(i.graphid))&&C.Z7(l.K,"showguide"===t);break;case"showtooltip":case"hidetooltip":case"clicknode":if(l=C.C8(i.graphid)){var v=i.ev||{};"showtooltip"!==t&&"clicknode"!==t||((o=l.I0(i.plotindex,i.plotid))&&o.S.length&&!i.xy?(s=o.L,c=ZC._i_(i.nodeindex||"0"),v.targetid=l.K+"-plotset-plot-"+s+"-node-"+c,v.update=!0):v.targetid=l.K+"-xy-"+ZC._i_(i.y||"0")+"-"+ZC._i_(i.x||"0")),"clicknode"===t?(v.which=0,l.TB(v)):l.A.A7&&("showtooltip"===t?l.A.A7.onmouseover(v,i.data):l.A.A7.hide())}break;case"locktooltip":ZC.TTLOCK=!0;break;case"unlocktooltip":ZC.TTLOCK=!1;break;case"showhoverstate":if(l=C.C8(i.graphid)){o=l.I0(i.plotindex,i.plotid),s=ZC._i_(o?o.L:0),c=ZC._i_(i.nodeindex||"0");var E=l.AY.A4[s].FK(c);l.LD(),E.A0W()}break;case"plotshow":case"showplot":(l=C.C8(i.graphid))&&l.A3C(i,"show");break;case"togglesource":ZC.AK(C.K+"-viewsource")?ZC.Q.EU(C.K+"-viewsource"):C.A5O();break;case"togglebugreport":ZC.AK(C.K+"-bugreport")?ZC.Q.EU(C.K+"-bugreport"):C.A6T();break;case"toggleabout":ZC.AK(C.K+"-about")?ZC.Q.EU([C.K+"-about",C.K+"-about-mask"]):C.A9E();break;case"toggleplot":(l=C.C8(i.graphid))&&l.QC(i);break;case"getcharttype":return(l=C.C8(i.graphid))?l.AF:null;case"showversion":case"getversion":return ZC.VERSION;case"get3dview":return(l=C.C8(i.graphid))?l.F0:null;case"set3dview":(l=C.C8(i.graphid))&&(null===ZC._n_(C.o.graphset[l.L]["3d-aspect"])&&(C.o.graphset[l.L]["3d-aspect"]={}),ZC._cp_(i,C.o.graphset[l.L]["3d-aspect"]),null===ZC._n_(l.o["3d-aspect"])&&(l.o["3d-aspect"]={}),ZC._cp_(i,l.o["3d-aspect"]),zingchart.SKIP.PARSE3D=!0,l.autoFit(),l.K6(!0,!0),zingchart.SKIP.PARSE3D=!1);break;case"getpage":return C.L3;case"setpage":var D=0;null!==ZC._n_(n=i.page)&&(D=ZC._i_(n)),C.L3=D,ZC.ZJ(function(){C.clear(),C.parse(),C.paint()},!0);break;case"unbinddocument":ZC.A5(document).unbind(ZC.Q.BZ("mousemove"),zingchart.MI).unbind(ZC.Q.BZ("mousedown"),zingchart.MI).unbind(ZC.Q.BZ("mouseup"),zingchart.MI).unbind("click",zingchart.SB).unbind("contextmenu",zingchart.YS),C.D7&&C.D7.unbind()}var w=[];for(zingchart.ABJ&&null!==(h=zingchart.ABJ(e,t,i))&&(n=h),w=["addobject","removeobject","updateobject","repaintobjects","getobjectsbyclass","getallobjects","getlabelinfo","getshapeinfo","setobjectsmode","settweenmode"],zingchart.AB5&&-1!==ZC.AV(w,t)&&null!==(h=zingchart.AB5(e,t,i))&&(n=h),w=["getimagedata","exportimage","saveasimage","exportdata","downloadCSV","downloadXLS","downloadRAW","viewDataTable"],zingchart.AB6&&-1!==ZC.AV(w,t)&&null!==(h=zingchart.AB6(e,t,i))&&(n=h),w=["getzoom","pan","zoomin","zoomout","zoomto","zoomtovalues","viewall"],zingchart.ABP&&-1!==ZC.AV(w,t)&&null!==(h=zingchart.ABP(e,t,i))&&(n=h),w=["clearselection","getselection","setselection","select","deselect"],zingchart.AAL&&-1!==ZC.AV(w,t)&&null!==(h=zingchart.AAL(e,t,i))&&(n=h),w=["clearfeed","getinterval","setinterval","stopfeed","startfeed"],zingchart.ABH&&-1!==ZC.AV(w,t)&&null!==(h=zingchart.ABH(e,t,i))&&(n=h),a=0,r=zingchart.A93.length;a<r;a++)t===zingchart.A93[a].call&&null!==(h=zingchart.A93[a].api.call(zingchart,e,i))&&(n=h);return n},zingchart.extendAPI("addmenuitem",function(e,t){var i=zingchart.getLoader(e);i.DF["context-menu"]=i.DF["context-menu"]||{},i.DF["context-menu"]["custom-items"]=i.DF["context-menu"]["custom-items"]||[];for(var n=t.id||"",a=i.DF["context-menu"]["custom-items"],r=!1,l=0;l<a.length;l++)if(a[l].id===n){r=!0;break}r||i.DF["context-menu"]["custom-items"].push(t)});var A9T={$i:function(){var e=this;e.OG=null,e.o={},e.I6=null,e.J9=null,e.E={},e.E7=[],e.HT=null,e.MJ=""},H3:function(e,t,i,n,a){var r=this;if(e.HT){a=a||r.MJ;var l=e.HT.call(r,n,a);i&&l&&(l[i+"-state"]?l=l[i+"-state"]:l[i+"State"]&&(l=l[i+"State"]));var o,s,c=r.getPMap(),h={},C={};for(var u in l)o=ZC.EE(u),s=ZC.UJ(u),"backgroundColor"===o?h.A0=h.AE=ZC.AP.GC(l[u]):"borderRadius"===o?h.F6=h.FS=h.FD=h.F2=l[u]:"padding"===u?h.FM=h.FN=h.FU=h.EQ=l[u]:c[o]?h[c[o]]=l[u]:h[o]=l[u],C[s]=l[u];t.o||ZC._cp_(l,h),ZC._cp_(h,t),t.o&&(ZC._cp_(C,t.o),t.KX())}},parse:function(){var s=this,G,i,oRule,KT;"dashed"!==zingchart.SYNTAX&&ZC._todash_(s.o);var AA="";if("undefined"!=typeof s.H&&(AA=s.H.AA),ZC.ZO(s.o,"html5"),""!==AA&&ZC.ZO(s.o,AA),zingchart.DEV.MEDIARULES&&s.o["media-rules"]&&"undefined"!=typeof s.H)for(i=0;i<s.o["media-rules"].length;i++)oRule=s.o["media-rules"][i],KT=!0,null!==ZC._n_(oRule["min-width"])&&ZC._i_(oRule["min-width"])>s.H.I&&(KT=!1),null!==ZC._n_(oRule["max-width"])&&ZC._i_(oRule["max-width"])<s.H.I&&(KT=!1),null!==ZC._n_(oRule["min-height"])&&ZC._i_(oRule["min-height"])>s.H.F&&(KT=!1),null!==ZC._n_(oRule["max-height"])&&ZC._i_(oRule["max-height"])<s.H.F&&(KT=!1),KT&&ZC._cp_(oRule,s.o);for(s.o.rules&&(s.E7=s.o.rules),i=0;i<s.E7.length;i++)if("*"===s.E7[i].rule&&s.E7[i].js){s.o["js-rule"]=s.E7[i].js,s.E7.splice(i,1);break}if(G=s.o["js-rule"])if("function"==typeof G)s.MJ="",s.HT=eval(G);else if("javascript:"===G.substring(0,11)||G.indexOf("(")<G.indexOf(")"))try{s.MJ="";var EC=G.replace("javascript:",""),iOpen=G.indexOf("("),iClose=G.indexOf(")");-1!==iOpen&&-1!==iClose&&(s.MJ=EC.substr(iOpen+1,iClose-iOpen-1),EC=EC.substr(0,iOpen)),s.HT=ZC.evalFn(EC,window)}catch(e){}if("undefined"!=typeof s.H&&null!==s.H.QP)for(var g in s.H.QP)s.H.QP.hasOwnProperty(g)&&null===ZC._n_(s.o[g])&&(s.o[g]=s.H.QP[g])},getPMap:function(){return{}},addPMap:function(e,t,i){for(var n=t.split(","),a=i.split(","),r=0,l=a.length;r<l;r++)e[n[r]]=a[r]},getData:function(){return this.o},setData:function(e){this.o=e},getAttributes:function(){return this.E},getAttribute:function(e){return this.E[e]},setAttribute:function(e,t){this.E[e]=t},get:function(e){var t=this.getPMap();return t[e]?this[t[e]]:null},set:function(e,t){var i=this.getPMap();i[e]&&(this[i[e]]=t)},append:function(e,t,i){null===t&&(t=!0);var n=this;e&&(n.I6||(n.I6={},ZC._cp_(n.o,n.I6,!0,i)),n.J9||(n.J9={}),ZC._cp_(e,n.J9,!0,i),ZC._cp_(e,n.o,!0,i)),"undefined"!=typeof n.AD2&&n.AD2()&&e&&ZC._cp_(e,n.o)},AD2:function(){},assign_a:function(e){for(var t=0,i=e.length;t<i;t++)this.o.hasOwnProperty(e[t][0])&&this.ZQ(e[t][0],e[t][1],e[t][2],e[t][3],e[t][4])},ZQ:function(e,t,i,n,a){var r,l=this;if(null!==(r=l.o[e])&&void 0!==r){if(i)switch(-1!==i.indexOf("p")&&(r=ZC._p_(r),i=i.replace("p","")),-1!==i.indexOf("a")&&(r=ZC._a_(r),i=i.replace("a","")),i){case"i":r=ZC._i_(r);break;case"f":r=ZC._f_(r);break;case"b":r=ZC._b_(r);break;case"c":r=ZC.AP.YN(r,l),(r=ZC.AP.GC(r,l))instanceof Array&&("color"===e||"font-color"===e?(l.o["text-alpha"]=r[1],l.V5=r[1],l.E["text-alpha"]=r[1]):"border-color"===e?(l.o["border-alpha"]=r[1],l.O0=r[1],l.E["b-alpha"]=r[1]):("line-color"===e&&(l.E["l-alpha"]=r[1]),null===ZC._n_(l.o.alpha)&&(l.C6=r[1])),r=r[0])}null!==ZC._n_(n)&&null!==ZC._n_(a)&&(r=ZC._l_(r,n,a)),l[t]=r}},DE:function(){for(var e=this,t=!1,i=0,n=e.E7.length;i<n;i++){var a=!1;try{a=new Function("return ("+e.J2(e.E7[i].rule)+")")()}catch(r){a=!1}a&&(t=!0,e.append(e.E7[i]))}return t},ACJ:function(e){for(var t="",i=0,n=e.length;i<n;i++){var a=!1;try{a=new Function("return ("+this.J2(e[i].rule)+")")()}catch(r){a=!1}a&&(t+="<"+e[i].rule+">")}return""!==t?[t,ZC.XK.md5(t)]:null},J2:function(){return!0},copy:function(e){var t=this;ZC._cp_(e.o,t.o),e.I6&&(t.I6=t.I6||{},ZC._cp_(e.I6,t.I6)),e.J9&&(t.J9=t.J9||{},ZC._cp_(e.J9,t.J9)),ZC._cp_(e.E,t.E),ZC._cp_(e.E7,t.E7)}};ZC.A9T=ZC.C9.CA(A9T);var D0={$i:function(e){this.b(e);var t=this;e&&e.H&&(t.H=e.H),t.K="",t.DK=null,t.AN=!0,t.A0="-1",t.AE="-1",t.GR="",t.HN="",t.VM=!0,t.DA="",t.M4="repeat",t.TA="50% 50%",t.WN="",t.KO=1,t.NH="linear",t.N7=90,t.VO=0,t.W5=0,t.AZ=0,t.B7="#000",t.GD="",t.EX=0,t.G9=0,t.AU=0,t.BW="#000",t.C6=1,t.O0=1,t.T7="butt",t.ZZ="round",t.M8=!1,t.OH=45,t.JW=2,t.T5=.75,t.RT="#999",t.PD=0,t.CZ=!0,t.N4=!1,t.L5=!1,t.A2A=!1,t.LO=null,t.BF=""},getPMap:function(){var e=this.b();return this.addPMap(e,"visible,backgroundColor1,backgroundColor2,gradientColors,gradientStops,backgroundImage,backgroundRepeat,backgroundPosition,backgroundFit,backgroundScale,fillType,fillAngle,fillOffsetX,fillOffsetY,lineWidth,lineColor,lineStyle,lineSegmentSize,lineGapSize,borderWidth,borderColor,borderAlpha,alpha,lineCap,shadow,shadowAngle,shadowDistance,shadowAlpha,shadowColor,shadowBlur,class,border","AN,A0,AE,GR,HN,DA,M4,TA,WN,KO,NH,N7,VO,W5,AZ,B7,GD,EX,G9,AU,BW,O0,C6,T7,M8,OH,JW,T5,RT,PD,DK,BF"),e},copy:function(e){this.b(e);for(var t="AN,A0,AE,GR,HN,DA,VM,M4,TA,WN,KO,NH,N7,VO,W5,AZ,B7,GD,EX,G9,AU,BW,O0,C6,T7,M8,OH,JW,T5,RT,PD,CZ,L5,DK,H,BF".split(","),i=0,n=t.length;i<n;i++)"undefined"!=typeof e[t[i]]&&(this[t[i]]=e[t[i]])},AD2:function(){var e,t,i=this,n=!1;if((i.o["class"]||i.o.cls||i.o.id)&&null!==i.H&&null!==i.H.N){if(e=i.o["class"]||i.o.cls)for(var a=e.split(/(\s+)/),r=0,l=a.length;r<l;r++)(t=i.H.N["."+a[r]])&&(n=!0,ZC._cp_(t,i.o));(e=i.o.id)&&(t=i.H.N["#"+e])&&(n=!0,ZC._cp_(t,i.o))}return null!==i.OG&&(t=i.H.N[i.OG])&&(n=!0,ZC._cp_(t,i.o)),n},KX:function(e){var t,i=this;switch(null===ZC._n_(e)&&(e=i.AZ),i.GD){case"dotted":i.EX=ZC.BQ(1,.75*e),i.G9=1.75*e;break;case"dashed":i.EX=4*e,i.G9=3*e;break;case"dashdot":i.EX=4*e,i.G9=2*e;break;default:i.EX=0,i.G9=0}null!==(t=ZC._n_(i.o["line-segment-size"]))&&(i.EX=parseInt(t,10)),null!==(t=ZC._n_(i.o["line-gap-size"]))&&(i.G9=parseInt(t,10))},parse:function(){var e,t,i,n,a,r,l,o,s;this.b();var c=this;if(null!==(e=ZC._n_(c.o.override))&&!c.A2A){var h,C,u,d=-1,A=-1;for("undefined"!=typeof c.E.plotidx&&(d=ZC._i_(c.E.plotidx)),"undefined"!=typeof c.E.nodeidx&&(A=ZC._i_(c.E.nodeidx)),l=0,o=e.length;l<o;l++){if(h=-1,C=-1,e[l].hook){if(null!==(t=ZC._n_(e[l].hook["node-index"]))){if(C=0,u=[],"object"==typeof t)u=t;else if("string"==typeof t){if(-1!==t.indexOf(","))u=t.split(",");else if(-1!==t.indexOf("-"))for(i=t.split("-"),n=ZC._i_(i[0]);n<=ZC._i_(i[1]);n++)u.push(n)}else u=[t];-1!==ZC.AV(u,A)&&(C=1)}if(null!==(t=e[l].hook["plot-index"])&&void 0!==t){if(h=0,u=[],"object"==typeof t)u=t;else if("string"==typeof t){if(-1!==t.indexOf(","))u=t.split(",");else if(-1!==t.indexOf("-"))for(i=t.split("-"),n=ZC._i_(i[0]);n<ZC._i_(i[1]);n++)u.push(n)}else u=[t];-1!==ZC.AV(u,d)&&(h=1)}}0!==h&&0!==C&&c.append(e[l])}}if(null!==(e=c.LO)&&c.append(e),e=c.o["background-color"]){if(e=ZC.AP.YN(e,this),"rgb("===String(e).substring(0,4))for(a=new RegExp("rgb\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\)");r=a.exec(e);)e=e.replace(r[0],ZC.AP.GC(r[0]));if("rgba("===String(e).substring(0,5))for(a=new RegExp("rgba\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\,\\s*([0-9.]+)\\)");r=a.exec(e);){var p=ZC.AP.GC(r[0],c);e=e.replace(r[0],p[0]),c.o.alpha=p[1],c.C6=p[1],c.E["bg-alpha"]=p[1],null===ZC._n_(c.E["b-alpha"])&&(c.E["b-alpha"]=1),null===ZC._n_(c.E["l-alpha"])&&(c.E["l-alpha"]=1)}var g=ZC.GV(String(e)).split(/\s+|;|,/);c.A0=ZC.AP.GC(g[0]),c.AE=1===g.length?c.A0:ZC.AP.GC(g[1])}if(!(null===ZC._n_(c.o["border-width"])&&null===ZC._n_(c.o["border-color"])&&null===ZC._n_(c.o["line-style"])||null===ZC._n_(c.o["border-top"])&&null===ZC._n_(c.o["border-right"])&&null===ZC._n_(c.o["border-bottom"])&&null===ZC._n_(c.o["border-left"])&&null===ZC._n_(c.o.border))){var Z=["top","right","bottom","left"],f={top:[0,"solid","#000"],right:[0,"solid","#000"],bottom:[0,"solid","#000"],left:[0,"solid","#000"]};if(c.I6=c.I6||{},e=c.I6.border)for(s=e.split(/\s/),l=0;l<4;l++)f[Z[l]]=[ZC._i_(s[0]||"0"),ZC.GV(s[1]||"solid"),ZC.AP.GC(s[2]||"#000000")];if(null!==ZC._n_(c.I6["border-width"]))for(l=0;l<4;l++)f[Z[l]][0]=c.I6["border-width"];if(null!==ZC._n_(c.I6["line-style"]))for(l=0;l<4;l++)f[Z[l]][1]=c.I6["line-style"];if(null!==ZC._n_(c.I6["border-color"]))for(l=0;l<4;l++)f[Z[l]][2]=c.I6["border-color"];for(l=0;l<4;l++)(e=c.I6["border-"+Z[l]])&&(s=e.split(/\s/),f[Z[l]]=[ZC._i_(s[0]||"0"),ZC.GV(s[1]||"solid"),ZC.AP.GC(s[2]||"#000000")]);if(c.J9=c.J9||{},e=c.J9.border)for(s=e.split(/\s/),l=0;l<4;l++)f[Z[l]]=[ZC._i_(s[0]||"0"),ZC.GV(s[1]||"solid"),ZC.AP.GC(s[2]||"#000000")];if(null!==ZC._n_(c.J9["border-width"]))for(l=0;l<4;l++)f[Z[l]][0]=c.J9["border-width"];if(null!==ZC._n_(c.J9["line-style"]))for(l=0;l<4;l++)f[Z[l]][1]=c.J9["line-style"];if(null!==ZC._n_(c.J9["border-color"]))for(l=0;l<4;l++)f[Z[l]][2]=c.J9["border-color"];for(l=0;l<4;l++)(e=c.J9["border-"+Z[l]])&&(s=e.split(/\s/),f[Z[l]]=[ZC._i_(s[0]||"0"),ZC.GV(s[1]||"solid"),ZC.AP.GC(s[2]||"#000000")]);for(l=0;l<4;l++)null===ZC._n_(c.o["border-"+Z[l]])&&(c.o["border-"+Z[l]]=f[Z[l]].join(" "))}c.assign_a([["visible","AN","b"],["background-color-1","A0","c"],["background-color-2","AE","c"],["gradient-colors","GR"],["gradient-stops","HN"],["pixel-correction","CZ","b"],["background-clip","VM","b"],["background-image","DA"],["background-repeat","M4"],["background-position","TA"],["background-fit","WN"],["background-scale","KO","f"],["fill-type","NH"],["fill-angle","N7","i"],["fill-offset-x","VO","f"],["fill-offset-y","W5","f"],["line-width","AZ","i"],["line-color","B7","c"],["line-style","GD",""],["class","DK"],["cls","DK"],["border","BF"]]),"none"===c.NH&&(c.AE=c.A0,c.NH="linear"),""!==c.BF&&(s=c.BF.split(/\s/),c.AU=ZC._i_(s[0]||"0"),c.GD=ZC.GV(s[1]||"solid"),c.BW=ZC.AP.GC(s[2]||"#000000")),c.GR=ZC.AP.YN(c.GR,this),c.KX(),c.assign_a([["line-segment-size","EX","i"],["line-gap-size","G9","i"],["border-width","AU","i"],["border-color","BW","c"],["alpha","C6","f",0,1],["shadow","M8","b"],["shadow-angle","OH","i",0,360],["shadow-distance","JW","i"],["shadow-alpha","T5","f",0,1],["shadow-color","RT","c"],["shadow-blur","PD","i"]]),c.O0=c.C6,c.assign_a([["border-alpha","O0","f",0,1]])}};ZC.D0=ZC.A9T.CA(D0),ZC.CR={contour:function(e,t,i){var n,a,r;if(e&&i&&0!==i.length){if(!t.E["fast-vector-path"])for(n=0,a=i.length;n<a;n++)i[n]&&(i[n][0]=parseFloat(Number(i[n][0]).toFixed(2)),i[n][1]=parseFloat(Number(i[n][1]).toFixed(2)));var l=!1,o=i.length;for(n=0;n<o;n++)null!==ZC._n_(i[n])&&(r=[i[n][0],i[n][1]],null!==ZC._n_(i[n][2])&&r.push(i[n][2],i[n][3]),null!==ZC._n_(i[n][4])&&r.push(i[n][4],i[n][5]),t.N4&&(r[0]=Math.round(r[0]),r[1]=Math.round(r[1]),4===r.length&&(r[2]=Math.round(r[2]),r[3]=Math.round(r[3]))),t.CZ&&t.AZ%2==1&&(r[0]-=.5,r[1]-=.5,4===r.length&&(r[2]-=.5,r[3]-=.5))),0===n?e.moveTo(r[0],r[1]):i[n]?(l&&(e.moveTo(r[0],r[1]),l=!1),2===r.length?e.lineTo(r[0],r[1]):4===r.length?e.quadraticCurveTo(r[0],r[1],r[2],r[3]):6===r.length&&e.arc(r[0],r[1],r[2],ZC.T1(r[3]),ZC.T1(r[4]),r[5])):l=!0}},setup:function(e,t){var i=t.H.AA;if(1!==t.C6&&t.L5&&(null===ZC._n_(t.o["border-color"])&&(t.BW=t.A0),null===ZC._n_(t.o["border-width"])))switch(i){case"canvas":t.AU=.2;break;case"svg":t.AU=.1;break;case"vml":t.AU=.2,t.E.A8F=t.C6/10}},paint:function(e,t,i,n,a,r){if(null===ZC._n_(a)&&(a=2),null===ZC._n_(n)&&(n=!1),null===ZC._n_(r)&&(r=!1),e&&i&&0!==i.length&&t){var l,o,s,c,h,C;!r&&i.length>2&&null!==i[0]&&null!==i[i.length-1]&&i[0].join(",")===i[i.length-1].join(",")&&(t.T7="round");var u=t.H.AA;if("canvas"!==u||0!==t.AZ&&"-1"!==t.B7){if(t.M8&&!n){t.C7=t.C7||t.Z;var d,A=ZC.Q._sh_(i,t);"undefined"!=typeof t.A4V?d=t.A4V:((d=new ZC.DT(t)).copy(t),d.K=t.K+"-sh",d.M8=!1,d.AZ+=d.PD,d.B7=d.RT),d.C6=t.C6*d.T5,"undefined"==typeof t.ADH&&(t.A4V=d),d.CZ=!1,l=t.C7?ZC.Q.EB(t.C7,u):e,ZC.CR.setup(l,d),ZC.CR.paint(l,d,A,!1,1,r)}var p=ZC._i_(t.EX||"0"),g=ZC._i_(t.G9||"0");"solid"===t.GD&&(p=g=0);var Z=i.length;"undefined"==typeof t.A9&&(t.A9=0),"canvas"===u&&(e.lineJoin=t.ZZ,e.lineCap=t.T7,e.strokeStyle=ZC.AP.A32(ZC.AP.GC(t.B7),n?t.O0:t.C6),e.lineWidth=t.AZ,e.beginPath());var f=!1;if(-1!==ZC.AV(["svg","vml"],u))o=r?[]:ZC.Q.A2W(i,u,t,n);else{var _=!1;"dashdot"!==t.GD&&(_=e.setLineDash)&&e.setLineDash(0===p||0===g?[]:[p,g]);var b=0,m=[ZC.MAX,ZC.MAX,-ZC.MAX,-ZC.MAX];for(C=0;C<Z;C++)if(null!==i[C]){if(null!==(s=ZC.objmove?i[C]:ZC.Q._txp_(i[C],u,t,n))&&!isNaN(s[0])&&!isNaN(s[1])&&isFinite(s[0])&&isFinite(s[1]))if(Z<=6&&n&&(m[0]=ZC.CY(m[0],s[0]),m[1]=ZC.CY(m[1],s[1]),m[2]=ZC.BQ(m[2],s[0]),m[3]=ZC.BQ(m[3],s[1])),0===C)2===s.length?e.moveTo(s[0],s[1]):6===s.length&&e.arc(s[0],s[1],s[2],ZC.T1(s[3]),ZC.T1(s[4]),s[5]);else if(f&&(e.moveTo(s[0],s[1]),f=!1),_||0===p||0===g||4===s.length||6===s.length||7===s.length)2===s.length?e.lineTo(s[0],s[1]):4===s.length?e.quadraticCurveTo(s[0],s[1],s[2],s[3]):6===s.length?e.arc(s[0],s[1],s[2],ZC.T1(s[3]),ZC.T1(s[4]),s[5]):7===s.length&&e.bezierCurveTo(s[0],s[1],s[2],s[3],s[4],s[5]);else if(null!==i[C-1]){var v=ZC.Q._txp_(i[C-1],u,t,n),E=v[4===v.length?2:0],D=v[4===v.length?3:1],w=s[0],x=s[1],B=p+g,y=w-E,K=x-D,F=Math.sqrt(y*y+K*K)+b;if(F>p){var M;b=0,M="dashdot"===t.GD?Math.floor(ZC._a_(F/((B+t.AZ+g)/2))):Math.floor(ZC._a_(F/B));var z=Math.atan2(K,y),I=Math.cos(z),S=Math.sin(z),G=E,N=D,H=p;for(c=0;c<M;c++)"dashdot"===t.GD&&(B=c%2?t.AZ+g:p+g,H=c%2?t.AZ:p),y=I*B,K=S*B,e.moveTo(G,N),e.lineTo(G+I*H,N+S*H),G+=y,N+=K;e.moveTo(G,N),(F=Math.sqrt((w-G)*(w-G)+(x-N)*(x-N)))>p?e.lineTo(G+I*p,N+S*p):F>0&&e.lineTo(G+I*F,N+S*F),e.moveTo(w,x)}else b=F}}else f=!0;t.H&&Z<=6&&n&&(t.H.E[t.K+"-bounds"]=m)}switch(u){case"canvas":e.globalCompositeOperation=t.A0Z,e.stroke();break;case"svg":case"vml":if(null===ZC._n_(t.o["top-state"])&&t.H.O7&&(!n||t.E.areanode)){if(h=t.E.areanode?t.A0+"-"+t.AE+"-"+t.DA+"-"+t.AZ+"-"+t.GD+"-"+t.C6+"-"+t.BM+"-"+t.BH:t.B7+"-"+t.AZ+"-"+t.GD+"-"+t.C6+"-"+t.BM+"-"+t.BH,null===ZC._n_(t.H.NT[a])){t.H.NT[a]={uid:h,ctx:e,path:o,style:t,filled:n};break}if(t.H.NT[a].uid===h&&t.H.NT[a].path.length<2e3){c=t.H.NT[a].path,o&&o[0]&&(c.length>0&&c[c.length-1].replace(/[A-Z]+/,"")===o[0].replace(/[A-Z]+/,"")&&(o[0]=""),t.H.NT[a].path=t.H.NT[a].path.concat(o));break}"svg"===u?ZC.CR.VX(t.H.NT[a].ctx,t.H.NT[a].style,t.H.NT[a].path.join(" "),t.H.NT[a].filled):ZC.CR.VW(t.H.NT[a].ctx,t.H.NT[a].style,t.H.NT[a].path.join(" "),t.H.NT[a].filled),t.H.NT[a]={uid:h,ctx:e,path:o,style:t,filled:n};break}"svg"===u?ZC.CR.VX(e,t,o.join(" "),n,r):ZC.CR.VW(e,t,o.join(" "),n)}if(null!==ZC._n_(t.o["top-state"])&&!t.Y6&&!t.E["skip-top"]&&!t.VN){var k=new ZC.HL(t.A);k.copy(t),k.VN=!0,k.M8=!1,k.Z=t.Z,k.append(t.o["top-state"]),k.K=t.K+"-top",k.parse(),"svg"===u?ZC.CR.VX(e,k,o.join(" "),n,r):"vml"===u?ZC.CR.VW(e,k,o.join(" "),n):ZC.CR.paint(e,k,i,n,a,r)}}}},smooth:function(e,t,i){var n,a,r,l;ZC._n_(t)&&(t=!1),i=i||"h";var o=[],s=[];for(n=0,a=e.length;n<a;n++)e[n]&&("h"===i?(s.push(e[n][0]),o.push(e[n][1])):(s.push(e[n][1]),o.push(e[n][0])),0===n&&(s.push(s[0]),o.push(o[0])));for(s.push(s[s.length-1]),o.push(o[o.length-1]),e=[],r=1,l=o.length;r<l-1;r++){var c=[o[r-1],o[r],o[r+1],o[r+2]],h=ZC._a_(s[r+1]-s[r]),C=1/(h/c.length),u=ZC.AQ.Y9(t,c,h,C);for(n=0,a=u.length;n<a;n++)null!==ZC._n_(u[n][0])&&null!==ZC._n_(u[n][1])?"h"===i?e.push([s[r]+u[n][0]*h,u[n][1]]):e.push([u[n][1],s[r]+u[n][0]*h]):e.push(null)}return e},_append_:function(e,t,i){t.H&&t.H.G1?(null===ZC._n_(t.H.G1[e.id])&&(t.H.G1[e.id]=document.createDocumentFragment()),t.H.G1[e.id].appendChild(i)):e.appendChild(i)},VX:function(e,t,i,n,a){if(""!==i||a){var r,l,o,s,c,h,C;ZC.cache.data["svg-rect"]||(ZC.cache.data["svg-rect"]=ZC.Q.F5("rect","http://www.w3.org/2000/svg")),r=a?ZC.cache.data["svg-rect"].cloneNode(!0):ZC.Q.F5("path","http://www.w3.org/2000/svg");var u={};if(t.DK&&""!==t.DK&&(u["class"]=t.DK),a||(u.d=i),a){t.I<0&&(t.iX-=t.I,t.I=-t.I),t.F<0&&(t.iY+=t.F,t.F=-t.F);var d=0,A=0,p=1;t.CZ&&(p=0,d=A=t.AZ/2,0===t.iX&&(d=0),0===t.iY&&(A=0)),0===p||t.I<=3||t.F<=3?(l=Math.floor(t.iX)+d,o=Math.floor(t.iY)+A,s=Math.ceil(t.I)-2*d,c=Math.ceil(t.F)-2*d,h=t.F6,C=t.F6):(l=parseFloat(t.iX.toFixed(p))+d,o=parseFloat(t.iY.toFixed(p))+A,s=parseFloat(t.I.toFixed(p))-2*d,c=parseFloat(t.F.toFixed(p))-2*A,h=t.F6,C=t.F6),u.x=l,u.y=o,u.width=ZC.BQ(0,s),u.height=ZC.BQ(0,c),u.rx=h,u.ry=C,t.H&&(t.H.E[t.K+"-bounds"]=[u.x,u.y,u.x+u.width,u.y+u.height])}var g="";"undefined"==typeof t.K||""===t.K?"undefined"!=typeof t.H&&(g=t.H.GRAPHID+"-path-"+ZC.SEQ,ZC.SEQ++):g=t.K+"-path";var Z,f="";if("undefined"!=typeof t.BM&&"undefined"!=typeof t.BH&&(0===t.BM&&0===t.BH||(f+="translate("+t.BM+" "+t.BH+")")),"undefined"!=typeof t.A9&&0!==t.A9){var _=t.A9;"undefined"!=typeof t.E.cx&&(_+=","+(ZC._x_(t.E.cx)-.5)),"undefined"!=typeof t.E.cy&&(_+=","+(ZC._x_(t.E.cy)-.5)),f+=" rotate("+_+")"}if(n&&-1!==t.E.fill?(u.fill=t.E.fill,u["fill-opacity"]=t.C6):u.fill="none",u["stroke-linecap"]=t.T7,u["stroke-linejoin"]=t.ZZ,t.AZ>0&&(u.stroke=t.B7,u["stroke-width"]=t.AZ,u["stroke-opacity"]=n?t.O0:t.C6,"solid"===t.GD||0===t.EX&&0===t.G9||("dashdot"===t.GD?u["stroke-dasharray"]=[t.EX,t.G9,t.AZ,t.G9].join(" "):u["stroke-dasharray"]=t.EX+","+t.G9)),r.id=g,""!==f&&(u.transform=f),t.o["fast-line"]&&t.AZ>0?(r.setAttribute("stroke",u.stroke),r.setAttribute("stroke-width",u["stroke-width"]),r.setAttribute("stroke-opacity",u["stroke-opacity"]),r.setAttribute("d",i)):ZC.Q.G3(r,u),ZC.CR._append_(e,t,r),(!t.E.border||"all"===t.E.border)&&"undefined"!=typeof t.E.imgfill)if("string"==typeof t.E.imgfill)ZC.AK(g+"-imgfill")||(Z=a?ZC.Q.F5("rect","http://www.w3.org/2000/svg"):ZC.Q.F5("path","http://www.w3.org/2000/svg"),ZC.Q.G3(Z,{id:g+"-imgfill",transform:f,fill:t.E.imgfill,"fill-opacity":t.C6}),a?ZC.Q.G3(Z,{x:l,y:o,width:ZC.BQ(0,s),height:ZC.BQ(0,c),rx:h,ry:C}):ZC.Q.G3(Z,{d:i}),ZC.CR._append_(e,t,Z));else if(!ZC.AK(g+"-imgfill")){var b=t.E.imgfill,m=ZC.Q.F5("image","http://www.w3.org/2000/svg");m.setAttributeNS?"zc."===t.DA.substring(0,3)?m.setAttributeNS("http://www.w3.org/1999/xlink","href",ZC.IMAGES[t.DA]):m.setAttributeNS("http://www.w3.org/1999/xlink","href",t.DA):"zc."===t.DA.substring(0,3)?m.setAttribute("src",ZC.IMAGES[t.DA]):m.setAttribute("src",t.DA),null!==ZC._n_(t.E["clip-path"])&&ZC.Q.G3(m,{"clip-path":"url(#"+t.E["clip-path"]+")"}),ZC.Q.G3(m,{id:g+"-imgfill",x:b[1],y:b[2],"fill-opacity":t.C6,width:t.E["bg-image-width"],height:t.E["bg-image-height"],preserveAspectRatio:"none"}),ZC.CR._append_(e,t,m)}}},VW:function(e,t,i,n){var a,r,l,o,s,c;n&&(i+=" x e");var h="";"undefined"==typeof t.K||""===t.K?"undefined"!=typeof t.H&&(h=t.H.GRAPHID+"-path-"+ZC.SEQ,ZC.SEQ++):h=t.K+"-path";var C=ZC.Q.F5("zcv:shape");C.style.position="absolute",C.style.rotation=t.A9,C.id=h;var u=ZC.Q.F5("zcv:path");if(u.v=i,u.setAttribute("VMLv",i),C.appendChild(u),0===t.AZ)C.stroked=!1;else{var d=ZC.Q.F5("zcv:stroke");if(o=t.C6,"undefined"!=typeof t.E.A8F&&(o=t.E.A8F),"undefined"!=typeof t.E.stroke)r=t.E.stroke.weight,l=t.E.stroke.color,o=t.E.stroke.opacity,s=t.E.stroke.dashstyle;else{switch(s="solid",t.GD){case"solid":s="solid";break;case"dotted":s="dot";break;case"dashed":s="dash";break;default:s=t.GD}"solid"!==s&&"0 0"!=(a=ZC.CY(6,t.EX*t.AZ)+" "+ZC.CY(8,t.G9*t.AZ))&&(s=a),r=t.AZ,l=t.B7}ZC.Q.G3(d,{weight:r+"px",color:l,opacity:o,miterlimit:10,endcap:"flat",joinstyle:"round",dashstyle:s}),C.appendChild(d)}n&&"undefined"!=typeof t.E.fill&&-1!==t.E.fill?(C.filled=!0,C.appendChild(t.E.fill)):C.filled=!1,ZC.Q.G3(C,{coordorigin:"0 0",coordsize:t.A9%360==0?"100 100":t.H.I+" "+t.H.F});var A=0,p=0;if(t.A9%360!=0&&"undefined"!=typeof t.E.cx&&"undefined"!=typeof t.E.cy){var g=t.H.I/2-t.E.cx,Z=t.H.F/2-t.E.cy,f=0===Z?0:ZC.TK(Math.atan(g/Z));t.E.cy>t.H.F/2&&(f+=180);var _=Math.sqrt(g*g+Z*Z);A=g-_*ZC.EP(f-t.A9),p=Z-_*ZC.EH(f-t.A9)}var b=0-A;null!==ZC._n_(t.BM)&&(b+=t.BM);var m=0-p;if(null!==ZC._n_(t.BH)&&(m+=t.BH),C.style.left=b+"px",C.style.top=m+"px",e.appendChild(C),t.A9%360==0?(C.style.width="10px",C.style.height="10px"):(C.style.width=t.H.I+"px",C.style.height=t.H.F+"px"),("all"===t.E.border||"undefined"!=typeof t.E.imgfill)&&"undefined"!=typeof t.E.imgfill){var v=t.E.imgfill;1===v.length?((C=ZC.Q.F5("zcv:shape")).style.position="absolute",C.style.rotation=t.A9,(u=ZC.Q.F5("zcv:path")).v=i,C.appendChild(u),C.appendChild(v[0]),C.stroked=!1,ZC.Q.G3(C,{id:h+"-imgfill",filled:!0,coordorigin:"0 0",coordsize:t.A9%360==0?"100 100":t.H.I+" "+t.H.F}),C.style.left=b+"px",C.style.top=m+"px",e.appendChild(C),t.A9%360==0?(C.style.width="10px",C.style.height="10px"):(C.style.width=t.H.I+"px",C.style.height=t.H.F+"px")):3===v.length&&((c=ZC.Q.F5("img")).id=h+"-img","zc."===t.DA.substring(0,3)?c.src=ZC.IMAGES[t.DA]:c.src=t.DA,c.style.position="absolute",c.style.left=v[1]+"px",c.style.top=v[2]+"px",c.style.width=t.E["bg-image-width"]+"px",c.style.height=t.E["bg-image-height"]+"px",e.appendChild(c))}}};var DT={$i:function(e){this.b(e);var t=this;t.A=e,t.Z=null,t.C7=null,t.H8="",t.iX=-1,t.iY=-1,t.DU="poly",t.D=[],t.D1=[0,0,0,0],t.A9=0,t.AI=0,t.JQ=0,t.BM=0,t.BH=0,t.AA8=0,t.DV=0,t.B4=0,t.BK=360,t.CN=0,t.U0=!1,t.ADA=!1,t.A5F=0,t.AAO="",t.O7=!1,t.A9D=1,t.JR=1,t.EA=null,t.FB=null,t.IV="auto",t.K9=!1,t.A0Z="source-over",t.QW=!1},getPMap:function(){var e=this.b();return this.addPMap(e,"objectId,x,y,points,bounds,pieAngleStart,pieAngleEnd,pieSlice,url,target,offsetX,offsetY,offsetR,size,size2,angle,shape,flat,cursor","H8,iX,iY,D,D1,B4,BK,CN,EA,FB,BM,BH,DV,AI,JQ,A9,DU,K9,IV"),e},build:function(){},copy:function(e){this.b(e);var t,i,n=this,a="BM,BH,DV,AI,JQ,A9,DU,K9,IV".split(",");for(t=0,i=a.length;t<i;t++)"undefined"!=typeof e[a[t]]&&(n[a[t]]=e[a[t]]);if(e.D&&e.D.length>0)for(n.D=[],t=0,i=e.D.length;t<i;t++)n.D.push(e.D[t])},ll_:function(e,t){var i=this;-1!==(""+e).indexOf("lat")&&(t="y"),-1!==(""+e).indexOf("lon")&&(t="x"),e=ZC._f_((""+e).replace("lat","").replace("lon",""));var n=zingchart.maps.maps[i.A5F];return n&&(e=zingchart.maps.lonlat2xy(n._INFO_.x,n._INFO_.y,n._INFO_.width,n._INFO_.height,"x"===t?[e,0]:[0,e],n._INFO_.bbox,{map:i.A5F,item:i.AAO,zoom:n._INFO_.zoom,offsetX:n._INFO_.offsetX,offsetY:n._INFO_.offsetY},!0)),e=ZC._i_("x"===t?e[0]:e[1])},kv_:function(e,t){var i;-1!==(""+e).indexOf("val")&&(t="y"),-1!==(""+e).indexOf("key")&&(t="x"),e=ZC._f_((""+e).replace("key","").replace("val",""));var n=this.H||zingchart.HZ[0];if(n){var a=this.A||n.AG[0];a&&("x"===t?null!==(i=a.BU("k")[0])&&(e=ZC._i_(i.AT(e))):null!==(i=a.BU("v")[0])&&(e=ZC._i_(i.AT(e))))}return ZC._i_(e)},xy_:function(e,t,i){var n=this;t=t||"x";var a=""+e;if(-1!==a.indexOf("lat")||-1!==a.indexOf("lon"))return n.ll_(e,t);if(-1!==a.indexOf("val")||-1!==a.indexOf("key"))return n.kv_(e,t);if(""+ZC._f_(e)!==a)return-1!==(e+="").indexOf("%")?n.xy_(parseFloat(e.replace("%",""))/100,t,!0):-1!==e.indexOf("px")?n.xy_(parseFloat(e.replace("px","")),t):n.xy_(parseFloat(e),t);var r="undefined"!=typeof n.E["p-x"]?n.E["p-x"]:n.A.iX,l="undefined"!=typeof n.E["p-y"]?n.E["p-y"]:n.A.iY,o="undefined"!=typeof n.E["p-width"]?n.E["p-width"]:n.A.I,s="undefined"!=typeof n.E["p-height"]?n.E["p-height"]:n.A.F;return(e>=1||e<0||zingchart.DEV.IGNORESUBUNIT)&&!i?"x"===t?r+parseFloat(e):l+parseFloat(e):e>=0&&e<1||i?"x"===t?(o=o||1,Math.round(r+o*e)):(s=s||1,Math.round(l+s*e)):void 0},locate:function(e){var t,i=this;if(i.U0)return-1!==(""+i.o.x).indexOf("lon")?i.iX=i.ll_(i.o.x,"x"):i.ZQ("x","iX"),-1!==(""+i.o.y).indexOf("lat")?i.iY=i.ll_(i.o.y,"y"):i.ZQ("y","iY"),void i.A3W();1===e?(null!==(t=ZC._n_(i.o.x))&&(i.iX=i.xy_(t,"x")),null!==(t=ZC._n_(i.o.y))&&(i.iY=i.xy_(t,"y")),-1===i.iX&&(i.iX=i.A.iX),-1===i.iY&&(i.iY=i.A.iY)):2===e&&(i.A3W(),i.I=i.D1[2]-i.D1[0],i.F=i.D1[3]-i.D1[1])},A3W:function(){var e,t=this,i=ZC.MAX,n=ZC.MAX,a=-ZC.MAX,r=-ZC.MAX;switch(t.DU){case"custom":i=0,n=0,a=0,r=0;break;case"circle":case"arc":case"pie":i=t.iX-t.AI,n=t.iY-t.AI,a=t.iX+t.AI,r=t.iY+t.AI;break;default:for(var l=0,o=t.D.length;l<o;l++)null!==(e=t.D[l])&&(i=Math.min(i,e[0]),n=Math.min(n,e[1]),a=Math.max(a,e[0]),r=Math.max(r,e[1]))}t.D1=[i,n,a,r]},FF:function(){var e,t=this;if("pie"===t.DU){var i=1,n=[],a=t.B4+t.A9,r=t.BK+t.A9,l=t.AI+Math.floor(t.AU/2),o=t.CN-Math.floor(t.AU/2);for(l>50&&(i=2),l>100&&(i=4),0===o?a%360!=r%360&&n.push([t.iX,t.iY]):n.push(ZC.AQ.BN(t.iX,t.iY,o,a),ZC.AQ.BN(t.iX,t.iY,(l+o)/2,a-.25*t.AU),ZC.AQ.BN(t.iX,t.iY,l,a)),e=a;e<=r;e+=i)n.push(ZC.AQ.BN(t.iX,t.iY,l,e));if(n.push(ZC.AQ.BN(t.iX,t.iY,l,r)),n.push(ZC.AQ.BN(t.iX,t.iY,(l+o)/2,r+.25*t.AU)),0===o)a%360!=r%360&&n.push([t.iX,t.iY]);else{for(n.push(ZC.AQ.BN(t.iX,t.iY,o,r)),e=r;e>=a;e-=i)n.push(ZC.AQ.BN(t.iX,t.iY,o,e));n.push(ZC.AQ.BN(t.iX,t.iY,o,a))}return n.push([n[0][0],n[0][1]]),ZC.AQ.PR(n,Math.min(5,l/5),[t.BM,t.BH])}if(0===t.A9||"rectangle"!==t.DU&&"rect"!==t.DU)return ZC.AQ.PR(t.D,Math.min(5,t.AI/5),[t.BM,t.BH]);var s,c,h,C,u,d,A,p,g=[];for(h=ZC._i_((t.D1[0]+t.D1[2])/2),C=ZC._i_((t.D1[1]+t.D1[3])/2),s=0,c=t.D.length;s<c;s++)null!==t.D[s]&&(u=t.D[s][0]-h,d=t.D[s][1]-C,A=u*ZC.EH(t.A9)-d*ZC.EP(t.A9),p=u*ZC.EP(t.A9)+d*ZC.EH(t.A9),g[s]=[A+h,p+C]);return ZC.AQ.PR(g,Math.min(5,t.AI/5),[t.BM,t.BH])},A4Y:function(){var e,t,i,n,a,r,l,o,s,c=this,h=ZC.ie67?ZC.MAPTX:0;switch(c.DU){case"line":if(i=[].concat(c.D),0!==c.A9)for(n=(c.D1[0]+c.D1[2])/2,a=(c.D1[1]+c.D1[3])/2,e=0,t=i.length;e<t;e++)null!==i[e]&&(r=i[e][0]-n,l=i[e][1]-a,o=r*ZC.EH(c.A9)-l*ZC.EP(c.A9),s=r*ZC.EP(c.A9)+l*ZC.EH(c.A9),i[e]=[o+n,s+a]);var C=["poly"];for(e=0,t=i.length;e<t-1;e++)null!==i[e]&&null!==i[e+1]&&C.push(ZC.AQ.PR(ZC.AQ.Z0([i[e],i[e+1]]),4,[c.BM,c.BH]));return C;case"cross":case"plus":return["circle",ZC._i_(c.iX+h+c.BM)+","+ZC._i_(c.iY+h+c.BH)+","+ZC._i_(c.AI)];case"circle":case"arc":return["circle",ZC._i_(c.iX+h+c.BM)+","+ZC._i_(c.iY+h+c.BH)+","+ZC._i_(c.AI+2)];case"pie":return["poly",c.FF()];default:var u,d=["poly"];for(i=[],e=0,t=c.D.length;e<t;e++)if(null!==c.D[e])if(6===c.D[e].length)for(var A=c.D[e][3];A<c.D[e][4];A+=1)i.push(ZC.AQ.BN(c.D[e][0],c.D[e][1],c.D[e][2],A));else if(4===c.D[e].length&&i[e-1]){var p={x:i[i.length-1][0],y:i[i.length-1][1]},g={x:c.D[e][2],y:c.D[e][3]},Z={x:c.D[e][0],y:c.D[e][1]};for(u=0;u<=1;u+=.1)i.push([(1-u)*(1-u)*p.x+2*u*(1-u)*Z.x+u*u*g.x,(1-u)*(1-u)*p.y+2*u*(1-u)*Z.y+u*u*g.y])}else if(7===c.D[e].length&&i[e-1]){var f={x:i[i.length-1][0],y:i[i.length-1][1]},_={x:c.D[e][0],y:c.D[e][1]},b={x:c.D[e][2],y:c.D[e][3]},m={x:c.D[e][4],y:c.D[e][5]};for(u=0;u<=1;u+=.1){var v=(1-u)*(1-u)*(1-u),E=3*u*(1-u)*(1-u),D=3*u*u*(1-u),w=u*u*u;i.push([v*f.x+E*_.x+D*b.x+w*m.x,v*f.y+E*_.y+D*b.y+w*m.y])}}else i.push(c.D[e]);else i.length>-1&&d.push(ZC.AQ.PR(i,Math.min(5,c.AI/5),[c.BM,c.BH])),i=[];if(0!==c.A9)for(n=ZC._i_((c.D1[0]+c.D1[2])/2),a=ZC._i_((c.D1[1]+c.D1[3])/2),e=0,t=i.length;e<t;e++)null!==i[e]&&(r=i[e][0]-n,l=i[e][1]-a,o=r*ZC.EH(c.A9)-l*ZC.EP(c.A9),s=r*ZC.EP(c.A9)+l*ZC.EH(c.A9),i[e]=[o+n,s+a]);return i.length>-1&&d.push(ZC.AQ.PR(i,Math.min(5,c.AI/5),[c.BM,c.BH])),d}},parse:function(e){var t,i,n,a,r,l,o;null===ZC._n_(e)&&(e=!1),this.o.tween||e||this.b();var s=this;if(!s.o.tween&&!e){s.assign_a([["map","A5F"]]),"string"==typeof s.o.item&&s.assign_a([["item","AAO"]]),0!==s.A5F&&(null===ZC._n_(s.o["map-item"])||s.o["map-item"])&&(s.o["map-item"]=!0,s.o["map-skip-z-sort"]=!0);var c=["offset-x","offset-y"];for(i=0;i<2;i++){var h=c[i],C="offset-x"===h?"lon":"lat";if(null!==(t=s.o[h])&&void 0!==t&&-1!==(t=""+t).indexOf(C)){t=ZC._f_(t.replace(C,""));var u=zingchart.maps.maps[s.A5F];u&&(t=zingchart.maps.translate(h.replace("offset-"),t,s.A.I,s.A.F,u._INFO_.bbox),s.o[h]=t)}}for(s.assign_a([["url","EA"],["target","FB"],["cursor","IV"],["id","H8"],["angle","A9","i"],["static","K9","b"],["flat","K9","b"],["angle-start","B4","f"],["angle-end","BK","f"],["slice","CN","i"],["size","AI","f"],["size-2","JQ","f"],["fast-vector-path","QW","b"],["type","DU"],["points","D"],["offset-x","BM"],["offset-y","BH"],["offset-z","AA8","i"],["offset-r","DV","i"],["z-sort","A9D","i"],["z-index","JR","f"],["composite","A0Z"]]),s.BM=ZC.II(s.BM,!0),s.BH=ZC.II(s.BH,!0),s.BM>-1&&s.BM<1&&"undefined"!=typeof s.E["p-width"]&&(s.BM*=s.E["p-width"]),s.BH>-1&&s.BH<1&&"undefined"!=typeof s.E["p-height"]&&(s.BH*=s.E["p-height"]),s.AI=ZC.BQ(1,s.AI),s.JQ=ZC.BQ(1,s.JQ),null!==s.o["z-sort"]&&"undefined"!=typeof s.o["z-sort"]||(s.A9D=s.JR),"rectangle"!==s.DU&&"rect"!==s.DU||s.assign_a([["width","AI","f"],["height","JQ","f"]]),s.A59?(s.D=JSON.parse(JSON.stringify(s.F9)),s.A59=!1):s.F9=JSON.parse(JSON.stringify(s.D)),i=0,n=s.D.length;i<n;i++)if(null!==s.D[i])for(var d=0;d<s.D[i].length;d++)-1===(""+s.D[i][d]).indexOf("lat")&&-1===(""+s.D[i][d]).indexOf("lon")||(s.A59=!0,s.D[i][d]=s.ll_(s.D[i][d],d%2==0?"x":"y")),-1===(""+s.D[i][d]).indexOf("key")&&-1===(""+s.D[i][d]).indexOf("val")||(s.A59=!0,s.D[i][d]=s.kv_(s.D[i][d],d%2==0?"x":"y"))}if(s.o.tween=null,s.A9=s.A9%360,s.locate(1),"bar"!==s.DU){var A=s.AI,p=s.JQ;switch(s.DU){case"custom":break;case"triangle":A=s.AI;var g=.1*s.AI;s.D=[[s.iX-A,s.iY+A-g],[s.iX,s.iY-A-g],[s.iX+A,s.iY+A-g],[s.iX-A,s.iY+A-g]];break;case"square":A=ZC._i_(.9*s.AI),s.D=[[s.iX-A,s.iY-A],[s.iX-A,s.iY+A],[s.iX+A,s.iY+A],[s.iX+A,s.iY-A],[s.iX-A,s.iY-A]];break;case"diamond":A=ZC._i_(1.2*s.AI),p=ZC._i_(1.2*(1===s.JQ?s.AI:s.JQ)),s.D=[[s.iX-A,s.iY],[s.iX,s.iY+p],[s.iX+A,s.iY],[s.iX,s.iY-p],[s.iX-A,s.iY]];break;case"trapezoid":s.D=[[s.iX-A/2,s.iY+s.JQ],[s.iX+A/2,s.iY+s.JQ],[s.iX+A,s.iY-s.JQ],[s.iX-A,s.iY-s.JQ],[s.iX-A/2,s.iY+s.JQ]];break;case"rectangle":case"rect":s.D=[[s.iX-A/2,s.iY-s.JQ/2],[s.iX+A/2,s.iY-s.JQ/2],[s.iX+A/2,s.iY+s.JQ/2],[s.iX-A/2,s.iY+s.JQ/2],[s.iX-A/2,s.iY-s.JQ/2]];break;case"parallelogram":s.D=[[s.iX-A/2,s.iY-s.JQ/2],[s.iX+3*A/2,s.iY-s.JQ/2],[s.iX+A,s.iY+s.JQ/2],[s.iX-A,s.iY+s.JQ/2],[s.iX-A/2,s.iY-s.JQ/2]];break;case"plus":A=s.AI,s.D=[[s.iX,s.iY-A],[s.iX,s.iY+A],null,[s.iX-A,s.iY],[s.iX+A,s.iY]];break;case"cross":A=s.AI,s.D=[[s.iX-A,s.iY-A],[s.iX+A,s.iY+A],null,[s.iX-A,s.iY+A],[s.iX+A,s.iY-A]];break;case"ic_line":A=s.AI/4,s.D=[[s.iX-2*A,s.iY+A],[s.iX-A,s.iY],[s.iX,s.iY+A],[s.iX+A,s.iY-A],[s.iX+2*A,s.iY]];break;case"ic_area":A=s.AI/4,s.D=[[s.iX-2*A,s.iY+2*A],[s.iX-2*A,s.iY+A],[s.iX-A,s.iY],[s.iX,s.iY+A],[s.iX+A,s.iY-A],[s.iX+2*A,s.iY],[s.iX+2*A,s.iY+2*A],[s.iX-2*A,s.iY+2*A]];break;case"ic_bars":s.CZ=!1,A=s.AI/4,s.D=[[s.iX-2*A,s.iY+2*A],[s.iX-2*A,s.iY-A],[s.iX-A,s.iY-A],[s.iX-A,s.iY+2*A],[s.iX-2*A,s.iY+2*A],[s.iX-2*A,s.iY+2*A-A],null,[s.iX-A/2,s.iY+2*A],[s.iX-A/2,s.iY],[s.iX+A/2,s.iY],[s.iX+A/2,s.iY+2*A],[s.iX-A/2,s.iY+2*A],[s.iX-A/2,s.iY+2*A-A],null,[s.iX+2*A,s.iY+2*A],[s.iX+2*A,s.iY-2*A],[s.iX+A,s.iY-2*A],[s.iX+A,s.iY+2*A],[s.iX+2*A,s.iY+2*A],[s.iX+2*A,s.iY+2*A-A]];break;case"arrow":A=2*s.AI;var Z=s.A9;s.A9=0;var f=ZC.AQ.BN(s.iX,s.iY,A,Z-35),_=ZC.AQ.BN(s.iX,s.iY,A,Z+35);s.D=[[s.iX,s.iY],f,null,[s.iX,s.iY],_];break;case"star3":case"star4":case"star5":case"star6":case"star7":case"star8":case"star9":for(s.D=[],A=2*s.AI,r=360/(a=ZC._i_(s.DU.replace("star",""))),l=a%2==0?0:-90,o=A/(a>4?2:7-a),i=0+l;i<360+l;i+=r)s.D.push(ZC.AQ.BN(s.iX,s.iY,.75*A,i),ZC.AQ.BN(s.iX,s.iY,.75*o,i+r/2));s.D.push([s.D[0][0],s.D[0][1]]);break;case"rpoly3":case"rpoly4":case"rpoly5":case"rpoly6":case"rpoly7":case"rpoly8":case"rpoly9":for(s.D=[],A=s.AI,r=360/(a=ZC._i_(s.DU.replace("rpoly",""))),l=a%2==0?0:-90,null!==ZC._n_(s.o["angle-offset"])&&(l=ZC._i_(s.o["angle-offset"])),i=0+l;i<360+l;i+=r)s.D.push(ZC.AQ.BN(s.iX,s.iY,A,i));s.D.push([s.D[0][0],s.D[0][1]]);break;case"gear3":case"gear4":case"gear5":case"gear6":case"gear7":case"gear8":case"gear9":for(s.D=[],A=2*s.AI,r=360/(2*(a=ZC._i_(s.DU.replace("gear","")))),o=.75*A,i=0+(l=a%2==0?0:-90);i<360+l;i+=2*r){var b=i+r/2;s.D.push(ZC.AQ.BN(s.iX,s.iY,.75*A,b),ZC.AQ.BN(s.iX,s.iY,.75*A,b+r),ZC.AQ.BN(s.iX,s.iY,.75*o,b+r+0*r),ZC.AQ.BN(s.iX,s.iY,.75*o,b+2*r-0*r))}s.D.push([s.D[0][0],s.D[0][1]]);break;case"hamburger":A*=2;var m=s.iX,v=s.iY-10;s.D=s.D.concat([[m-A/2,v-s.JQ/2],[m+A/2,v-s.JQ/2],[m+A/2,v+s.JQ/2],[m-A/2,v+s.JQ/2],[m-A/2,v-s.JQ/2],null]),v+=5,s.D=s.D.concat([[m-A/2,v-s.JQ/2],[m+A/2,v-s.JQ/2],[m+A/2,v+s.JQ/2],[m-A/2,v+s.JQ/2],[m-A/2,v-s.JQ/2],null]),v+=5,s.D=s.D.concat([[m-A/2,v-s.JQ/2],[m+A/2,v-s.JQ/2],[m+A/2,v+s.JQ/2],[m-A/2,v+s.JQ/2],[m-A/2,v-s.JQ/2],null]);break;case"ellipse":for(s.CZ=!1,s.D=[],i=0;i<=360;i+=5)s.D.push([s.iX+s.AI*ZC.EH(i),s.iY+s.JQ*ZC.EP(i)]);s.D.push([s.D[0][0],s.D[0][1]]);break;case"arc":s.CZ=!1,s.D=[ZC.AQ.BN(s.iX,s.iY,s.AI,s.B4),[s.iX,s.iY,s.AI,s.B4,s.BK,0]];break;case"pie":for(var E=(s.o["pie-transform"]||"").split(/=|,/);s.B4<0||s.BK<0;)s.B4+=360,s.BK+=360;s.CZ=!1;var D=!1;-1!==ZC.AV(["svg","vml"],s.H.AA)&&s.B4%360==s.BK%360&&(s.B4+=.05,s.BK-=.05,D=!0);var w,x,B,y,K,F=s.iX,M=s.iY,z=ZC._x_(s.B4,2),I=ZC._x_(s.BK,2),S=ZC._x_((z+I)/2,2),G=A,N=s.CN,H=0===N&&z%360!=I%360&&!D;switch(s.D=[],"circle"!==E[0]&&(0===N?z%360==I%360||D||s.D.push([F,M]):s.D.push(ZC.AQ.BN(F,M,N,z))),E[0]){case"flat":case"fold":s.D.push(ZC.AQ.BN(F,M,G,z),ZC.AQ.BN(F,M,G-("fold"===E[0]?ZC._i_(E[1]):0),I)),H||s.D.push(ZC.AQ.BN(F,M,N,I));break;case"callout":s.D.push(ZC.AQ.BN(F,M,G,z),[F,M,G,z,I,0]),H||(w=1.5*ZC._i_(E[1])*360/(2*Math.PI*G),s.D.push(ZC.AQ.BN(F,M,G,I),ZC.AQ.BN(F,M,N,I),[F,M,N,I,S+w,1],ZC.AQ.BN(F,M,N-ZC._i_(E[1]),S),ZC.AQ.BN(F,M,N,S-w),[F,M,N,S-w,z,1]));break;case"flow":w=ZC._i_(E[1]),y=ZC.AQ.BN(F,M,(N+G)/2,z),99===w||-99===w?s.D.push([y[0],y[1],(G-N)/2,z+180,z,99===w?1:0]):s.D.push(ZC.AQ.BN(F,M,(N+G)/2,z+w)),s.D.push(ZC.AQ.BN(F,M,G,z),[F,M,G,z,I,0]),K=ZC.AQ.BN(F,M,(N+G)/2,I),H?99===w||-99===w?s.D.push(ZC.AQ.BN(F,M,G,I),[K[0],K[1],(G-N)/2,I,I+180,99===w?0:1]):s.D.push(ZC.AQ.BN(F,M,(N+G)/2,I+w)):(99===w||-99===w?s.D.push([K[0],K[1],(G-N)/2,I,I+180,99===w?0:1]):s.D.push(ZC.AQ.BN(F,M,(N+G)/2,I+w)),s.D.push(ZC.AQ.BN(F,M,N,I),[F,M,N,I,z,1]));break;case"circle":var k=ZC._f_(E[1]||"1"),L=(5+ZC._a_(I-z)%360*50/360)*k;B=I%360==z%360||D?[F,M]:ZC.AQ.BN(F,M,(G+N)/2,(z+I)/2),s.D.push(ZC.AQ.BN(B[0],B[1],L,0),[B[0],B[1],L,0,360,0]);break;case"bite":w=ZC._i_(E[1]),x=ZC._i_(2*G*ZC.EP(w/2)),B=ZC.AQ.BN(F,M,G,z),s.D.push(ZC.AQ.BN(F,M,G-x,z),[B[0],B[1],x,z+180,z+90+(90-(180-w)/2),1],[F,M,G,z+w,I,0]),H||s.D.push(ZC.AQ.BN(F,M,N,I),[F,M,N,I,z,1]);break;case"droplet":for(var Q=G,P=1,O=0;G*P+O>=Q;)P=ZC._x_(P-.02,2),x=ZC._i_(G*P/ZC.EH((I-z)/2)),O=ZC._i_(G*P*Math.tan(ZC.T1((I-z)/2)));B=ZC.AQ.BN(F,M,x,S),s.D.push(ZC.AQ.BN(F,M,G*P,z),[B[0],B[1],O,S-(360-(180-(I-z)))/2,S+(360-(180-(I-z)))/2,0]),H||s.D.push(ZC.AQ.BN(F,M,N,I),[F,M,N,I,z,1]);break;default:s.D.push(ZC.AQ.BN(F,M,G,z),[F,M,G,z,I,0]),0===N?z%360==I%360||D||s.D.push([F,M]):s.D.push(ZC.AQ.BN(F,M,G,I),ZC.AQ.BN(F,M,N,I),[F,M,N,I,z,1])}s.D.push([s.D[0][0],s.D[0][1]])}}s.locate(2)},paint:function(){var e=this;if("none"!==e.DU&&("custom"===e.DU||"circle"===e.DU||"arc"===e.DU||0!==e.D.length)){var t,i,n={x:"iX",y:"iY",width:"I",height:"F",size:"AI"};if(e.o["bottom-state"]&&!e.Y6&&!e.VN&&!e.bIsBottom){var a=new ZC.DT(e.A);for(t in a.copy(e),a.bIsBottom=!0,a.M8=!1,a.Z=e.Z,a.append({x:e.iX-e.A.iX,y:e.iY-e.A.iY}),a.append(e.o["bottom-state"]),a.K=e.K+"-bottom",a.parse(),i=!1,n)null===ZC._n_(a.o[t])||-1===(""+a.o[t]).indexOf("+")&&-1===(""+a.o[t]).indexOf("-")||(a.o[t]=a[n[t]]=e[n[t]]+ZC._i_(a.o[t]),i=!0);i&&a.parse(),a.paint()}var r=e.H.AA;switch(e.M8&&e.C7&&e.A97(),r){case"canvas":e.A1V();break;case"svg":e.VX();break;case"vml":e.VW()}if(e.o["top-state"]&&!e.Y6&&!e.VN&&!e.bIsBottom){var l=new ZC.DT(e.A);for(t in l.copy(e),l.VN=!0,l.M8=!1,l.Z=e.Z,l.append({x:e.iX-e.A.iX,y:e.iY-e.A.iY}),l.append(e.o["top-state"]),l.K=e.K+"-top",l.parse(),i=!1,n)null===ZC._n_(l.o[t])||-1===(""+l.o[t]).indexOf("+")&&-1===(""+l.o[t]).indexOf("-")||(l.o[t]=l[n[t]]=e[n[t]]+ZC._i_(l.o[t]),i=!0);i&&l.parse(),l.paint()}}},A97:function(){var e,t=this,i=new ZC.DT(t.A);i.K=t.K+"-sh",i.copy(t),i.O7=t.O7,i.Z=t.C7,i.M8=!1,i.Y6=!0,i.A0=i.AE=i.RT,i.GR=i.HN="",i.DA="",i.GD="solid",i.BW=i.RT,i.AZ=0,i.C6=i.T5*t.C6,i.K=t.K+"-sh";var n=(t.JW-t.PD)*ZC.EH(t.OH)+t.PD,a=(t.JW-t.PD)*ZC.EP(t.OH)+t.PD;if(i.iX=t.iX+parseInt(n,10),i.iY=t.iY+parseInt(a,10),i.AI=t.AI+t.PD,t.D.length>0){e=[];for(var r=0,l=t.D.length;r<l;r++)if(null!==t.D[r]){for(var o=[],s=0;s<t.D[r].length;s++)o[s]=t.D[r][s];o[0]=t.D[r][0]+parseInt(n,10),o[1]=t.D[r][1]+parseInt(a,10),e.push(o)}else e.push(null)}i.D1=[t.D1[0]+n,t.D1[1]+a,t.D1[2]+n,t.D1[3]+a],i.D=e,i.paint()},A1I:function(){var e=this;return{lc:"-1"===e.B7?"rgba(255,255,255,0)":1===e.C6?e.B7:ZC.AP.A32(ZC.AP.GC(e.B7),e.C6),bc:"-1"===e.BW?"rgba(255,255,255,0)":1===e.O0?e.BW:ZC.AP.A32(ZC.AP.GC(e.BW),e.O0),bgc1:"-1"===e.A0?"rgba(255,255,255,0)":1===e.C6?e.A0:ZC.AP.A32(ZC.AP.GC(e.A0),e.C6),bgc2:"-1"===e.AE?"rgba(255,255,255,0)":1===e.C6?e.AE:ZC.AP.A32(ZC.AP.GC(e.AE),e.C6)}},YD:function(e){var t,i,n,a=this;switch(a.DU){case"circle":case"arc":case"pie":t=a.iX,i=a.iY,n=a.AI;break;default:t=a.D1[0]+(a.D1[2]-a.D1[0])/2,i=a.D1[1]+(a.D1[3]-a.D1[1])/2,n=ZC._a_(ZC.EH(a.N7)*(a.D1[2]-a.D1[0])/2+ZC.EP(a.N7)*(a.D1[3]-a.D1[1])/2)}ZC.P5(t)||(t=0),ZC.P5(i)||(i=0),ZC.P5(n)||(n=0);var r=a.VO,l=a.W5;if(ZC._a_(r)<=1&&(r=r*(a.D1[2]-a.D1[0])/2),ZC._a_(l)<=1&&(l=l*(a.D1[3]-a.D1[1])/2),t+=r,i+=l,"radial"===e)return{cx:t,cy:i,r:ZC._a_(n)};if("linear"===e){var o=n*ZC.EH(a.N7),s=n*ZC.EP(a.N7),c=t-o,h=i-s,C=t+o,u=i+s;return ZC._i_(h)===ZC._i_(u)&&ZC._a_(C-c)<5&&(u+=1),ZC._i_(c)===ZC._i_(C)&&ZC._a_(u-h)<5&&(C+=1),{x1:c,y1:h,x2:C,y2:u}}},RB:function(){var e,t,i,n,a,r,l,o=this;switch(ZC.cache.data[o.DA]?e=ZC.cache.data[o.DA]:((e=new Image).src=o.DA,ZC.cache.data[o.DA]=e),1!==o.KO&&(e._width_?(e.width=e._width_,e.height=e._height_):(e._width_=e.width,e._height_=e.height)),t=e.width*o.KO,i=e.height*o.KO,o.WN){case"x":t=o.I;break;case"y":i=o.F;break;case"xy":case"both":t=o.I,i=o.F}var s=o.TA.split(" "),c=s[0]||"",h=0,C=0;switch(c){case"":case"left":n=0,h=0;break;case"center":n=(o.I-t)/2,h=.5;break;case"right":n=o.I-t,h=1;break;default:-1!==c.indexOf("%")?(h=ZC._i_(c.replace(/[^0-9\-]/g,""))/100,n=(o.I-t)*h):(h=ZC._i_(c.replace(/[^0-9\-]/g,""))/o.I,n=ZC._i_(c.replace(/[^0-9\-]/g,"")))}r=n/o.I,"undefined"!=typeof o.KP?n+=o.iX+o.BM:n+=o.D1[0]+o.BM;var u=s[1]||"";switch(u){case"":case"top":a=0,C=0;break;case"middle":a=(o.F-i)/2,C=.5;break;case"bottom":a=o.F-i,C=1;break;default:-1!==u.indexOf("%")?(C=ZC._i_(u.replace(/[^0-9\-]/g,""))/100,a=(o.F-i)*C):(C=ZC._i_(u.replace(/[^0-9\-]/g,""))/o.F,a=ZC._i_(u.replace(/[^0-9\-]/g,"")))}if(l=a/o.F,"undefined"!=typeof o.KP?a+=o.iY+o.BH:a+=o.D1[1]+o.BH,"pie"===o.DU){var d=o.A9+o.B4+(o.BK-o.B4)*h,A=ZC.AQ.BN(o.iX,o.iY,o.CN+(o.AI-o.CN)*C,d);n=A[0]-e.width/2,a=A[1]-e.height/2}return o.E["bg-image-width"]=t,o.E["bg-image-height"]=i,{image:e,x:ZC._i_(n)+.5,y:ZC._i_(a)+.5,cx:ZC._f_(r),cy:ZC._f_(l),hPos:h,vPos:C}},ZH:function(e){for(var t=this,i=t.GR.split(/\s+|;/),n=t.HN.split(/\s+|;/),a=0,r=i.length;a<r;a++){var l=ZC.AP.GC(i[a],t);"object"!=typeof l&&(l=[l,t.C6]);var o=ZC.AP.A32(l[0],l[1]),s=ZC._f_(n[a]||"1");ZC.DS(s,0,1)||(s=1),e.addColorStop(s,o)}},A1V:function(){var e,t,i,n,a,r,l,o,s=this,c=s.Z.getContext("2d");c.save(),"poly"===s.DU||"line"===s.DU?(t=s.D1[0]+(s.D1[2]-s.D1[0])/2,i=s.D1[1]+(s.D1[3]-s.D1[1])/2):(t=s.iX,i=s.iY);var h=s.A1I(),C=h.lc,u=h.bc,d=h.bgc1,A=h.bgc2;if(d!==A||""!==s.GR&&""!==s.HN){var p=s.YD(s.NH);"radial"===s.NH?n=c.createRadialGradient(p.cx,p.cy,1,p.cx,p.cy,p.r):"linear"===s.NH&&(n=c.createLinearGradient(p.x1,p.y1,p.x2,p.y2)),""!==s.GR&&""!==s.HN?s.ZH(n):(n.addColorStop(0,d),n.addColorStop(1,A)),c.fillStyle=n}else""!==s.DA&&-1!==ZC.AV(["repeat","true",!0],s.M4)&&"-1"===s.A0&&"-1"===s.AE&&(d="rgba(255,255,255,0)"),c.fillStyle=d;switch(s.DU){case"custom":if((e=s.o.url)&&(ZC.cache.data[e]?a=ZC.cache.data[e]:((a=new Image).src=e,ZC.cache.data[e]=a),a.width=s.o.width?s.o.width:a.width,a.height=s.o.height?s.o.height:a.height,c.drawImage(a,s.iX-a.width/2+s.BM,s.iY-a.height/2+s.BH,a.width,a.height),0===d.indexOf("#")&&7===d.length)){for(var g=parseInt(d.substring(1,3),16),Z=parseInt(d.substring(3,5),16),f=parseInt(d.substring(5,7),16),_=c.getImageData(s.iX-a.width/2+s.BM,s.iY-a.height/2+s.BH,a.width,a.height),b=0;b<_.data.length;b+=4)_.data[b]=g|_.data[b],_.data[b+1]=Z|_.data[b+1],_.data[b+2]=f|_.data[b+2];c.putImageData(_,s.iX-a.width/2+s.BM,s.iY-a.height/2+s.BH)}break;case"plus":case"cross":case"line":case"ic_line":case"arc":c.strokeStyle=C,c.lineWidth=s.AZ;break;default:c.strokeStyle=u,c.lineWidth=s.AU}0!==s.A9&&(c.translate(t,i),isNaN(s.A9)||c.rotate(ZC.T1(s.A9)),c.translate(-t,-i));var m=-1===ZC.AV(["cross","plus","arc","line","ic_line"],s.DU);switch(isNaN(s.BM)||isNaN(s.BH)||0===s.BM&&0===s.BH||!m&&"arc"!==s.DU||c.translate(s.BM,s.BH),c.beginPath(),s.DU){case"circle":case"arc":c.setLineDash&&"circle"===s.DU&&(s.KX(s.AU),c.setLineDash(0===s.EX||0===s.G9?[]:[s.EX,s.G9])),c.arc(s.iX,s.iY,s.AI,ZC.T1(s.B4),ZC.T1(s.BK),!1);break;case"line":break;default:-1!==ZC.AV(["square","plus"],s.DU)&&(s.N4=!0),ZC.CR.contour(c,s,s.D),-1!==ZC.AV(["square","plus"],s.DU)&&(s.N4=!1)}if(c.globalCompositeOperation=s.A0Z,m)if(""!==s.DA&&-1===ZC.AV(ZC.IMG404,s.DA)){var v;c.fill(),c.save(),c.clip(),v=c.globalAlpha,c.globalAlpha=s.C6;var E=s.RB();switch(a=E.image,s.M4){case"repeat":case!0:case"true":r=s.D1[0]-(a.width-(s.D1[2]-s.D1[0]))/2,l=s.D1[1]-(a.height-(s.D1[3]-s.D1[1]))/2,c.translate(r,l),o=c.createPattern(a,"repeat"),c.fillStyle=o,c.fill(),c.translate(-r,-l);break;case"no-repeat":case!1:case"false":c.drawImage(a,E.x-s.BM,E.y-s.BH,s.E["bg-image-width"],s.E["bg-image-height"])}c.globalAlpha=v,c.restore()}else c.fill();switch(c.closePath(),c.beginPath(),s.DU){case"circle":case"arc":c.arc(s.iX,s.iY,s.AI,ZC.T1(s.B4),ZC.T1(s.BK),!1),("circle"===s.DU&&s.AU>0||"arc"===s.DU&&s.AZ>0)&&c.stroke(),c.closePath();break;case"plus":case"cross":case"line":case"ic_line":s.AZ>0&&(ZC.CR.setup(c,s),s.o.spline?(s.CZ=!1,s.QW=!0,ZC.CR.paint(c,s,ZC.CR.smooth(s.D,!1,s.o.direction||"h"))):ZC.CR.paint(c,s,s.D));break;default:if(s.AU>0){var D=s.B7,w=s.AZ;s.B7=s.BW,s.AZ=s.AU,s.KX(),ZC.CR.setup(c,s),ZC.CR.paint(c,s,s.D,!0),s.B7=D,s.AZ=w,s.KX()}c.closePath()}c.restore()},A2O:function(e){var t=this,i=e.info,n=i.image,a=!0;switch(t.M4){default:a=!0;break;case"no-repeat":case"false":case!1:a=!1}var r=t.DA;0===n.src.indexOf("data:")&&(r=n.src),n.width*=t.KO,n.height*=t.KO;var l=""===t.K?"pattern-"+ZC.SEQ++:t.K+"-pattern";ZC.Q.EU(l);var o=ZC.Q.F5("image","http://www.w3.org/2000/svg");o.setAttributeNS?o.setAttributeNS("http://www.w3.org/1999/xlink","href",r):o.setAttribute("src",r),ZC.Q.G3(o,{id:l+"-image",preserveAspectRatio:"none",width:t.E["bg-image-width"],height:t.E["bg-image-height"]});var s=n.width,c=n.height;if(!a){var h,C;s=c=1,t.I>0&&t.F>0?(h=t.I,C=t.F):(h=t.D1[2]-t.D1[0],C=t.D1[3]-t.D1[1]);var u=ZC._i_(h*i.cx),d=ZC._i_(C*i.cy);if("pie"===t.DU){s=t.H?t.H.I:t.A.I,c=t.H?t.H.F:t.A.F;var A=t.A9+t.B4+(t.BK-t.B4)*i.hPos,p=ZC.AQ.BN(t.iX,t.iY,t.CN+(t.AI-t.CN)*i.vPos,A);u=p[0]-n.width/2,d=p[1]-n.height/2}t.E["pattern-image-id"]=l+"-image",t.E["pattern-tx"]=u,t.E["pattern-ty"]=d,ZC.Q.G3(o,{transform:"translate("+u+","+d+")"})}var g=ZC.Q.F5("pattern","http://www.w3.org/2000/svg");ZC.Q.G3(g,{x:a?e.x:0,y:a?e.y:0,width:s,height:c,id:l,patternUnits:a||"pie"===t.DU?"userSpaceOnUse":"objectBoundingBox"}),t.H.KE.childNodes[0].appendChild(g),g.appendChild(o),t.E.imgfill="url(#"+l+")"},WZ:function(e){null!==e&&void 0!==e||(e=!1);var t,i,n=this;if(n.A0!==n.AE||""!==n.GR&&""!==n.HN){var a=""===n.K?"gradient-"+ZC.SEQ++:n.K+"-gradient";(n.U0||e&&!ZC.AK(a))&&(e=!1),ZC.A5.browser.msie&&9===ZC._i_(ZC.A5.browser.version)&&(e=!1),ZC.AK(a)&&!e&&ZC.Q.EU(a);var r=n.YD(n.NH);if("radial"===n.NH?(t=e?ZC.AK(a):ZC.Q.F5("radialGradient","http://www.w3.org/2000/svg"),ZC.Q.G3(t,{cx:ZC._i_(r.cx),cy:ZC._i_(r.cy),r:ZC._i_(r.r),fx:ZC._i_(r.cx),fy:ZC._i_(r.cy)})):"linear"===n.NH&&(t=e?ZC.AK(a):ZC.Q.F5("linearGradient","http://www.w3.org/2000/svg"),ZC.Q.G3(t,{x1:ZC._i_(r.x1),x2:ZC._i_(r.x2),y1:ZC._i_(r.y1),y2:ZC._i_(r.y2)})),!e){if(ZC.Q.G3(t,{id:a,gradientUnits:"userSpaceOnUse"}),n.H.KE.childNodes[0].appendChild(t),""!==n.GR&&""!==n.HN)for(var l=n.GR.split(/\s+|;/),o=n.HN.split(/\s+|;/),s=0,c=l.length;s<c;s++){var h=ZC.AP.GC(l[s],n);"object"!=typeof h&&(h=[h,n.C6]),l[s]=h[0];var C=o[s]||1;ZC.DS(C,0,1)||(C=1);var u=h[1];i=l[s],"-1"===l[s]&&(u=0,i="rgb(255,255,255)");var d=ZC.Q.F5("stop","http://www.w3.org/2000/svg");ZC.Q.G3(d,{offset:C,"stop-color":i,"stop-opacity":u}),t.appendChild(d)}else{var A=1,p=n.A0;"-1"===n.A0&&(A=0,p="rgb(255,255,255)");var g=ZC.Q.F5("stop","http://www.w3.org/2000/svg");ZC.Q.G3(g,{offset:0,"stop-color":p,"stop-opacity":A});var Z=1,f=n.AE;"-1"===n.AE&&(Z=0,f="rgb(255,255,255)");var _=ZC.Q.F5("stop","http://www.w3.org/2000/svg");ZC.Q.G3(_,{offset:1,"stop-color":f,"stop-opacity":Z}),t.appendChild(g),t.appendChild(_)}n.E.fill="url(#"+a+")"}}else"-1"!==n.A0&&(n.E.fill=n.A0)},A3G:function(){var e=this;if("object"==typeof e.E.imgfill&&"undefined"!=typeof e.H&&e.H){var t=e.A4Y()[1].split(",");if("circle"===e.DU)e.H.KE.appendChild(ZC.Q.X8({id:e.K+"_image-clip",cx:t[0],cy:t[1],r:t[2]})),e.E["clip-path"]=e.K+"_image-clip";else if(t.length>6){for(var i="",n=0,a=t.length;n<a;n+=2)i+=ZC._i_(t[n])+ZC._i_(e.BM)+","+(ZC._i_(t[n+1])+ZC._i_(e.BH))+" ";e.H.KE.appendChild(ZC.Q.X8({id:e.K+"_image-clip",path:i})),e.E["clip-path"]=e.K+"_image-clip"}}},VX:function(){var e,t,i,n,a,r,l=this,o=l.Z;if("poly"===l.DU||"line"===l.DU?(t=l.D1[0]+(l.D1[2]-l.D1[0])/2,i=l.D1[1]+(l.D1[3]-l.D1[1])/2):(t=l.iX,i=l.iY),l.E.cx=t,l.E.cy=i,l.E.fill=-1,""!==l.DA){var s=l.RB();l.A2O({info:s,x:t-s.image.width/2,y:i-s.image.height/2})}switch(l.VM&&l.A3G(),l.WZ(),l.DU){case"custom":if(e=l.o.url){var c,h;ZC.cache.data[e]?n=ZC.cache.data[e]:((n=new Image).src=e,ZC.cache.data[e]=n),(c=e.indexOf(".svg")>0&&e.indexOf("#")>=0)?(h=ZC.Q.F5("svg","http://www.w3.org/2000/svg"),ZC.Q.G3(h,{viewBox:"0 0 8 8",fill:l.E.fill}),r=ZC.Q.F5("use","http://www.w3.org/2000/svg")):r=ZC.Q.F5("image","http://www.w3.org/2000/svg"),r.setAttributeNS?r.setAttributeNS("http://www.w3.org/1999/xlink","href",e):r.setAttribute("src",e);var C=l.o.width?l.o.width:n.width,u=l.o.height?l.o.height:n.height;n.width=C,n.height=u,c?ZC.Q.G3(h,{id:l.K+"-image",x:l.iX-n.width/2+l.BM,y:l.iY-n.height/2+l.BH,width:n.width,height:n.height}):ZC.Q.G3(r,{id:l.K+"-image",x:l.iX-n.width/2+l.BM,y:l.iY-n.height/2+l.BH,width:n.width,height:n.height}),c?(h.appendChild(r),o.appendChild(h)):o.appendChild(r)}break;case"circle":if(!ZC.AK(l.K+"-circle")&&(a=ZC.Q.F5("circle","http://www.w3.org/2000/svg"),-1!==l.E.fill?ZC.Q.G3(a,{fill:l.E.fill,"fill-opacity":l.C6}):ZC.Q.G3(a,{fill:"none"}),l.DK&&""!==l.DK&&ZC.Q.G3(a,{"class":l.DK}),ZC.Q.G3(a,{id:l.K+"-circle",cx:l.iX+l.BM,cy:l.iY+l.BH,r:l.AI}),l.AU>0&&(ZC.Q.G3(a,{stroke:l.BW,"stroke-width":l.AU,"stroke-opacity":l.O0}),l.KX(l.AU),"solid"===l.GD||0===l.EX&&0===l.G9||ZC.Q.G3(a,{"stroke-dasharray":"dashdot"===l.GD?[l.EX,l.G9,l.AZ,l.G9].join(" "):[l.EX,l.G9].join(",")})),l.H&&l.H.G1?(l.H.G1[o.id]||(l.H.G1[o.id]=document.createDocumentFragment()),l.H.G1[o.id].appendChild(a)):o.appendChild(a),"undefined"!=typeof l.E.imgfill))if("string"==typeof l.E.imgfill)a=ZC.Q.F5("circle","http://www.w3.org/2000/svg"),ZC.Q.G3(a,{id:l.K+"-imgfill",fill:l.E.imgfill,"fill-opacity":l.C6,cx:l.iX+l.BM,cy:l.iY+l.BH,r:l.AI,"stroke-width":0}),l.H&&l.H.G1?l.H.G1[o.id].appendChild(a):o.appendChild(a);else{var d=l.E.imgfill;(r=ZC.Q.F5("image","http://www.w3.org/2000/svg")).setAttributeNS&&r.setAttributeNS("http://www.w3.org/1999/xlink","href",l.DA),l.E["clip-path"]&&ZC.Q.G3(r,{"clip-path":"url(#"+l.E["clip-path"]+(ZC.A5.browser.webkit?"-shape":"")+")"}),ZC.Q.G3(r,{id:l.K+"-imgfill",x:d[1],y:d[2],width:d[0].width,height:d[0].height}),o.appendChild(r)}break;case"plus":case"cross":case"line":case"ic_line":case"arc":l.AZ>0&&(ZC.CR.setup(o,l),l.o.spline?(l.CZ=!1,l.QW=!0,ZC.CR.paint(o,l,ZC.CR.smooth(l.D,!1,l.o.direction||"h"))):ZC.CR.paint(o,l,l.D));break;default:var A=l.B7,p=l.AZ;l.B7=l.BW,l.AZ=l.AU,l.KX(),ZC.CR.setup(o,l),ZC.CR.paint(o,l,l.D,!0,0),l.B7=A,l.AZ=p,l.KX()}},WY:function(e,t){null!==t&&void 0!==t||(t=!1);var i,n=this;if(n.A0!==n.AE||""!==n.GR&&""!==n.HN){var a=""===n.K?"gradient-"+ZC.SEQ++:n.K+"-gradient";if(t&&!ZC.AK(a)&&(t=!1),ZC.AK(a)&&!t&&ZC.A5(a).remove(),i=t?ZC.AK(a):ZC.Q.F5("zcv:fill"),t&&(e=ZC.A5("#"+a).attr("focusposition")),""!==n.GR&&""!==n.HN){for(var r=n.GR.split(/\s+|;/),l=n.HN.split(/\s+|;/),o="",s="",c="",h=0,C=r.length;h<C;h++){r[h]=ZC.AP.GC(r[h]);var u="-1"===r[h]?"rgb(255,255,255)":r[h],d=l[h]||1;ZC.DS(d,0,1)||(d=1);var A=ZC._i_(100*d);0===h?o=u:h===C-1?s=u:c+=A+"% "+ZC.AP.GC(u)+","}""!==c&&(c=c.substring(0,c.length-1)),"radial"===n.NH?ZC.Q.G3(i,{id:a,type:"gradientradial",focusposition:e,color:o,color2:s,colors:c}):"linear"===n.NH&&ZC.Q.G3(i,{id:a,type:"gradient",method:"sigma",angle:270-n.N7-n.A9,color:o,color2:s,colors:c})}else{var p=n.A0;"-1"===n.A0&&(p="rgb(255,255,255)");var g=n.AE;"-1"===n.AE&&(g="rgb(255,255,255)"),"radial"===n.NH?ZC.Q.G3(i,{id:a,type:"gradientradial",focusposition:e,color:g,color2:p}):"linear"===n.NH&&ZC.Q.G3(i,{id:a,type:"gradient",method:"sigma",angle:270-n.N7-n.A9,color:p,color2:g})}var Z="undefined"!=typeof n.E.opacity2?n.E.opacity2:n.C6;ZC.Q.G3(i,{opacity:n.C6,"o:opacity2":Z}),n.E.fill=i}else i=ZC.Q.F5("zcv:fill"),"-1"!==n.A0&&(ZC.Q.G3(i,{type:"solid",color:n.A0,opacity:n.C6}),n.E.fill=i)},VW:function(){var e,t,i,n,a,r,l=this,o=l.Z;"poly"===l.DU||"line"===l.DU?(t=l.D1[0]+(l.D1[2]-l.D1[0])/2,i=l.D1[1]+(l.D1[3]-l.D1[1])/2):(t=l.iX,i=l.iY),l.E.cx=t,l.E.cy=i,l.E.fill=-1;var s=-1===ZC.AV(["cross","plus","arc","line","ic_line"],l.DU),c=ZC.Q.F5("zcv:fill");if(""!==l.DA){var h=l.RB();switch(n=h.image,l.M4){default:c.type="tile",c.src=l.DA,ZC.Q.G3(c,{position:h.cx+","+h.cy,opacity:l.C6,"o:opacity2":l.C6}),l.E.imgfill=[c];break;case"no-repeat":case"false":case!1:l.E.imgfill=[n,h.x,h.y]}}l.WY("0,0");var C=ZC.Q.F5("zcv:stroke");switch(l.DU){case"custom":(e=l.o.url)&&(ZC.cache.data[e]?n=ZC.cache.data[e]:((n=new Image).src=e,ZC.cache.data[e]=n),(r=ZC.Q.F5("img")).id=l.K+"-img",r.src=e,r.style.position="absolute",1!==l.KO&&(r.width*=l.KO,r.height*=l.KO,r.style.width=r.width+"px",r.style.height=r.height+"px"),r.style.left=l.iX-n.width/2+l.BM+"px",r.style.top=l.iY-n.height/2+l.BH+"px",o.appendChild(r));break;case"plus":case"cross":case"line":case"ic_line":case"arc":C.weight=l.AZ+"px",C.color=l.B7;break;default:C.weight=l.AU+"px",C.color=l.BW}switch(C.opacity=l.O0,l.GD){case"solid":C.dashstyle="solid";break;case"dotted":C.dashstyle="dot";break;case"dashed":C.dashstyle="dash"}switch(-1===ZC.AV(["plus","cross","line","ic_line"],l.DU)&&(l.E.stroke=C),l.DU){case"circle":case"arc":if(!ZC.AK(l.K+"-circle")&&((a=ZC.Q.F5("circle"===l.DU?"zcv:oval":"zcv:arc")).id=l.K+"-circle",a.style.position="absolute",-1!==l.E.fill&&s?a.appendChild(l.E.fill):a.filled=!1,l.AU>0||l.AZ>0?a.appendChild(C):a.stroked=!1,a.style.left=l.iX+l.BM-l.AI+"px",a.style.top=l.iY+l.BH-l.AI+"px",a.style.width=2*l.AI+"px",a.style.height=2*l.AI+"px","arc"===l.DU&&ZC.Q.G3(a,{startangle:l.BK+90,endangle:l.B4+90}),o.appendChild(a),s&&"undefined"!=typeof l.E.imgfill)){var u=l.E.imgfill;1===u.length?((a=ZC.Q.F5("zcv:oval")).id=l.K+"-imgfill",a.style.position="absolute",o.appendChild(a),a.appendChild(u[0]),a.style.left=l.iX+l.BM-l.AI+"px",a.style.top=l.iY+l.BH-l.AI+"px",a.style.width=2*l.AI+"px",a.style.height=2*l.AI+"px",a.stroked=!1,"arc"===l.DU&&ZC.Q.G3(a,{startangle:l.BK+90,endangle:l.B4+90})):3===u.length&&((r=ZC.Q.F5("img")).id=l.K+"-img",r.src=l.DA,r.style.position="absolute",r.style.left=u[1]+"px",r.style.top=u[2]+"px",1!==l.KO&&(r.width*=l.KO,r.height*=l.KO,r.style.width=r.width+"px",r.style.height=r.height+"px"),o.appendChild(r))}break;case"plus":case"cross":case"line":case"ic_line":l.AZ>0&&(ZC.CR.setup(o,l),l.o.spline?(l.CZ=!1,l.QW=!0,ZC.CR.paint(o,l,ZC.CR.smooth(l.D,!1,l.o.direction||"h"))):ZC.CR.paint(o,l,l.D));break;default:var d=l.B7,A=l.AZ;l.B7=l.BW,l.AZ=l.AU,l.KX(),ZC.CR.setup(o,l),ZC.CR.paint(o,l,l.D,!0,0),l.B7=d,l.AZ=A,l.KX()}}};ZC.DT=ZC.D0.CA(DT);var HL={$i:function(e){this.b(e);var t=this;t.DU="box",t.I=0,t.F=0,t.A8G="",t.E8=-1,t.E9=-1,t.DR=-1,t.DY=-1,t.F6=0,t.FS=0,t.F2=0,t.FD=0,t.A7G=!1,t.KP=!1,t.EM="bottom",t.EV=0,t.M3=0,t.H9=8,t.G8=8,t.XT=[1,1],t.DM=null,t.OL=null,t.PU=!1,t.N4=!0,t.Q1="",t.OJ="",t.NP="",t.P6="",t.WT="tl",t.FC=!1},getPMap:function(){var e=this.b();return this.addPMap(e,"width,height,borderRadiusTopLeft,borderRadiusTopRight,borderRadiusBottomRight,borderRadiusBottomLeft,callout,calloutType,calloutPosition,calloutHook,calloutWidth,calloutHeight,calloutOffset,calloutExtension,position,borderTop,borderRight,borderBottom,borderLeft,rectShortcut","I,F,F6,FS,F2,FD,KP,EM,DM,H9,G8,EV,M3,A8G,Q1,OJ,NP,P6,FC"),e},build:function(){},wh_:function(e,t,i){var n=this;if(t=t||"w",ZC._f_(e)+""!=e+"")return-1!==(e+="").indexOf("%")?n.wh_(ZC._f_(e.replace("%",""))/100,t,!0):-1!==e.indexOf("px")?n.wh_(ZC._f_(e.replace("px","")),t):n.wh_(ZC._f_(e),t);var a="undefined"!=typeof n.E["p-width"]?n.E["p-width"]:n.A.I,r="undefined"!=typeof n.E["p-height"]?n.E["p-height"]:n.A.F;return(e=ZC._a_(e))>1&&!i?ZC._i_(e):e<=1||i?"w"===t?ZC._i_(a*e):ZC._i_(r*e):void 0},m_:function(e,t,i,n,a){var r,l,o=this;if(i=i||0,n=n||0,t=t||"all",a=a||"n","all"===t){var s=String(e).split(/\s+|;|,/);return 1===s.length?[o.m_(s[0],"tb",i,n,a),o.m_(s[0],"lr",i,n,a),o.m_(s[0],"tb",i,n,a),o.m_(s[0],"lr",i,n,a)]:2===s.length?[o.m_(s[0],"tb",i,n,a),o.m_(s[1],"lr",i,n,a),o.m_(s[0],"tb",i,n,a),o.m_(s[1],"lr",i,n,a)]:3===s.length?[o.m_(s[0],"tb",i,n,a),o.m_(s[1],"lr",i,n,a),o.m_(s[2],"tb",i,n,a),o.m_(s[1],"lr",i,n,a)]:[o.m_(s[0],"tb",i,n,a),o.m_(s[1],"lr",i,n,a),o.m_(s[2],"tb",i,n,a),o.m_(s[3],"lr",i,n,a)]}return e+""=="auto"?-2:e+""=="dynamic"&&"y"===a?"dynamic":ZC._f_(e)+""!=e+""?-1!==(e+="").indexOf("%")?o.m_(ZC._f_(e.replace("%",""))/100,t):-1!==e.indexOf("px")?o.m_(ZC._f_(e.replace("px","")),t):o.m_(ZC._f_(e),t):((o.A||"undefined"!=typeof o.E["p-width"])&&(r="undefined"!=typeof o.E["p-width"]?o.E["p-width"]:o.A.I),(o.A||"undefined"!=typeof o.E["p-height"])&&(l="undefined"!=typeof o.E["p-height"]?o.E["p-height"]:o.A.F),(e=ZC._a_(e))>=1?ZC._i_(e):e<1?"lr"===t?ZC._i_((o.A?r:i)*e):ZC._i_((o.A?l:n)*e):void 0)},copy:function(e){this.b(e);for(var t="I,F,E8,DR,DY,E9,F6,FS,F2,FD,KP,EM,DM,XT,H9,G8,EV,M3,A8G,Q1,OJ,NP,P6,FC".split(","),i=0,n=t.length;i<n;i++)"undefined"!=typeof e[t[i]]&&(this[t[i]]=e[t[i]])},locate:function(e){var t,i,n,a,r,l=this;if(2!==(e=e||1))if(l.U0)l.assign_a([["x","iX"],["y","iY"],["width","I"],["height","F"]]);else{var o="undefined"!=typeof l.E["p-x"]?l.E["p-x"]:l.A.iX,s="undefined"!=typeof l.E["p-y"]?l.E["p-y"]:l.A.iY,c="undefined"!=typeof l.E["p-width"]?l.E["p-width"]:l.A.I,h="undefined"!=typeof l.E["p-height"]?l.E["p-height"]:l.A.F;if(!l.PU){var C=0,u=0,d=0,A=0;if(null!==ZC._n_(l.o.margin)){var p=""+l.o.margin;if(-1!==p.indexOf("dynamic")){var g=l.m_(p,"all",0,0,"y");"dynamic"===g[0]&&(l.E["d-margin-top"]=l.E["d-margin"]=!0),"dynamic"===g[1]&&(l.E["d-margin-right"]=l.E["d-margin"]=!0),"dynamic"===g[2]&&(l.E["d-margin-bottom"]=l.E["d-margin"]=!0),"dynamic"===g[3]&&(l.E["d-margin-left"]=l.E["d-margin"]=!0),l.o.margin=p.replace(/dynamic/g,"20")}}"dynamic"===l.o.margin&&(l.E["d-margin"]=l.E["d-margin-top"]=l.E["d-margin-right"]=l.E["d-margin-bottom"]=l.E["d-margin-left"]=!0,l.o.margin=null),"undefined"==typeof l.E["force-margins"]||null!==ZC._n_(l.o["adjust-layout"])&&ZC._b_(l.o["adjust-layout"])||(null!==ZC._n_(l.o["margin-top"])&&null===ZC._n_(l.o["margin-bottom"])&&(l.o["margin-bottom"]="auto"),null!==ZC._n_(l.o["margin-bottom"])&&null===ZC._n_(l.o["margin-top"])&&(l.o["margin-top"]="auto"),null!==ZC._n_(l.o["margin-left"])&&null===ZC._n_(l.o["margin-right"])&&(l.o["margin-right"]="auto"),null!==ZC._n_(l.o["margin-right"])&&null===ZC._n_(l.o["margin-left"])&&(l.o["margin-left"]="auto"));for(var Z=["margin-top","margin-right","margin-bottom","margin-left"],f=0,_=Z.length;f<_;f++)"dynamic"===l.o[Z[f]]&&(l.E["d-"+Z[f]]=l.E["d-margin"]=!0,l.o[Z[f]]=null);null!==(t=ZC._n_(l.o.margin))&&(i=l.m_(t,"all"),null===ZC._n_(l.o["margin-top"])&&(C=i[0]),null===ZC._n_(l.o["margin-right"])&&(u=i[1]),null===ZC._n_(l.o["margin-bottom"])&&(d=i[2]),null===ZC._n_(l.o["margin-left"])&&(A=i[3])),null!==(t=ZC._n_(l.o["margin-top"]))&&(C=i=l.m_(t,"tb")),null!==(t=ZC._n_(l.o["margin-right"]))&&(u=i=l.m_(t,"lr")),null!==(t=ZC._n_(l.o["margin-bottom"]))&&(d=i=l.m_(t,"tb")),null!==(t=ZC._n_(l.o["margin-left"]))&&(A=i=l.m_(t,"lr"));var b,m=[C,u,d,A];if(null!==ZC._n_(l.o.x)&&(l.iX=l.xy_(l.o.x,"x")),null!==ZC._n_(l.o.y)&&(l.iY=l.xy_(l.o.y,"y")),null!==(t=ZC._n_(l.o.width))){var v=ZC._p_(t);b=-1!==(""+t).indexOf("%"),l.I=v>1&&!b?ZC._i_(v):-2===A&&-2===u?ZC._i_(c*v):-2===A&&-2!==u?ZC._i_((c-u)*v):-2!==A&&-2===u?ZC._i_((c-A)*v):ZC._i_((c-A-u)*v),-1!==l.iX?(l.DY=l.iX-o,l.E9=o+c-l.DY-l.I):-2===A&&-2===u?(l.DY=l.E9=(c-l.I)/2,l.iX=o+l.DY):-2===A&&-2!==u?(l.E9=u,l.DY=c-l.E9-l.I,l.iX=o+l.DY):(l.DY=A,l.iX=o+l.DY,l instanceof ZC.DN?l.E9=u:l.E9=c-l.DY-l.I)}else-1!==l.iX?(l.DY=l.iX-o,l.E9=-2===u?0:u,l.I=c-l.DY-l.E9):-2===A&&-2===u?(l.DY=l.E9=0,l.iX=o+l.DY,l.I=c-l.DY-l.E9):-2===A&&-2!==u?(l.E9=u,l.DY=0,l.iX=o+l.DY,l.I=c-l.DY-l.E9):-2!==A&&-2===u?(l.DY=A,l instanceof ZC.DN?l.E9=u:l.E9=0,l.iX=o+l.DY,l.I=c-l.DY-l.E9):(l.DY=A,l.E9=u,l.iX=o+l.DY,l.I=c-l.DY-l.E9);if(null!==(t=ZC._n_(l.o.height))){var E=ZC._p_(t);b=-1!==(""+t).indexOf("%"),l.F=E>1&&!b?ZC._i_(E):-2===C&&-2===d?ZC._i_(h*E):-2===C&&-2!==d?ZC._i_((h-d)*E):-2!==C&&-2===d?ZC._i_((h-C)*E):ZC._i_((h-C-d)*E),-1!==l.iY?(l.E8=l.iY-s,l.DR=s+h-l.E8-l.F):-2===C&&-2===d?(l.E8=l.DR=(h-l.F)/2,l.iY=s+l.E8):-2===C&&-2!==d?(l.DR=d,l.E8=h-l.DR-l.F,l.iY=s+l.E8):(l.E8=C,l.iY=s+l.E8,l instanceof ZC.DN?l.DR=d:l.DR=h-l.E8-l.F)}else-1!==l.iY?(l.E8=l.iY-s,l.DR=-2===d?0:d,l.F=h-l.E8-l.DR):-2===C&&-2===C?(l.E8=l.E8=0,l.iY=s+l.E8,l.F=h-l.E8-l.DR):-2===C&&-2!==d?(l.DR=d,l.E8=0,l.iY=s+l.E8,l.F=h-l.E8-l.DR):-2===C&&-2!==d?(l.E8=C,l instanceof ZC.DN?l.DR=d:l.DR=0,l.iY=s+l.E8,l.F=h-l.E8-l.DR):(l.E8=C,l.DR=d,l.iY=s+l.E8,l.F=h-l.E8-l.DR);if(null!==(t=ZC._n_(l.o.position))){if(l.A&&"undefined"!=typeof l.A.iX&&"undefined"!=typeof l.A.iY&&"undefined"!=typeof l.A.I&&"undefined"!=typeof l.A.F){switch(n=0,a=0,(r=String(t).split(/\s+/))[0]){case"left":n=0;break;case"right":n=1;break;case"center":n=.5;break;default:(n=ZC.II(r[0]))>1&&(n/=l.A.I)}switch(r[1]){case"top":a=0;break;case"bottom":a=1;break;case"middle":a=.5;break;default:(a=ZC.II(r[1]))>1&&(a/=l.A.F)}}l.E["position-info"]=[n,a],l.iX=l.A.iX+ZC._i_(n*(l.A.I-l.I-m[1]-m[3]))+m[3],l.iY=l.A.iY+ZC._i_(a*(l.A.F-l.F-m[0]-m[2]))+m[0]}l.D1=[l.iX,l.iY,l.iX+l.I,l.iY+l.F]}}},parse:function(){this.b();var e,t=this;if(!t.o.tween){if(t.assign_a([["anchor","WT"],["rect-shortcut","FC","b"],["center-ref","A7G","b"],["callout","KP","b"],["callout-type","ACR"],["callout-position","EM"],["callout-hook","DM"],["callout-ratio","XT"],["callout-width","H9","i"],["callout-height","G8","i"],["callout-offset","EV","i"],["callout-extension","M3","i"],["border-top","Q1"],["border-right","OJ"],["border-bottom","NP"],["border-left","P6"]]),null!==(e=ZC._n_(t.o["border-radius"]))){var i=String(e).split(/\s+|;|,/);2===i.length?(t.F6=t.FS=ZC._i_(i[0]),t.F2=t.FD=ZC._i_(i[1])):4===i.length?(t.F6=ZC._i_(i[0]),t.FS=ZC._i_(i[1]),t.F2=ZC._i_(i[2]),t.FD=ZC._i_(i[3])):t.F6=t.FS=t.F2=t.FD=ZC._i_(i[0])}null!==ZC._n_(t.o["callout-tip"])&&(t.OL=new ZC.DT(t.A)),t.assign_a([["border-radius-top-left","F6","i"],["border-radius-top-right","FS","i"],["border-radius-bottom-right","F2","i"],["border-radius-bottom-left","FD","i"]])}},WO:function(e){var t=e.split(/\s/);return t[0]=ZC._i_(t[0]),t[2]=ZC.AP.GC(t[2]),t},paint:function(){var e=this;if(null!==e.DM&&!(e.DM instanceof Array)&&"zcgraph"===e.A.OB){var t=e.A.UY(e.DM);e.DM=[t[0],t[1]],e.DM[0]-=e.BM,e.DM[1]-=e.BH}if(e.A7G&&(e.iX-=e.I/2,e.iY-=e.F/2),"-1"!==e.BW&&0!==e.AU||e.Q1+e.OJ+e.NP+e.P6!==""||"-1"!==e.A0||"-1"!==e.AE||""!==e.DA||""!==e.GR||""!==e.HN){var i,n=e.H.AA;e.M8&&e.C7&&e.A97();var a={x:"iX",y:"iY",width:"I",height:"F"};if(e.o["bottom-state"]&&!e.Y6&&!e.bIsBottom&&!e.VN){var r=new ZC.HL(e.A);for(i in r.copy(e),r.bIsBottom=!0,r.M8=!1,r.Z=e.Z,r.WT=e.WT,r.append({x:e.iX-e.A.iX,y:e.iY-e.A.iY,width:e.I,height:e.F}),r.append(e.o["bottom-state"]),r.K=e.K+"-bottom",r.parse(),r.setAnchor(),!1,a)null===ZC._n_(r.o[i])||-1===(""+r.o[i]).indexOf("+")&&-1===(""+r.o[i]).indexOf("-")||(r[a[i]]=e[a[i]]+ZC._i_(r.o[i]),!0);r.paint()}if(e.Q1+e.OJ+e.NP+e.P6===""){switch(n){case"canvas":e.A1V();break;case"svg":e.VX();break;case"vml":e.VW()}if(e.KP&&e.OL){var l,o;if(e.DM&&2===e.DM.length?(l=e.DM[0],o=e.DM[1]):e.E.cp&&(l=e.E.cp[0],o=e.E.cp[1]),e.OL.Z=e.OL.C7=e.Z,e.OL.copy(e),e.OL.append(e.o["callout-tip"]),e.OL.K=e.K+"-callout-tip",e.OL.o.x=l,e.OL.o.y=o,e.E.cm){var s=e.E.cm[0],c=e.E.cm[1],h=Math.atan2(ZC._i_(c)-ZC._i_(o),ZC._i_(s)-ZC._i_(l));isNaN(h)&&(h=0),null===ZC._n_(e.OL.o.angle)&&(e.OL.o.angle=ZC.TK(h))}e.OL.parse(),e.OL.paint()}}else{var C=e.AU,u=e.BW,d=e.GD;switch(e.AU=0,n){case"canvas":e.A1V();break;case"svg":e.VX();break;case"vml":e.VW()}e.AU=C;var A=e.A0,p=e.AE;e.A0=e.AE="-1";for(var g,Z=["top","right","bottom","left"],f=["Q1","OJ","NP","P6"],_=0;_<Z.length;_++)if(""!==(g=e[f[_]])&&"none"!==g){var b=e.WO(g);switch(e.AU=b[0],e.GD=b[1],e.BW=b[2],n){case"canvas":e.A1V(Z[_]);break;case"svg":e.VX(Z[_]);break;case"vml":e.VW(Z[_])}e.AU=C,e.BW=u,e.GD=d}e.A0=A,e.AE=p}if(e.o["top-state"]&&!e.Y6&&!e.VN&&!e.bIsBottom){var m=new ZC.HL(e.A);for(i in m.copy(e),m.VN=!0,m.M8=!1,m.Z=e.Z,m.WT=e.WT,m.append({x:e.iX-e.A.iX,y:e.iY-e.A.iY,width:e.I,height:e.F}),m.append(e.o["top-state"]),m.K=e.K+"-top",m.parse(),m.setAnchor(),!1,a)null===ZC._n_(m.o[i])||-1===(""+m.o[i]).indexOf("+")&&-1===(""+m.o[i]).indexOf("-")||(m[a[i]]=e[a[i]]+ZC._i_(m.o[i]),!0);m.paint()}}},setAnchor:function(){var e=this;switch(e.WT){case"tl":break;case"tr":e.iX-=e.I;break;case"bl":e.iY-=e.F;break;case"br":e.iX-=e.I,e.iY-=e.F;break;case"c":e.iX-=e.I/2,e.iY-=e.F/2;break;case"t":e.iX-=e.I/2;break;case"r":e.iX-=e.I,e.iY-=e.F/2;break;case"b":e.iX-=e.I/2,e.iY-=e.F;break;case"l":e.iY-=e.F/2}},A97:function(){var e=this,t=new ZC.HL(e.A);t.K=e.K+"-sh",t.copy(e),t.Z=e.C7,t.M8=!1,t.Y6=!0,t.Q1=t.OJ=t.NP=t.P6="",t.A0=t.AE=t.RT,t.GR=t.HN="",t.DA="",t.GD="solid",t.BW=t.RT,t.AZ=0;var i=e.JW*ZC.EH(e.OH),n=e.JW*ZC.EP(e.OH);t.I=e.I+("vml"===e.H.AA?0:.5)-ZC.EH(e.OH)*e.PD/2,t.F=e.F+("vml"===e.H.AA?0:.5)-ZC.EP(e.OH)*e.PD/2,t.O0=t.C6=t.T5*e.C6,t.K=e.K+"-sh",t.iX=e.iX+ZC._i_(i),t.iY=e.iY+ZC._i_(n),t.paint()},YD:function(e){var t,i=this,n=i.iX,a=i.iY,r=n+i.I/2,l=a+i.F/2,o=i.VO,s=i.W5;if(ZC._a_(o)<=1&&(o=o*i.I/2),ZC._a_(s)<=1&&(s=s*i.F/2),r+=o,l+=s,"radial"===e){var c=ZC._i_((i.I+i.F)/2),h=ZC.CY(i.I,i.F);return t=h<c/4?(h+c)/2:h,{cx:r,cy:l,r:ZC._a_(t)}}if("linear"===e){var C=(t=i.I>=i.F?ZC._a_(ZC.EP(i.N7))>.5?i.F/2:i.I/2:ZC._a_(ZC.EH(i.N7))>.5?i.I/2:i.F/2)*ZC.EH(i.N7),u=t*ZC.EP(i.N7);return{x1:r-C,y1:l-u,x2:r+C,y2:l+u}}},W0:function(e){var t,i=this;void 0===e&&(e="all");var n,a,r=i.iX,l=i.iY;i.D=[],n=a=i.AU/2;var o=1;switch(i.H.AA){case"vml":o=2,i.AU%2==1&&(n=ZC._i_((i.AU-1)/2),a=ZC._i_((i.AU+1)/2))}var s=null,c=ZC._x_(r+n,2),h=ZC._x_(r-a,2),C=ZC._x_(l+n,2),u=ZC._x_(l-a,2),d=i.DM&&2===i.DM.length,A=ZC._i_(i.EV*(i.I-i.H9)/100),p=ZC._i_(i.EV*(i.F-i.G8)/100),g=0!==i.F6||0!==i.FS||0!==i.F2||0!==i.FD,Z=i.XT[0],f=i.XT[1];switch(i.EM){case"top":i.E.cm=[i.iX+i.I/2+A,i.iY];break;case"bottom":i.E.cm=[i.iX+i.I/2+A,i.iY+i.F];break;case"left":i.E.cm=[i.iX,i.iY+i.F/2+p];break;case"right":i.E.cm=[i.iX+i.I,i.iY+i.F/2+p]}if(g){var _,b=ZC.CY(i.I/2,i.F/2);"top"!==e&&"all"!==e||(0!==i.F6?(_=i.I/2>=i.F6&&i.F/2>=i.F6?ZC._a_(i.F6):b,i.D.push([c,C+_]),i.F6>0&&i.D.push([c,C,c+o*_,C]),i.D.push([c+_,C])):i.D.push([c,C]),i.KP&&"top"===i.EM&&(i.D.push([c+i.I/2-Z*i.H9/2-i.AU/2+A,C]),d?i.D.push([i.DM[0],i.DM[1]]):(s=[c+i.I/2-i.AU/2+A,C-i.G8],i.D.push(s)),i.M3>0&&(t=i.D[i.D.length-1],i.D.push([t[0],t[1]-i.M3*(i.G8>0?1:-1)]),i.D.push([t[0],t[1]])),i.D.push([c+i.I/2-i.AU/2+f*i.H9/2+A,C])),"top"===e&&(0!==i.FS?(_=i.I/2>=i.FS&&i.F/2>=i.FS?ZC._a_(i.FS):b,i.D.push([h+i.I-_,C])):i.D.push([h+i.I,C]))),"right"!==e&&"all"!==e||(0!==i.FS?(_=i.I/2>=i.FS&&i.F/2>=i.FS?ZC._a_(i.FS):b,i.D.push([h+i.I-_,C]),i.FS>0?i.D.push([h+i.I,C,h+i.I,C+o*_]):i.D.push([h+i.I,C+_])):i.D.push([h+i.I,C]),i.KP&&"right"===i.EM&&(i.D.push([h+i.I,C+i.F/2-Z*i.G8/2-i.AU/2+p]),d?i.D.push([i.DM[0],i.DM[1]]):(s=[h+i.I+i.H9,C+i.F/2-i.AU/2+p],i.D.push(s)),i.D.push([h+i.I,C+i.F/2+f*i.G8/2-i.AU/2+p])),"right"===e&&(0!==i.F2?(_=i.I/2>=i.F2&&i.F/2>=i.F2?ZC._a_(i.F2):b,i.D.push([h+i.I,u+i.F-_])):i.D.push([h+i.I,u+i.F]))),"bottom"!==e&&"all"!==e||(0!==i.F2?(_=i.I/2>=i.F2&&i.F/2>=i.F2?ZC._a_(i.F2):b,i.D.push([h+i.I,u+i.F-_]),i.F2>0?i.D.push([h+i.I,u+i.F,h+i.I-o*_,u+i.F]):i.D.push([h+i.I-_,u+i.F])):i.D.push([h+i.I,u+i.F]),i.KP&&"bottom"===i.EM&&(i.D.push([h+i.I/2+Z*i.H9/2+i.AU/2+A,u+i.F]),d?i.D.push([i.DM[0],i.DM[1]]):(s=[h+i.I/2+i.AU/2+A,u+i.F+i.G8],i.D.push(s)),i.M3>0&&(t=i.D[i.D.length-1],i.D.push([t[0],t[1]+i.M3*(i.G8>0?1:-1)]),i.D.push([t[0],t[1]])),i.D.push([h+i.I/2-f*i.H9/2+i.AU/2+A,u+i.F])),"bottom"===e&&(0!==i.FD?(_=i.I/2>=i.FD&&i.F/2>=i.FD?ZC._a_(i.FD):b,i.D.push([c+_,u+i.F])):i.D.push([c,u+i.F]))),"left"!==e&&"all"!==e||(0!==i.FD?(_=i.I/2>=i.FD&&i.F/2>=i.FD?ZC._a_(i.FD):b,i.D.push([c+_,u+i.F]),i.FD>0?i.D.push([c,u+i.F,c,u+i.F-o*_]):i.D.push([c,u+i.F-_])):i.D.push([c,u+i.F]),i.KP&&"left"===i.EM&&(i.D.push([c,u+i.F/2+Z*i.G8/2+i.AU/2+p]),d?i.D.push([i.DM[0],i.DM[1]]):(s=[c-i.H9,u+i.F/2+i.AU/2+p],i.D.push(s)),i.D.push([c,u+i.F/2-f*i.G8/2+i.AU/2+p])),0!==i.F6?(_=i.I/2>=i.F6&&i.F/2>=i.F6?ZC._a_(i.F6):b,i.D.push([c,C+_])):(i.D.push([c,C]),i.D.push([c+.1,C])))}else"top"!==e&&"all"!==e||("top"===e?i.D.push([c+.5,C+.5]):i.D.push([c,C]),i.KP&&"top"===i.EM&&(i.D.push([c+i.I/2-Z*i.H9/2-i.AU/2+A,C]),d?i.D.push([i.DM[0],i.DM[1]]):(s=[c+i.I/2-i.AU/2+A,C-i.G8],i.D.push(s)),i.M3>0&&(t=i.D[i.D.length-1],i.D.push([t[0],t[1]-i.M3*(i.G8>0?1:-1)]),i.D.push([t[0],t[1]])),i.D.push([c+i.I/2+f*i.H9/2-i.AU/2+A,C])),"top"===e&&i.D.push([h+i.I+.5,C+.5])),"right"!==e&&"all"!==e||("right"===e?i.D.push([h+i.I+.5,C+.5]):i.D.push([h+i.I,C]),i.KP&&"right"===i.EM&&(i.D.push([h+i.I,C+i.F/2-i.AU/2-Z*i.G8/2+p]),d?i.D.push([i.DM[0],i.DM[1]]):(s=[h+i.I+i.H9,C+i.F/2-i.AU/2+p],i.D.push(s)),i.D.push([h+i.I,C+i.F/2-i.AU/2+f*i.G8/2+p])),"right"===e&&i.D.push([h+i.I+.5,u+i.F+.5])),"bottom"!==e&&"all"!==e||("bottom"===e?i.D.push([h+i.I+.5,u+i.F+.5]):i.D.push([h+i.I,u+i.F]),i.KP&&"bottom"===i.EM&&(i.D.push([h+i.I/2+Z*i.H9/2+i.AU/2+A,u+i.F]),d?i.D.push([i.DM[0],i.DM[1]]):(s=[h+i.I/2+i.AU/2+A,u+i.F+i.G8],i.D.push(s)),i.M3>0&&(t=i.D[i.D.length-1],i.D.push([t[0],t[1]+i.M3*(i.G8>0?1:-1)]),i.D.push([t[0],t[1]])),i.D.push([h+i.I/2-f*i.H9/2+i.AU/2+A,u+i.F])),"bottom"===e&&i.D.push([c+.5,u+i.F+.5])),"left"!==e&&"all"!==e||("left"===e?i.D.push([c+.5,u+i.F+.5]):i.D.push([c,u+i.F]),i.KP&&"left"===i.EM&&(i.D.push([c,u+i.F/2+i.AU/2+Z*i.G8/2+p]),d?i.D.push([i.DM[0],i.DM[1]]):(s=[c-i.H9,u+i.F/2+i.AU/2+p],i.D.push(s)),i.D.push([c,u+i.F/2+i.AU/2-f*i.G8/2+p])),"left"===e?i.D.push([c+.5,C+.5]):(i.D.push([c,C]),i.D.push([c+.1,C])));s&&(i.E.cp=s)},A1V:function(e){e=e||"all";var t,i,n,a=this,r=a.Z.getContext("2d");r.save(),r.globalCompositeOperation=a.A0Z;var l=a.iX,o=a.iY,s=a.A1I(),c=s.bc,h=s.bgc1,C=s.bgc2;if("all"===e)if(h!==C||""!==a.GR&&""!==a.HN){var u=a.YD(a.NH);"radial"===a.NH?t=r.createRadialGradient(u.cx,u.cy,1,u.cx,u.cy,u.r):"linear"===a.NH&&(u.x1=isNaN(u.x1)?0:u.x1,u.x2=isNaN(u.x2)?0:u.x2,u.y1=isNaN(u.y1)?0:u.y1,u.y2=isNaN(u.y2)?0:u.y2,t=r.createLinearGradient(u.x1,u.y1,u.x2,u.y2)),""!==a.GR&&""!==a.HN?a.ZH(t):(t.addColorStop(0,h),t.addColorStop(1,C)),r.fillStyle=t}else""!==a.DA&&-1!==ZC.AV(["repeat","true",!0],a.M4)&&"-1"===a.A0&&"-1"===a.AE&&(h="rgba(255,255,255,0)"),r.fillStyle=h;r.strokeStyle=c,r.lineWidth=a.AU,r.translate(a.BM,a.BH),0!==a.A9&&(r.translate(l+a.I/2,o+a.F/2),r.rotate(ZC.T1(a.A9)),r.translate(-(l+a.I/2),-(o+a.F/2))),r.beginPath(),a.W0(e);var d=a.F6+a.FS+a.F2+a.FD!==0;n=a.AZ,a.AZ=a.AU;var A=a.GD;if(a.GD="",a.KX(),ZC.CR.contour(r,a,a.D),a.AZ=n,a.GD=A,a.KX(),"all"===e)if(""!==a.DA&&-1===ZC.AV(ZC.IMG404,a.DA)){r.fill(),r.save(),r.clip();var p=r.globalAlpha;r.globalAlpha=a.C6;var g=a.RB(),Z=g.image;switch(a.M4){default:r.translate(a.iX,a.iY),i=r.createPattern(Z,"repeat"),r.fillStyle=i,r.fill(),r.translate(-g.x,-g.y);break;case"no-repeat":case"false":case!1:r.drawImage(Z,g.x-a.BM,g.y-a.BH,a.E["bg-image-width"],a.E["bg-image-height"])}r.globalAlpha=p,r.restore()}else r.fill();if(a.AU>0){var f=a.B7;n=a.AZ,a.B7=a.BW,a.AZ=a.AU,a.KX(),ZC.CR.setup(r,a),a.T7=d?"round":"square",a.EX+a.G9>0&&(a.T7="butt"),a.ZZ=d?"round":"miter",a.E["skip-top"]=!0,a.E.border=e,ZC.CR.paint(r,a,a.D,!0),a.B7=f,a.AZ=n,a.KX()}r.closePath(),r.restore()},VX:function(e){e=e||"all";var t=this,i=t.Z;t.E.fill=-1;var n=!1;if("all"===e){if(""!==t.DA&&-1===ZC.AV(ZC.IMG404,t.DA)){var a=t.RB();t.A2O({info:a,x:t.iX,y:t.iY}),n=!0}t.WZ()}if(t.W0(e),n&&"repeat"!==t.M4&&t.KP){var r=0,l=0;t.D1[1]<t.iY&&(l=t.D1[3]-t.D1[1]-t.F),t.D1[0]<t.iX&&(r=t.D1[2]-t.D1[0]-t.I),null===ZC._n_(t.E["pattern-tx"])?t.E["pattern-tx"]=r:t.E["pattern-tx"]+=r,null===ZC._n_(t.E["pattern-ty"])?t.E["pattern-ty"]=l:t.E["pattern-ty"]+=l,ZC.Q.G3(ZC.AK(t.E["pattern-image-id"]),{transform:"translate("+t.E["pattern-tx"]+","+t.E["pattern-ty"]+")"})}var o=t.F6+t.FS+t.F2+t.FD!==0;t.E.cx=t.iX+t.I/2,t.E.cy=t.iY+t.F/2,t.VM&&t.A3G();var s=t.B7,c=t.AZ;t.B7=t.BW,t.AZ=t.AU,t.KX(),ZC.CR.setup(i,t),t.T7=o?"round":"square",t.EX+t.G9>0&&(t.T7="butt"),t.ZZ=o?"round":"miter";var h=!1;ZC.A5.browser.msie||!t.FC||t.KP||""!==t.Q1||""!==t.OJ||""!==t.NP||""!==t.P6||0!==t.F6||0!==t.FS||0!==t.F2||0!==t.FD||(h=!0),t.E["skip-top"]=!0,t.E.border=e,ZC.CR.paint(i,t,t.D,!0,null,h),t.B7=s,t.AZ=c,t.KX()},VW:function(e){e=e||"all";var t=this,i=t.Z;if("all"===e){var n=ZC.Q.F5("zcv:fill");if(""!==t.DA&&-1===ZC.AV(ZC.IMG404,t.DA)){var a=t.RB(),r=a.image;switch(t.M4){default:n.type="tile",n.src=t.DA,ZC.Q.G3(n,{position:a.cx+","+a.cy,opacity:t.C6,"o:opacity2":t.C6}),t.E.imgfill=[n];break;case"no-repeat":case"false":case!1:t.E.imgfill=[r,a.x,a.y]}}t.WY("0.5,0.5")}var l=ZC.Q.F5("zcv:stroke");switch(l.weight=t.AU+"px",l.color=t.BW,l.opacity=t.C6,t.GD){case"solid":l.dashstyle="solid";break;case"dotted":l.dashstyle="dot";break;case"dashed":l.dashstyle="dash"}t.E.stroke=l,t.W0(e);var o=t.F6+t.FS+t.F2+t.FD!==0;t.E.cx=t.iX+t.I/2,t.E.cy=t.iY+t.F/2;var s=t.B7,c=t.AZ;t.B7=t.BW,t.AZ=t.AU,t.KX(),ZC.CR.setup(i,t),t.T7=o?"round":"square",t.EX+t.G9>0&&(t.T7="butt"),t.ZZ=o?"round":"miter",t.E.border=e,ZC.CR.paint(i,t,t.D,"all"===e),t.B7=s,t.AZ=c,t.KX()}};ZC.HL=ZC.DT.CA(HL);var DN={$i:function(e){this.b(e);var t=this;t.IL=null,t.GL="",t.AM=null,t.O8="center",t.JX="middle",t.DG=zingchart.FONTSIZE,t.GH=zingchart.FONTFAMILY,t.C2="#000",t.A92=!1,t.N5=!1,t.QT=!1,t.K8="none",t.sFontWeight="normal",t.YB=0,t.FM=2,t.FN=2,t.FU=2,t.EQ=2,t.A8K=!1,t.A29=!1,t.FI=-1,t.KA=0,t.NM=0,t.OM=ZC.MAX,t.bRTL=!1,t.A1D=!0,t.V2=zingchart.FASTWIDTH,t.A69=1.65,t.V5=1,t.VP=!1,t.A7=null,t.V9=!1,t.A5J=!1},getPMap:function(){var e=this.b();return this.addPMap(e,"textAlign,verticalAlign,fontSize,fontFamily,color,bold,fontWeight,italic,underline,textDecoration,paddingTop,paddingRight,paddingBottom,paddingLeft,text","O8,JX,DG,GH,C2,A92,sFontWeight,N5,QT,K8,FM,FN,FU,EQ,AM"),e},copy:function(e){this.b(e);for(var t="O8,JX,DG,GH,C2,A92,sFontWeight,N5,K8,QT,FM,FN,FU,EQ,AM".split(","),i=0,n=t.length;i<n;i++)"undefined"!=typeof e[t[i]]&&(this[t[i]]=e[t[i]])},overrideFormat:function(e){for(var t=["decimals","thousands-separator","decimals-separator"],i=0;i<t.length;i++)e[t[i]]="undefined"!=typeof this.o[t[i]]?this.o[t[i]]:e[t[i]];return e},JV:function(e){return e},isBold:function(e){return"bold"===e||"bolder"===e||"500"===e||"600"===e||"700"===e||"800"===e||"900"===e},cwidth:function(e){var t=this;if(t.V2)return e.replace(/(<([^>]+)>)/gi,"").length*t.DG/(t.A69*(t.isBold(t.sFontWeight)?.87:1)*(t.N5?.95:1));var i="";return"undefined"!=typeof t.o["html-mode"]&&ZC._b_(t.o["html-mode"])&&(i="[HTMLMODE]"),ZC.Q.A43(this.H.K,i+e,this.GH,this.DG,this.sFontWeight,this.FI)},parse:function(){this.I=this.F=this.NM=this.KA=0,this.b();var e,t,i,n,a,r=this;if(!r.o.tween){if(r.ZQ("text","AM"),null!==ZC._n_(r.AM)&&(r.AM=""+r.AM,r.AM=r.JV(r.AM),r.AM=r.AM.replace(/\n/g,"<br>").replace(/\\n/g,"<br>"),"svg"===r.H.AA&&(r.AM=r.AM.replace(/&nbsp;/g," ")),r.AM=r.AM.replace(/<audio|<video|<embed|<object/gi,""),-1!==r.AM.indexOf("img")&&(r.AM=r.AM.replace(/on(.+?)=/gi,""))),r.assign_a([["overlap","A1D","b"],["fast-width","V2","b"],["max-width","OM","i"],["line-height","FI","i"],["width-ratio","A69","f"],["wrap-text","A29","b"],["clip-text","A8K","b"],["bold","A92","b"],["italic","N5","b"],["underline","QT","b"],["text-decoration","K8"],["rtl","bRTL","b"],["text-align","O8"],["align","O8"],["vertical-align","JX"],["font-size","DG","f"],["max-chars","YB","i"],["font-family","GH"],["font-angle","A9","i"],["color","C2","c"],["font-color","C2","c"],["text-alpha","V5","f",0,1],["lock-rotation","V9","b"]]),r.DG=ZC.BQ(1,r.DG),null===ZC._n_(r.o["text-alpha"])&&(r.V5=r.C6),r.A92&&(r.sFontWeight="bold"),null!==(e=ZC._n_(r.o["font-weight"]))&&(r.sFontWeight=e),null===ZC._n_(r.o["text-decoration"])&&(r.K8=r.QT?"underline":"none"),null!==(e=ZC._n_(r.o["font-style"]))&&(r.N5="italic"===e||"oblique"===e),null!==(e=ZC._n_(r.o.padding))){var l=String(e).split(/\s+|;|,/);t=1===l.length?[ZC._i_(l[0]),ZC._i_(l[0]),ZC._i_(l[0]),ZC._i_(l[0])]:2===l.length?[ZC._i_(l[0]),ZC._i_(l[1]),ZC._i_(l[0]),ZC._i_(l[1])]:3===l.length?[ZC._i_(l[0]),ZC._i_(l[1]),ZC._i_(l[2]),ZC._i_(l[0])]:[ZC._i_(l[0]),ZC._i_(l[1]),ZC._i_(l[2]),ZC._i_(l[3])],r.FM=t[0],r.FN=t[1],r.FU=t[2],r.EQ=t[3]}if(r.assign_a([["padding-top","FM","i"],["padding-right","FN","i"],["padding-bottom","FU","i"],["padding-left","EQ","i"]]),r.AM){r.YB>0&&r.AM.length>r.YB&&(r.AM=r.AM.substring(0,r.YB)+"...");var o=r.AM.split(/<br>|<br\/>|<br \/>|\n/),s="";"undefined"!=typeof r.o["html-mode"]&&ZC._b_(r.o["html-mode"])&&(o=[r.AM],s="[HTMLMODE]");o.length;for(r.V2?r.KA=1.65*this.DG:r.KA=ZC.Q.A43(this.H.K,s+r.AM,this.GH,this.DG,this.sFontWeight,this.FI,!0)+r.FM+r.FU,i=0,n=o.length;i<n;i++)r.NM=ZC.BQ(r.NM,r.cwidth(o[i])+r.EQ+r.FN)}else r.AM="",r.NM=ZC._i_(1.25*r.DG),r.KA=-1===r.FI?ZC._i_(1.25*r.DG):r.FI;if((null===ZC._n_(r.o.width)||isNaN(r.I)||0===r.I)&&(r.I=r.NM),(null===ZC._n_(r.o.height)||isNaN(r.F)||0===r.F)&&(r.F=r.KA),r.I=ZC.CY(r.I,r.OM),r.A29&&r.NM>r.I&&!r.E.wrapped&&r.I>2*r.DG){var c,h="",C=0,u=r.AM.replace(/<br>/gi," [##] ").split(/\s|<br>/),d=[];for(i=0,n=u.length;i<n;i++)if((c=r.cwidth(u[i]))>.9*r.I){var A=Math.ceil(c/r.I*.9),p=Math.ceil(u[i].length/A);for(a=0;a<A;a++)d.push(u[i].substr(a*p,p))}else d.push(u[i]);for(i=0,n=d.length;i<n;i++)""!==d[i]&&("[##]"===d[i]?(h+="<br>",C=0):(C+=c=1+r.cwidth(d[i]+" "))>.9*r.I?(i>0&&(h+="<br>"),h+=d[i]+" ",C=c):h+=d[i]+" ");h=(h=h.replace(/<br><br>/g,"<br>").replace(/ <br> <br>/g," <br>")).replace(/(.+?)<br> $/g,"$1");var g=r.o.text;r.o.text=h,r.E.wrapped=!0,r.parse(),r.o.text=g,r.E.wrapped=!1}if("canvas"!==r.H.AA&&(r.AM=r.AM.replace(/&lt;/g,"<").replace(/&gt;/g,">")),!(null!==ZC._n_(r.o.width)&&null!==ZC._n_(r.o.height)||null===ZC._n_(r.o.position)&&null===ZC._n_(r.o.margin)&&null===ZC._n_(r.o["margin-top"])&&null===ZC._n_(r.o["margin-right"])&&null===ZC._n_(r.o["margin-bottom"])&&null===ZC._n_(r.o["margin-left"]))){r.iX=-1,r.iY=-1;var Z=r.o.width,f=r.o.height;null===ZC._n_(Z)&&(r.o.width=r.I),null===ZC._n_(f)&&(r.o.height=r.F),r.locate(),r.o.width=Z,r.o.height=f}if("undefined"==typeof r.o["html-mode"]||!r.o["html-mode"]){var _=Math.ceil((r.NM-r.EQ-r.FN)/r.DG);_>0&&(r.AM=r.AM.replace(/<hr>/g,new Array(_).join("\u2014")))}}r.setAnchor()},paint:function(){var e,t,i,n,a,r,l,o,s,c,h,C=this;if(!C.VP&&!C.A1D){var u=!0;null!==ZC._n_(C.o.flexible)&&(u=ZC._b_(C.o.flexible));var d,A,p={x:C.iX+C.EQ-1,y:C.iY+C.FM-1,width:C.I-C.EQ-C.FN+2,height:C.F-C.FM-C.FU+2,type:C.E.lbltype||""},g=[[0,0]];for(u&&(g=[[0,0],[0,2],[0,-4],[0,4],[0,-8],[3,0],[-6,0],[5,0],[-10,0]]),A=0;A<g.length;A++){for(d=!0,p.x+=g[A][0],p.y+=g[A][0],a=0,r=C.H.ST.length;a<r;a++)ZC.AQ.XM(p,C.H.ST[a],-2)&&(d=!1);if(d){C.iX=p.x,C.iY=p.y;break}}if(!d)return;C.H.ST.push(p)}var Z=C.H.AA;if(e=ZC.Q.EB(C.Z,Z),C.VP||C.b(),!C.A5J&&(C.o.width||!(C.I-C.EQ-C.FN<2))&&(C.o.height||!(C.KA-C.FM-C.FU<2))){var f=C.A9%360==0?"0":"";if((C.VP||zingchart.CANVASTEXT&&"canvas"===Z)&&(f=""),ZC.vml&&"svg"===Z&&""===C.GL&&(C.GL=C.K+"-class"),!C.VP&&ZC.AK(C.K)&&(Z="_",ZC.objmove))return ZC.AK(C.K).style.top=C.iY+C.BH+"px",void(ZC.AK(C.K).style.left=C.iX+C.BM+"px");var _="undefined"!=typeof C.E["html-mode"]&&C.E["html-mode"],b=_;"undefined"!=typeof C.o["html-mode"]&&(_=ZC._b_(C.o["html-mode"]));var m,v,E,D,w,x,B,y,K,F,M,z,I,S,G,N,H,k,L,Q,P,O,T=[C.AM];_||(T=C.AM.split(/<br>|<br\/>|<br \/>|\n/)),_&&!b&&"svg"===Z&&"0"===f&&(f="0html");var Y=C.IL?C.IL:C.Z.parentNode;switch(Z+f){case"canvas0":case"vml0":case"svg0html":if(n=1,!_)switch(C.JX){case"middle":n+=(C.F-C.KA)/2;break;case"bottom":n+=C.F-C.KA}if(l=ZC.Q.HY({id:C.K,cls:C.GL,tl:ZC._x_(C.iY+C.BH)+"/"+ZC._x_(C.iX+C.BM),wh:C.I+"/"+C.F,position:"absolute",padding:0,margin:0,overflow:_?"visible":"hidden",textAlign:C.O8}),_&&(b||Z+f!=="svg0html"||(Y=ZC.AK(C.H.K+"-top")),Y.appendChild(l)),ZC.Q.HY({id:C.K+"-t",cls:""!==C.GL?C.GL+"-t":"",p:l,width:C.I-C.EQ-C.FN,height:_?null:C.KA-C.FM-C.FU,tl:n+"/0",html:C.AM+"",position:"absolute",whiteSpace:"nowrap",opacity:C.V5,color:C.C2,fontWeight:C.sFontWeight,fontStyle:C.N5?"oblique":"normal",textDecoration:C.K8,fontSize:C.DG,fontFamily:C.GH,marginTop:C.FM,marginRight:C.FN,marginBottom:C.FU,marginLeft:C.EQ,verticalAlign:C.JX,textAlign:C.O8,lineHeight:-1===C.FI?"125%":C.FI+"px",rtl:C.bRTL,padding:0}),C.E["css-display"]&&(l.style.display=C.E["css-display"],C.E["css-display"]=null),b&&C.H&&C.H.A7&&!C.o.width&&!C.o.height){var X=ZC.A5("#"+C.K+"-t");"canvas"===Z&&(ZC.AK(C.H.K+"-tooltip-c").width=X.width()+C.EQ+C.FN,ZC.AK(C.H.K+"-tooltip-c").height=X.height()+C.FM+C.FU),C.H.A7.clear(),C.I=X.width()+C.EQ+C.FN,C.F=X.height()+C.FM+C.FU,C.paint()}break;case"canvas":var V=!1;if(ZC.A5.browser.opera&&C.A9%90==0&&0!==C.A9&&(C.A9+=.5,V=!0),e=C.Z.getContext("2d"),zingchart.DEV.CACHECANVASTEXT&&(ZC.CanvasCache||(ZC.CanvasCache={})),!zingchart.DEV.CACHECANVASTEXT||zingchart.DEV.CACHECANVASTEXT&&!ZC.CanvasCache[C.K]){for(zingchart.DEV.CACHECANVASTEXT&&(ZC.CanvasCache[C.K]=document.createElement("canvas"),ZC.CanvasCache[C.K].width=C.NM,ZC.CanvasCache[C.K].height=C.KA),m=-1===C.FI?0:ZC._x_(C.FI-1.25*C.DG)/2,a=0,r=T.length;a<r;a++)if(""!==ZC.GV(T[a])){switch(t=1===r?C.NM:C.cwidth(T[a])+C.FN+C.EQ,E=-1===(v=T[a]).indexOf("<")?v:v.replace(/<.+?>/gi,"").replace(/<\/.+?>/gi,""),i=0,n=0,C.O8){case"center":i+=(C.I-t)/2;break;case"right":i+=C.I-t}switch(C.JX){case"middle":n+=(C.F-C.KA)/2;break;case"bottom":n+=C.F-C.KA}if(D=0,v!==E){for(;x=/<(.+?)>(.*?)<\/(.+?)>/.exec(v);){switch(B="",y="",(c=/(.+?)style=(.+?)(\'|")(.*?)/.exec(x[1]))&&(y=c[2].replace(/\'|"/g,"")),x[3]){case"b":case"strong":B="font-weight:bold";break;case"i":case"em":B="font-style:italic";break;case"u":B="text-decoration:underline"}F='[[span style="'+(""===B?"":B+";")+y+'"]]'+x[2]+"[[/span]]",v=v.replace(x[0],F)}for(M=!1,L=0,Q=(x=(v=v.replace(/\[\[/g,"<").replace(/\]\]/g,">").replace(/<span/g,"[[*]]<span").replace(/<\/span>/g,"</span>[[*]]")).split("[[*]]")).length;L<Q;L++)if(""!==x[L]){if(o=C.C2,z=C.sFontWeight,I=C.N5,S=C.QT,G=C.DG,N=C.GH,k=C.FI,H=C.K8,w=x[L],h=/<span style=(.+?)>(.+?)<\/(.+?)>/.exec(x[L]))for(w=h[2],P=0,O=(K=h[1].replace(/\'|"/g,"").split(/;|:/)).length;P<O-1;P+=2)switch(ZC.GV(K[P])){case"font-size":G=ZC._i_(ZC.GV(K[P+1]));break;case"font-family":N=ZC.GV(K[P+1]);break;case"font-weight":z=ZC.GV(K[P+1]);break;case"font-style":-1!==ZC.AV(["italic","oblique"],ZC.GV(K[P+1]))&&(I=!0);break;case"text-decoration":H=ZC.GV(K[P+1]);break;case"line-height":k=ZC._i_(ZC.GV(K[P+1]));break;case"color":o=ZC.AP.GC(ZC.GV(K[P+1]))}0===a&&(m=-1===k?0:ZC._x_(k-1.25*G)/2);var J={idx:a,ctx:e,i:I,fw:z,fs:G,lh:k,ff:N,c:o,t:w,dx:i,dy:n};J.dy+=ZC._x_(m),J.dy+=M||C.isBold(z)||S?2:0,C.paintCANVASText(J),M=I,D++,i+=ZC.Q.A43(this.H.K,w,N,G,z,k)}null!==ZC._n_(k)&&null!==ZC._n_(G)&&(m+=-1===k?1.25*G:k)}else C.paintCANVASText({idx:a,ctx:e,i:C.N5,fw:C.sFontWeight,fs:C.DG,lh:C.FI,ff:C.GH,c:C.C2,t:T[a],dx:i,dy:n+m}),m+=-1===C.FI?1.25*C.DG:C.FI}}else e.drawImage(ZC.CanvasCache[C.K],C.iX+C.BM,C.iY+C.BH);V&&(C.A9-=.5);break;case"vml":switch(n=0,C.JX){case"top":n-=(C.F-C.KA)/2;break;case"bottom":n+=(C.F-C.KA)/2}var U=ZC.Q.F5("zcv:line"),R=C.iX+C.BM+C.I/2,W=C.iY+C.BH+C.F/2,j=ZC.EH(C.A9)*(C.I-C.EQ-C.FN)/2,q=ZC.EP(C.A9)*(C.I-C.EQ-C.FN)/2,$=ZC._i_(R-j-ZC.EH(90-C.A9)*n),ee=ZC._i_(W-q+ZC.EP(90-C.A9)*n),te=ZC._i_(R+j-ZC.EH(90-C.A9)*n),ie=ZC._i_(W+q+ZC.EP(90-C.A9)*n);$===te&&($-=.01,te+=.01),ee===ie&&(ee-=.01,ie+=.01),o=C.C2,0!==C.A9&&C.C6<1&&(o=ZC.AP.QU(o,99*(1-C.C6))),ZC.Q.G3(U,{id:C.K+"-line",from:$+"px,"+ee+"px",to:te+"px,"+ie+"px",fillcolor:o}),U.filled=!0,U.stroked=!1;var ne=ZC.Q.F5("zcv:path");ne.setAttribute("textpathok",!0),U.appendChild(ne);var ae=ZC.Q.F5("zcv:textpath"),re=C.AM.replace(/<br>|<br\/>|<br \/>/gi,"\n").replace(/<.+?>/gi,"").replace(/<\/.+?>/gi,"");ZC.Q.G3(ae,{on:!0,string:re}),ZC.Q.PJ(ae,{color:o,fontWeight:C.sFontWeight,fontStyle:C.N5?"oblique":"normal",textDecoration:C.K8,fontSize:C.DG+"px",fontFamily:C.GH,"v-text-align":C.O8}),U.appendChild(ae),e.appendChild(U);break;case"svg":case"svg0":var le=C.iX+C.EQ+C.BM,oe=C.iY+C.FM+C.BH;if(l=ZC.Q.F5("text","http://www.w3.org/2000/svg"),ZC.Q.G3(l,{x:ZC._x_(le),y:ZC._x_(oe),id:C.K,"class":C.GL,opacity:C.V5}),C.E["css-display"]&&(l.style.display=C.E["css-display"],C.E["css-display"]=null),C.bRTL&&ZC.Q.G3(l,{"text-anchor":ZC.A5.browser.msie?"":"end","writing-mode":"rl",direction:"rtl","unicode-bidi":"bidi-override"}),C.A8K&&(C.H.KE.appendChild(ZC.Q.X8({id:C.K+"-clip",path:[[C.iX+C.EQ+C.AU+C.BM,C.iY+C.FM+C.AU+C.BH].join(","),[C.iX+C.I-C.FN-C.AU+C.BM,C.iY+C.FM+C.AU+C.BH].join(","),[C.iX+C.I-C.FN-C.AU+C.BM,C.iY+C.F-C.FU-C.AU+C.BH].join(","),[C.iX+C.EQ+C.AU+C.BM,C.iY+C.F-C.FU-C.AU+C.BH].join(","),[C.iX+C.EQ+C.AU+C.BM,C.iY+C.FM+C.AU+C.BH].join(",")].join(" ")})),ZC.Q.G3(l,{"clip-path":"url(#"+C.K+"-clip)"})),C.A9%360!=0&&l.setAttribute("transform","rotate("+C.A9+" "+(le+(C.I-C.EQ-C.FN)/2)+" "+(oe+(C.F-C.FM-C.FU)/2)+")"),_&&Y.appendChild(l),_){ZC.Q.EU(C.K+"-float");var se=ZC.Q.F5("div");ZC.Q.PJ(se,{position:"absolute",left:0,top:0,width:C.I-C.EQ-C.FN+"px",height:C.F-C.FM-C.FU+"px",color:C.C2,fontSize:C.DG+"px",fontFamily:C.GH,fontWeight:C.sFontWeight,textDecoration:C.K8,textAlign:C.O8,fontStyle:C.N5?"italic":"normal"}),se.id=C.K+"-float",se.className="zc-style zc-html-mode",se.innerHTML=T[0],1===C.o["z-index"]?ZC.AK(C.H.K+"-top").append(se):ZC.AK(C.H.K+"-top").insertBefore(se,ZC.AK(C.H.K+"-img")),b&&C.H&&C.H.A7&&(C.o.width||C.o.height||(C.H.A7.clear(),se.style.width="",se.style.height="",C.I=ZC.A5(se).width()+C.EQ+C.FN,C.F=ZC.A5(se).height()+C.FM+C.FU,C.paint()))}else for(m=-1===C.FI?0:ZC._x_(C.FI-1.25*C.DG)/2,a=0,r=T.length;a<r;a++){switch(t=1===r?C.NM:C.cwidth(T[a])+C.FN+C.EQ,E=-1===(v=T[a]).indexOf("<")?v:v.replace(/<.+?>/gi,"").replace(/<\/.+?>/gi,""),i=0,n=C.DG,C.O8){case"center":i=(C.I-t)/2;break;case"right":i=C.I-t}switch(C.JX){case"middle":n+=(C.F-C.KA)/2;break;case"bottom":n+=C.F-C.KA}if(D=0,v!==E){for(;x=/<(.+?)>(.*?)<\/(.+?)>/.exec(v);){switch(B="",y="",(c=/(.+?)style=(.+?)(\'|")(.*?)/.exec(x[1]))&&(y=c[2].replace(/\'|"/g,"")),x[3]){case"b":case"strong":B="font-weight:bold";break;case"i":case"em":B="font-style:italic";break;case"u":B="text-decoration:underline"}F='[[span style="'+(""===B?"":B+";")+y+'"]]'+x[2]+"[[/span]]",v=v.replace(x[0],F)}for(M=!1,L=0,Q=(x=(v=v.replace(/\[\[/g,"<").replace(/\]\]/g,">").replace(/<span/g,"[[*]]<span").replace(/<\/span>/g,"</span>[[*]]")).split("[[*]]")).length;L<Q;L++)if(""!==x[L]){if(o=C.C2,z=C.sFontWeight,I=C.N5,S=C.QT,G=C.DG,N=C.GH,H=C.K8,k=C.FI,w=x[L],h=/<span style=(.+?)>(.+?)<\/(.+?)>/.exec(x[L]))for(w=h[2],P=0,O=(K=h[1].replace(/\'|"/g,"").split(/;|:/)).length;P<O-1;P+=2)switch(ZC.GV(K[P])){case"font-size":G=ZC._i_(ZC.GV(K[P+1]));break;case"font-family":N=ZC.GV(K[P+1]);break;case"font-weight":z=ZC.GV(K[P+1]);break;case"font-style":-1!==ZC.AV(["italic","oblique"],ZC.GV(K[P+1]))&&(I=!0);break;case"text-decoration":H=ZC.GV(K[P+1]);break;case"line-height":k=ZC._i_(ZC.GV(K[P+1]));break;case"color":o=ZC.AP.GC(ZC.GV(K[P+1]))}n=G,s=ZC.Q.F5("tspan","http://www.w3.org/2000/svg"),0===D?(ZC.Q.G3(s,{x:ZC._x_(le+i),y:ZC._x_(oe+n),dy:ZC._x_(m)}),m+=-1===k?1.25*G:ZC.BQ(1.5*G,k)):ZC.Q.G3(s,{dx:M||C.isBold(z)||S?2:0}),ZC.Q.G3(s,{color:o,fill:o}),ZC.Q.PJ(s,{fontWeight:z,fontStyle:I?"oblique":"normal",textDecoration:H,fontSize:G+"px",fontFamily:N,dominantBaseline:"auto"});var ce=document.createElement("span");-1!==w.indexOf("<")||-1!==w.indexOf(">")?ce.innerText=w:ce.innerHTML=w,w=ce.innerText||ce.textContent,ce=null,s.textContent=w,l.appendChild(s),M=I,D++}}else C.bRTL&&ZC.A5.browser.msie&&(i+=t-C.EQ-C.FN),s=ZC.Q.F5("tspan","http://www.w3.org/2000/svg"),ZC.Q.G3(s,{x:ZC._x_(le+i),y:ZC._x_(oe+n),color:C.C2,fill:C.C2,dy:ZC._x_(m)}),ZC.Q.PJ(s,{fontWeight:C.sFontWeight,fontStyle:C.N5?"oblique":"normal",textDecoration:C.K8,fontSize:C.DG+"px",fontFamily:C.GH,dominantBaseline:"auto"}),s.textContent=E,l.appendChild(s),m+=-1===C.FI?1.25*C.DG:C.FI}}if(!_)if(!C.VP&&l&&Y)if(C.H.G1)-1!==ZC.Q.T8(Y).indexOf("zc-text")&&null===ZC._n_(C.H.G1[Y.id])&&(C.H.G1[Y.id]=document.createDocumentFragment()),C.H.G1[Y.id]?C.H.G1[Y.id].appendChild(l):Y.appendChild(l);else Y.appendChild(l)}},paintCANVASText:function(e){var t=this,i=e.idx,n=e.ctx,a=e.i,r=e.fw,l=e.fs,o=e.ff,s=e.c,c=e.dx,h=e.dy,C=e.t;n.save(),n.globalAlpha=t.V5;var u;if(u=(a?"italic":"normal")+" normal "+r+" "+l+"px "+o,n.font=u,n.fillStyle=s,n.textAlign="left",n.textBaseline="alphabetic",n.translate(t.iX+t.BM,t.iY+t.BH),0!==t.A9&&(n.translate(t.I/2,t.F/2),n.rotate(ZC.T1(t.A9)),n.translate(-t.I/2,-t.F/2)),n.translate(t.EQ,t.FM+l),n.translate(c,h),n.fillText(C,0,0),zingchart.DEV.CACHECANVASTEXT){var d=ZC.CanvasCache[t.K].getContext("2d");d.font=u,d.fillStyle=s,d.textAlign="left",d.textBaseline="alphabetic",d.fillText(C,t.EQ,t.FM+l+1.25*i*l)}n.restore()},EK:function(e){var t=this;if(ZC.canvas&&"canvas"===t.H.AA&&(e||(e=ZC.AK(t.H.K+"-textprint-c")),!zingchart.CANVASTEXT&&t.A9%360==0)){var i=t.Z;t.Z=e,t.VP=!0;var n=t.H.AA;t.H.AA="canvas",t.paint(),t.VP=!1,t.H.AA=n,t.Z=i}}};ZC.DN=ZC.HL.CA(DN);var Q2={$i:function(e){this.b(e);var t=this;t.CI="json",t.NZ={graphset:!0,graph:!0,"objects-bottom":!0,"objects-top":!0,maps:!0,plotarea:!0,plots:!0,guide:!0,"static":!0,"value-box":!0},t.bA11y=!1,t.P2="",t.A19=!1,t.A14="en_us",t.QP=null,t.JL="",t.UN=!1,t.RS={},t.MZ="",t.ADI={},t.QM="",t.EW="",t.M9={},t.HP=null,t.AG=[],t.LL="",t.A7=null,t.H2=null,t.D7=null,t.B8=new ZC.AAT(t),t.QJ="",t.ML=null,t.NT=[null,null,null,null],t.O7=!1,t.NF="x",t.K9=!1,t.TJ=!1,t.ABL=!1,t.A3D=!1,t.GO=!1,t.A9P={},t.NW=null,t.QS={},t.LS=!1,t.QZ=!1,t.AD3=null,t.SW=[],t.N={},t.MY=null,t.DF=null,t.UQ=0,t.A28=0,t.A4G=1,t.MF=null,t.SD="",t.AAZ="F*nStrlng4Cu$tOmLlc9nc9!",t.MA="",t.A18={},t.A0L=!1,t.AA="",t.KE=null,t.ZT=!1,t.QO=["",""],t.L3=0,t.KR=[],t.A8B=0,t.A87=0,t.AA2=!1,t.A1A="",t.A6L=!0,t.IC=null,t.QL=[],t.NS=0,t.AAQ=!1,t.SA={},t.A1K=!1,t.G1=zingchart.DEV.DOMFRAGMENTS?{}:null,t.A2H=!1,t.ST=[]},clearLabelBoxes:function(e){var t=this;if(e)for(var i=t.ST.length-1;i>=0;i--)t.ST[i].type===e&&t.ST.splice(i,1);else t.ST=[]},usc:function(){return-1!==ZC.AV(this.KR,"use_single_canvas")},mc:function(e){return e=e||"",ZC.AK(this.K+"-main-c"+(""===e?e:"-"+e))},hideCM:function(){var e;(e=ZC.AK(this.K+"-menu"))&&(e.style.display="none"),this.AA2=!1},ZV:function(){for(var e=this,t=e.NT.length,i=0;i<t;i++)if(null!==ZC._n_(e.NT[i])){switch(e.AA){case"svg":ZC.CR.VX(e.NT[i].ctx,e.NT[i].style,e.NT[i].path.join(" "),e.NT[i].filled);break;case"vml":ZC.CR.VW(e.NT[i].ctx,e.NT[i].style,e.NT[i].path.join(" "),e.NT[i].filled)}e.NT[i]=null}},A8N:function(){var s=this,i,A6,EY,A5N;ZC.LICENSE=ZC.LICENSE||zingchart.LICENSE||"",ZC.BUILDCODE=ZC.BUILDCODE||zingchart.BUILDCODE||"",ZC.LICENSEKEY=ZC.LICENSEKEY||zingchart.LICENSEKEY||"",A5N="file:"===document.location.protocol?ZC.HOSTNAME||"":document.location.hostname;var A1S=[A5N],CV=A5N.split(".");for("www"===CV[0]?A1S.push(A5N.replace("www.","")):A1S.push("www."+A5N),i=0;i<=CV.length-2;i++){for(var ABB="*",j=i;j<CV.length;j++)ABB+="."+CV[j];A1S.push(ABB)}function X6(e){if(ZC.NOABOUT&&ZC.NOABOUT instanceof Array){var t=ZC.XK.md5(ZC.A9U(ZC.A9G(e)));-1!==ZC.AV(ZC.NOABOUT,t)&&(s.ABL=!0)}}if(-1!==ZC.AV(A1S,"localhost")||-1!==ZC.AV(A1S,"127.0.0.1"))s.TJ=!0,s.A3D=!0,X6("localhost");else{var A2F=[["window.AC.Core.zflags","Q^fhx]XKoJJLnmLPUYiWUuQKAOGnuAIWrSN_ZIj_LYvS`jRkihLOSfysvRQTBtQOUUO^`SdgZUHWKDVQ[xST_SWRLyFKogwOclSB"],["window.jsNorthNine.AppIdentity","09Vczmfsf/Q5G8dRWLio+7PVG0KjUnLRqnRSPOeqf6gu/hpxK6BeHRUtuasojuRTPFQYdzNGN57nxLviTf1hV4lwaFjtbv/tA1g0W0k7AKV1g1ouow1nG/+EJLl0khmPDSKBJa8fkP70KLNtrxt5pE2yjx+IvQ40ajd/03rqqtR="]];for(i=0,A6=A2F.length;i<A6;i++)try{if(eval(A2F[i][0])===ZC.A9G(A2F[i][1])){s.TJ=!0;break}}catch(e){}for(i=0,A6=A1S.length;i<A6;i++){var A4H=ZC.XK.md5(ZC.A9U(ZC.A9G(A1S[i])));ZC.LICENSE instanceof Array&&-1!==ZC.AV(ZC.LICENSE,A4H)&&(s.TJ=!0,X6(A4H))}ZC.BUILDCODE instanceof Array&&2===ZC.BUILDCODE.length&&(EY=ZC.AD8(s.AAZ),EY=EY.replace("O","0"),s.SD=ZC.ACA(ZC.BUILDCODE[0],EY),s.SD===ZC.BUILDCODE[1]&&(s.TJ=!0,s.A3D=!0,X6(ZC.BUILDCODE[0])))}},A8S:function(){var e=this;if(null!==e.ML)ZC._todash_(e.ML),e.load();else if(null===ZC._n_(ZC.cache.data["defaults-"+e.QJ])){var t=["query-string"===e.MZ?"zcrandom="+Math.random():"",zingchart.ZCOUTPUT?"zcoutput="+e.AA:""].join("&");ZC.A5.ajax({type:"GET",url:e.QJ,dataType:"text",beforeSend:function(t){e.RS.defaults||"http-headers"!==e.MZ||t.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:t,error:function(t,i,n,a){return e.NU({name:"Network error",message:"Resource not found ("+a+")"},"URL Data loader"),!1},success:function(t){var i;try{i=JSON.parse(t),ZC.cache.data["defaults-"+e.QJ]=t}catch(n){return e.NU(n,"JSON parser"),!1}e.ML=i,ZC._todash_(e.ML),e.load()}})}else{var i;try{i=JSON.parse(ZC.cache.data["defaults-"+e.QJ])}catch(n){return e.NU(n,"JSON parser"),!1}e.ML=i,ZC._todash_(e.ML),e.load()}},load:function(e,t){var i=this;if(i.MA="load",""!==(t=t||i.QM)&&0!==t.indexOf("javascript:"))if(null===ZC._n_(ZC.cache.data["data-"+t])){var n=["query-string"===i.MZ?"zcrandom="+Math.random():"",zingchart.ZCOUTPUT?"zcoutput="+i.AA:""].join("&");ZC.A5.ajax({type:"GET",url:t,dataType:"text",beforeSend:function(e){i.RS.data||"http-headers"!==i.MZ||e.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:n,error:function(e,t,n,a){return i.NU({name:"Network error",message:"Resource not found ("+a+")"},"URL Data loader"),!1},success:function(t){i.data_(e,t)}})}else i.data_(e,ZC.cache.data["data-"+t]),ZC.cache.data["data-"+t]=null;else""!==i.EW?i.data_(e,i.EW):null!==i.M9&&(i.A73?i.M9=JSON.parse(JSON.stringify(i.A73)):i.A73=JSON.parse(JSON.stringify(i.M9)),i.data_(e,i.M9))},data_:function(e,t){var i=this;ZC.TS[i.K]=(new Date).getTime(),ZC.AP.A83("dataload",i)?ZC.AP.BY("dataload",i,i.FE(),t,function(t){i.load_(e,t)}):i.load_(e,t)},A4W:function(e){var t,i;if(!zingchart.DEV.RESOURCES)return[];e||(e=this.o);var n=[];if(e.graphset)for(t=0,i=e.graphset.length;t<i;t++){var a=e.graphset[t].type||"null";if(-1===ZC.AV(ZC.CHARTS,a)){for(var r in"3d"===a.substring(a.length-2)&&(a=a.substring(0,a.length-2)),ZC.EQUIV)ZC.EQUIV.hasOwnProperty(r)&&-1!==ZC.AV(ZC.EQUIV[r],a)&&(a=r);zingchart.loadModules(a),n.push(a)}}for(this.ACM(e),t=0,i=ZC.RH.length;t<i;t++)""!==ZC.GV(ZC.RH[t])&&-1===ZC.AV(ZC.WI,ZC.GV(ZC.RH[t]))&&n.push(ZC.GV(ZC.RH[t]));return n},ACM:function(e){var t,i,n,a,r,l;function o(e){return-1!==ZC.AV(["bar","bar3d","funnel","bullet"],e)&&(e="v"+e),-1===ZC.AV(ZC.CHARTS,e)&&(e=""),e}if(e||(e=this.o),this.A6L)for(e.history&&zingchart.loadModules("history"),n=0,a=e.graphset.length;n<a;n++){if((t=e.graphset[n].type)&&"null"!==t)if("mixed"===t||"hmixed"===t||"mixed3d"===t){if(e.graphset[n].series)for(r=0,l=e.graphset[n].series.length;r<l;r++)(i=e.graphset[n].series[r].type)&&zingchart.loadModules(o(i));e.graphset[n].plot&&(i=e.graphset[n].plot.type)&&zingchart.loadModules(o(i))}else zingchart.loadModules(o(t));var s=!1,c=!1;if(e.graphset[n].series)for(r=0,l=e.graphset[n].series.length;r<l;r++)e.graphset[n].series[r].errors&&(s=!0),e.graphset[n].series[r].animation&&(c=!0);if(e.graphset[n].plot&&(e.graphset[n].plot.animation&&(c=!0),e.graphset[n].plot.errors&&(s=!0)),s&&zingchart.loadModules("errorbars"),c&&zingchart.loadModules("animation"),e.graphset[n].legend&&zingchart.loadModules("legend"),e.graphset[n].preview&&zingchart.loadModules("preview"),e.graphset[n].tooltip&&zingchart.loadModules("tooltip"),(e.graphset[n].labels||e.graphset[n].shapes||e.graphset[n].arrows)&&zingchart.loadModules("objects"),t=e.graphset[n].shapes)for(r=0,l=t.length;r<l;r++)"zingchart.maps"===t[r].type&&zingchart.loadModules("maps"),t[r].options&&t[r].options.name&&zingchart.loadModules("maps-"+t[r].options.name.replace(/\./g,"-"));(e.graphset[n].guide||e.graphset[n]["crosshair-x"]||e.graphset[n]["crosshair-y"]||e.graphset[n].crosshairX||e.graphset[n].crosshairY)&&zingchart.loadModules("guide"),(e.graphset[n]["scroll-x"]||e.graphset[n]["scroll-y"]||e.graphset[n].scrollX||e.graphset[n].scrollY)&&zingchart.loadModules("scroll"),(e.refresh||e.graphset[n].refresh)&&zingchart.loadModules("refresh");var h=!1,C=!1;for(var u in e.graphset[n])e.graphset[n].hasOwnProperty(u)&&0===u.indexOf("scale")&&(e.graphset[n][u].zooming&&(h=!0),e.graphset[n][u].markers&&(C=!0));(h||e.graphset[n].zoom)&&zingchart.loadModules("zoom"),C&&zingchart.loadModules("scalemarkers")}},load_:function(JJ,TP){var s=this,G;s.E.rawsource=zingchart.DEV.KEEPSOURCE?TP:"N/A";var DL=null;if("string"==typeof TP)try{DL=JSON.parse(TP)}catch(JA){try{DL=eval("("+TP+")")}catch(JA){return s.NU(JA,"JSON parser"),!1}}else DL=TP;null===ZC._n_(DL.graphset)&&(DL={graphset:[DL]}),s.E.source="N/A",zingchart.DEV.KEEPSOURCE&&(s.E.source=ZC.GV(JSON.stringify(DL))),zingchart.A1E(s,s.A4W(DL),function(){DL=ZC.AP.BY("dataparse",s,s.FE(),DL),zingchart.A1E(s,s.A4W(DL),function(){if(ZC.AP.BY("modulesready",s,{id:s.K}),null===ZC._n_(JJ))s.XO(DL),s.o=DL,s.A19?(s.parse(),s.paint()):s.QH(function(){s.parse(),s.paint()});else{var e=s.OQ(JJ);if(null!==e&&null!==ZC._n_(G=DL.graphset)){var t=G.length>1?G[e.L]:G[0];t.id||(t.id=e.o.id||""),s.o.graphset[e.L]=t,s.QH(function(){s.parse(JJ),s.AG[e.L].paint()})}}})})},XO:function(DL){var s=this,G,i,A6,j,J8;for(null===ZC._n_(DL.graphset)&&(DL={graphset:[DL]}),1===DL.graphset.length&&null===ZC._n_(DL.graphset[0])&&(DL.graphset=[{type:"null"}]),i=0,A6=DL.graphset.length;i<A6;i++)if(null!==ZC._n_(DL.graphset[i])){if(null!==ZC._n_(G=DL.graphset[i].shapes)){var FH=[];for(DL.graphset[i].labels=DL.graphset[i].labels||[],j=0,J8=G.length;j<J8;j++)if(G[j].generated&&G[j]["map-item"]||FH.push(G[j]),null!==ZC._n_(G[j].type)&&0===G[j].type.indexOf("zingchart."))try{var LX=G[j].options||{},EC=G[j].type+"."+(LX.name||"");LX.graphid=i;var A30=eval(EC).call(s,LX,DL,G[j]);for(var A3F in A30)A30.hasOwnProperty(A3F)&&("label"===A30[A3F].objtype?DL.graphset[i].labels.push(A30[A3F]):FH.push(A30[A3F]))}catch(e){}DL.graphset[i].shapes=FH}var A6H;if(null!==ZC._n_(A6H=DL.graphset[i].widgets))for(var AAX=s.A4O(DL,i),k=0;k<A6H.length;k++){var A36=A6H[k];if(null!==ZC._n_(A36.type)&&null!==ZC._n_(zingchart.widgets[A36.type])&&"function"==typeof zingchart.widgets[A36.type].parse)try{var BI={};ZC._cp_(A36,BI),BI.graph=AAX.graph,BI.loader={id:s.K,width:s.I,height:s.F};var o=zingchart.widgets[A36.type].parse.call(s,BI);if(null!==ZC._n_(G=o.graphs))for(j=0;j<G.length;j++)DL.graphset.push({}),ZC._cp_(G[j],DL.graphset[DL.graphset.length-1]);if(null!==ZC._n_(G=o.labels))for(null===ZC._n_(DL.graphset[i].labels)&&(DL.graphset[i].labels=[]),j=0;j<G.length;j++)DL.graphset[i].labels.push(G[j]);if(null!==ZC._n_(G=o.shapes))for(null===ZC._n_(DL.graphset[i].shapes)&&(DL.graphset[i].shapes=[]),j=0;j<G.length;j++)DL.graphset[i].shapes.push(G[j])}catch(e){}}}},AAG:function(e,t){var i=this;switch(e){case"line":return new ZC.A66(i);case"area":return new ZC.A5Z(i);case"vline":return new ZC.A9C(i);case"varea":return new ZC.A9A(i);case"bar":case"vbar":case"column":return new ZC.A2N(i);case"hbar":return new ZC.A2G(i);case"mixed":case"hmixed":case"mixed3d":for(var n=!1,a=i.o.graphset[t].series,r=0,l=a.length;r<l;r++)a[r]&&a[r].type&&-1!==a[r].type.indexOf("3d")&&(n=!0);return n?new ZC.A31(i):i.o.graphset[t].plot&&i.o.graphset[t].type&&i.o.graphset[t].plot&&i.o.graphset[t].plot.type&&-1!==i.o.graphset[t].plot.type.indexOf("3d")?new ZC.A31(i):"mixed"===e?new ZC.A58(i):new ZC.A8Q(i);case"scatter":return new ZC.A89(i);case"hscatter":return new ZC.A7F(i);case"bubble":return new ZC.A8W(i);case"hbubble":return new ZC.A84(i);case"ring":case"pie":return new ZC.A3U(i);case"nestedpie":return new ZC.A6K(i);case"radar":case"polar":return new ZC.A9Q(i);case"venn":return new ZC.AAK(i);case"bullet":case"vbullet":return new ZC.A80(i);case"hbullet":return new ZC.A82(i);case"funnel":case"vfunnel":return new ZC.A88(i);case"hfunnel":return new ZC.A86(i);case"heatmap":case"piano":return new ZC.A99(i);case"stock":return new ZC.A9X(i);case"range":return new ZC.A9N(i);case"vrange":return new ZC.ZCVRangeGraph(i);case"gauge":return new ZC.AA1(i);case"line3d":return new ZC.A8R(i);case"area3d":return new ZC.A8Z(i);case"ring3d":case"pie3d":return new ZC.A5G(i);case"bar3d":case"vbar3d":return new ZC.A90(i);case"hbar3d":return new ZC.A8T(i);case"null3d":return new ZC.A8M(i);default:return new ZC.AAJ(i)}},OQ:function(e){for(var t=this,i=0,n=t.AG.length;i<n;i++)if(t.AG[i].K===t.K+"-graph-"+e||t.AG[i].K===t.K+"-graph-id"+e||t.AG[i].K===e||i===e)return t.AG[i];return null},A4A:function(e,t){var i=this,n=ZC.A5("#"+i.K+("svg"===i.AA?"-top":"-main")),a=ZC._tx_(i.K);e-=n.offset().left,t-=n.offset().top;for(var r=null,l=0,o=i.AG.length;l<o;l++)ZC.DS(e,i.AG[l].iX,i.AG[l].iX+i.AG[l].I*a[0])&&ZC.DS(t,i.AG[l].iY,i.AG[l].iY+i.AG[l].F*a[1])&&(r=i.AG[l]);return r},A9Y:function(e){var t,i=this;if("undefined"==typeof i.E.themesloaded){void 0===e&&(e=!1),i.assign_a([["theme","LL"]]),i.o.graphset&&1===i.o.graphset.length&&null!==ZC._n_(t=i.o.graphset[0].theme)&&(i.LL=t),""===i.LL&&(i.LL="light"),i.LL=String(i.LL).replace("zingchart","classic");for(var n=i.LL.split(/\s+|;|,/),a=0,r=n.length;a<r;a++)i.B8.AAY(n[a]);i.B8.A8S(i.ML),ZC.mobile&&i.B8.AAY("mobile"),e||(i.E.themesloaded=!0)}},parse:function(e){var t,i,n,a,r,l,o=this;o.NF="x",o.E.json=ZC.GV(JSON.stringify(o.o)),ZC._cp_(o.o.layers,o.NZ),1===o.o.graphset.length&&ZC._cp_(o.o.graphset[0].layers,o.NZ);var s=o.FE();if(null!==ZC._n_(e)&&(s.graphid=e),ZC.AP.BY("dataready",o,s),o.MA="parse",o.QO[1]=o.QO[0],o.QO[0]="",o.QO[0]+=o.I+":"+o.F+":",null!==ZC._n_(t=o.o.graphset))for(o.QO[0]+=t.length+":",a=0;a<t.length;a++)o.QO[0]+=(t[a].type||"")+":",o.QO[0]+=(t[a].x||"")+":"+(t[a].y||"")+":"+(t[a].width||"")+":"+(t[a].height||"")+":",null!==ZC._n_(t[a].series)&&(o.QO[0]+=t[a].series.length+":");if(ZC.AK(o.K+"-main-c")&&o.clear(e,!1),"undefined"!=typeof ZC.A4Z&&(o.H2=new ZC.A4Z(o)),null===ZC._n_(e)){o.A9Y(),o.B8.B8["font-family"]&&(zingchart.FONTFAMILY=o.B8.B8["font-family"]);var c=!!o.o.gui;if(o.B8.load(o.o,"loader",!1,!0),o.assign_a([["gui","DF"],["globals","QP"]]),o.o.graphset&&1===o.o.graphset.length&&(i=o.o.graphset[0],null!==ZC._n_(t=i.gui)&&(o.DF=t),null!==ZC._n_(t=i.globals)&&(o.QP=t)),ZC._todash_(o.QP),ZC._cp_(o.B8.B8.root.gui,o.DF,!1,!0,!0),o.DF.behaviors)for(a=o.DF.behaviors.length-1;a>=0;a--)for(l=0;l<a;l++)if(o.DF.behaviors[a].id===o.DF.behaviors[l].id){o.DF.behaviors.splice(a,1);break}if(c||delete o.o.gui,ZC._todash_(o.DF),o.N={},null!==ZC._n_(t=o.o.style))for(n in t)"url"!==n&&(o.N[n]=t[n]);if(o.o.graphset&&1===o.o.graphset.length&&(i=o.o.graphset[0],null!==ZC._n_(t=i.style)))for(n in t)"url"!==n&&(o.N[n]=t[n]);ZC._todash_(o.N),o.NZ.graphset&&o.b(),o.assign_a([["locale","A14"],["set-locale","A14"],["layout","NF"],["h-space","A8B","i"],["v-space","A87","i"],["flat","K9","b"],["show-progress","A0L","b"]]),o.o.graphset&&1===o.o.graphset.length&&(i=o.o.graphset[0],null!==ZC._n_(t=i.locale)&&(o.A14=t),null!==ZC._n_(t=i["set-locale"])&&(o.A14=t),null!==ZC._n_(t=i.flat)&&(o.K9=ZC._b_(t)),null!==ZC._n_(t=i["show-progress"])&&(o.A0L=ZC._b_(t))),null!==ZC._n_(t=zingchart.i18n[o.A14])&&(ZC.HJ=t),o.AG=[]}var h=0,C=0,u=o.I,d=o.F;if(null!==ZC._n_(o.o.margin)||null!==ZC._n_(o.o["margin-top"])||null!==ZC._n_(o.o["margin-right"])||null!==ZC._n_(o.o["margin-bottom"])||null!==ZC._n_(o.o["margin-left"])){var A=new ZC.HL(o);A.append(o.o,!1,!1),A.parse(),h=A.DY,C=A.E8,u=u-A.DY-A.E9,d=d-A.E8-A.DR}var p,g,Z=o.OQ(e);if(null!==ZC._n_(p=o.o.graphset)){var f=0;for(a=0,r=p.length;a<r;a++)g=0,null!==ZC._n_(t=p[a].page)&&(g=ZC._i_(t)),f+=o.L3===g?1:0;var _=ZC.AQ.A2C(o.NF,f),b=ZC._i_(_[0]),m=ZC._i_(_[1]),v=0,E=0,D=0;for(a=0,r=p.length;a<r;a++){if(g=0,null===Z&&null!==ZC._n_(t=p[a].page)&&(g=ZC._i_(t)),(null===Z||D===Z.L)&&o.L3===g){if(o.AG[D]=o.AAG(p[a].type||"null",a),o.AG[D].OG=o.AG[D].AF+"graph",o.B8.load(o.AG[D].o,"graph"),o.B8.load(o.AG[D].o,p[a].type||"null"),o.AG[D].append(o.o.graph),o.AG[D].append(p[a]),o.AG[D].L=D,null===ZC._n_(p[D].id)||""===p[D].id?o.AG[D].K=o.K+"-graph-id"+D:o.AG[D].K=o.K+"-graph-"+p[a].id,p.length>0){for(var w=0,x=0,B=ZC._i_((u-(m+1)*o.A8B)/m),y=ZC._i_((d-(b+1)*o.A87)/b),K=["x","y","width","height"],F=0;F<K.length;F++)null!==ZC._n_(o.E["graph-"+D+"-"+K[F]])&&(delete o.E["graph-"+D+"-"+K[F]],delete o.AG[D].o[K[F]]);null===ZC._n_(o.AG[D].o.x)?o.E["graph-"+D+"-x"]=o.AG[D].o.x=ZC._i_(o.iX+(v+1)*o.A8B+v*B)+h:(w=ZC.II(o.AG[D].o.x))<1&&(w=ZC._i_(o.I*w)),null===ZC._n_(o.AG[D].o.y)?o.E["graph-"+D+"-y"]=o.AG[D].o.y=ZC._i_(o.iY+(E+1)*o.A87+E*y)+C:(x=ZC.II(o.AG[D].o.y))<1&&(x=ZC._i_(o.F*x)),null===ZC._n_(o.AG[D].o.width)&&(o.E["graph-"+D+"-width"]=o.AG[D].o.width=Math.max(B,B-w)),null===ZC._n_(o.AG[D].o.height)&&(o.E["graph-"+D+"-height"]=o.AG[D].o.height=Math.max(y,y-x))}o.AG[D].parse()}o.L3===g&&(D++,++v===m&&(E++,v=0))}}null===ZC._n_(e)&&null!==ZC._n_(t=o.o.refresh)&&(o.HP={type:"full",interval:10},ZC._cp_(t,o.HP))},A41:function(e,t){t=t||"";var i=[];for(var n in e)if("object"==typeof e[n])for(var a=this.A41(e[n],t+"."+n),r=0,l=a.length;r<l;r++)-1===ZC.AV(i,a[r])&&i.push(a[r]);else{var o=t+"."+n;"background-image"!==n&&"backgroundImage"!==n||""===e[n]||"zc."===e[n].substring(0,3)||(!ZC.ie67&&ZC.PATTERNS&&"PATTERN_"===e[n].substring(0,8)&&(e[n]=ZC.PATTERNS[e[n].substring(8)]),"!"===e[n].charAt(0)&&(e[n]=e[n].substring(1),this.E["safe-images"]=this.E["safe-images"]||[],this.E["safe-images"].push(e[n])),i.push([e[n],"image"])),"src"===n&&""!==e[n]&&"zc."!==e[n].substring(0,3)&&-1!==o.indexOf(".images.")&&(!ZC.ie67&&ZC.PATTERNS&&"PATTERN_"===e[n].substring(0,8)&&(e[n]=ZC.PATTERNS[e[n].substring(8)]),"!"===e[n].charAt(0)&&(e[n]=e[n].substring(1),this.E["safe-images"]=this.E["safe-images"]||[],this.E["safe-images"].push(e[n])),i.push([e[n],"image"])),".csv"===o.substr(o.length-4,4)&&"string"==typeof e[n]&&i.push([e[n],"csv"]),"url"===n&&(-1!==o.indexOf(".style.")&&i.push([e[n],"css"]),-1!==o.indexOf(".csv.")&&i.push([e[n],"csv"]),-1!==o.indexOf(".marker.")&&i.push([e[n],"image"])),"string"==typeof e[n]&&"url"!==n&&(0===e[n].indexOf("url:")&&"values"===n||0===e[n].indexOf("javascript:"))&&-1===ZC.AV(["format","text","tooltipText"],ZC.EE(n))&&i.push([e[n],"data"])}return i},QH:function(J7){var s=this;if(zingchart.DEV.RESOURCES){var J4=s.A41(s.o).concat(s.A41(s.ML));if(0!==J4.length){var UQ=0,LH={},A1W=0;s.E["safe-images"]=s.E["safe-images"]||[];var C4=window.setInterval(function(){if(UQ>=J4.length){for(var e in window.clearInterval(C4),s.ABM(s.o),LH)if(0!==e.indexOf("data:")&&-1===ZC.AV(s.E["safe-images"],e))try{var t=document.createElement("canvas");t.width=LH[e].width,t.height=LH[e].height,t.getContext("2d").drawImage(LH[e],0,0);var i=t.toDataURL("image/png");LH[e].onload=null,LH[e].onerror=null,LH[e].src=i,ZC.cache.data[e]=LH[e]}catch(n){}window.setTimeout(function(){zingchart.XZ[s.K]&&J7()},1)}else A2Q(++A1W)},20);A2Q(A1W)}else zingchart.XZ[s.K]&&J7()}else zingchart.XZ[s.K]&&J7();function A2Q(i){if(!(i>=J4.length)){var EW,MG,KD=J4[i][0],A0I=J4[i][1];if("url:"===KD.substring(0,4)){var QM=KD.substring(4);s.QS["url:"+QM]="[]";try{EW=["query-string"===s.MZ?"zcrandom="+Math.random():""].join("&"),ZC.A5.ajax({type:"GET",url:QM,beforeSend:function(e){s.RS.data||"http-headers"!==s.MZ||e.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:EW,error:function(e,t,i,n){return s.NU({name:"Network error",message:"Resource not found ("+n+")"},"URL Data loader"),!1},success:function(e,t,i,n){s.QS["url:"+n]=e,UQ++}})}catch(JA){return s.NU(JA,"URL Data loader"),!1}}else if("javascript:"===KD.substring(0,11))if("zc.ext.load"===s.QS[KD]){s.QS[KD]="[]";var DW=ZC.AP.AAH(KD.substring(11)),O={id:s.K,resource:KD,callback:function(e){s.QS[KD]=e,UQ++}},ZY=DW[0];O.arguments=DW[1];try{var ZN=eval(ZY).call(s,O);null!==ZC._n_(ZN)&&ZN&&(s.QS[KD]=ZN,UQ++)}catch(JA){return s.NU(JA,"JavaScript data loader"),!1}}else UQ++;else"image"===A0I?(LH[KD]=new Image,LH[KD].crossOrigin="anonymous",LH[KD].onload=function(){UQ++},LH[KD].onerror=function(){var e=ZC._b_(s.o.strict);if(ZC.IMG404.push(KD),e)return s.NU({name:"Network error",message:"Resource not found ("+this.src+")"},"Resource loader (image)"),!1;this.src=ZC.BLANK,UQ++},LH[KD].src=KD,ZC.cache.data[KD]=LH[KD]):"css"===A0I?(EW=["query-string"===s.MZ?"zcrandom="+Math.random():""].join("&"),ZC.A5.ajax({type:"GET",url:KD,beforeSend:function(e){s.RS.css||"http-headers"!==s.MZ||e.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:EW,error:function(e,t,i){return s.NU(i,"Resource loader"),!1},success:function(e){for(var t={},i=e.match(/[a-zA-Z0-9\.\#\-](.+?)\{((.|\s)+?)\}/gi),n=0,a=i.length;n<a;n++){MG=i[n].split("{");var r=ZC.GV(MG[0]),l=r.split(/\s+/);if(1===l.length||2===l.length&&ZC.GV(l[0])==="#"+s.K){t[r=ZC.GV(1===l.length?l[0]:l[1])]||(t[r]={});for(var o=0,c=(MG=MG[1].replace("}","").split(";")).length;o<c;o++){var h=MG[o].split(":");2===h.length&&(t[r][ZC.GV(h[0])]=""+ZC.GV(h[1]))}}}null!==ZC._n_(s.o.style)?ZC._cp_(t,s.o.style):null!==ZC._n_(s.o.graphset)&&1===s.o.graphset.length&&s.o.graphset[0].style&&ZC._cp_(t,s.o.graphset[0].style),UQ++}})):"csv"===A0I&&(EW=["query-string"===s.MZ?"zcrandom="+Math.random():""].join("&"),ZC.A5.ajax({type:"GET",url:KD,beforeSend:function(e){s.RS.csv||"http-headers"!==s.MZ||e.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:EW,error:function(e,t,i){return s.NU(i,"Resource loader"),!1},success:function(e,t,i,n){s.A9P[n]=e,UQ++}}))}}},ABM:function(C0){var s=this;for(var p in C0)if("object"==typeof C0[p])s.ABM(C0[p]);else for(var EW in s.QS)EW===C0[p]&&(C0[p]=eval(s.QS[EW]))},resize:function(e){var t,i,n,a,r=this;if(r.E.resize=!0,r.E.wh=r.I+"/"+r.F,r.o.graphset)if(r.A1K)zingchart.exec(r.K,"destroy"),zingchart.render(zingchart.params[r.K]);else{for(void 0===e&&(e=!1),i=0;i<r.AG.length;i++)null!==ZC._n_(r.H2)&&r.H2.IM&&r.H2.TZ(null),null!==ZC._n_(r.AG[i].HS)&&r.AG[i].HS.IM&&r.AG[i].HS.M7(null),null!==ZC._n_(r.AG[i].HQ)&&r.AG[i].HQ.IM&&r.AG[i].HQ.M7(null),null!==ZC._n_(r.AG[i].B9)&&r.AG[i].B9.A3X&&r.AG[i].B9.TH();if(ZC.AP.BY("resize",r,r.FE()),e=!1);else{for(i=0;i<r.AG.length;i++)for(a=0;a<r.AG[i].AY.A4.length;a++)r.E["g-"+i+"-p-"+a+".visible"]=r.AG[i].E["plot"+a+".visible"];for(i=0;i<r.AG.length;i++)r.E["g-"+r.AG[i].L+"-selection"]=JSON.stringify(r.AG[i].CB);for(var l=r.o.graphset,o=["labels","shapes"],s=0,c=l.length;s<c;s++)for(var h=0;h<o.length;h++){var C=o[h],u=[];if(null!==ZC._n_(l[s][C])){for(i=0,n=l[s][C].length;i<n;i++)l[s][C][i].generated||u.push(l[s][C][i]);l[s][C]=u}}if(r.XO(r.o),r.o=ZC.AP.BY("dataparse",r,r.FE(),r.o),ZC.A5("#"+r.K+"-top").width(r.I).height(r.F),r.E["from-api"]&&(ZC.A5("#"+r.K+"-wrapper").width(r.I).height(r.F),delete r.E["from-api"]),1===(t=ZC.A5("#"+r.K+"-img")).length&&t.width(r.I).height(r.F).css("clip","rect(1px,"+(r.I-1)+"px,"+(r.F-1)+"px,1px)"),"svg"===r.AA&&(r.KE.setAttribute("width",r.I),r.KE.setAttribute("height",r.F)),"canvas"===r.AA||"vml"===r.AA){for(ZC.A5("#"+r.K+"-main").width(r.I).height(r.F),i=0,n=r.AG.length;i<n;i++)ZC.A5("#"+r.AG[i].K+"-hover").remove();ZC.A5("#"+r.K+"-main>div").width(r.I).height(r.F)}for("canvas"===r.AA&&((t=ZC.AK(r.K+"-main-c"))&&(t.width=r.I,t.height=r.F),(t=ZC.AK(r.K+"-main-c-top"))&&(t.width=r.I,t.height=r.F),ZC.A5("#"+r.K+"-objects-bottom canvas, #"+r.K+"-objects-top canvas, #"+r.K+"-tools canvas").each(function(){this.width=r.I,this.height=r.F})),"vml"===r.AA&&ZC.A5("#"+r.K+"-objects-bottom div, #"+r.K+"-objects-top div, #"+r.K+"-tools div").each(function(){this.style.width=r.I+"px",this.style.height=r.F+"px"}),r.parse(),i=0,n=r.AG.length;i<n;i++)r.AG[i].U5&&r.AG[i].U5(),r.AG[i].HH=!0,r.AG[i].A6A=r.AG[i].GG,r.AG[i].GG=!1;for(r.paint(),i=0;i<r.AG.length;i++)for(a=0;a<r.AG[i].AY.A4.length;a++)delete r.E["g-"+i+"-p-"+a+".visible"];for(i=0;i<r.AG.length;i++)r.AG[i].HH=!1,r.AG[i].GG=r.AG[i].A6A,delete r.AG[i].A6A,delete r.E["g-"+r.AG[i].L+"-selection"]}}},clearGenerated:function(){var e=this.o.graphset,t=["labels","shapes"];if(e)for(var i=0,n=e.length;i<n;i++)for(var a=0;a<t.length;a++){var r=t[a],l=[];if(null!==ZC._n_(e[i][r])){for(var o=0,s=e[i][r].length;o<s;o++)e[i][r][o].generated||l.push(e[i][r][o]);e[i][r]=l}}},clear:function(e,t,i){var n=this;for(var a in n.E)-1!==a.indexOf("-label-")&&-1!==a.indexOf("-bounds")&&delete n.E[a];if(void 0===t&&(t=!0),ZC.A5("."+n.K+"-history-area").die("click",n.A0Q),ZC.A5("."+n.K+"-history-area").remove(),null!==ZC._n_(e))n.OQ(e).clear();else{t&&n.clearGenerated(),n._unbind_();for(var r=0,l=n.AG.length;r<l;r++)"vml"===n.AA&&i?n.AG[r].destroy():n.AG[r].clear();var o,s,c;null!==(o=ZC.AK(n.K+"-main-c"))&&ZC.Q.IU(o,n.AA,n.iX,n.iY,n.I,n.F),null!==(c=ZC.AK(n.K+"-main-c-top"))&&ZC.Q.IU(c,n.AA,n.iX,n.iY,n.I,n.F),null!==(s=ZC.AK(n.K+"-trigger-c"))&&(ZC.Q.IU(s,n.AA,n.iX,n.iY,n.I,n.F),ZC.A5("#"+n.K+"-menu-area").remove()),n.A7&&n.A7.hide(),ZC.A5("."+n.K+"-menu-item").remove(),ZC.Q.EU([n.K+"-menu-trigger",n.K+"-menu"]),ZC.Q.EU(n.K+"-license-text"),null!==n.IC&&ZC.Q.EU([n.K+"-history-path",n.K+"-history-back-path",n.K+"-history-forw-path",n.K+"-history-gradient",n.K+"-history-back-gradient",n.K+"-history-forw-gradient"])}},AAS:function(){var e,t,i,n=this,a=n.I+"/"+n.F,r=ZC.Q.HY({id:n.K+"-wrapper",position:"relative",p:ZC.AK(n.K)});ZC.Q.PJ(r,{height:"100%"===n.MT?n.MT:n.F+"px",width:"100%"===n.FZ?n.FZ:n.I+"px"}),n.bA11y&&ZC.Q.G3(r,{tabindex:0,"aria-label":"ZingChart "+n.P2});var l=ZC.Q.HY({cls:"zc-rel zc-top",wh:a,id:n.K+"-top",overflow:"hidden",position:"absolute",p:r});switch(zingchart.OFFSET&&(l.style.left="-0.5px",l.style.top="-0.5px"),n.AA){case"svg":n.KE=ZC.Q.F5("svg","http://www.w3.org/2000/svg"),n.KE.setAttributeNS&&n.KE.setAttributeNS(null,"xlink","http://www.w3.org/1999/xlink"),ZC.Q.G3(n.KE,{version:"1.1",id:n.K+"-svg","class":"zc-svg",width:n.I,height:n.F,display:"block"}),l.appendChild(n.KE);var o=ZC.Q.F5("defs","http://www.w3.org/2000/svg");if(o.id=n.K+"-defs",n.KE.appendChild(o),ZC.Q.JZ({cls:"zc-rel zc-main",wh:a,id:n.K+"-main",p:n.KE},n.AA),n.A24=[],n.o.graphset)for(e=0,t=n.o.graphset.length;e<t;e++)if((i=n.o.graphset[e].resources)&&i.length)for(var s=0;s<i.length;s++)if("css"===i[s].type&&i[s].url){var c=ZC.Q.F5("link","http://www.w3.org/2000/svg");ZC.Q.G3(c,{xmlns:"http://www.w3.org/1999/xhtml",href:i[s].url,rel:"stylesheet",type:"text/css"}),n.A24.push(i[s].url),o.appendChild(c)}break;case"vml":case"canvas":ZC.Q.HY({cls:"zc-rel zc-main",wh:a,id:n.K+"-main",p:l})}},paintHistory:function(){},paint:function(){var e=this;e.MA="paint";var t=e.I+"/"+e.F;if(e.A0C(),null===ZC.AK(e.K+"-top")){e.AAS();var i=ZC.AK(e.K+"-main");if(e.NZ.graphset&&ZC.Q.HC({cls:"zc-abs",id:e.K+"-main-c",wh:t,p:i},e.AA),e.H.usc())ZC.Q.HC({cls:"zc-abs",id:e.K+"-main-c-top",wh:t,p:i},e.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-print-c",p:i,wh:t,display:"none"},e.AA);else{ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-objects-bottom",p:i},e.AA),zingchart.DEV.MAPSONBOTTOM&&ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-objects-maps",p:i},e.AA),ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-graphset",p:i},e.AA),zingchart.DEV.MAPSONBOTTOM||ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-objects-maps",p:i},e.AA),ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-objects-top",p:i},e.AA),ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-hover",p:i},e.AA),ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-objects-front",p:i},e.AA),ZC.Q.JZ({cls:"zc-abs zc-text",wh:t,id:e.K+"-text",p:i},e.AA);var n="legend",a="tools";("legend"===e.o["top-layer"]||e.o.graphset&&1===e.o.graphset.length&&"legend"===e.o.graphset[0]["top-layer"])&&(n="tools",a="legend"),ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-"+n,p:i},e.AA),ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-"+a,p:i},e.AA);var r=ZC.AK(e.K+"-tools");e.NZ["static"]&&ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-static-c",wh:t,p:r},e.AA),e.NZ.guide&&ZC.Q.HC({cls:"zc-abs zc-layer zc-guide-c",id:e.K+"-guide-c",wh:t,p:r},e.AA),(ZC.A5.browser.opera&&ZC._i_(ZC.A5.browser.version)<=9.5||ZC.mobile||"classic"!==e.LL)&&ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-trigger-c",wh:t,p:r},e.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-print-c",p:r,wh:t,display:"none"},e.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-textprint-c",p:r,wh:t,display:"none"},e.AA),ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-text-top",p:i},e.AA)}if(!zingchart.DEV.SKIPTRACKERS){var l=document.createElement("img");if(l.id=e.K+"-img",l.className="zc-img",l.setAttribute("useMap","#"+e.K+"-map"),l.setAttribute("alt","ZingChart "+e.P2),ZC.Q.PJ(l,{position:"absolute",borderWidth:0,width:e.I+2*ZC.MAPTX+"px",height:e.F+2*ZC.MAPTX+"px",left:-ZC.MAPTX+"px",top:-ZC.MAPTX+"px",zIndex:0,opacity:0,filter:"alpha(opacity=0)",clip:"rect("+(ZC.MAPTX+1)+"px,"+(e.I+ZC.MAPTX-1)+"px,"+(e.F+ZC.MAPTX-1)+"px,"+(ZC.MAPTX+1)+"px)"}),l.src=(ZC.ie67?"//":"")+ZC.BLANK,ZC.AK(e.K+"-top").appendChild(l),!e.H.usc()){var o=document.createElement("map");o.className="zc-map",ZC.Q.G3(o,{id:e.K+"-map",name:e.K+"-map"}),ZC.AK(e.K+"-top").appendChild(o);for(var s=0;s<e.AG.length;s++)o.innerHTML+='<area shape="rect" coords="0,0,1,1" id="mark'+s+'">'}}}e.Z=ZC.AK(e.K+"-main-c"),e.b();var c,h,C=!1,u=!1;for(c=0,h=e.AG.length;c<h;c++){e.AG[c].paint(),(null!==e.AG[c].CX&&e.AG[c].CX.AN||null!==e.AG[c].HA&&e.AG[c].HA.AN)&&(C=!0);for(var d=0;d<e.AG[c].BO.length;d++)if(e.AG[c].BO[d].GO){u=!0;break}}if(e.G1){for(var A in e.G1)ZC.AK(A).appendChild(e.G1[A]);e.G1=null}if(e.E.preservezoom=null,e.TJ||e.UN||(e.Z3?e.A91():e.Z3=window.setInterval(function(){e.A8N(),e.TJ||e.UN?(window.clearInterval(e.Z3),ZC.Q.EU(e.K+"-license-text")):ZC.AK(e.K+"-license-text")||e.A91()},2e3)),ZC.A5("."+e.K+"-node-area").live("focus",function(e){var t=e.target.id.split("-");"plot"===t[4]&&"node"===t[6]&&zingchart.exec(t[0],"showtooltip",{graphid:t[2],plotindex:t[5],nodeindex:t[7]})}),-1===ZC.AV(e.KR,"skip_context_menu")&&e.A5T(),-1===ZC.AV(e.KR,"skip_interactivity")?("undefined"!=typeof ZC.A27&&(e.A7=new ZC.A27(e)),u&&e.H2.bind(),C&&"undefined"!=typeof ZC.JS&&(e.D7=new ZC.JS(e),e.D7.bind()),ZC.mobile&&(e.AFW=function(t){ZC.swipe={xy:ZC.Q.MB(t),ts:(new Date).getTime()},t.target.id===e.K+"-menu-area"?(ZC.move=!1,e.A7&&e.A7.hide(),zingchart.YS(t)):(null===e.DF||null===ZC._n_(e.DF["page-scroll"])||e.DF["page-scroll"]||t.preventDefault(),ZC.move=!1,e.hideCM(),e.A7&&e.A7.hide(),e.YI(t))},e.OU=function(){window.clearTimeout(e.AAW),e.A3S=null},e.AFT=function(t){if(ZC.swipe){var i=ZC.Q.MB(t);if(ZC._a_(i[0]-ZC.swipe.xy[0])>100&&(new Date).getTime()-ZC.swipe.ts<1e3){var n=e.FE();n.direction=i[0]>ZC.swipe.xy[0]?"right":"left",ZC.AP.BY("swipe",e,n)}ZC.swipe=null}e.AA2||ZC.move||zingchart.SB(t),e.OU(t)},ZC.A5("#"+e.K+"-img").bind("touchstart",e.AFW).bind("touchmove",e.OU).bind("touchend",e.AFT),ZC.A5("#"+e.K+"-menu-area").live("touchstart",e.AFW)),e.zc_loader_mousewheel=function(t){var i=e.FE();i.ev=t,ZC.AP.BY("mousewheel",e,i)},ZC.A5("#"+e.K+"-img").bind("mousewheel",e.zc_loader_mousewheel),ZC.A5("#"+e.K+"-map").bind("mousewheel",e.zc_loader_mousewheel),"svg"===e.AA&&ZC.A5("#"+e.K+"-svg").bind("mousewheel",e.zc_loader_mousewheel),e.A25=function(t){27===t.keyCode&&e.QZ&&(e.A7S||e.A95())},ZC.A5(document).bind("keyup",e.A25),e.A95=function(){ZC.A5("#"+e.K+"-menu-item-exitfullscreen").die("click",e.A95),ZC.FSSTATUS=null,ZC.Q.EU(e.K+"-data-table"),e.destroy(),zingchart.FSID&&ZC.AK(zingchart.FSID)&&(ZC.AK(zingchart.FSID).style.display="none")},ZC.A5("#"+e.K+"-menu-item-exitfullscreen").live("click",e.A95)):ZC.mobile&&(e.zc_loader_touchstart_static=function(e){return e.preventDefault(),zingchart.SB(e),!1},ZC.A5("#"+e.K+"-img").bind("touchstart",e.zc_loader_touchstart_static)),null!==e.HP){var p=ZC._i_(e.HP.interval);p=p>=50?p:1e3*p,window.setTimeout(function(){e.N3(),e.load()},p)}e.MA="",ZC.TS[e.K]=(new Date).getTime()-ZC.TS[e.K],e.E["fire-complete"]&&(ZC.AP.BY("complete",e,e.FE()),e.E["fire-complete"]=null),e.E["fire-load"]&&(ZC.AP.BY("load",e,e.FE()),e.E["fire-load"]=null)},togglePreviewMasks:function(e){for(var t=this,i=0;i<t.AG.length;i++)t.AG[i].B9&&t.AG[i].B9.toggleMasks(e)},createPreviewMasks:function(){var e=this,t=document.createElement("canvas");t.width=e.I,t.height=e.F,t.setAttribute("class","");for(var i=0;i<e.AG.length;i++)e.AG[i].B9&&e.AG[i].B9.toggleMasks(!0,t);return t},AGC:function(){null===ZC._n_(ZC.showZCAbout)&&(ZC.showZCAbout=function(e){zingchart.exec(e.id,"toggleabout")}),zingchart.exec(this.K,"addmenuitem",{text:"About ZingChart","function":"ZC.showZCAbout()",order:100})},A91:function(){var e,t=this,i={},n=t.DF.watermark;t.B8.load(i,"loader.gui.watermark"),n&&ZC._cp_(n,i),1===t.o.graphset.length&&t.o.graphset[0].gui&&(e=t.o.graphset[0].gui.watermark)&&ZC._cp_(e,i);var a=ZC._l_(ZC._i_(i.type||1),1,2),r=i.position||"br";-1===ZC.AV(["tl","tr","br","bl"],r)&&(r="br"),t.ACS=r;var l,o=32,s=146,c=0,h=1;ZC.ie67&&(o=30,s=168,c=8,h=1),s=126,o=22;var C={light:["#6D6E71","#00384A"],dark:["#FFFFFF","#09A9DA"]},u=C.light;if(zingchart.THEME&&(u="light"===t.LL||"classic"===t.LL?C.light:C.dark),1===t.o.graphset.length)if(t.o.graphset[0]["background-color"]){var d=ZC.AP.GC(t.o.graphset[0]["background-color"]);7===d.length&&(u=ZC.AP.AA9(d,C.dark,C.light))}else if(t.o.graphset[0].theme){var A=t.o.graphset[0].theme;u="light"===A||"classic"===A?C.light:C.dark}var p,g,Z="undefined"!=typeof window&&window.location?window.location.origin:"",f="undefined"!=typeof window&&window.location?window.location.pathname:"";switch(l='<a title="JavaScript Charts by ZingChart" style="color:'+u[0]+' !important;font-size:11px !important;display:block !important;opacity:1 !important; text-decoration:none;" href="http://www.zingchart.com/?origin='+Z+"&pathname="+f+'">Powered by <span style="color:'+u[1]+'; font-weight:bold;">ZingChart</span></a>',r){case"br":p=t.F-o,g=t.I-s;break;case"bl":p=t.F-o,g=6;break;case"tr":p=2,g=t.I-s;break;case"tl":p=2,g=6}null!==ZC._n_(e=ZC.AK(t.K+"-top"))&&ZC.Q.HY({cls:ZC.ie67?"-ie67":"",p:e,id:t.K+"-license-text",tl:p+"/"+g,wh:s+"/"+(o-c),color:ZC.ie67?1===a?"#369":"#fff":"",padding:c,opacity:h,position:"absolute",cursor:"pointer",fontFamily:zingchart.FONTFAMILY,html:l})},_unbind_:function(){var e=this;ZC.A5("#"+e.K+"-menu").die("mousedown",e.TM),ZC.A5("."+e.K+"-menu-item").die("mousedown",e.TM),ZC.A5("."+e.K+"-menu-item").die("click touchend",e.AGR).die("mouseover",e.AG8).die("mouseout",e.AGN),e.E["menu-item-events"]=!1,ZC.A5("."+e.K+"-node-area").die("focus"),null!==e.H2&&e.H2.unbind(),null!==e.D7&&e.D7.unbind(),ZC.mobile&&(ZC.A5("#"+e.K+"-img").unbind("touchstart",e.AFW).unbind("touchmove",e.OU).unbind("touchend",e.AFT),ZC.A5("#"+e.K+"-menu-area").die("touchstart",e.AFW),ZC.A5("#"+e.K+"-img").unbind("touchstart",e.zc_loader_touchstart_static)),ZC.A5("#"+e.K+"-img").unbind("mousewheel",e.zc_loader_mousewheel),ZC.A5("#"+e.K+"-map").unbind("mousewheel",e.zc_loader_mousewheel),"svg"===e.AA&&ZC.A5("#"+e.K+"-svg").unbind("mousewheel",e.zc_loader_mousewheel),ZC.A5(document).unbind("keyup",e.A25),ZC.A5("#"+e.K+"-menu-item-exitfullscreen").die("click",e.A95)},VL:function(e,t,i){void 0===i&&(i=!1);var n=ZC.AK("zc-menu-"+(i?"sep":"item")+"-"+e);n&&(n.style.display=t?"block":"none")},A5T:function(LC,ev){if(!zingchart.DEV.SKIPCONTEXTMENU){var s=this,G,i,A6,j,J8;void 0===LC&&(LC=-1);var DF={};ZC._cp_(s.DF,DF),-1!==LC&&s.o.graphset[LC]&&ZC._cp_(s.o.graphset[LC].gui,DF,null,null,!0),ZC.A5("#"+s.K+"-menu").remove();var PF=[];for("undefined"==typeof ZC.AO&&PF.push({id:"3D",enabled:"none"},{id:"SwitchTo3D",enabled:"none"},{id:"SwitchTo2D",enabled:"none"}),i=DF.behaviors.length-1;i>0;i--)for(var sBId=DF.behaviors[i].id,ii=i-1;ii>=0;ii--)DF.behaviors[ii].id===sBId&&DF.behaviors.splice(ii,1);if(null!==ZC._n_(G=DF.behaviors))for(i=0,A6=G.length;i<A6;i++){var N9=!1;for(j=0,J8=PF.length;j<J8;j++)PF[j].id===G[i].id&&(N9=!0);N9||PF.push(G[i])}var JH=DF["context-menu"],OI=DF["context-menu[mobile]"];for(i=0,A6=PF.length;i<A6;i++)null!==ZC._n_(PF[i]["function"])&&(null===ZC._n_(JH)&&(JH={}),null===ZC._n_(JH["custom-items"])&&(JH["custom-items"]=[]),JH["custom-items"].push(PF[i]));JH["custom-items"]&&JH["custom-items"].sort(function(e,t){return ZC._i_(e.order||"0")>ZC._i_(t.order||"0")}),s.MY=new ZC.DN(s);var A15=s.LL.split(/\s+|;|,/),E0,LB,U7,ABA,GS;for(i=0,A6=A15.length;i<A6;i++)if(s.B8.NY[A15[i]]){var A10=s.B8.NY[A15[i]].root||{};A10&&A10.gui&&A10.gui.contextMenu&&ZC._cp_(A10.gui.contextMenu,s.MY.o)}if(s.B8.load(s.MY.o,"loader.gui.context-menu"),JH&&s.MY.append(JH),ZC.mobile&&(s.B8.load(s.MY.o,"loader.gui.context-menu[mobile]"),OI&&s.MY.append(OI)),s.MY.V2=!0,s.MY.parse(),s.MY.AN||!s.A3D){if(!ZC.AK(s.K+"-menu-area")){var A55=!!(s.DF&&s.DF["context-menu"]&&s.DF["context-menu"].button)&&ZC._n_(s.DF["context-menu"].button.visible);if(A55||"classic"!==s.LL&&A55){GS=new ZC.DN(s),s.B8.load(GS.o,"loader.gui.context-menu.button"),JH&&ZC._n_(null!==(G=JH.button))&&GS.append(G),ZC.mobile&&(s.B8.load(GS.o,"loader.gui.context-menu[mobile].button"),OI&&null!==ZC._n_(G=OI.button)&&GS.append(G)),ZC._cp_(s.MY.o,JH);var A6E="left"===JH.position||"classic"===s.LL;if(GS.K=s.K+"-menu-trigger",GS.IL=ZC.AK(s.K+"-tools"),GS.Z=GS.C7=ZC.AK(s.K+"-trigger-c"),GS.V2=!0,GS.parse(),GS.AN){GS.paint();var DD=ZC.A5("#"+s.H.K+"-top");if(""===GS.AM){var N0=new ZC.DT(s);if(N0.CZ=!1,s.B8.load(N0.o,"loader.gui.context-menu.gear"),JH&&null!==ZC._n_(G=JH.gear)&&N0.append(G),ZC.mobile&&(s.B8.load(N0.o,"loader.gui.context-menu[mobile].gear"),OI&&null!==ZC._n_(G=OI.gear)&&N0.append(G)),N0.K=s.K+"-menu-trigger-gear",N0.IL=ZC.AK(s.K+"-tools"),N0.Z=ZC.AK(s.K+"-trigger-c"),N0.iX=A6E?GS.iX+GS.I/2:DD.width()-(GS.iX+GS.I/2),N0.iY=GS.iY+GS.F/2,N0.AI=ZC.CY(GS.I,GS.F)/4.5,N0.parse(),N0.paint(),"hamburger"!==N0.DU){var QI=new ZC.DT(s);QI.copy(GS),QI.K=s.K+"-menu-trigger-gear-hole",QI.IL=ZC.AK(s.K+"-tools"),QI.Z=ZC.AK(s.K+"-trigger-c"),QI.DU="circle",QI.AI=ZC.CY(GS.I,GS.F)/7,QI.parse(),QI.iX=A6E?GS.iX+GS.I/2:DD.width()-(GS.iX+GS.I/2),QI.iY=GS.iY+GS.F/2,QI.paint()}}var _iX=A6E?GS.iX:DD.width()-(GS.iX+GS.I);ZC.AK(s.K+"-map").innerHTML+=ZC.Q.G0("rect")+'id="'+s.K+'-menu-area" coords="'+ZC._i_(_iX+ZC.MAPTX)+","+ZC._i_(GS.iY+ZC.MAPTX)+","+ZC._i_(_iX+GS.I+ZC.MAPTX)+","+ZC._i_(GS.iY+GS.F+ZC.MAPTX)+'" />'}}}E0=new ZC.DN(s),s.B8.load(E0.o,"loader.gui.context-menu.item"),JH&&null!==ZC._n_(G=JH.item)&&E0.append(G),ZC.mobile&&(s.B8.load(E0.o,"loader.gui.context-menu[mobile].item"),OI&&null!==ZC._n_(G=OI.item)&&E0.append(G)),E0.V2=!0,E0.parse(),LB=new ZC.DN(s),LB.copy(E0),s.B8.load(LB.o,"loader.gui.context-menu.item.hover-state"),JH&&null!==ZC._n_(JH.item)&&null!==ZC._n_(G=JH.item["hover-state"])&&LB.append(G),ZC.mobile&&(s.B8.load(LB.o,"loader.gui.context-menu[mobile].item.hover-state"),OI&&null!==ZC._n_(OI.item)&&null!==ZC._n_(G=OI.item["hover-state"])&&LB.append(G)),LB.V2=!0,LB.parse(),U7={},JH&&null!==ZC._n_(JH.separator)&&(U7=JH.separator);var JU=[],EJ=null;if(ABA=null!==ZC._n_(s.MY.o.empty)&&ZC._b_(s.MY.o.empty),ZC.mobile&&(EJ=G7("PageScroll"),"none"!==EJ.enabled&&(null===s.DF||null===ZC._n_(s.DF["page-scroll"])||s.DF["page-scroll"]?JU.push(GU("disablepagescroll",EJ.text)):JU.push(GU("enablepagescroll",EJ.text)),JU.push(J6("pagescroll")))),EJ=G7("Reload"),"none"!==EJ.enabled&&(JU.push(GU("reload",EJ.text)),JU.push(J6("reload"))),"undefined"!=typeof ZC.A7X){EJ=G7("SaveAsImage"),"none"!==EJ.enabled&&(EJ=G7("SaveAsImagePNG"),"none"!==EJ.enabled&&JU.push(GU("viewaspng",EJ.text?EJ.text:null)),EJ=G7("SaveAsImageJPG"),"none"!==EJ.enabled&&JU.push(GU("viewasjpg",EJ.text?EJ.text:null)),JU.push(J6("export")));var TE=["DownloadPDF","DownloadSVG","DownloadCSV","DownloadXLS","ViewDataTable","ExportData","Print"],A63=0,A23=0;for(i=0;i<TE.length;i++)"ViewDataTable"===TE[i]&&ZC.AK(s.K+"-data-table")&&(TE[i]="HideDataTable"),EJ=G7(TE[i]),"none"!==EJ.enabled&&(A63++,A23=i,JU.push(GU(TE[i].toLowerCase(),EJ.text)));A63>0&&JU.push(J6(TE[A23].toLowerCase()))}if(-1!==LC){var GO=!1;for(j=0,J8=s.AG[LC].BO.length;j<J8;j++)s.AG[LC].BO[j].GO&&(GO=!0);if(GO&&"undefined"!=typeof ZC.A4Z){var A13=!1;EJ=G7("ZoomIn"),"none"!==EJ.enabled&&(JU.push(GU("zoomin",EJ.text)),A13=!0),EJ=G7("ZoomOut"),"none"!==EJ.enabled&&(JU.push(GU("zoomout",EJ.text)),A13=!0),EJ=G7("ViewAll"),"none"!==EJ.enabled&&(JU.push(GU("viewall",EJ.text)),A13=!0),A13&&JU.push(J6("zoom"))}}var b2D=!1,b3D=!1;if(-1!==LC&&(-1!==ZC.AV(["line","area","bar","vbar","hbar","pie","mixed"],s.AG[LC].AF)&&(b2D=!0,s.XH="2d"),-1!==ZC.AV(["line3d","area3d","bar3d","vbar3d","hbar3d","pie3d","mixed3d"],s.AG[LC].AF)&&(b3D=!0,s.XH="3d")),(b2D||b3D)&&(EJ=G7("3D"),"none"!==EJ.enabled&&(EJ=G7(b2D?"SwitchTo3D":"SwitchTo2D"),"none"!==EJ.enabled&&(JU.push(GU(b2D?"switchto3d":"switchto2d",EJ.text)),JU.push(J6("dimension"))))),-1!==LC){var C=s.AG[LC],AAR=!1,ABI=!1;for(j=0;j<C.BO.length;j++){var B=C.BO[j];0===B.BE.indexOf("scale-y")&&(AAR=!0),"log"===B.C1&&(ABI=!0)}AAR&&(EJ=G7("Progression"),"none"!==EJ.enabled&&(EJ=G7(ABI?"LinScale":"LogScale"),"none"!==EJ.enabled&&(JU.push(GU(ABI?"switchtolin":"switchtolog",EJ.text)),JU.push(J6("progression"))))),(C.CX||C.HA)&&(EJ=G7("Guide"),"none"!==EJ.enabled&&(EJ=G7(C.A1J?"HideGuide":"ShowGuide"),"none"!==EJ.enabled&&(JU.push(GU(C.A1J?"hideguide":"showguide",EJ.text)),JU.push(J6("guide")))))}var AAU=0,B6;if("undefined"!=typeof ZC.A8P&&(EJ=G7("ViewSource"),"none"!==EJ.enabled&&(JU.push(GU("viewsource",EJ.text)),AAU++),EJ=G7("BugReport"),"none"!==EJ.enabled&&(JU.push(GU("bugreport",EJ.text)),AAU++)),AAU>0&&JU.push(J6("tools")),EJ=G7("FullScreen"),"none"===EJ.enabled||s.LS||(s.QZ?(EJ=G7("ExitFullScreen"),JU.push(GU("exitfullscreen",EJ.text)),JU.push(J6("exitfullscreen"))):(JU.push(GU("fullscreen",EJ.text)),JU.push(J6("fullscreen")))),s.IC&&(EJ=G7("GoBack"),"none"!==EJ.enabled&&JU.push(GU("goback",EJ.text)),EJ=G7("GoForward"),"none"!==EJ.enabled&&JU.push(GU("goforward",EJ.text)),JU.push(J6("history"))),JU.length>0&&-1!==JU[JU.length-1].indexOf("zc-menu-sep")&&JU.splice(JU.length-1,1),s.A1T={},-1!==LC)if(JH&&null!==ZC._n_(B6=JH["custom-items"]))for(JU.length>0&&JU.push(J6("custom")),i=0,A6=B6.length;i<A6;i++){var A3L=!0;if(null!==ZC._n_(B6[i].enabled)&&("none"===B6[i].enabled?A3L=!1:"all"!==B6[i].enabled&&(A3L=!ev||eval(B6[i].enabled).call(s,zingchart.A0A(ev,s),B6[i].id,ev))),A3L){var AM,K=B6[i].id||"custom-"+i;"sep"===B6[i].id||"sep"===B6[i].type?JU.push(J6(K,!0)):"header"===B6[i].type?(AM=B6[i].text||"Custom Menu "+i,JU.push(A2R(K,AM,!0))):(AM=B6[i].text||"Custom Menu "+i,s.A1T[K]={fn:B6[i]["function"]||"",url:B6[i].url||"",target:B6[i].target||""},JU.push(GU(K,AM,!0)))}}s.TJ||(JU.push(J6("zingchart")),JU.push(GU("xmiabt","About ZingChart"))),ZC.Q.HY({id:s.K+"-menu",p:document.body,cls:"zc-menu zc-style",top:null===ZC._n_(GS)?0:GS.iY+GS.F/2,left:null===ZC._n_(GS)?0:GS.iX+GS.I/2,borderBottom:s.MY.AU+"px solid "+s.MY.BW,background:(-1===s.MY.A0?"transparent":s.MY.A0)+" "+A1P(s.MY.DA),paddingTop:s.MY.FM,paddingRight:s.MY.FN,paddingBottom:s.MY.FU,paddingLeft:s.MY.EQ,html:JU.join("")}),s.E["menu-item-events"]||(s.AGR=function(e){var t,i=1!==e.target.nodeType?e.target.parentNode.id:e.target.id,n=i.substring(0,i.indexOf("-menu-item-")),a=zingchart.getLoader(n);ZC.mobile&&a.OU();var r=a.A4A(a.SW[0],a.SW[1]);a.hideCM(),ZC.mobile&&zingchart.SB(e);var l=i.replace(a.K+"-menu-item-","");a.AAI({graphid:r?r.K:null,menuitemid:l,ev:ZC.A5.BZ(e)});var o=a.o["export-filename"]||a.o.graphset[0]["export-filename"]||"";switch(l){case"switchto2d":case"switchto3d":r&&a.A54(r.K);break;case"enablepagescroll":s.DF=s.DF||{},s.DF["page-scroll"]=!0;break;case"disablepagescroll":s.DF=s.DF||{},s.DF["page-scroll"]=!1;break;case"showguide":a.Z7(r.K,!0);break;case"hideguide":a.Z7(r.K,!1);break;case"switchtolin":a.A0Y(r.K,"lin");break;case"switchtolog":a.A0Y(r.K,"log");break;case"reload":a.A8Y();break;case"viewaspng":a.OD("png");break;case"viewasjpg":a.OD("jpeg");break;case"downloadpdf":a.OD("pdf",""===o?null:{fn:o+".pdf"});break;case"downloadsvg":a.OD("svg",""===o?null:{fn:o+".svg"});break;case"exportdata":zingchart.exec(a.K,"exportdata");break;case"downloadcsv":zingchart.exec(a.K,"downloadCSV",""===o?null:{fn:o});break;case"downloadxls":var c=a.o["export-sheetname"]||a.o.graphset[0]["export-sheetname"]||"ZingChart";(t=G7("DownloadXLS"))["custom-function"]?a.A47({graphid:r?r.K:null,menuitemid:l,filename:o,sheetname:c,"function":t["custom-function"]}):zingchart.exec(a.K,"downloadXLS",""===o?null:{fn:o,sn:c});break;case"viewdatatable":case"hidedatatable":zingchart.exec(a.K,"viewDataTable",{menuid:l});break;case"print":a.A98();break;case"viewsource":a.A5O();break;case"bugreport":a.A6T();break;case"fullscreen":a.A5W();break;case"goback":zingchart.exec(a.K,"goback");break;case"goforward":zingchart.exec(a.K,"goforward");break;case"zoomin":r&&(a.H2.C=r,a.A8X({graphid:r.K,ev:e}));break;case"zoomout":r&&(a.H2.C=r,a.A8D({graphid:r.K,ev:e}));break;case"viewall":r&&(a.H2.C=r,a.A8A({graphid:r.K,ev:e}));break;case"xmiabt":a.A9E();break;default:null!==ZC._n_(G=s.A1T[l])&&(""!==G.fn?a.A47({graphid:r?r.K:null,menuitemid:l,"function":G.fn}):""!==G.url&&r&&r.UZ(e,G.url,G.target))}},s.AG8=function(){this.style.backgroundColor=LB.A0,this.style.color=LB.C2,this.style.borderLeft=this.style.borderRight=LB.AU+"px solid "+LB.BW},s.AGN=function(){this.style.backgroundColor=E0.A0,this.style.color=E0.C2,this.style.borderLeft=this.style.borderRight=E0.AU+"px solid "+E0.BW},s.TM=function(e){return e.preventDefault(),!1},ZC.A5("#"+s.K+"-menu").live("mousedown",s.TM),ZC.A5("."+s.K+"-menu-item").live("mousedown",s.TM),ZC.A5("."+s.K+"-menu-item").live("click touchend",s.AGR).live("mouseover",s.AG8).live("mouseout",s.AGN),s.E["menu-item-events"]=!0)}}function A1P(e){return""!==e&&e?"url("+(0===e.indexOf("zc.")?ZC.IMAGES[e]:e)+")":"none"}function J6(e){return'<div id="'+s.K+"-menu-sep-"+e+'" class="zc-menu-sep" style="background-color:'+E0.A0+";background-image:"+A1P(E0.DA)+" repeat-x 50% 0%;border-bottom-width:"+U7["line-width"]+";border-bottom-color:"+U7["line-color"]+';">&nbsp;</div>'}function GU(e,t,i){t=t||ZC.HJ["menu-"+e];var n=void 0!==i&&i?" zc-custom-menu-item "+s.K+"-custom-menu-item":"";return'<div class="'+s.K+"-menu-item"+n+'" style="width:'+s.MY.o.width+";color:"+E0.C2+";font-family:"+E0.GH+";font-size:"+E0.DG+"px;background-color:"+E0.A0+";background-image:"+A1P(E0.DA)+" repeat-x 50% 0%;border-top:"+(ZC.ie67?E0.AU:1)+"px solid "+E0.BW+";border-left:"+E0.AU+"px solid "+E0.BW+";border-right:"+E0.AU+"px solid "+E0.BW+";padding:"+E0.FM+"px "+E0.FN+"px "+E0.FU+"px "+E0.EQ+"px;text-align:"+E0.O8+";"+(ZC.HJ.rtl?"unicode-bidi:bidi-override;direction:rtl;":"")+'" id="'+s.K+"-menu-item-"+e+'">'+t+"</div>"}function A2R(e,t,i){var n=void 0!==i&&i?" zc-custom-menu-header "+s.K+"-custom-menu-header":"";return'<div class="zc-menu-header '+s.K+"-menu-header"+n+'" style="color:'+E0.C2+";background-color:#666;border-top:"+(ZC.ie67?E0.AU:1)+"px solid "+E0.BW+";border-left:"+E0.AU+"px solid "+E0.BW+";border-right:"+E0.AU+"px solid "+E0.BW+";padding:"+E0.FM+"px "+E0.FN+"px "+E0.FU+"px "+E0.EQ+"px;text-align:"+E0.O8+";"+(ZC.HJ.rtl?"unicode-bidi:bidi-override;direction:rtl;":"")+'" id="'+s.K+"-menu-item-"+e+'">'+t+"</div>"}function G7(e){var t={ViewAsImage:"SaveAsImage",ViewAsImagePNG:"SaveAsImagePNG",ViewAsImageJPG:"SaveAsImageJPG"};if(ABA)return{enabled:"none"};for(var i=0,n=PF.length;i<n;i++){if(PF[i].id===e)return PF[i];if(t[PF[i].id]&&t[PF[i].id]===e)return PF[i]}return{enabled:"all"}}},destroy:function(){this._unbind_(),zingchart.HZ.length-=1,this.clear(),ZC.A5("#zc-fullscreen").remove(),document.body.style.overflow=""},N3:function(e,t){var i,n=this;if(null===ZC._n_(t)&&(t=!1),(t||n.A0L)&&-1===ZC.AV(n.KR,"skip_interactivity"))if(n.ZT=!0,t&&ZC.Q.HY({id:n.K+"-dummy",p:ZC.AK(n.K),wh:n.I+"/"+n.F}),n.E.hideprogresslogo||zingchart.DEV.SKIPPROGRESS)n.ZT=!1;else{var a=ZC.A5("#"+n.K);if(!(void 0===a.offset()||a.width()+a.height()===0||n.E.hideprogresslogo&&n.TJ)){var r=a.offset().left+ZC._i_(a.css("border-left-width"))+(null===e?n.iX:e.iX),l=a.offset().top+ZC._i_(a.css("border-top-width"))+(null===e?n.iY:e.iY);(ZC.ipad||ZC.iphone)&&(r-=ZC.A5(window).scrollLeft(),l-=ZC.A5(window).scrollTop());var o=null===e?n.I:e.I,s=null===e?n.F:e.F,c=ZC._i_(.8*n.I),h=30,C=new ZC.DN(n);n.B8.load(C.o,"loader.gui.progress"),C.append(n.E.progress),null!==n.DF&&null!==ZC._n_(i=n.DF.progress)&&C.append(i),C.parse();var u,d=ZC.HJ["progress-wait-long"];if(ZC.ie67)u=C.A0;else{var A=n.E.customprogresslogo||ZC.IMAGES["zc.logo"];u=C.A0+" url("+A+") no-repeat center center"}(o<180||s<90)&&(u=C.A0,h=-12),o<120&&o>60?(c=60,d=ZC.HJ["progress-wait-short"]):o<60&&(c=20,d=ZC.HJ["progress-wait-mini"]),d=n.E.customprogresstext||d;var p=ZC.Q.HY({id:n.K+"-progress",p:document.body,tl:l+"/"+r,width:o-2*C.AU,height:s-2*C.AU,position:"absolute",opacity:.8,border:C.AU+"px solid "+C.BW,background:u});ZC.Q.HY({id:n.K+"-progress-text",p:p,width:c,html:d,textAlign:"center",marginLeft:ZC._i_((o-c)/2),marginTop:ZC._i_(s/2+h),fontFamily:zingchart.FONTFAMILY,fontSize:zingchart.FONTSIZE,color:C.C2,fontWeight:"bold"})}}},A0C:function(){var e=this;ZC.Q.EU(e.K+"-dummy"),e.E.hideprogresslogo||(e.ZT=!1,ZC.Q.EU([e.K+"-progress-text",e.K+"-progress"]))},A4O:function(e,t){var i,n,a=this;i=null!==ZC._n_(n=e.graphset)?n:[e];var r=e.layout||"",l=ZC.AQ.A2C(r,i.length),o=i[t],s=a.I/l[1],c=a.F/l[0],h=Math.floor(t/l[1]),C=t%l[1]*s,u=h*c;o&&(null!==ZC._n_(n=o.x)&&(C=ZC._p_(n))<=1&&(C=ZC._i_(C*a.I)),null!==ZC._n_(n=o.y)&&(u=ZC._p_(n))<=1&&(u=ZC._i_(u*a.F)),null!==ZC._n_(n=o.width)&&(s=ZC._p_(n))<=1&&(s=ZC._i_(s*a.I)),null!==ZC._n_(n=o.height)&&(c=ZC._p_(n))<=1&&(c=ZC._i_(c*a.F)));var d=[0,0,0,0];if(o.plotarea){if(a.B8.load(o.plotarea,["("+o.type+").plotarea"],!1,!0),null!==ZC._n_(o.plotarea.margin))d=new ZC.HL(null).m_(o.plotarea.margin,"all",s,c);for(var A=["top","right","bottom","left"],p=0;p<4;p++)if(null!==ZC._n_(o.plotarea["margin-"+A[p]])){var g=o.plotarea["margin-"+A[p]];ZC._i_(g)+""==g+""&&(d[p]=ZC._i_(g))}}return{graph:{x:ZC._i_(C),y:ZC._i_(u),width:ZC._i_(s),height:ZC._i_(c),index:t},plotarea:{x:d[3],y:d[0],width:s-d[1]-d[3],height:c-d[0]-d[2]}}},K6:function(){var e=this;null===ZC._n_(e.o.graphset)&&(e.o={graphset:[e.o]}),e.N3(),zingchart.A1E(e,e.A4W(),function(){e.o=ZC.AP.BY("dataparse",e,e.FE(),e.o),zingchart.XZ[e.K]&&e.QH(function(){e.parse(),e.paint()})})},render:function(){var e=this;function t(){function t(){""!==e.QJ||null!==e.ML?e.A8S():e.load()}e.UN||e.A8N(),e.N3(null,!0),zingchart.TIMEOUT>0?ZC.ZJ(t):t()}zingchart.ACL("progress")?ZC.AP.ACC(e,zingchart.MODULESDIR+"zingchart-progress.min.js",t):t()},YI:function(e){var t=this;null===ZC._n_(t.A3S)&&(t.A3S=(new Date).getTime(),t.AAW=window.setTimeout(function(){null!==ZC._n_(t.A3S)&&(t.A3S=null,zingchart.YS(e))},1500))},FE:function(){var e,t=this,i=0,n=0;return i="undefined"!=typeof t.SW[0]?t.SW[0]-i:0,n="undefined"!=typeof t.SW[1]?t.SW[1]-n:0,e=t.LL?t.LL:"light",{id:t.K,width:t.I,height:t.F,output:t.AA,x:i,y:n,targetid:t.SW[2],theme:e}},AC5:function(e){e=e||{},null!==ZC._n_(e.resource)&&(this.QS[e.resource]=e.data||"[]",this.UQ++)},A8X:function(){},A8D:function(){},A8A:function(){},PV:function(){},A9H:function(e,t){var i=this;if(e=e||{},null!==ZC._n_(e.graphid)){var n=i.OQ(e.graphid);null!==n&&n.clear()}else i.clear(null,null,t);ZC.JS&&ZC.JS.GUIDES&&(ZC.JS.GUIDES[i.K]=null)},A7W:function(e){e=e||ZC.HJ["sync-wait"];var t=this;if(null===ZC.AK(t.K+"-blocker")){ZC.Q.HY({cls:"zc-abs zc-style zc-blocker",id:t.K+"-blocker",p:ZC.AK(t.K+"-top"),wh:t.I+"/"+t.F,opacity:.75}),ZC.Q.HY({cls:"zc-blocker-msg",id:t.K+"-blocker-t",p:ZC.AK(t.K+"-blocker"),html:e});var i=ZC.A5("#"+t.K+"-blocker-t");i.css("top",t.F/2-i.height()/2+"px").css("left",t.I/2-i.width()/2+"px")}},A42:function(){ZC.Q.EU(this.K+"-blocker")},A9E:function(){var e=this;ZC.AP.BY("about_show",e,e.FE()),ZC.Q.HY({cls:"zc-abs",id:e.K+"-about-mask",p:ZC.AK(e.K+"-top"),wh:e.I+"/"+e.F,background:"#ccc",opacity:.75});var t=ZC.CY(320,e.I),i=ZC.CY(215,e.F),n=ZC.BQ(0,(e.I-t)/2),a=ZC.BQ(0,(e.F-i)/2),r=ZC.Q.HY({cls:"zc-about zc-style",id:e.K+"-about",p:ZC.AK(e.K+"-top"),tl:a+"/"+n,wh:t-(ZC.quirks?0:10)+"/"+(i-(ZC.quirks?0:10))}),l="";""!==e.SD&&(l="Custom Built for<br />"+e.SD),r.innerHTML='<div class="zc-about-1"><a href="http://www.zingchart.com" target="_blank">zingchart.com</a></div><div class="zc-about-2">&copy;2009-'+(new Date).getFullYear()+'</div><div class="zc-about-3"><div id="'+e.K+'-about-close">'+ZC.HJ["about-close"]+'</div></div><div class="zc-about-4" style="padding:'+(i-215)+'px 5px 5px 5px;"><div>&nbsp;<br />Build '+ZC.VERSION+" ["+e.AA+"]</div>"+l+"</div>",ZC.A5("#"+e.K+"-about-close").bind("click",function(){ZC.AP.BY("about_hide",e,e.FE()),ZC.Q.EU([e.K+"-about",e.K+"-about-mask"])})},NU:function(e,t){var i=this;if(ZC.AP.A83("error",i))ZC.AP.BY("error",i,{id:i.K,error:e,section:t,json:i.E.json||i.E.rawsource});else{var n="";n+="object"==typeof e?e.name+":"+e.message+"\n\n":e+"\n\n",null!==ZC._n_(t)&&(n+="Section:"+t+"\n\n"),n+="JSON data:\n\n"+i.E.json+"\n\n",i.A0C(),null===ZC.AK(i.K+"-top")&&i.AAS(),ZC.Q.HY({cls:"zc-abs zc-error zc-style",id:i.K+"-error",p:ZC.AK(i.K+"-top"),wh:i.I-(ZC.quirks?0:10)+"/"+(i.F-(ZC.quirks?0:10))}).innerHTML='<div class="zc-form-row-label zc-form-s0">'+ZC.HJ["error-header"]+'</div><div class="zc-form-row-label zc-form-s1">'+ZC.HJ["error-message"]+'</div><div class="zc-form-row-element"><textarea id="'+i.K+'-error-message" style="width:'+(i.I-35)+"px;height:"+(i.F-135)+'px;"></textarea></div><div class="zc-form-row-element zc-form-row-last"><input type="button" value="'+ZC.HJ["error-close"]+'" id="'+i.K+'-error-close" /></div>',ZC.A5("#"+i.K+"-error-message").val(ZC.GV(n)),ZC.A5("#"+i.K+"-error-close").bind("click",function(){ZC.Q.EU(i.K+"-error")})}},A5O:function(){},A6T:function(){},A5W:function(){var e=this,t=document.createElement("div");t.id="zc-fullscreen",t.style.zIndex=zingchart.FSZINDEX,t.style.overflow="hidden";var i,n,a=document.body,r=!1;for(zingchart.FSID&&ZC.AK(zingchart.FSID)&&(r=!0,(a=ZC.AK(zingchart.FSID)).style.display="block"),a.appendChild(t),ZC.FSSTATUS={},i=0,n=e.AG.length;i<n;i++){var l=e.AG[i];if(null!==l.AY)for(var o=0,s=l.AY.A4.length;o<s;o++)ZC.FSSTATUS["g-"+l.L+"-p-"+o]=l.E["plot"+o+".visible"]}ZC.Q.EU(e.K+"-data-table");var c,h=JSON.parse(e.E.json),C=h.graphset;for(i=C.length-1;i>=0;i--)if(C[i].generated)C.splice(i,1);else{if(null!==ZC._n_(C[i].shapes))for(c=C[i].shapes.length-1;c>=0;c--)C[i].shapes[c].generated&&C[i].shapes.splice(c,1);if(null!==ZC._n_(C[i].labels))for(c=C[i].labels.length-1;c>=0;c--)C[i].labels[c].generated&&C[i].labels.splice(c,1)}r||window.scroll(0,0),zingchart.render({id:"zc-fullscreen",output:e.AA,width:ZC.A5(r?a:window).width(),height:ZC.A5(r?a:window).height(),fullscreenmode:!0,theme:e.LL,modules:e.A1A,data:h,defaults:e.ML,defaultsurl:e.QJ})},A0Y:function(e,t){var i,n,a,r=this,l=0,o=!1;for(i=0,n=r.AG.length;i<n;i++)if(e===r.AG[i].K){for(l=i,a=0;a<r.AG[i].AY.A4.length;a++)if(r.AG[i].AY.A4[a].I3){o=!0;break}var s;for(s=r.AG[l].AJ["3d"]||o?r.o.graphset[i]:r.AG[i].o,a=0;a<10;a++){var c="scale-y"+(0===a?"":"-"+a);null===ZC._n_(s[c])&&null===ZC._n_(s[ZC.EE(c)])&&null!==r.AG[i].BL(c)?s[c]={progression:t}:(null!==ZC._n_(s[c])&&(s[c].progression=t),null!==ZC._n_(s[ZC.EE(c)])&&(s[ZC.EE(c)].progression=t))}}delete r.E["graph"+l+".zoom"],r.AG[l].AJ["3d"]||o?r.K6():r.AG[l].K6(!0,!0)},Z7:function(e,t){var i=this;if(i.D7){for(var n=0,a=i.AG.length;n<a;n++)e===i.AG[n].K&&(i.AG[n].A1J=t,i.AG[n].E["guide-on"]=t);if(t){var r=ZC.A5("#"+i.K+"-top"),l={_pageX_:ZC.E1[0]-r.offset().left,_pageY_:ZC.E1[1]-r.offset().top,type:"mousemove",target:{id:i.K+"-img"}};i.D7.Q7(l)}else ZC.JS.clearGuide(i.K)}},A54:function(e){for(var t=this,i=["line","area","bar","vbar","hbar","pie","mixed"],n=0,a=t.AG.length;n<a;n++)if(e===t.AG[n].K){var r=t.o.graphset[n];if("mixed"===r.type)for(var l=0,o=r.series.length;l<o;l++){var s=r.series[l];s.type=s.type||"line","3d"===t.XH?s.type=s.type.replace("3d",""):-1!==ZC.AV(i,s.type)&&(s.type=s.type+"3d")}else"3d"===t.XH?r.type=r.type.replace("3d",""):-1!==ZC.AV(i,r.type)&&(r.type=r.type+"3d")}t.XH="3d"===t.XH?"2d":"3d",t.E.json=ZC.GV(JSON.stringify(t.o)),t.K6()},A8Y:function(e){for(var t,i=this,n=0;n<i.AG.length;n++)delete i.E["g"+n+"-legend-collapsed"];if(e=e||{},ZC.AP.BY("reload",i,{id:i.K,graphid:e.graphid}),null!==ZC._n_(t=e.graphid)){var a=i.C8(t);null!==a&&(i.N3(a),i.load(a.K))}else i.QL=[],i.NS=-1,i.N3(),i.clearGenerated(),i.load()},ACZ:function(e){var t,i=this;if(e=e||{},null!==ZC._n_(t=e.graphid)){var n=i.C8(t);null!==n&&null!==ZC._n_(e.dataurl)&&(i.N3(n),i.load(t,e.dataurl))}else null!==ZC._n_(t=e.dataurl)&&(i.QM=t,i.N3(),i.load())},A98:function(){},OD:function(){},Z4:function(){},AAI:function(e){ZC._cp_(this.FE(),e),ZC.AP.BY("menu_item_click",this,e)},A47:function(O){var s=this;try{var DW=ZC.AP.AAH(O["function"]);O["function"]=DW[0],O.arguments=DW[1],ZC._cp_(s.FE(),O),eval(O["function"]).call(s,O)}catch(JA){return s.NU(JA,"JavaScript data loader"),!1}},C8:function(e){var t=this;return null!==ZC._n_(e)?t.OQ(e):t.AG.length>0?t.AG[0]:null},bind:function(e,t){zingchart.bind(this.K,e,t)},unbind:function(e,t){zingchart.unbind(this.K,e,t)},exec:function(e,t){return zingchart.exec(this.K,e,t)},gc:function(){for(var e=0,t=this.AG.length;e<t;e++)this.AG[e].gc()}};ZC.Q2=ZC.HL.CA(Q2),ZC.JI=ZC.HL.CA({$i:function(e){this.b(e);var t=this;t.OB="zcgraph",t.H=e,t.AF="",t.IR=null,t.P2="",t.K0=null,t.MR=null,t.S5=null,t.P=null,t.B9=null,t.HS=null,t.HQ=null,t.A5Y=1,t.VH=1,t.A50=1,t.L=0,t.HP=null,t.MC=[1,0],t.A9L=null,t.CC=!1,t.KQ="normal",t.BO=[],t.BX=[],t.YC=[],t.FH=[],t.LH=[],t.AY=new ZC.LJ(t),t.H2=null,t.BD=null,t.A7=null,t.CX=null,t.HA=null,t.A1Q="always",t.ABO=!0,t.MA="",t.RJ=null,t.LK=!1,t.UL=!1,t.NB=0,t.YK=!1,t.Q5=!1,t.F0={true3d:1,angle:45,depth:40,"x-angle":0,"y-angle":0,"z-angle":0,zoom:1},t.AJ={"enable-guide":!1,"enable-preview":!1,"enable-scroll":!1,"enable-zooming":!0,"3d":!1,clip:!1,layout:"","enable-animation":!0,"angle-min":15,"angle-max":75,"x-angle-min":-65,"x-angle-max":65,"y-angle-min":-65,"y-angle-max":65,"z-angle-min":-65,"z-angle-max":65},t.OA=!1,t.A17=!1,t.A9W=[],t.A1J=!0,"undefined"!=typeof ZC.PE&&(t.LW=new ZC.PE(t)),t.GG=!1,t.CB={},t.IX=[],t.KI=!1,t.HH=!1,t.L3=0,t.BP=[],t.A4C=!0,t.UO=zingchart.DEV.STACKINGLOGIC,-1===t.UO&&(t.UO=0)},a11y:function(){if(this.A.bA11y){return ZC.Q.G0("rect","","")+'class="zc-graph-descriptor" tabindex="0" aria-label="Chart '+(this.L+1)+" of "+this.A.AG.length+", "+({vbar:"column",vbar3d:"3d column",hbar:"bar",hbar3d:"3d bar",line3d:"3d line",area3d:"3d area",pie3d:"3d pie"}[this.AF]||this.AF)+" chart. "+(this.IR?this.IR.AM:"Untitled")+". "+(this.K0?this.K0.AM:"")+". "+this.P2+'" id="'+this.K+'--graph" coords="0,0,0,0" data-z-sort="-200" />'}return""},getPMap:function(){var e=this.b();return this.addPMap(e,"index","L"),e},getToggleAction:function(){var e,t=this,i="hide";return t.BD&&""!==t.E["legend-last-trigger"]&&"undefined"!=typeof t.E["legend-last-trigger"]?i="item"===t.E["legend-last-trigger"]?t.BD.R1:t.BD.PP:(t.o.legend&&(e=t.o.legend["toggle-action"])&&(i=e),t.o.legend&&t.o.legend.item&&(e=t.o.legend.item["toggle-action"])&&(i=e)),(t.A.K9||t.E["toggle-action-remove"])&&(i="remove"),i},BU:function(e,t){void 0===t&&(t=!1);for(var i=[],n=this,a=0,r=n.BO.length;a<r;a++)n.BO[a].AF===e&&(!t||t&&n.BO[a].V.length>0)&&i.push(n.BO[a]);return i},BL:function(e){for(var t=this,i=0,n=t.BO.length;i<n;i++)if(t.BO[i].BE===e)return t.BO[i];return null},A2P:function(e){return e},ACH:function(e){return new ZC.A2M(this,e)},ACN:function(){for(var e=this,t=0,i=e.BO.length;t<i;t++){var n=e.BO[t],a=n.BE;e.A.B8.load(n.o,["("+e.AF+").SCALE","("+e.AF+")."+a.replace(/\-[0-9]+/,""),"("+e.AF+")."+a.replace(/\-[0-9]+/,"-n"),"("+e.AF+")."+a],!1,!0);var r=a.replace(/\-[0-9]+/,"")+"-n";e.o[r]&&n.append(e.o[r]),e.o[a]&&n.append(e.o[a]),e.AJ["3d"]&&e.A.B8.load(n.o,["("+e.AF+").SCALE[3d]","("+e.AF+")."+a.replace(/\-[0-9]+/,"")+"[3d]","("+e.AF+")."+a.replace(/\-[0-9]+/,"-n")+"[3d]","("+e.AF+")."+a+"[3d]"],!1,!0),e.AJ["3d"]&&n.append(e.o[a+"[3d]"]),n.parse()}},ABG:function(){return null},AAB:function(e){var t,i,n,a=this,r=0,l=a.AY.A4.length;for(t=0;t<l;t++)r=ZC.BQ(r,a.AY.A4[t].S.length);function o(e){return e=(e=(e=e.replace(/(%N|%node-count)/g,r)).replace(/(%P|%plot-count)/g,l)).replace(/(%S|%scale-values-count)/g,n.V.length)}for(t=0,i=a.BO.length;t<i;t++)(n=a.BO[t]).A96(e),2===e&&(n.J2=o,n.DE()&&n.parse()),null===ZC._n_(n.o["max-items"])&&null===ZC._n_(n.o["max-labels"])&&n.A7U(),null===ZC._n_(n.o["max-ticks"])&&n.AC9()},UY:function(){},NX:function(){},ADE:function(){},AC1:function(){},setupPlotArea:function(){var e=this,t=e.A.B8,i="("+e.AF+")";e.P=new ZC.HL(e),e.P.OG="plotarea",e.P.K=e.K+"-plotarea";var n=[i+".plotarea"];if(e.B9&&n.push(i+".plotarea[preview]"),e.AJ["3d"]&&n.push(i+".plotarea[3d]"),t.load(e.P.o,n),e.P.append(e.o.chart),e.P.append(e.o.plotarea),e.B9&&e.P.append(e.o["plotarea[preview]"]),e.AJ["3d"]&&e.P.append(e.o["plotarea[3d]"]),"dynamic"===e.P.o["margin-top"]||"dynamic"===e.P.o["margin-right"]||"dynamic"===e.P.o["margin-bottom"]||"dynamic"===e.P.o["margin-left"]){var a=String(e.P.o.margin||"").split(/\s+|;|,/),r=a.length>0?a[0]:"",l=a.length>1?a[1]:"",o=a.length>0?a[2]||a[0]:"",s=a.length>1?a[3]||a[1]:"";"dynamic"===e.P.o["margin-top"]&&(r="dynamic"),"dynamic"===e.P.o["margin-right"]&&(l="dynamic"),"dynamic"===e.P.o["margin-bottom"]&&(o="dynamic"),"dynamic"===e.P.o["margin-left"]&&(s="dynamic"),e.P.o.margin=[r,l,o,s].join(" ")}if(e.E["plotarea-margins"]?e.P.o.margin=e.E["plotarea-margin"]:(e.E["plotarea-margins"]=!0,e.E["plotarea-margin"]=e.P.o.margin,e.E["plotarea-margin-top"]=e.P.o["margin-top"],e.E["plotarea-margin-right"]=e.P.o["margin-right"],e.E["plotarea-margin-bottom"]=e.P.o["margin-bottom"],e.E["plotarea-margin-left"]=e.P.o["margin-left"]),"undefined"!=typeof e.E["plotarea-p-x"]&&(e.P.E["p-x"]=e.E["plotarea-p-x"],e.P.E["p-y"]=e.E["plotarea-p-y"],e.P.E["p-width"]=e.E["plotarea-p-width"],e.P.E["p-height"]=e.E["plotarea-p-height"]),null!==ZC._n_(e.P.o["adjust-layout"])&&ZC._b_(e.P.o["adjust-layout"])&&(e.P.o.margin="dynamic"),e.P.parse(),e.AJ["3d"]&&!e.F0.true3d){var c=ZC._a_(ZC._i_(e.F0.depth*ZC.EP(e.F0.angle)));e.P.iY+=c,e.P.F-=c,e.P.I-=ZC._i_(e.F0.depth*ZC.EH(e.F0.angle))}if("undefined"!=typeof e.E["plotarea-p-x"])for(var h=0,C=e.BO.length;h<C;h++)e.BO[h].A51(),e.BO[h].J1()},setupDynamicPlotArea:function(){var e,t,i,n=this,a=["top","right","bottom","left"],r={};for(t=0;t<a.length;t++)r[a[t]]=!1,n.E["plotarea.d-margin-"+a[t]]&&(n.o.plotarea["margin-"+a[t]]=null),n.o.plotarea&&"dynamic"===n.o.plotarea["margin-"+a[t]]&&(r[a[t]]=!0,n.o.plotarea["margin-"+a[t]]="20");var l=!1,o={};if("xy"===n.AJ.layout&&(l=!0),("xy"===n.AJ.layout||"yx"===n.AJ.layout)&&(n.P.E["d-margin"]||n.E["plotarea.d-margin"])){for(var s=0,c=n.BO.length;s<c;s++){var h=0,C=0,u="",d=n.BO[s];if(d.AN&&d.T9){"k"===d.AF?u=d.CO?"default"===d.BA?"left":"right":"default"===d.BA?"bottom":"top":"v"===d.AF&&(u=d.CO?"default"===d.BA?"bottom":"top":"default"===d.BA?"left":"right");var A=0;if(n.P.E["d-margin-"+u]||n.E["plotarea.d-margin-"+u]){var p=new ZC.DN(d);p.copy(d.BR);var g=ZC.BQ(1,ZC._i_((d.A1-d.W)/d.EG));for(t=d.W;t<=d.A1;t+=g)if(p.AM=d.FQ(t),p.A29&&("k"===d.AF&&!d.CO||"v"===d.AF&&d.CO)&&(p.o.width=ZC._i_(.9*d.AC)),p.parse(),p.AN)if(C=ZC.BQ(C,p.A9%180==0?p.F:p.I),h=ZC.BQ(h,p.A9%180==0?p.I:p.F),A=ZC.BQ(A,1.5*p.DG*(p.AM||"").split(/<br>|<br\/>|<br \/>|\n/).length),"top"===u||"bottom"===u){if(A=ZC.BQ(A,.465*p.DG+1.025*ZC._a_(ZC.EP(p.A9))*ZC.BQ(p.I,p.F)),h=p.I,C=A,l&&"k"===d.AF){o[d.BE]||(o[d.BE]=[]);var Z=null===ZC._n_(p.o["auto-align"])||ZC._b_(p.o["auto-align"]),f=.465*p.DG+1.025*ZC._a_(ZC.EH(p.A9))*ZC.BQ(p.I,p.F);"default"===d.BA?(Z&&(ZC.DS(ZC._ang_(p.A9),90,180)||ZC.DS(ZC._ang_(p.A9),270,360))&&o[d.BE].push(f),Z||o[d.BE].push(f/2)):(Z&&(ZC.DS(ZC._ang_(p.A9),0,90)||ZC.DS(ZC._ang_(p.A9),180,270))&&o[d.BE].push(f),Z||o[d.BE].push(f/2))}}else h=A=ZC.BQ(A,.465*p.DG+1.025*ZC._a_(ZC.EH(p.A9))*ZC.BQ(p.I,p.F)),C=p.F;var _=new ZC.DN(d);_.copy(d.M),_.AM=d.M.AM,_.parse(),""!==_.AM&&_.AN&&(C+=_.A9%180==0?_.F:_.I,h+=_.A9%180==0?_.I:_.F)}if(n.o.plotarea||(n.o.plotarea={}),("dynamic"===n.o.plotarea["margin-"+u]||n.P.E["d-margin-"+u])&&(n.P.E["d-margin-"+u]=!1,r[u]=!0,n.o.plotarea["margin-"+u]="0"),r[u]){n.o.plotarea["margin-"+u]=ZC._f_(n.o.plotarea["margin-"+u]||"0"),n.E[d.BE+"-distance"]=n.o.plotarea["margin-"+u];var b=("top"===u||"bottom"===u?ZC._i_(C):ZC._i_(h))+10+(n.AJ["3d"]?20:0);if(d.VE?n.o.plotarea["margin-"+u]=ZC.BQ(n.o.plotarea["margin-"+u],b):n.o.plotarea["margin-"+u]+=b,null!==ZC._n_(n.o.plotarea["margin-"+u+"-offset"])&&(n.o.plotarea["margin-"+u]+=ZC._i_(n.o.plotarea["margin-"+u+"-offset"])),!n.A.TJ){var m={},v=n.A.DF.watermark;n.A.B8.load(m,"loader.gui.watermark"),v&&ZC._cp_(v,m),1===n.A.o.graphset.length&&n.A.o.graphset[0].gui&&(e=n.A.o.graphset[0].gui.watermark)&&ZC._cp_(e,m);var E=m.position||"br";-1===ZC.AV(["tl","tr","br","bl"],E)&&(E="br"),("bottom"!==u||"bl"!==E&&"br"!==E)&&("top"!==u||"tl"!==E&&"tr"!==E)||(n.o.plotarea["margin-"+u]+=15)}"bottom"===u&&("xy"===n.AJ.layout&&n.HS||"yx"===n.AJ.layout&&n.HQ)&&(n.o.plotarea["margin-"+u]+=15),"left"===u&&("xy"===n.AJ.layout&&n.HQ||"yx"===n.AJ.layout&&n.HS)&&(n.o.plotarea["margin-"+u]+=15),n.E["plotarea.d-margin-"+u]=!0}}}if(l&&r.left&&null!==ZC._n_(n.o.plotarea["margin-left"]))for(var D in o){var w=n.BL(D);for(t=0;t<o[D].length;t++){ZC._i_(n.o.plotarea["margin-left"])+t*w.AC+(w.DJ?w.AC/2:0)-o[D][t]<0&&(n.o.plotarea["margin-left"]=o[D][t]-t*w.AC-(w.DJ?w.AC/2:0))}}ZC.Q.IU(ZC.AK(n.K+"-plotarea-c"),n.H.AA,n.P.iX,n.P.iY,n.P.I,n.P.F,n.K),n.E["plotarea.paint"]=!0,n.setupPlotArea();var x=2,B=6;null!==ZC._n_(e=n.P.o["mask-tolerance"])&&(e instanceof Array?(x=B=ZC._i_(e[0]),e.length>1&&(B=ZC._i_(e[1]))):x=B=ZC._i_(e)),n.P.E.tolerance=x,"svg"===n.H.AA?((e=ZC.AK(n.K+"-clip-shape"))&&e.setAttribute("points",n.M6(x,"svg")),(e=ZC.AK(n.K+"-clip-hover-shape"))&&e.setAttribute("points",n.M6(B,"svg"))):(ZC.A5("#"+n.K+" div").each(function(){""!==this.style.clip&&(this.style.clip=n.M6(x))}),(e=ZC.AK(n.K+"-hover"))&&""!==e.style.clip&&(e.style.clip=n.M6(B)))}for(t=0,i=n.BO.length;t<i;t++)n.BO[t].A51(),n.BO[t].J1()},parse:function(){var e,t,i,n,a,r,l,o,s,c=this,h=c.A.B8,C="("+c.AF+")";(e=c.A.E["graph-state-"+c.L])&&(c.E=JSON.parse(e),null===ZC._n_(c.E["guide-on"])||ZC._b_(c.E["guide-on"])||(c.A1J=!1)),c.E.legend_toggle_action||(c.A.E["graph-"+c.K+"-legend-info"]=null),c.E.legend_toggle_action=null,c.MA="parse.init",c.b(),c.ADE(),-1!==JSON.stringify(c.o).indexOf("zingchart.maps")&&(c.o.plotarea=c.o.plotarea||{},c.o.plotarea.margin=0);var u=null;if(!zingchart.SKIP.CSV&&((e=c.o["html5-csv"])&&(c.RJ=e["html5-url"]),(e=c.o.csv)&&("object"==typeof e?e.url?c.RJ=e.url:e["data-string"]&&(u=e["data-string"]):c.RJ=e),""!==c.RJ&&null!==ZC._n_(c.A.A9P[c.RJ])&&(u=c.A.A9P[c.RJ]),c.H.NW&&(u=c.H.NW),u)){var d=c.ACH(u);c.o=d.parse()}if(c.LK=zingchart.ASYNC,c.assign_a([["utc","UL","b"],["timezone","NB","f"],["async","LK","b"],["stacked","CC","b"],["stack-type","KQ"],["animate-type","A1Q"],["url-data","A9L"],["page","L3","i"],["palette","BP"],["sort-objects","A4C","b"],["description","P2"]]),c.BP.length>0)for(h.B8.palette=[],n=0;n<c.BP.length;n++){var A=c.BP[n],p=ZC.AP.JN(c.BP[n],10),g=ZC.AP.QU(c.BP[n],10);h.B8.palette.push(["#fff",A,p,g])}"pie3d"===c.AF&&(c.F0.true3d=!0),(c.AJ["3d"]||c.A.A19)&&(c.LK=!1),c.AC1(),-1===ZC.AV(c.H.KR,"skip_interactivity")&&((null!==ZC._n_(e=c.o.preview)||h.PL("preview",c.AF))&&c.AJ["enable-preview"]&&(c.B9&&!c.E["force-preview-parse"]||"undefined"==typeof ZC.A2D||(c.E["force-preview-parse"]=!1,c.B9=new ZC.A2D(c),c.B9.OG="preview",h.load(c.B9.o,C+".preview"),"yx"===c.AJ.layout&&h.load(c.B9.o,C+".preview[yx]"),(t=c.o.plotarea)&&c.B9.append({"background-color":t["background-color"],"background-color-1":t["background-color-1"],"background-color-2":t["background-color-2"],"gradient-stops":t["gradient-stops"],"gradient-colors":t["gradient-colors"]}),c.B9.append(e),c.B9.parse())),(null!==ZC._n_(e=c.o["scroll-x"])||h.PL("scroll-x",c.AF))&&c.AJ["enable-scroll"]&&(c.HS||"undefined"==typeof ZC.ZF||(c.HS=new ZC.ZF(c,"x"),c.HS.OG="scrollx",h.load(c.HS.o,C+".scroll-x"),c.HS.append(e),c.HS.parse())),(null!==ZC._n_(e=c.o["scroll-y"])||h.PL("scroll-y",c.AF))&&c.AJ["enable-scroll"]&&(c.HQ||"undefined"==typeof ZC.ZF||(c.HQ=new ZC.ZF(c,"y"),c.HQ.OG="scrolly",h.load(c.HQ.o,C+".scroll-y"),c.HQ.append(e),c.HQ.parse()))),c.setupPlotArea(),c.NX(),c.BO=[],c.ACN(),c.AAB(1),null!==ZC._n_(e=c.o.series)&&(c.AY.o=e);var Z=c.AY.o;for(n=0;n<Z.length;n++)if(Z[n].rel)for(s=0;s<Z.length;s++)Z[s].id&&Z[s].id===Z[n].rel&&(c.AY.o[n].values=[].concat(c.AY.o[s].values));if(c.AY.parse(),c.AAB(2),(null!==ZC._n_(e=c.o.title)||h.PL("title",c.AF))&&(c.IR=new ZC.DN(c),c.IR.OG="title",h.load(c.IR.o,C+".title"),c.IR.append(e),c.IR.K=c.K+"-title",c.IR.K9=!0,c.IR.parse(),null===ZC._n_(c.IR.o.x))){var f=c.iX,_=c.I;switch("plotarea"===c.IR.o["center-point"]&&(f=c.P.iX,_=c.P.I),c.IR.O8){case"left":c.IR.iX=f;break;case"center":c.IR.iX=f+_/2-c.IR.I/2;break;case"right":c.IR.iX=f+_-c.IR.I}}(null!==ZC._n_(e=c.o.subtitle)||h.PL("subtitle",c.AF))&&(c.K0=new ZC.DN(c),c.K0.OG="subtitle",h.load(c.K0.o,C+".subtitle"),c.K0.append(e),c.K0.K=c.K+"-subtitle",c.K0.parse()),null!==ZC._n_(e=c.o.source)&&(c.MR=new ZC.DN(c),c.MR.OG="source",h.load(c.MR.o,C+".source"),c.MR.append(e),c.MR.K=c.K+"-source",c.MR.parse()),"undefined"!=typeof ZC.UV&&(null!==ZC._n_(e=c.o.legend)||h.PL("legend",c.AF))&&(c.BD=new ZC.UV(c),c.BD.K=c.K+"-legend","undefined"!=typeof e.alpha&&e.alpha<.1&&"undefined"==typeof e["border-width"]&&"undefined"==typeof e["border-alpha"]&&(e["border-alpha"]=e.alpha),h.load(c.BD.o,C+".legend"),c.BD.alignPosition(e),(null!==ZC._n_(e)&&null!==ZC._n_(e.position)||null!==ZC._n_(c.BD.o.position))&&h.load(c.BD.o,C+".legend[position]"),c.BD.append(e),ZC._b_(c.BD.o.shared)&&(c.BD.E["p-x"]=c.A.iX,c.BD.E["p-y"]=c.A.iY,c.BD.E["p-width"]=c.A.I,c.BD.E["p-height"]=c.A.F),c.BD.alignPosition(e),c.BD.parse());var b=!1,m=c.iX,v=c.iY,E=c.I,D=c.F,w="";if(c.IR&&c.IR.AN&&c.IR.o["adjust-layout"]&&(b=!0,(i=c.IR.iY+c.IR.F/2)<v+D/2&&(w="top",D=v+D-c.IR.F-c.IR.iY,v=c.IR.iY+c.IR.F,c.K0&&c.K0.o["adjust-layout"]))){var x=c.K0.iY+c.K0.F/2;x<v+D/2&&x>i&&(D-=c.K0.F,v+=c.K0.F)}if(c.MR&&c.MR.AN&&c.MR.o["adjust-layout"]&&(b=!0,(i=c.MR.iY+c.MR.F/2)>v+D/2&&(D-=c.MR.F)),c.B9&&c.B9.AN&&c.B9.o["adjust-layout"]&&(b=!0,"xy"===c.AJ.layout?(i=c.B9.AR.iY+c.B9.AR.F/2)>v+D/2?D-=c.B9.AR.F+c.B9.AR.DR:(v=c.B9.AR.iY+c.B9.AR.F,D-=c.B9.AR.F):(f=c.B9.AR.iX+c.B9.AR.I/2)<m+E/2?(E-=c.B9.AR.I+c.B9.AR.DY,m+=c.B9.AR.I+c.B9.AR.DY):(m=c.B9.AR.iX+c.B9.AR.I,E-=c.B9.AR.I)),c.BD&&c.BD.AN&&c.BD.o["adjust-layout"]){b=!0;var B=c.BD.D4&&c.BD.D4.enabled?15:5;if("top"===w&&c.BD.iY<c.IR.iY+c.IR.F+5){if(null!==ZC._n_(c.BD.o.position)){var y=(""+c.BD.o.position).split(" ");c.BD.o.position=y[0]+" "+(c.IR.iY-c.iY+c.IR.F+c.BD.ME+B)}else c.BD.o["margin-top"]=c.IR.iY-c.iY+c.IR.F+c.BD.ME;c.BD.parse()}c.BD.fixPlacement(),i=c.BD.iY+c.BD.F/2;var K="",F=(ZC.MAX,c.BD.E["position-info"]),M={Bottom:c.BD.iY-c.iY,Top:c.iY+c.F-c.BD.iY-c.BD.F,Right:c.BD.iX-c.iX,Left:c.iX+c.I-c.BD.iX-c.BD.I},z="";if(c.BD.I/c.BD.F>2)z="v";else if(c.BD.F/c.BD.I>2)z="h";else{z=Math.max(M.Left*c.F,M.Right*c.F)/Math.max(M.Top*c.I,M.Bottom*c.I)>1?"h":"v"}if(F)F[0]>=.8?K=F[1]<=.2?"v"===z?"top":"right":F[1]>=.8&&"v"===z?"bottom":"right":F[0]<=.2?K=F[1]<=.2?"v"===z?"top":"left":F[1]>=.8&&"v"===z?"bottom":"left":F[1]<=.2?K="top":F[1]>=.8&&(K="bottom");else Math.min(M.Top,M.Bottom)/Math.max(M.Top,M.Bottom)<Math.min(M.Left,M.Right)/Math.max(M.Left,M.Right)?M.Top>M.Bottom?(K="top",c.BD.E8):(K="bottom",c.BD.DR):M.Left>M.Right?(K="left",c.BD.DY):(K="right",c.BD.E9);var I=0;"top"===K&&(D=v+D-c.BD.F-c.BD.iY,v=c.BD.iY+c.BD.F),"bottom"===K&&(D-=I=D-c.BD.iY+v+c.BD.FM+c.BD.FU),"left"===K&&(m+=I=c.BD.iX-c.iX+c.BD.I,E-=I),"right"===K&&(E-=I=E-(c.BD.iX-c.iX)+c.BD.EQ+c.BD.FN)}else c.BD&&c.BD.fixPlacement();b&&(c.E["plotarea-p-x"]=m,c.E["plotarea-p-y"]=v,c.E["plotarea-p-width"]=E,c.E["plotarea-p-height"]=D,c.setupPlotArea()),c.setupDynamicPlotArea(),c.AY.parseLayout&&c.AY.parseLayout(!0),c.B9&&c.B9.o["adjust-layout"]&&("xy"===c.AJ.layout?(null===ZC._n_(c.B9.J9.x)&&(c.B9.AR.iX=c.P.iX),null===ZC._n_(c.B9.J9.width)&&(c.B9.AR.I=c.P.I)):(null===ZC._n_(c.B9.J9.y)&&(c.B9.AR.iY=c.P.iY),null===ZC._n_(c.B9.J9.height)&&(c.B9.AR.F=c.P.F)));var S=0;for(n=0;n<c.AY.A4.length;n++)S+=c.AY.A4[n].S.length;null!==ZC._n_(e=c.o["no-data"])&&0===S?(c.S5=new ZC.DN(c),c.S5.OG="nodata",h.load(c.S5.o,C+".noData"),c.S5.append({x:c.P.iX,y:c.P.iY,width:c.P.I,height:c.P.F}),c.S5.append(e),c.S5.K=c.K+"-nodata",c.S5.parse()):c.S5=null,c.E["plotarea-margins"]&&(c.E["plotarea-margins"]=null,c.o.plotarea=c.o.plotarea||{},c.o.plotarea.margin=c.E["plotarea-margin"],c.o.plotarea["margin-top"]=c.E["plotarea-margin-top"],c.o.plotarea["margin-right"]=c.E["plotarea-margin-right"],c.o.plotarea["margin-bottom"]=c.E["plotarea-margin-bottom"],c.o.plotarea["margin-left"]=c.E["plotarea-margin-left"]);var G=["top","right","bottom","left"];for(n=0;n<G.length;n++)c.E["plotarea.d-margin-"+G[n]]=null;if(ZC.Q.EU(c.A.K+"-tooltip"),"undefined"!=typeof c.E.datalength&&null!==ZC._n_(c.E.datalength)&&c.E.datalength.length>0&&"canvas"!==c.H.AA&&c.AY.A4)for(var N=0,H=c.AY.A4.length;N<H;N++){if(c.AY.A4[N].S.length<c.E.datalength[N])for(l=c.AY.A4[N].S.length,o=c.E.datalength[N];l<o;l++)r=c.K+"-plotset-plot-"+N+"-node-"+l,ZC.Q.EU([r+"-path",r+"-area-path",r+"-sh-path"]),-1!==ZC.AV(["scatter","bubble"],c.AF)&&ZC.Q.EU([r+"-marker-gradient",r+"-marker-path",r+"-marker-sh-path",r+"-marker-circle",r+"-marker-sh-circle"]),c.EN[N+"-"+l]=null;if(-1===ZC.AV(["scatter","bubble"],c.AF)||ZC.A5.browser.webkit)for(l=0,o=c.E.datalength[N];l<o;l++)r=c.K+"-plotset-plot-"+N+"-node-"+l,ZC.Q.EU([r+"-marker-gradient",r+"-marker-path",r+"-marker-sh-path",r+"-marker-circle",r+"-marker-sh-circle"])}for(c.E.datalength=null,n=0,a=c.AY.A4.length;n<a;n++)c.GG=c.GG||c.AY.A4[n].GG;(c.HH||"undefined"==typeof ZC.PE)&&(c.GG=!1),c.GG&&(c.LW.onStop=function(){c.MA="ready"}),-1===ZC.AV(c.H.KR,"skip_interactivity")&&(c.H2=new ZC.HL(c),c.H2.K=c.K+"-zoom",h.load(c.H2.o,C+".zoom"),c.H2.append(c.o.zoom),c.A7=new ZC.DN(c),c.A7.OG="tooltip",c.o.tooltip&&c.o.tooltip.placement&&c.o.tooltip.placement.indexOf("node")>-1?h.load(c.A7.o,C+".tooltip[dynamic]"):h.load(c.A7.o,C+".tooltip"),c.A7.append(c.o.tooltip),c.A7.PU=!0,c.A7.parse(),null!==ZC._n_(e=c.o.guide)&&(c.o["crosshair-x"]=e),(null!==ZC._n_(e=c.o["crosshair-x"])||h.PL("guide",c.AF)||h.PL("crosshair-x",c.AF))&&c.AJ["enable-guide"]&&(c.CX=new ZC.D0(c),c.CX.OG="crosshairx",h.load(c.CX.o,[C+".guide",C+".crosshair-x"],!0,!0),c.CX.append(e),c.CX.parse(),c.E["guide-on"]=!0),(null!==ZC._n_(e=c.o["crosshair-y"])||h.PL("crosshair-y",c.AF))&&c.AJ["enable-guide"]&&(c.HA=new ZC.D0(c),c.HA.OG="crosshairy",h.load(c.HA.o,[C+".guide",C+".crosshair-y"],!0,!0),c.HA.append(e),c.HA.parse(),c.E["guide-on"]=!0)),c.OW(),ZC.AP.BY("gparse",c.A,c.GX()),null!==ZC._n_(e=c.o.refresh)&&(c.HP={type:"full",interval:10,transport:"http",method:"pull","adjust-scale":!1,"max-ticks":20,"reset-timeout":100,"stop-timeout":0,storage:!1,"storage-size":1e3},ZC._cp_(e,c.HP),c.UO=1),c.MA="parse.complete"},OW:function(){},PW:function(){},M6:function(e,t,i){var n=this,a=(i=i||n.P).iX,r=i.iY,l=i.I,o=i.F;if("svg"===t){if(n.AJ["3d"]){var s,c=[];e=1;var h,C,u,d,A=[],p=a-ZC.AO.E2,g=r-ZC.AO.E3;s=new ZC.CE(n,p+l/2-e,g-e,ZC.AO.FT),d=ZC._i_(s.ED[1]),s=new ZC.CE(n,p+l/2-e,g-e,0),u=ZC._i_(s.ED[1]),A.push(new ZC.CE(n,p-e,g-e,d<u?ZC.AO.FT:0),new ZC.CE(n,p+l+e,g-e,d<u?ZC.AO.FT:0)),s=new ZC.CE(n,p+l-e,g+o/2-e,ZC.AO.FT),h=ZC._i_(s.ED[0]),s=new ZC.CE(n,p+l-e,g+o/2-e,0),C=ZC._i_(s.ED[0]),A.push(new ZC.CE(n,p+l+e,g-e,h>C?ZC.AO.FT:0),new ZC.CE(n,p+l+e,g+o+e,h>C?ZC.AO.FT:0)),s=new ZC.CE(n,p+l/2-e,g+o+e,ZC.AO.FT),d=ZC._i_(s.ED[1]),s=new ZC.CE(n,p+l/2-e,g+o+e,0),u=ZC._i_(s.ED[1]),A.push(new ZC.CE(n,p+l+e,g+o+e,d>u?ZC.AO.FT:0),new ZC.CE(n,p-e,g+o+e,d>u?ZC.AO.FT:0)),s=new ZC.CE(n,p-e,g+o/2-e,ZC.AO.FT),h=ZC._i_(s.ED[0]),s=new ZC.CE(n,p-e,g+o/2-e,0),C=ZC._i_(s.ED[0]),A.push(new ZC.CE(n,p-e,g+o+e,h<C?ZC.AO.FT:0),new ZC.CE(n,p-e,g-e,h<C?ZC.AO.FT:0)),A.push(A[0]);for(var Z=0;Z<A.length;Z++)s=A[Z],c.push([ZC._i_(s.ED[0]),ZC._i_(s.ED[1])].join(","));return c.join(" ")}return[[a-e,r-e].join(","),[a+l+e,r-e].join(","),[a+l+e,r+o+e].join(","),[a-e,r+o+e].join(","),[a-e,r-e].join(",")].join(" ")}return"box"===t?a-e+","+(r-e)+","+(l+2*e)+","+(o+2*e):(n.AJ["3d"]&&(e+=10),"rect("+(r-e)+"px,"+(a+l+e)+"px,"+(r+o+e)+"px,"+(a-e)+"px)")},autoFit:function(){var e,t=this;if(t.AJ["3d"]&&t.F0["auto-fit"]){var i=!1;for(t.F0.zoom=1;!i&&t.F0.zoom>.25;){i=!0;var n=t.M6(0,"svg").split(" ");for(e=0;e<n.length;e++){var a=n[e].split(",");(ZC._i_(a[0])<t.iX+t.P.DY||ZC._i_(a[0])>t.iX+t.I-t.P.E9||ZC._i_(a[1])<t.iY+t.P.E8||ZC._i_(a[1])>t.iY+t.F-t.P.DR)&&(i=!1)}i||(t.F0.zoom-=.05),i&&(t.F0.zoom-=.025)}}},build:function(){var e,t,i,n,a,r,l,o,s=this,c=s.A.I+"/"+s.A.F,h="0/0";if(s.autoFit(),!s.H.usc()){var C=2,u=6;if(null!==ZC._n_(e=s.P.o["mask-tolerance"])&&(e instanceof Array?(C=u=ZC._i_(e[0]),e.length>1&&(u=ZC._i_(e[1]))):C=u=ZC._i_(e)),"svg"===s.A.AA&&s.AJ.clip&&(ZC.Q.EU([s.K+"-clip",s.K+"-clip-hover",s.K+"-clip-preview"]),s.A.KE.appendChild(ZC.Q.X8({id:s.K+"-clip",path:s.M6(C,"svg")})),s.A.KE.appendChild(ZC.Q.X8({id:s.K+"-clip-hover",path:s.M6(u,"svg")})),s.B9)){var d=s.AJ["3d"];s.AJ["3d"]=!1,s.A.KE.appendChild(ZC.Q.X8({id:s.K+"-clip-preview",path:s.M6(0,"svg",s.B9.AR)})),s.AJ["3d"]=d}var A=!s.AJ.clip,p=A?null:s.M6(C),g=A?null:"url(#"+s.K+"-clip)",Z=A?null:s.M6(u),f=A?null:"url(#"+s.K+"-clip-hover)";if(s.B9&&(a=A?null:s.M6(0,s.A.AA,s.B9.AR),r=A?null:"url(#"+s.K+"-clip-preview)"),ZC.Q.JZ({cls:"zc-abs",id:s.K,p:ZC.AK(s.A.K+"-graphset"),tl:h,wh:c},s.A.AA),s.A.NZ.graph&&ZC.Q.HC({cls:"zc-abs zc-layer zc-persistent",id:s.K+"-c",p:ZC.AK(s.K),wh:c},s.A.AA),ZC.Q.JZ({id:s.K+"-plotarea",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute"},s.A.AA),s.o.plotarea&&s.A.NZ.plotarea&&ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-plotarea-c",p:ZC.AK(s.K+"-plotarea"),wh:c},s.A.AA),"null"!==s.AF&&s.A.NZ.plots){for(ZC.Q.JZ({id:s.K+"-scales-bl",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute","clip-path":g,clip:p},s.A.AA),t=0;t<s.A5Y;t++)ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-scales-bl-"+t+"-c",p:ZC.AK(s.K+"-scales-bl"),wh:c},s.A.AA);if(s.AY.E["plot-sort"]){for(t=0,i=s.AY.A4.length;t<i;t++){for(s.AY.A4[t].UP={},n=0;n<s.AY.A4[t].SV;n++)ZC.Q.EU(s.K+"-plots-bl-"+n);for(n=0;n<s.AY.A4[t].A1G;n++)ZC.Q.EU(s.K+"-plots-fl-"+n)}delete s.AY.E["plot-sort"]}if(s.A.K9||s.AJ["3d"])ZC.AK(s.K+"-plots-bl")||ZC.Q.JZ({id:s.K+"-plots-bl",p:ZC.AK(s.K),after:ZC.AK(s.K+"-scales-bl"),tl:h,wh:c,position:"absolute","clip-path":g,clip:p},s.A.AA),(l=ZC.Q.HC({cls:"zc-abs zc-layer zc-bl",id:s.K+"-plots-bl-c",p:ZC.AK(s.K+"-plots-bl"),wh:c},s.A.AA)).setAttribute("data-clip",s.M6(C,"box"));else for(t=0,i=s.AY.A4.length;t<i;t++)for(o=s.AY.M2[t],n=s.AY.A4[t].SV-1;n>=0;n--)ZC.AK(s.K+"-plots-bl-"+n)||ZC.Q.JZ({id:s.K+"-plots-bl-"+n,p:ZC.AK(s.K),after:ZC.AK(s.K+"-scales-bl"),tl:h,wh:c,position:"absolute","clip-path":g,clip:p},s.A.AA),(l=ZC.Q.HC({cls:"zc-abs zc-layer zc-bl",id:s.K+"-plot-"+o+"-bl-"+n+"-c",p:ZC.AK(s.K+"-plots-bl-"+n),wh:c},s.A.AA)).setAttribute("data-clip",s.M6(C,"box")),l.style.display="block";for(t=0;t<s.VH;t++)ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-scales-ml-"+t+"-c",p:ZC.AK(s.K),wh:c},s.A.AA);if(s.A.K9||s.AJ["3d"])ZC.AK(s.K+"-plots-fl")||ZC.Q.JZ({id:s.K+"-plots-fl",p:ZC.AK(s.K),after:ZC.AK(s.K+"-scales-ml-"+(s.VH-1)+"-c"),tl:h,wh:c,position:"absolute"},s.A.AA),(l=ZC.Q.HC({cls:"zc-abs zc-layer zc-fl",id:s.K+"-plots-fl-c",p:ZC.AK(s.K+"-plots-fl"),wh:c},s.A.AA)).setAttribute("data-clip",s.M6(u,"box"));else for(t=0,i=s.AY.A4.length;t<i;t++)for(o=s.AY.M2[t],n=s.AY.A4[t].A1G-1;n>=0;n--)ZC.AK(s.K+"-plots-fl-"+n)||ZC.Q.JZ({id:s.K+"-plots-fl-"+n,p:ZC.AK(s.K),after:ZC.AK(s.K+"-scales-ml-"+(s.VH-1)+"-c"),tl:h,wh:c,position:"absolute"},s.A.AA),(l=ZC.Q.HC({cls:"zc-abs zc-layer zc-fl",id:s.K+"-plot-"+o+"-fl-"+n+"-c",p:ZC.AK(s.K+"-plots-fl-"+n),wh:c},s.A.AA)).setAttribute("data-clip",s.M6(u,"box")),l.style.display="block";for(zingchart.DEV.PLOTSHLAYER&&(ZC.Q.JZ({id:s.K+"-plots-hover",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute"},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer zc-fl",id:s.K+"-plots-hover-c",p:ZC.AK(s.K+"-plots-hover"),wh:c},s.A.AA)),ZC.Q.JZ({id:s.K+"-scales-fl",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute","clip-path":g,clip:p},s.A.AA),t=0;t<s.A50;t++)ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-scales-fl-"+t+"-c",p:ZC.AK(s.K+"-scales-fl"),wh:c},s.A.AA);if(s.B9&&(ZC.Q.JZ({id:s.K+"-preview",p:ZC.AK(s.A.K+"-tools"),tl:h,wh:c,position:"absolute","clip-path":r,clip:a},s.A.AA),ZC.Q.HC({cls:"zc-abs",id:s.K+"-preview-c",p:ZC.AK(s.K+"-preview"),wh:c},s.A.AA)),ZC.Q.JZ({id:s.K+"-scroll",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute"},s.A.AA),s.o["scroll-x"]&&ZC.Q.HC({cls:"zc-abs",id:s.K+"-scroll-x-c",p:ZC.AK(s.K+"-scroll"),wh:c},s.A.AA),s.o["scroll-y"]&&ZC.Q.HC({cls:"zc-abs",id:s.K+"-scroll-y-c",p:ZC.AK(s.K+"-scroll"),wh:c},s.A.AA),ZC.Q.JZ({id:s.K+"-plots-vb",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute"},s.A.AA),s.A.NZ["value-box"])if(s.A.K9||s.AJ["3d"])ZC.Q.HC({cls:"zc-abs zc-layer zc-vb",id:s.K+"-plots-vb-c",p:ZC.AK(s.K+"-plots-vb"),wh:c},s.A.AA);else for(t=0,i=s.AY.A4.length;t<i;t++)ZC.Q.HC({cls:"zc-abs zc-layer zc-vb",id:s.K+"-plot-"+t+"-vb-c",p:ZC.AK(s.K+"-plots-vb"),wh:c},s.A.AA)}(s.o.title||s.o.subtitle||s.o.source||s.o["no-data"])&&(ZC.Q.JZ({id:s.K+"-titles",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute"},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-titles-c",p:ZC.AK(s.K+"-titles"),wh:c},s.A.AA)),ZC.Q.JZ({cls:"zc-abs",wh:c,id:s.K+"-hover",p:ZC.AK(s.A.K+"-hover"),"clip-path":f,clip:Z},s.A.AA),"canvas"===s.A.AA&&(ZC.AK(s.K+"-hover").style.clip=Z),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-hover-c",p:ZC.AK(s.K+"-hover"),wh:c},s.A.AA),s.A.NZ.maps&&-1!==JSON.stringify(s.o).indexOf("zingchart.maps")&&(ZC.Q.JZ({cls:"zc-abs",wh:c,id:s.K+"-objects-maps",p:ZC.AK(s.A.K+"-objects-maps"),"clip-path":f,clip:Z},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-sh-c",p:ZC.AK(s.K+"-objects-maps"),wh:c},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-c",p:ZC.AK(s.K+"-objects-maps"),wh:c},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-click-c",p:ZC.AK(s.K+"-objects-maps"),wh:c},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-hover-c",p:ZC.AK(s.K+"-objects-maps"),wh:c},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-print-c",p:ZC.AK(s.K+"-objects-maps"),wh:c,display:"none"},s.A.AA)),s.initObjectsLayers(),s.o.legend&&(ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-legend-c",p:ZC.AK(s.A.K+"-legend"),wh:c},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-legend-scroll-c",p:ZC.AK(s.A.K+"-legend"),wh:c},s.A.AA))}s.Z=s.H.usc()?s.H.mc():ZC.AK(s.K+"-c")},initObjectsLayers:function(){var e=this,t=e.A.I+"/"+e.A.F;!ZC.AK(e.K+"-objects-bottom")&&e.A.NZ["objects-bottom"]&&(e.o.shapes||e.o.labels||e.o.arrows||e.o.images)&&(ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-objects-bottom",p:ZC.AK(e.A.K+"-objects-bottom")},e.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-bottom-sh-c",p:ZC.AK(e.K+"-objects-bottom"),wh:t},e.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-bottom-c",p:ZC.AK(e.K+"-objects-bottom"),wh:t},e.A.AA)),!ZC.AK(e.K+"-objects-top")&&e.A.NZ["objects-top"]&&(e.o.shapes||e.o.labels||e.o.arrows||e.o.images)&&(ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-objects-top",p:ZC.AK(e.A.K+"-objects-top")},e.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-top-sh-c",p:ZC.AK(e.K+"-objects-top"),wh:t},e.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-top-c",p:ZC.AK(e.K+"-objects-top"),wh:t},e.A.AA)),(e.A.NZ["objects-bottom"]||e.A.NZ["objects-top"])&&(e.o.shapes||e.o.labels||e.o.arrows)&&ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-print-c",p:ZC.AK(e.K+"-objects-top"),wh:t,display:"none"},e.A.AA),!ZC.AK(e.K+"-objects-click")&&(e.A.NZ["objects-bottom"]||e.A.NZ["objects-top"])&&(e.o.shapes||e.o.labels||e.o.arrows||e.o.images)&&(ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-objects-click",p:ZC.AK(e.A.K+"-hover")},e.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-click-c",p:ZC.AK(e.K+"-objects-click"),wh:t},e.A.AA)),!ZC.AK(e.K+"-objects-hover")&&(e.A.NZ["objects-bottom"]||e.A.NZ["objects-top"])&&(e.o.shapes||e.o.labels||e.o.arrows||e.o.images)&&(ZC.Q.JZ({cls:"zc-abs",wh:t,id:e.K+"-objects-hover",p:ZC.AK(e.A.K+"-hover")},e.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-hover-c",p:ZC.AK(e.K+"-objects-hover"),wh:t},e.A.AA))},A0M:function(){},clear_:function(){},destroy:function(){var e,t=this;null!==ZC._n_(e=t.A.SA[t.K])&&"feed"===t.HP.type&&(e.send("zingchart.stopfeed"),e.close(),t.A.SA[t.K]=null),t.GG&&t.LW.stop(!0),t.MA="clear.init",t.unbind(),t.BD&&t.BD.unbind(),t.B9&&t.B9.unbind(),t.HS&&t.HS.unbind(),t.HQ&&t.HQ.unbind(),t.MA="clear.complete"},clear:function(e,t){null===ZC._n_(e)&&(e=!1),null===ZC._n_(t)&&(t=!1);var i,n,a,r,l=this;l.TG={},null===ZC._n_(i=l.A.SA[l.K])||e||"feed"===l.HP.type&&(i.send("zingchart.stopfeed"),i.close(),l.A.SA[l.K]=null),l.GG&&l.LW.stop(!0),l.MA="clear.init",l.unbind(e),l.A0M(!1,!0),l.LD(),l.LD("click"),l.LD("guide",!0),l.LD("print",!0),l.LD("textprint",!0),e||(!l.B9||l.B9&&!l.B9.LK)&&l.LD("static",!0),l.AY.YZ=[],l.A.ST=[],zingchart.SKIP.LEGEND||l.BD&&l.BD.clear(),l.E.datalength=[];var o,s,c,h=ZC.ie67?ZC.AK(l.A.K):null;if(ZC.mobile||ZC.ie67)ZC.A5("."+l.K+"-node-area",h).remove();else if(ZC.AK(l.A.K+"-img")&&ZC.AK(l.A.K+"-map")){ZC.AK(l.A.K+"-img").setAttribute("useMap","");var C=ZC.AK(l.A.K+"-map").cloneNode(!0);for(n=(a=C.childNodes.length)-1;n>=0;n--)-1!==C.childNodes[n].className.indexOf(l.K+"-node-area")&&C.removeChild(C.childNodes[n]);ZC.Q.EU(l.A.K+"-map"),ZC.AK(l.A.K+"-top").appendChild(C),ZC.AK(l.A.K+"-img").setAttribute("useMap","#"+l.A.K+"-map")}switch(ZC.Q.EU(l.K+"--graph"),l.AY.HE=[],ZC.A5("."+l.K+"-value-box",h).remove(),ZC.A5("."+l.K+"-scale-marker-label",h).remove(),ZC.A5("."+l.K+"-scale-item",h).remove(),ZC.A5("."+l.K+"-scale-label",h).remove(),ZC.A5("."+l.K+"-guide-label",h).remove(),ZC.A5("."+l.K+"-shape-label",h).remove(),ZC.A5("."+l.K+"-mapshape-label",h).remove(),e||ZC.A5("."+l.K+"-preview-item",h).remove(),l.A.AA){case"svg":for(n=0,a=l.AY.A4.length;n<a;n++)l.AY.A4[n].HI=null;ZC.A5("#"+l.A.K+"-defs").children().each(function(){"LINK"!==this.tagName.toUpperCase()&&(0!==this.id.indexOf(l.K+"-")&&1!==l.A.AG.length||(e?this.id!==l.K+"-gradient"&&-1===this.id.indexOf("-preview-gradient")&&-1===this.id.indexOf("-menu-trigger-gradient")&&-1!==this.id.indexOf(l.K+"-plotset-plot-")&&(t&&l.GG||-1!==this.id.indexOf(l.K+"-legend-")&&zingchart.SKIP.LEGEND||ZC.A5(this).remove()):-1===this.id.indexOf("zc-menu-")&&-1===this.id.indexOf("-menu-trigger-")&&(-1!==this.id.indexOf(l.K+"-legend-")?zingchart.SKIP.LEGEND||ZC.A5(this).remove():l.B9&&l.B9.LK?-1===this.id.indexOf("-preview-gradient")&&ZC.A5(this).remove():ZC.A5(this).remove())))}),e||ZC.Q.EU([l.K+"-clip",l.K+"-clip-hover",l.K+"-clip-preview"]),ZC.A5("#"+l.A.K+"-svg").children().each(function(){var e=l.K+"-";"clippath"===this.tagName.toLowerCase()&&this.id.substring(0,e.length)===e&&this.id!==l.K+"-clip"&&this.id!==l.K+"-clip-hover"&&this.id!==l.K+"-clip-preview"&&ZC.Q.EU(this.id)})}(ZC.Q.EU(l.K+"-nodata"),ZC.Q.EU(l.A.K+"-tooltip-text-float"),e||(ZC.Q.EU([l.K+"-title",l.K+"-subtitle",l.K+"-source",l.K+"-hover"]),zingchart.SKIP.LEGEND||l.BD&&(ZC.Q.EU(l.K+"-legend-c"),ZC.Q.EU(l.K+"-legend-scroll-c"),ZC.A5("."+l.K+"-legend-item-area",h).remove(),ZC.A5("."+l.K+"-legend-marker-area",h).remove(),ZC.A5("."+l.K+"-legend-item",h).remove(),ZC.A5("."+l.K+"-legend-header",h).remove(),ZC.A5("."+l.K+"-legend-footer",h).remove(),ZC.A5("."+l.K+"-legend-frame",h).remove(),l.BD.gc(),l.BD=null),l.B9&&(l.B9.LK&&!l.A.E.resize||(l.B9.unbind(),ZC.A5("."+l.K+"-preview-handler").remove(),ZC.A5("."+l.K+"-preview-mask").remove(),ZC.A5("#"+l.K+"-preview").remove(),l.B9.gc(),l.B9=null)),l.HS&&(l.HS.unbind(),l.HS=null),ZC.Q.IU(ZC.AK(l.K+"-scroll-x-c"),l.A.AA,l.iX,l.iY,l.I,l.F,l.K),ZC.Q.IU(ZC.AK(l.K+"-scroll-y-c"),l.A.AA,l.iX,l.iY,l.I,l.F,l.K),ZC.A5("#"+l.K+"-scroll-x-handle").remove(),ZC.A5("#"+l.K+"-scroll-x-bar").remove(),l.HQ&&(l.HQ.unbind(),l.HQ=null),ZC.A5("#"+l.K+"-scroll-y-handle").remove(),ZC.A5("#"+l.K+"-scroll-y-bar").remove(),ZC.A5("#"+l.K+"-c").empty(),l.H.QO[0]!==l.H.QO[1]&&""!==l.H.QO[1]&&("canvas"===l.H.AA&&ZC.A5("#"+l.K+" canvas").each(function(){this.width=1,this.height=1,ZC.Q.EU(this)}),ZC.A5("#"+l.K+" div").each(function(){ZC.Q.EU(this)}),ZC.Q.EU(l.K))),ZC.A5("#"+l.K+" .zc-layer").each(function(){var i=ZC.Q.T8(this);if(-1===i.indexOf("zc-persistent")){if(e&&(this.id===l.K+"-plotarea-c"||this.id===l.K+"-titles-c"))return;if(-1===this.id.indexOf(l.K+"-plot-")&&-1===this.id.indexOf(l.K+"-plots-"))ZC.Q.IU(this,l.H.AA,l.iX,l.iY,l.I,l.F,l.K);else if(t&&l.GG&&!l.HH){if("canvas"!==l.H.AA)for(var n=0,a=l.AY.A4.length;n<a;n++)l.E.datalength[n]=l.AY.A4[n].S.length;(r=l.A.K9?new RegExp("-plots-[a-z]+-c","g").exec(this.id):new RegExp("-plot-(\\d+)-[a-z]+-\\d+-","g").exec(this.id))&&(!l.E["plot"+r[1]+".visible"]&&"remove"===l.getToggleAction()||l.A.K9)&&ZC.Q.IU(this,l.H.AA,l.iX,l.iY,l.I,l.F,l.K),-1===i.indexOf("zc-vb")&&-1===i.indexOf("zc-fl")||ZC.Q.IU(this,l.H.AA,l.iX,l.iY,l.I,l.F,l.K)}else ZC.Q.IU(this,l.H.AA,l.iX,l.iY,l.I,l.F,l.K)}}),-1!==ZC.AV(l.H.KR,"use_single_canvas"))&&((o=ZC.AK(l.H.K+"-main-c"))&&ZC.Q.IU(o,l.H.AA,l.iX,l.iY,l.I,l.F,l.K),(s=ZC.AK(l.H.K+"-main-c-top"))&&ZC.Q.IU(s,l.H.AA,l.iX,l.iY,l.I,l.F,l.K),(c=ZC.AK(l.H.K+"-print-c"))&&ZC.Q.IU(c,l.H.AA,l.iX,l.iY,l.I,l.F,l.K));l.clear_(),l.A.E.resize=!1,l.MA="clear.complete"},unbind:function(e,t){null===ZC._n_(e)&&(e=!1);var i=this;(-1===ZC.AV(i.H.KR,"skip_interactivity")||t)&&(ZC.A5("."+i.K+"-node-area").die("mousedown mouseover touchstart",i.X2).die("mouseup mouseout touchend",i.A1U).die("mousemove touchmove",i.A0R).die("click",i.TB).die("contextmenu",i.TB).die("dblclick",i.A1B),i.BD&&(zingchart.SKIP.LEGEND||(ZC.A5("."+i.K+"-legend-item-area").die("mouseup touchstart",i.SP).die("DOMMouseScroll",i.zc_legend_mousescroll).die("mousewheel",i.zc_legend_mousescroll),ZC.A5("."+i.K+"-legend-marker-area").die("mouseup touchstart",i.SP).die("DOMMouseScroll",i.zc_legend_mousescroll).die("mousewheel",i.zc_legend_mousescroll),ZC.A5("#"+i.K+"-legend-frame").die("DOMMouseScroll",i.zc_legend_mousescroll).die("mousewheel",i.zc_legend_mousescroll),ZC.mobile||(ZC.A5("."+i.K+"-legend-item-area").die(ZC.Q.BZ("mouseover"),i.QQ).die(ZC.Q.BZ("mouseout"),i.R9).die(ZC.Q.BZ("mousemove"),i.PN),ZC.A5("."+i.K+"-legend-marker-area").die(ZC.Q.BZ("mouseover"),i.QQ).die(ZC.Q.BZ("mouseout"),i.R9).die(ZC.Q.BZ("mousemove"),i.PN))))),i.AC7()},AC7:function(){},S9:function(){},QR:function(){},KK:function(){},SF:function(){},S0:function(){},LD:function(e,t){var i=this;e=e||"hover",null===ZC._n_(t)&&(t=!1);var n=ZC.AK((t?i.A.K:i.K)+"-"+e+"-c");n&&(ZC.Q.IU(n,i.H.AA,i.iX,i.iY,i.I,i.F,i.K,"textprint"===e),ZC.A5("."+i.K+"-label-hover").remove()),"hover"===e&&(ZC.Q.IU(ZC.AK(i.K+"-objects-hover-c"),i.H.AA,i.iX,i.iY,i.I,i.F,i.K),ZC.Q.IU(ZC.AK(i.K+"-objects-maps-hover-c"),i.H.AA,i.iX,i.iY,i.I,i.F,i.K),zingchart.DEV.PLOTSHLAYER&&ZC.Q.IU(ZC.AK(i.K+"-plots-hover-c"),i.H.AA,i.iX,i.iY,i.I,i.F,i.K)),"click"===e&&(ZC.Q.IU(ZC.AK(i.K+"-objects-click-c"),i.H.AA,i.iX,i.iY,i.I,i.F,i.K),ZC.Q.IU(ZC.AK(i.K+"-objects-maps-click-c"),i.H.AA,i.iX,i.iY,i.I,i.F,i.K)),i.hideLayer_(e,t)},hideLayer_:function(){},A6U:function(e,t){var i,n=this;if(null!==ZC._n_(e)&&null!==ZC._n_(t)){var a=n.AY.A4[e].IZ,r=n.AY.A4[e].RO;if("none"===a)return;if(null!==ZC._n_(n.CB["p"+e])){if(null!==ZC._n_(n.CB["p"+e]["n"+t])){if(delete n.CB["p"+e]["n"+t],r)for(i=0;i<n.AY.A4.length;i++)delete n.CB["p"+i]["n"+t]}else if("graph"===a?(n.CB={},n.CB["p"+e]={}):"plot"===a&&(n.CB["p"+e]={}),n.CB["p"+e]["n"+t]=!0,r)for(i=0;i<n.AY.A4.length;i++)n.CB["p"+i]=n.CB["p"+i]||{},n.CB["p"+i]["n"+t]=!0}else if("graph"===a&&(n.CB={}),n.CB["p"+e]={},n.CB["p"+e]["n"+t]=!0,r)for(i=0;i<n.AY.A4.length;i++)n.CB["p"+i]=n.CB["p"+i]||{},n.CB["p"+i]["n"+t]=!0}null!==ZC._n_(e)&&null!==ZC._n_(t)&&(n.HH=!0,n.K6(!0,!0))},paint:function(e){null===ZC._n_(e)&&(e=!1);var t,i,n,a,r,l,o=this;o.A.GRAPHID=o.K,o.UX=e,window.clearTimeout(ZC.ASYNC_TICK[o.K]),o.A.clearLabelBoxes("vb"+o.L);var s,c,h,C,u,d,A,p=o.BU("k")[0],g=ZC.MAX,Z=-ZC.MAX,f={},_=o.AY.A4,b=0;for(C=0;C<_.length;C++)if(_[C].o.rel)for(h=0;h<_.length;h++)if(_[h].o.id&&_[h].o.id===_[C].o.rel){b++,A=!0;var m=[];for(r=0;r<_[h].S.length;r++)(p.EF?_[h].S[r].BT>=p.B3&&_[h].S[r].BT<=p.BJ:_[h].S[r].L>=p.W&&_[h].S[r].L<=p.A1)?(s=_[h].S[r].AD,g=Math.min(g,s),Z=Math.max(Z,s),A?(A=!1,_[h].S[r].BT?m.push([_[h].S[r].BT,0]):m.push(0),d=s):_[h].S[r].BT?m.push([_[h].S[r].BT,100*(s-d)/d]):m.push(100*(s-d)/d)):_[h].S[r].BT?m.push([_[h].S[r].BT,0]):m.push(0);f["p-"+C]=[].concat(m)}if(b>0){for(g=ZC.MAX,Z=-ZC.MAX,C=0;C<_.length;C++)if(_[C].o.rel&&f["p-"+C])for(r=0;r<_[C].S.length;r++)2===(c=f["p-"+C][r]).length?(s=c[1],_[C].V[r]=c,_[C].S[r].AD=_[C].S[r].CS=c[1]):(s=c,_[C].V[r]=_[C].S[r].AD=_[C].S[r].CS=c),_[C].FK(r),g=Math.min(g,s),Z=Math.max(Z,s);var v=o.BU("v")[0];v.RQ(g,Z,!0),v.J1()}for(o.A.E["g-"+o.L+"-selection"]&&(o.CB=JSON.parse(o.A.E["g-"+o.L+"-selection"])),o.KI=!1,i=0,n=o.AY.A4.length;i<n;i++)o.IX[i]=!1;for(i in o.CB)if(o.CB.hasOwnProperty(i)){var E=ZC._i_(i.replace("p",""));for(u in o.CB[i])if(o.CB[i].hasOwnProperty(u)){o.IX[E]=!0,o.KI=!0;break}}function D(){if(o.AJ["3d"]){var e=ZC.DI.DB(o.P,o,o.P.iX-ZC.AO.E2,o.P.iX-ZC.AO.E2+o.P.I,o.P.iY-ZC.AO.E3,o.P.iY-ZC.AO.E3+o.P.F,ZC.AO.FT+10,ZC.AO.FT+10,"y"),i=ZC.DI.DB(o.P,o,o.P.iX-ZC.AO.E2,o.P.iX-ZC.AO.E2+o.P.I,o.P.iY-ZC.AO.E3,o.P.iY-ZC.AO.E3+o.P.F,ZC.AO.FT,ZC.AO.FT,"y");i.K=o.K+"-plotarea",i.PA=e.D,o.CL.add(i)}else{o.P.Z=o.P.C7=o.H.usc()?o.H.mc():ZC.AK(o.K+"-plotarea-c");var n,a=[o.P.iX,o.P.iY,o.P.I,o.P.F],r=o.P.AU,l=o.P.AU,s=o.P.AU,c=o.P.AU;""!==(t=o.P.Q1)&&(n=t.split(/\s/),r=ZC._i_(n[0])),""!==(t=o.P.OJ)&&(n=t.split(/\s/),l=ZC._i_(n[0])),""!==(t=o.P.NP)&&(n=t.split(/\s/),s=ZC._i_(n[0])),""!==(t=o.P.P6)&&(n=t.split(/\s/),c=ZC._i_(n[0])),o.P.iX-=c+1,o.P.iY-=r+1,o.P.I+=c+l+1,o.P.F+=r+s+1,o.P.paint(),o.P.iX=a[0],o.P.iY=a[1],o.P.I=a[2],o.P.F=a[3]}}if(o.A.A0C(),o.NX(),o.UX?o.E["plotarea.paint"]&&(D(),o.E["plotarea.paint"]=null):(o.build(),o.Z&&(o.C7=o.Z,o.b()),D()),"xy"===o.AJ.layout||"yx"===o.AJ.layout){var w=o.BU("v"),x=null;for(r=0;r<w.length;r++)(0===r||w[r].o["ref-zero"])&&w[r].FW<=0&&w[r].H1>=0&&w[r].T9&&(x=r);if(null!==ZC._n_(x)){var B=w[x].AT(0);for(r=0;r<w.length;r++)if(r!==x&&w[r].o["sync-zero"]&&w[r].FW<=0&&w[r].H1>=0&&w[r].T9){var y=w[r].AT(0);if(ZC._a_(y-B)>=1)for(var K=!0,F=0;K;)y>B?w[r].CO?w[r].AW?w[r].AB+=1:w[r].BV+=1:w[r].AW?w[r].BV+=1:w[r].AB+=1:w[r].CO?w[r].AW?w[r].BV+=1:w[r].AB+=1:w[r].AW?w[r].AB+=1:w[r].BV+=1,F++,w[r].J1(),w[r].A7U(),(F>(w[r].CO?o.P.I:o.P.F)||ZC._a_(w[r].AT(0)-B)<1)&&(K=!1)}}}for(r=0,l=o.BO.length;r<l;r++)o.BO[r].Z=o.BO[r].C7=o.H.usc()?o.H.mc():ZC.AK(o.K+"-scales-bl-0-c"),o.A.O7=!0,o.BO[r].paint(),o.A.ZV(),o.A.O7=!1;var M="undefined"!=typeof o.E["shared-zoom"]&&null!==ZC._n_(o.E["shared-zoom"])&&o.E["shared-zoom"];if(o.B9&&o.B9.LK?o.B9.I2&&(o.B9.I2=!0,o.B9.paint()):o.E["skip-preview"]||!o.B9||o.UX&&!o.B9.I2||M||(o.B9.I2=!0,o.B9.paint()),o.E["shared-zoom"]=null,o.E["skip-preview"]=null,o.HS&&o.HS.paint(),o.HQ&&o.HQ.paint(),o.UX||(a=o.H.usc()?o.H.mc():ZC.AK(o.K+"-titles-c"),o.IR&&o.IR.AN&&null!==ZC._n_(o.IR.AM)&&(o.IR.Z=o.IR.C7=a,o.IR.paint(),!o.IR.K9&&ZC.AK(o.A.K+"-map")&&(ZC.AK(o.A.K+"-map").innerHTML+=ZC.AP.O5(o.K,o.IR))),o.K0&&o.K0.AN&&null!==ZC._n_(o.K0.AM)&&(o.K0.Z=o.K0.C7=a,o.K0.paint(),!o.K0.K9&&ZC.AK(o.A.K+"-map")&&(ZC.AK(o.A.K+"-map").innerHTML+=ZC.AP.O5(o.K,o.K0))),o.MR&&o.MR.AN&&null!==ZC._n_(o.MR.AM)&&(o.MR.Z=o.MR.C7=a,o.MR.paint(),!o.MR.K9&&ZC.AK(o.A.K+"-map")&&(ZC.AK(o.A.K+"-map").innerHTML+=ZC.AP.O5(o.K,o.MR))),o.S5&&o.S5.AN&&null!==ZC._n_(o.S5.AM)&&(o.S5.Z=o.S5.C7=a,o.S5.paint())),o.IR&&o.IR.EK(),o.K0&&o.K0.EK(),o.MR&&o.MR.EK(),o.AJ["3d"]||o.UD(),o.A.O7=!o.GG,zingchart.DEV.SKIPTRACKERS&&(o.A.O7=!1),o.A.E["graph."+o.K+".disableanimation"])for(r=0,l=o.AY.A4.length;r<l;r++)o.AY.A4[r].GG=!1;o.AY.paint(),o.H.paintHistory()},UD:function(){},clearPreview:function(){var e=this;e.B9&&(ZC.Q.IU(ZC.AK(e.K+"-preview-c"),e.A.AA,e.iX,e.iY,e.I,e.F,e.K),e.A.H2&&!e.A.H2.A0G&&e.B9.reset(),e.B9.I2=!0)},flatten:function(){},_end_:function(){var e,t,i,n,a=this;for(a.E["toggle-action-remove"]=null,a.GG||a.A.ZV(),a.A.O7=!1,(a.LK||!a.GG||a.H.E["graph."+a.K+".disableanimation"]||!a.AJ["enable-animation"]||-1!==ZC.AV(a.H.KR,"skip_interactivity")||zingchart.SKIP.ANIMATION)&&(a.MA="ready"),"initial"===a.A1Q&&(a.ABO=!1,a.H.E["graph."+a.K+".disableanimation"]=!0),t=0,i=a.BO.length;t<i;t++)a.BO[t].paint_();if(!a.A.E["fire-load"]){var r=ZC.AP.BY("objectsinit",a.A,a.GX(),!0);if(r)for(var l=["labels","shapes","imges","arrows"],o=0;o<l.length;o++)r[l[o]]&&(a.o[l[o]]=(a.o[l[o]]||[]).concat(r[l[o]]))}function s(e){var t,i,n=(e.targetid||e.target.id).replace("-area-path","").replace("-path","").replace(/--([a-zA-Z0-9]+)/,"").replace("-marker","").replace("-circle","").split("-").reverse();return"node"===n[1]&&(t=n[2],i=n[0]),[t,i]}if(a.AJ["3d"]||(a.flatten(),a.PW(),a.KK(),-1===ZC.AV(a.H.KR,"skip_interactivity")&&a.S0()),-1===ZC.AV(a.H.KR,"skip_interactivity")){var c=ZC.A5("."+a.K+"-node-area");a.X2=function(e){if(!(zingchart.NODE_EV&&"mouseover"===zingchart.NODE_EV_TYPE&&"mouseover"===e.type||(zingchart.NODE_EV_CHART=a.A.K,zingchart.NODE_EV=e,zingchart.NODE_EV_TYPE=e.type,ZC.move||a.BD&&a.BD.YF||-1===ZC.Q.T8(e.target).indexOf("zc-node-area")||"ready"!==a.MA))){ZC.mobile&&(a.E["node-target-id"]=e.target.id,ZC.move=!1,a.H.hideCM(),null===a.H.DF||null===ZC._n_(a.H.DF["page-scroll"])||a.H.DF["page-scroll"]||e.preventDefault(),a.A.YI(e));var n=s(e);if(a.AY.A4[n[0]]){var r=a.AY.A4[n[0]].FK(n[1]);if(r&&(r.N?(ZC.COLORS=[r.N.C2,r.N.A0,r.N.AE,r.N.BW,r.N.B7],r.NC&&ZC.COLORS.push(r.NC.A0,r.NC.AE,r.NC.BW,r.NC.B7)):ZC.COLORS=[],a.E["plot"+n[0]+".visible"])){var l=ZC.mobile?"mousedown":e.xtype||e.type;(ZC.mobile||"mousedown"!==l)&&a.A.A7&&a.A7&&a.A7.AN&&a.A.A7.onmouseover(e);var o=a.AY.A4[n[0]];if("plot"===o.A3K)for(t=0,i=o.S.length;t<i;t++)o.S[t]&&o.FK(t).A0W("hover");else r.A0W("hover");if(r.X4(e,l),r.A.X5(e,l),a.BD){ZC.move=!0;var c=n[0];a.AY.A4[c].o["legend-item"]&&null!==ZC._n_(a.AY.A4[c].o["legend-item"].order)&&(c=ZC._i_(a.AY.A4[c].o["legend-item"].order)),a.BD.o["reverse-series"]&&(c=a.AY.A4.length-1-c),a.BD.PQ?a.L===a.A.AG.length-1&&a.BD.highlightItem(c):a.BD.highlightItem(c),ZC.move=!1}}}}},c.live("mousedown mouseover touchstart",a.X2),a.A1U=function(e){if(zingchart.NODE_EV=zingchart.NODE_EV_TYPE=null,zingchart.NODE_EV_CHART=null,!(ZC.move||a.BD&&a.BD.YF)){var t=e.target;if(ZC.mobile&&document.elementFromPoint){var i=ZC.Q.MB(e),n=Math.max(window.pageXOffset,document.documentElement.scrollLeft,document.body.scrollLeft),r=Math.max(window.pageYOffset,document.documentElement.scrollTop,document.body.scrollTop);if((t=document.elementFromPoint(i[0]-n,i[1]-r))&&a.E["node-target-id"]&&a.E["node-target-id"]!==t.id)return}if(-1!==ZC.Q.T8(e.target).indexOf("zc-node-area")&&"ready"===a.MA){ZC.mobile&&a.A.OU(e);var l=s(e),o=a.AY.A4[l[0]].FK(l[1]);if(o){if(a.E["plot"+l[0]+".visible"]){a.A.A7&&a.A7&&a.A7.AN&&a.A.A7.onmouseout(e),a.AY.A4[l[0]].D=[],o.LD(),a.LD();var c=ZC.mobile?"mouseup":e.xtype||e.type;o.X4(e,c),o.A.X5(e,c),a.BD&&(ZC.move=!0,a.BD.PQ?a.L===a.A.AG.length-1&&a.BD.highlightItem(-1):a.BD.highlightItem(-1),ZC.move=!1)}!ZC.mobile||a.H.AA2||ZC.move||"touchend"!==e.type||(zingchart.SB(e),a.TB(e))}}}},c.live("mouseup mouseout touchend",a.A1U),a.A0R=function(e){if(zingchart.NODE_EV=e,zingchart.NODE_EV_CHART=a.A.K,zingchart.NODE_EV_TYPE=e.type,-1!==ZC.Q.T8(e.target).indexOf("zc-node-area")&&"ready"===a.MA){ZC.mobile&&a.A.OU(e);var t=s(e);a.E["plot"+t[0]+".visible"]&&a.A.A7&&a.A7&&a.A7.AN&&a.A.A7.onmousemove(e)}},c.live("mousemove touchmove",a.A0R),a.TB=function(e){if((e.targetid||-1!==ZC.Q.T8(e.target).indexOf("zc-node-area"))&&"ready"===a.MA){var t=s(e),i=a.AY.A4[t[0]].FK(t[1]);if(i&&("none"===i.A.IZ||!ZC.mobile&&0!==e.button||(a.A.E.preservezoom=!0,a.clearPreview(),a.A6U(i.A.L,i.L)),i.X4(e,"click"),i.A.X5(e,"click"),null!==ZC._n_(i.A.EA)&&"NULL"!==i.A.EA))if(i.A.EA instanceof Array)for(var n=0;n<i.A.EA.length;n++){var r=i.A.FB;i.A.FB instanceof Array&&(r=i.A.FB[n]||"graph="+(a.o.id||"")),n===i.L&&a.UZ(e,i.JV(i.A.EA[n],null,null,!0),r)}else a.UZ(e,i.JV(i.A.EA,null,null,!0),i.A.FB||"graph="+(a.o.id||""))}},a.A1B=function(e){if(-1!==ZC.Q.T8(e.target).indexOf("zc-node-area")&&"ready"===a.MA){var t=s(e),i=a.AY.A4[t[0]].FK(t[1]);i&&(i.X4(e,"doubleclick"),i.A.X5(e,"doubleclick"))}},ZC.mobile||c.live("click",a.TB).live("contextmenu",a.TB).live("dblclick",a.A1B)}if(a.AC2(),a.A.E["tr-ev-"+a.L]?(a.A.E["tr-ev-"+a.L]=null,a.A7Q()):a.A7Q(),a.A17){a.A17=!1;var h={graphid:a.K};for(t=0,i=a.BU("k").length;t<i;t++){var C=a.BU("k")[t];null!==ZC._n_(e=C.KN)&&(h["zoomx"+(n=1===C.L?"":"-"+C.L)]=!0,h["xmin"+n]=e[0],h["xmax"+n]=e[1])}for(t=0,i=a.BU("v").length;t<i;t++){var u=a.BU("v")[t];null!==ZC._n_(e=u.KN)&&(h["zoomy"+(n=1===u.L?"":"-"+u.L)]=!0,h["ymin"+n]=e[0],h["ymax"+n]=e[1])}if(h.zoomto=!0,a.A.G1){for(var d in a.A.G1)ZC.AK(d).appendChild(a.A.G1[d]);a.A.G1=null}a.A.PV(h)}},AC2:function(){},A7Q:function(){var e=this;if(e.A.A28<e.A.AG.length&&(e.A.A28++,ZC.AP.BY("gload",e.A,e.GX())),ZC.AP.BY("gcomplete",e.A,e.GX()),e.B9&&(e.B9.I2=!1),zingchart.NODE_EV&&zingchart.NODE_EV_CHART&&zingchart.NODE_EV_CHART===e.A.K){var t=ZC.A5("#"+e.A.K+"-top"),i=ZC.E1[0]-t.offset().left,n=ZC.E1[1]-t.offset().top,a=zingchart.exec(e.A.K,"getxyinfo",{x:i,y:n});if(a)for(var r=0;r<a.length;r++)if("node"===a[r].infotype&&a[r].xydistance<10){var l=a[r].graphid+"-plotset-plot-"+a[r].plotidx+"-node-"+a[r].nodeidx;zingchart.NODE_EV&&zingchart.NODE_EV.target&&zingchart.NODE_EV.target.id===l&&(e.X2(zingchart.NODE_EV),zingchart.NODE_EV=null)}}zingchart.GUIDE_EV&&e.A.D7&&e.A.D7.Q7(zingchart.GUIDE_EV),e.A.A4G<e.A.AG.length?e.A.A4G++:(e.A.A4G=1,e.A.A28===e.A.AG.length&&(e.A.A28++,e.A.E["fire-load"]=!0,e.LK&&e.AY.A4.length>1&&(zingchart.SKIP.EVENT||ZC.AP.BY("load",e.A,e.A.FE()))),e.A.E["fire-complete"]=!0,(e.E["graph-K6"]||e.LK&&e.AY.A4.length>1)&&(zingchart.SKIP.EVENT||ZC.AP.BY("complete",e.A,e.A.FE()),e.E["graph-K6"]=null)),0!==e.A.QL.length&&e.A.QL[e.A.QL.length-1]===e.A.E.json||(e.A.QL[e.A.NS]!==e.A.E.json&&(e.A.QL.length=e.A.NS+1),e.A.QL[e.A.NS]=e.A.E.json)},K6:function(e,t){var i=this;null===ZC._n_(e)&&(e=!1),null===ZC._n_(t)&&(t=!1),i.A.N3(i),i.E["graph-K6"]=!0,i.clear(e,t),i.parse(),i.U5&&i.U5(),i.paint(e),i.B9&&i.B9.setScalesInfo(),i.HH=!1,zingchart.SKIP.CSV=!1},UZ:function(ev,EA,FB){if(2!==ev.button){var s=this,C,P9=[""];switch(null!==ZC._n_(FB)&&(P9=FB.split("=")),P9[0]){case"_blank":window.open(EA,"_blank");break;case"_top":window.top.location.href=EA;break;case"_parent":window.parent.location.href=EA;break;case"window":null!==ZC._n_(P9[1])&&""!==P9[1]&&(window.top[P9[1]].location.href=EA);break;case"graph":var Y3=null;if("()"===EA.substring(EA.length-2)||"javascript:"===EA.substring(0,11))try{var EC=EA.replace("javascript:","").replace("()","");eval(EC)&&(Y3=eval(EC).call(s))}catch(e){}null!==ZC._n_(P9[1])&&""!==P9[1]?"_top"===P9[1]||"_parent"===P9[1]?(s.A.N3(),Y3?zingchart.exec(s.A.K,"setdata",{data:Y3}):s.A.load(null,EA)):(C=s.A.OQ(P9[1]),C&&(s.A.N3(C),s.A.E["tr-ev-"+C.L]=!0,s.A.NS++,Y3?zingchart.exec(s.A.K,"setdata",{graphid:P9[1],data:Y3}):s.A.load(P9[1],EA))):(C=s.A.AG[0],s.A.N3(C),Y3?zingchart.exec(s.A.K,"setdata",{graphid:C.K,data:Y3}):(s.A.E["tr-ev-"+C.L]=!0,s.A.NS++,s.A.load(C.K,EA)));break;default:window.location.href=EA}}},I0:function(e,t,i){var n=this;if(null===ZC._n_(i)&&(i=n.AY.A4.length-1),null!==ZC._n_(e)&&void 0!==e)return n.AY.A4[e];if(null===ZC._n_(t)||void 0===t)return n.AY.A4[i];for(var a=0,r=n.AY.A4.length;a<r;a++)if(t===n.AY.A4[a].H8)return n.AY.A4[a];return null},A3C:function(e,t){var i,n,a=this;(e=e||{})["toggle-action"]=e["toggle-action"]||a.getToggleAction();var r=null;if("undefined"!=typeof e.plotindex&&(r=ZC._i_(e.plotindex)),-1===r)for(r=[],i=0,n=a.AY.A4.length;i<n;i++)r.push(i);r instanceof Array||(r=[r]);var l=e.plotid||"";l instanceof Array||(l=[l]);var o=[];for(i=0,n=ZC.BQ(r.length,l.length);i<n;i++){var s=a.I0(r[i],l[i]);if(s){var c={};ZC._cp_(e,c);var h=s.L;c.plotindex=h,c.plotid=s.H8,("show"===t&&!a.E["plot"+h+".visible"]||"hide"===t&&a.E["plot"+h+".visible"])&&o.push(c)}}for(i=0,n=o.length;i<n;i++)a.A.o.graphset[a.L].series[o[i].plotindex].visible="show"===t,i===n-1&&(o[i].K6=1),a.QC(o[i])},QC:function(e){var t,i,n,a=this;a.A.E["graph."+a.K+".disableanimation"]=!1,e=e||{};var r=!1;null!==ZC._n_(e.skip)&&e.skip&&(r=!0),null===ZC._n_(e.update)||e.update||(r=!0);var l=!1;e["toggle-action"]=e["toggle-action"]||a.getToggleAction(),null!==ZC._n_(t=e["ignore-legend"])&&(l=ZC._b_(t));var o=a.I0(e.plotindex,e.plotid);if(o){var s=o.L;switch(e["toggle-action"]){case"hide":if(a.BD&&(a.BD.E.showhide=!0),a.E["plot"+s+".visible"]=!a.E["plot"+s+".visible"],null!==ZC._n_(a.A.o.graphset[a.L].series)&&(a.A.o.graphset[a.L].series[s].visible=a.E["plot"+s+".visible"]),a.AJ["3d"])l=!0,r||a.K6();else{var c=a.E["plot"+s+".visible"]?"block":"none";if(zingchart.DEV.SKIPTRACKERS||ZC.A5("."+a.K+"-plotset-plot-"+s+"-node-area").each(function(){if("AREA"===this.tagName.toUpperCase()){var e=ZC.A5(this),t=e.attr("coords"),n=e.attr("shape");"none"===c?(t="-"+t.replace(/,/g,",-"),"rect"===n?4===(i=t.split(",")).length&&(t=[i[2],i[3],i[0],i[1]].join(",")):"circle"===n&&3===(i=t.split(",")).length&&(t=[i[0],i[1],-i[2]].join(","))):(t=t.replace(/\-/g,""),"rect"===n&&4===(i=t.split(",")).length&&(t=[i[2],i[3],i[0],i[1]].join(","))),e.attr("coords",t)}}),a.A.K9)ZC.AK(a.K+"-plots-bl-c").style.display=c,ZC.AK(a.K+"-plots-fl-c").style.display=c,ZC.AK(a.K+"-plots-vb-c").style.display=c;else{for(n=0;n<o.SV;n++)(t=ZC.AK(a.K+"-plot-"+s+"-bl-"+n+"-c"))&&(t.style.display=c);for(n=0;n<o.A1G;n++)(t=ZC.AK(a.K+"-plot-"+s+"-fl-"+n+"-c"))&&(t.style.display=c);(t=ZC.AK(a.K+"-plot-"+s+"-vb-c"))&&(t.style.display=c)}var h=ZC.A5("."+a.K+"-plot-"+s+"-value-box");a.E["plot"+s+".visible"]?(h.show(),ZC.A5("."+a.K+"-plotset-plot-"+s+"-preview").show()):(h.hide(),ZC.A5("."+a.K+"-plotset-plot-"+s+"-preview").hide())}break;case"remove":a.clearPreview(),l=!0,a.E["toggle-action-remove"]=!0,a.E["plot"+s+".visible"]=!a.E["plot"+s+".visible"],e.K6&&(r||(a.LV("on-legend-toggle"),a.K6(!0,!0)))}a.BD&&!l&&(a.BD.clear(),a.BD.paint())}},LV:function(e){var t=this,i=!0,n=t.o.plot||{};null!==ZC._n_(n.animation)&&null!==ZC._n_(n.animation[e])&&(i=ZC._b_(n.animation[e])),t.HH="initial"===t.A1Q||!i},GX:function(){return{id:this.A.K,graphidx:this.L,graphid:this.K.replace(this.A.K+"-graph-",""),x:this.iX,y:this.iY,width:this.I,height:this.F,loader:this.A.FE()}},RY:function(){},RV:function(){},gc:function(){for(var e=0;e<this.BO.length;e++)this.BO[e].gc();for(var t=0;t<this.AY.A4.length;t++)this.AY.A4[t].gc();ZC.AP.gc(this.AY,["A","C","H","F8","o","I6","J9"]),ZC.AP.gc(this,["Z","C7","AJ","IR","K0","MR","F0"])}}),ZC.AAJ=ZC.JI.CA({$i:function(e){this.b(e);var t=this;t.AF="null",t.AJ.clip=!0,t.AJ["enable-guide"]=!0,t.AJ["enable-preview"]=!0}}),ZC.WI.push("null3d"),ZC.A8M=ZC.JI.CA({$i:function(e){this.b(e);var t=this;t.AF="null3d",t.CL=new ZC.SJ,t.AJ["3d"]=!0,t.AJ["x-angle-min"]=-1800,t.AJ["x-angle-max"]=1800,t.AJ["y-angle-min"]=-1800,t.AJ["y-angle-max"]=1800,t.AJ["z-angle-min"]=-1800,t.AJ["z-angle-max"]=1800,zingchart.V3D=3},clear:function(){this.b(),this.CL.clear()},paint:function(){var e=this;e.b(),e.PW(),e.S9(),e.flatten(),e.KK(),-1===ZC.AV(e.H.KR,"skip_interactivity")&&e.S0()}}),ZC.NI=ZC.JI.CA({$i:function(e){this.b(e);var t=this;t.AF="xy",t.AJ.clip=!0,t.AJ.layout="xy"},MO:function(e){switch(e){case"x":return new ZC.Q6(this);case"y":return new ZC.Q3(this)}},ACN:function(){var e,t=this,i=t.MO("x","scale-x");for(i.BE="scale-x",i.K=t.K+"-scale-x",t.BO.push(i),e=2;e<50;e++)if(null!==ZC._n_(t.o["scale-x-"+e])){var n=t.MO("x","scale-x-"+e);n.L=e,n.BE="scale-x-"+e,n.K=t.K+"-scale-x-"+e,t.BO.push(n)}var a=t.MO("y","scale-y");for(a.BE="scale-y",a.K=t.K+"-scale-y",t.BO.push(a),e=2;e<50;e++)if(null!==ZC._n_(t.o["scale-y-"+e])){var r=t.MO("y","scale-y-"+e);r.L=e,r.BE="scale-y-"+e,r.K=t.K+"-scale-y-"+e,t.BO.push(r)}t.b()}}),ZC.A58=ZC.NI.CA({$i:function(e){this.b(e);var t=this;t.AF="mixed",t.AY=new ZC.ZE(t),t.AJ["enable-guide"]=!0,t.AJ["enable-preview"]=!0,t.AJ["enable-scroll"]=!0},MO:function(e,t){switch(e){case"x":var i=!1;if(this.o.series)for(var n=0;n<this.o.series.length;n++)if(this.o.series[n]&&this.o.series[n].type&&-1!==ZC.AV(["bar","vbar","bullet","vbullet","stock","vbar3d"],this.o.series[n].type)){var a=(this.o.series[n].scales||"scale-x,scale-y").split(",");-1!==ZC.AV(a,t)&&(i=!0)}var r=this.b(e,t);return r.DJ=i,r;case"y":return this.b(e,t)}}}),ZC.A8Q=ZC.NI.CA({$i:function(e){this.b(e);var t=this;t.AF="hmixed",t.AJ.layout="yx",t.AJ["enable-guide"]=!0,t.AJ["enable-preview"]=!1,t.AJ["enable-scroll"]=!0,t.AY=new ZC.ZE(t)},MO:function(e,t){switch(e){case"x":var i=new ZC.SU(this),n=!1;if(this.o.series)for(var a=0;a<this.o.series.length;a++)if(this.o.series[a]&&this.o.series[a].type&&-1!==ZC.AV(["hbar","hbullet"],this.o.series[a].type)){var r=(this.o.series[a].scales||"scale-x,scale-y").split(",");-1!==ZC.AV(r,t)&&(n=!0)}return i.DJ=n,i;case"y":return new ZC.SR(this)}}}),ZC.A31=ZC.A58.CA({$i:function(e){this.b(e);var t=this;t.AF="mixed3d",t.AY=new ZC.ZE(t),t.CL=new ZC.SJ,t.AJ["3d"]=!0,t.AJ["enable-preview"]=!1,t.AJ["enable-animation"]=!1,t.AJ["enable-scroll"]=!0},clear:function(){this.b(),this.CL.clear()},paint:function(){var e=this;e.b(),e.S9(),e.flatten(),e.PW(),e.FA.length&&(e.CL.clear(),e.KK(),e.S9()),e.UD(),-1===ZC.AV(e.H.KR,"skip_interactivity")&&e.S0()}}),ZC.LJ=ZC.HL.CA({$i:function(e){this.b(e);var t=this;t.C=e,t.H=t.C.A,t.A4=[],t.HE=null,t.KB=[],t.K3=[],t.PU=!0,t.F8=null,t.A4X=!0,t.YZ=[]},ACW:function(){return new ZC.HV(this)},parse:function(){var e,t,i,n=this;for(n.K=n.A.K+"-plotset",n.F8=null,t=n.o.length-1;t>=0;t--)"undefined"==typeof n.o[t]&&n.o.splice(t,1);if(null===ZC._n_(n.E["plot-sort"])&&(n.E["plot-sort"]=!1),n.o.length>1){for(t=0,i=n.o.length;t<i;t++)"undefined"==typeof n.o[t].palette&&(n.o[t].palette=t);var a=[],r=[];for(t=0,i=n.o.length;t<i;t++)r[t]=t,a[t]={"z-index":n.o[t]["z-index"]||0};for(var l=!1;!l;)for(l=!0,t=0,i=a.length;t<i-1;t++){if(a[t]["z-index"]>a[t+1]["z-index"]){n.E["plot-sort"]=!0;var o=a[t];a[t]=a[t+1],a[t+1]=o;var s=r[t];r[t]=r[t+1],r[t+1]=s,l=!1}}n.M2=r}else n.M2=[0];for(n.A4=[],t=0,i=n.o.length;t<i;t++){var c="";n.A.o.plot&&null!==ZC._n_(e=n.A.o.plot.type)&&(c=e),null!==ZC._n_(e=n.o[t].type)&&(c=e);var h=n.ACW(c,t);h.OG=h.AF+"plot",h.L=t,h.JR=t,n.C.A.B8.load(h.o,["("+h.AF+").plot"]),h.sTypeX&&n.C.A.B8.load(h.o,["("+h.sTypeX+").plot"]),n.C.A.B8.load(h.o,["("+h.AF+").plot.animation"]),null!==ZC._n_(e=n.A.o.plot)&&h.append(e),h.append(n.o[t]),h.CC=n.A.CC,h.parse(),n.A4.push(h)}var C={},u=[],d=[],A={},p={},g=0,Z=0;for(t=0,i=n.A4.length;t<i;t++)if(null!==ZC._n_(n.A.A.E["g-"+n.A.L+"-p-"+t+".visible"])&&(n.C.E["plot"+t+".visible"]=n.A.A.E["g-"+n.A.L+"-p-"+t+".visible"]),!n.A4[t].HM&&(n.C.E["plot"+t+".visible"]||"hide"===n.C.getToggleAction())){n.A4[t].CC?(-1===(Z=ZC.AV(d,n.A4[t].DZ))&&(d.push(n.A4[t].DZ),Z=d.length-1),null===ZC._n_(u[Z])?u[Z]=[t]:u[Z].push(t)):(d.push(-1),Z=d.length-1,null===ZC._n_(u[Z])?u[Z]=[t]:u[Z].push(t));var f=n.A4[t].AF;if(n.A4[t].o.type&&f!==n.A4[t].o.type){var _=f.indexOf("3d"),b=n.A4[t].o.type.indexOf("3d");(-1===_&&-1!==b||-1===_&&-1===b)&&(f=n.A4[t].o.type)}-1!==ZC.AV(["bar","bar3d","bullet"],f)&&(f="v"+f),-1===ZC.AV(["vbar","hbar","vbullet","hbullet","stock","vbar3d","hbar3d"],f)||n.A4[t].HM||(null===ZC._n_(A[f])&&(A[f]=[]),null===ZC._n_(p[f])&&(p[f]=[]),n.A4[t].CC?(null===ZC._n_(C[n.A4[t].DZ])?C[n.A4[t].DZ]=1:C[n.A4[t].DZ]++,-1===(g=ZC.AV(p[f],n.A4[t].DZ))&&(p[f].push(n.A4[t].DZ),g=p[f].length-1),null===ZC._n_(A[f][g])?A[f][g]=[t]:A[f][g].push(t)):(p[f].push(-1),g=p[f].length-1,null===ZC._n_(A[f][g])?A[f][g]=[t]:A[f][g].push(t)))}if(n.KB=u,n.K3=A,n.WM)for(var m in n.WM)n.WM[m].sort();for(n.A1C=[],t=0;t<n.KB.length;t++)n.A1C.push(n.KB[t][n.KB[t].length-1])},paint:function(){var e=this;function t(i){var n=e.M2[i];(e.A4[n].HT||e.A4[n].E7.length&&e.A.B9||"none"!==e.A4[n].IZ)&&(e.H.O7=!1),e.A4X=!0;var a=e.C.getToggleAction();e.A4[n].o["skip-paint"]||(e.C.AJ["3d"]?e.C.E["plot"+n+".visible"]&&(e.A4[n].paint(),e.H.ZV()):(e.C.E["plot"+n+".visible"]||"hide"===a)&&("undefined"!=typeof e.C.E["plot-"+n+"-first-run"]&&(e.A4[n].TL=0),e.A4[n].paint(),e.A4[n].TL=0,e.H.ZV(),e.C.E["plot"+n+".visible"]||"hide"!==a||(e.C.E["plot"+n+".visible"]=!0,e.A.QC({plotindex:n,"ignore-legend":!0})))),e.C.E["plot-"+n+"-first-run"]=!1,i<e.A4.length-1?e.C.LK?ZC.ASYNC_TICK[e.C.K]=window.setTimeout(function(){t(i+1)},10):e.A4.length<=100&&t(i+1):(!e.C.LK||e.C.LK&&e.A4X)&&e._end_()}if(e.HE=[],e.A4.length>0)if(e.A4.length>100&&!e.C.LK)for(var i=0;i<e.A4.length;i++)t(i);else t(0);else e._end_()},_end_:function(){var e,t=this;t.RU=null,t.VJ=null;for(var i=0;i<t.C.BO.length;i++)t.C.BO[i].ET=null,t.C.BO[i].WK=null;function n(e){var i=0,n=e.indexOf("-plotset-plot-"),a=e.indexOf("-node-",n);return-1!==n&&-1!==a&&(i=e.substr(n+14,a-n-14)),"undefined"!=typeof t.A4[i].E["z-mid"]?t.A4[i].E["z-mid"]:i}if((e=ZC.AK(t.C.A.K+"-map"))&&!t.H.A19){-1===ZC.AV(["bubble","hbubble","vbullet","hbullet","radar","vbar3d","hbar3d","mixed","mixed3d","pie3d","hmixed","hmixed3d"],t.C.AF)&&1!==zingchart.SORTTRACKERS||t.HE.sort(function(e,i){return"pie3d"===t.C.AF?ZC.AP.N2(e)>ZC.AP.N2(i)?1:ZC.AP.N2(e)<ZC.AP.N2(i)?-1:0:n(e)>n(i)&&t.A.AJ["3d"]?1:n(e)<n(i)&&t.A.AJ["3d"]?-1:ZC.AP.N2(e)>ZC.AP.N2(i)?1:ZC.AP.N2(e)<ZC.AP.N2(i)?-1:0});var a='<area shape="rect" coords="0,0,1,1" id="mark'+t.A.L+'">',r=t.A.a11y(),l=e.innerHTML.indexOf(a);zingchart.DEV.DELAYEDTRACKERS?window.setTimeout(function(){-1!==l?e.innerHTML=e.innerHTML.substring(0,l+a.length)+r+t.HE.join("")+e.innerHTML.substring(l+a.length):e.innerHTML+=r+t.HE.join("")},500):-1!==l?e.innerHTML=e.innerHTML.substring(0,l+a.length)+r+t.HE.join("")+e.innerHTML.substring(l+a.length):e.innerHTML+=r+t.HE.join("")}t.F1=null,t.D6=null,t.C.A9W=[],t.A._end_()}}),ZC.ZE=ZC.LJ.CA({ACW:function(e){var t=this;switch(e){default:return new ZC.QK(t);case"vline":var i=new ZC.QK(t);return i.O6=!0,i;case"poly":var n=new ZC.P7(t);return n.bPoly=!0,n.sTypeX="poly",n;case"area":return new ZC.QV(t);case"varea":var a=new ZC.QV(t);return a.O6=!0,a;case"bar":case"vbar":return new ZC.QY(t);case"hbar":return new ZC.R0(t);case"scatter":return new ZC.P7(t);case"hscatter":return new ZC.P7(t,"hscatter");case"bubble":return new ZC.RZ(t);case"hbubble":return new ZC.RZ(t,"hbubble");case"stock":return new ZC.VB(t);case"range":return new ZC.SQ(t);case"vrange":var r=new ZC.SQ(t);return r.O6=!0,r;case"line3d":return new ZC.UC(t);case"area3d":return new ZC.UB(t);case"bar3d":case"vbar3d":return new ZC.UE(t);case"bullet":case"vbullet":return new ZC.TC(t);case"hbullet":return new ZC.TF(t)}}});var HV={$i:function(e){this.b(e);var t=this;t.C=e.A,t.H=t.C.A,t.A68={},t.HM=!1,t.SV=3,t.A1G=1,t.V=[],t.KH={},t.S=[],t.AF="",t.sTypeX=null,t.IE=null,t.RO=!1,t.IZ="none",t.O2="plot",t.UT=!0,t.SZ=null,t.T3=null,t.TN={},t.A2=null,t.GA=null,t.PM=null,t.PI=null,t.BP=null,t.L=-1,t.BO=[],t.CC=!1,t.KQ="normal",t.DZ=0,t.U=null,t.NQ=null,t.A7=null,t.JM=null,t.AM=null,t.JB=null,t.A6C=null,t.P2=null,t.DQ=-1,t.I1=-1,t.RD=null,t.RW=null,t.ZX=!1,t.SE=2,t.A33=!1,t.TX="",t.A04="standard",t.CW=null,t.A0X=null,t.MS=null,t.RX=null,t.Y1=!0,t.XQ=null,t.YA=1,t.Q8=!1,t.QN=!0,t.JR=0,t.XX=null,t.T0=null,t.PU=!0,t.K2=null,t.AAD=1,t.A2K=1,t.S6=[],t.JA=null,t.EF=!1,t.SY=[],t.A6Q=-1,t.GG=!1,t.L7=0,t.JF=.6,t.L8=0,t.AC3=0,t.AC4=null,t.TL=0,t.FV=null,t.I3=!1,t.YH=!0,t.A78=!1,t.Y0=1,t.YL=0,t.IA=!1,t.L9=!1,t.A3K="node",t.LP=!1,t.R4=-1,t.RK=0,t.Q9=!1,t.GQ=[null,null,null,null],t.P3="line"},applyRGBA:function(){var e,t=this;null!==ZC._n_(e=t.E["l-alpha"])&&null===ZC._n_(t.J9.alpha)&&(t.C6=e),null!==ZC._n_(e=t.E["bg-alpha"])&&null===ZC._n_(t.J9["alpha-area"])&&(t.o["alpha-area"]=e)},FK:function(e,t,i){var n=this;return void 0===i&&(i=!1),(void 0===t||!n.GQ[t]&&n.GQ[1])&&(t=1),e=parseInt(e,10),!n.I3||"xy"!==n.C.AJ.layout&&"yx"!==n.C.AJ.layout?n.S[e]:n.S[e]&&n.GQ[t]?(n.GQ[t].K=n.K+"-node-"+e,n.GQ[t].o={value:n.V[e]},"string"==typeof n.V[e]&&(n.GQ[t].A26=!0),n.GQ[t].L=e,"line"!==n.AF&&"area"!==n.AF&&"vline"!==n.AF&&"varea"!==n.AF||n.U?n.GQ[t].parse():(i||null!==n.S[e].BT||"undefined"!=typeof n.C.E["plot-"+n.L+"-first-run"])&&n.GQ[t].parse(),"line"===n.AF||"area"===n.AF||"vline"===n.AF||"varea"===n.AF?"xy"===n.C.AJ.layout?(null!==n.S[e].BT?n.GQ[t].iX=n.S[e].iX=n.B1.AT(n.S[e].BT):n.GQ[t].iX=n.S[e].iX=n.B1.IB(e),n.CC&&"100%"===n.KQ?n.GQ[t].iY=n.S[e].iY=n.CM.AT(100*n.S[e].CS/n.A.F8[e]["%total-"+n.DZ]):n.GQ[t].iY=n.S[e].iY=n.CM.AT(n.S[e].CS)):(null!==n.S[e].BT?n.GQ[t].iY=n.S[e].iY=n.B1.AT(n.S[e].BT):n.GQ[t].iY=n.S[e].iY=n.B1.IB(e),n.CC&&"100%"===n.KQ?n.GQ[t].iX=n.S[e].iX=n.CM.AT(100*n.S[e].CS/n.A.F8[e]["%total-"+n.DZ]):n.GQ[t].iX=n.S[e].iX=n.CM.AT(n.S[e].CS)):n.GQ[t].T6(),n.GQ[t].JD=n.S[e].JD,n.GQ[t]):null},V4:function(e,t){var i=this;i.K2[e]||(i.K2[e]=[]),(!i.I3||i.I3&&-1===ZC.AV(i.K2[e],t))&&i.K2[e].push(t)},TQ:function(){return new ZC.LG(this)},ABZ:function(){return{}},NR:function(){return this.ZQ("palette","A6Q","i"),this.C.A.B8.A9B(-1!==this.A6Q?this.A6Q:this.L,this.C.AF)},NO:function(){var e=this;if(e.BP[4]){var t,i={};for(var n in e.BP[4])-1===(t=n.indexOf("."))?null===ZC._n_(e.o[n])&&(i[n]=!0,e.o[n]=e.BP[4][n]):n.substring(0,t)===e.AF&&(null===ZC._n_(e.o[n.substring(t+1)])||i[n.substring(t+1)])&&(e.o[n.substring(t+1)]=e.BP[4][n])}},ID:function(e,t){var i,n,a=this,r=!1,l="";if("none"!==a.IZ&&(a.C.IX[a.L]||a.C.KI)){var o=!(e.E["selected-state"]||e.E["background-state"]);a.C.CB["p"+a.L]&&a.C.CB["p"+a.L]["n"+e.L]?zingchart.DEV.CACHESELECTION&&o&&a.TN["selected-state"]?(n=a.TN["selected-state"],r=!0):(l="selected-state",(n=new ZC.DN(a)).copy(t),e.E["selected-state"]?n.LO=e.E["selected-state"]:n.LO=a.SZ?a.SZ.o:{}):"none"!==a.O2&&("plot"===a.O2&&a.C.IX[a.L]||"graph"===a.O2&&a.C.KI)&&(zingchart.DEV.CACHESELECTION&&o&&a.TN["background-state"]?(n=a.TN["background-state"],r=!0):(l="background-state",(n=new ZC.DN(a)).copy(t),e.E["background-state"]?n.LO=e.E["background-state"]:n.LO=a.T3?a.T3.o:{})),r||(n?(n.PU=!0,n.parse()):(n=new ZC.DN(a)).copy(t),zingchart.DEV.CACHESELECTION&&o&&""!==l&&(a.TN[l]=n))}else(n=new ZC.DN(a)).copy(t);return null!==ZC._n_(i=a.SY[e.L])&&(0===e.A.E7.length&&(e.A.E7=[{}]),"string"==typeof a.SY[e.L]?n.append({"background-color":ZC.AP.JN(i,20)+" "+i,"line-color":i,"border-color":ZC.AP.JN(i,20)}):n.append(a.SY[e.L]),n.parse()),n.Z=t.Z,n.C7=t.C7,n},BU:function(e){var t=this,i=[];if(null!==ZC._n_(e))for(var n=0,a=t.BO.length;n<a;n++){var r=t.C.BL(t.BO[n]);r&&r.AF===e&&i.push(t.BO[n])}else i=t.BO;return i},MP:function(){var e=this;return{negation:e.A04,"thousands-separator":e.RD,"decimals-separator":e.RW,decimals:e.DQ,"max-decimals":e.I1,short:e.A33,"short-unit":e.TX,exponent:e.ZX,"exponent-decimals":e.SE}},parse:function(){var e,t,i,n=this;if(n.UP={},n.b(),n.K2={},null!==ZC._n_(e=n.o.scales))for(n.BO=e.split(/,|;|\s/),A=0;A<n.BO.length;A++)n.BO[A]=ZC.UJ(ZC.GV(n.BO[A]));if(n.C.o.legend&&n.C.o.legend["highlight-plot"]&&(n.IA=!0),null!==ZC._n_(n.o.multiplier)&&null===ZC._n_(n.o.short)&&(n.o.short=n.o.multiplier),null!==ZC._n_(n.o["click-marker"])&&null===ZC._n_(n.o["selection-mode"])&&null===ZC._n_(n.o["selected-marker"])&&(n.o["selection-mode"]="multiple",n.o["selected-marker"]={},ZC._cp_(n.o["click-marker"],n.o["selected-marker"])),n.KQ=n.C.KQ,n.assign_a([["ignore","HM","b"],["exponent","ZX","b"],["exponent-decimals","SE","ia"],["decimals","DQ","ia"],["max-decimals","I1","i"],["preview","QN","b"],["stacked","CC","b"],["stack-type","KQ"],["exact","Q8","b"],["text","AM"],["tooltip-text","JB"],["legend-text","A6C"],["description","P2"],["stack","DZ","i"],["z-index","JR","i"],["aspect","CW"],["mode","A0X"],["density","Y0","f"],["max-nodes","MS"],["max-trackers","RX"],["segment-trackers","Y1","b"],["sampling-step","XQ","i"],["scroll-step-multiplier","YA","i"],["url","EA"],["target","FB"],["decimals-separator","RW"],["thousands-separator","RD"],["short","A33","b"],["negation","A04"],["short-unit","TX"],["fast-rules","A78","b"],["errors","S6"],["styles","SY"],["monotone","Q9","b"],["highlight","IA","b"],["highlight-legend","L9","b"],["hover-mode","A3K"],["mid-point","UT","b"],["clustered","LP","b"],["cluster-index","R4","i"],["cluster-offset","RK","i"],["animate","GG","b"],["effect","L7","i"],["speed","JF","f"],["selection-mode","IZ"],["group-selections","RO","b"],["background-mode","O2"],["extra-values","YL","ia"]]),n.AAN=n.Q8,!n.E["quick-parse"]){var a;if(ZC._todash_(n.SY),n.IA&&(null===ZC._n_(n.C.o.legend)||null===ZC._n_(n.C.o.legend["highlight-legend"]))&&ZC._n_(null===n.o["highlight-legend"])&&(n.L9=n.IA),null!==ZC._n_(e=n.o.animation))n.GG=!0,null!==ZC._n_(t=e.effect)&&(0===(t+"").indexOf("ANIMATION_")&&null!==ZC._n_(a=ZC.ANIMATION[(t+"").substring(10)])&&(t=a),n.L7=ZC._i_(t),0===n.L7&&(n.GG=!1)),null!==ZC._n_(t=e.speed)&&(0===(t+"").indexOf("ANIMATION_")&&null!==ZC._n_(a=ZC.ANIMATION[(t+"").substring(10)])&&(t=a),n.JF=ZC._f_(t)),null!==ZC._n_(t=e.delay)&&(n.L6=ZC._f_(t)),null!==ZC._n_(t=e.method)&&(0===(t+"").indexOf("ANIMATION_")&&null!==ZC._n_(a=ZC.ANIMATION[(t+"").substring(10)])&&(t=a),n.L8=ZC._i_(t)),null!==ZC._n_(t=e.sequence)&&(0===(t+"").indexOf("ANIMATION_")&&null!==ZC._n_(a=ZC.ANIMATION[(t+"").substring(10)])&&(t=a),n.TL=ZC._i_(t)),null!==ZC._n_(t=e.attributes)&&(n.FV=t);for(var r in n.JF<10&&(n.JF*=1e3),n.L6<10&&(n.L6*=1e3),"undefined"!=typeof ZC.PE&&(n.JF=ZC.BQ(ZC.PE.U3,n.JF)),("fast"===n.A0X||"undefined"==typeof ZC.PE||zingchart.SKIP.ANIMATION)&&(n.GG=!1),n.H.A19&&(n.GG=!1),-1!==ZC.AV(["line","area","vbar","hbar","stock","scatter","bubble","radar","piano"],n.AF)&&("fast"===n.A0X?n.I3=!0:"normal"===n.A0X||n.GG||-1!==JSON.stringify(n.o).indexOf('"rules"')||-1!==JSON.stringify(n.o).indexOf('"js-rule"')||0!==n.SY.length||-1!==n.H.E.json.indexOf('"override"')||-1!==n.H.E.json.indexOf('"errors"')||"none"!==n.IZ?n.I3=!1:n.I3=!0),n.o)if("data-"===r.substring(0,5)){var l=r.substring(5);n.KH[l]=n.o[r]}var o=n.H.B8;if(n.IE=new ZC.D0(n),n.IE.append(n.o),o.load(n.IE.o,v("hover-state")),n.IE.append(n.o["hover-state"]),null!==ZC._n_(n.o["hover-state"])||"line"!==n.AF&&"area"!==n.AF||(n.IE.AN=!1),n.IA&&(n.S2=new ZC.D0(n),o.load(n.S2.o,v("highlight-state")),n.S2.append(n.o),null!==ZC._n_(e=n.o["highlight-state"])&&n.S2.append(e),null===ZC._n_(n.S2.o.shadow)&&(n.S2.o.shadow=!0)),null!==ZC._n_(e=n.o["selected-state"])&&(n.SZ=new ZC.D0(n),o.load(n.SZ.o,v("selected-state")),n.SZ.append(e)),null!==ZC._n_(e=n.o["background-state"])&&(n.T3=new ZC.D0(n),o.load(n.T3.o,v("background-state")),n.T3.append(e)),n.A2=new ZC.D0(n),o.load(n.A2.o,v("marker")),o.load(n.A2.o,v("marker["+n.CW+"]")),n.A2.append(n.o.marker),"auto"===n.A2.o.type){var s=["circle","square","diamond","triangle","star5"];n.A2.o.type=s[n.L%s.length]}if(n.A2.parse(),(n.A2.E7.length>0||n.SY.length>0||n.A2.o["top-state"])&&(n.YH=!1),n.GA=new ZC.D0(n),o.load(n.GA.o,v("hover-marker")),n.GA.append(n.o.marker),n.GA.append(n.o["hover-marker"]),null!==ZC._n_(e=n.o["selected-marker"])&&(n.PM=new ZC.D0(n),o.load(n.PM.o,v("selected-marker")),n.PM.append(e)),null!==ZC._n_(e=n.o["background-marker"])&&(n.PI=new ZC.D0(n),o.load(n.PI.o,v("background-marker")),n.PI.append(e)),n.IA&&(n.V6=new ZC.D0(n),n.V6.append(n.o.marker),null!==ZC._n_(e=n.o["highlight-marker"])&&(o.load(n.V6.o,v("highlight-marker")),n.V6.append(e))),"normal"!==n.A0X&&(n.SZ||n.PM)&&(n.I3=!1),"fast"===n.A0X&&(n.I3=!0),n.A7=new ZC.DN(n),n.o.tooltip&&n.o.tooltip.placement&&n.o.tooltip.placement.indexOf("node")>-1?o.load(n.A7.o,"("+n.AF+").tooltip[dynamic]"):o.load(n.A7.o,n.AF+".tooltip"),n.A7.append(n.o.tooltip),null!==ZC._n_(e=n.o.error)&&(n.JA=new ZC.DT(n),o.load(n.JA.o,v("error")),n.JA.append(e),null===ZC._n_(n.JA.o.size)&&(n.JA.o.size=4)),null!==ZC._n_(e=n.o["value-box"])){if(e instanceof Array)for(n.U=new ZC.D0(n),o.load(n.U.o,v("value-box")),null!==ZC._n_(t=n.C.o.plot)&&n.U.append(t["value-box"]),n.U.append(e[0]),e.length>1&&(n.NQ=[]),A=1;A<e.length;A++)n.NQ[A-1]=new ZC.D0(n),o.load(n.NQ[A-1].o,v("value-box")),null!==ZC._n_(t=n.C.o.plot)&&n.NQ[A-1].append(t["value-box"]),n.NQ[A-1].append(e[A]);else n.U=new ZC.D0(n),o.load(n.U.o,v("value-box")),null!==ZC._n_(t=n.C.o.plot)&&n.U.append(t["value-box"]),n.U.append(e);n.U.parse()}n.H.QZ&&(n.AN=ZC.FSSTATUS["g-"+n.C.L+"-p-"+n.L]);var c=!1;for("undefined"==typeof n.C.E["plot"+n.L+".visible"]&&(c=!0),c?n.C.E["plot"+n.L+".visible"]=!0:n.AN=n.C.E["plot"+n.L+".visible"],n.AN||c&&(n.C.E["plot"+n.L+".visible"]=!1),A=0,i=n.C.BO.length;A<i;A++)null!==ZC._n_(n.C.BO[A].o.values)?n.C.BO[A].T9=!0:-1!==ZC.AV(n.BO,n.C.BO[A].BE)&&("remove"===n.C.getToggleAction()||n.C.A.K9?n.AN&&n.C.E["plot"+n.L+".visible"]&&(n.C.BO[A].T9=!0):n.C.BO[A].T9=!0);var h,C=null;if(n.K=n.A.K+"-plot-"+n.L,n.S=[],n.A.F8||(n.A.F8={}),-1!==n.AF.indexOf("area")&&-1===n.AF.indexOf("3d")&&n.CC){n.A.WM||(n.A.WM={}),n.A.WM["s"+n.DZ]||(n.A.WM["s"+n.DZ]=[]);var u=!1;if(null!==ZC._n_(n.o.values))for(A=0,i=n.o.values.length;A<i;A++)if("object"==typeof n.o.values[A]&&null!==ZC._n_(n.o.values[A])){u=!0;break}u&&(n.GG=!1,n.HT||0!==n.E7.length||(n.I3=!0,-1===zingchart.DEV.STACKINGLOGIC&&(n.C.UO=1)))}if(n.B1=n.C.BL(n.BU("k")[0]),n.CM=n.C.BL(n.BU("v")[0]),null!==ZC._n_(n.o.values)&&""!==n.AF){if(n.V=n.o.values,n.I3&&"area"===n.AF&&"spline"===n.CW){for(var d=!1,A=0;A<n.V.length;A++)if(null===ZC._n_(n.V[A])){d=!0;break}d&&(n.I3=!1)}var p=null;n.PY=[ZC.MAX,-ZC.MAX];var g=[],Z=[],f=0;for(A=0,i=n.V.length;A<i;A++){var _=!1;if(n.o["hint-ts"]||(null!==ZC._n_(n.V[A])&&"object"==typeof n.V[A]&&n.V[A].length>1?(null===ZC._n_(n.V[A][1])||"string"==typeof n.V[A][1]&&"NULL"===n.V[A][1].toUpperCase())&&(_=!0):(null===ZC._n_(n.V[A])||"string"==typeof n.V[A]&&"NULL"===n.V[A].toUpperCase())&&(_=!0),"piano"===n.C.AF&&(_=!1)),_)n.S.push(null);else{!n.I3||"xy"!==n.C.AJ.layout&&"yx"!==n.C.AJ.layout?C=n.TQ():n.GQ[1]||("bubble"===n.AF||"scatter"===n.AF?n.GQ[1]=C=n.TQ():(n.GQ[0]=n.TQ(),n.GQ[1]=C=n.TQ(),n.GQ[2]=n.TQ(),n.GQ[3]=n.TQ())),C.K=n.K+"-node-"+A,"string"==typeof n.V[A]&&zingchart.QUOTEDVALUES&&(n.V[A]=ZC._f_(n.V[A])),C.o={value:n.V[A]},"string"==typeof n.V[A]&&(C.A26=!0),C.L=A,n.o["hint-ts"]?(C.E.plotidx=n.L,C.E.nodeidx=C.L,C.K=n.K+"-node-"+C.L,C.BT=n.V[A][0],C.AD=n.V[A][1]):C.parse(),(i<256||zingchart.DEV.CHECKDECIMALS)&&null!==ZC._n_(C.AD)&&2===(h=C.AD.toString().split(".")).length&&(f=ZC.BQ(f,h[1].length)),C.BT&&(null!==p&&ZC._a_(C.BT-p)>0&&g.push(ZC._a_(C.BT-p)),p=C.BT),n.A.WM=n.A.WM||{};var b=n.A.WM["s"+n.DZ];if(b&&(null!==p?-1===ZC.AV(b,C.BT)&&b.push(C.BT):-1===ZC.AV(b,A)&&b.push(A)),!n.I3||"xy"!==n.C.AJ.layout&&"yx"!==n.C.AJ.layout)n.S.push(C);else{var m={iX:C.iX,iY:C.iY,L:C.L,BT:C.BT,AD:C.AD,CS:C.AD,DP:C.DP,JD:C.JD};"bubble"===n.AF&&(m.SI=C.SI),n.S.push(m)}null!==C.BT&&(n.PY[0]=Math.min(n.PY[0],C.BT),n.PY[1]=Math.max(n.PY[1],C.BT)),n.C.E["plot"+n.L+".visible"]&&(zingchart.DEV.PLOTSTATS||"100%"===n.KQ)&&n.CC&&(null===ZC._n_(n.A.F8[A])?(n.A.F8[A]={},n.A.F8[A]["%total-"+n.DZ]=C.AD):null===ZC._n_(n.A.F8[A]["%total-"+n.DZ])?n.A.F8[A]["%total-"+n.DZ]=C.AD:n.A.F8[A]["%total-"+n.DZ]+=C.AD),zingchart.DEV.PLOTSTATS&&(Z.push(C.AD),n.JM?(n.JM["%plot-max-index"]=A,n.JM["%plot-sum"]+=C.AD,i<256&&(n.JM["%plot-values"]+=","+C.AD)):n.JM={"%plot-min-index":A,"%plot-max-index":A,"%plot-sum":C.AD,"%plot-values":C.AD},n.A.F8||(n.A.F8={}),n.AN&&(null===ZC._n_(n.A.F8["%pstack-"+A+"-"+n.DZ+"-sum"])?(n.A.F8["%pstack-"+A+"-"+n.DZ+"-sum"]=C.AD,n.A.F8["%pstack-"+A+"-"+n.DZ+"-stack-length"]=1):(n.A.F8["%pstack-"+A+"-"+n.DZ+"-sum"]+=C.AD,n.A.F8["%pstack-"+A+"-"+n.DZ+"-stack-length"]+=1)))}}(n.V.length<256||zingchart.DEV.CHECKDECIMALS)&&n.JM&&null!==ZC._n_(n.JM["%plot-sum"])&&2===(h=n.JM["%plot-sum"].toString().split(".")).length&&ZC._i_(h[1])>f&&(n.JM["%plot-sum"]=ZC._f_(n.JM["%plot-sum"].toFixed(ZC.CY(20,f)))),zingchart.DEV.PLOTSTATS?(n.JM&&(n.JM["%plot-average"]=n.JM["%plot-sum"]/n.V.length,n.JM["%plot-average"]=ZC._f_(n.JM["%plot-average"].toFixed(ZC.CY(20,f+2)))),Z.length>0&&(n.JM["%plot-min-value"]=ZC.XY(Z),n.JM["%plot-max-value"]=ZC.A1L(Z))):n.JM={"%plot-min-index":0,"%plot-max-index":n.V.length,"%plot-sum":-1,"%plot-values":"","%plot-average":-1,"%plot-min-value":-1,"%plot-max-value":-1},p&&g.length>0&&(n.AAD=ZC.XY(g),n.A2K=ZC.A1L(g))}}function v(e){var t=["("+n.AF+").plot."+e];return n.sTypeX&&t.push("("+n.sTypeX+").plot."+e),t}},mapPointsToPreview:function(e,t){for(var i=this,n=i.C.P,a=i.C.B9.AR,r=[],l=0,o=e.length;l<o;l++)if(e[l]){"vml"===i.H.AA&&t&&(e[l][0]=e[l][0]/10,e[l][1]=e[l][1]/10);var s=(e[l][0]-n.iX)/n.I,c=(e[l][1]-n.iY)/n.F,h=a.iX+a.AU+s*(a.I-2*a.AU),C=a.iY+a.AU+c*(a.F-2*a.AU);r.push([h,C])}else r.push(null);return r},paint:function(){var e=this,t=e.C.P.I;switch(e.C.AF){case"scatter":case"bubble":t=1e6;break;case"hbar":case"hbar3d":t=e.C.P.F}null===ZC._n_(e.MS)&&(e.MS=ZC._i_(t/4)),null===ZC._n_(e.RX)&&(e.RX=ZC._i_(t/4)),e.YH&&(e.HB=null,e.HI=null,e.RA=null,e.QB=null)},XN:function(e){var t,i,n,a=this;for(t=0,i=a.S.length;t<i;t++)a.S[t]&&(a.S[t].JD=!1);var r=a.C.P;if(a.R7=!1,a.FY=!0,a.U8=!1,n=0,a.C.OA||"undefined"!=typeof a.AAN&&(a.Q8=a.AAN),e)a.R7=!0,a.RX<a.S.length&&(a.FY=!1);else{if(a.B1.EF&&a.EF){for(t=0,i=a.S.length;t<i;t++)a.S[t]&&(a.B1.IQ.length>0||ZC.DS(a.S[t].BT,a.B1.V[a.B1.W],a.B1.V[a.B1.A1]))&&n++;a.RX<n&&(a.FY=!1),n*a.Y0>r.I&&(a.U8=!0),a.MS>=n&&(a.R7=!0)}else a.MS>a.B1.A1-a.B1.W&&(a.R7=!0);a.Y=1,a.B1.EF&&a.EF||(n=a.B1.A1-a.B1.W,a.RX<n&&(a.FY=!1),n*a.Y0>r.I&&(a.U8=!0),!a.Q8&&n*a.Y0>r.I&&(a.Y=ZC.BQ(1,ZC._i_(n*a.Y0/r.I)))),a.B1.EF&&a.EF&&(a.Q8||n*a.Y0>r.I&&(a.Y=ZC.BQ(1,ZC._i_(n*a.Y0/r.I)))),a.C.OA&&(a.Q8=!1,a.Y*=a.YA)}null!==ZC._n_(a.XQ)&&a.Y>a.XQ&&(a.Y=a.XQ)},PB:function(e){var t,i,n,a=this;null!==ZC._n_(e)&&e||(e=!1),a.B1&&"log"===a.B1.C1&&(e=!0),a.XN(e);var r=null;if(e||a.LP)a.A.A4X=!1,function A(e,t){for(var i=e;i<ZC.CY(e+t,a.S.length);i++)a.S[i]?((r=a.FK(i)).Z=a.KF,r.paint(),r.JD=!0,a.S[i].JD=!0):"radar"===a.C.AF&&(i===a.S.length-1?"line"!==a.CW&&"area"!==a.CW&&"range"!==a.CW||ZC.CR.paint(a.QE,a,a.D):a.D.push(null));e+t<a.S.length?a.C.LK?window.setTimeout(function(){A(e+t,t)},10):A(e+t,t):a.C.LK&&a.L===a.A.A4.length-1&&a.A._end_()}(0,ZC.ie678||ZC.mobile?200:2e3);else{var l="vbar"!==a.AF&&"hbar"!==a.AF;if(a.B1.EF&&a.EF){n=a.GB=a.HD=a.Y;var o=!0,s=0,c=0;for(t=0,i=a.S.length;t<i;t+=n)l&&(i-t==1?(a.GB=n,a.HD=1):i-t<a.Y&&(a.GB=a.Y,a.HD=i-t-1,n=i-t-1)),a.S[t]&&(a.B1.IQ.length>0||ZC.DS(a.S[t].BT,a.B1.V[a.B1.W],a.B1.V[a.B1.A1])||l&&o&&a.S[t+n]&&a.S[t+n].BT>=a.B1.V[a.B1.W])&&(l&&o&&a.S[t-n]&&((r=a.FK(t-n)).Z=a.KF,r.paint(),r.JD=!0,o=!1,c++),(r=a.FK(t)).Z=a.KF,r.paint(),r.JD=!0,c++,o=!1,s=t);l&&c>0&&a.S[s+n]&&((r=a.FK(s+n)).Z=a.KF,r.paint(),r.JD=!0)}else{n=a.GB=a.HD=a.Y;var h=0,C=1,u=null;if(!l){var d="vbar"===a.AF?a.C.P.I:a.C.P.F;h=4/("vbar"===a.AF?a.C.P.F:a.C.P.I)*(a.CM.BJ-a.CM.B3),C=1+ZC._i_((a.B1.A1-a.B1.W)/(2*d)),n=1}for(t=a.B1.W;t<=a.B1.A1;t+=n)(a.B1.A1-a.B1.W)%a.Y!=0&&l&&(a.B1.A1-t==0?(a.GB=n,a.HD=1):a.B1.A1-t<=a.Y&&(a.GB=a.Y,a.HD=a.B1.A1-t,n=a.B1.A1-t)),a.S[t]?(r=a.FK(t),(l||a.Q8||!l&&null===u||ZC._a_(r.AD-u)>h||t%C==0)&&(r.Z=a.KF,r.paint(),r.JD=!0,a.S[t].JD=!0),u=r.AD):a.CC&&-1!==ZC.AV(["vbar","hbar","vbar3d","hbar3d"],a.AF)&&a.SM()}}},CP:function(e,t){var i=this;if(i.UP[e+t])return i.UP[e+t];var n=null;return n=i.H.usc()?ZC.AK(i.H.K+"-main-c"+("fl"===e?"-top":"")):i.H.K9||i.C.AJ["3d"]?ZC.AK(i.C.K+"-plots-"+e+"-c"):ZC.AK(i.C.K+"-plot-"+i.L+"-"+e+"-"+t+"-c"),i.UP[e+t]||(i.UP[e+t]=n),n},UW:function(e){var t=this;return{id:t.H.K,graphid:t.C.K,graphidx:t.C.L,plotid:t.H8,plotindex:t.L,plottext:t.AM,ev:e?ZC.A5.BZ(e):null,xdata:t.KH}},X5:function(e,t){ZC.AP.BY("plot_"+t,this.H,this.UW(e))},applyJsRuleSvg:function(e,t,i){var n;if(n=e.o["js-rule-svg"]){var a=ZC.AK(t),r=ZC.evalFn(n.replace("javascript:","").replace("()",""),window);if(a&&r)try{var l=r.call(this,i);for(var o in l)a.setAttribute(o,l[o])}catch(s){}}},sharedZScale:function(){var e=this,t=e.C,i=t.P;if(t.o["scale-z"]&&t.E["plot"+e.L+".visible"]){var n,a,r,l,o;if(n=new ZC.CE(t,i.iX+i.I-ZC.AO.E2+10,i.iY+i.F-ZC.AO.E3,e.E["z-mid"]),(a=new ZC.DN(e)).GL=t.K+"-scale-z-item "+t.K+"-scale-item zc-scale-item",a.K=t.K+"-scale-z-item_"+e.L,a.AM=t.o["scale-z"].values[e.L],a.Z=a.C7=e.H.usc()?e.H.mc():ZC.AK(t.K+"-scales-ml-0-c"),o=ZC.Q.EB(a.Z,e.H.AA),a.IL=e.H.usc()?ZC.AK(e.H.K+"-main"):ZC.AK(e.H.K+"-text"),a.append(t.o["scale-z"].item),a.parse(),a.A9+=a.V9?0:ZC.DI.A2T(t,a),a.iX=n.ED[0],a.iY=n.ED[1],a.o["auto-align"]&&a.V9&&(a.iY-=a.F/2),a.paint(),null===ZC._n_(e.E["scale-z-item-max-width"])&&(e.E["scale-z-item-max-width"]=0),e.E["scale-z-item-max-width"]=ZC.BQ(e.E["scale-z-item-max-width"],a.I),e.E["z-cnt"]===e.E["z-plots"]-1&&t.o["scale-z"].label){var s,c;n=new ZC.CE(t,i.iX+i.I-ZC.AO.E2+20+e.E["scale-z-item-max-width"],i.iY+i.F-ZC.AO.E3,ZC.AO.FT/2),(a=new ZC.DN(e)).GL=t.K+"-scale-z-label "+t.K+"-scale-label zc-scale-label",a.K=t.K+"-scale-z-label",a.Z=a.C7=e.H.usc()?e.H.mc():ZC.AK(t.K+"-scales-ml-0-c"),o=ZC.Q.EB(a.Z,e.H.AA),a.IL=e.H.usc()?ZC.AK(e.H.K+"-main"):ZC.AK(e.H.K+"-text"),a.append(t.o["scale-z"].label),a.parse(),s=new ZC.CE(t,i.iX+i.I-ZC.AO.E2,i.iY+i.F-ZC.AO.E3,0),c=new ZC.CE(t,i.iX+i.I-ZC.AO.E2,i.iY+i.F-ZC.AO.E3,ZC.AO.FT);var h=ZC.TK(Math.atan((c.ED[1]-s.ED[1])/(c.ED[0]-s.ED[0])));a.A9+=a.V9?0:h,a.iX=n.ED[0],a.iY=n.ED[1],a.paint()}if(t.o["scale-z"].tick&&((l=new ZC.DT(e)).B7="#cccccc",l.AZ=1,l.AI=6,l.append(t.o["scale-z"].tick),l.parse(),l.AN&&l.AZ>0)){l.K=t.K+"-scale-z-tick-"+e.L;for(var C=[],u=[[i.iX+i.I,i.iY+i.F],[i.iX+i.I+l.AI,i.iY+i.F]],d=0;d<u.length;d++)n=new ZC.CE(t,u[d][0]-ZC.AO.E2,u[d][1]-ZC.AO.E3,e.E["z-mid"]),C.push([n.ED[0],n.ED[1]]);ZC.CR.paint(o,l,C)}if(0===e.E["z-cnt"]&&((l=new ZC.D0(e)).B7="#cccccc",l.AZ=1,l.append(t.o["scale-z"].axis),l.parse(),l.AZ>0&&l.AN&&(l.A0=l.AE=l.B7,(r=ZC.DI.DB(l,t,i.iX+i.I-ZC.AO.E2-l.AZ,i.iX+i.I-ZC.AO.E2,i.iY+i.F-ZC.AO.E3,i.iY+i.F-ZC.AO.E3,0,ZC.AO.FT,"x")).K=t.K+"-scale-z-axis",t.CL.add(r))),e.E["z-cnt"]>0&&t.o["scale-z"].guide&&((l=new ZC.D0(e)).B7="#cccccc",l.AZ=1,l.append(t.o["scale-z"].guide),l.parse(),l.AZ>0&&l.AN&&(l.A0=l.AE=l.B7,(r=ZC.DI.DB(l,t,i.iX-ZC.AO.E2,i.iX+i.I-ZC.AO.E2,i.iY+i.F-ZC.AO.E3,i.iY+i.F-ZC.AO.E3+l.AZ,e.E["z-cnt"]*e.E["z-depth"],e.E["z-cnt"]*e.E["z-depth"],"y")).K=t.K+"-scale-z-guideh-"+e.L,t.CL.add(r),(r=ZC.DI.DB(l,t,i.iX-ZC.AO.E2,i.iX-ZC.AO.E2,i.iY-ZC.AO.E3,i.iY+i.F-ZC.AO.E3,e.E["z-cnt"]*e.E["z-depth"],e.E["z-cnt"]*e.E["z-depth"]+l.AZ,"y")).K=t.K+"-scale-z-guidev-"+e.L,t.CL.add(r))),t.o["scale-z"].items&&t.o["scale-z"].items.length){(l=new ZC.D0(e)).A0=l.AE="#ff9900",l.C6=.25;var A=e.E["z-cnt"]%t.o["scale-z"].items.length;l.append(t.o["scale-z"].items[A]),l.parse(),(r=ZC.DI.DB(l,t,i.iX-ZC.AO.E2,i.iX+i.I-ZC.AO.E2,i.iY+i.F-ZC.AO.E3,i.iY+i.F-ZC.AO.E3,e.E["z-cnt"]*e.E["z-depth"],e.E["z-cnt"]*e.E["z-depth"]+e.E["z-depth"],"z")).K=e.K+"-item-",t.CL.add(r)}}},gc:function(){if(this.S)for(var e=0;e<this.S.length;e++)this.S[e]&&this.S[e].A&&ZC.AP.gc(this.S[e],["Z","C7","o","J9","I6","A","C","H","N","NC"]);ZC.AP.gc(this,["V","S","GQ","K2","V3","A7","Z","C7","UP","A2","TT","HB","GA","IE","KF","QE","B1","CM","S","GQ","K2","JM","o","J9","I6","A","C","H"])}};ZC.HV=ZC.HL.CA(HV),ZC.VY=ZC.HV.CA({$i:function(e){this.b(e);var t=this;t.bXY=!0,t.AF="xy",t.BO=["scale-x","scale-y"]},paint:function(){this.b()}});var LG={$i:function(e){this.b(e);var t=this;t.C=e.A.A,t.H=t.C.A,t.L=-1,t.AD=null,t.DP=[],t.CS=null,t.BT=null,t.CK=null,t.JO=[],t.I2=!1,t.PU=!0,t.N=t,t.JD=!1,t.A26=!1},H3:function(e,t){this.b(this.A,e,t,this.LT(null,!1),this.A.MJ)},UY:function(){return[this.iX,this.iY,{reference:this,center:!0}]},ACE:function(){return[this.iX,this.iY]},getTooltipPosition:function(e,t,i){var n,a,r,l,o=this;switch(o.paint(!0),n=o.iX,a=o.iY,r=o.I,l=o.F,t){case"center":n=o.iX+r/2,a=o.iY+l/2;break;case"top":n=o.iX+r/2,a=o.iY,a=i?a-i:a;break;case"bottom":n=o.iX+r/2,a=o.iY+l,a=i?a+i:a;break;case"left":n=o.iX,a=o.iY+l/2,n=i?n-i:n;break;case"right":n=o.iX+r,a=o.iY+l/2,n=i?n+i:n;break;default:n+=o.BM,a+=o.BH}return{x:n,y:a}},setNodeData:function(e){var t=this;for(var i in e)e.hasOwnProperty(i)&&(t.A.I3?t.A.S[t.L][i]=e[i]:t.E[i]=e[i])},getNodeData:function(e){return this.A.I3?this.A.S[this.L][e]:this.E[e]},AB2:function(){var e,t,i=this,n=i.C.E,a=i.A.L;null===ZC._n_(n.update)&&(n.update={});var r=n.update,l=""+i.AD,o=i.A.MP();for(ZC.P5(l)&&ZC._f_(l)<0&&"currency"===o.negation&&(l=ZC._a_(ZC._f_(l))),o.utc=i.C.UL,o.timezone=i.C.NB,l=ZC.AP.G2(l,o,i.A),r["plot-"+a+"-value"]=l,r["plot-"+a+"-value-0"]=l,e=0,t=i.DP.length;e<t;e++)r["plot-"+a+"-value-"+(e+1)]=i.DP[e];for(r["plot-value"]=r["plot-value-0"]=l,e=0,t=i.DP.length;e<t;e++)r["plot-value-"+(e+1)]=i.DP[e];for(var s in i.A.KH){var c=null;c="object"==typeof i.A.KH[s]&&i.A.KH[s].length?i.A.KH[s][i.L]:i.A.KH[s],r["plot-"+a+"-data-"+s]=c}},T6:function(){var e,t,i=this,n=i.A.B1,a=i.A.CM,r=[n.W,n.A1,a.W,a.A1];if(i.A.I3&&(i.CS=i.A.S[i.L].CS),i.JO!==r){n.CO?(null!==i.BT?i.iY=n.AT(i.BT):i.iY=n.IB(i.L),i.A.CC&&"100%"===i.A.KQ?i.A.A.F8[i.L]["%total-"+i.A.DZ]>0?i.iX=a.AT(100*i.CS/i.A.A.F8[i.L]["%total-"+i.A.DZ]):i.iX=a.AT(100*i.CS):i.iX=a.AT(i.CS+0)):(null!==i.BT?i.iX=n.AT(i.BT):i.A.LP?"bar"===i.A.sMetaType?i.iX=n.IB(i.A.R4):i.iX=n.IB(i.A.R4)+i.A.RK+i.L*(n.AC-2*i.A.RK)/(i.A.S.length-1)-n.AC/2:"log"===n.C1?i.iX=n.AT(i.L):i.iX=n.IB(i.L),i.A.CC&&"100%"===i.A.KQ?i.A.A.F8[i.L]["%total-"+i.A.DZ]>0?i.iY=a.AT(100*i.CS/i.A.A.F8[i.L]["%total-"+i.A.DZ]):i.iY=a.AT(100*i.CS):i.iY=a.AT(i.CS+0)),i.A.I3&&(i.A.S[i.L].iX=i.iX,i.A.S[i.L].iY=i.iY),i.JO=r}i.I2||(0!==i.A.E7.length||-1===ZC.AV(["line","area","vbar","hbar","line3d","area3d","vbar3d","hbar3d"],i.A.AF)||i.A.o.override?ZC.A5.browser.mozilla?(i.copy(i.A),i.E7=i.A.E7,i.DE(),i.parse(!1),i.N=i):i.A.o.override?(i.copy(i.A),i.E7=i.A.E7,i.DE(),i.parse(!1),i.N=i):(e=i.ACJ(i.A.E7),null===ZC._n_(t=i.A.A68[e])?(i.copy(i.A),i.E7=i.A.E7,i.DE(),i.parse(!1),i.N=i,i.A.A68[e]=i):i.N=t):i.N=i.A,i.A.o.override&&(i.N.E.plotidx=i.A.L,i.N.E.nodeidx=i.L,i.N.parse(!1)),i.I2=!0)},a11y:function(){var e=this,t="";if(e.H.bA11y){if(e.A.I3){var i=this.A.FK(e.L,1,!0);i&&(t=i.JV(this.C.A7.o.text||this.A.A7.o.text||this.A.JB))}else t=e.JV(this.C.A7.o.text||this.A.A7.o.text||this.A.JB);return e.A.AM&&-1===t.indexOf(e.A.AM)&&(t=e.A.AM+":"+t),t=t.replace(/<.+?>/gi," "),'tabindex="0" aria-label="Series '+(this.A.L+1)+" of "+this.A.A.A4.length+", point "+(this.L+1)+" of "+this.A.S.length+". "+t+'"'}return""},A96:function(){var e,t=this;if(t.o.value instanceof Array&&(t.CK=t.o.value.join(" "),"string"==typeof t.o.value[0]?-1!==(e=ZC.AV(t.A.B1.IQ,t.o.value[0]))?t.BT=e:(t.A.B1.IQ.push(t.o.value[0]),t.BT=t.A.B1.IQ.length-1):t.BT=parseFloat(t.o.value[0]),"string"==typeof t.o.value[1]?-1!==(e=ZC.AV(t.A.CM.JK,t.o.value[1]))?t.AD=e:(t.A.CM.JK.push(t.o.value[1]),t.AD=t.A.CM.JK.length-1):t.AD=parseFloat(t.o.value[1]),null!==t.BT&&t.A.V4(t.BT,t.L),t.A.YL>0&&t.o.value.length>t.A.YL))for(var i=t.o.value.length-t.A.YL;i<t.o.value.length;i++)t.DP.push(t.o.value[i])},parse:function(e){var t=this;if(t.E.plotidx=t.A.L,t.E.nodeidx=t.L,t.K=t.A.K+"-node-"+t.L,null===ZC._n_(e)&&(e=!0),e){if(t.o.value instanceof Array||t.A.AA0)t.A96();else if(t.CK=t.o.value,"string"==typeof t.o.value){var i=ZC.AV(t.A.CM.JK,t.o.value);-1!==i?t.AD=i:(t.A.CM.JK.push(t.o.value),t.AD=t.A.CM.JK.length-1)}else t.AD=t.o.value;null===t.CS&&(t.CS=t.AD)}else t.b()},J2:function(e){return this.JV(e,{})},getFormatValue:function(){return this.AD},JV:function(AM,ER,LN,bUrl){var s=this,G,CK,BC,i,A6,D5,oRE;void 0===LN&&(LN=!1);var oPPI=s.A.JM,oPS=s.A.A,EY,PH;if(!bUrl&&"javascript:"===AM.substring(0,11))try{var EC=AM.replace("javascript:","").replace("()","");eval(EC)&&(G=0===s.DP.length?s.AD:[s.AD].concat(s.DP),AM=eval(EC).call(s,G,{nodeindex:s.L,plotindex:s.A.L,plotid:s.A.H8,nodeinfo:s.LT(null,!1),plotinfo:s.A.UW()})||AM)}catch(e){}if(AM+="",s.A.A78){for(EY in CK=s.getFormatValue(),null!==ZC._n_(s.A.CM.JK[CK])&&s.A26&&(CK=s.A.CM.JK[CK]),AM=AM.replace(/%node-numeric-value/g,s.AD).replace(/%node-value/g,CK).replace(/%previous-node-value/g,s.A.S[s.L-1]?s.A.S[s.L-1].AD:null).replace(/%next-node-value/g,s.A.S[s.L+1]?s.A.S[s.L+1].AD:null).replace(/%node-index/g,s.L).replace(/%plot-text/g,s.A.AM).replace(/%plot-index/g,s.A.L).replace(/%plot-count/g,oPS.A4.length).replace(/%p/g,s.A.L).replace(/%P/g,oPS.A4.length).replace(/%v/g,CK).replace(/%V/g,s.AD).replace(/%i/g,s.L).replace(/%n/g,s.L),s.A.KH)PH="",PH=s.A.KH[EY]instanceof Array?null!==s.A.KH[EY][s.L]?s.A.KH[EY][s.L]:"":null!==s.A.KH[EY]?s.A.KH[EY]:"",oRE=new RegExp("%data-"+EY,"g"),AM=AM.replace(oRE,PH);return AM}var PK="",S1="",RN="",WF="",R=s.C.BL(s.A.BU("k")[0]),X=s.C.BL(s.A.BU("v")[0]);R&&(null!==s.BT?PK=S1=RN=s.BT:(null!==ZC._n_(R.V[s.L])&&(PK=S1=RN=R.V[s.L]),null!==ZC._n_(R.BX[s.L])&&(RN=S1=R.BX[s.L]))),null!==ZC._n_(G=s.A.B1.IQ[PK])&&"number"==typeof PK&&(PK=G),null!==ZC._n_(G=s.A.B1.IQ[S1])&&"number"==typeof S1&&(S1=G),null!==ZC._n_(G=s.A.B1.IQ[RN])&&"number"==typeof RN&&(RN=G),WF=null!==ZC._n_(s.A.AM)?s.A.AM:"Series "+(s.A.L+1),s.A.LP&&s.A.A.A4[s.L]&&(WF=s.A.A.A4[s.L].AM||"Series "+s.L);var TV=(WF+"").split(/\s+/),A61=PK;R&&(BC=R.MP(),ER&&ER["transform-date"]&&ZC._cp_({"transform-date":!0,"transform-date-format":ER["transform-date-format"]},BC),BC.utc=s.C.UL,BC.timezone=s.C.NB,RN=S1=ZC.AP.G2(PK,BC,R,!0),null===s.BT&&(null===ZC._n_(R.BX[s.BT])&&null===ZC._n_(R.BX[s.L])||(S1=RN=R.BX[s.BT]||R.BX[s.L])),BC["transform-date"]&&(RN=ZC.AP.G2(RN,BC,R,!0)));var A4D=(S1+"").split(/\s+/),A6P=(RN+"").split(/\s+/),W2=(PK+"").split(/\s+/);CK=s.getFormatValue(),s.A.CM&&null!==ZC._n_(s.A.CM.JK[CK])&&s.A26&&(CK=s.A.CM.JK[CK]);var OO=ZC.P5(CK)&&ZC._f_(CK)<0;if(BC=s.A.MP(),ZC._cp_(ER,BC),OO&&"currency"===BC.negation&&(CK=ZC._a_(ZC._f_(CK))),BC.utc=s.C.UL,BC.timezone=s.C.NB,CK=ZC.AP.G2(CK,BC,s.A,!(!X||!X.FG)&&X.FG),"%v"===AM&&"%vv"!==AM||"%node-value"===AM)return CK;if("%t"===AM||"%plot-text"===AM)return WF;var CV=s.CV||[],oNode_,YP,A6B,oPlot_,p,pLen;if(X&&X.NE){var YW=X.MP();null===ZC._n_(YW.decimals)&&(YW.decimals=0);var AB1=X.CO?X.NE(this.iX,!0,"piano"===s.A.AF):X.NE(this.iY,!0,"piano"===s.A.AF),WL=X.FQ(0,AB1,YW);CV.push(["%scale-value-value",WL],["%vv",WL]),null!==ZC._n_(G=X.BX[s.L])?CV.push(["%scale-value-label",G],["%vl",G]):CV.push(["%scale-value-label",WL],["%vl",WL])}if(X&&(-1!==AM.indexOf("%scale-value-text")||-1!==AM.indexOf("%vt")))for(-1!==(G=ZC.AV(X.V,s.AD))&&null!==ZC._n_(X.BX)&&null!==ZC._n_(X.BX[G])?CV.push(["%scale-value-text",X.BX[G]],["%vt",X.BX[G]]):CV.push(["%scale-value-text",s.AD],["%vt",s.AD]),oRE=-1!==AM.indexOf("%vt(")?new RegExp("(%vt)\\(([0-9]*)\\)"):new RegExp("(%scale-value-text)\\(([0-9]*)\\)");D5=oRE.exec(AM);)YP="",""!==(G=D5[2])&&(A6B=ZC._i_(G),null!==ZC._n_(oPlot_=s.A.A.A4[A6B])&&(oNode_=oPlot_.FK(s.L),null!==oNode_&&(YP=oNode_.JV(D5[1])))),AM=AM.replace(D5[0],YP),""!==YP&&CV.push([D5[0],YP]);for(EY in null!==ZC._n_(s.A.LY)&&null!==ZC._n_(s.A.LY[s.L])&&CV.push(["%offset-values",s.A.LY[s.L]]),s.A.A.A1C&&CV.push(["%stack-top",-1!==ZC.AV(s.A.A.A1C,s.A.L)?1:0]),s.A.KH)PH="",PH=s.A.KH[EY]instanceof Array?null!==s.A.KH[EY][s.L]?s.A.KH[EY][s.L]:"":null!==s.A.KH[EY]?s.A.KH[EY]:"","number"==typeof PH&&(PH=ZC.AP.G2(PH,BC,s.A,!(!X||!X.FG)&&X.FG)),CV.push(["%data-"+EY,PH]);for(i=0;i<A4D.length;i++)CV.push(["%scale-key-label-"+i,A4D[i]],["%kl"+i,A4D[i]]);for(i=0;i<A6P.length;i++)CV.push(["%scale-key-text-"+i,A6P[i]],["%kt"+i,A6P[i]]);for(i=0;i<W2.length;i++)CV.push(["%scale-key-value-"+i,W2[i]],["%kv"+i,W2[i]],["%k"+i,W2[i]]);for(p=0,pLen=oPS.A4.length;p<pLen;p++)null!==ZC._n_(oPS.A4[p].S[s.L])&&CV.push(["%plot-"+p+"-value",oPS.A4[p].S[s.L].AD]);CV.push(["%scale-key-label",S1],["%scale-key-text",RN],["%scale-key-value",PK],["%scale-key-value-ts",A61],["%kvts",A61],["%kt",RN],["%kl",S1],["%kv",PK],["%k",PK],["%node-value",CK],["%v",CK],["%node-numeric-value",s.AD],["%previous-node-value",s.A.S[s.L-1]?s.A.S[s.L-1].AD:null],["%next-node-value",s.A.S[s.L+1]?s.A.S[s.L+1].AD:null],["%V",s.AD],["%node-index",s.L],["%node-x",s.iX],["%node-y",s.iY],["%chart-width",s.H.I],["%chart-height",s.H.F],["%i",s.L],["%n",s.L],["%node-count",s.A.S.length],["%N",s.A.S.length]);var ABN=oPPI["%plot-sum"],A3R=ABN+"",ABQ=oPPI["%plot-average"],A3Q=ABQ+"",A8L=ZC._f_(oPS.F8["%pstack-"+s.L+"-"+s.A.DZ+"-sum"]||"0"),A4N=A8L+"",ABC=ZC._f_(A8L/oPS.F8["%pstack-"+s.L+"-"+s.A.DZ+"-stack-length"]),A5D=String(ABC),A9F=String(oPS.F8["%pstack-"+s.L+"-"+s.A.DZ+"-stack-length"]),A70=0;null!==ZC._n_(oPS.F8)&&null!==ZC._n_(oPS.F8[s.L])&&(A70=ZC._f_(oPS.F8[s.L]["%total-"+s.A.DZ]||"0"));var A39=A70+"";A3R=ZC.AP.G2(A3R,BC),A3Q=ZC.AP.G2(A3Q,BC),A39=ZC.AP.G2(A39,BC),A4N=ZC.AP.G2(A4N,BC),A5D=ZC.AP.G2(A5D,BC),CV.push(["%node-error-plus",s.E["node-error-plus"]],["%node-error-minus",s.E["node-error-minus"]],["%stack-total",A4N],["%stack-average",A5D],["%stack-length",A9F],["%total",A39],["%plot-min-index",oPPI["%plot-min-index"]],["%pmi",oPPI["%plot-min-index"]],["%plot-max-index",oPPI["%plot-max-index"]],["%pxi",oPPI["%plot-max-index"]],["%plot-min-value",oPPI["%plot-min-value"]],["%pmv",oPPI["%plot-min-value"]],["%plot-max-value",oPPI["%plot-max-value"]],["%pxv",oPPI["%plot-max-value"]],["%plot-sum",A3R],["%psum",A3R],["%plot-average",A3Q],["%pavg",A3Q],["%plot-values",oPPI["%plot-values"]],["%pv",oPPI["%plot-values"]]);var A9M=100*s.AD/oPPI["%plot-sum"],YX=A9M+"";null!==ZC._n_(BC.decimals)&&(YX=ZC.AP.G2(YX,BC)),CV.push(["%plot-percent",YX],["%pper",YX]);var bNpv=!1,WE,AX,J,C0;for(i=0,A6=CV.length;i<A6;i++)if("%npv"===CV[i][0]){bNpv=!0;break}if(!bNpv&&null!==ZC._n_(s.A.A.F8)&&null!==ZC._n_(s.A.A.F8[s.L])){var JP=100*s.AD/s.A.A.F8[s.L]["%total-"+s.A.DZ],HO=JP+"";null!==ZC._n_(BC.decimals)&&(HO=ZC.AP.G2(HO,BC)),CV.push(["%node-percent-value",HO],["%npv",HO])}for(i=0;i<TV.length;i++)CV.push(["%plot-text-"+i,TV[i]],["%t"+i,TV[i]]);for(CV.push(["%plot-text",WF],["%t",WF],["%plot-description",s.A.P2],["%plot-index",s.A.L],["%p",s.A.L],["%plot-count",oPS.A4.length],["%P",oPS.A4.length],["%id",s.H.K],["%graphid",s.C.K.replace(s.H.K+"-graph-","")]),-1!==AM.indexOf("%negation")&&(OO&&"currency"===BC.negation?(CV.push(["%negation","-"]),OO=!1):CV.push(["%negation",""])),CV.push(["%node-x",s.iX],["%node-y",s.iY],["%node-width",s.I],["%node-height",s.F],["%node-size",s.E["marker.size"]||1]),zingchart.DEV.SORTTOKENS&&CV.sort(ZC.A1H),oRE=new RegExp("\\(([^(]+?)\\)\\(([0-9]*)\\)(\\(*)([0-9]*)(\\)*)");D5=oRE.exec(AM);){WE="";var CQ=s.A.L,D9=s.L;""!==(G=D5[2])&&(CQ=ZC._i_(G)),""!==(G=D5[4])&&(D9=ZC._i_(G)),null!==(J=oPS.A4[CQ])&&(AX=J.FK(D9,3),null!==AX&&(WE=AX.JV(D5[1],ER))),AM=AM.replace(D5[0],WE)}if(-1!==AM.indexOf("%prop-")){oRE=new RegExp("%prop-([a-zA-Z0-9-]+)");for(var oMap=s.getPMap();D5=oRE.exec(AM);)null!==ZC._n_(oMap[D5[1]])&&null!==ZC._n_(s[oMap[D5[1]]])&&(AM=AM.replace(D5[0],s[oMap[D5[1]]]))}if(-1!==AM.indexOf("%linecolor"))for(oRE=new RegExp("%linecolor([0-9]*)");D5=oRE.exec(AM);)""===D5[1]?(C0=s.N||s,C0.B7||(C0=s.A)):C0=oPS.A4[D5[1]],AM=AM.replace(D5[0],C0&&C0.B7||"#000");if(-1!==AM.indexOf("%backgroundcolor"))for(oRE=new RegExp("%backgroundcolor([0-9]*)");D5=oRE.exec(AM);)""===D5[1]?(C0=s.N||s,C0.B7||(C0=s.A)):C0=oPS.A4[D5[1]],AM="markerbg"===s.A.P3?AM.replace(D5[0],C0&&C0.A2&&C0.A2.A0||"#000"):AM.replace(D5[0],C0&&C0.A0||"#000");if(-1!==AM.indexOf("%color"))for(oRE=new RegExp("%color([0-9]*)");D5=oRE.exec(AM);)""===D5[1]?(C0=s.N||s,C0.B7&&"line"!==s.A.P3||(C0=s.A)):C0=oPS.A4[D5[1]],AM="line"===s.A.P3?AM.replace(D5[0],C0&&C0.B7||"#000"):"markerbg"===s.A.P3?AM.replace(D5[0],C0&&C0.A2&&C0.A2.A0||"#000"):AM.replace(D5[0],C0&&C0.A0||"#000");for(AM=ZC.AP.YN(AM,this),i=0,A6=CV.length;i<A6;i++)oRE=new RegExp(CV[i][0],"g"),AM="undefined"==typeof CV[i][1]?AM.replace(oRE,""):LN?AM.replace(oRE,encodeURIComponent(CV[i][1])):AM.replace(oRE,CV[i][1]);return AM=AM.replace(new RegExp("%data-([a-zA-Z0-9]+)","g"),""),OO&&"currency"===BC.negation&&(AM="-"+AM),AM},paint:function(){},paint_:function(){},ABF:function(){return{color:this.N.A0}},Y4:function(){return{"border-color":this.N.A0,"background-color":this.N.AE,color:this.N.C2}},A8E:function(){return this.Y4()},GW:function(e,t){var i,n,a,r=this;if(t||(t=1),r.A.NQ&&r.A.NQ.length>0&&r.A.NQ.length>t-1&&r.GW(e,t+1),r.AN||"pie"===r.A.AF||"pie3d"===r.A.AF){var l,o=1===t?r.A.U:r.A.NQ[t-2];if(o){if(r.A.A74)(l=r.A.A74).K=r.K+"-value-box-"+t,l.Z=l.C7=r.H.usc()?r.H.mc("top"):r.C.AJ["3d"]||r.H.K9?ZC.AK(r.C.K+"-plots-vb-c"):ZC.AK(r.C.K+"-plot-"+r.A.L+"-vb-c"),l.IL=r.H.usc()?ZC.AK(r.C.A.K+"-top"):ZC.AK(r.C.A.K+"-text"),l.E.plotidx=r.A.L,l.E.nodeidx=r.L,a=ZC.AP.O3(l.o,r.A.o),l.JV=function(e){return r.JV(e,a)},l.parse();else{l=new ZC.DN(r.A),o.o.rules||r.A.U.HT||(n="all",null!==ZC._n_(i=o.o.type)&&(n=i),"pie"===r.C.AF||"nestedpie"===r.C.AF||"pie3d"===r.C.AF||"all"!==n||r.A.NQ&&0!==r.A.NQ.length||(r.A.A74=l)),l.append(o.o),r.appendToValueBox&&!e&&(l.parse(),l.append(r.appendToValueBox(l))),l.GL=r.C.K+"-value-box "+r.C.K+"-plot-"+r.A.L+"-value-box zc-value-box",l.K=r.K+"-value-box-"+t,l.Z=l.C7=r.H.usc()?r.H.mc("top"):r.C.AJ["3d"]||r.H.K9?ZC.AK(r.C.K+"-plots-vb-c"):ZC.AK(r.C.K+"-plot-"+r.A.L+"-vb-c"),l.IL=r.H.usc()?ZC.AK(r.C.A.K+"-top"):ZC.AK(r.C.A.K+"-text"),a=ZC.AP.O3(l.o,r.A.o),l.JV=function(e){return r.JV(e,a)};var s=r.ABF(l);if(null!==ZC._n_(i=s.color)&&(l.C2=i),null!==ZC._n_(i=s["background-color"])&&(l.A0=l.AE=i),l.E.plotidx=r.A.L,l.E.nodeidx=r.L,r.A.U.HT&&(r.A.U.H3(r.A.U,l,null,r.LT(null,!1)),l.parse()),l.parse(),l.J2=function(e){return r.J2(e)},l.DE()&&(a=l.overrideFormat(a),l.parse()),!r.A.YJ){var c=new ZC.DN(r.A);c.copy(l),r.A.YJ=c}if(n="all",null!==ZC._n_(i=o.o.type)&&(n=i),l.AN){l.AN=!1;var h=r.A.o["value-box"].text||"";if("values("===n.substring(0,7)){var C=n.substring(7,n.length).replace(")","").split(",");-1!==ZC.AV(C,r.AD)&&(l.AN=!0)}else{var u=n.split(","),d={min:"%plot-min-value",max:"%plot-max-value",first:"%plot-min-index",last:"%plot-max-index"};for(var A in d)-1!==ZC.AV(u,A)&&(("first"!==A&&"last"!==A||r.L!==r.A.JM[d[A]])&&("min"!==A&&"max"!==A||r.AD!==r.A.JM[d[A]])||("object"==typeof h&&null!==ZC._n_(h[A])&&(l.o.text=h[A],l.parse()),l.AN=!0));-1!==ZC.AV(u,"all")&&(l.AN=!0)}}}if(r.C.E["plot"+r.A.L+".visible"]||(l.E["css-display"]="none"),e)return l;if(l.AN&&null!==ZC._n_(l.AM)&&""!==l.AM){var p=r.AC8(l);l.E.positioninfo=p,l.iX=p[0],l.iY=p[1];var g={};if(-1!==l.iX&&-1!==l.iY){var Z=!1;if(null!==ZC._n_(l.o.overlap)&&!ZC._b_(l.o.overlap)){g={x:l.iX,y:l.iY,width:l.I,height:l.F};for(var f=0,_=r.A.A.YZ.length;f<_;f++)if(ZC.AQ.XM(g,r.A.A.YZ[f])){Z=!0;break}}Z||(r.C.E["plot"+r.A.L+".visible"]||(l.E["css-display"]="none"),l.E.lbltype="vb"+r.C.L,l.paint(),l.EK(),r.A.A.YZ.push(g),!l.K9&&ZC.AK(r.H.K+"-map")&&r.A.A.HE.push(ZC.AP.O5(r.C.K,l)))}}return l}}},setupValueBoxWH:function(e){if(null!==ZC._n_(e.o.width)){var t=ZC.II(e.o.width);t<=1&&(t=this.I*t),e.I=t}if(null!==ZC._n_(e.o.height)){var i=ZC.II(e.o.height);i<=1&&(i=this.I*i),e.F=i}return e},AC8:function(e){var t,i=this,n=i.C.BL(i.A.BU("v")[0]),a=i.AD>=n.LA&&!n.AW||i.AD<n.LA&&n.AW?-1:1,r="auto";if(null!==ZC._n_(t=e.o.placement)&&(r=t),"auto"===r){var l=null!==ZC._n_(i.A.S[i.L-1])?i.A.S[i.L-1].AD:i.AD,o=null!==ZC._n_(i.A.S[i.L+1])?i.A.S[i.L+1].AD:i.AD;l>=i.AD&&i.AD<=o?r="bottom":l<=i.AD&&i.AD>=o?r="top":l>=i.AD&&i.AD>=o?r=l/i.AD>i.AD/o?"bottom":"top":l<=i.AD&&i.AD<=o&&(r=i.AD/l>o/i.AD?"top":"bottom")}var s=e.I,c=e.F,h=i.iX-s/2,C=i.iY-c/2;switch(r){case"top":C-=a*(c/2+4);break;case"bottom":C+=a*(c/2+4);break;case"left":h-=s/2+4;break;case"right":h+=s/2+4}return i.C.AJ["3d"]||(h=ZC.BQ(i.C.P.iX-s/2,h),h=ZC.CY(i.C.P.iX+i.C.P.I-s/2,h),C=ZC.BQ(i.C.P.iY-c,C),C=ZC.CY(i.C.P.iY+i.C.P.F,C)),null!==ZC._n_(e.o.x)&&(h=e.iX),null!==ZC._n_(e.o.y)&&(C=e.iY),[ZC._i_(h),ZC._i_(C)]},P8:function(e,t){var i,n,a,r,l,o=this;if("undefined"==typeof o.A.bBS&&(o.A.bBS=-1===ZC.AV(["bubble","hbubble","scatter","hscatter"],o.A.AF)),null!==ZC._n_(o.A.o["markers-on-top"])&&(o.A.bBS=ZC._b_(o.A.o["markers-on-top"])),!o.C.OA||!o.A.bBS){null===ZC._n_(e)&&(e=!1),null===ZC._n_(t)&&(t=!1);var s=o.C.P.E.tolerance||2;if(ZC.DS(o.iX,o.C.P.iX-s,o.C.P.iX+o.C.P.I+s)&&ZC.DS(o.iY,o.C.P.iY-s,o.C.P.iY+o.C.P.F+s)){var c=o.C.K+"-node-area "+o.C.K+"-plotset-plot-"+o.A.L+"-node-area zc-node-area";if(-1===ZC.AV(o.H.KR,"skip_segment_tracking")&&o.A.FY){if(o.A.Y1&&!zingchart.DEV.SKIPTRACKERS){var h=o.getNodeData("points");-1!==ZC.AV(o.H.KR,"use_fast_mode")&&-1!==ZC.AV(["line","area"],o.A.AF)&&void 0===h&&o.paint(!0),""!==(a="undefined"==typeof o.E.polypoints?ZC.AQ.PR(ZC.AQ.Z0(h,ZC.BQ(6,o.A.AZ/2)),4):ZC.AQ.PR(h,4))&&o.A.A.HE.push(ZC.Q.G0("poly",o.A.EA,o.N.IV)+'class="'+c+'" id="'+o.K+'" coords="'+a+'" />')}if(("area"===o.A.AF||"area3d"===o.A.AF||"radar"===o.A.AF&&("area"===o.A.CW||"range"===o.A.CW))&&o.A.XC){var C=o.getNodeData("pointsarea");""!==(a=ZC.AQ.PR(C,4))&&o.A.A.HE.push(ZC.Q.G0("poly",o.A.EA,o.A.IV)+'class="'+c+'" id="'+o.K+'--area" coords="'+a+'" />')}}if(o.A.U||!o.A.I3||!o.A.A2.o||"none"!==o.A.A2.o.type&&(null===ZC._n_(o.A.A2.o.visible)||ZC._b_(o.A.A2.o.visible))){if(t||o.A.R7){if(o.A.HB)r=o.A.HB,"svg"!==o.H.AA&&(e?(l=new ZC.CE(o.C,o.iX-ZC.AO.E2,o.iY-ZC.AO.E3,o.A.E["z-start"]||0),r.iX=ZC._x_(l.ED[0]),r.iY=ZC._x_(l.ED[1]),o.E["3dxy"]=[r.iX,r.iY]):(r.iX=ZC._x_(o.iX),r.iY=ZC._x_(o.iY)),r.E.plotidx=o.A.L,r.E.nodeidx=o.L,r.K=o.K+"-marker",r.parse(!0));else{if(o.I3?o.A._oMarker?r=o.A._oMarker:o.A._oMarker=r=new ZC.DT(o.A):r=new ZC.DT(o.A),r.K=o.K+"-marker",r.E["p-width"]=o.A.B1.AC,r.E["p-height"]=o.A.CM.AC,o.A.bBS)r.Z=o.A.CP("fl",0),r.C7=o.A.CP("fl",0);else if(r.Z=o.A.CP("bl",1),r.C7=o.A.CP("bl",0),Object&&Object.keys&&Object.keys(o.C.CB).length>0){var u=o.C.CB["p"+o.A.L];"none"!==o.A.IZ&&u&&u["n"+o.L]&&(r.Z=o.A.CP("bl",2))}if(e?(l=new ZC.CE(o.C,o.iX-ZC.AO.E2,o.iY-ZC.AO.E3,o.A.E["z-start"]||0),r.iX=ZC._x_(l.ED[0]),r.iY=ZC._x_(l.ED[1]),o.E["3dxy"]=[r.iX,r.iY]):(r.iX=ZC._x_(o.iX),r.iY=ZC._x_(o.iY)),r.B7=o.A.BP[3],r.BW=o.A.BP[3],r.A0=o.A.BP[2],"bubble"===o.A.AF||"hbubble"===o.A.AF?r.AE=o.A.BP[1]:r.AE=o.A.BP[2],r.append(o.A.A2.o),null!==ZC._n_(o.E["marker.size"])&&(r.AI=o.E["marker.size"]),r.E.plotidx=o.A.L,r.E.nodeidx=o.L,"none"!==o.A.IZ&&(o.C.IX[o.A.L]||o.C.KI))if(o.C.CB["p"+o.A.L]&&o.C.CB["p"+o.A.L]["n"+o.L]){if(r.LO={},o.A.PM&&ZC._cp_(o.A.PM.o,r.LO),r.LO.rules){var d=new ZC.DT(o.A);d.o=r.LO,d.parse(),d.J2=function(e){return o.J2(e)},d.DE()&&(r.LO=d.o)}}else"none"!==o.A.O2&&("plot"===o.A.O2&&o.C.IX[o.A.L]||"graph"===o.A.O2&&o.C.KI)&&(r.LO=o.A.PI?o.A.PI.o:{});null!==ZC._n_(i=o.A.o.marker)&&null!==ZC._n_(i.styles)&&null!==ZC._n_(n=i.styles[o.L])&&("string"==typeof n?r.append({"background-color":ZC.AP.QU(n,20),"line-color":ZC.AP.JN(n,20),"border-color":ZC.AP.JN(n,20)}):r.append(n)),r.parse(),r.J2=function(e){return o.J2(e)},r.DE()&&r.parse()}if(o.E["marker.size"]=ZC.BQ(2.02,o.E["marker.size"]||r.AI),r.DK=c,!(e||ZC.DS(r.iX,o.C.P.iX-2,o.C.P.iX+o.C.P.I+2)&&ZC.DS(r.iY,o.C.P.iY-2,o.C.P.iY+o.C.P.F+2)))return;if(r.HT&&(o.A.YH=!1,r.H3(r,r,null,o.LT(null,!1)),r.parse()),o.NC=r,r.AN&&"none"!==r.AF){var A=function(){if(o.A.bBS||o.N6(ZC.Q.EB(o.A.CP("bl",0),o.H.AA)),o.E["marker.type"]=r.DU,o.A.FY&&-1===ZC.AV(o.H.KR,"skip_marker_tracking")&&!zingchart.DEV.SKIPTRACKERS){var e=o.E["3dxy"]?o.E["3dxy"][0]:o.iX,t=o.E["3dxy"]?o.E["3dxy"][1]:o.iY,i=parseInt(e+r.BM+ZC.MAPTX,10),n=parseInt(t+r.BH+ZC.MAPTX,10),a=parseInt(ZC.BQ(ZC.mobile?6:3,o.E["marker.size"]+1)*(ZC.mobile?1.25:1.05),10),l=!0;if("undefined"!=typeof o.A.aLastMarkerXY)Math.sqrt((i-o.A.aLastMarkerXY[0])*(i-o.A.aLastMarkerXY[0])+(n-o.A.aLastMarkerXY[1])*(n-o.A.aLastMarkerXY[1]))<zingchart.DEV.MINTRACKERDIFF&&(l=!1);else o.A.aLastMarkerXY=[i,n];l&&(o.A.aLastMarkerXY=[i,n],-1!==ZC.AV(["pie","square","rect","rectangle"],r.DU)?o.A.A.HE.push(ZC.Q.G0("poly",o.A.EA,o.A.IV)+'class="'+c+'" id="'+o.K+'--marker" coords="'+r.FF()+'" />'):o.A.A.HE.push(ZC.Q.G0("circle",o.A.EA,o.A.IV)+'class="'+c+'" '+o.a11y()+' id="'+o.K+'--marker" coords="'+i+","+n+","+a+'" />'))}if(o.A.U&&(o.A.E.vboxid=o.K,o.GW()),!o.A.bBS&&o.C.B9&&o.C.B9.I2&&o.A.QN&&o.C.B9.AN){var s=o.C.P,h=o.C.B9,C=h.AR,u=o.A.HB||r,d=new ZC.DT(o.A);d.copy(u);var A=(o.iX-s.iX)/s.I,p=(o.iY-s.iY)/s.F,g=Math.min(C.F/s.F,C.I/s.I);d.iX=C.iX+C.AU+A*(C.I-2*C.AU),d.iY=C.iY+C.AU+p*(C.F-2*C.AU),d.K=o.K+"-marker-preview",d.DK=o.A.K+"-preview";var Z=u.AI;null!==ZC._n_(o.E["marker.size"])&&(Z=o.E["marker.size"]),d.AI=ZC.BQ(2.02,.9*g*Z),d.Z=d.C7=h.Z,d.parse(),d.paint()}},p=!1;if((!o.A.bBS||"radar"===o.A.AF&&"dots"===o.A.CW)&&(p=!0),o.A.GG&&p&&!o.C.HH){var g=r,Z={},f=r.C6,_=r.AI,b=r.iX,m=r.iY;g.iX=b,g.iY=m,Z.x=b,Z.y=m;var v,E=o.A.L7,D=o.C.P;for(v in g.C6=0,Z.alpha=f,3===E?(g.AI=2,Z.size=_):8===E?(g.iX=b-D.iX,Z.x=b):9===E?(g.iX=b+D.iX,Z.x=b):10===E?(g.iY=m-D.iY,Z.y=m):11===E&&(g.iY=m+D.iY,Z.y=m),o.A.FV)g[ZC.E4.GN[ZC.EE(v)]]=o.A.FV[v],Z[ZC.EE(v)]=o.N[ZC.E4.GN[ZC.EE(v)]];if(null===ZC._n_(o.C.EN)&&(o.C.EN={}),null!==ZC._n_(o.C.EN[o.A.L+"-"+o.L]))for(v in o.C.EN[o.A.L+"-"+o.L])g[ZC.E4.GN[ZC.EE(v)]]=o.C.EN[o.A.L+"-"+o.L][v];o.C.EN[o.A.L+"-"+o.L]={},ZC._cp_(Z,o.C.EN[o.A.L+"-"+o.L]);var w=new ZC.E4(g,Z,o.A.JF,o.A.L6,ZC.E4.RI[o.A.L8],function(){A()});w.AX=o,w.OF=function(){o.N6(ZC.Q.EB(o.A.CP("bl",0),o.H.AA))},o.LM(w)}else{var x="circle"===r.DU?"circle":"path";if(o.A.HI){var B=function(t,i){var n=t.cloneNode(!1),a=o.iX,l=o.iY;if(e){var s=new ZC.CE(o.C,a-ZC.AO.E2,l-ZC.AO.E3,o.A.E["z-start"]||0);a=ZC._x_(s.ED[0]),l=ZC._x_(s.ED[1]),o.E["3dxy"]=[a,l]}n.setAttribute("transform","translate("+ZC._i_(a-r.iX)+","+ZC._i_(l-r.iY)+") "+(n.getAttribute("transform")||"")),n.setAttribute("id",i),"bubble"!==o.A.AF&&"hbubble"!==o.A.AF||n.setAttribute("r",o.E["marker.size"]),t.parentNode.appendChild(n)};r.M8&&B(o.A.RA,o.K+"-marker-sh-"+x),B(o.A.HI,o.K+"-marker-"+x),r.DA&&B(o.A.QB,o.K+"-marker-imgfill")}else{r.paint();var y=r.A0!==r.AE;if(!o.C.IX[o.A.L]&&o.A.YH&&!y)if("svg"===o.H.AA){if(-1===ZC.AV(["pie","square","rect","rectangle","cross","plus","custom"],r.DU))if(o.A.HB=r,zingchart.DEV.DOMFRAGMENTS&&document.querySelector){for(var K in o.H.G1)o.A.HI||(o.A.HI=o.H.G1[K].querySelector("#"+o.K+"-marker-"+x)),r.M8&&!o.A.RA&&(o.A.RA=o.H.G1[K].querySelector("#"+o.K+"-marker-sh-"+x)),r.DA&&!o.A.QB&&(o.A.QB=o.H.G1[K].querySelector("#"+o.K+"-marker-imgfill")||o.H.G1[K].querySelector("#"+o.K+"-marker-path-imgfill"));o.A.HI||(o.A.HI=ZC.AK(o.K+"-marker-"+x),r.M8&&(o.A.RA=ZC.AK(o.K+"-marker-sh-"+x)),r.DA&&(o.A.QB=ZC.AK(o.K+"-marker-imgfill")))}else o.A.HI=ZC.AK(o.K+"-marker-"+x),r.M8&&(o.A.RA=ZC.AK(o.K+"-marker-sh-"+x)),r.DA&&(o.A.QB=ZC.AK(o.K+"-marker-imgfill")||ZC.AK(o.K+"-marker-path-imgfill"))}else"bubble"!==o.A.AF&&"hbubble"!==o.A.AF&&(e||(o.A.HB=r))}"svg"===o.H.AA&&o.A.applyJsRuleSvg(o.A.A2,o.K+"-marker-"+x,o.LT()),A()}}else o.A.U&&o.GW()}else o.A.U&&o.GW()}}}},LM:function(e,t){var i,n=this,a=n.C.LW,r=a.PG,l=n.A.TL;switch(l){default:t&&a.add(t),a.add(e);break;case 1:case 2:case 3:if(t){var o="all";if(1===l?o="plots-group-"+n.L+"-area":2===l&&(o="nodes-group-"+n.A.L+"-area"),null===ZC._n_(r[o])){var s=new ZC.VK(o);a.A9K(s,t.XI)}r[o].add(t)}if(i="all",1===l?i="plots-group-"+n.L:2===l&&(i="nodes-group-"+n.A.L),null===ZC._n_(r[i])){var c=new ZC.VK(i);a.A9K(c,e.XI)}r[i].add(e)}},TR:function(e){var t=this;t.A.I3&&t.A.bXY&&(t.T6(),e&&("scatter"!==t.A.AF&&"hscatter"!==t.A.AF&&"bubble"!==t.A.AF&&"hbubble"!==t.A.AF||t.paint(!0)));var i=t.A.BP;t.M5({layer:e,type:"shape",id:"marker",marker:!0,initcb:function(){this.DU=t.E["marker.type"],this.iX=t.iX,this.iY=t.iY,"bubble"===t.A.AF||"hbubble"===t.A.AF?(this.AE=i[3],this.A0=i[2]):(this.B7=i[3],this.BW=i[3],this.A0=i[2],this.AE=i[1]),this.AI=t.E["marker.size"]}})},A1F:function(e){var t=this;t.M5({layer:e,type:"line",id:"line",initcb:function(){this.B7=t.A.BP[3]}})},M5:function(e){if(!ZC.move){var t,i,n,a,r,l,o=this,s=e.layer||"hover",c=e.id||"",h=!1;switch(o.GJ=null,null!==ZC._n_(t=e.marker)&&(h=ZC._b_(t)),s){case"hover":null!==ZC._n_(o.C.CB["p"+o.A.L])&&null!==ZC._n_(o.C.CB["p"+o.A.L]["n"+o.L])||(n=h?o.A.GA:o.A.IE,a="hover");break;case"highlight":n=h?o.A.V6:o.A.S2,a="hover"}if(null!==ZC._n_(e.state)&&(n=e.state),n&&o.C.E["plot"+o.A.L+".visible"]&&n.AN){switch(e.type){case"box":(l=new ZC.HL(o.A)).PU=!0;break;case"line":l=new ZC.DT(o.A),r=ZC.Q.EB(o.C.K+"-"+a+"-c",o.H.AA),l.CZ=!1;break;case"shape":l=new ZC.DT(o.A);break;case"area":l=new ZC.DT(o.A),r=ZC.Q.EB(o.C.K+"-"+a+"-c",o.H.AA)}if(h&&(l.E["p-width"]=o.A.B1.AC,l.E["p-height"]=o.A.CM.AC),zingchart.DEV.PLOTSHLAYER&&"hover"===a?l.Z=l.C7=ZC.AK(o.C.K+"-plots-hover-c"):l.Z=l.C7=ZC.AK(o.C.K+"-"+a+"-c"),l.K=o.K+"-"+(""!==c?c+"-":"")+s,l.E.plotidx=o.A.L,l.E.nodeidx=o.L,"hover"!==s&&(l.A2A=!0),e.initcb&&e.initcb.call(l),l.append(n.o),e.parsecb&&e.parsecb.call(l),"hover"===s&&null!==ZC._n_(t=o.A.o)&&null!==ZC._n_(t.styles)&&null!==ZC._n_(i=t.styles[o.L])&&("string"==typeof i?l.append({"background-color":i,"line-color":i,"border-color":i}):l.append(i)),null!==ZC._n_(t=o.A.o[s+"-state"])&&null!==ZC._n_(t.styles)&&null!==ZC._n_(i=t.styles[o.L])&&("string"==typeof i?l.append({"background-color":i,"line-color":i,"border-color":i}):l.append(i)),o.A.HT&&o.H3(l,s),"hover"===s&&o.A.A2&&o.A.A2.HT&&(o.A.A2.H3(o.A.A2,l,null,o.LT(null,!1)),l.parse()),l.parse(),l.J2=function(e){return o.J2(e)},l.DE()&&l.parse(),l.AN){switch(e.setupcb&&e.setupcb.call(l),e.type){case"box":case"shape":l.locate(2),l.paint();break;case"line":ZC.CR.setup(r,l),"plot"===o.A.A3K?ZC.CR.paint(r,l,o.A.V3):ZC.CR.paint(r,l,o.getNodeData("points"));break;case"area":"spline"!==o.A.CW&&(null!==ZC._n_(t=n.o["alpha-area"])&&(l.C6=ZC._f_(t)),ZC.CR.setup(r,l),l.paint())}o.GJ=l}}}},N6:function(){},setup:function(){},A0W:function(){},LD:function(){var e=this;ZC.Q.EU([e.K+"-hover-gradient",e.K+"-marker-hover-gradient",e.H.K+"-tooltip-text-gradient",e.H.K+"-tooltip-text-sh-gradient"])},LT:function(e,t){var i=this;void 0===t&&(t=!0);var n=!1;"none"!==i.A.IZ&&i.C.CB&&i.C.CB["p"+i.A.L]&&i.C.CB["p"+i.A.L]["n"+i.L]&&(n=!0);var a={id:i.C.A.K,graphid:i.C.K,graphindex:i.C.L,plotid:i.A.H8,plotindex:i.A.L,nodeindex:i.L,key:null===i.BT?i.L:i.BT,scaleval:i.A.B1?i.A.B1.V[null===i.BT?i.L:i.BT]:null,scaletext:i.A.B1?i.A.B1.FQ(i.L,null===i.BT?null:i.A):null,value:i.AD,text:t?i.JV(i.A.JB):i.A.JB,ev:e?ZC.A5.BZ(e):null,x:i.iX,y:i.iY,width:i.I,height:i.F,size:i.E["marker.size"]||1,selected:n};for(var r in i.A.KH)i.A.KH[r]instanceof Array?null!==ZC._n_(i.A.KH[r][i.L])&&(a["data-"+r]=i.A.KH[r][i.L]):a["data-"+r]=i.A.KH[r];return a},X4:function(e,t){ZC.AP.BY("node_"+t,this.H,this.LT(e))}};ZC.LG=ZC.DN.CA(LG);var F3={$i:function(e){this.b(e);var t=this;t.H=t.A.A,t.BE="",t.V=[],t.BX=[],t.A53=[],t.DJ=!1,t.M=null,t.BR=null,t.IT=null,t.D7=null,t.FR=0,t.I9=null,t.G5=null,t.H6=0,t.P0=null,t.L=1,t.AB=0,t.A46=0,t.BV=0,t.AW=!1,t.CO=!1,t.AC=0,t.iStepMultiplier=1,t.DQ=-1,t.RD=ZC.HJ["thousands-separator"]||"",t.RW=ZC.HJ["decimals-separator"]||".",t.ZX=!1,t.SE=2,t.A33=!1,t.TX="",t.A04="standard",t.CI=null,t.AF="",t.EG=ZC.MAX,t.M0=ZC.MAX,t.GO=!1,t.Y7=!1,t.KN=null,t.NN=null,t.Q4=[],t.E5=1,t.B3=-1,t.BJ=-1,t.SG=-1,t.FW=-1,t.H1=-1,t.C1="lin",t.E6=10,t.FG=null,t.OZ=1,t.PU=!0,t.A0J=!1,t.aAutoFit=[!1,!1],t.LR=null,t.WH=null,t.T9=!1,t.I1=-1,t.YQ=!1,t.BA="default",t.PZ=!1,t.VE=!1,t.R2=1,t.sMaster="",t.bNormalize=!0,t.bAllowDuplicates=!1},parse:function(){this.b();var e,t=this;if(null!==ZC._n_(e=t.o.step))if(ZC.P5(e))t.E5=ZC._f_(e);else{var i=e.replace(/[0-9]/gi,""),n=parseInt(e.replace(/[^0-9]/gi,""),10);switch(n=n||1,i){case"second":t.E5=1e3*n;break;case"minute":t.E5=1e3*n*60;break;case"hour":t.E5=1e3*n*60*60;break;case"day":t.E5=1e3*n*60*60*24;break;case"week":t.E5=1e3*n*60*60*24*7;break;case"month":t.E5=2629743e3*n;break;case"year":t.E5=31556926e3*n}}if(null!==ZC._n_(t.o.multiplier)&&null===ZC._n_(t.o.short)&&(t.o.short=t.o.multiplier),t.assign_a([["labels","BX"],["tooltip-text","A53"],["format","CI"],["offset-start","AB","i"],["offset-start","A46","i"],["offset-end","BV","i"],["minor-ticks","FR","i"],["step-multiplier","iStepMultiplier","i"],["index","L","i"],["mirrored","AW","b"],["zooming","GO","b"],["zoom-snap","Y7","b"],["fixed-step","PZ","b"],["zoom-to","KN"],["force-view","YQ","b"],["zoom-to-values","NN"],["items-overlap","A0J","b"],["used","T9","b"],["max-labels","EG","i"],["max-items","EG","i"],["ref-value","H6","f"],["decimals","DQ","ia"],["decimals-separator","RW"],["thousands-separator","RD"],["short","A33","b"],["short-unit","TX"],["negation","A04"],["exponent","ZX","b"],["exponent-decimals","SE","ia"],["progression","C1"],["log-base","E6","fa"],["scale-factor","OZ","fa"],["show-labels","LR"],["max-decimals","I1","i"],["placement","BA"],["factor","R2","f"],["master","sMaster"],["blended","VE","b"],["ranged","DJ","b"],["normalize","bNormalize","b"],["allow-duplicates","bAllowDuplicates","b"]]),"log"===t.C1&&(null===ZC._n_(t.o["minor-ticks"])&&(t.FR=Math.max(0,t.E6-2)),null!==ZC._n_(t.KN)&&"v"===t.AF&&(t.KN[0]=ZC.G6(t.KN[0],t.E6),t.KN[1]=ZC.G6(t.KN[1],t.E6))),null!==ZC._n_(e=t.o["auto-fit"])&&(e.length?(t.aAutoFit[0]=ZC._b_(e[0]),t.aAutoFit[1]=ZC._b_(e[e.length-1])):t.aAutoFit[0]=t.aAutoFit[1]=ZC._b_(e)),"string"==typeof t.BX){var a=t.BX.split(":"),r=1;3===a.length&&(r=ZC._f_(a[2])),t.BX=[];for(var l=ZC._f_(a[0]);l<ZC._f_(a[1]);l+=r)t.BX.push(""+l);t.BX.push(""+a[1])}null!==ZC._n_(t.o["fixed-items"])&&(t.EG=ZC.MAX),t.EG=ZC.BQ(t.EG,2),null!==ZC._n_(e=t.o.offset)&&(t.AB=t.BV=ZC._i_(e),0!==ZC._i_(e)||"mixed"!==t.A.AF&&"mixed3d"!==t.A.AF||(t.DJ=!1)),null!==ZC._n_(e=t.o["max-ticks"])?t.M0=ZC._i_(e):t.M0=t.EG,t.M0=ZC.BQ(2,t.M0),null!==ZC._n_(e=t.o.transform)&&(t.FG=new ZC.D0,t.FG.append(e));var o=t.A.A.B8,s="("+t.A.AF+")",c=t.BE.replace(/\-[0-9]/,""),h=t.BE.replace(/\-[0-9]/,"-n");function C(e){var i=[s+".SCALE."+e,s+"."+t.BE+"."+e,s+"."+c+"."+e,s+"."+c+"["+t.BA+"]."+e,s+"."+h+"."+e];return t.A.AJ["3d"]&&(i=i.concat([s+".SCALE[3d]."+e,s+"."+t.BE+"[3d]."+e,s+"."+c+"[3d]."+e,s+"."+h+"[3d]."+e])),i}if(null===ZC._n_(t.o.placement)&&t.L>1&&(t.BA="opposite"),null!==ZC._n_(e=t.o.markers))for(var u=0,d=e.length;u<d;u++){var A=new ZC.A0F(t);A.L=u,A.K=t.K+"-marker-"+u,o.load(A.o,C("marker")),A.append(e[u]),A.parse(),t.Q4.push(A)}t.P0=new ZC.D0(t),o.load(t.P0.o,C("ref-line")),t.P0.append(t.o["ref-line"]),"k"===t.AF&&(t.P0.AN=!1),t.P0.parse(),t.M=new ZC.DN(t),o.load(t.M.o,C("label")),t.M.append(t.o.label),t.M.K=t.K+"-label",t.M.parse(),t.BR=new ZC.DN(t),o.load(t.BR.o,C("item")),t.BR.append(t.o.item),t.BR.K=t.K+"-item",t.BR.parse(),t.IT=new ZC.D0(t),o.load(t.IT.o,C("tick")),t.IT.append(t.o.tick),t.IT.parse(),t.D7=new ZC.D0(t),o.load(t.D7.o,C("guide")),t.D7.append(t.o.guide),t.D7.parse(),null===ZC._n_(t.D7.o.items)&&"-1"!==t.D7.A0&&"-1"!==t.D7.AE&&t.D7.A0!==t.D7.AE&&(t.D7.o.items=[{alpha:t.D7.C6,"background-color":t.D7.A0},{alpha:t.D7.C6,"background-color":t.D7.AE}]),t.I9=new ZC.D0(t),o.load(t.I9.o,C("minor-tick")),t.I9.append(t.o["minor-tick"]),t.I9.parse(),t.G5=new ZC.D0(t),o.load(t.G5.o,C("minor-guide")),t.G5.append(t.o["minor-guide"]),t.G5.parse(),t.A51()},A51:function(){var e,t=this,i={x:"iX",y:"iY",width:"I",height:"F"};for(var n in i){var a=t.A.P[i[n]];null!==ZC._n_(t.o[n])&&(a=ZC.II(t.o[n]))>=0&&a<=1&&(a="x"===n||"y"===n?t.A.P["x"===n?"iX":"iY"]+ZC._i_(a*t.A.P["x"===n?"I":"F"]):ZC._i_(a*t.A.P[i[n]])),t[i[n]]=a}null!==ZC._n_(e=t.o.offset)&&(t.AB=t.BV=ZC._f_(ZC._p_(e))),null!==ZC._n_(e=t.o["offset-start"])&&(t.AB=ZC._f_(ZC._p_(e))),null!==ZC._n_(e=t.o["offset-end"])&&(t.BV=ZC._f_(ZC._p_(e)));var r="k"===t.AF&&!t.CO||"v"===t.AF&&t.CO?t.I:t.F;t.AB<1&&(t.AB*=r),t.BV<1&&(t.BV*=r)},YM:function(e){var t=this;null!==ZC._n_(t.o.rules)&&(t.WH||(t.WH=new ZC.F3(t.A)),t.WH.append(t.o),t.WH.parse(),t.WH.J2=e,t.WH.DE()&&(t.WH.parse(),t.DQ=t.WH.DQ,t.CI=t.WH.CI))},J1:function(){},A7U:function(){},AC9:function(){},A96:function(){},clear:function(){},build:function(){},MP:function(){var e,t=this,i={negation:t.A04,"thousands-separator":t.RD,"decimals-separator":t.RW,decimals:t.DQ,"max-decimals":t.I1,short:t.A33,"short-unit":t.TX,exponent:t.ZX,"exponent-decimals":t.SE};if(t.FG)switch(t.FG.o.type){case"date":i["transform-date"]=!0,null!==ZC._n_(e=t.FG.o.text)&&(t.FG.o.all=e);var n=t.V[t.A1]-t.V[t.W],a="",r="",l={},o=["msecond","second","minute","hour","day","month","year"];for(var s in o)l[o[s]]=ZC.HJ["date-formats"][o[s]];r=0<=n&&n<=1e3?"msecond":1e3<n&&n<=36e5?"second":36e5<n&&n<=864e5?"minute":864e5<n&&n<=26784e5?"hour":26784e5<n&&n<=316224e5?"day":316224e5<n&&n<=632448e6?"month":"year",a=null!==ZC._n_(t.FG.o[r])?t.FG.o[r]:null!==ZC._n_(t.FG.o.all)?t.FG.o.all:l[r],t.E.dateformat=a,i["transform-date-format"]=t.E.dateformat}return i},A0E:function(){for(var e=this,t=e.A.AY.A4,i=-1,n=0,a=t.length;n<a;n++){var r=t[n].BU(e.AF);if(-1!==ZC.AV(r,e.BE)){switch(t[n].AF){case"pie":case"pie3d":case"nestedpie":case"vbar":case"vbar3d":case"hbar":case"hbar3d":case"vbullet":case"hbullet":case"area":case"area3d":case"gauge":case"vfunnel":case"hfunnel":case"venn":i=t[n].A0;break;case"scatter":case"bubble":i=-1!==t[n].A2.A0?t[n].A2.A0:t[n].A0;break;default:i=t[n].B7}break}}return i},paint:function(){var e=this;e.build(),e.A.AJ["3d"]||e.b()},MX:function(e,t,i,n){var a=this;if(null===ZC._n_(n)&&(n=5),a.A.AJ["3d"]){var r=new ZC.CE(a.A,e.iX+e.I/2-ZC.AO.E2,e.iY+e.F/2-ZC.AO.E3,0+e.AA8);e.iX=r.ED[0]-e.I/2+("v"===i?"default"===a.BA?-n:n:0),e.iY=r.ED[1]-e.F/2+("h"===i?"default"===a.BA?n:-n:0);var l=ZC.DI.A2T(a.A,e);null===ZC._n_(t)&&(t=e.A9,e.A9%90==0&&(t+=e.V9?0:l)),e.A9=t}return t},X3:function(e,t,i){var n=this,a=(i.items,i.lcoords),r=i.lstep,l=i.tdim,o=i.mdim,s=i.dim,c=i.html,h=[e.iX+e.BM,e.iY+e.BH,e.I,e.F],C=ZC._a_(e.A9%180),u=!1;C%360!=0&&(u=!0),u&&(h=[e.iX+e.BM+e.I/2-e.F/2,e.iY+e.BH+e.F/2-e.I/2,e.F,e.I]);var d=!0;if(e.AN){if(!n.A0J)if("log"===n.C1||t!==n.W&&t!==n.A1){t%r==0&&(d=!0);for(var A=0,p=a.length;A<p;A++)if(ZC.AQ.XM({x:h[0],y:h[1],width:h[2],height:h[3]},{x:a[A][0],y:a[A][1],width:a[A][2],height:a[A][3]})){d=!1;break}}else d=!0;d&&(a.push(h),e.paint(),0,o=ZC.BQ(o,1.5*e.DG*(e.AM||"").split("<br>").length),"h"===s?(l+=e.F,o=ZC.BQ(o,ZC._a_(ZC.EP(C))*ZC.BQ(e.I,e.F))):"w"===s&&(l+=e.I,o=ZC.BQ(o,ZC._a_(ZC.EH(C))*ZC.BQ(e.I,e.F))),e.EK(),null===ZC._n_(n.o.tooltip)&&e.K9||(null!==ZC._n_(n.o.tooltip)&&(n.o.tooltip.text=n.o.tooltip.text||"%scale-value"),c.push(ZC.AP.O5(n.A.K,e))))}return{tdim:l,mdim:o,overlaps:!d}},VG:function(e,t){var i=this;if("v"===i.AF&&(i.H6!==i.B3&&i.H6!==i.BJ||(null===ZC._n_(i.o["ref-line"])||null!==ZC._n_(i.o["ref-line"])&&null===ZC._n_(i.o["ref-line"].visible))&&(i.P0.AN=!1)),i.P0.K=i.K+"-ref-line",i.V.length>0&&i.P0.AN&&!i.A.AJ["3d"]&&i.P0.AZ>0){"inherit"===i.P0.o["line-color"]&&-1!==t&&(i.P0.B7=t);var n=i.H6;if("k"===i.AF&&!i.CO||"v"===i.AF&&i.CO){var a=i.AT(n);a>=i.iX&&a<=i.iX+i.I&&ZC.CR.paint(e,i.P0,[[a,i.iY],[a,i.iY+i.F]])}else{var r=i.AT(n);r>=i.iY&&r<=i.iY+i.F&&ZC.CR.paint(e,i.P0,[[i.iX,r],[i.iX+i.I,r]])}}},paint_:function(){},XL:function(){for(var e=this,t=0,i=e.Q4.length;t<i;t++)e.V.length>0&&e.Q4[t].paint()},gc:function(){ZC.AP.gc(this,["V","BX","Z","C7","D7","BR","M","G5","I9","P0","IT","J2","o","I6","J9","A","H"])}};ZC.F3=ZC.HL.CA(F3);var ZI={$i:function(e){this.b(e);var t=this;t.EF=!1,t.AF="k",t.DC=-1,t.DX=-1,t.W=-1,t.A1=-1,t.V7=1,t.DQ=null,t.OK=0,t.A5E=!1,t.O1=!1,t.U9={},t.IQ=[],t.iMinOffset=0},zoomTo:function(e,t){var i=this;if(i.GO){null!==ZC._n_(e)?i.W=e:i.W=i.DC,null!==ZC._n_(t)?i.A1=t:i.A1=i.DX;var n=i.IQ;if(n.length>0?(i.B3=ZC.AV(n,i.V[i.W]),i.BJ=ZC.AV(n,i.V[i.A1])):(i.B3=i.V[i.W],i.BJ=i.V[i.A1]),i.H.H2.C||(i.H.H2.C=i.A),i.A.H2&&null!==ZC._n_(i.A.H2.o.shared)&&ZC._b_(i.A.H2.o.shared)&&i.A.K===i.H.H2.C.K)for(var a=0,r=i.H.AG.length;a<r;a++){var l=i.H.AG[a];if(l.K!==i.A.K&&null!==ZC._n_(l.H2.o.shared)&&ZC._b_(l.H2.o.shared)){var o=l.BL(i.BE);o&&o.GO&&(e=Math.max(o.DC,Math.min(o.DX,i.W)),t=Math.max(o.DC,Math.min(o.DX,i.A1)),o.zoomTo(e,t),ZC.AK(l.K)&&(l.clear(!0),l.E["shared-zoom"]=!0,l.paint(),l.B9&&l.B9.update(e,t,null,null,!0)))}}i.J1()}},zoomToV:function(e,t){var i=this;null!==ZC._n_(e)?i.B3=e:i.B3=i.FW,null!==ZC._n_(t)?i.BJ=t:i.BJ=i.H1,i.RQ(i.B3,i.BJ,null===ZC._n_(e)&&null===ZC._n_(t))},FQ:function(L,J,ER,bKeep,AD){var s=this,CU="";J?(CU=J.S[L].BT,s.FG&&"date"===s.FG.o.type||"number"==typeof CU||(null!==ZC._n_(s.BX[CU])?CU=s.BX[CU]:null!==ZC._n_(s.V[CU])&&(CU=s.V[CU]))):CU="log"===s.C1&&bKeep?L+1:null!==ZC._n_(s.BX[L])?s.BX[L]:s.V[L],"number"==typeof CU&&null!==ZC._n_(s.IQ[CU])&&(CU=s.IQ[CU]),null!==ZC._n_(AD)&&(CU=AD);var OO=ZC.P5(CU)&&ZC._f_(CU)<0,BC=s.MP();if(ZC._cp_(ER,BC),OO&&"currency"===BC.negation&&(CU=ZC._a_(ZC._f_(CU))),BC.utc=s.A.UL,BC.timezone=s.A.NB,CU=ZC.AP.G2(CU,BC,s,!0),s.CI)if("()"===s.CI.substring(s.CI.length-2)||"javascript:"===s.CI.substring(0,11))try{var EC=s.CI.replace("javascript:","").replace("()","");eval(EC)&&(CU=eval(EC).call(s,CU))}catch(e){}else CU=OO&&"currency"===BC.negation?"-"+s.CI.replace(/%v|%scale-value/g,CU):s.CI.replace(/%v|%scale-value/g,CU);return CU},JV:function(e,t,i,n,a){var r=this,l=r.FQ(t,i,n,a),o=[];o.push(["%scale-label",l],["%scale-index",t],["%scale-position",t]),r.FG&&"date"===r.FG.o.type?o.push(["%scale-value",l],["%v",l]):"log"===r.C1&&a?o.push(["%scale-value",Math.pow(r.E6,t)],["%v",Math.pow(r.E6,t)]):o.push(["%scale-value",ZC._c_(r.V[t],"")],["%v",ZC._c_(r.V[t],"")]),o.push(["%l",l],["%t",l],["%i",t],["%c",t]),o.sort(ZC.A1H);for(var s=0,c=o.length;s<c;s++){var h=new RegExp(o[s][0],"g");e=e.replace(h,o[s][1])}return e},A7U:function(){var e=this,t=ZC.BQ(e.V.length,e.BX.length),i=0;if(t>0&&e.BR.A9%180==0){for(var n=ZC.BQ(1,ZC._i_(t/20)),a=0,r=0;r<t;r+=n){for(var l=((e.BX[r]||e.V[r])+"").split(/<br>|<br\/>|<br \/>|\n/),o=0,s=0,c=l.length;s<c;s++)o=ZC.BQ(o,11*l[s].replace(/<.+?>/gi,"").replace(/<\/.+?>/gi,"").length);i+=o,a++}i=.75*i/Math.max(1,a)}else i=15;e.CO?e.EG=ZC._i_((e.F-e.AB-e.BV)/15):e.EG=ZC._i_((e.I-e.AB-e.BV)/i),e.EG=ZC.CY(e.EG,20),(e.BJ-e.B3)/e.E5+1<e.EG?e.EG=ZC.BQ(e.EG,ZC._i_((e.BJ-e.B3)/e.E5)+1):(e.BJ-e.B3)/(2*e.E5)+1<e.EG&&(e.EG=ZC.BQ(e.EG,ZC._i_((e.BJ-e.B3)/(2*e.E5))+1)),e.EG=ZC.BQ(2,e.EG)},AC9:function(){var e=this;null===ZC._n_(e.o["max-ticks"])&&(e.M0=e.EG)},A96:function(e){var t,i,n,a,r,l=this;if(1===e&&l.o.transform&&"date"===l.o.transform.type&&(null===ZC._n_(l.o.transform.uniform)||ZC._b_(l.o.transform.uniform)||(l.O1=!0)),1===e&&null!==ZC._n_(l.o.values))if(l.V=[],"object"==typeof l.o.values)for(l.V=l.o.values,0===l.BX.length&&(l.BX=l.V),n=0,a=l.V.length;n<a;n++)"string"==typeof l.V[n]&&(l.A5E=!0,l.IQ.push(l.V[n]));else{var o=l.o.values.split(":"),s=l.E5;if(3===o.length&&(s=ZC._f_(o[2])),l.E5=l.SG=s,ZC._f_(o[0])>ZC._f_(o[1])){var c=o[0];o[0]=o[1],o[1]=c}if(s<=0&&(s=1),o.length>1){for(var h=0,C=0,u=0,d=(""+s).split("."),A=ZC._f_(o[0]);A<=ZC._f_(o[1]);A+=s){var p=(""+A).split(".");d.length>1&&p.length>1&&d[1].length>0&&p[1].length>=9&&ZC._a_(p[1].length-d[1].length)>2?(h+=d[1].length,C=ZC.BQ(C,d[1].length),u++,null!==(r=ZC._n_(l.o.decimals))?l.V.push(ZC._f_(Number(A).toFixed(ZC._i_(r)))):l.V.push(ZC._f_(ZC._fixed_(Number(A),d[1].length))),A=ZC._f_(ZC._fixed_(Number(A),d[1].length))):(h+=p[1]?p[1].length:0,C=ZC.BQ(C,p[1]?p[1].length:0),u++,null!==(r=ZC._n_(l.o.decimals))?l.V.push(ZC._f_(Number(A).toFixed(ZC._i_(r)))):l.V.push(A))}null===ZC._n_(l.o.decimals)&&(h=Math.ceil(h/u),l.DQ=ZC._a_(C-h)<=1?C:h)}}if(2===e){var g=0,Z=[];0===l.V.length?(t=ZC.MAX,i=-ZC.MAX):(t=l.V[0],i=l.V[l.V.length-1]);var f,_,b=l.A.AY.A4,m=!1;for(n=0,a=b.length;n<a;n++){var v=b[n].BU();if(-1!==ZC.AV(v,l.BE)){for(var E=0===Z.length,D=0,w=b[n].S.length;D<w;D++)if(b[n].S[D])if(null!==b[n].S[D].BT){var x=b[n].S[D].BT;t=ZC.CY(t,x),i=ZC.BQ(i,x),l.O1&&E&&Z.push(x),l.EF=!0,b[n].EF=!0}else m=!0;else l.O1&&E&&Z.push("");b[n].EF||(g=ZC.BQ(g,b[n].S.length))}}if(null!==ZC._n_(l.o.values))for(n=0;n<l.V.length;n++)null===l.V[n]&&(l.V[n]="");if(null!==ZC._n_(l.o.labels))for(n=0;n<l.BX.length;n++)null===l.BX[n]&&(l.BX[n]="");if(g>l.V.length&&l.V.length>0&&!l.EF)for(n=l.V.length;n<g;n++);var B=0;for(n=0;n<b.length;n++)b[n].LP&&(-1===b[n].R4&&(b[n].R4=B),B++,l.DJ=!0);if(0===l.V.length)for(n=0;n<B;n++)l.V.push(n),l.BX.push(n);if(0===l.V.length)if(l.EF)m&&t>0&&(t=0),m&&i<g-1&&(i=g-1),null!==ZC._n_(l.o["min-value"])&&(t=ZC._f_(l.o["min-value"])),null!==ZC._n_(l.o["max-value"])&&(i=ZC._f_(l.o["max-value"])),i-t<l.E5&&i-t>0&&(l.E5=Math.pow(10,Math.floor(ZC.G6(i-t)/Math.LN10))),l.O1||l.RQ(t,i,!0),0===t&&0===i&&"0,1"===l.V.join(",")&&(l.V=[0]);else if(null!==ZC._n_(l.o["max-value"])){f=0,_=0,null!==ZC._n_(l.o["min-value"])&&(f=ZC._f_(l.o["min-value"])),_=ZC._f_(l.o["max-value"]),n=0;var y=f;if(l.FG&&null!==ZC._n_(l.FG.o.type))switch(l.FG.o.type){case"date":l.E5=l.A1X(f,_)}else(_-f)/l.E5>1e4&&(l.E5=Math.pow(10,ZC.BQ(1,ZC._i_(ZC.G6(ZC._a_(_-f),10)-4))));for(;y<_;)y=l.A.A2P(n*l.E5+f),null===ZC._n_(l.V[n])&&(l.V[n]=y),n++}else if(_=(f=null!==ZC._n_(l.o["min-value"])?ZC._f_(l.o["min-value"]):0)+(g-1)*l.E5,"log"===l.C1)l.RQ(f,_,!0);else for(n=0;n<g;n++)null===ZC._n_(l.V[n])&&(l.V[n]=l.A.A2P(n*l.E5+f));l.O1&&l.EF&&(l.V=[].concat(Z),l.BX=[].concat(Z))}if(l.O1)for(l.U9={},n=0,a=l.BX.length;n<a;n++)l.U9[l.BX[n]]=n;if(l.W=0,l.A1=l.V.length-1,l.DC=0,l.DX=l.V.length-1,l.IQ.length>0?(l.B3=l.W,l.BJ=l.A1):(l.B3=ZC._f_(l.V[l.W]),l.BJ=ZC._f_(l.V[l.A1])),l.NN){-1===ZC.AV(l.V,l.NN[0])&&ZC.P5(l.NN[0])&&null!==ZC._n_(l.V[0])&&-1!==l.SG&&(l.NN[0]=l.V[0]+l.SG*Math.floor((l.NN[0]-l.V[0])/l.SG)),-1===ZC.AV(l.V,l.NN[1])&&ZC.P5(l.NN[1])&&null!==ZC._n_(l.V[0])&&-1!==l.SG&&(l.NN[1]=l.V[0]+l.SG*Math.ceil((l.NN[1]-l.V[0])/l.SG));var K=ZC.AV(l.V,l.NN[0]),F=ZC.AV(l.V,l.NN[1]);l.KN=[-1===K?0:K,-1===F?l.V.length-1:F]}l.KN&&-1!==l.W&&-1!==l.A1&&((l.KN[0]>l.A1||l.KN[0]<l.W)&&(l.KN[0]=l.W),(l.KN[1]>l.A1||l.KN[1]<l.W)&&(l.KN[1]=l.A1));var M=l.H.E["graph"+l.A.L+".zoom"];if(null===ZC._n_(l.H.E.preservezoom)||l.H.E.preservezoom){var z=1===l.L?"":"-"+l.L;void 0!==M&&null!==ZC._n_(M["xmin"+z])&&null!==ZC._n_(M["xmax"+z])&&(l.KN=[M["xmin"+z],M["xmax"+z]])}else l.H.E["graph"+l.A.L+".zoom"]={};l.KN&&(l.A.A17=!0)},RQ:function(e,t,i){var n,a,r,l,o=this,s=!1,c=null!==ZC._n_(o.o.step)&&-1!==(""+o.o.step).indexOf("month");if(o.FG&&null!==ZC._n_(o.FG.o.type))switch(o.FG.o.type){case"date":var h=o.A1X(e,t);(t-e)%h!=0&&(c||(t+=h-(t-e)%h)),n=[e,t,h,1,h],s=!0}else if("log"===o.C1)n=[e,t,1,1,1];else{var C=null!==ZC._n_(o.o.step)||null!==ZC._n_(o.o["min-value"])||null!==ZC._n_(o.o["max-value"]);n=e!==t?ZC.AQ.VS(e,t,o.E5,o.OZ,C):[e,t,o.E5,1,o.E5]}-1===o.SG&&(o.SG=n[4]);var u=n[0],d=n[1];l=n[2],i&&"log"===o.C1&&(u=Math.floor(ZC.G6(u,o.E6)),d=Math.ceil(ZC.G6(d,o.E6))),null===ZC._n_(o.o.step)&&(d-u)/l>1e4&&(l=(d-u)/1e4,r=Math.ceil(ZC.G6(l)/Math.LN10),l=Math.pow(10,r)),null===ZC._n_(o.o["min-value"])&&u!==d&&(s&&c||(u-=u%l)),null===ZC._n_(o.o["max-value"])&&u!==d&&(s&&c||(d=d-d%l+(d%l==0?0:l))),r=Math.floor(ZC.G6(l)/Math.LN10);var A,p=n[3];if(r<p&&r<0&&(p=r),"log"===o.C1&&(p=ZC.BQ(1,p)),o.V=[],s&&c){var g=ZC.AP.Y5(u,"%Y-%n-%d-%H-%i-%s",!1,0).split("-"),Z=new Date(u).getTimezoneOffset(),f=!0,_=ZC._i_((""+o.o.step).replace("month",""));0===_&&(_=1);var b=ZC._i_(g[1]),m=ZC._i_(g[0]);for(o.V.push(u);f&&u!==d;){f=!1;var v=ZC._i_(g[2]);b+_>=12&&m++,b=(b+_)%12,(31===v&&(3===b||5===b||8===b||10===b)||v>28&&1===b)&&(v=1===b?m%4==0&&m%100!=0||m%400==0?29:28:30);var E=new Date(m,b,v,ZC._i_(g[3]),ZC._i_(g[4]),ZC._i_(g[5])),D=E.getTimezoneOffset(),w=E.getTime()+6e4*(Z-D);o.V.push(w),w<d&&w<=t&&(f=!0)}}else if(i){o.FW=e,o.H1=t,o.V7=ZC._i_((d-u)/l);var x=(""+l).split("."),B=new String(x[1]||"0").length;for((d-u)%l!=0&&(d-=(d-u)%l)<t&&(d=d-(d-u)%l+l),a=u;a<=d+1e-4;a+=l){var y,K;A=a;var F=o.DQ;if("log"===o.C1)for(var M=!0;M;)M=!1,K=y=Math.pow(o.E6,A),y=ZC._f_(ZC._fixed_(y,F)),K<1&&K!==y&&ZC.BQ(K,y)/ZC.CY(K,y)>1.005&&(M=!0,++F>ZC.CY(20,-1===o.I1?99:o.I1)&&(M=!1));else y=null!==F?ZC._f_(ZC._fixed_(A,Math.max(F,B))):ZC._f_(ZC._fixed_(A,B));o.V.push(y)}}else for(l=ZC._f_((t-e)/o.V7),a=0;a<=o.V7;a++)A=e+l*a,p<0&&(A=ZC._f_(A.toFixed(-p))),o.V.push(A);o.W=0,o.A1=o.V.length-1,o.DC=0,o.DX=o.V.length-1,o.B3=ZC._f_(o.V[o.W]),o.BJ=ZC._f_(o.V[o.A1])},A1X:function(e,t,i){void 0===i&&(i=!1);var n=t-e,a=Math.floor(ZC.G6(n)/Math.LN10);return null===ZC._n_(this.o.step)||i?a<=3?1:4===a?1e3:5===a?1e4:6===a?2e4:7===a?3e4:8===a?6e4:9===a?6e5:10===a?12e5:11===a?18e5:36e5:this.E5},parse:function(){this.b()},clear:function(){this.b()},build:function(){this.b()},paint:function(){this.b(),null!==ZC._n_(this.o.values)&&(this.T9=!0)}};ZC.ZI=ZC.F3.CA(ZI);var VQ={$i:function(e){this.b(e);var t=this;t.AF="v",t.W=-1,t.A1=-1,t.V7=0,t.DQ=null,t.KQ="normal",t.JK=[],t.bExtendMinValue=!0,t.bExtendMaxValue=!0},zoomTo:function(e,t){var i,n,a=this;if(a.GO){null!==ZC._n_(e)?a.B3=e:a.B3=a.FW,null!==ZC._n_(t)?a.BJ=t:a.BJ=a.H1,("piano"===a.A.AF||a.PZ)&&(a.B3=ZC._i_(a.B3),a.BJ=ZC._i_(a.BJ)),a.RQ(a.B3,a.BJ,!1);var r=a.A.BU("v");for(i=0;i<r.length;i++)r[i].BE!==a.BE&&r[i].sMaster===a.BE&&r[i].zoomTo(e,t);if(""===a.sMaster){if(a.H.H2.C||(a.H.H2.C=a.A),a.A.H2&&null!==ZC._n_(a.A.H2.o.shared)&&ZC._b_(a.A.H2.o.shared)&&a.A.K===a.H.H2.C.K)for(i=0,n=a.H.AG.length;i<n;i++){var l=a.H.AG[i];if(l.K!==a.A.K&&null!==ZC._n_(l.H2.o.shared)&&ZC._b_(l.H2.o.shared)){var o=l.BL(a.BE);o&&o.GO&&(e=Math.max(o.FW,Math.min(o.H1,a.B3)),t=Math.max(o.FW,Math.min(o.H1,a.BJ)),o.zoomTo(e,t),ZC.AK(l.K)&&(l.clear(!0),l.E["shared-zoom"]=!0,l.paint(),l.B9&&l.B9.update(null,null,e,t,!0)))}}a.J1()}}},FQ:function(L,CU,ER){var s=this;void 0===CU&&(CU="",CU=null!==ZC._n_(s.BX[L])?s.BX[L]:s.V[L]),"number"==typeof CU&&null!==ZC._n_(s.JK[CU])&&(CU=s.JK[CU]);var OO=ZC.P5(CU)&&ZC._f_(CU)<0,BC=s.MP();if(ZC._cp_(ER,BC),null!==ZC._n_(s.E["max-power"])&&(BC["max-power"]=s.E["max-power"]),OO&&"currency"===BC.negation&&(CU=ZC._a_(ZC._f_(CU))),BC.utc=s.A.UL,BC.timezone=s.A.NB,CU=ZC.AP.G2(CU,BC,s,!0),s.CI)if("()"===s.CI.substring(s.CI.length-2)||"javascript:"===s.CI.substring(0,11))try{var EC=s.CI.replace("javascript:","").replace("()","");eval(EC)&&(CU=eval(EC).call(s,CU))}catch(e){}else CU=OO&&"currency"===BC.negation?"-"+s.CI.replace(/%v|%scale-value/g,CU):s.CI.replace(/%v|%scale-value/g,CU);return CU},A7U:function(){var e=this,t=ZC.BQ(e.V.length,e.BX.length);if(0===t&&(t=10),"log"===e.C1)e.EG=999;else{var i=Math.max(15,10*ZC.BQ(e.V.join("").length,e.BX.join("").length)/t);e.CO?e.EG=ZC._i_((e.I-e.AB-e.BV)/i):e.EG=ZC._i_((e.F-e.AB-e.BV)/10),e.EG=ZC.CY(e.EG,10),e.EG=ZC.BQ(2,e.EG)}},AC9:function(){var e=this;null===ZC._n_(e.o["max-ticks"])&&(e.M0=e.EG)},A96:function(e){var t,i,n,a,r,l,o,s=this;if(""!==s.sMaster&&2===e){var c=s.A.BL(s.sMaster);if(c)return s.B3=c.B3,s.FW=c.FW,s.BJ=c.BJ,s.H1=c.H1,s.E5=c.E5,s.SG=c.SG,s.W=c.W,s.A1=c.A1,s.DC=c.DC,s.DX=c.DX,s.V=[].concat(c.V),void(s.BX=[].concat(c.BX))}1===e&&null===ZC._n_(s.o.values)&&null!==ZC._n_(t=s.A.ABG("v"))&&(s.o.values=t);var h,C=0,u=s.JK;if(1===e&&null!==ZC._n_(s.o.values)){if(s.V=[],"object"==typeof s.o.values){var d=s.o.values,A=ZC.XY(d),p=ZC.A1L(d),g=!0;for(i=0,n=d.length-2;i<n;i++)if("number"==typeof d[i+2]&&"number"==typeof d[i+1]&&"number"==typeof d[i]&&ZC._f_(d[i+2])-ZC._f_(d[i+1])!=ZC._f_(d[i+1])-ZC._f_(d[i])){g=!1;break}if(!g&&(s.o.values=A+":"+p,!s.LR))for(s.LR=[],i=0,n=d.length;i<n;i++)s.LR.push(""+d[i])}if("object"==typeof s.o.values){for(ZC._cpa_(s.o.values,s.V),0===s.BX.length&&ZC._cpa_(s.BX,s.V),i=0,n=s.V.length;i<n;i++)if("string"==typeof s.V[i]){var Z=s.V[i],f=ZC.AV(u,s.V[i]);-1===f||s.bAllowDuplicates?(u.push(s.V[i]),s.V[i]=u.length-1):s.V[i]=f,null===ZC._n_(s.BX[i])&&(s.BX[i]=Z)}}else{var _=s.o.values.split(":");if(o=1,3===_.length&&(o=ZC._f_(_[2])),ZC._f_(_[0])>ZC._f_(_[1])){var b=_[0];_[0]=_[1],_[1]=b}if(o<=0&&(o=1),null!==ZC._n_(s.o["fixed-items"])&&(o=(ZC._f_(_[1])-ZC._f_(_[0]))/ZC.BQ(1,ZC._i_(s.o["fixed-items"])-1),s.V7=ZC.BQ(1,ZC._i_(s.o["fixed-items"])-1)),_.length>1){for(var m=0,v=0,E=0,D=(""+o).split("."),w=ZC._f_(_[0]);w<=ZC._f_(_[1]);w+=o)a=(""+w).split("."),D.length>1&&a.length>1&&D[1].length>0&&a[1].length>=9&&ZC._a_(a[1].length-D[1].length)>2?(m+=D[1].length,v=ZC.BQ(v,D[1].length),E++,s.V.push(ZC._f_(ZC._fixed_(Number(w),D[1].length)))):(m+=ZC._i_(a[1]?a[1].length:0),v=ZC.BQ(v,a[1]?a[1].length:0),E++,s.V.push(w));w-ZC._f_(_[1])!=0&&ZC._a_(w-ZC._f_(_[1]))/o<1e-8&&s.V.push(ZC._f_(_[1])),null===ZC._n_(s.o.decimals)&&(m=(a=(""+o).split("."))[1]?a[1].length:Math.ceil(m/E),s.DQ=ZC._a_(v-m)<=1?v:m)}}s.W=0,s.A1=s.V.length-1,s.E5=o,u.length>1?(C=ZC.XY(s.V,!0),s.B3=ZC.XY(s.V),s.BJ=ZC.A1L(s.V)):(s.B3=s.V[0],s.BJ=s.V[s.V.length-1]),"log"===s.C1&&(0===s.B3&&(h=Math.floor(ZC.G6(C,s.E6)),s.B3=Math.pow(s.E6,Math.min(-1,h))),s.RQ(ZC.G6(s.B3,s.E6),ZC.G6(s.BJ,s.E6),!1))}if(2===e){var x={};null===ZC._n_(s.o.values)&&(s.V=[],r=ZC.MAX,l=-ZC.MAX);var B=[],y=s.A.AY.A4;for(i=0,n=y.length;i<n;i++)if(s.A.E["plot"+i+".visible"]||"hide"===s.A.getToggleAction()){var K=y[i].BU();if(-1!==ZC.AV(K,s.BE))for(var F=-1!==ZC.AV(["vbar","hbar","vbar3d","hbar3d"],y[i].AF),M=[],z=0,I=y[i].V.length;z<I;z++)if(y[i].S[z]){var S=null===y[i].S[z].BT?z:y[i].S[z].BT;if(y[i].CC&&-1!==ZC.AV(M,S))continue;M.push(S);var G=y[i].LY&&null!==ZC._n_(y[i].LY[z])?ZC._f_(y[i].LY[z]):0;if(y[i].CC)null===ZC._n_(x[y[i].DZ])&&(x[y[i].DZ]=[]),null===ZC._n_(x[y[i].DZ][S])?y[i].S[z].AD>=0||!F?x[y[i].DZ][S]=[y[i].S[z].AD,0]:x[y[i].DZ][S]=[0,y[i].S[z].AD]:y[i].S[z].AD>=0||!F?x[y[i].DZ][S][0]+=y[i].S[z].AD:x[y[i].DZ][S][1]+=y[i].S[z].AD,y[i].S[z].AD>=0||!F?y[i].S[z].CS=x[y[i].DZ][S][0]:y[i].S[z].CS=x[y[i].DZ][S][1],null===ZC._n_(s.o.values)&&B.push(x[y[i].DZ][S][0]+G,x[y[i].DZ][S][1]+G);else if(null===ZC._n_(s.o.values)){B.push(y[i].S[z].AD+G),0!==G&&B.push(G);for(var N=0,H=y[i].S[z].DP.length;N<H;N++)B.push(y[i].S[z].DP[N]+G)}}}B.length>0&&(C=ZC.XY(B,!0),r=ZC.XY(B),l=ZC.A1L(B)),0!==s.V.length||r!==Number.MAX_VALUE&&l!==Number.MIN_VALUE||(s.V=[0,1],r=0,l=1),null===ZC._n_(s.o.values)&&(null!==ZC._n_(s.o["min-value"])&&"auto"!==s.o["min-value"]?r=ZC._f_(s.o["min-value"]):r>0&&"auto"!==s.o["min-value"]&&"log"!==s.C1&&(r=0),null!==ZC._n_(s.o["max-value"])&&(l=ZC._f_(s.o["max-value"])),r===ZC.MAX&&l===-ZC.MAX?(s.W=0,s.A1=0,s.B3=0,s.BJ=0):"log"===s.C1?(0===r&&(h=Math.floor(ZC.G6(C,s.E6)),r=Math.pow(s.E6,Math.min(-1,h))),s.RQ(ZC.G6(r,s.E6),ZC.G6(l,s.E6),!1)):s.RQ(r,l,!0))}2===e&&(-1===s.FW&&-1===s.H1&&(s.FW=s.B3,s.H1=s.BJ),-1===s.SG&&(s.SG=s.E5)),"auto"===s.o["min-value"]&&null===ZC._n_(s.o["ref-value"])&&(s.H6=s.B3),0===s.V7&&(s.V7=ZC._i_((s.BJ-s.B3)/s.E5));var k=s.H.E["graph"+s.A.L+".zoom"];if(null===ZC._n_(s.H.E.preservezoom)||s.H.E.preservezoom){var L=1===s.L?"":"-"+s.L;2===e&&void 0!==k&&null!==ZC._n_(k["ymin"+L])&&null!==ZC._n_(k["ymax"+L])&&(ZC.DS(k["ymin"+L],s.B3,s.BJ)||(k["ymin"+L]=s.B3),ZC.DS(k["ymax"+L],s.B3,s.BJ)||(k["ymax"+L]=s.BJ),s.KN=[k["ymin"+L],k["ymax"+L]])}else s.H.E["graph"+s.A.L+".zoom"]={};s.KN&&(s.A.A17=!0)},RQ:function(e,t,i){var n,a,r,l,o=this;"piano"!==o.A.AF&&!o.PZ&&o.JK.length>1&&(e=0),o.TX.length&&null===ZC._n_(o.o["scale-factor"])&&(r=Math.floor(ZC.G6(ZC._a_(t),ZC._f_(o.TX[0]))),o.OZ=Math.pow(ZC._f_(o.TX[0]),r)/Math.pow(1e3,r),o.E["max-power"]=r);var s=(l=o.FG&&"date"===o.FG.o.type?ZC.AQ.VS(e,t,"lin"===o.C1?o.E5:null,o.OZ,o.bNormalize,o.EG):ZC.AQ.VS(e,t,"lin"===o.C1?o.o.step:null,o.OZ,o.bNormalize,o.EG))[0],c=l[1],h=!1;a=Math.floor(l[0]),"log"===o.C1&&(r=Math.ceil(l[1]),l[1]-l[0]>=.5?h=!0:l=ZC.AQ.VS(Math.pow(o.E6,l[0]),Math.pow(o.E6,l[1]),null,o.OZ,o.bNormalize));var C,u,d=l[0],A=l[1],p=l[2];if(null!==ZC._n_(o.o["fixed-items"])&&(p=(A-d)/ZC.BQ(1,ZC._i_(o.o["fixed-items"])-1)),o.PZ&&t===e&&(t+p<=o.BJ?t+=p:e-=p),1!==o.R2&&(d*=o.R2,A*=o.R2,p*=o.R2),null!==ZC._n_(o.E["o-decimals"])?o.DQ=o.E["o-decimals"]:o.E["o-decimals"]=o.DQ,null===ZC._n_(o.o.decimals))if("log"===o.C1&&h)o.DQ=a<0?null:0;else if(o.bNormalize)o.A33||(o.DQ=0);else{var g=ZC.G6(t-e,10);o.DQ=l[3],o.DQ>9&&(g>=1?o.DQ=1:g>0&&g<1&&(o.DQ=2))}var Z,f,_,b=!0;if(h){var m,v;a=Math.floor(d),r=Math.ceil(A),Z=Math.pow(o.E6,e),f=Math.pow(o.E6,t),o.V=[];var E=[0,2,5];for(v=[0,1,2,3,4,5,6,7,8,9,10],n=a;n<=r;n++){var D=l[3];if(D=n<0?Math.max(ZC._a_(n),D):0,n===r)for(m=0;m<E.length;m++)_=Math.pow(o.E6,n)+E[m]*Math.pow(o.E6,n-1),_=ZC._f_(_.toFixed(D)),-1===ZC.AV(o.V,_)&&o.V.push(_);for(m=0;m<v.length;m++)_=v[m]*Math.pow(o.E6,n),_=ZC._f_(_.toFixed(D)),-1===ZC.AV(o.V,_)&&o.V.push(_)}o.V.sort(function(e,t){return e-t});for(var w=-1,x=-1,B=0;B<o.V.length-1;B++)o.V[B]<=Z&&Z<=o.V[B+1]&&(w=B),o.V[B]===f?x=B:o.V[B]<=f&&f<=o.V[B+1]&&(x=B+1);o.V=o.V.slice(w,x+1),0===o.V[0]&&o.V.shift(),s=ZC.G6(o.V[0],o.E6),c=ZC.G6(o.V[o.V.length-1],o.E6)}else{for("log"===o.C1&&(Z=Math.pow(o.E6,e),f=Math.pow(o.E6,t));b;){b=!1,o.V=[],C=u=d;do{u=C,u=ZC._f_(u.toFixed(o.DQ)),-1!==ZC.AV(o.V,u)&&(b=!0),"log"===o.C1?u>=d&&u<=A&&o.V.push(u):o.V.push(u),C+=p,C=ZC._f_(C.toFixed(l[3]))}while(C<=A);b&&(o.DQ+=1)}"log"===o.C1&&(s=ZC.G6(d,o.E6),c=ZC.G6(A,o.E6),o.V.push(d),o.V.push(A),o.V.sort(function(e,t){return e-t}))}o.E5=p,o.W=0,o.A1=o.V.length-1,i?(o.B3=o.bExtendMinValue?s:e,o.BJ=o.bExtendMaxValue?c:t):(o.B3=e,o.BJ=t)},parse:function(){var e=this;e.assign_a([["stack-type","KQ"],["CA-min-value","bExtendMinValue","b"],["CA-max-value","bExtendMaxValue","b"]]),(e.A.CC&&"100%"===e.A.KQ||"100%"===e.KQ)&&null===ZC._n_(e.o.values)&&(e.o.values="0:100:20",e.o.format="%v%"),this.b()},clear:function(){this.b()},build:function(){this.b()},paint:function(){this.b(),null===ZC._n_(this.E.decimals)&&(this.E.decimals=null!==ZC._n_(this.DQ)?this.DQ:-1),null!==ZC._n_(this.o.values)&&(this.T9=!0)}};ZC.VQ=ZC.F3.CA(VQ);}
