<!doctype html>
<html class="no-js" lang="zxx">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Climate Shakti - Dashboard</title>
    <meta name="robots" content="noindex, follow" />
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="img/favicon.png" type="image/x-icon" />
    <link rel="stylesheet" href="css/font-icons.css">
    <link rel="stylesheet" href="css/plugins.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
    <style>
  .zc-body { background:#f9f9f9; }

.chart--container {
  height: 100%;
  width: 100%;
  min-height: 650px;
}

.zc-ref {
  display: none;
}
  </style>
</head>

<body>
    <!--[if lte IE 9]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
    <![endif]-->

    <!-- Add your site or application content here -->

<!-- Body main wrapper start -->
<div class="body-wrapper">

   <?php include('include/header.php');?>

   


    <div class="ltn__utilize-overlay"></div>

    <!-- BREADCRUMB AREA START -->
    <div class="ltn__breadcrumb-area text-left bg-overlay-black-80 bg-image "  data-bs-bg="img/bg/breadcumb-bg.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ltn__breadcrumb-inner">
                        <h1 class="page-title">Dashboard</h1>
                        <div class="ltn__breadcrumb-list">
                            <ul>
                                <li><a href="index.php"><span class="ltn__secondary-color"><i class="fas fa-home"></i></span> Home</a></li>
                                <li>Dashboard</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- BREADCRUMB AREA END -->

    <!-- ABOUT US AREA START -->
    <div class="ltn__about-us-area pt-120--- pb-90 mt--30">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    
                    <div class="section-title-area mb-20">
                        <h2 class="section-title">Sectors</h2>
                        
                    </div>
                   
                </div>
                <div class="col-md-6 zc-body">
                <script src="zingchart.min.js"></script>
                	 <div id="myChart" class="chart--container">
      <a href="https://www.zingchart.com/" rel="noopener" class="zc-ref">Powered by ZingChart</a>
    </div>
    <script>
var bgColorMain = '#FFF';
var aYears = [2007,2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021];
var aColors = ['#3CC1CF','#FBAE44','#485463','#EF413C','#999999','#4C4C4C'];

var aGender = ['Men','Women'];
var aAge = ['18-24','25-34','35-44','45-54','55-64','65+'];
var aRegion = ['Northeast','Midwest','South','West'];

// g2 ////////////////////////////////
var aSeries2_a = [48.48,59.06,64.82,66.54,56.31,66.28,72.31,79.82,75.03,77.52,74.34,82.93,86.13,86.79,86.27];
var aSeries2_b = [3.3,5.0,5.1,5.8,4.8,5.8,6.9,8.0,7.0,7.4,6.9,8.4,9.1,9.0,8.8];

var aTooltip2 = ['Per person expected Halloween spending','Total expected Halloween spending(in billions)'];
//////////////////////////////////////

// g3 /////////////////////////////////
var aSeries3_a = [
	[53,60,61,62,59,62,65,66,65,67,64,67,69,68,67],
	[95,96,95,96,94,96,96,96,96,95,94,94,95,95,95]
];

var aSeries3_b = [
	[16.98,21.57,23.33,24.17,20.75,23.37,26.52,28.65,27.85,29.26,27.33,31.03,31.73,31.26,31.05],
	[17.09,18.72,19.84,20.39,17.99,20.29,21.05,23.27,22.37,23.39,23.10,24.43,25.27,25.47,25.37],
	[12.35,15.63,17.73,18.25,14.54,18.66,19.79,23.56,20.99,21.20,20.34,23.62,25.24,26.21,26.03],
	[2.06,3.14,3.92,3.73,3.02,3.95,4.96,4.34,3.82,3.67,3.57,3.84,3.88,3.85,3.82]
];

var aSeries3_c = [
	[1.2,1.8,1.8,2.1,1.8,2.0,2.5,2.9,2.6,2.8,2.5,3.1,3.4,3.2,3.2],
	[1.2,1.6,1.6,1.8,1.5,1.8,2.0,2.3,2.1,2.2,2.1,2.5,2.7,2.6,2.6],
	[0.8,1.3,1.4,1.6,1.2,1.6,1.9,2.4,2.0,2.0,1.9,2.4,2.7,2.7,2.7],
	[0.1,0.3,0.3,0.3,0.3,0.4,0.5,0.6,0.4,0.4,0.3,0.4,0.4,0.4,0.39]
];

var aTooltip3 = ['Costumes','Candy','Decorations','Greeting Cards'];
//////////////////////////////////////

// g4 ////////////////////////////////
let bgColor = 'none';
// gender
var aData4_a = [
	['67%','$96.13'],
	['69%','$76.92']
];
var aSeries4_a = [
	[[2,0,32], [2,1,33]],
	[[5,0,33], [5,1,31]]
];

// age
var aData4_b = [
	['88%','$88.23'],
	['84%','$109.11'],
	['78%','$115.53'],
	['66%','$91.30'],
	['54%','$74.19'],
	['45%','$47.01']
];
var aSeries4_b = [
	[[1,0,30], [1,1,31]],
	[[2,0,32], [2,1,32]],
	[[3,0,32], [3,1,34]],
	[[4,0,30], [4,1,30]],
	[[5,0,26], [5,1,26]],
	[[6,0,26], [6,1,26]]
];

// region
var aData4_c = [
	['70%','$92.78'],
	['69%','77.57$'],
	['67%','$89.84'],
	['67%','$83.16']
];
var aSeries4_c = [
	[[1,0,30], [1,1,31]],
	[[2,0,32], [2,1,32]],
	[[3,0,32], [3,1,34]],
	[[4,0,30], [4,1,30]]
];
//////////////////////////////////////

// g5 ////////////////////////////////
var aTooltip5 = ['Costumes (including children<br>and pets)','Candy','Decorations','Greeting cards'];

var aSeries5_a = [
	[68,96,73,35],
	[66,93,71,33]
];

var aSeries5_b = [
	[87,92,77,32],
	[88,93,80,40],
	[87,95,79,40],
	[68,96,73,31],
	[51,96,70,31],
	[32,94,57,31]
];

var aSeries5_c = [
	[68,95,75,40],
	[62,95,67,32],
	[69,95,73,34],
	[67,93,71,31]
];
//////////////////////////////////////

// g6 ////////////////////////////////
var aTooltip6 = ['Dress<br>in costume','Dress your<br>pet(s) in costume','Throw/attend<br>a party','Hand out<br>candy','Carve a<br>pumpkin','Visit a<br>haunted house','Take children<br>trick-or-treating','Decorate your<br>home/yard','Other<br>(please specify)'];

var aSeries6_a = [
	[47,15,36,68,41,22,27,41,3],
	[47,19,28,69,48,22,30,56,3]
];

var aSeries6_b = [
	[73,26,53,56,53,40,26,45,2],
	[68,27,42,60,54,34,41,50,2],
	[56,22,34,65,50,29,47,47,2],
	[44,16,29,72,46,20,29,52,3],
	[34,12,24,77,40,14,20,53,3],
	[19,4,16,78,29,5,12,45,6]
];

var aSeries6_c = [
	[48,18,33,69,41,22,26,50,3],
	[45,15,31,69,47,22,30,50,4],
	[46,18,30,69,43,24,30,47,2],
	[50,17,33,67,47,21,28,48,4]
];
//////////////////////////////////////

// g7 ////////////////////////////////
var aTooltip7 = ['Before September','September','First 2 weeks of October','Last 2 weeks of October'];

var aSeries7_a = [
	[6,28,42,24],
	[6,34,42,18]
];

var aSeries7_b = [
	[4,28,50,18],
	[7,40,40,13],
	[9,37,40,13],
	[6,30,44,19],
	[6,29,43,22],
	[4,21,39,37]
];

var aSeries7_c = [
	[7,32,41,20],
	[6,34,40,21],
	[6,31,43,20],
	[6,28,43,23]
];
//////////////////////////////////////

// g9 ////////////////////////////////
var aTooltip9_a = ['Print Media','Online search','Retail store or costume shop','Friends/family','Pop culture','Current Events','Facebook','Instagram','Pinterest','Twitter','YouTube','Blogs','Habit','Other','N/A'];
var aTooltip9 = ['Print Media (magazines, catalogs, etc.)','Online Search','Within a retail store or costume shop','Friends/Family','Pop Culture (celebrities, TV shows, movies, etc.)','Current Events','Facebook','Instagram','Pinterest','Twitter','YouTube','Blogs','Habit/Wear the same costume each year','Other','Does not apply/Will not wear costume'];

var aSeries9_a = [
	[11,35,28,20,16,7,16,14,18,6,14,3,6,3,27]
];

var aSeries9_b = [
	[12,35,27,21,18,8,19,15,12,9,19,4,6,3,26],
	[11,35,30,18,14,6,14,14,25,3,10,3,6,3,28]
];

var aSeries9_c = [
	[13,56,40,32,32,8,23,35,33,13,30,6,7,2,6],
	[14,48,35,26,25,10,25,25,28,10,21,7,6,2,9],
	[15,45,35,22,22,10,25,19,23,8,17,3,6,4,12],
	[12,33,29,18,13,8,15,9,18,3,12,2,4,3,27],
	[10,25,25,14,7,4,10,4,10,2,8,1,7,4,39],
	[7,12,13,10,3,3,5,1,5,0,2,1,8,4,58]
];
var aSeries9_d = [
	[13,35,30,20,15,8,15,14,17,7,14,4,5,3,27],
	[10,32,27,19,14,6,17,11,19,5,10,3,7,3,29],
	[12,36,29,20,17,7,19,16,19,6,16,4,6,3,26],
	[11,35,27,18,17,7,13,15,18,5,14,3,7,4,26]
];
let data = [
['Andaman and Nicobar', 9, 20, 21.5, 38.3, 14.1, 'AN'],
['Andhra Pradesh', 10, 10, 21.7, 28.1, 15.1, 'AP'],
['Arunachal Pradesh', 11, 12, 21.9, 21.5, 16.1, 'AR'],
['Assam', 12, 9, 22.1, 34.1, 17.1, 'AS'],
['Bihar', 13, 20, 22.3, 38.3, 18.1, 'BR'],
['Chandigarh', 14, 10, 22.5, 28.1, 19.1, 'CH'],
['Dadra and Nagar Haveli', 15, 12, 22.7, 21.5, 20.1, 'DN'],
['Daman and Diu', 16, 9, 22.9, 34.1, 21.1, 'DD'],
['Delhi', 17, 20, 23.1, 38.3, 22.1, 'DL'],
['Goa', 18, 10, 23.3, 28.1, 23.1, 'GA'],
['Gujarat', 19, 12, 23.5, 21.5, 24.1, 'GJ'],
['Haryana', 20, 9, 23.7, 34.1, 25.1, 'HR'],
['Himachal Pradesh', 21, 20, 23.9, 38.3, 26.1, 'HP'],
['Jammu and Kashmir', 22, 10, 24.1, 28.1, 27.1, 'JK'],
['Karnataka', 23, 12, 24.3, 21.5, 28.1, 'KA'],
['Kerala', 24, 9, 24.5, 34.1, 29.1, 'KL'],
['Madhya Pradesh', 25, 20, 24.7, 38.3, 30.1, 'MP'],
['Maharashtra', 26, 10, 24.9, 28.1, 31.1, 'MH'],
['Manipur', 27, 12, 25.1, 21.5, 32.1, 'MN'],
['Meghalaya', 28, 9, 25.3, 34.1, 33.1, 'ML'],
['Mizoram', 29, 20, 25.5, 38.3, 34.1, 'MZ'],
['Nagaland', 30, 10, 25.7, 28.1, 35.1, 'NL'],
['Orissa', 31, 12, 25.9, 21.5, 36.1, 'OR'],
['Puducherry', 32, 9, 26.1, 34.1, 37.1, 'PY'],
['Punjab', 33, 20, 26.3, 38.3, 38.1, 'PB'],
['Rajasthan', 34, 10, 26.5, 28.1, 39.1, 'RJ'],
['Sikkim', 35, 12, 26.7, 21.5, 40.1, 'SK'],
['Tamil Nadu', 36, 9, 26.9, 34.1, 41.1, 'TN'],
['Tripura', 37, 20, 27.1, 38.3, 42.1, 'TR'],
['Uttar Pradesh', 38, 10, 27.3, 28.1, 43.1, 'UP'],
['West Bengal', 39, 12, 27.5, 21.5, 44.1, 'WB'],
['Uttaranchal', 40, 20, 27.7, 38.3, 45.1, 'UT'],
['Jharkhand', 41, 10, 27.9, 28.1, 46.1, 'JH'],
['Chhattisgarh', 42, 12, 28.1, 21.5, 47.1, 'CT'],
['Telangana', 43, 9, 28.3, 34.1, 48.1, 'TL']
];

// better placement to avoid pie overlap
let oOffsets = {
  RP: [15, -15]
};

let _r_ = function (min, max) {
  return Math.round(min + (max - min) * Math.random());
};

let getNameById = function (sId) {
  let sName = 'N/A';
  for (let i = 0; i < data.length; i++) {
    if (sId === data[i][6]) {
      sName = data[i][0];
    }
  }
  return sName;
};

let oCacheDataArea = {};
let getRandomDataArea = function (sId) {
  if (oCacheDataArea[sId]) {
    return oCacheDataArea[sId];
  }
  let aValues = [
    [],
    [],
    [],
    [],
	[]
  ];
  for (let i = 0; i < data.length; i++) {
    let v0 = _r_(5, 15);
    let v1 = _r_(25, 35);
    let v3 = _r_(5, 10);
	let v4 = _r_(7, 15);
    let v2 = 100 - v0 - v1 - v3 - v4;
    aValues[0].push(v0);
    aValues[1].push(v1);
    aValues[2].push(v2);
    aValues[3].push(v3);
	aValues[4].push(v4);
  }
  oCacheDataArea[sId] = aValues;
  return aValues;
};

let oCacheDataPop = {};
let getRandomDataPop = function (sId) {
  if (oCacheDataPop[sId]) {
    return oCacheDataPop[sId];
  }
  let aValues = [];
  let iPop = ZC._r_(2000000, 8000000);
  for (let i = 0; i < data.length; i++) {
    aValues.push(iPop);
    iPop += _r_(-20000, 20000);
  }
  oCacheDataPop[sId] = [aValues];
  return [aValues];
};


let updateAreaPopCharts = function (sId) {
  zingchart.exec('myChart', 'setdata', {
    graphid: 'gmap',
    data: getMapData(sId),
    update: false
  });
  zingchart.exec('myChart', 'modify', {
    graphid: 'histarea',
    data: {
      subtitle: {
        text: getNameById(sId)
      }
    },
    update: false
  });
  zingchart.exec('myChart', 'modify', {
    graphid: 'histpop',
    data: {
      subtitle: {
        text: getNameById(sId)
      }
    },
    update: false
  });
  zingchart.exec('myChart', 'setseriesvalues', {
    graphid: 'histarea',
    values: getRandomDataArea(sId),
    update: false
  });
  zingchart.exec('myChart', 'setseriesvalues', {
    graphid: 'histpop',
    values: getRandomDataPop(sId),
    update: false
  });
  zingchart.exec('myChart', 'update');
}

zingchart.bind('myChart', 'node_click', function (p) {
  if (p.graphid.indexOf('zc-graph-pie') === 0) {
    updateAreaPopCharts(p.graphid.replace('zc-graph-pie', ''));
  }
});
zingchart.bind('myChart', 'shape_click', function (p) {
  if (p.shape.mapItem) {
    updateAreaPopCharts(p.shape.id);
  }
});

let addPieGraphs = function () {
  for (let i = 0; i < data.length; i++) {
    let info = data[i];
    let xy = zingchart.maps.getXY('mapind', [info[1], info[2]]);
    let oGraph = {
      id: 'pie' + info[6],
      type: 'pie',
      x: xy[0] - 80 + (oOffsets[info[6]] ? oOffsets[info[6]][0] : 0),
      y: xy[1] - 25 + (oOffsets[info[6]] ? oOffsets[info[6]][1] : 0),
      width: '160px',
      height: '50px',
      backgroundColor: 'none',
      plotarea: {
        margin: '2px'
      },
      plot: {
        detach: false,
        alpha: 0.75,
        borderWidth: '0px',
        valueBox: {
          visible: false
        }
      },
      title: {
        fontSize: '10px',
        offsetY: '40px',
        fontWeight: 'bold',
        text: info[0]
      },
      tooltip: {
        padding: '10px',
        fontSize: '13px',
        fontWeight: 'bold',
        text: '%node-value% in %plot-text'
      },
      series: [{
        text: 'Settlement Area',
        values: [info[5]],
        backgroundColor: '#d15c5c'
      },
      {
        text: 'Forest Area',
        values: [info[4]],
        backgroundColor: '#56b556'
      },
      {
        text: 'Agriculture',
        values: [info[3]],
        backgroundColor: '#e5e510'
      },
      {
        text: 'Other',
        values: [Number((100 - info[3] - info[4] - info[5]).toFixed(1))],
        backgroundColor: '#999'
      }
      ]
    };
    zingchart.exec('myChart', 'addgraph', {
      data: oGraph,
      update: false
    });
  }
  zingchart.exec('myChart', 'update');
}

var getMapData = function (sId) {
  let oGraphMainMap = {
    backgroundColor: 'none',
    x: '0px',
    y: '0px',
    width: '800px',
    height: '600px',
    type: 'null',
    id: 'gmap',
    title: {
      align: 'left',
      fontSize: '15px',
      paddingLeft: '20px',
      text: 'Geographical Data'
    },
    source: {
      text: '(*) random data',
      offsetX: '-50px'
    },
    shapes: [{
      type: 'zingchart.maps',
      options: {
        x: '0px',
        y: '20px',
        width: '480px',
        height: '580px',
        id: 'mapdeu',
        name: 'ind',
        zooming: false,
        panning: false,
        scrolling: false,
        scale: true,
        style: {
          controls: {
            visible: false
          },
          label: {
            visible: false
          },
          backgroundColor: '#f9f9f9',
          borderColor: '#666',
          hoverState: {
            visible: false
          },
          items: {KA: {
              tooltip: {
                text: 'Karnataka has 2,851 monthly users total',
                backgroundColor: '#ff5722'
              },
              backgroundColor: '#ff5722',
              label: {
                visible: true
              }
            },
            MH: {
              tooltip: {
                text: 'Maharashtra has 2,683 monthly users total',
                backgroundColor: '#ff9800'
              },
              backgroundColor: '#ff9800',
              label: {
                visible: true
              }
            },
            TL: {
              tooltip: {
                text: 'Telangana has 1,494 monthly users total',
                backgroundColor: '#00AE4D'
              },
              backgroundColor: '#00AE4D',
              label: {
                visible: true
              }
            },
            GJ: {
              tooltip: {
                text: 'Gujarat has 1,494 monthly users total',
                backgroundColor: '#00bcd4'
              },
              backgroundColor: '#00bcd4',
              label: {
                visible: true
              }
            }}
        }
      }
    },{
      type: 'circle',
      id: '1950',
      backgroundColor: '#163D6B',
      borderColor: '#a5a5a5',
      borderWidth: '1px',
      cursor: 'pointer',
      label: {
        text: 'Vulnerability',
        fontColor: '#666666',
        fontFamily: 'arial',
        offsetX: '50px',
		fontWeight : 'bold',
      },
      size: '10px',
      x: '280px',
      y: '100px'
    },
    {
      type: 'circle',
      id: '1990',
      backgroundColor: '#4E6C90',
      borderColor: '#a5a5a5',
      borderWidth: '1px',
      cursor: 'pointer',
      label: {
        text: 'GHG Emission (Per Capita)',
        fontColor: '#666666',
        fontFamily: 'arial',
		margin:'50',
        offsetX: '88px',
		fontWeight : 'bold',
      },
      size: '10px',
      x: '280px',
      y: '130px'
    }]
  };
  oGraphMainMap.shapes[0].options.style.items[sId] = {
    backgroundColor: '#eeeeee #c2edc3'
  };
  return oGraphMainMap;
};

let aAreaValues = getRandomDataArea(data[0][6]);
let oGraphHistoryArea = {
  id: 'histarea',
  backgroundColor: 'none',
  x: '480px',
  y: '0px',
  width: '400px',
  height: '250px',
  type: 'bar',
  stacked: true,
  title: {
    fontSize: '14px',
    text: 'Sectoral Contribution to GHG Emission(2005-2015)'
  },
  subtitle: {
    fontSize: '12px',
    offsetY: '-5px',
    text: getNameById(data[0][6])
  },
  source: {
    text: '(*) random data'
  },
  plotarea: {
    margin: '55 5 35 35'
  },
  scaleX: {
    values: '2005:2015:1',
    maxItems: 99,
    itemsOverlap: true,
    item: {
      fontSize: '9px'
    }
  },
  tooltip: {
    text: '%plot-text in %scale-key-text: %node-value%'
  },
  scaleY: {
    format: '%v%',
    item: {
      fontSize: '10px'
    }
  },
  plot: {
    alpha: 0.75,
    animation: {
      speed: 200,
      effect: 'ANIMATION_FADE_IN',
      method: 'ANIMATION_LINEAR',
      sequence: 'ANIMATION_BY_NODE'
    }
  },
  series: [{
    backgroundColor: '#CCCCC3',
    values: aAreaValues[0],
    text: 'Climage Policy'
  },
  {
    backgroundColor: '#56b556',
    values: aAreaValues[1],
    text: 'Clean Power'
  },
  {
    backgroundColor: '#e5e510',
    values: aAreaValues[2],
    text: 'Energy Efficiency'
  },
  {
    backgroundColor: '#999',
    values: aAreaValues[3],
    text: 'Electric Mobility'
  },
  {
    backgroundColor: '#f64e60',
    values: aAreaValues[4],
    text: 'Transport'
  }
  ]
};

let aPopValues = getRandomDataPop(data[0][6]);

let oGraphHistoryPop = {
  id: 'histpop',
  backgroundColor: 'none',
  x: '480px',
  y: '250px',
  width: '400px',
  height: '300px',
  type: 'line',
  title: {
    fontSize: '14px',
    text: 'Growth of GDP Vs. GHG'
  },
  subtitle: {
    fontSize: '12px',
    offsetY: '-5px',
    text: getNameById(data[0][6])
  },
  source: {
    text: '(*) random data'
  },
  plotarea: {
    margin: '55 5 35 35'
  },
  tooltip: {
    short: true,
    decimals: 4,
    text: 'Population in %scale-key-text: %node-value'
  },
  scaleX: {
    values: '2005:2012:1',
    maxItems: 99,
    itemsOverlap: true,
    item: {
      fontSize: '9px'
    }
  },
  scaleY: {
    minValue: 'auto',
    short: true,
    decimals: 2,
    item: {
      fontSize: '10px'
    }
  },
  plot: {
    alpha: 0.75,
    animation: {
      speed: 200,
      effect: 'ANIMATION_FADE_IN',
      method: 'ANIMATION_LINEAR',
      sequence: 'ANIMATION_BY_NODE'
    }
  },
  series: [{
    lineColor: '#333',
    backgroundColor: '#333 #fff',
    marker: {
      type: 'circle',
      backgroundColor: '#666'
    },
    values: aPopValues[0]
  }]
};

let g9 = {
  type: 'ring',
  backgroundColor: bgColor,
  x: '900px',
  y: '250px',
  width: '300px',
  height: '300px',

  title: {
    fontSize: '14px',
    text: 'Sectors'
  },
  subtitle: {
    fontSize: '12px',
    offsetY: '-5px',
    text: getNameById(data[0][6])
  },
  scale: {
    sizeFactor: 0.75
  },
  'scaleR': {
    refAngle: 270
  },

  plot: {
    'borderWidth': 0
  },

  tooltip: {
    text: '%node-value%'
  },
  series: [{
      values: [37],
      'backgroundColor': '#FFDA00',
      'valueBox': [{
          text: '%node-value%',
          decimals: 0,
          fontColor: '#000',
          fontWeight: 'normal',
          fontSize: 11,
          placement: 'out',
          offsetR: -15
        },
        {
          text: 'Climage Policy',
          fontColor: '#004280',
          'fontSize': 10,
          placement: 'fixed=50%;'
        }
      ]
    },
    {
      values: [28],
      'backgroundColor': '#FFA300',
      'valueBox': [{
          text: '%node-value%',
          decimals: 0,
          'fontColor': '#000',
          'fontWeight': 'normal',
          fontSize: 11,
          placement: 'out',
          offsetR: -10
        },
        {
          text: 'Clean Power',
          fontColor: '#004280',
          fontSize: 10,
          placement: 'fixed=50%;'
        }
      ]
    },
    {
      values: [18],
      'backgroundColor': '#00BCF2',
      'valueBox': [{
          text: '%node-value%',
          decimals: 0,
          'fontColor': '#000',
          fontWeight: 'normal',
          'fontSize': 11,
          placement: 'out',
          'offsetR': -19
        },
        {
          text: 'Energy Efficiency',
          'fontColor': '#004280',
          'fontSize': 10,
          placement: 'fixed=50%;'
        }
      ]
    },
    {
      values: [17],
      'backgroundColor': '#7DAB4B',
      'valueBox': [{
          text: '%node-value%',
          decimals: 0,
          fontColor: '#000',
          fontWeight: 'normal',
          'fontSize': 11,
          placement: 'out',
          offsetR: -10
        },
        {
          text: 'Electric Mobility',
          fontColor: '#004280',
          'fontSize': 10,
          placement: 'fixed=50%;'
        }
      ]
    }
  ]
};
let oRingLegend = {
  id: 'ringlegend',
  type: 'ring',
  x: '900px',
  y: '250px',
  width: '300px',
  height: '260px',
  backgroundColor: 'none',
  plotarea: {
    margin: '50px'
  },
  title: {
    fontSize: '14px',
    text: 'Sectors'
  },
  subtitle: {
    fontSize: '12px',
    offsetY: '-5px',
    text: getNameById(data[0][6])
  },
  scale: {
    sizeFactor: 0.75
  },
  'scaleR': {
    refAngle: 270
  },

  plot: {
    'borderWidth': 0
  },
  tooltip: {
    text: '%plot-value%'
  },
  plot: {
    flat: true,
    maxTrackers: 0,
    detach: false,
    alpha: 0.6,
    borderWidth: '0px',
    valueBox: {
      placement: 'out',
      offsetR: -25,
      align: 'left',
      text: '%plot-text',
      fontSize: '10px',
      fontWeight: 'bold',
      color: '#333',
      connector: {
        visible: false
      }
    }
  },
  tooltip: {
    visible: false
  },
  scale: {
    sizeFactor: 0.8
  },
  series: [{
    text: 'Climage Policy',
    values: [1],
	placement: 'out',
    backgroundColor: '#d15c5c'
  },
  {
    text: 'Clean Power',
    values: [1],
	placement: 'out',
    backgroundColor: '#56b556'
  },
  {
    text: 'Energy Efficiency',
    values: [1],
	placement: 'out',
    backgroundColor: '#e5e510'
  },
  {
    text: 'Electric Mobility',
    values: [1],
	placement: 'out',
    backgroundColor: '#999'
  }
  ,
  {
    text: 'Transport',
    values: [1],
	placement: 'out',
    backgroundColor: '#f64e60'
  }
  ]
};

let oGraphLegend = {
  id: 'pielegend',
  type: 'hbar',
  x: '1000px',
  y: '0px',
  width: '300px',
  height: '280px',
  backgroundColor: 'none',
  plotarea: {
    margin: '50px'
  },
  title: {
    fontSize: '14px',
    text: 'Sectors',
	offsetX: '-100px'
  },
  subtitle: {
    fontSize: '12px',
    offsetY: '-5px',
	offsetX: '-100px',
    text: getNameById(data[0][6])
  },
  plot: {
    'barWidth': '70%',
    valueBox: {
      text: '%node-value%',
      fontSize: 10,
      fontWeight: 'normal',
      color: '#000',
    }
  },
  tooltip: {
    text: '%node-value%'
  },
  scaleX: {
    values: ['Climage Policy','Clean Power','Energy Efficiency','Electric Mobility','Transport'],
    lineWidth: 0,
    itemsOverlap: true,
    item: {
      'fontColor': '#000',
      'textAlign': 'center',
      'fontWeight': 'normal',
      'fontSize': 10,
      'offsetX': -5
    },
    tick: {
      visible: false
    },
    guide: {
      visible: false
    }

  },
  scaleY: {
    minValue: 0,
    maxValue: 25,
    'lineWidth': 0,
    item: {
      visible: false
    },
    guide: {
      visible: false
    },
    tick: {
      visible: false
    }
  },

  series: [{
    values: [1, 2, 3, 4, 5],
    backgroundColor: ['#d15c5c']
  }]
};

// New

// New1
var g3 = {

	x : 900,
	y : 0,
	width : '400',
	height : '450',
	type : 'line',
	plotarea : {
		margin : '130 50 40 40'
	},
	backgroundColor : 'none',
 
	title : {
		offsetY : 5,
		text : 'Historical: Purchasing plans',
		width : '100%',
		align : 'center',
		fontColor : '#FBAE44',
		fontWeight : 'bold',
		fontSize : '14px',
		padding : 5
	},

	subtitle : {
		flat : true,
		text : 'Historical Halloween spending and celebration plans (2007 - 2021)',
		align : 'left',
		fontColor : '#464646',
		fontWeight : 'normal',
		fontStyle : 'italic',
		fontSize: '12px',
        offsetY: '-5px',
	},

	labels : [
		{
			x : 500,
			y : 45,
			width : '100%',
			borderBottom : '1px solid #EDEDED'
		}
	],

	plot : {
		aspect : 'spline',
		marker : {
			type : 'circle',
			borderWidth : 0,
			size : 4
		},
		hoverMarker : {
			type : 'circle',
			size : 5,
			backgroundColor : '#FFF',
			borderWidth : 1
		},
		valueBox : {
			text : '%node-value%',
			fontColor : '#464646',
			fontWeight : 'normal',
			fontSize : 10
		},
		animation : {
			effect : 1,
			sequence : 2,
			speed : 100
		}
	},

	tooltip : {
		backgroundColor : '#000',
		align : 'center',
		alpha : 0.75,
		borderWidth : 0,
		fontColor : '#fff',
		fontSize : 11,
		fontWeight : 'normal',
		borderRadius : 4,
		callout : true,
		padding : '5 10 10 5'
	},

	legend : {
		layout : '1x',
		backgroundColor : 'none',
		margin : '460 auto 0 auto',
		borderWidth : 0,
		marker : {
			type : 'circle',
			size : 8,
			borderWidth : 0,
		},
		item : {
			fontSize : 10,
			fontWeight : 'normal',
			color : '#464646'
		}
	},

	scaleX : {
		values : aYears,
		itemsOverlap : true,
		lineWidth : 0,
		item : {
			fontColor : '#464646',
			fontSize : 11,
			offsetY : -40
		},
		guide : {
			visible : false
		},
		tick : {
			visible : false
		}
	},

	scaleY : {
		minValue : 'auto',
		offsetStart : 45,
		offsetEnd : 5,
		lineWidth : 0,
		item : {
			visible : false
		},
		guide : {
			visible : false
		},
		tick : {
			visible : false
		}
	},

	series: [
		{
			values : aSeries3_a[0],
			lineColor : '#3CC1CF',
			lineWidth : 2,
			text : aTooltip3[0],
			tooltip : {
				text : '<span style="font-size:16px;color:#3CC1CF;">\u25CF</span><b>Costumes</b><br> %scale-key-value: %node-value%'
			},
			marker : {
				backgroundColor : '#3CC1CF'
			},
			hoverMarker : {
				borderColor : '#3CC1CF'
			}
		},
		{
			values : aSeries3_a[1],
			lineColor : '#FBAE44',
			lineWidth : 2,
			text : aTooltip3[1],
			tooltip : {
				text : '<span style="font-size:16px;color:#FBAE44;">\u25CF</span><b>Candy</b><br> %scale-key-value: %node-value%'
			},
			marker : {
				backgroundColor : '#FBAE44'
			},
			hoverMarker : {
				borderColor : '#FBAE44'
			}
		}
	]

};

let chartConfig = {
  flat: true,
  backgroundColor: '#f3f3f3 #e3e3e3',
  borderColor: '#999',
  borderWidth: '1px',
  graphset: [
    getMapData(data[0][6]),
    oGraphHistoryArea,
    oGraphHistoryPop,
    oGraphLegend,
	g9
  ]
};

let bInit = true;
zingchart.bind('myChart', 'load', function () {
  if (bInit) {
    bInit = false;
    addPieGraphs();
  }
});



zingchart.DEV.MAPSONBOTTOM = 1;
// renders chart
zingchart.loadModules('maps, maps-ind', function (e) {
  zingchart.render({
    id: 'myChart',
    data: chartConfig,
    height: '100%',
    width: '100%'
  });
});


	</script>
                </div>
            </div>
        </div>
    </div>
    <!-- ABOUT US AREA END -->

    

    

   

    

   <?php include('include/footer.php');?>

</div>
<script src="js/plugins.js"></script>
<script src="js/main.js"></script>

</body>
</html>

