<style>
  #containergraph {
  height: 400px;
}
</style>




<script>
   var corr = 1,
        pre = [];
	var colors = Highcharts.getOptions().colors.slice(0),
    		dark = -0.5;
    
    
    colors[1] = "#ccc";
    colors[2] = "#ccc";
    colors[3] = "#000";
Highcharts.chart('containergraph', {
  chart: {
    type: 'column'
  },
  colors: colors,
  title: {
    text: 'Stacked column chart'
  },
  xAxis: {
    categories: ['Apples', 'Oranges', 'Pears', 'Grapes', 'Bananas']
  },
  yAxis: {
    min: 0,
    title: {
      text: 'Total fruit consumption'
    }
  },
  tooltip: {
    pointFormat: '<span style="color:{series.color}">{series.name}</span>: <b>{point.y}</b> ({point.percentage:.0f}%)<br/>',
    shared: true
  },
   plotOptions: {
            series: {
                stacking: 'percent',
                dataLabels: {
                    enabled: true,
                    style: {
                        color: 'black'
                    },
                    formatter: function () {
                        var ret = '',
                            i = 0,
                            j = 0,
                            serNo = this.series._i;

                        if (serNo == 0) {
                            corr = this.total - this.y + 1;
                            pre[this.x] = this.y;
                        } else if (serNo == 1) {
                            corr = this.total - pre[this.x] - this.y + 1;
                        } else {
                            corr = 1;
                        }

                      

                        return ret + this.percentage.toFixed(0) + '%';
                    }
                }
            }
        },
  
  series: [{
    name: 'John',
    data: [5, 3, 4, 7, 2]
  }, {
    name: 'Jane',
    data: [2, 2, 3, 2, 1]
  }, {
    name: 'Joe',
    data: [3, 4, 4, 2, 5]
  }]
});
</script>