<?php include 'include/config.php' ?>
<?php include('include/function.php');?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
	<meta charset="utf-8">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
	<title>India Climate Action Tracker - About the Data</title>
	<meta name="robots" content="noindex, follow" />
	<meta name="description" content="">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<link rel="shortcut icon" href="img/favicon.png" type="image/x-icon" />
	<link rel="stylesheet" href="css/font-icons.css">
	<link rel="stylesheet" href="css/plugins.css">
	<link rel="stylesheet" href="css/style.css">
	<link href="css/lightgallery.css" rel="stylesheet">
	<link rel="stylesheet" href="css/responsive.css">

<style>
a.one:link {color:#ff0000;}
a.one:visited {color:#0000ff;}
a.one:hover {color:#ffcc00;}
</style>

</head>

<body>
	<!--[if lte IE 9]>

        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
    <![endif]-->
	<!-- Add your site or application content here -->
	<!-- Body main wrapper start -->
	<div class="body-wrapper">
		<?php include('include/header.php');?>
		<div class="ltn__utilize-overlay"></div>
			<div class="ltn__breadcrumb-area text-left bg-overlay-black-80 bg-image " data-bs-bg="img/bg/breadcumb-bg.jpg">
				<div class="container">
					<div class="row">
						<div class="col-lg-12">
							<div class="ltn__breadcrumb-inner">
								<h4 class="page-title">About the Data</h4>
								<div class="ltn__breadcrumb-list">
									<ul>
										<li><a href="index.php"><span class="ltn__secondary-color"><i
														class="fas fa-home"></i></span> Home</a></li>
										<li>About the Data</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		<!-- Main Body Content Start -->

		<div class="container">
			<div class="text-justify">
				<p>All the data and information on this Website is compiled and collated from various government sources
					at national and state levels and includes data from sources such  as like Reserve bank of India (RBI),
					Department of Science and technology (DST), Central Electricity Authority, Ministry of New and
					Renewable Energy (MNRE), GHG platform India etc. Further, the data was largely taken from publicly
					available information such as publications of various government institutions and departments or
					from their websites. </p>
				<p>However, in few cases data has been derived or calculated using  different  methodologies. These have been
					 explained in the methodology section of the glossary and in the disclaimers wherever this
					data has been showcased along with the assumption and formulae. Further, data on socio economic
					indicators like population, income, GDP, NSDP etc are sourced from institutions such as Reserve Bank
					of India and MOSPI. The data on climate indicators like Forest area, GHG emissions, annual rainfall,
					vulnerability are sources from GHG platform India, Forest survey of India, NITI Aayog, Department of
					Science and Technology India, Central electricity authority and MNRE. Similarly, data on funding are
					sources from Shakti Sustainable Energy Foundation (Shakti) database, FCRA online, OECD database and CSR India.</p>
				<p>More details on the methodology and the sources can be accessed from the following sections:</p>
			</div>
			<div class="accordion" id="accordion_about">
				<div class="accordion-item">
					<h2 class="accordion-header" id="glossary_heading">
						<button class="accordion-button" type="button" data-bs-toggle="collapse"
							data-bs-target="#glossary" aria-expanded="true" aria-controls="collapseOne">
							<h4>Glossary</h4>
						</button>
					</h2>
					<div id="glossary" class="accordion-collapse collapse show" aria-labelledby="glossary_heading"
						data-bs-parent="#accordion_about">
						<div class="accordion-body">
							<div class="accordion" id="accordion_glossary">
								<div class="accordion-item">
									<h2 class="accordion-header" id="Homepage_heading">
										<button class="accordion-button" type="button" data-bs-toggle="collapse"
											data-bs-target="#Homepage" aria-expanded="true" aria-controls="collapseOne">
											<h4>Homepage and Dashboard</h4>
										</button>
									</h2>
									<div id="Homepage" class="accordion-collapse collapse"
										aria-labelledby="Homepage_heading" data-bs-parent="#accordion_glossary">
										<div class="accordion-body">
											<div class="text-left">
												<ol>
													<li>
														<strong>AFOLU:</strong>
														<p>Agriculture, Forestry and Other Land Use</p>
													</li>
													<li>
														<strong>CEA:</strong>
														<p>Central Electricity Authority</p>
													</li>
													<li>
														<strong>CFLs:</strong>
														<p>Compact Fluorescent Lamps</p>
													</li>
													<li>
														<strong>CSO:</strong>
														<p>Civil society organizations</p>
													</li>
													<li>
														<strong>DCs:</strong>
														<p>Designated Consumers</p>
													</li>
													<li>
														<strong>EEFP: </strong>
														<p>Energy Efficiency Financing Platform</p>
													</li>
													<li>
														<strong>ESCerts:</strong>
														<p>Energy Saving Certificates</p>
													</li>
													<li>
														<strong>FCRA:</strong>
														<p>Foreign Contribution (Regulation) Act</p>
													</li>
													<li>
														<strong>FCRA:</strong>
														<p>The Foreign Contribution Act, 2010</p>
													</li>
													<li>
														<strong>FEEED:</strong>
														<p>Framework for Energy Efficient Economic Development</p>
													</li>
													<li>
														<strong>FSI:</strong>
														<p>Forest survey of India</p>
													</li>
													<li>
														<strong>GDP:</strong>
														<p>Gross Domestic Product</p>
													</li>
													<li>
														<strong>GHS:</strong>
														<p>Greenhouse Gas</p>
													</li>
													<li>
														<strong>GSDP:</strong>
														<p>Gross State Domestic Product</p>
													</li>
													<li>
														<strong>IEX:</strong>
														<p>Indian Energy Exchange</p>
													</li>
													<li>
														<strong>INR:</strong>
														<p>Indian Rupee</p>
													</li>
													<li>
														<strong>IPCC:</strong>
														<p>Intergovernmental Panel on Climate Change</p>
													</li>
													<li>
														<strong>IPPU: </strong>
														<p>Industrial Processes and Product Use</p>
													</li>
													<li>
														<strong>JPEG:</strong>
														<p>Joint Photographic Experts Group</p>
													</li>
													<li>
														<strong>M:</strong>
														<p>Million</p>
													</li>
													<li>
														<strong>Mm:</strong>
														<p>Millimeter</p>
													</li>
													<li>
														<strong>Millimeter NAPCC: </strong>
														<p>The National Action Plan on Climate Change</p>
													</li>
													<li>
														<strong>NGO:</strong>
														<p>Non-governmental Organization</p>
													</li>
													<li>
														<strong>NMEEE:</strong>
														<p>National Mission for Enhanced Energy Efficiency</p>
													</li>
													<li>
														<strong>NSDP: </strong>
														<p>Net State Domestic Product</p>
													</li>
													<li>
														<strong>NSV: </strong>
														<p>Net State Value</p>
													</li>
													<li>
														<strong>OECD: </strong>
														<p>Organization for Economic Co-operation and Development</p>
													</li>
													<li>
														<strong>PAT:</strong>
														<p>Perform, Achieve and Trade</p>
													</li>
													<li>
														<strong>PNG:</strong>
														<p>Portable Network Graphics</p>
													</li>
													
													<li>
														<strong>PXIL:</strong>
														<p>Power Exchange India Limited</p>
													</li>
													<li>
														<strong>SAPCC:</strong>
														<p>State Action Plan on Climate Change</p>
													</li>
													<li>
														<strong>SDG:</strong>
														<p>Sustainable Development Goals</p>
													</li>
													<li>
														<strong>SEC:</strong>
														<p>Specific Energy Consumption</p>
													</li>
													<li>
														<strong>SEEP:</strong>
														<p>Super-Efficient Equipment Program</p>
													</li>
													<li>
														<strong>tCO2e:</strong>
														<p>Tonnes of CO2 equivalent</p>
													</li>
													<li>
														<strong>USD:</strong>
														<p>US Dollar</p>
													</li>
												</ol>

																<!-- <pre>
													1. AFOLU: Agriculture, Forestry and Other Land Use
													2. CEA: Central Electricity Authority
													3. CFLs: Compact Fluorescent Lamps
													4. CSO: Civil society organizations
													5.  Designated Consumers
													6. EEFP: Energy Efficiency Financing Platform
													7. ESCerts: Energy Saving Certificates
													8. FCRA: Foreign Contribution (Regulation) Act
													9. FCRA: The Foreign Contribution Act, 2010
													10. FEEED: Framework for Energy Efficient Economic Development
													11. FSI: Forest survey of India
													12. GDP: Gross Domestic Product
													13. GHG: Greenhouse Gas
													14. GSDP: Net State Domestic Product
													15. IEX: Indian Energy Exchange
													16. INR: Indian Rupee
													17. IPCC: Intergovernmental Panel on Climate Change
													18. IPPU: Industrial Processes and Product Use
													19. JPEG: Joint Photographic Experts Group
													20. M: Million
													21. Mm: Millimeter
													22. MNRE: Ministry of New and Renewable Energy
													23. NAPCC: The National Action Plan on Climate Change
													24. NGO: Non-governmental Organization
													25. NMEEE: National Mission for Enhanced Energy Efficiency
													26. NSDP: Net State Domestic Product
													27. NSV: Net State Value
													28. OECD: Organization for Economic Co-operation and Development
													29. PAT: Perform, Achieve and Trade
													30. PNG: Portable Network Graphics
													31. PRSF: Partial Risk Sharing Facility
													32. PXIL: Power Exchange India Limited
													33. SAPCC: State Action Plan on Climate Change
													34. SDG: Sustainable Development Goals
													35. SEC: Specific Energy Consumption
													36. SEEP: Super-Efficient Equipment Program
													37. tCO2e: Tonnes of CO2 equivalent
													38. USD: US Dollar

												</pre> -->
											</div>
										</div>
									</div>
									<div class="accordion-item">
										<h2 class=" accordion-header" id="State_heading">
											<button class="accordion-button collapsed" type="button"
												data-bs-toggle="collapse" data-bs-target="#State" aria-expanded="false"
												aria-controls="collapseTwo">
												<h4>State codes</h4>
											</button>
										</h2>
										<div id="State" class="accordion-collapse collapse"
											aria-labelledby="State_heading" data-bs-parent="#accordion_glossary">
											<div class="accordion-body">
												<ol>
													<li><strong>AN:</strong> Andaman and Nicobar</li>
													<li><strong>AP:</strong> Andhra Pradesh</li>
													<li><strong>AR:</strong> Arunachal Pradesh</li>
													<li><strong>AS:</strong> Assam</li>
													<li><strong>BR:</strong> Bihar</li>
													<li><strong>CH:</strong> Chandigarh</li>
													<li><strong>CT:</strong> Chhattisgarh</li>
													<li><strong>DD:</strong> Daman and Diu</li>
													<li><strong>DL:</strong> Delhi</li>
													<li><strong>GA:</strong> Goa</li>
													<li><strong>GJ:</strong> Gujarat</li>
													<li><strong>HP:</strong> Himachal Pradesh</li>
													<li><strong>HR:</strong> Haryana</li>
													<li><strong>JH:</strong> Jharkhand</li>
													<li><strong>JK:</strong> Jammu and Kashmir</li>
													<li><strong>KA:</strong> Karnataka</li>
													<li><strong>KL:</strong> Kerala</li>
													<li><strong>MH:</strong> Maharashtra</li>
													<li><strong>ML:</strong> Meghalaya</li>
													<li><strong>MN:</strong> Manipur</li>
													<li><strong>MP:</strong> Madhya Pradesh</li>
													<li><strong>MZ:</strong> Mizoram</li>
													<li><strong>NL:</strong> Nagaland</li>
													<li><strong>OR:</strong> Odisha</li>
													<li><strong>PB:</strong> Punjab</li>
													<li><strong>PY:</strong> Puducherry</li>
													<li><strong>RJ:</strong> Rajasthan</li>
													<li><strong>SK:</strong> Sikkim</li>
													<li><strong>TL:</strong> Telangana</li>
													<li><strong>TN:</strong> Tamil Nadu</li>
													<li><strong>TR:</strong> Tripura</li>
													<li><strong>UP:</strong> Uttar Pradesh</li>
													<li><strong>UT:</strong> Uttarakhand</li>
													<li><strong>WB:</strong> West Bengal</li>
													<li><strong>UP:</strong> Uttar Pradesh</li>
													<li><strong>UT:</strong> Uttarakhand</li>
													<li><strong>WB:</strong> West Bengal</li>
												</ol>
											</div>
										</div>
									</div>
									<div class="accordion-item">
										<h2 class=" accordion-header" id="Terminology_heading">
											<button class="accordion-button collapsed" type="button"
												data-bs-toggle="collapse" data-bs-target="#Terminology"
												aria-expanded="false" aria-controls="collapseTwo">
												<h4>Terminology</h4>
											</button>
										</h2>
										<div id="Terminology" class="accordion-collapse collapse"
											aria-labelledby="Terminology_heading" data-bs-parent="#accordion_glossary">
											<div class="accordion-body">
												<ol>
												<li>
													<strong>Average Maximum Temperature: </strong>
													<p>The average daily maximum air temperature, for each month and as an annual statistic, calculated over all years of record.</p>
												</li>
												<li>
													<strong>Average Minimum Temperature:</strong>
													<p>The lowest (by month and overall) maximum air temperature observed at the site. </p>
												</li>
												<li>
													<strong>Average Temperature: </strong>
													<p>The average temperature of the air as indicated by a properly exposed thermometer during a given time period, usually a day, month, or year.  </p>
												</li>
												<li>
													<strong>Common Equity: </strong>
													<p> The amount that all common shareholders have invested in an organization.</p>
												</li>
												<li>
													<strong>Core grant: </strong>
													<p> Flexible Financial support that provides an organization to build on a program or/and covers institutional support as well. </p>
												</li>
												<li>
													<strong>Expenditure:</strong>
													<p> Money spent from the budget of the state. </p>
												</li>
												<li>
													<strong>FCRA status: </strong>
													<p>FCRA stands for Foreign Contribution Regulation Act, and FCRA is a law of the government of India which regulates receipt of foreign contributions or aid from outside India to Indian territories. </p>
												</li>
												<li>
													<strong>Forest Cover: </strong>
													<p> Forest cover is the amount of land area that is covered by forest.</p>
												</li>
												<li>
													<strong>Funding source:</strong>
													<p>  Budgetary resources for programs and projects.</p>
												</li>
												<li>
													<strong>GHG emissions</strong>
													<p> Greenhouse gas is any gas that has the property of absorbing infrared radiation (net heat energy) emitted from Earth’s surface and reradiating it back to Earth’s surface, thus contributing to the greenhouse effect. Carbon dioxide, methane, and water vapor are the most important greenhouse gases. Emissions resulting from greenhouse gases are termed as Greenhouse gas emissions.</p>
												</li>
												<li>
													<strong>Grantee partner:  </strong>
													<p> Recipient of funding from the grantor to implement a program/project.</p>
												</li>
												<li>
													<strong>Gross State Domestic Product (GSDP):</strong>
													<p> The total value of goods produced and services provided in a state during one year.</p>
												</li>
												<li>
													<strong>Gross value Added (GVA):</strong>
													<p>  Economic productivity metric that measures the contribution of a corporate subsidiary, company, or municipality to an economy.</p>
												</li>
												<li>
													<strong>GSDP Growth Rate:</strong>
													<p>  Measures how fast the economy is growing.</p>
												</li>
												<li>
													<strong>Health Care Accessibility:</strong>
													<p>  Health care facilities accessible to population.</p>
												</li>
												<li>
													<strong>Human Development Index (HDI):</strong>
													<p> A statistic composite index of life expectancy, education, and per capita income indicators .</p>
												</li>
												<li>
													<strong>Key industry: </strong>
													<p>	An industry that is pivotal to the growth (or sometimes the survival) of an economy.</p>
												</li>

												<li>
													<strong>Land area: </strong>
													<p> Land area or non-forest area.</p>
												</li>
												<li>
													<strong> Literacy Rate: </strong>
													<p>Percentage of the population of a given age group that can read and write.</p>
												</li>
												<li>
													<strong> Net State Domestic Product:</strong>
													<p> Annual measure of the economic output of a nation that is adjusted to account for depreciation.</p>
												</li>
												<li>
													<strong>	Per capita income: </strong>
													<p> Per capita income is the income of each person in a population of a particular area.</p>
												</li>
												<li>
													<strong>Percent Contribution of Agriculture to GDP: </strong>
													<p> Agriculture's share in the GDP.</p>
												</li>
												<li>
													<strong>	Percent Contribution of Industry to GDP: </strong>
													<p> Industry's share in the GDP.</p>
												</li>
												<li>
													<strong>Percent Contribution of Service to GDP:  </strong>
													<p>Service sector's share in the GDP.</p>
												</li>
												<li>
													<strong>Percent Contribution to National Population: </strong>
													<p> State Population percentage with respect to India's population.</p>
												</li>
												<li>
													<strong> Population Density:</strong>
													<p> Number of people per unit of area.</p>
												</li>
												<li>
													<strong>Precipitation: </strong>
													<p> In meteorology, precipitation is any product of the condensation of atmospheric water vapor that falls under gravitational pull from clouds.</p>
												</li>
												<li>
													<strong> Programme consultancy:</strong>
													<p>Assignments shared with for-profits to deliver task/deliverable based on specific outcomes. </p>
											    </li>
												<li>
													<strong> Project grant:</strong>
													<p>  Collaboration with another civil society organization working for similar objectives to achieve project specific outcomes through a connected set of activities, where budgets are pre-defined. </p>
												</li>
												<li>
													<strong>Rural Population: </strong>
													<p> population in areas that have a lower population density than urban areas and are spread over a larger area out than urban centers.</p>
												</li>
												<li>
													<strong> SDG:</strong>
													<p> The 17 global goals for development for all countries established by the United Nations through a participatory process and elaborated in the 2030 Agenda for Sustainable Development, including ending poverty and hunger; ensuring health and well-being, education, gender equality, clean water and energy, and decent work; building and ensuring resilient and sustainable infrastructure, cities and consumption; reducing inequalities; protecting land and water ecosystems; promoting peace, justice and partnerships; and taking urgent action on climate change.
													</p>
												</li>
													<li>
													<strong>SDG Ranking:</strong>
													<p> 17 Sustainable Development Goals were adopted by the UN General Assembly
in September 2015 as a part of the 2030 Agenda for Sustainable Development. The Index for

Sustainable Development Goals (SDGs) evaluates progress of states and Union Territories
(UTs) on various parameters including health, education, gender, economic growth,
institutions, climate change and environment.
The SDG India Index scores range between 0–100, higher the score of a State/UT, the
greater the distance to target achieved. States and UTs are classified in four categories
based on their SDG India Index score — aspirant: 0–49; performer: 50–64; front-runner:
65–99, achiever: 100. Currently, there are no states in the aspirant and achiever category; 15
states/UTs are in the performer category and 22 states/UTs in the front runner category.</p>
												</li>
												<li>
													<strong>Sex Ratio: </strong>
													<p> Ratio of males to females in a population.</p>
												</li>
												<li>
													<strong>Standard grant:</strong>
													<p> A grant in which an organization agrees to provide a specific level of support
for a specified period of time with no statement of the organization’s intent to provide
additional future support without submission of another proposal.</p>
												</li>
												<li>
													<strong>State Budget: </strong>
													<p> State's plan of how to spend an amount of money over a particular period of time.</p>
												</li>
												<li>
													<strong>Topography:</strong>
													<p> The physical characteristics of an area of land, especially the position of its rivers, mountains, etc.</p>
												</li>
												<li>
													<strong>Total Population:</strong>
													<p> Total population of the country or state.</p>
												</li>
												<li>
													<strong>Urban Population:</strong>
													<p> Population inhabiting areas that have a greater population density than rural areas.</p>
												</li>
												<li>
												<strong>Water bodies:</strong>
												<p>Water bodies in the form of lakes, ponds, dams etc.</p>
												</li>
												</ol>

												<!--<pre>
                                            1.	Average Maximum Temperature: The average daily maximum air temperature, for each month and as an annual statistic, calculated over all years of record.
                                            2.	Average Minimum Temperature: The lowest (by month and overall) maximum air temperature observed at the site
                                            3.	Average Temperature: The average temperature of the air as indicated by a properly exposed thermometer during a given time period, usually a day, month, or year.
                                            4.	Core grant: Financial support that covers basic “core” organizational and administrative cost of an organization
                                            5.	Expenditure: Money spent from the budget of the state
                                            6.	FCRA status: FCRA stands for Foreign Contribution Regulation Act, and FCRA is a law of the government of India which regulates receipt of foreign contributions or aid from outside India to Indian territories.
                                            7.	Forest Cover: Forest cover is the amount of land area that is covered by forest.
                                            8.	Funding source: Budgetary resources for programs and projects.
                                            9.	GHG emissions: Greenhouse gas is any gas that has the property of absorbing infrared radiation (net heat energy) emitted from Earth’s surface and reradiating it back to Earth’s surface, thus contributing to the greenhouse effect. Carbon dioxide, methane, and water vapor are the most important greenhouse gases. Emissions resulting from greenhouse gases are termed as Greenhouse gas emissions.
                                            10.	Grantee partner: Recipient of funding from the grantor to implement a program/project
                                            11.	Gross State Domestic Product (GSDP): The total value of goods produced and services provided in a state during one year
                                            12.	Gross value Added (GVA): Economic productivity metric that measures the contribution of a corporate subsidiary, company, or municipality to an economy
                                            13.	GSDP Growth Rate: Measures how fast the economy is growing
                                            14.	Health Care Accessibility: Health care facilities accessible to population
                                            15.	Human Development Index (HDI): A statistic composite index of life expectancy, education, and per capita income indicators
                                            16.	Key industry: An industry that is pivotal to the growth (or sometimes the survival) of an economy
                                            17.	Land area: Land area or non-forest area
                                            18.	Literacy Rate: Percentage of the population of a given age group that can read and write
                                            19.	Net State Domestic Product: Annual measure of the economic output of a nation that is adjusted to account for depreciation
                                            20.	Per capita income: Per capita income is the income of each person in a population of a particular area.
                                            21.	Percent Contribution of Agriculture to GDP: Agriculture's share in the GDP
                                            22.	Percent Contribution of Industry to GDP: Industry's share in the GDP
                                            23.	Percent Contribution of Service to GDP: Service sector's share in the GDP
                                            24.	Percent Contribution to National Population: State Population percentage with respect to India's population
                                            25.	Population Density: Number of people per unit of area
                                            26.	Precipitation: In meteorology, precipitation is any product of the condensation of atmospheric water vapor that falls under gravitational pull from clouds.
                                            27.	Programme consultancy: Consultancy in planning, creation and administration of the programs in the particular area of the program
                                            28.	Common Equity: The amount that all common shareholders have invested in an organization.
                                            29.	Standard grant: A grant in which NSF agrees to provide a specific level of support for a specified period of time with no statement of NSF intent to provide additional future support without submission of another proposal.
                                            30.	Project grant: An amount given to support a specific, connected set of activities, with a beginning and an end, explicit objectives and a predetermined cost.
                                            31.	Rural Population: population in areas that have a lower population density than urban areas and are spread over a larger area out than urban centers
                                            32.	SDG Ranking: Sustainable development is the development that meets the needs of the present without compromising the ability of future generations to meet their own needs and balances social, economic and environmental concerns.
                                            33.	Sex Ratio: Ratio of males to females in a population
                                            34.	State Budget: State's plan of how to spend an amount of money over a particular period of time
                                            35.	SDG: The 17 global goals for development for all countries established by the United Nations through a participatory process and elaborated in the 2030 Agenda for Sustainable Development, including ending poverty and hunger; ensuring health and well-being, education, gender equality, clean water and energy, and decent work; building and ensuring resilient and sustainable infrastructure, cities and consumption; reducing inequalities; protecting land and water ecosystems; promoting peace, justice and partnerships; and taking urgent action on climate change.
                                            The NITI Aayog released the Baseline Report of the Sustainable Development Goals (SDG) India Index, which comprehensively documents the progress made by India’s States and Union Territories towards implementing the 2030 SDG targets.
                                            36.	Topography: The physical characteristics of an area of land, especially the position of its rivers, mountains, etc.
                                            37.	Total Population: Total population of the country or state
                                            38.	Urban Population: Population inhabiting areas that have a greater population density than rural areas
                                            39.	Water bodies: Water bodies in the form of lakes, ponds, dams etc.

                                            </pre> -->

											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="accordion-item">
						<h2 class="accordion-header" id="methodology_heading">
							<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
								data-bs-target="#methodology" aria-expanded="false" aria-controls="collapseTwo">
								<h4>Methodology</h4>
							</button>
						</h2>
						<div id="methodology" class="accordion-collapse collapse" aria-labelledby="methodology_heading"
							data-bs-parent="#accordion_about">
							<div class="accordion-body">
								<ol>
									<li>
										<strong>YoY % Growth of GDP vs GHG Emissions</strong>
										<p>The YoY % growth is calculated by calculating the percentage growth rate of
											the 2nd year from the first year. E.g., Growth rate for FY 2010 will be the
											growth rate from FY 2009.
											<br>Formula used: (Value in Current year minus value in Previous year)
											divided by value in previous year, the whole multiplied by 100.</p>
									</li>

									<li>
										<strong>Emissions Intensity per INR 1000 NSDP</strong>
										<p>State emissions divided by INR 1000 NSDP of the state.</p>
									</li>

									<li>
										<strong>Per Capita GHG Emissions</strong>
										<p>GHG emissions of the state divided by state population.</p>
									</li>

									<li>
										<strong>INR to US Dollar Conversion</strong>
										<p>Calculated by dividing the funding amount in INR by the exchange rate (INR to
											USD) for the corresponding funding year. Data are based on FEDAI (Foreign
											Exchange Dealers' Association of India) indicative rates till April 2012.
											RBI reference rates are used w.e.f. May 2012.
											<br>Source:
											<a class="one" href="https://rbidocs.rbi.org.in/rdocs/Publications/PDFs/140TE74E725980E74CB987BB87D52853686D.PDF"><strong>Link</strong></a>
										</p>
									</li>

									<li>
										<strong>Emissions Avoided in Power Sector</strong>
										<p>RE 2030 Scenario: As per CEA's Optimal Mix Report 2030, India is projected to
											have RE's installed capacity of 435 GW by FY 2030 [Solar: 280 GW, Wind: 140
											GW, Biomass & small Hydro: 15 GW]. A 'Mission 500GW' action plan is being
											drawn by the government to take forward the announcement made by Prime
											Minister Modi at the COP26 climate conference at Glasgow. As per the report,
											435 GW of RE corresponds to 800 BU of RE generated electricity in 2030 with
											an improvement in CUFs of RE technologies by 2030 (CUFs Solar: 22%, Wind:
											25.2 %, Small Hydro: 35%, Biomass: 35%). The RE generation in 2030 is then
											worked upon with current grid emission factor (0.79 tCO2/MWh) to arrive at
											the emissions avoided in 2030.
											<br><br>
											<i> Formula used: (Installed Capacity in 2030 x CUF in 2030 x 8760)/10^3
												Unit in GWh -> Electricity GenerationEmissions Calculation: Electricity
												generation x 0.79 (Current Grid emission factor in tCO2/MWh)
												<br>
												<br>
												<u>RE Potential Scenario: </u>
												<br>
												RE Potential is worked upon to arrive at RE generation with the improved
												CUF for RE technologies in 2030. The corresponding emissions avoided is
												estimated using current grid emission factor.
												<br>
												<i>Formula used: (Full potential installed Capacity in 2030 x CUF in
													2030 x 8760)/10^3 Unit in GWh -> Electricity Generation</i>
												<i>Emissions Calculation: Electricity generation x 0.79 (Current Grid
													emission factor in tCO2/MWh) .</i></p>
									</li>

									<li>
										<strong>Emissions avoided in electricity demand side</strong>
										<p>Emissions avoided are estimated from year-on-year State wise Energy Saving
											targets projected by CEA till 2027. The value is further extrapolated till
											2030 using CAGR method. The value for Energy saved is due to Demand side
											management, energy efficiency and conservation. The corresponding emissions
											are estimated using the current grid emission factor.
											<br>
											<i>Formula used:</i>
											<br>
											<i>Emissions Calculation: Electricity saved due to Demand side management x
												0.79 (Current Grid emission factor in tCO2/MWh). </i> </p>
									</li>
								</ol>




									<!--  <pre>
								1.	YoY % Growth of GDP vs GHG Emissions
								The YoY % growth is calculated by calculating the percentage growth rate of the 2nd year from the first year. E.g., Growth rate for FY 2010 will be the growth rate from FY 2009.
								Formula used: (Value in Current year minus value in Previous year) divided by value in previous year, the whole multiplied by 100.
								2.	Emissions Intensity per INR 1000 NSDP
								State emissions divided by INR 1000 NSDP of the state
								3.	Per Capita GHG Emissions
								GHG emissions of the state divided by state population
								4.	INR to US Dollar Conversion
								Calculated by dividing the funding amount in INR by the exchange rate (INR to USD) for the corresponding funding year. Data are based on FEDAI (Foreign Exchange Dealers' Association of India) indicative rates till April 2012. RBI reference rates are used w.e.f. May 2012. 
								Source: https://rbidocs.rbi.org.in/rdocs/Publications/PDFs/140TE74E725980E74CB987BB87D52853686D.PDF 
								5.	Emissions Avoided in Power Sector
								RE 2030 Scenario: 
								As per CEA's Optimal Mix Report 2030, India is projected to have RE's installed capacity of 435 GW by FY 2030 [Solar: 280 GW, Wind: 140 GW, Biomass & small Hydro: 15 GW]. A 'Mission 500GW' action plan is being drawn by the government to take forward the announcement made by Prime Minister Modi at the COP26 climate conference at Glasgow. As per the report, 435 GW of RE corresponds to 800 BU of RE generated electricity in 2030 with an improvement in CUFs of RE technologies by 2030 (CUFs Solar: 22%, Wind: 25.2 %, Small Hydro: 35%, Biomass: 35%). The RE generation in 2030 is then worked upon with current grid emission factor (0.79 tCO2/MWh) to arrive at the emissions avoided in 2030.
								Formula used: (Installed Capacity in 2030 x CUF in 2030 x 8760)/10^3 Unit in GWh  Electricity Generation
								Emissions Calculation: Electricity generation x 0.79 (Current Grid emission factor in tCO2/MWh) 
								RE Potential Scenario: 
								RE Potential is worked upon to arrive at RE generation with the improved CUF for RE technologies in 2030. The corresponding emissions avoided is estimated using current grid emission factor.
								Formula used: (Full potential installed Capacity in 2030 x CUF in 2030 x 8760)/10^3 Unit in GWh  Electricity Generation
								Emissions Calculation: Electricity generation x 0.79 (Current Grid emission factor in tCO2/MWh) 
								6.	Emissions avoided in electricity demand side
								Emissions avoided are estimated from year-on-year State wise Energy Saving targets projected by CEA till 2027. The value is further extrapolated till 2030 using CAGR method. The value for Energy saved is due to Demand side management, energy efficiency and conservation. The corresponding emissions are estimated using the current grid emission factor.
								Formula used: 
								Emissions Calculation: Electricity saved due to Demand side management x 0.79 (Current Grid emission factor in tCO2/MWh)

								</pre> -->
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="accordion-item">
				<h2 class="accordion-header" id="sources_heading">
					<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
						data-bs-target="#sources" aria-expanded="false" aria-controls="collapseTwo">
						<h4>Sources</h4>
					</button>
				</h2>
				<div id="sources" class="accordion-collapse collapse" aria-labelledby="sources_heading"
					data-bs-parent="#accordion_about">
					<div class="accordion-body">
						<div class="table-responsive mt-4">
							<table style="word-break:break-word;" class="table table-bordered">
								<thead>
									<tr>
										<th style="word-break:normal;">S.NO.</th>
										<th>INDICATOR</th>
										<th>DESCRIPTION</th>
										<th>LINK</th>
										<th>FREQUENCY OF UPDATION</th>
									</tr>
								</thead>
								<tbody>
									<tr>
										<th colspan="5">Homepage – Representation on map</th>
									</tr>
									<tr>
										<td>1.</td>
										<td>State-wise vulnerability to climate change</td>
										<td>Department of Science and Technology (2019). Climate Vulnerability
											Assessment for Adaptation Planning in India Using a Common Framework.</td>
										<td>https://dst.gov.in/sites/default/files/Full%20Report%20%281%29.pdf</td>
										<td>A one-time study on vulnerability was conducted by Department of Science and
											Technology in 2019. Further, updation plans have not been announced by
											DST.</td>
									</tr>
									<tr>
										<td>2.</td>
										<td>GHG emissions per capita</td>
										<td>GHG Platform (2005-2015) Emission Estimates</td>
										<td>http://www.ghgplatform-india.org/economy-wide </td>
										<td>Phase IV is in progress; data will be updated accordingly</td>
									</tr>
									<tr>
										<th colspan="5">Homepage – India profile</th>
									</tr>
									<tr>
										<td>3.</td>
										<td>Population</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Census of India is updated every 10 years. Census 2021 has been delayed,
											with preliminary results expected in 2023</td>
									</tr>
									<tr>
										<td>4.</td>
										<td>Urban Population</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Census of India is updated every 10 years. Census 2021 has been delayed,
											with preliminary results expected in 2023</td>
									</tr>
									<tr>
										<td>5.</td>
										<td>Rural Population</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Census of India is updated every 10 years. Census 2021 has been delayed,
											with preliminary results expected in 2023</td>
									</tr>
									<tr>
										<td>6.</td>
										<td>Percentage of rural population</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Census of India is updated every 10 years. Census 2021 has been delayed,
											with preliminary results expected in 2023</td>
									</tr>
									<tr>
										<td>7.</td>
										<td>Percentage of urban population</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Census of India is updated every 10 years. Census 2021 has been delayed,
											with preliminary results expected in 2023</td>
									</tr>
									<tr>
										<td>8.</td>
										<td>Gross Domestic Product (at constant prices - 2011-12)</td>
										<td>Ministry of Statistics and Programme Implementation (2021). National Account
											Statistics 2021</td>
										<td>https://mospi.gov.in/web/mospi/reports-publications/-/reports/view/templateFive/22001?q=RPCAT
										</td>
										<td>Yearly</td>
									</tr>
									<tr>
										<td>9.</td>
										<td>Per capita energy consumption</td>
										<td>Ministry of Statistics and Programme Implementation (2021). Energy
											Statistics 2021</td>
										<td>https://www.thehinducentre.com/resources/article35740193.ece/binary/Energy%20Statistics%20India%2020211_compressed.pdf
										</td>
										<td>Yearly</td>
									</tr>
									<tr>
										<td>10.</td>
										<td>GHG emissions (with LULUCF)</td>
										<td>*GHG Platform Phase III (2005-2015) Emission Estimates *India Third Biennial
											Update Report to the United Nations Framework Convention on Climate Change
										</td>
										<td>http://www.ghgplatform-india.org/economy-wide
											https://unfccc.int/sites/default/files/resource/INDIA_%20BUR-3_20.02.2021_High.pdf
										</td>
										<td>* Phase IV is in progress;data will be updated accordingly.<br>*Biennial Update Reports (BUR) areupdated every 2 years. India&#39;s third BUR was submitted in 2021. The fourth BUR should be released in 2023.</td>
									</tr>
									<tr>
										<td>11.</td>
										<td>GDP Growth Rate (At Constant Prices)</td>
										<td>Ministry of Statistics and Programme Implementation (2021). National Account
											Statistics 2021</td>
										<td>https://mospi.gov.in/web/mospi/reports-publications/-/reports/view/templateFive/22001?q=RPCAT
										</td>
										<td>Yearly</td>
									</tr>
									<tr>
										<td>12.</td>
										<td>GHG Growth Rate</td>
										<td>GHG Platform Phase III (2005-2015) Emission Estimates</td>
										<td>Calculated by YoY % growth rate of GHG emissions</td>
										<td>Phase IV is in progress;data will be updated accordingly</td>
									</tr>
									<tr>
										<th colspan="5">Homepage - Sectoral GHG Share</th>
									</tr>
									<tr>
										<td>13.</td>
										<td>Sectoral Contribution to GHG Emissions</td>
										<td>GHG Platform India</td>
										<td>http://www.ghgplatform-india.org/economy-wide </td>
										<td>Phase IV is in progress; data will be updated accordingly</td>
									</tr>
									<tr>
										<th colspan="5">Homepage – State data on map</th>
									</tr>
									<tr>
										<td>14.</td>
										<td>Population (2011)</td>
										<td>Reserve Bank of India- Handbook on Statistics 2021</td>
										<td>https://rbi.org.in/Scripts/AnnualPublications.aspx%3Fhead%3DHandbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>As per Census of India (Census of India is updated every 10 years. Census
											2021 has been delayed, with preliminary results expected in 2023.)</td>
									</tr>
									<tr>
										<td>15.</td>
										<td>Net State Domestic Product (2020-21) (at Constant Prices) (INR)</td>
										<td>Reserve Bank of India- Handbook on Statistics 2021</td>
										<td>https://rbi.org.in/Scripts/AnnualPublications.aspx%3Fhead%3DHandbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Annually</td>
									</tr>
									<tr>
										<td>16.</td>
										<td>Per Capita Electricity Consumption (2019) (kWh)</td>
										<td>Central Electricity Authority</td>
										<td>https://cea.nic.in/?lang=en </td>
										<td>Yearly (Published by Central Electricity Authority)</td>
									</tr>
									<tr>
										<th colspan="5">State page – Socio-economic data</th>
									</tr>
									<tr>
										<td>17.</td>
										<td>Forest area</td>
										<td>India State of Forest Report 2021</td>
										<td>https://fsi.nic.in/isfr-2021/chapter-2.pdf </td>
										<td>Biennial(The next edition of the State of Forest Report will be published in
											2023)</td>
									</tr>
									<tr>
										<td>18.</td>
										<td>Number of factories</td>
										<td>Number of factories Ministry of Statistics and Programme Implementation</td>
										<td>https://mospi.gov.in/web/mospi/reports-publications/-/reports/view/templateTwo/25501?q=RPCAT
										</td>
										<td>While the frequency of updation should be annual, Survey of Industries has
											not been conducted after 2018-19</td>
									</tr>
									<tr>
										<td>19.</td>
										<td>Key industries in the state</td>
										<td>Assam</td>
										<td>https://des.assam.gov.in/information-services/economic-survey-assam</td>
										<td>NA</td>
									</tr>
									<tr>
										<td></td>
										<td></td>
										<td>Bihar</td>
										<td>https://state.bihar.gov.in/finance/CitizenHome.html</td>
										<td></td>
									</tr>
									<tr>
										<td></td>
										<td></td>
										<td>Jharkhand</td>
										<td>https://finance.jharkhand.gov.in/pdf/Economic_Survey_2020_21/Jharkhand_Economic_Survey_2020_21.pdf
										</td>
										<td></td>
									</tr>
									<tr>
										<td></td>
										<td></td>
										<td>Karnataka</td>
										<td>https://www.karnataka.gov.in/info-1/Publications/Economic+Survey/en </td>
										<td></td>
									</tr>
									<tr>
										<td></td>
										<td></td>
										<td>Maharashtra</td>
										<td>http://mls.org.in/pdf2021/budget/budgetpdf/ESM_2020_21_Eng_Book.pdf </td>
										<td></td>
									</tr>
									<tr>
										<td></td>
										<td></td>
										<td>Odisha</td>
										<td>https://finance.odisha.gov.in/sites/default/files/2021-02/Odisha_Economic_Survey_2020_21.pdf
										</td>
										<td></td>
									</tr>
									<tr>
										<td></td>
										<td></td>
										<td>Rajasthan</td>
										<td>https://statistics.rajasthan.gov.in/content/dam/planning-portal/Directorate%20of%20Economics%20and%20Statistics/Publication/Regular%20Publications/economic%20review%20english/Economic_Review_English_2020-21.pdf
										</td>
										<td></td>
									</tr>
									<tr>
										<td></td>
										<td></td>
										<td>Tamil Nadu</td>
										<td>https://www.tn.gov.in/dear/State%20of%20the%20Economy.pdf </td>
										<td></td>
									</tr>
									<tr>
										<td>20.</td>
										<td>Total Population</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>As per Census of India (Census of India is updated every 10 years. Census
											2021 has been delayed, with preliminary results expected in 2023.)</td>
									</tr>
									<tr>
										<td>21.</td>
										<td>% Contribution to National Population</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>As per Census of India (Census of India is updated every 10 years. Census
											2021 has been delayed, with preliminary results expected in 2023.)</td>
									</tr>
									<tr>
										<td>22.</td>
										<td>Urban Population</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>As per Census of India (Census of India is updated every 10 years. Census
											2021 has been delayed, with preliminary results expected in 2023.)</td>
									</tr>

									<tr>
										<td>23.</td>
										<td>Rural population</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>As per Census of India (Census of India is updated every 10 years. Census
											2021 has been delayed, with preliminary results expected in 2023.)</td>
									</tr>
									<tr>
										<td>24.</td>
										<td>Population density(Persons per sq. km.)</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>As per Census of India (Census of India is updated every 10 years. Census
											2021 has been delayed, with preliminary results expected in 2023.) </td>
									</tr>
									<tr>
										<td>25.</td>
										<td>Literacy rate (%)</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>As per Census of India (Census of India is updated every 10 years. Census
											2021 has been delayed, with preliminary results expected in 2023.)</td>
									</tr>
									<tr>
										<td>26.</td>
										<td>Total physicians, nurses and midwives per 10,000 population (Number)</td>
										<td>NITI Ayog</td>
										<td>https://www.niti.gov.in/writereaddata/files/SDG_3.0_Final_04.03.2021_Web_Spreads.pdf
										</td>
										<td>Yearly</td>
									</tr>
									<tr>
										<td>27.</td>
										<td>Gross State Domestic Product (at constant prices) (INR)</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Yearly</td>
									</tr>
									<tr>
										<td>28.</td>
										<td>Net State Domestic Product (at constant prices) (INR)</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Yearly</td>
									</tr>
									<tr>
										<td>29.</td>
										<td>Per capita income (Per capita net state domestic product) (at constant
											prices) (INR)</td>
										<td>Reserve Bank of India (2021). Handbook of Statistics on Indian States
											2020-21</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Yearly</td>
									</tr>
									<tr>
										<td>30.</td>
										<td>Net State Value by economic activity - Agriculture (at constant prices)
											(INR)</td>
										<td>Reserve Bank of India (2021)</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Yearly</td>
									</tr>
									<tr>
										<td>31.</td>
										<td>Net State Value by economicactivity - Manufacturing (at constant
											prices)(INR)</td>
										<td>Reserve Bank of India (2021)</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Yearly</td>
									</tr>
									<tr>
										<td>32.</td>
										<td>Net State Value by economic activity - Construction (at constant prices)
											(INR)</td>
										<td>Reserve Bank of India (2021)</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Yearly</td>
									</tr>
									<tr>
										<td>33.</td>
										<td>Net State Value by economic activity - Industry (At constant prices) (INR)
										</td>
										<td>Reserve Bank of India (2021)</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Yearly</td>
									</tr>
									<tr>
										<td>34.</td>
										<td>Net State Value by economic activity - Services (At constant prices) (INR)
										</td>
										<td>Reserve Bank of India (2021</td>
										<td>https://m.rbi.org.in/scripts/AnnualPublications.aspx?head=Handbook%20of%20Statistics%20on%20Indian%20States
										</td>
										<td>Yearly</td>
									</tr>
									<tr>
										<th colspan="5">States page – Climate profile</th>
									</tr>
									<tr>
										<td>35.</td>
										<td>Annual rainfall (mm)</td>
										<td>Indian Meteorological Department</td>
										<td>https://mausam.imd.gov.in/ </td>
										<td>Yearly</td>
									</tr>
									<tr>
										<td>36.</td>
										<td>GHG emissions per capita (tCO2e per capita)</td>
										<td>GHG Platform India</td>
										<td>www.ghgplatform india.org </td>
										<td>Phase IV is in progress; data will be updated accordingly</td>
									</tr>
									<tr>
										<td>37.</td>
										<td>Sector wise GHG emissions</td>
										<td>GHG Platform India</td>
										<td>www.ghgplatform india.org </td>
										<td>Phase IV is in progress;data will be updated accordingly</td>
									</tr>
									<tr>
										<td>38.</td>
										<td>Percentage of renewable energy out of total installed generating capacity
											(MW)</td>
										<td>Central Electricity Authority</td>
										<td>https://cea.nic.in/dashboard/?lang=en </td>
										<td>Monthly</td>
									</tr>
									<tr>
										<td>39.</td>
										<td>SDG 13 score</td>
										<td>NITI Aayog</td>
										<td>https://www.niti.gov.in/writereaddata/files/SDG_3.0_Final_04.03.2021_Web_Spreads.pdf
										</td>
										<td>Yearly</td>
									</tr>
									<tr>
										<th colspan="5">States page – Sectoral GHG share</th>
									</tr>
									<tr>
										<td>40.</td>
										<td>Sectoral Contribution to GHG emissions</td>
										<td>GHG Platform India</td>
										<td>http://www.ghgplatform-india.org/economy-wide </td>
										<td>Phase IV is in progress; data will be updated accordingly </td>
                                       
									</tr>
									<tr>
										<th colspan="5">Funding landscape</th>
									</tr>
									<tr>
										<td>41.</td>
										<td>All other KPIs</td>
										<td>Shakti Foundation data</td>
										<td>Shakti Sustainable Energy Foundation (Shakti)</td>
										<td>NA</td>
									</tr>

									<tr>
										<td>42.</td>
										<td>Grantee partner FCRA status</td>
										<td>Ministry of Home Affairs – Portal of FCRA Services</td>
										<td>https://fcraonline.nic.in/fc8_statewise.aspx </td>
										<td>Yearly</td>
									</tr>
									<tr>
										<td>43.</td>
										<td>All KPIs on OECD Funding</td>
										<td>OECD Funding</td>
										<td>https://stats.oecd.org/Index.aspx?DataSetCode=DV_DCD_PPFD </td>
										<td>Yearly</td>
									</tr>
									<tr>
										<th colspan="5">CSR</th>
									</tr>
									<tr>
										<td>44.</td>
										<td>Corporate Social Responsibility (CSR)</td>
										<td>National CSR Portal</td>
										<td>https://www.csr.gov.in/content/csr/global/master/home/home.html</td>
										<td>Frequently</td>
									</tr>
									<tr>
										<th colspan="5">Policy framework</th>
									</tr>
									<tr>
										<td>45.</td>
										<td>Sector-wise policy framework</td>
										<td>-</td>
										<td>Websites of National and state governments </td>
										<td>NA</td>
									</tr>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- Main Body Content End -->



	<!-- ABOUT US AREA START -->

	<div class="ltn__about-us-area pt-0 pb-40 ">
		<div class="container">
			<div class="row">
				<div class="col-lg-12">
					<div class="about-us-info-wrap">
						<div class="section-title-area ltn__section-title-2--- mb-20">
							<!-- <h1 class="section-title">Terms and Conditions</h1>-->
							<p class="text-justify"></p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php include('include/footer.php');?>
</body>
</html>