/**
 * Menu Engine 1.0.2 (https://codings.dev)
 * Copyright 2022-2023 Codings
 * 
 */

// Display the dropdown
function show_menu(everyitem) {
	let el_link = everyitem.querySelector('a[data-bs-toggle]');
	let el_btn = everyitem.querySelector('.btn[data-bs-toggle]');
	
	if (el_btn) { el_link = el_btn; }

	if (el_link != null) {
		let nextEl = el_link.nextElementSibling;

		if (nextEl.classList.contains('dropdown-menu')) {
			el_link.classList.add('show');
 			nextEl.classList.add('show');
		}
	}
}

// Hide the dropdown
function hide_menu(everyitem) {
	let el_link = everyitem.querySelector('a[data-bs-toggle]');
	let el_btn = everyitem.querySelector('.btn[data-bs-toggle]');
	
	if (el_btn) { el_link = el_btn; }
	
	if (el_link != null) {
		let nextEl = el_link.nextElementSibling;
		
		if (nextEl.classList.contains('dropdown-menu')) {
			el_link.classList.remove('show');
 			nextEl.classList.remove('show');
		}	
	}
}

// Enable dark screen element
function darken_activate() {
	el_overlay = document.createElement('span');
	el_overlay.className = 'screen-darken active';
	document.body.appendChild(el_overlay);
}

// Remove dark screen element
function darken_remove() {
	el_overlay = document.querySelector('.screen-darken');
	el_overlay.classList.remove('active');
	// document.body.removeChild(document.querySelector('.screen-darken'));
}

// Toggles the display of the next element
function toggle_next_el(nextEl) {
	if (nextEl.style.display == 'contents') {
		nextEl.style.display = 'none';
		
	} else {
		nextEl.style.display = 'contents';
	}
}

/**
 * Performs actions necessary for the general functioning of the navbar
 */
document.addEventListener('DOMContentLoaded', function() {

	// Build classes for the navbar when scrolling the page
	el_navbar = document.querySelector('.navbar.smart-scroll, .navbar.fixed-scroll');

	if (el_navbar) {
		var last_scroll_top = 0;

		window.addEventListener('scroll', function() {
			
			if (window.scrollY > 100) {
				el_navbar.classList.add('navbar-sticky');
		
			} else {
				el_navbar.classList.remove('navbar-sticky');
			} 

			if ( window.scrollY > 0 ) {

				if (window.scrollY < last_scroll_top) {
					el_navbar.classList.remove('scrolled-down');
					el_navbar.classList.add('scrolled-up');

				} else {
					el_navbar.classList.remove('scrolled-up');
					el_navbar.classList.add('scrolled-down');
				}

				last_scroll_top = window.scrollY;

			} else {
				el_navbar.classList.remove('scrolled-up', 'scrolled-down');
			}
		}) 
	}	
      
	// Prevent closing from click inside dropdown
	document.querySelectorAll('.dropdown-menu').forEach(function(element) {
		element.addEventListener('click', function (e) {
		  e.stopPropagation();
		})
	})

	/**
	 * Function only performed on larger screens
	 */
  if (window.innerWidth > 991) {
    
    // Dropdown hover
		document.querySelectorAll('.dropdown').forEach(function(everyitem) {
			everyitem.addEventListener('mouseenter', function() {
				if (everyitem.classList.contains('hover')) {
					show_menu(everyitem);
				}
				if (everyitem.classList.contains('hover') && everyitem.classList.contains('darken-on-show')) {
					darken_activate();
				}
			})
			everyitem.addEventListener('mouseleave', function() {
				if (everyitem.classList.contains('hover')) {
					hide_menu(everyitem);
				}
				if (everyitem.classList.contains('hover') && document.querySelector('.screen-darken')) {
					darken_remove();
				}
			})
		})

		// Dropdown click
	  document.querySelectorAll('.dropdown').forEach(function(everydropdown) {
			everydropdown.addEventListener('shown.bs.dropdown', function() {
				if (everydropdown.classList.contains('darken-on-show')) {
					darken_activate();
				}
			})
			everydropdown.addEventListener('hide.bs.dropdown', function() {
				if (document.querySelector('.screen-darken')) {
					darken_remove();
				}
			})
		})	
  }

	/**
	 * Function only performed on smaller screens
	 */
	if (window.innerWidth < 991) {

		// Close all inner dropdowns when parent is closed
		document.querySelectorAll('.dropdown').forEach(function(everydropdown) {
			everydropdown.addEventListener('hidden.bs.dropdown', function() {
				this.querySelectorAll('.megasubmenu, .submenu').forEach(function(everysubmenu) {
					everysubmenu.style.display = 'none';
				})
			})
		})

		// Adaptation of the dropdown in responsive mode
		document.querySelectorAll('.dropdown-menu a').forEach(function(element) {
			element.addEventListener('click', function (e) {
				let nextEl = this.nextElementSibling;
				if (nextEl && nextEl.classList.contains('submenu')) {	
					e.preventDefault();
					toggle_next_el(nextEl);
				}
			})
		})

		// Adaptation of the megamenu in responsive mode
		document.querySelectorAll('.has-megasubmenu > a').forEach(function(element) {			
			element.addEventListener('click', function (e) {
				let nextEl = this.nextElementSibling;
				if (nextEl && nextEl.classList.contains('megasubmenu')) {
					e.preventDefault();	
					toggle_next_el(nextEl);
				}
			})
		})
	}
})

/**
 * Changes the side of the dropdown if it is stacked on the right side.
 */
jQuery(function($) {
  'use strict';

  var screen_width = window.innerWidth;

  $('.dropdown-menu.submenu').each(function() {
    let offset_left = $(this).offset().left;

    if ( screen_width - offset_left <= 200 ) {
      $(this).addClass('submenu-left');

    } else {
      $(this).removeClass('submenu-left');
    }
  })
})

/**
 * Adjust language switcher layout when triggered.
 */
jQuery(function($) {
  'use strict';

  if ( $(window).width() < 991 ) {
    var menu_item = $('.language-switcher > .nav-item');
    var menu_item_height = $('.language-switcher > .nav-item .dropdown-menu').outerHeight();
		var margin_top = 'calc( -' + menu_item_height + 'px - 0.5rem )';

    menu_item.on('show.bs.dropdown', function() {
      $('.navbar-bottom-wrapper').css('margin-top', margin_top);
    })
    
    menu_item.on('hide.bs.dropdown', function() {
      $('.navbar-bottom-wrapper').css('margin-top', '');
    })
  }
})

/**
 * Adjust navbar positioning when offcanvas is triggered.
 */
jQuery(function($) {
	'use strict';

	if ( $(window).width() > 400 ) {

		var navbar = $('.navbar');
		var offcanvas = $('.offcanvas');

		if ( navbar.hasClass('smart-scroll') || navbar.hasClass('fixed-scroll') ) {

			offcanvas.on('show.bs.offcanvas', function() {
				$('.navbar .container').css('position', 'relative');
				$('.navbar .container').css('right', '8.5px');
			})

			offcanvas.on('hidden.bs.offcanvas', function() {
				$('.navbar .container').css('position', '');
				$('.navbar .container').css('right', '');
			})
		}
	}
})